/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class LabelFieldLayout
implements LayoutManager {
    protected int m_divider = -1;
    protected int m_hGap = 10;
    protected int m_vGap = 5;

    public LabelFieldLayout() {
    }

    public LabelFieldLayout(int n, int n2) {
        this.m_hGap = n;
        this.m_vGap = n2;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public int getDivider() {
        return this.m_divider;
    }

    protected int getDivider(Container container) {
        if (this.m_divider > 0) {
            return this.m_divider;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < container.getComponentCount()) {
            Component component = container.getComponent(n2);
            Dimension dimension = component.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 += 2;
        }
        return n += this.m_hGap;
    }

    public int getHGap() {
        return this.m_hGap;
    }

    public int getVGap() {
        return this.m_vGap;
    }

    public void layoutContainer(Container container) {
        int n = this.getDivider(container);
        Insets insets = container.getInsets();
        int n2 = container.getWidth() - insets.left - insets.right - n;
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = 1;
        while (n5 < container.getComponentCount()) {
            Component component = container.getComponent(n5 - 1);
            Component component2 = container.getComponent(n5);
            Dimension dimension = component2.getPreferredSize();
            component.setBounds(n3, n4, n - this.m_hGap, dimension.height);
            component2.setBounds(n3 + n, n4, n2, dimension.height);
            n4 += dimension.height + this.m_vGap;
            n5 += 2;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        int n = this.getDivider(container);
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        while (n4 < container.getComponentCount()) {
            serializable = container.getComponent(n4);
            Dimension dimension = serializable.getPreferredSize();
            n2 = Math.max(n2, dimension.width);
            n3 += dimension.height + this.m_vGap;
            n4 += 2;
        }
        serializable = container.getInsets();
        return new Dimension(n + n2 + ((Insets)serializable).left + ((Insets)serializable).right, (n3 -= this.m_vGap) + ((Insets)serializable).top + ((Insets)serializable).bottom);
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setDivider(int n) {
        if (n > 0) {
            this.m_divider = n;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hGap=" + this.m_hGap + ",vGap=" + this.m_vGap + ",divider=" + this.m_divider + "]";
    }
}

