/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.external.DistInfo;
import com.cisco.cpnm.boot.internal.BootDebug;
import com.cisco.cpnm.boot.internal.Package;
import com.cisco.cpnm.boot.internal.VersionFile;
import com.cisco.cpnm.boot.internal.VersionXml;
import com.cisco.cpnm.boot.internal.util.VersionNumber;
import com.cisco.cpnm.boot.internal.xmllite.CharString;
import com.cisco.cpnm.boot.internal.xmllite.Handler;
import com.cisco.cpnm.boot.internal.xmllite.ParseException;
import com.cisco.cpnm.boot.internal.xmllite.Parser;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

class Distribution
implements Handler,
VersionXml,
DistInfo,
BootDebug {
    private VersionFile container;
    private String name;
    private String description;
    private String whatsNew = null;
    private Date date;
    private static SimpleDateFormat format = new SimpleDateFormat();
    private VersionNumber jreVer;
    private int majVer;
    private int count;
    private List packages;
    private int numLatest;
    private CharString currElem;
    private boolean local = false;
    private boolean waitingOnIgnoredData = false;

    Distribution(VersionFile container) {
        this.container = container;
        this.packages = new ArrayList();
    }

    URL getFilesystem() {
        return this.container.getFilesystem();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getWhatsNew() {
        return this.whatsNew;
    }

    public String getSource() {
        return this.getFilesystem().toString();
    }

    public Date getBuildDate() {
        return this.date;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean v) {
        this.local = v;
    }

    List getPackages() {
        return this.packages;
    }

    public int getMajorVersion() {
        return this.majVer;
    }

    boolean isContributing() {
        return this.numLatest > 0;
    }

    void updateNumLatest(boolean isLatest) {
        this.numLatest = isLatest ? ++this.numLatest : --this.numLatest;
        this.container.updateNumLatest(isLatest);
    }

    public String toString() {
        return this.name;
    }

    public void startDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected start-of-document");
    }

    public CharString startElement(Parser parser, CharString element) throws ParseException {
        this.currElem = null;
        String myelement = element.toString();
        if (element.equals(VersionXml.NAME)) {
            this.currElem = VersionXml.NAME;
        } else if (element.equals(VersionXml.DESCRIPTION)) {
            this.currElem = VersionXml.DESCRIPTION;
        } else if (element.equals(VersionXml.WHATS_NEW)) {
            this.waitingOnIgnoredData = true;
        } else if (element.equals(VersionXml.DATE)) {
            this.currElem = VersionXml.DATE;
        } else if (element.equals(VersionXml.MINIMUM_JRE)) {
            this.currElem = VersionXml.MINIMUM_JRE;
        } else if (element.equals(VersionXml.MAJOR_VERSION)) {
            this.currElem = VersionXml.MAJOR_VERSION;
        } else if (element.equals(VersionXml.COUNT)) {
            this.currElem = VersionXml.COUNT;
        } else if (element.equals(VersionXml.PACKAGE)) {
            this.currElem = VersionXml.PACKAGE;
            Package pkg = new Package(this);
            this.packages.add(pkg);
            parser.pushHandler(pkg);
        }
        return this.currElem;
    }

    public void elementData(Parser parser, CharString data) throws ParseException {
        if (this.currElem == VersionXml.NAME) {
            this.name = data.toString();
        } else if (this.currElem == VersionXml.DESCRIPTION) {
            this.description = data.toString();
        } else if (this.currElem == VersionXml.COUNT) {
            this.count = data.toInt();
        } else if (this.currElem == VersionXml.DATE) {
            try {
                this.date = format.parse(data.toString());
            }
            catch (java.text.ParseException ex) {
                this.date = null;
            }
        } else if (this.currElem == VersionXml.MINIMUM_JRE) {
            this.jreVer = new VersionNumber(data.toString());
        } else if (this.currElem == VersionXml.MAJOR_VERSION) {
            this.majVer = data.toInt();
        }
    }

    public void ignoredData(Parser parser, CharString data) throws ParseException {
        if (this.waitingOnIgnoredData) {
            this.waitingOnIgnoredData = false;
            this.whatsNew = data.toString();
        }
    }

    public void endElement(Parser parser, CharString element) throws ParseException {
        if (element.equals(VersionXml.DISTRIBUTION)) {
            parser.popHandler();
        }
    }

    public void endDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected end-of-document");
    }

    public void outputVersionFile(PrintWriter out) {
        this.outputPrologue(out);
        Iterator it = this.packages.iterator();
        while (it.hasNext()) {
            Package pkg = (Package)it.next();
            pkg.outputVersionFile(out);
        }
        this.outputEpilogue(out);
    }

    private void outputPrologue(PrintWriter out) {
        out.print(" <");
        out.print(VersionXml.DISTRIBUTION);
        out.println(">");
        out.print("  <");
        out.print(VersionXml.NAME);
        out.print(">");
        out.print(this.name);
        out.print("</");
        out.print(VersionXml.NAME);
        out.println(">");
        out.print("  <");
        out.print(VersionXml.MINIMUM_JRE);
        out.print(">");
        out.print(this.jreVer);
        out.print("</");
        out.print(VersionXml.MINIMUM_JRE);
        out.println(">");
        out.print("  <");
        out.print(VersionXml.MAJOR_VERSION);
        out.print(">");
        out.print(this.majVer);
        out.print("</");
        out.print(VersionXml.MAJOR_VERSION);
        out.println(">");
        out.print("  <");
        out.print(VersionXml.DESCRIPTION);
        out.print(">");
        out.print(this.description);
        out.print("</");
        out.print(VersionXml.DESCRIPTION);
        out.println(">");
        out.print("  <");
        out.print(VersionXml.DATE);
        out.print(">");
        out.print(format.format(this.date));
        out.print("</");
        out.print(VersionXml.DATE);
        out.println(">");
        out.print("  <");
        out.print(VersionXml.COUNT);
        out.print(">");
        out.print(this.count);
        out.print("</");
        out.print(VersionXml.COUNT);
        out.println(">");
        if (this.whatsNew != null) {
            out.print("  <");
            out.print(VersionXml.WHATS_NEW);
            out.print(">");
            out.print(this.whatsNew);
            out.print("</");
            out.print(VersionXml.WHATS_NEW);
            out.println(">");
        }
    }

    private void outputEpilogue(PrintWriter out) {
        out.print(" </");
        out.print(VersionXml.DISTRIBUTION);
        out.println(">");
    }
}

