<!-- Copyright (c) 2004 by Cisco Systems, Inc. -->
// discover.js for c2955 devices.

// c2955 models.
// WS-C2955C-12, WS-C2955S-12, WS-C2955T-12

function WS_C2955C_12(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 14;
	dev.x=106;
	dev.y=0;
	dev.width = 448;
	dev.height = 196;
	dev.image = "images/c2955c12.gif";
	dev.scrollYCord = 57;

	// Add the Leds
	addCommonLEDs(dev);

	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var fxPortImages = top.fxportImages();
	var xPortGap = 5;
	var xPortGroupGap = 30;
	var xPortStartPos = 254;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 106;

	// Add the 12 FastEthernet ports.
	for(i=0; i<12; i++) {       
		if(i%2 == 0) {
			yPortCoord = 106;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 124;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 FX Port
	xPortCoord = 245;
	yPortCoord = 60;		
	xPortGap = 9;
	for(i=12; i<14; i++) {       
		port = new top.fxport(fxPortImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	return dev;
}

function WS_C2955S_12(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 14;
	dev.x=106;
	dev.y=0;
	dev.width = 448;
	dev.height = 196;
	dev.image = "images/c2955s12.gif";
	dev.scrollYCord = 57;

	// Add the Leds
	addCommonLEDs(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var fxPortImages = top.fxportImages();
	var xPortGap = 5;
	var xPortGroupGap = 30;
	var xPortStartPos = 254;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 106;

	// Add the 12 FastEthernet ports.
	for(i=0; i<12; i++) {       
		if(i%2 == 0) {
			yPortCoord = 106;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 124;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 FX Port
	xPortCoord = 245;
	yPortCoord = 60;		
	xPortGap = 9;
	for(i=12; i<14; i++) {       
		port = new top.fxport(fxPortImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	return dev;
}

function WS_C2955T_12(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 14;
	dev.x=106;
	dev.y=0;
	dev.width = 448;
	dev.height = 196;
	dev.image = "images/c2955t12.gif";
	dev.scrollYCord = 57;

	// Add the Leds
	addCommonLEDs(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 5;
	var xPortGroupGap = 30;
	var xPortStartPos = 254;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 106;

	// Add the 12 FastEthernet ports.
	for(i=0; i<12; i++) {       
		if(i%2 == 0) {
			yPortCoord = 106;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 124;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 Gig ports
	xPortCoord = 245;
	yPortCoord = 60;		
	xPortGap = 9;
	for(i=12; i<14; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	return dev;
}

function addCommonLEDs(dev) {
	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 333;
	tempLed.y = 185;
	tempLed.id = "relay_maj";
	tempLed.device = dev;
	dev.sysleds["RELAY_MAJ"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 356;
	tempLed.y = 185;
	tempLed.id = "relay_min";
	tempLed.device = dev;
	dev.sysleds["RELAY_MIN"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 380;
	tempLed.y = 185;
	tempLed.id = "power_a";
	tempLed.device = dev;
	dev.sysleds["POWER_A"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 404;
	tempLed.y = 185;
	tempLed.id = "power_b";
	tempLed.device = dev;
	dev.sysleds["POWER_B"] = tempLed;
}

function createDevice(int_status, media_type, deviceType) {
	
	var device = null;
	if(deviceType == null)
		return device;	
	if(deviceType == "WS-C2955C-12") {
		device = new WS_C2955C_12(int_status, media_type);
	} else if(deviceType == "WS-C2955S-12") {
		device = new WS_C2955S_12(int_status, media_type);
	} else if(deviceType == "WS-C2955T-12") {
		device = new WS_C2955T_12(int_status, media_type);
	}

	if(device != null) {
		device.type = deviceType;
		device.family = "2955";
	}

	return device;
}
