<!-- Copyright (c) 2005 by Cisco Systems, Inc. -->
// discover.js - Will discover 2960 devices.
// Support added for WS-C2960-48TC-L, WS-C2960-24TC-L, WS-C2960G-24TC-L, WS-C2960-48TT-L, WS-C2960-24TT-L and WS-C2960G-48TC-L devices
//Support added for WS-C2960-24PC-S,WS-C2960-24LC-S and WS-C2960-48PST-S devices
/*Added Support for Sake Choya and Junmai SKUs
	Choya8Power   WS-C2960CPD-8PT-L
	Choya8        WS-C2960CPD-8TT-L 
	Junmmai8      WS-C2960CG-8TC-L.
*/
/*Added Support for Dortmunder
WS-C2960+48PST-L, WS-C2960P-24PC-L, WS-C2960P-24LC-L, WS-C2960P-48TC-L, WS-C2960P-24TC-L,WS-C2960P-48PST-S
WS-C2960P-24PC-S, WS-C2960P-24LC-S,WS-C2960P-48TC-S,WS-C2960P-24TC-S
*/
//////////////////////////////////////////////////////////////////////////////////////////////

function WSC296044_4_composite(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 48;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2960_44_4_composite.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 68;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 44 FastEthernet ports in 2 groups of 16 each and 1 group of 14 ports.
	for(i=0; i<44; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==15 || i == 31 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 4 Composite ports.
	xPortCoord = 532;
	xPortGap = 13;
	yPortCoord = 35;
	for(i=44; i<48; i++) 
	{       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;
        port.height = 33;
		port.sfpx = 0;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 19;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += 32;
	}
	return dev;
}


function WSC296048_2_composite(int_status, media_type, deviceType) 
{
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	if(deviceType == "WS-C2960+48TC-L")
	{
	dev.image = "images/c2960_48_2_compositeFE.gif";	
	}
	else
	{
	dev.image = "images/c2960_48_2_composite.gif";	
    }
	// Construct the mode button and the system LEDs
	constructModeSysleds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 68;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 Composite ports.
	xPortCoord = 588;
	xPortGap = 13;
	yPortCoord = 35;
	for(i=48; i<50; i++) 
	{       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;
        port.height = 33;
		port.sfpx = 0;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 19;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += 32;
	}
	return dev;
}
function WS_C2960III_24_2(int_status, media_type){
	
	var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2960III_24_2.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysledsForPilsner3(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 313;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	return dev;
}
function constructModeSysledsforpilsener3_24(dev){
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 17;
	tempLed.y = 27;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;
	
	
	tempLed = new top.led(ledImages);
	tempLed.x = 17;
	tempLed.y = 34;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 17;
	tempLed.y = 41;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 17;
	tempLed.y = 48;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 17;
	tempLed.y = 55;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/C2960III_modebutton.gif");
	modeBtn.x = 43;
	modeBtn.y = 65;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	// override the modes listed by show hardware led.
	dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
	
}
function WS_C2960III_24_2_composite(int_status, media_type, deviceType){
	var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	if(deviceType == "WS-C2960+24TC-S")
	{
	dev.image = "images/c2960III_24_2_compositeFE.gif";	
	}
	else
	{
	dev.image = "images/c2960III_24_2_composite.gif";	
    }
	// Construct the mode button and the system LEDs
	constructModeSysledsForPilsner3(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 315;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 Composite ports.
	xPortCoord = 591;
	xPortGap = 13;
	yPortCoord = 35;
	for(i=24; i<26; i++) 
	{       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;
        port.height = 33;
		port.sfpx = 0;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 19;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += 32;
	}
	return dev;
}
function WSC296024_2_composite(int_status, media_type, deviceType) 
{
	var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	if(deviceType == "WS-C2960+24TC-L")
	{
	dev.image = "images/c2960_24_2_compositeFE.gif";	
	}
	else
	{
	dev.image = "images/c2960_24_2_composite.gif";	
    }
	// Construct the mode button and the system LEDs
	constructModeSysleds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 313;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 Composite ports.
	xPortCoord = 588;
	xPortGap = 13;
	yPortCoord = 35;
	for(i=24; i<26; i++) 
	{       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;
        port.height = 33;
		port.sfpx = 0;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 19;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += 32;
	}
	return dev;
}

function WSC296020_4_composite(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2960_20_4_composite.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 307;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 10 each.
	for(i=0; i<20; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 25;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==9 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 4 Composite ports.
	xPortCoord = 532;
	xPortGap = 13;
	portWidth = 21;
	yPortCoord = 35;
	for(i=20; i<24; i++) 
	{       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;
        port.height = 33;
		port.sfpx = 0;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 19;
		port.id = "port_" + i;
		dev.addPort(port);
		if ( i== 21 ) 
			xPortGap = 5;
		else
			xPortGap = 13;
		xPortCoord += portWidth+xPortGap;
	}
	return dev;
}

function WSC296048_2_rj45(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2960_48_2_rj45.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 68;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 RJ45 ports.
	xPortCoord = 589;
	xPortGap = 13;
	yPortCoord = 54;
	for(i=48; i<50; i++) 
	{       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	return dev;
}
function WSC296024_2_rj45(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2960_24_2_rj45.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 313;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 RJ45 ports.
	xPortCoord = 589;
	xPortGap = 13;
	yPortCoord = 54;
	for(i=24; i<26; i++) 
	{       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	return dev;
}

function WSC29608_1_composite(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 9;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2960_8_1.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysledsForPilsner2(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<8; i++){
 	    yPortCoord = 52;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add one composite port
	xPortCoord = 397;
	yPortCoord = 49;
	for(i=8; i<9; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages,true);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 44;
        port.height = 17;
		port.sfpx = 22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 1;
		port.id = "port_" + i;
		dev.addPort(port);
	}
	return dev;
}

function WSC29608G_1_composite(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 8;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2960_7_1.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysledsForPilsner2(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 3;
	var xPortGroupGap = 9;
	var xPortStartPos = 113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	for(i=0; i<7; i++){
		yPortCoord = 52;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	xPortCoord = 398;
	yPortCoord = 50;
	for(i=7; i<8; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages,true);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 44;
        port.height = 17;
		port.sfpx = 22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 1;
		port.id = "port_" + i;
		dev.addPort(port);
	}
	return dev;
}
function WSC2960III48_2_composite(int_status, media_type, deviceType){
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	if(deviceType == "WS-C2960+48TC-S")
	{
	dev.image = "images/c2960III_48_2_compositeFE.gif";	
	}
	else
	{
	dev.image = "images/c2960III_48_2_composite.gif";	
    }
	// Construct the mode button and the system LEDs
	constructModeSysledsForPilsner3(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 70;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 Composite ports.
	xPortCoord = 594;
	xPortGap = 13;
	yPortCoord = 29;
	for(i=48; i<50; i++) 
	{       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;
        port.height = 31;
		port.sfpx = 0;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 19;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += 32;
	}
	return dev;
}

//Stella-24FP (24 PoE)
function WS_C2960_24PC_L(int_status, media_type, deviceType) {
    var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	if(deviceType == "WS-C2960+24PC-L")
	{
	dev.image = "images/c2960_3_II_24FPFE.gif";	
	}
	else
	{
	dev.image = "images/c2960_3_II_24FP.gif";	
    }
	// Construct the mode button and the system LEDs
	construct_Pilsner3_phaseII_leds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 18;//20;
	var xPortStartPos = 247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 26;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 42;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 Composite ports.
	xPortCoord = 582;//588;
	xPortGap = 13;
	yPortCoord = 33;//35;
	for(i=24; i<26; i++) 
	{       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;
        port.height = 33;
		port.sfpx = 0;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 19;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += 32;
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");	
	return dev;
}

//Stella-24PP (8-PoE)
function  WS_C2960_24LT_L(int_status, media_type){
    
	 var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2960_3_II_24LT.gif";	

	// Construct the mode button and the system LEDs
	construct_Pilsner3_phaseII_leds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 254;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 26;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 42;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 Gig ports.
	xPortCoord = 554;
	xPortGap = 13;
	yPortCoord = 38;
	for(i=24; i<26; i++) {       

		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45port(portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += 32;
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");	
	return dev;
}

//Kirin-Lite
function WS_C2960PD_8TT_L(int_status, media_type) {

	var dev = new top.device();
	dev.noofports = 9;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c2960_kirinlite.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysledsForPilsner2_Kirinlite(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<8; i++){
 	    yPortCoord = 52;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add one Gig port
	xPortCoord = 391;
	yPortCoord = 50;//49;
	for(i=8; i<9; i++){       
		port = new top.rj45port(portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
     	port.id = "port_" + i;
		dev.addPort(port);
	}
	return dev;
	
}
//Calsberg 48TT-S
function WS_C2960_48TT_S(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960_48TT_S_rj45.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysleds_Pilser4(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 8;
	var xPortStartPos = 69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 26;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 42;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 RJ45 ports.
	xPortCoord = 590;
	xPortGap = 13;
	yPortCoord = 43;
	for(i=48; i<50; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	return dev;
}

//Orion 8
function WSC29608_TC_S(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 9;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960_8_TC_S.gif";	

	// Construct the mode button and the system LEDs
	constructModeSysledsForPilsner4(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<8; i++){
 	    yPortCoord = 52;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add one composite port
	xPortCoord = 381;//397;
	yPortCoord = 53;//49;
	for(i=8; i<9; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages,true);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 44;
        port.height = 17;
		port.sfpx = 22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 1;
		port.id = "port_" + i;
		dev.addPort(port);
	}
	return dev;
}

//Stella - 48 PWR
function WSC296048_PST_L(int_status, media_type, deviceType){
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	if(deviceType == "WS-C2960+48PST-L")
	{
	dev.image = "images/C2960_48_PST_LFE.gif";	
	}
	else
	{
	dev.image = "images/C2960_48_PST_L.gif";	
	}
	// Construct the mode button and the system LEDs
	construct_Pilsner4_stella_leds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//8;
	var xPortStartPos = 68;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;//26;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;//42;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 589;//590;
	xPortGap = 18;//13;
	yPortCoord = 27;//43;
	for(i=48; i<50; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	
	// Add the 2 RJ45 ports.
	xPortCoord = 589;//590;
	xPortGap = 18;
	yPortCoord = 58;//43;
	for(i=50; i<52; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

function constructModeSysleds_Pilser4(dev) {
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 22;//17;
	tempLed.y = 25;//29;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 22;
	tempLed.y = 39;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 22;
	tempLed.y = 46;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 22;
	tempLed.y = 53;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 43;//43;
	modeBtn.y = 66;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	// override the modes listed by show hardware led.
	dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
}

function constructModeSysledsForPilsner2(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 25;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 32;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 39;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 46;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	modeBtn.x = 36;
	modeBtn.y = 49;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	// override the modes listed by show hardware led.
	dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
}
function constructModeSysledsForPilsner2_Kirinlite(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 25;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 32;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 39;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 46;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/hb_mode.gif");
	modeBtn.x = 35;
	modeBtn.y = 48;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	// override the modes listed by show hardware led.
	dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
}
function constructModeSysledsForPilsner3(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 17;
	tempLed.y = 29;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 17;
	tempLed.y = 36;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 17;
	tempLed.y = 43;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 17;
	tempLed.y = 50;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/C2960III_modebutton.gif");
	modeBtn.x = 43;
	modeBtn.y = 65;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	// override the modes listed by show hardware led.
	dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
}

function constructModeSysledsForPilsner4(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 25;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 32;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 39;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 46;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/hb_mode.gif");
	modeBtn.x = 36;
	modeBtn.y = 49;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	// override the modes listed by show hardware led.
	dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
}

function constructModeSysleds(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 20;
	tempLed.y = 23;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 20;
	tempLed.y = 30;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 20;
	tempLed.y = 37;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 20;
	tempLed.y = 44;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 20;
	tempLed.y = 51;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c2960_mode.gif");
	modeBtn.x = 42;
	modeBtn.y = 64;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	// override the modes listed by show hardware led.
	dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
}

function construct_Pilsner3_phaseII_leds(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 19;//20;
	tempLed.y = 25;//23;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 19;//20;
	tempLed.y = 32;//30;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 19;//20;
	tempLed.y = 39;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 19;//20;
	tempLed.y = 46;//44;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 19;//20;
	tempLed.y = 53;//51;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 19;//20;
	tempLed.y = 60;//51;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;
	
	// Create the Mode Btn
	//var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 42;
	modeBtn.y = 66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}

function construct_Pilsner4_stella_leds(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 20;
	tempLed.y = 20;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 20;
	tempLed.y = 27;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 20;
	tempLed.y = 34;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 20;
	tempLed.y = 41;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 20;
	tempLed.y = 48;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 20;
	tempLed.y = 55;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;
	
	// Create the Mode Btn
	//var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 44;
	modeBtn.y = 65;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}
function construct_PilsnerV_leds(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 22;//19;//20;
	tempLed.y = 25;//23;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	/*tempLed = new top.led(ledImages);
	tempLed.x = 19;//20;
	tempLed.y = 32;//30;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;*/

	tempLed = new top.led(ledImages);
	tempLed.x = 22;//19;//20;
	tempLed.y = 37;//39;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 22;//19;//20;
	tempLed.y = 44;//46;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 22;//19;//20;
	tempLed.y = 51;//53;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 22;//19;//20;
	tempLed.y = 58;//60;//51;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;
	
	// Create the Mode Btn
	//var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 42;
	modeBtn.y = 65;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}

function construct_Choya_leds(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 20;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 27;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 34;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 41;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;


	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/choya_mode.gif"); 
	modeBtn.x = 32;
	modeBtn.y = 55;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}
function construct_Choya_leds_C2960CX(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 20;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 27;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 37;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;


	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/choya_mode.gif"); 
	modeBtn.x = 32;
	modeBtn.y = 55;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}
function construct_Choya_leds_C2960CX_POE(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 20;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 27;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 35;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 169;//19;//20;
	tempLed.y = 44;//60;//51;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/choya_mode.gif"); 
	modeBtn.x = 32;
	modeBtn.y = 54;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}


// Start of PilsnerV Switches
//PilsnerV - 24PC (24 PoE)
function WS_C2960_24PC_S(int_status, media_type, deviceType) {
    var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	if(deviceType == "WS-C2960+24PC-S")
	{
	dev.image = "images/C2960_24PC_SFE.gif";	
	}
	else
	{
	dev.image = "images/C2960_24PC_S.gif";	
	}
	// Construct the mode button and the system LEDs
	construct_PilsnerV_leds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 8;//20;
	var xPortStartPos = 318;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 26;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 42;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 Composite ports.
	xPortCoord = 588;
	xPortGap = 16;//13;
	yPortCoord = 26;//33;//35;
	for(i=24; i<26; i++) 
	{       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;
        port.height = 37;//33;
		port.sfpx = 0;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 23;//19;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += 35;//32;
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");	
	return dev;
}

//PilsnerV - 24LC (8-PoE) || Dortmunder -24LC (8 POE)
function  WS_C2960_24LC_S(int_status, media_type, deviceType){
    var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	if(deviceType == "WS-C2960+24LC-S" || deviceType == "WS-C2960+24LC-L")
	{
	dev.image = "images/C2960_24LC_SFE.gif";	
	}
	else
	{
	dev.image = "images/C2960_24LC_S.gif";	
    }
	// Construct the mode button and the system LEDs
	construct_PilsnerV_leds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 8;//20;
	var xPortStartPos = 318;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 26;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 42;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 Composite ports.
	xPortCoord = 588;
	xPortGap = 16;//13;
	yPortCoord = 26;//33;//35;
	for(i=24; i<26; i++) 
	{       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;
        port.height = 37;//33;
		port.sfpx = 0;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 23;//19;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += 35;//32;
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");	
	return dev;
}
//PilsnerV - 48PST (48 PoE)
function WS_C2960_48PST_S(int_status, media_type, deviceType){ 
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	if(deviceType=="WS-C2960+48PST-S")
	{
	dev.image = "images/C2960_48PST_SFE.gif";	
	}
	else
	{
	dev.image = "images/C2960_48PST_S.gif";	
    } 
	// Construct the mode button and the system LEDs
	construct_PilsnerV_leds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 8;//9;
	var xPortStartPos = 69;//68;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 26;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 42;//43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 589;//590;
	xPortGap = 13;//18;
	yPortCoord = 23;//27;//43;
	for(i=48; i<50; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	
	// Add the 2 RJ45 ports.
	xPortCoord = 590;//589;
	xPortGap = 13;//18;
	yPortCoord = 48;//58;
	for(i=50; i<52; i++) {       
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}
//Start of Choya
function WSC2960CPD_8_PC_L(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 9;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960CPD_8PT_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds(dev);

	// PoE led	
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 48;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	//PD led
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 55;
	tempLed.id = "pd_led";
	tempLed.device = dev;
	dev.sysleds["PD"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 215;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<8; i++){
 	    yPortCoord = 42;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add Giga port composite port
	xPortCoord = 394;//381;//397;
	yPortCoord = 40;//53;//49;
	xPortGap=12;
	for(i=8; i<10; i++){
 	    yPortCoord = 40;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "DUPLEX", "SPEED","PoE");
	return dev;
}
//Choya8
function WSC2960CPD_8_TT_L(int_status, media_type) //Non PoE
{
	var dev = new top.device();
	dev.noofports = 9;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960CPD_8TT_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 215;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<8; i++){
 	    yPortCoord = 42;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add Giga port composite port
	xPortCoord = 394;//381;//397;
	yPortCoord = 40;//53;//49;
	xPortGap=12;
	for(i=8; i<10; i++){
 	    yPortCoord = 40;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "DUPLEX", "SPEED");
	return dev;
}
//Junmai2k SKU
function WSC2960CG8_2_composite(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 10;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960CG_8_2.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 206;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<8; i++){
 	    yPortCoord = 42;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i==3)
		xPortCoord += portWidth + xPortGap+xPortGroupGap;
		else
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add one composite port
	//Add Two composite port
	xPortCoord = 393;
	yPortCoord = 24;//49;
	for(i=8; i<10; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "DUPLEX", "SPEED");
	return dev;
}

//Start of Honjozo
function WSC2960C_12PCL_2(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 14;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC2960C_12PCL_2.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds(dev);

	// PoE led	
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 48;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3;
	var xPortGroupGap = 9;
	var xPortStartPos = 208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<12; i++){
	
		if(i%2 == 0) {
			yPortCoord = 19;//26;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 36;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 393;
	yPortCoord = 24;//49;
	for(i=12; i<14; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "DUPLEX", "SPEED","PoE");
	return dev;
}
//Honjozo8PWR
function WSC2960C_8PCL_2(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 10;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC2960C_8PCL_2.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds(dev);

	
	// PoE led	
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 48;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 247;//208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<8; i++){
	
		if(i%2 == 0) {
			yPortCoord = 22;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 39;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0){
		xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 393;
	yPortCoord = 24;//49;
	for(i=8; i<10; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "DUPLEX", "SPEED","PoE");
	return dev;
} 

//Honjozo8
function WSC2960C_8TCL_2(int_status, media_type,deviceType) 
{
	var dev = new top.device();
	dev.noofports = 10;
	dev.x=0;
	dev.y=0;

	if(deviceType == "WS-C2960C-8TC-L") 
	dev.image = "images/WSC2960C_8TCL_2.gif";	
	else 
	dev.image = "images/WSC2960C_8TCS_2.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 240;//208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<8; i++){
	
		if(i%2 == 0) {
			if(deviceType == "WS-C2960C-8TC-L") 
				yPortCoord = 24;//27;
			else
				yPortCoord = 26;//24;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			if(deviceType == "WS-C2960C-8TC-L") 
				yPortCoord = 42;//43;
			else
				yPortCoord = 44;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0){
		xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	//Add Two composite port
	if(deviceType == "WS-C2960C-8TC-L"){
		xPortCoord = 342;
		yPortCoord = 23;//24;//49;
	}else{
		xPortCoord = 342;//342;
		yPortCoord = 25;//24;//49;
		}
	
	for(i=8; i<10; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "DUPLEX", "SPEED");
	return dev;
}
function WSC2960CX_8TC_L(int_status, media_type,deviceType) 
{
	var dev = new top.device();
	dev.noofports = 12;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC2960CX_8TC_L.gif";		
	// Construct the mode button and the system LEDs
	construct_Choya_leds_C2960CX(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 240;//208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

		for(i=0; i<8; i++){
	
		if(i%2 == 0) {
			yPortCoord = 24;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 42;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0){
		xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	
	xPortCoord = 337;//381;//397;
	yPortCoord = 42;//53;//49;
	xPortGap=0;
	for(i=8; i<10; i++){
 	    yPortCoord = 42;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 393;
	yPortCoord = 24;//49;
	for(i=10; i<12; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "SPEED");
	return dev;
}

function WSC2960CX_8PC_L(int_status, media_type,deviceType) 
{
	var dev = new top.device();
	dev.noofports = 12;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC2960CX_8PC_L.gif";		
	// Construct the mode button and the system LEDs
	construct_Choya_leds_C2960CX_POE(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 240;//208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

		for(i=0; i<8; i++){
	
		if(i%2 == 0) {
			yPortCoord = 24;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 42;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0){
		xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	
	xPortCoord = 337;//381;//397;
	yPortCoord = 42;//53;//49;
	xPortGap=0;
	for(i=8; i<10; i++){
 	    yPortCoord = 42;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 393;
	yPortCoord = 24;//49;
	for(i=10; i<12; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "SPEED","PoE");
	return dev;
}
function createDevice(int_status, media_type, deviceType) 
{
	var device = null;
	
	if(deviceType == null) 
		return device;

	if(deviceType == "WS-C2960-48TC-L" || deviceType == "WS-C2960+48TC-L")  //Added product id for Dortmunder.
	{
		device = new WSC296048_2_composite(int_status, media_type, deviceType);
	}
	else if ( deviceType == "WS-C2960-24TC-L" || deviceType == "WS-C2960+24TC-L") //Added product id for Dortmunder.
	{
		device = new WSC296024_2_composite(int_status, media_type, deviceType);	
	}	
	else if ( deviceType == "WS-C2960G-24TC-L")
	{
		device = new WSC296020_4_composite(int_status, media_type);	
	}	
		else if ( deviceType == "WS-C2960-48TT-L")
	{
		device = new WSC296048_2_rj45(int_status, media_type);	
	}
	else if ( deviceType == "WS-C2960-24TT-L")
	{
		device = new WSC296024_2_rj45(int_status, media_type);	
	}
	else if ( deviceType == "WS-C2960G-48TC-L")
	{
		device = new WSC296044_4_composite(int_status, media_type);	
	}
	else if ( deviceType == "WS-C2960-8TC-L")
	{
		device = new WSC29608_1_composite(int_status, media_type);	
	}
	else if ( deviceType == "WS-C2960G-8TC-L")
	{
		device = new WSC29608G_1_composite(int_status, media_type);	
	}
	else if ( deviceType == "WS-C2960-48TC-S" || deviceType == "WS-C2960+48TC-S"){ //Added product id for Dortmunder.
			device = new WSC2960III48_2_composite(int_status, media_type, deviceType);
	}
	else if ( deviceType == "WS-C2960-24-S" ){
			device = new WS_C2960III_24_2(int_status, media_type);
	}
	else if(deviceType == "WS-C2960-24TC-S" || deviceType == "WS-C2960+24TC-S"){ //Added product id for Dortmunder.
			device = new WS_C2960III_24_2_composite(int_status, media_type, deviceType);
		}
    else if(deviceType == "WS-C2960PD-8TT-L"){ //Kirin-Lite
			device = new WS_C2960PD_8TT_L(int_status, media_type);
	}
	else if(deviceType == "WS-C2960-24PC-L" || deviceType == "WS-C2960+24PC-L"){ //Stella-24FP (24 PoE) || Dortmunder
			device = new WS_C2960_24PC_L(int_status, media_type, deviceType);
	}
	else if(deviceType == "WS-C2960-24LT-L"){ //Stella-24PP (8 PoE)
			device = new WS_C2960_24LT_L(int_status, media_type);
	}
	else if(deviceType == "WS-C2960-48TT-S"){ //Calsberg 48TT-S
			device = new WS_C2960_48TT_S(int_status, media_type);
	}
	else if(deviceType == "WS-C2960-8TC-S"){ //Orion 8
			device = new WSC29608_TC_S(int_status, media_type);
	}
	else if(deviceType == "WS-C2960-48PST-L" || deviceType == "WS-C2960+48PST-L"){ //Stella-48 PWR || Dortmunder
		device = new WSC296048_PST_L(int_status, media_type, deviceType);
	}
	else if(deviceType == "WS-C2960-24PC-S" || deviceType == "WS-C2960+24PC-S"){ //PilsnerV 24 (24-PoE) || Dortmunder 
		device = new WS_C2960_24PC_S(int_status, media_type, deviceType); 
	}
	else if(deviceType == "WS-C2960-24LC-S" || deviceType == "WS-C2960+24LC-S" || deviceType == "WS-C2960+24LC-L"){ //PilsnerV 24 (8-PoE) //Dortmunder 24 (8-PoE)
		device = new WS_C2960_24LC_S(int_status, media_type, deviceType);
	}
	else if(deviceType == "WS-C2960-48PST-S" || deviceType == "WS-C2960+48PST-S"){ //PilsnerV 48 (48-PoE) || Dortmunder 48
		device = new WS_C2960_48PST_S(int_status, media_type, deviceType); 
	}else if(deviceType == "WS-C2960CPD-8PT-L"){ //Choya 8Power
		device = new WSC2960CPD_8_PC_L(int_status, media_type);  
	}else if(deviceType == "WS-C2960CPD-8TT-L"){ //Choya8 
		device = new WSC2960CPD_8_TT_L(int_status, media_type); 
	}else if(deviceType == "WS-C2960CG-8TC-L"){ //Junmai8
		device = new WSC2960CG8_2_composite(int_status, media_type); 
	}else if(deviceType == "WS-C2960C-12PC-L"){ //2960C-12PC-L Honjozo 12 Pwr
		device = new WSC2960C_12PCL_2(int_status, media_type); 
	}else if(deviceType == "WS-C2960C-8PC-L"){ //2960C-8PC-L Honjozo8Pwr
		device = new WSC2960C_8PCL_2(int_status, media_type); 
	}else if(deviceType == "WS-C2960C-8TC-L" || deviceType == "WS-C2960C-8TC-S") { //2960C-8TC-L Honjozo8 &  Honjozo8 LanLite
		device = new WSC2960C_8TCL_2(int_status, media_type,deviceType); 
	}else if(deviceType == "WS-C2960CX-8TC-L") {                                     //Smirnoff Support -->
		device = new WSC2960CX_8TC_L(int_status, media_type,deviceType); 
	}else if(deviceType == "WS-C2960CX-8PC-L") {                                    
		device = new WSC2960CX_8PC_L(int_status, media_type,deviceType); 
	} 
	if(device != null) 
	{
		device.type = deviceType;
		if(device.type.indexOf("C2960CX") != -1) 
			device.family = "2960-CX";
		else if(device.type.indexOf("C2960C") != -1) 
			device.family = "2960-C";
		else
			device.family = "2960";
	}

	return device;
}
