/**
 Description: Controller - Day Zero Wizard
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.controller("step1Ctrl", ['$scope', 'dayZeroStepService', 'validationService', '$filter','$timeout',
function($scope, dayZeroStepService,  validationService,$filter,$timeout) {
	var translate = $filter("translate");
	//$scope.basicConfigToolTip=function(msg, $event){
	//	var el = $event.target;
	//	if(el.id=="hostName")
	//	Angular.element("#basicConfigToolTip").html("{{'help_day0_hostname' | translate}}");
	//}
	$scope.basicConfigToolTip=true;
	angular.element("#hostName").on("focus", function () {
		$timeout(function(){
			$scope.hostNameTip = true;
		},0);
	});
	angular.element("#userName").on("focus", function () {
		$timeout(function(){
			$scope.userNameTip = true;
		},0);
	});
	angular.element("#password").on("focus", function () {
		$timeout(function(){
			$scope.passwordTip = true;
		},0);
	});
	angular.element("#enablePassword").on("focus", function () {
		$timeout(function(){
			$scope.enablePasswordTip = true;
		},0);
	});
	angular.element("#clock").on("focus", function () {
		$timeout(function(){
			$scope.clockTip = true;
		},0);
	});
	angular.element("input").on("blur", function () {
		$timeout(function(){
			$scope.hostNameTip=false;
			$scope.userNameTip=false;
			$scope.passwordTip=false;
			$scope.enablePasswordTip=false;
			$scope.clockTip=false;
			$scope.basicConfigToolTip=true;
		},0);
	});
	angular.element("input").on("focus", function () {
		$timeout(function(){
			$scope.basicConfigToolTip=false;
		},0);
	});


	$scope.wizardValidations = {
		//TODO: make it re-usable
		rules : {
			hostnamevalidate : function(input) {
				var valMsg = input.data('hostnamevalidateMsg');
				if ((valMsg==undefined)) {
					return true;
				}
				var regExp=/^[0-9-_]+$/;
				if(regExp.test(input.val()))
					return false;
				return true;
			}
		}
	};
	$scope.$on("dayZeroWizard:nextButtonPressed", function(evt, laststep, stepNumber) {
		if (stepNumber === 1) {
			$scope.myValidator = $scope.basicScreenValidator;
			validationService.addValidator($scope.myValidator, 1);
			if ($scope.myValidator && $scope.myValidator.validate()) {
				$scope.dayzero.clock=$filter('date')(new Date($scope.dayzero.clock), 'HH:mm:ss dd MMMM yyyy');
				var basicConfig = {
					"hostName": $scope.dayzero.hostName,
					"userName": $scope.dayzero.userName,
					"password": $scope.dayzero.password,
					"enablePassword": $scope.dayzero.enablePassword,
					"clock": $scope.dayzero.clock
				};
				dayZeroStepService.setBasicConfig(basicConfig);
			}
		}
	});
}]);
