/**
 Description: Controller for System Information
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
'use strict';
app.controller('systemInformationCtrl', ['$scope','$filter','DashletService','requestRoutingService','$interval','dashletReloadTime','$rootScope', function ($scope,$filter, dashletService,requestRoutingService,$interval,dashletReloadTime, $rootScope) {
	var translate = $filter("translate");
	//Refresh the system info for every 60 seconds
	var sysInfoFetchLoop = $interval(function(){
		if(angular.element(".systemPower").length > 0){
			loadSystemInfo();
		} else {
			$interval.cancel(sysInfoFetchLoop);
		}
	}, dashletReloadTime);
	//for initial load
	loadSystemInfo();	
	
	function loadSystemInfo(){	
	 if($rootScope.deviceInfo.isPoECapable){
		$scope.powerStatus=true;
		
		var avaiablePowers,usedPowers,remainingPowers=0;
		var availablePower,usedPower,remainingPower=0;
		var arrAvailablePower,arrUsedPower,arrRemainingPower;
		if( ($rootScope.deviceInfo.type.indexOf("2960X")!=-1 && ($rootScope.deviceInfo.type != "WS-C2960X-24PSQ-L" && $rootScope.deviceInfo.type != "WS-C2960X-48TS-LL" &&
                $rootScope.deviceInfo.type != "WS-C2960X-24TS-LL" ))  || $rootScope.deviceInfo.type.indexOf("2960XR")!=-1 || ( $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1 && $rootScope.deviceInfo.type.indexOf("PD-S")!=-1)){		
			var strCLIOutput = deviceCommunicator.getExecCmdOutput("show power inline");
			var arrPower=strCLIOutput.split("\n");			
			var arrInnerWords = arrPower[3].split(" ");				  		    
			for (var k=0,j=1; k < arrInnerWords.length; k++) {			
				if(arrInnerWords[k] == "") {
		 			continue;
	 			}	 				 					
				if (j == 2) {				
					availablePower=arrInnerWords[k];
					arrAvailablePower=availablePower.split("(")
				    avaiablePowers=arrAvailablePower[0];
	 			} else if (j == 3) {
	 				usedPower=arrInnerWords[k];
	 				arrUsedPower=usedPower.split("(")
				    usedPowers=arrUsedPower[0];
	 			} else if (j == 4) {
	 				remainingPower=arrInnerWords[k];
	 				arrRemainingPower=remainingPower.split("(")
				    remainingPowers=arrRemainingPower[0];
	 			}  	 				 					
	 		   	j++;	 	
			}
		}else{
			var powerDetails =requestRoutingService.getShowCmdOutput("show power inline","showPower");
			if(powerDetails!=null){
			    availablePower=powerDetails.entry.availablePower;
			    arrAvailablePower=availablePower.split("(")
			    avaiablePowers=arrAvailablePower[0];
			    
			    usedPower=powerDetails.entry.usedPower;
				arrUsedPower=usedPower.split("(")
			    usedPowers=arrUsedPower[0];
				
				remainingPower=powerDetails.entry.remainingPower;
				arrRemainingPower=remainingPower.split("(")
			    remainingPowers=arrRemainingPower[0];
			}			
		}
		 
		//Power utilization chart
		angular.element("#powerChart").kendoChart({              
             legend: {
                position: "bottom"
             },
             chartArea:{                
                 height:260
             },            
             seriesColors: ["#9EC654","red","#725D87"],
             series: [{
                 type: "pie",
				 overlay: {
					gradient: "none"
				 },
                 data: [{
                     category:translate("db_power_available"),
                     value: remainingPowers
                 }, {
                     category:translate("db_power_used"),
                     value: usedPowers
                 }, {
                     category:translate("db_power_total"),
                     value: avaiablePowers
                 }]
             }],
             tooltip: {
                 visible: true,
                 template: "#= category #: #= value # w"
             }
         }); 
	  }else{
		  $scope.powerStatus=false;
	  }
		
		//Temp chart
		var tempDetails =requestRoutingService.getShowCmdOutput("show env all","showEnv");
		var currentTemp,yellowThres,redThres=0;
		if(tempDetails!=null){
			currentTemp=tempDetails.entry.tempVal;
			$scope.currentTemp=currentTemp;
			yellowThres=tempDetails.entry.yellowThres;
			redThres=tempDetails.entry.redThres;
		}
		 angular.element("#gauge").kendoLinearGauge({             
             legend: {
            	 position: "bottom"
             },
             chartArea: {
            	 width:200,
                 height:230
             },
             pointer: {
                 value: currentTemp,
                 shape: "arrow"
             },
             scale: {
                 majorUnit: 10,
                 minorUnit: 2,
                 min: 0,
                 max: 100,
                 vertical: true,
                 ranges: [
                     {
                         name:translate("com_ok"),
                         from: 0,
                         to: parseInt(yellowThres)-1,
                         color: "Green"
                     }, {
                         name:translate("db_syteminfo_yellowthres"),
                         from: yellowThres,
                         to: parseInt(redThres)-1,
                         color: "Yellow"
                     }, {
                         name:translate("db_syteminfo_redthres"),
                         from: redThres,
                         to: 100,
                         color: "Red"
                     }
                 ]
             },
           tooltip: {
        	   visible: true,        	  
        	   template: "#= scale.ranges.name #: #= value #"
           }
         });
	
     }
	
}]);