/**
 Description: Controller - Day Zero Wizard
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.controller("step3Ctrl", ['$scope', 'dayZeroStepService', 'validationService', '$timeout','$filter','$compile','executeCliCmdService','requestRoutingService',
function($scope, dayZeroStepService, validationService, $timeout, $filter,$compile,executeCliCmdService,requestRoutingService) {
	$scope.interface = {
		selected:{}
	};
	$scope.ipAddress = {
		selected:{}
	};
	$scope.newIpAddress = {
		selected:{}
	};
	$scope.subnetMask = {
		selected:{}
	};
	$scope.layerConfigToolTip=true;
	angular.element("#defaultGateway").on("focus", function () {
		$timeout(function(){
			$scope.defaultGatewayTip = true;
		},0);
	});
	angular.element("#defaultRoute").on("focus", function () {
		$timeout(function(){
			$scope.defaultRouteTip = true;
		},0);

	});
	$(document).on("focus","#dynamicInterface input", function () {
		$timeout(function(){
			$scope.ipAddressAssignTip = true;
			$scope.layerConfigToolTip=false;
		},0);
	});
	$(document).on("blur","#dynamicInterface input", function () {
		$timeout(function(){
			$scope.ipAddressAssignTip = false;
			$scope.layerConfigToolTip=true;
		},0);
	});
	angular.element("input").on("blur", function () {
		$timeout(function(){
			$scope.defaultGatewayTip=false;
			$scope.defaultRouteTip=false;
			$scope.ipAddressAssignTip=false;
			$scope.layerConfigToolTip=true;
		},0);
	});
	angular.element("input").on("focus", function () {
		$timeout(function(){
			$scope.layerConfigToolTip=false;
		},0);
	});
	$scope.iprouteEnable=false;
	var deviceDesc = deviceCommunicator.getExecCmdOutput("show inventory");
	var START_INPUT= new Array("DESCR:");
	var END_INPUT= new Array("PID:");
	deviceDesc= executeCliCmdService.getNextString(deviceDesc,START_INPUT,END_INPUT);
	if(deviceDesc.indexOf('C2960L') > -1)
		$scope.iprouteEnable=true;
	else
		$scope.iprouteEnable=false;

	var translate = $filter("translate");
	$scope.dayzero={};
	var vlan1IPDetails = requestRoutingService.getShowCmdOutput("show running-config","showRun");
	if(vlan1IPDetails.ShowRun){
		vlan1IPDetails=vlan1IPDetails.ShowRun.wnwebdata.ipAddress;
		vlan1IPDetails=vlan1IPDetails.split(' ');
		$scope.dayzero.vlan="Vlan1";
		$scope.dayzero.ipAddress=vlan1IPDetails[0];
		//$scope.dayzero.subnetMask=vlan1IPDetails[1];
	}
	$scope.interfaceOptions=dayZeroStepService.getInterOption();
	$scope.$watch(function() {
		return dayZeroStepService.getInterOption();
	}, function(newValue,oldValue) {
		$scope.interfaceOptions = newValue;
		$scope.accordions = [];
		for(var i=0;i<$scope.interfaceOptions.length;i++){
			$scope.accordions.push($scope.accordions.length);
			$scope.interface.selected[i]=$scope.interfaceOptions[i].interfaceText;
		}
	});

	var ipAddressReg=/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
	$scope.wizardValidations = {
		//TODO: make it re-usable
		rules : {
			validateip:function(input){
				var valMsg = input.data('validateipMsg');
				if ((valMsg==undefined)) {
					return true;
				}
				var ipAddress=input.val();
				if(ipAddress=="0.0.0.0" || '')
					return false;
				if (ipAddressReg.test(ipAddress)) {
					return true;
				};
				return false;
			},
			routevalidate:function(input){
				var valMsg = input.data('routevalidateMsg');
				if ((valMsg==undefined)) {
					return true;
				}
				if(input.val()=='')
					return true;
				if(input.val()=="0.0.0.0")
					return false;
				if (ipAddressReg.test(input.val()) && input.val()!='') {
					return true;
				};
				return false;
			}
		}
	};
	$scope.$on("dayZeroWizard:nextButtonPressed", function(evt, laststep, stepNumber) {
		if (stepNumber === 3) {
			$scope.myValidator = $scope.basicScreenValidator;
			validationService.addValidator($scope.myValidator, 3);
			if ($scope.myValidator && $scope.myValidator.validate()) {
				var ipAddressAssign =[];
					for(var i=0;i<$scope.interfaceOptions.length;i++){
						if($scope.interface.selected[i]&&$scope.newIpAddress.selected[i]&&$scope.subnetMask.selected[i]) {
							ipAddressAssign.push({
								"vlan": $scope.interface.selected[i],
								"ipAddress": $scope.newIpAddress.selected[i],
								"subnet":$scope.subnetMask.selected[i]
							});
						}
					}
				var vlanInterfaceDef='';
				var newIpAddressDef='';
				var subnetMaskVal='';
				if($scope.dayzero.vlan&&$scope.dayzero.newIpAddress&&$scope.dayzero.subnetMask){
					vlanInterfaceDef=$scope.dayzero.vlan;
					newIpAddressDef=$scope.dayzero.newIpAddress;
					subnetMaskVal=$scope.dayzero.subnetMask;
				}
				var layConfig = {
					"defaultGateway": $scope.dayzero.defaultGateway,
					"defaultRoute": $scope.dayzero.defaultRoute,
					"vlan":vlanInterfaceDef,
					"newIpAddress": newIpAddressDef,
					"subnet":subnetMaskVal
				};
				dayZeroStepService.setLayConfig(layConfig);
				dayZeroStepService.setIpAddressAssign(ipAddressAssign);
			}
		}
	});
}]);



