/**
Description: Controller - Day Zero Wizard
Copyright (c) 2016 by Cisco Systems, Inc.
	All rights reserved.
*/
app.controller("step4Ctrl", ['$scope', 'dayZeroStepService', 'validationService' ,'$filter','$timeout',
function($scope,  dayZeroStepService, validationService, $filter,$timeout) {
	var translate = $filter("translate");
	var dayzeroConfigCLI='';
	$scope.dayzero={};
	$scope.dayzero.enableTelnet=false;
	$scope.dayzero.enableSSH=false;
	$scope.advConfigToolTip=true;
	angular.element("#enableTelnet").on("focus", function () {
		$timeout(function(){
			$scope.enableTelnetTip = true;
		},0);
	});
	angular.element("#enableSSH").on("focus", function () {
		$timeout(function(){
			$scope.enableSSHTip = true;
		},0);

	});
	angular.element("input").on("blur", function () {
		$timeout(function(){
			$scope.enableTelnetTip=false;
			$scope.enableSSHTip=false;
			$scope.advConfigToolTip=true;
		},0);
	});
	angular.element("input").on("focus", function () {
		$timeout(function(){
			$scope.advConfigToolTip=false;
		},0);
	});

	$scope.wizardValidations = {
		rules : {

		}
	};
	$scope.$on("dayZeroWizard:nextButtonPressed", function(evt, laststep, stepNumber) {
		if (stepNumber === 4) {
			$scope.myValidator = $scope.basicScreenValidator;
			validationService.addValidator($scope.myValidator, 4);
			if ($scope.myValidator.validate() === true) {
				var enbaleTelnetVal='';
				if($scope.dayzero.enableTelnet)
					enbaleTelnetVal=translate("com_enable");
				else
					enbaleTelnetVal=translate("com_disable");
				var enbaleSSHVal='';
				if($scope.dayzero.enableSSH)
					enbaleSSHVal=translate("com_enable");
				else
					enbaleSSHVal=translate("com_disable");
				var advConfig = {
					"enableTelnet": enbaleTelnetVal,
					"enableSSH": enbaleSSHVal
				};
				dayZeroStepService.setAdvConfig(advConfig);
			}
		}
	});
}]); 