/**
 Description: Controller - Day Zero Wizard
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.controller("SummaryScreenCtrl", ['$scope', 'dayZeroStepService', 'validationService', '$filter',
function ($scope, dayZeroStepService, validationService, $filter) {
	var translate = $filter("translate");
	$scope.basicSummary= dayZeroStepService.getBasicConfig();
	$scope.interSummary= dayZeroStepService.getInterConfig();
	$scope.advSummary= dayZeroStepService.getAdvConfig();
	$scope.laySummary= dayZeroStepService.getLayConfig();
	$scope.ipAddressAssign= dayZeroStepService.getIpAddressAssign();

	$scope.$watch(function() {
		return dayZeroStepService.getBasicConfig();
	}, function(newValue,oldValue) {
		$scope.basicSummary = newValue;
	});
	$scope.$watch(function() {
		return dayZeroStepService.getInterConfig();
	}, function(newValue,oldValue) {
		$scope.interSummary = newValue;
	});
	$scope.$watch(function() {
		return dayZeroStepService.getAdvConfig();
	}, function(newValue,oldValue) {
		$scope.advSummary = newValue;
	});
	$scope.$watch(function() {
		return dayZeroStepService.getLayConfig();
	}, function(newValue,oldValue) {
		$scope.laySummary = newValue;
	});
	$scope.$watch(function() {
		return dayZeroStepService.getIpAddressAssign();
	}, function(newValue,oldValue) {
		$scope.ipAddressAssign = newValue;
	});

	$scope.$on("dayZeroWizard:nextButtonPressed", function (evt, laststep, stepNumber) {
		if (stepNumber === 5) {
			var dayzeroConfigCLI='';
			dayzeroConfigCLI+="hostname "+ $scope.basicSummary.hostName+"\n";
			dayzeroConfigCLI+="username " + $scope.basicSummary.userName+" privilege 15 password 0 "+ $scope.basicSummary.password+"\n ";
			dayzeroConfigCLI+="enable secret "+ $scope.basicSummary.enablePassword+"\n";

			//dayzeroConfigCLI+="enable password 0 "+ $scope.basicSummary.enablePassword+"\n";
			dayzeroConfigCLI+="do clock set "+ $scope.basicSummary.clock+"\n";
			for(var i=0;i<$scope.interSummary.dataVlan.length;i++){
				dayzeroConfigCLI+="int vlan" + $scope.interSummary.dataVlan[i]+"\n";
			}
			for(var i=0;i<$scope.interSummary.voiceVlan.length;i++){
				dayzeroConfigCLI+="int vlan" + $scope.interSummary.voiceVlan[i]+"\n";
			}

			if($scope.interSummary.accessPorts){
				for(var index=0;index<$scope.interSummary.accessPorts.length;index++){
					if($scope.interSummary.accessPorts[index]!=translate("portconfig_options_none") && $scope.interSummary.accessPorts[index]!=undefined){
						dayzeroConfigCLI+="int "+ $scope.interSummary.accessPorts[index]+"\n";
						dayzeroConfigCLI+="switchport mode access \n"
						for(var i=0;i<$scope.interSummary.dataVlan.length;i++){
							dayzeroConfigCLI+="switchport access vlan "+$scope.interSummary.dataVlan[i]+"\n";
						}
						for(var j=0;j<$scope.interSummary.voiceVlan.length;j++){
							dayzeroConfigCLI+="switchport voice vlan "+$scope.interSummary.voiceVlan[j]+"\n";
						}
						if($scope.interSummary.portfast==translate("com_enable")){
							dayzeroConfigCLI+="spanning-tree portfast edge\n";
						}
					}
				}
			}

			if($scope.interSummary.uplinkPort!="none" && $scope.interSummary.uplinkPort!=translate("portconfig_options_none") && $scope.interSummary.uplinkPort!=undefined){
				dayzeroConfigCLI+="exit\nint "+ $scope.interSummary.uplinkPort+"\n";
				dayzeroConfigCLI+="switchport mode trunk \n";
				dayzeroConfigCLI+="switchport trunk allowed vlan all \n";
			}
			dayzeroConfigCLI+="ip default-gateway " + $scope.laySummary.defaultGateway +"\n";
			if($scope.laySummary.defaultRoute!='' && $scope.laySummary.defaultRoute!=undefined){
				dayzeroConfigCLI+="ip routing \nip route 0.0.0.0 0.0.0.0 " + $scope.laySummary.defaultRoute+"\n";
			}
			if($scope.laySummary.newIpAddress){
				dayzeroConfigCLI+="interface "+$scope.laySummary.vlan+"\n";
				dayzeroConfigCLI+="ip address "+$scope.laySummary.newIpAddress+" "+$scope.laySummary.subnet+"\n";
			}
			for(var i=0;i<$scope.ipAddressAssign.length;i++){
				if($scope.ipAddressAssign[i].ipAddress){
					var newIpAddressAssign=($scope.ipAddressAssign[i].vlan).replace(/\D/g,'');
					dayzeroConfigCLI+="interface vlan"+newIpAddressAssign+"\n";
					dayzeroConfigCLI+="ip address "+$scope.ipAddressAssign[i].ipAddress+" "+$scope.ipAddressAssign[i].subnet+"\n";
				}
			}
			if($scope.advSummary.enableTelnet==translate("com_enable")){
				dayzeroConfigCLI+="do write memory\n";
				dayzeroConfigCLI+="line vty 0 10 \ntransport input telnet \ntransport output telnet\nlogin local\n";
			}
			if($scope.advSummary.enableSSH==translate("com_enable")){
				dayzeroConfigCLI+="line vty 0 10 \ntransport input ssh \ntransport output ssh\nlogin local\n";
			}
			dayzeroConfigCLI+="ip http authentication local\n"
			dayzeroConfigCLI+="do write memory\n"
			dayzeroConfigCLI+="exit"
			dayZeroStepService.setCli(dayzeroConfigCLI);
		}
	});
	$scope.tabTog = function(){
		$('#summaryTabs').find('li').removeClass('k-state-default');
	}
}]);
