/**
 Description: Clients Monitoring Controller
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.controller('ClientsMonitoring', ['$scope', '$filter', 'gridCrudService','requestRoutingService',
    function ($scope, $filter, gridCrudService,requestRoutingService) {
        var translate = $filter("translate"), exportData = [], dateTimeStamp = "";

        $scope.headersInExport = [translate("clients_mac"), translate("clients_switchport"), translate("clients_name"),
            translate("clients_os"), translate("clients_manufacturer"),
            translate("clients_ip"), translate("clients_vlan"), translate("clients_poe")
        ];

        var showCDPDetails = requestRoutingService.getShowCmdOutput("show cdp neighbors detail", "clientsShowCdpNeighborsDetail");
        showCDPDetails = showCDPDetails.showCdpNeighborsDetail.wnwebdata;
        if (typeof showCDPDetails == "object" && !showCDPDetails.length)
            showCDPDetails = [showCDPDetails];
        showCDPDetails = $.map(showCDPDetails, function (value) {
            return [value];
        });
        console.log(showCDPDetails);

        var showDeviceClassifier =requestRoutingService.getShowCmdOutput("show device classifier attached", "clientsShowDeviceClassifierAttached");;
        if(showDeviceClassifier.showDeviceClassifierAttached.wnwebdata!='')
        {
            showDeviceClassifier = showDeviceClassifier.showDeviceClassifierAttached.wnwebdata.entry;
            showDeviceClassifier.pop();
            showDeviceClassifier.shift();
            showDeviceClassifier = $.map(showDeviceClassifier, function (value) {
                return [value];
            });
        }
        else
            showDeviceClassifier = showDeviceClassifier.showDeviceClassifierAttached.wnwebdata;

        console.log(showDeviceClassifier);


            for (var i in showCDPDetails) {
                if (!(showCDPDetails[i].VLAN))
                    showCDPDetails[i].VLAN = "NA"

                if (showCDPDetails[i].PoEDrawn)
                    showCDPDetails[i].PoEDrawn = ((parseFloat(showCDPDetails[i].PoEDrawn)).toFixed(2)) + "W";
                else
                    showCDPDetails[i].PoEDrawn = "0W";

                switch (showCDPDetails[i].Capabilities) {
                    case "Trans-Bridge":
                        showCDPDetails[i].Images = "/resources/images/distribution_switch.png";
                        break;
                    case"Switch":
                        showCDPDetails[i].Images = "/resources/images/distribution_switch.png";
                        break;
                    case "Router":
                        showCDPDetails[i].Images = "/resources/images/wireless_router.png";
                        break;
                    case "H P M":
                        showCDPDetails[i].Images = "/resources/images/phone.png";
                        break;
                    case "IP Phone":
                        showCDPDetails[i].Images = "/resources/images/phone.png";
                        break;
                    default :
                        showCDPDetails[i].Images = "/resources/images/unknown_device.png";
                        break;
                }
                console.log(showCDPDetails[i].Images);

                for (var j in showDeviceClassifier) {
                    if (showCDPDetails[i].Manufacturer == showDeviceClassifier[j].Manufacturer)
                        showCDPDetails[i].MAC = showDeviceClassifier[j].MAC;
                }
            }
        console.log(showCDPDetails);

        $scope.gridDataSource1 = new kendo.data.DataSource({
            pageSize: 10,
            data: showCDPDetails
        });

        $scope.getHeader = function () {
            return $scope.headersInExport;
        };

        $scope.getArray = function () {
            $scope.dataForExport = function () {
                    showCDPDetails.forEach(function (x) {
                        exportData.push({
                            "MAC": x.MAC,
                            "SwitchPort": x.SwitchPort,
                            "ClientName": x.ClientName,
                            "OS": x.OS,
                            "Manufacturer": x.Manufacturer,
                            "IP": x.IP,
                            "VLAN": x.VLAN,
                            "PoEDrawn": x.PoEDrawn
                        })
                    });
                return exportData;
            };
            dateTimeStamp = new Date();
            $scope.clientsFileName = "Clients " + $filter('date')(dateTimeStamp, 'yyyy-MM-dd_hh-mm-ss');
            exportData = [];
            return $scope.dataForExport;
        };

        $scope.portsGridOptions = {
            dataSource: $scope.gridDataSource1,
            editable: false,
            sortable: true,
            filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
            reorderable: true,
            scrollable: false,
            selectable: true,
            pageable: {
            	messages: {
					  display: translate("com_page_display"), 
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),  
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
                previousNext: true,
                info: true,
                refresh: true,
                pageSizes: gridCrudService.grid_page_sizes,
                buttonCount: 5
            },
            columns: [{
                field: "MAC",
                title: translate("clients_mac")
            }, {
                field: "SwitchPort",
                title: translate("clients_switchport")
            }, {
                field: "ClientName",
                title: translate("clients_name")
            }, {
                field: "OS",
                title: translate("clients_os")
            }, {
                field: "Manufacturer",
                title: translate("clients_manufacturer")
            }, {
                field: "IP",
                title: translate("clients_ip")
            }, {
                field: "VLAN",
                title: translate("clients_vlan")
            }, {
                field: "PoEDrawn",
                title: translate("clients_poe")
            }, {
                field: "Images",
                title: translate("clients_images"),
                template: "<img src='#= Images #' />"
        }]
        };

    }
]);
