/**
 Description: Controller for System Information
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
'use strict';
app.controller('systemInformationCtrl', ['$scope','DashletService','requestRoutingService','$interval','dashletReloadTime', function ($scope, dashletService,requestRoutingService,$interval,dashletReloadTime) {
	
	//Refresh the system info for every 60 seconds
	var sysInfoFetchLoop = $interval(function(){
		if(angular.element(".sysInfoContent").length > 0){
			loadSystemInfo();
		} else {
			$interval.cancel(sysInfoFetchLoop);
		}
	}, dashletReloadTime);
	//for initial load
	loadSystemInfo();
	
	//CPU UTILIZATION  
	function loadSystemInfo(){ 
	var sysInfoDetails =requestRoutingService.getShowCmdOutput("show env all","showEnv");
	if(sysInfoDetails!=null){
		//setting temp details
		$scope.tempState=sysInfoDetails.entry.tempState;
		$scope.temp=sysInfoDetails.entry.temp;
		$scope.tempValue=sysInfoDetails.entry.tempVal;
		$scope.yellowThres=sysInfoDetails.entry.yellowThres;
		$scope.redThres=sysInfoDetails.entry.redThres;
		
		//setting ps deatils
		$scope.psPID=sysInfoDetails.entry.pid;
		$scope.sysPower=sysInfoDetails.entry.sysPower;
		$scope.psMaxPower=sysInfoDetails.entry.maxPower;
		$scope.maxHeat=sysInfoDetails.entry.maxHeat;
		$scope.poePower=sysInfoDetails.entry.poePower;
		$scope.psStatus=sysInfoDetails.entry.psStatus;
	}
	}	
}]);