/**
 Description: Switch Service
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */

/**
 Description: Switch data service provides all the capabilities of the switch
 			  and the data required to render the switch view.
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.service("switchDataService",['$rootScope','requestRoutingService',function($rootScope,requestRoutingService){
	
	this.getSwitchViewData = function(){
		var switchViewData = {};
		
		//Set hostname
		var hname = requestRoutingService.getShowCmdOutput("show running-config | i hostname");
		switchViewData.hostname = hname.split(' ')[1];
		
		//Set master swicth id and number of switches
		switchViewData.noOfSwitches = 1;
		switchViewData.masterSwitchId = 1;
		
		//Add the individual switches and the capabilities
		var powerStatus = null;
		if($rootScope.deviceInfo.isPoECapable){
			powerStatus = requestRoutingService.getShowCmdOutput("show power inline", "portsMonPower");
		}
		var ifStatus = requestRoutingService.getShowCmdOutput("show interface status", "portsMonStatus");

		//console.log("-----");
		//console.log(ifStatus);
		//console.log(powerStatus);
		//console.log("-----");
		
		var switchNoIndexInName = 0;
		var portNumberIndexInName = 1;
		
		//Identify the ports in each group
		var groupSize = 12;
		if(parseInt($rootScope.deviceInfo.numberOfPorts) === 8 || parseInt($rootScope.deviceInfo.numberOfPorts) === 16){
			groupSize = 8;
		}

		//for (var p in powerStatus.ShowPowerInline.PowerTable.entry){ console.log(powerStatus.ShowPowerInline.PowerTable.entry[p]);}
		//for (var p in ifStatus.Port.InterfaceStatus.entry){ console.log(ifStatus.Port.InterfaceStatus.entry[p]);}

		if($rootScope.deviceInfo.isStackingSupported){
			//TODO - once we support 2960X
			//Update number of switches
			//Get masterswitchId and no os switches with "show sw"
			//Get mac addresses for each switch
			portNumberIndexInName = 2; //is Gig0/0/1 as against Gig0/1 in non-stacked switches
		}else{
			//Anything specific for non-stacking switches????
		}
		var totalPorts = switchViewData.noOfSwitches * parseInt($rootScope.deviceInfo.numberOfPorts);
		switchViewData.switches = [];
		
		var switchNo = 1;
		for(; switchNo <= switchViewData.noOfSwitches; switchNo++){
			var switchObject = {};
			switchObject.id = 1; //Hard code for now. Will be dynamic in 2960X with stacking
			//TODO: in stacked switches, the MAC address has to be got for each switch from "show sw" o/p
			switchObject.macAdd =  $rootScope.deviceInfo.baseMacAdd; //TODO for stacks
			switchObject.isPoECapable = $rootScope.deviceInfo.isPoECapable;
			switchObject.isStackConfigurable = $rootScope.deviceInfo.isStackingSupported;
			switchObject.ports = [[[]]];
			switchObject.uplinkports = [];
			switchViewData.switches[switchNo-1] = switchObject;
		}
		
		var totalNumberOfGroups = Math.floor(ifStatus.Port.InterfaceStatus.entry.length / groupSize);
		if( parseInt($rootScope.deviceInfo.numberOfPorts) == 8 ){
			totalNumberOfGroups = 1;
		}
		//The subgroups can either be 4 or 6. When ports are 8 or 16, subgroups are 4, and for 24 or 48 ports subgroups are 6
		var totalNumberOfSubgroups = (parseInt($rootScope.deviceInfo.numberOfPorts)%6)==0?6:4;
		
		var index1, index2;
		for(index1 = 0; index1 < totalNumberOfGroups; index1++ ){
			switchObject.ports[index1] = [];
			for(index2 = 0; index2 < totalNumberOfSubgroups; index2++ ){ 
				switchObject.ports[index1][index2] = [];
				switchObject.ports[index1][index2][0] = {};
				switchObject.ports[index1][index2][1] = {};
			}
		}
		
		//Update port/uplinkport data
		var tempArray = ifStatus.Port.InterfaceStatus.entry;
		if($rootScope.deviceInfo.isPoECapable){
			for (var powerEntryIndex in powerStatus.ShowPowerInline.PowerTable.entry ){
				var powerEntry = powerStatus.ShowPowerInline.PowerTable.entry[parseInt(powerEntryIndex)];
				var wattage = parseFloat(powerEntry.Power);
				if(wattage != 0){
					for(var index=0; index < tempArray.length; index++){
						if(tempArray[index].Port === powerEntry.Interface){
							tempArray[index].poe = true;
							tempArray[index].power = wattage;
						}
					}
				}	
			}
		}
		
		for (var p in tempArray){ 
			p = parseInt(p);
			//console.log(ifStatus.Port.InterfaceStatus.entry[p]);
			var uniqueId = ifStatus.Port.InterfaceStatus.entry[p].Port;
			if (uniqueId.substr(0,2) == "Po"){
				continue;
			}
			var portNameParts = uniqueId.split('/');
			var switchNumber  = parseInt(portNameParts[switchNoIndexInName].substr(2)) || 1;
			var portNumber = parseInt(portNameParts[portNumberIndexInName]);
			var duplex = "auto";
			if(ifStatus.Port.InterfaceStatus.entry[p].Duplex.indexOf("full") >= 0){
				duplex = "full";
			} else if(ifStatus.Port.InterfaceStatus.entry[p].Duplex.indexOf("half") >= 0){
				duplex = "half";
			}
			var speed = 0;
			var status = 1;
			if(ifStatus.Port.InterfaceStatus.entry[p].Status === "disabled"){
				status = 2;
			} else if(ifStatus.Port.InterfaceStatus.entry[p].Status === "notconnect"){
				status= 0;
			} else if(ifStatus.Port.InterfaceStatus.entry[p].Status === "err-disabled"){
                                status= 3;
                        }
			if(status == 1){
				if(ifStatus.Port.InterfaceStatus.entry[p].Status.indexOf('1000')){
					speed = 1000;
				} else if (ifStatus.Port.InterfaceStatus.entry[p].Status.indexOf('100')){
					speed = 100;
				} else {
					speed = 10;
				}
			}
			
			var groupNoDiv = Math.floor(portNumber / groupSize);
			var groupNoMod = portNumber % groupSize;
			var groupNo = null;
			if(groupNoDiv == 0 && groupNoMod != 0){
				groupNo = groupNoDiv;
			} else if (groupNoDiv != 0 && groupNoMod == 0){
				groupNo = groupNoDiv-1; //last entry to go into the group
			} else{
				groupNo = groupNoDiv;
			}
			
			//Construct the port object
			var portObject = {};
			portObject.portNo = portNumber;
			portObject.uniqueId = uniqueId
			portObject.status = status;
			portObject.speed = speed;
			portObject.duplex = duplex;
			var isUplinkPort = (parseInt($rootScope.deviceInfo.numberOfPorts) % portNumber === parseInt($rootScope.deviceInfo.numberOfPorts));
			if(tempArray[p].poe == undefined && !isUplinkPort){ //No power on this port
				portObject.poe = false; //Set default, will be updated after fetching value
				portObject.power = 0; //Set default, will be updated after fetching value
			}else{
				portObject.poe = true; 
				portObject.power = tempArray[p].power;
			}
			
			if(isUplinkPort){
				//Entry goes into the uplink ports array
				switchViewData.switches[switchNumber-1].uplinkports.push(portObject);
			} else {
				//Entry goes into the ports array
				var subGroupNo = Math.ceil((portNumber % groupSize) /2);
				if(subGroupNo == 0){
					subGroupNo = groupSize/2;
				}
				var portPosition = (portNumber+1) % 2;
				
				//console.log("port"+groupNo+","+parseInt(subGroupNo-1)+","+portPosition+" is "+portObject);
				switchViewData.switches[switchNumber-1].ports[groupNo][subGroupNo-1][portPosition] = portObject;
			}
		
		}
		
		return switchViewData;
		
	};
}]);
