/**
 Description: Controller for Port Configuration
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.controller('PortsConfCtrl', ['$scope','$timeout','$filter','dataSourceService','portsDataSourceService','notificationService','validationService','requestRoutingService',
    function($scope,$timeout,$filter,dataSourceService,portsDataSourceService,notificationService,validationService,requestRoutingService) {
        var trimVal=$filter('trimValue');
		var translate = $filter("translate"),
        portsConfigGenCLI = "",
        portsConfigSetCLI = "",
        portsConfigAdvCLI = "";
        var portDetails, portInitialData ="";
        $scope.diableGenApplyButton=true;
        $scope.diableGenCancelButton=true;
        $scope.diableSetApplyButton=true;
        $scope.diableSetCancelButton=true;
        $scope.diableAdvApplyButton=true;
        $scope.diableAdvCancelButton=true;
		
		angular.extend($scope,{
			currentPortconfig: '',
            portsVoiceVlan: ""
		});

        var portGenValidations = angular.element("#portsConfigGenForm").kendoValidator({
                rules: {
                    check: function (input) {
                        return validationService.validateCheck(input);
                    },
                    space: function (input) {
                        return validationService.validateDataSpace(input);
                    },
                    range: function (input) {
                        return validationService.validateRange(input);
                    }
                }
            }).data("kendoValidator");

        var portSetValidations = angular.element("#portsConfigSetForm").kendoValidator({
            rules: {
                check: function (input) {
                    return validationService.validateCheck(input);
                },
                space: function (input) {
                    return validationService.validateDataSpace(input);
                },
                range: function (input) {
					if(input.val() != ""){
						var count=0;
						var valMsg = input.data('rangeMsg');
						if ((valMsg==undefined)) {
							return true;
						}
						var min= trimVal(input.prop('min'));
						var max= trimVal(input.prop('max'));
						var arr = input.val().replace('-',',');
						arr= arr.split(',');						
						for(var i=0;i<arr.length;i++){
							if(parseFloat(trimVal(arr[i]))>=min && parseFloat(trimVal(arr[i]))<=max) {
								count++;
							}
						}
						if(arr.length!=count){
							return false;
						}
						return true;
					}
					else return true;
				},
				checkVlanList:function(input){
					var valMsg = input.data('checkVlanListMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var regExp=/^[,-]+$/;
					var valStrHy=input.val().includes("--");
					var valStrCom=input.val().includes(",,");
					if(regExp.test(input.val()) || valStrHy || valStrCom || trim(input.val()) == "")
						return false;
					return true;
				}
            }
        }).data("kendoValidator");

        var portAdvValidations = angular.element("#portsConfigAdvForm").kendoValidator({
            rules: {
                check: function (input) {
                    return validationService.validateCheck(input);
                },
                space: function (input) {
                    return validationService.validateDataSpace(input);
                },
                range: function (input) {
					if(input.val() != ""){
						var count=0;
						var valMsg = input.data('rangeMsg');
						if ((valMsg==undefined)) {
							return true;
						}
						var min= trimVal(input.prop('min'));
						var max= trimVal(input.prop('max'));
						var arr = input.val().replace('-',',');
						arr= arr.split(',');						
						for(var i=0;i<arr.length;i++){
							if(parseFloat(trimVal(arr[i]))>=min && parseFloat(trimVal(arr[i]))<=max) {
								count++;
							}
						}
						if(arr.length!=count){
							return false;
						}
						return true;
					}
					else return true;
				}
            }
        }).data("kendoValidator");

        var getPortDetails= function(portno) {
            portDetails = portsDataSourceService.getPortData($scope.selectedPortId);
            portInitialData = angular.copy(portDetails);
            /*Display Values*/
            $scope.speedOptions = dataSourceService.speedOptions();
            $scope.duplexOptions = dataSourceService.duplexOptions();
            $scope.switchModeOptions = dataSourceService.switchModeOptions();
            $scope.stormControlOptions = dataSourceService.stormControlOptions();
            /*To Identify Actual Edit*/
            $scope.portsDuplex = null;
            $scope.switchMode = null;
            $scope.portsStormControlStorm = null;

            $timeout(function () {
                $scope.interfaceId = portDetails.PortId;
                
                //General config
                $scope.portsDescription = portDetails.Description ? portDetails.Description : "";
                $scope.portsOldDescription = portDetails.Description ? portDetails.Description : "";
                if(portDetails.runSpeed==undefined){
                     $scope.portsSpeed="auto";
                }else{
                     $scope.portsSpeed = portDetails.Speed;
                }
                if(portDetails.runDuplex==undefined){
                     $scope.portsDuplex="auto";
                }else{
                     $scope.portsDuplex = portDetails.Duplex;
                }               
                $scope.portsStatus = portDetails.Status === "disabled" ? translate("toggle_down") : translate("toggle_up");
                $scope.portsOldStatus = portDetails.Status === "disabled" ? translate("toggle_down") : translate("toggle_up");
                
                //port settings
                $scope.switchMode = portDetails.SwitchMode === "static access" ? "access" : portDetails.SwitchMode;
                $scope.switchOldMode = portDetails.SwitchMode === "static access" ? "access" : portDetails.SwitchMode;
                $scope.portsAccessVlan = portDetails.accessVlan;
                
                if (portDetails.voiceVlan!="none"){
                    $scope.portsVoiceVlan = portDetails.voiceVlan;
                    $scope.portsOldVoiceVlan = portDetails.voiceVlan;
                }
                else{
                    $scope.portsVoiceVlan = "";
                    $scope.portsOldVoiceVlan = "";
                }
                $scope.portsAllowedVlan = portDetails.vlanIDs === "ALL" ? "all" : "notall";
                $scope.portsOldAllowedVlan = portDetails.vlanIDs === "ALL" ? "all" : "notall";
                $scope.portsAllowedVlanId = portDetails.vlanIDs !== "ALL" ? portDetails.vlanIDs : "";
                $scope.portsOldAllowedVlanId = portDetails.vlanIDs !== "ALL" ? portDetails.vlanIDs : "";
                $scope.portsNativeVlan = portDetails.nativeVlan;
                
                if(portDetails.portfast=="disable" || portDetails.portfast==undefined){
                	 $scope.portsPortFast = translate("toggle_off");
                     $scope.portsOldPortFast = translate("toggle_off");
                }else{
                	$scope.portsPortFast = translate("toggle_on");
                    $scope.portsOldPortFast = translate("toggle_on");
                }
                if(portDetails.dhcpsnooping=="" || portDetails.dhcpsnooping==undefined){
               	 	$scope.portsDhcpSnooping = translate("com_disable");
                    $scope.portsOldDhcpSnooping = translate("com_disable");
                }else{
               	 	$scope.portsDhcpSnooping = translate("com_enable");
                    $scope.portsOldDhcpSnooping = translate("com_enable");
                } 
                
                //Advance config
                if(portDetails.stormControl == undefined){
                	$scope.portsStormControlStorm = "none";
                	$scope.portsOldStormControlStorm = "none";
                }else{
                	$scope.portsStormControlStorm = portDetails.stormControl;
                	$scope.portsOldStormControlStorm = portDetails.stormControl;
                }
                $scope.portsStormControlBroadcast = portDetails.broadcast;
                $scope.portsStormControlMulticast = portDetails.multicast;
                $scope.portsStormControlUnicast = portDetails.unicast;
            });
        };

        var interfaceData = requestRoutingService.getShowCmdOutput("show interfaces status", "showInterfacesStatus");
        interfaceData= interfaceData.ShowInterfacesStatus.wnwebdata.entry;
        $scope.selectedPortId = interfaceData[0].Port;
	$scope.currentPortconfig = $scope.selectedPortId;
        $scope.diableGenApplyButton=true;
        $scope.diableGenCancelButton=true;
        $scope.diableSetApplyButton=true;
        $scope.diableSetCancelButton=true;
        $scope.diableAdvApplyButton=true;
        $scope.diableAdvCancelButton=true;
        getPortDetails($scope.selectedPortId);

        $scope.$on('portSelected', function(event, args) {
            var selectedPort = args.object;
            console.log(selectedPort);
            $scope.selectedPortId = selectedPort.uniqueId;
            //Select the port in the grid
            $scope.diableGenApplyButton=true;
            $scope.diableGenCancelButton=true;
            $scope.diableSetApplyButton=true;
            $scope.diableSetCancelButton=true;
            $scope.diableAdvApplyButton=true;
            $scope.diableAdvCancelButton=true;
			
			$scope.currentPortconfig = $scope.selectedPortId;
			if (!$scope.$$phase)
				$scope.$apply();
			
            getPortDetails($scope.selectedPortId);
        });

        $scope.allowdVlanOnChange = function(){
            $scope.diableSetApplyButton = $scope.diableSetCancelButton = false;
            angular.element("#portsConfigSetForm  span.k-tooltip-validation").hide();
            $scope.portsAllowedVlanId = "";
        }

        $scope.isAllowedVlan = function () {
            return $scope.portsAllowedVlan === "notall" ? false : true;
        };

        $scope.validateDuplex = function () {
            var _selectedValue = $scope.portsSpeed;
            var duplValue = "half";
            if (_selectedValue === "1000") {
                duplValue = "full";
            }
            else {
                duplValue = $scope.portsDuplex;
            }
            $timeout(function () {
                $scope.portsDuplex = duplValue;
            }, 0);
        };
        angular.element("#duplex").on("focus", function (event,data) {
            $timeout(function(){
                $scope.validateDuplex(data);
            },0);
        });
        angular.element("#speed").on("focus", function (event,data) {
            $timeout(function(){
                $scope.validateDuplex(data);
            },0);
        });

        $scope.savePortsGenConf = function () {
        	var result="";
            if(portGenValidations.validate()) {
            	portsConfigGenCLI += "interface " + $scope.interfaceId + "\n";
            	if($scope.portsOldDescription!=$scope.portsDescription){
	                if ($scope.portsDescription !== "") {
	                    portsConfigGenCLI += "description " + $scope.portsDescription + "\n";
	                }
	                else {
	                    portsConfigGenCLI += "no description" + "\n";
	                }
                }
                
                //applying duplex and speed
            	if(portDetails.Speed!=$scope.portsSpeed){
	                if ($scope.portsSpeed != "") {
	                    portsConfigGenCLI += "speed " + $scope.portsSpeed + "\n";
	                }
            	}
            	if(portDetails.Duplex!=$scope.portsDuplex){
	                if ($scope.portsDuplex != "") {                	
	                	if (($scope.portsSpeed != "auto" || $scope.portsDuplex != "half") && ($scope.portsSpeed != "1000" || $scope.portsDuplex != "half")){
	                		portsConfigGenCLI += "duplex " + $scope.portsDuplex + "\n";
	                	}
	                }
            	}
                
                //applying port status
            	if($scope.portsOldStatus!=$scope.portsStatus){
	                if ($scope.portsStatus ===translate("toggle_up")) {
	                    portsConfigGenCLI += "no shutdown" + "\n";
	                }
	                else {
	                    portsConfigGenCLI += "shutdown" + "\n";
	                }
            	}
            }
            result = requestRoutingService.getConfigCmdOutput(portsConfigGenCLI);
            if (result == "") {
                   notificationService.showNotification(translate('portsconfig_success_msg'), translate('com_config_success_title'), 'success');
            } else {
                    notificationService.showNotification(result.errorResponse, translate('com_config_fail_title'), 'error');
            }

            portsConfigGenCLI = "";
            $scope.diableGenApplyButton=true;
            $scope.diableGenCancelButton=true;
            getPortDetails($scope.interfaceId);
        };
        $scope.cancelPortsGenConf = function () {
            $scope.portsDescription = portInitialData.Description;
            $scope.portsSpeed = portInitialData.Speed;
            $scope.portsDuplex = portInitialData.Duplex;
            $scope.portsStatus = portInitialData.Status === "connected" ? translate("toggle_up") : translate("toggle_down");
            $scope.diableGenCancelButton=true;
            $scope.diableGenApplyButton=true;
        };
        $scope.savePortsSetConf = function () {
        	var result="";
            if(portSetValidations.validate()) {
                portsConfigSetCLI += "interface " + $scope.interfaceId + "\n";
                
                if($scope.switchMode !== $scope.switchOldMode){
                  portsConfigSetCLI += "switchport mode " + $scope.switchMode + "\n";
                }
                
                if ($scope.switchMode === "access" || $scope.switchMode === "dynamic auto" || $scope.switchMode === "dynamic desirable") {
                    if($scope.portsAccessVlan !== portDetails.accessVlan){
                        portsConfigSetCLI += "switchport access vlan " + $scope.portsAccessVlan + "\n";
                    }
                    console.log($scope.portsVoiceVlan , $scope.portsOldVoiceVlan, $scope.portsVoiceVlan !== $scope.portsOldVoiceVlan)
                    if(($scope.portsVoiceVlan) && ($scope.portsVoiceVlan !== $scope.portsOldVoiceVlan)){
                        if($scope.portsVoiceVlan){
                            if ($scope.portsVoiceVlan != "" || $scope.portsVoiceVlan != 0 || $scope.portsVoiceVlan != undefined || $scope.portsVoiceVlan != "undefined") {
                                portsConfigSetCLI += "switchport voice vlan " + $scope.portsVoiceVlan + "\n";
                            }
                        }
                        else {
                            portsConfigSetCLI += "no switchport voice vlan" + "\n";
                        }
                    }
                }
                
                if ($scope.switchMode === "trunk" || $scope.switchMode === "dynamic auto" || $scope.switchMode === "dynamic desirable") {
                    if ($scope.portsAllowedVlan === "all") {
                        if($scope.portsAllowedVlan !== $scope.portsOldAllowedVlan){
                            portsConfigSetCLI += "switchport trunk allowed vlan all" + "\n";
                        }
                    }
                    else {
                        console.log($scope.portsAllowedVlanId , $scope.portsOldAllowedVlanId, "if---->",$scope.portsAllowedVlanId !== $scope.portsOldAllowedVlanId)
                        if($scope.portsAllowedVlanId !== $scope.portsOldAllowedVlanId){
                            if($scope.portsAllowedVlanId != "" || $scope.portsAllowedVlanId != 0){
                                portsConfigSetCLI += "switchport trunk allowed vlan " + $scope.portsAllowedVlanId + "\n";
                            }else{
                                portsConfigSetCLI += "no switchport trunk allowed vlan \n";
                            }
                        }
                    }

                    if($scope.portsNativeVlan !== portDetails.nativeVlan){
                        portsConfigSetCLI += "switchport trunk native vlan " + $scope.portsNativeVlan + "\n";
                    }
                }
                
                if($scope.portsPortFast !== $scope.portsOldPortFast){
                    if ($scope.portsPortFast === translate("toggle_on")) {
                        portsConfigSetCLI += "spanning-tree portfast" + "\n";
                    } else {
                        portsConfigSetCLI += "no spanning-tree portfast" + "\n";
                    }
                }
                
                if($scope.portsDhcpSnooping !== $scope.portsOldDhcpSnooping){
                    if ($scope.portsDhcpSnooping === translate("com_enable")) {
                        portsConfigSetCLI += "ip dhcp snooping trust" + "\n";
                    } else {
                        portsConfigSetCLI += "no ip dhcp snooping trust" + "\n";
                    }
                }

				
	  	      result = requestRoutingService.getConfigCmdOutput(portsConfigSetCLI);
                if (result == "" || result.errorResponse.indexOf("Access VLAN does not exist. Creating vlan")) {
                    notificationService.showNotification(translate('portsconfig_success_msg'), translate('com_config_success_title'), 'success');
                } else {
                    notificationService.showNotification(result.errorResponse, translate('com_config_fail_title'), 'error');
                }
				
            }
			else return false;
              

	        portsConfigSetCLI = "";
            $scope.diableSetApplyButton=true;
            $scope.diableSetCancelButton=true;
            getPortDetails($scope.interfaceId);
        };
        $scope.cancelPortsSetConf = function () {
            angular.element("#portsConfigSetForm  span.k-tooltip-validation").hide();
            $scope.switchMode = portInitialData.SwitchMode === "static access" ? "access" : portInitialData.SwitchMode;
            $scope.portsVoiceVlan = portInitialData.voiceVlan === "none" ? "" : portInitialData.voiceVlan;
            $scope.portsAccessVlan = portInitialData.accessVlan;
            $scope.portsAllowedVlan = portInitialData.vlanIDs === "ALL" ? "all" : "notall";
            $scope.portsAllowedVlanId = portInitialData.vlanIDs !== "ALL" ? portDetails.vlanIDs : "";
            $scope.portsNativeVlan = portInitialData.nativeVlan;
            $scope.portsPortFast = portInitialData.portfast ? translate("toggle_on") : translate("toggle_off");
            $scope.portsDhcpSnooping = portInitialData.dhcpsnooping ? translate("com_enable") : translate("com_disable");
            $scope.diableSetCancelButton=true;
            $scope.diableSetApplyButton=true;
        };
        $scope.savePortsAdvConf = function () {
        	var result="";
            if(portAdvValidations.validate()) {
                portsConfigAdvCLI += "interface " + $scope.interfaceId + "\n";
                
                if($scope.portsOldStormControlStorm!=$scope.portsStormControlStorm){
	                if ($scope.portsStormControlStorm === "shutdown") {
	                    portsConfigAdvCLI += "no storm-control action trap" + "\n";
	                    portsConfigAdvCLI += "storm-control action shutdown" + "\n";
	                }
	                else if ($scope.portsStormControlStorm === "trap") {
	                    portsConfigAdvCLI += "storm-control action trap" + "\n";
	                    portsConfigAdvCLI += "no storm-control action shutdown" + "\n";
	                }
	                else {
	                    portsConfigAdvCLI += "no storm-control action trap" + "\n";
	                    portsConfigAdvCLI += "no storm-control action shutdown" + "\n";
	                }
                }
                
                if(portDetails.broadcast!=$scope.portsStormControlBroadcast){
	                if ($scope.portsStormControlBroadcast !== "" && $scope.portsStormControlBroadcast != undefined) {
	                    portsConfigAdvCLI += "storm-control broadcast level " + $scope.portsStormControlBroadcast + "\n";
	                }
	                else {
	                    portsConfigAdvCLI += "no storm-control broadcast level " + "\n";
	                }
                }
                
                if(portDetails.multicast!=$scope.portsStormControlMulticast){
	                if ($scope.portsStormControlMulticast !== "" && $scope.portsStormControlMulticast != undefined) {
	                    portsConfigAdvCLI += "storm-control multicast level " + $scope.portsStormControlMulticast + "\n";
	                }
	                else {
	                    portsConfigAdvCLI += "no storm-control multicast level " + "\n";
	                }
                }
                
                if(portDetails.unicast!=$scope.portsStormControlUnicast){
	                if ($scope.portsStormControlUnicast !== "" && $scope.portsStormControlUnicast != undefined) {
	                    portsConfigAdvCLI += "storm-control unicast level " + $scope.portsStormControlUnicast + "\n";
	                }
	                else {
	                    portsConfigAdvCLI += "no storm-control unicast level " + "\n";
	                }
                }
				
				result = requestRoutingService.getConfigCmdOutput(portsConfigAdvCLI);
				if (result == "") {
					notificationService.showNotification(translate('portsconfig_success_msg'), translate('com_config_success_title'), 'success');
				} else {
					notificationService.showNotification(result.errorResponse, translate('com_config_fail_title'), 'error');
				}
            }
           else return false;
           

            portsConfigAdvCLI = "";
            $scope.diableAdvApplyButton=true;
            $scope.diableAdvCancelButton=true;
            getPortDetails($scope.interfaceId);
        };

        $scope.cancelPortsAdvConf = function () {
            $scope.portsStormControlStorm = portInitialData.stormControl === undefined ? "none" : portInitialData.stormControl;
            $scope.portsStormControlBroadcast = portInitialData.broadcast;
            $scope.portsStormControlMulticast = portInitialData.multicast;
            $scope.portsStormControlUnicast = portInitialData.unicast;
            $scope.diableAdvCancelButton=true;
            $scope.diableAdvApplyButton=true;
        };
    }
]);
