/**
 Description: Ports Monitoring Controller
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.controller('PortsMonitorCtrl', ['$scope', 'gridCrudService', '$filter','requestRoutingService', '$timeout',
    function ($scope, gridCrudService, $filter,requestRoutingService, $timeout) {

        var translate = $filter("translate");
        angular.extend($scope, {
            currentPort: ''
        });
        var interfaceStatusInfo = requestRoutingService.getShowCmdOutput("show interface status", "portsMonStatus");
        interfaceStatusInfo = interfaceStatusInfo.Port.InterfaceStatus.entry;
        interfaceStatusInfo = $.map(interfaceStatusInfo, function (value, index) {
            return [value];
        });

        var portTypeDetails = requestRoutingService.getShowCmdOutput("show running-config", "portsMonPortType");
        portTypeDetails = portTypeDetails.showRun.wnwebdata;
        var vlanIdDetails = new kendo.data.ObservableArray([]);
        for (var i in interfaceStatusInfo) {
            vlanIdDetails.push(interfaceStatusInfo[i].Vlan);
        }

	for (var i in interfaceStatusInfo){
            for (var j in portTypeDetails) {
            	var shortName = "";
            	try{
            		shortName = portTypeDetails[j].PortName.replace("GigabitEthernet","Gi");
            	} catch(e){
			console.log(e);
		}
            	if(shortName != interfaceStatusInfo[i].Port){
            		continue;
            	}
                if (portTypeDetails[j].mode == "trunk") {
                    interfaceStatusInfo[i].PortType = "Trunk";
		    var allowedVlan = requestRoutingService.getShowCmdOutput("show interfaces " + shortName + " switchport | i Trunking VLANs Enabled:");
                    //interfaceStatusInfo[i].Vlan= portTypeDetails[j].vlan;
                    interfaceStatusInfo[i].Vlan= allowedVlan.split(":")[1].trim();
                }
                else {
                    interfaceStatusInfo[i].PortType = "Access";
                }
            }
            if (interfaceStatusInfo[i].Status == "notconnect") {
                interfaceStatusInfo[i].Status = "not connected";
            }
        }

        var portsPowerInfo = requestRoutingService.getShowCmdOutput("show power inline", "portsMonPower");
        portsPowerInfo = portsPowerInfo.ShowPowerInline.PowerTable.entry;

        var powerData = new kendo.data.ObservableArray([]);
        for (var c in portsPowerInfo) {
            powerData.push(portsPowerInfo[c].Power);
        }
        powerData.shift();
        for (var d in interfaceStatusInfo) {
            interfaceStatusInfo[d].Power = powerData[d];
        }

        var portsPacketDropInfo = requestRoutingService.getShowCmdOutput("show interfaces summary", "portsMonPacketsDrop");
        portsPacketDropInfo = portsPacketDropInfo.ShowInterfaceSummary.PacketDrop.entry;
        portsPacketDropInfo = $.map(portsPacketDropInfo, function (value, index) {
            return [value];
        });

        var gigInterfaceData = new kendo.data.ObservableArray([]);
        var packetDropData = new kendo.data.ObservableArray([]);

        for (var b in portsPacketDropInfo) {
            if (portsPacketDropInfo[b].Interface.indexOf("Vlan")) {
                gigInterfaceData.push(portsPacketDropInfo[b]);
                packetDropData.push(parseInt(portsPacketDropInfo[b].IQD) + parseInt(portsPacketDropInfo[b].OQD));
            }
            else
                packetDropData.push("NA");
        }

        for (var d in interfaceStatusInfo) {
            interfaceStatusInfo[d].PktDrop = packetDropData[d];
        }

        var ethernetControllersInfo = requestRoutingService.getShowCmdOutput("show controllers ethernet-controller","portsMonEthernetController");
        ethernetControllersInfo = ethernetControllersInfo.ShowEthernetController.Transmit;

        var txbytesInfoData = new kendo.data.ObservableArray([]);

        for (var j in ethernetControllersInfo){
            txbytesInfoData.push(ethernetControllersInfo[j].totalBytesTransmit);
            for (var k in interfaceStatusInfo){
                interfaceStatusInfo[k].TxBytes= txbytesInfoData[k];
            }
        }

        var rxbytesInfoData = new kendo.data.ObservableArray([]);

        for (var m in ethernetControllersInfo){
            rxbytesInfoData.push(ethernetControllersInfo[m].totalBytesReceive);
            for (var n in interfaceStatusInfo){
                interfaceStatusInfo[n].RxBytes= rxbytesInfoData[n];
            }
        }

        $scope.portsDataSource = new kendo.data.DataSource({
            pageSize: 10,
            data: interfaceStatusInfo
        });

        var portsPacketTableInfo = [{
            "PortPackets": translate("ports_monitoring_total")
        }, {
            "PortPackets": translate("ports_monitoring_broadcast")
        }, {
            "PortPackets": translate("ports_monitoring_multicast")
        }, {
            "PortPackets": translate("ports_monitoring_crc_errors")
        }, {
            "PortPackets": translate("ports_monitoring_runts")
        }, {
            "PortPackets": translate("ports_monitoring_errors")
        }];

        var portsStatusTableInfo = [{
            "PortOtherStatus": translate("ports_monitoring_unidirectional_links")
        }, {
            "PortOtherStatus": translate("ports_monitoring_buffer_overflow")
        }, {
            "PortOtherStatus": translate("ports_monitoring_queue_drops")
        }, {
            "PortOtherStatus": translate("ports_monitoring_optics_intserted")
        }, {
            "PortOtherStatus": translate("ports_monitoring_loopback_enabled")
        }];


		


        var populateGridData = function(newport){
			$scope.currentPort = newport;
			if (!$scope.$$phase)
				$scope.$apply();
			
            var portsInterfacesInfo = requestRoutingService.getShowCmdOutput("show interfaces " + newport, "portsMonShowInterfaces");
            portsInterfacesInfo = portsInterfacesInfo.ShowInterfaces.InterfacesDetail.line;

            var ethernetControllerInfo = requestRoutingService.getShowCmdOutput("show controllers ethernet-controller " + newport, "portsMonEthernetController");
            ethernetControllerInfo = ethernetControllerInfo.ShowEthernetController.Transmit;

           var counterErrorsInfo= requestRoutingService.getShowCmdOutput("show interfaces "+ newport +" counters errors ", "portsMonCounterErrors");
           counterErrorsInfo = counterErrorsInfo.Port;
            counterErrorsInfo.crcReceived=counterErrorsInfo.InterfaceCounters1.entry.crcReceived;
            counterErrorsInfo.runtsReceived=counterErrorsInfo.InterfaceCounters2.entry.runtsReceived;

            var udldInfo = requestRoutingService.getShowCmdOutput("show udld " + newport, "portsMonUdld");
            udldInfo = udldInfo.ShowUdld.Port;

            var sfpInf="Not Present";
            var portsInventoryInfo = requestRoutingService.getShowCmdOutput("show inventory", "portsMonInventory");
            if (portsInventoryInfo.ShowInventory.InventoryEntry.length > 0) {
               for (var i in portsInventoryInfo.ShowInventory.InventoryEntry) {                	
                    intname = portsInventoryInfo.ShowInventory.InventoryEntry[i].ChassisName.replace(/\,/g,"");
                    sfpInfo = portsInventoryInfo.ShowInventory.InventoryEntry[i].Description.replace(/\,/g,"");
                    intname = portsInventoryInfo.ShowInventory.InventoryEntry[i].ChassisName.replace(/"/g,"");
                    sfpInfo = portsInventoryInfo.ShowInventory.InventoryEntry[i].Description.replace(/"/g,"");
                    if (intname.replace("GigabitEthernet","Gi").toLowerCase() == newport.toLowerCase())
                         sfpInf=sfpInfo;
              }
            }else{
            	 intname = portsInventoryInfo.ShowInventory.InventoryEntry.ChassisName.replace(/\,/g,"");
                 sfpInfo = portsInventoryInfo.ShowInventory.InventoryEntry.Description.replace(/\,/g,"");
                 intname = portsInventoryInfo.ShowInventory.InventoryEntry.ChassisName.replace(/"/g,"");
                 sfpInfo = portsInventoryInfo.ShowInventory.InventoryEntry.Description.replace(/"/g,"");
                 if (intname.replace("GigabitEthernet","Gi").toLowerCase() == newport.toLowerCase())
                      sfpInf=sfpInfo;
            }

            ethernetControllerInfo.packetsTotal = parseInt(ethernetControllerInfo.totalBytesTransmit) + parseInt(ethernetControllerInfo.totalBytesReceive);
            ethernetControllerInfo.broadcastFramesTotalData = parseInt(ethernetControllerInfo.broadcastFramesTransmit) + parseInt(ethernetControllerInfo.broadcastFramesReceive);
            ethernetControllerInfo.multicastFramesTotalData = parseInt(ethernetControllerInfo.multicastFramesTransmit) + parseInt(ethernetControllerInfo.multicastFramesReceive);
            portsInterfacesInfo.totalErrors = parseInt(portsInterfacesInfo.inputErrors) + parseInt(portsInterfacesInfo.outputErrors);

            if(udldInfo.uniDirectionalLinks=="Unknown"){
                udldInfo.uniDirectionalLinksState = "Yes";
            }
            else
                udldInfo.uniDirectionalLinksState = "No";

            if(portsInterfacesInfo.loopback =="not set")
                portsInterfacesInfo.loopbackinfo = "No";
            else
                portsInterfacesInfo.loopbackinfo = "Yes";

            var portsPacketTableInfo = [{
                "PortPackets": translate("ports_monitoring_total"),
                "TotalPackets": ethernetControllerInfo.packetsTotal,
                "SentPackets": ethernetControllerInfo.totalBytesTransmit,
                "ReceivedPackets":ethernetControllerInfo.totalBytesReceive
            }, {
                "PortPackets": translate("ports_monitoring_broadcast"),
                "TotalPackets": ethernetControllerInfo.broadcastFramesTotalData,
                "SentPackets": ethernetControllerInfo.broadcastFramesTransmit,
                "ReceivedPackets": ethernetControllerInfo.broadcastFramesReceive
            }, {
                "PortPackets": translate("ports_monitoring_multicast"),
                "TotalPackets": ethernetControllerInfo.multicastFramesTotalData,
                "SentPackets": ethernetControllerInfo.multicastFramesTransmit,
                "ReceivedPackets": ethernetControllerInfo.multicastFramesReceive
            }, {
                "PortPackets": translate("ports_monitoring_crc_errors"),
                "TotalPackets": portsInterfacesInfo.totalCRC,
                "SentPackets": "NA",
                "ReceivedPackets": counterErrorsInfo.crcReceived
            }, {
                "PortPackets": translate("ports_monitoring_runts"),
                "TotalPackets": portsInterfacesInfo.totalRunts,
                "SentPackets": "NA",
                "ReceivedPackets": counterErrorsInfo.runtsReceived
            }, {
                "PortPackets": translate("ports_monitoring_errors"),
                "TotalPackets": portsInterfacesInfo.totalErrors,
                "SentPackets":portsInterfacesInfo.outputErrors,
                "ReceivedPackets": portsInterfacesInfo.inputErrors
            }];
            angular.element("#portsPacketGrid").data('kendoGrid').dataSource.data([]);
            for (var i=0;i<portsPacketTableInfo.length; i++ ) {
                $scope.portsPacketGrid.dataSource.add({
                    "PortPackets":portsPacketTableInfo[i].PortPackets,
                    "TotalPackets": portsPacketTableInfo[i].TotalPackets,
                    "SentPackets": portsPacketTableInfo[i].SentPackets,
                    "ReceivedPackets": portsPacketTableInfo[i].ReceivedPackets
                });
            }


            var portsStatusTableInfo = [{
                "PortOtherStatus": translate("ports_monitoring_unidirectional_links"),
                "PortStatus": udldInfo.uniDirectionalLinksState
            }, {
                "PortOtherStatus": translate("ports_monitoring_buffer_overflow"),
                "PortStatus": portsInterfacesInfo.outputbuffers
            }, {
                "PortOtherStatus": translate("ports_monitoring_queue_drops"),
                "PortStatus": portsInterfacesInfo.queueDrops
            },  {
                "PortOtherStatus": translate("ports_monitoring_optics_intserted"),
                "PortStatus":sfpInf
            }, {
                "PortOtherStatus": translate("ports_monitoring_loopback_enabled"),
                "PortStatus": portsInterfacesInfo.loopbackinfo
            }];
            angular.element("#portsStatusGrid").data('kendoGrid').dataSource.data([]);
            for (var i=0;i<portsStatusTableInfo.length; i++ ) {
                $scope.portsStatusGrid.dataSource.add({
                    "PortOtherStatus":portsStatusTableInfo[i].PortOtherStatus,
                    "PortStatus": portsStatusTableInfo[i].PortStatus
                });
            }
        };

        function unpopulateGridData(){

            var portsPacketTableInfo = [{
                "PortPackets": translate("ports_monitoring_total"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets":""
            }, {
                "PortPackets": translate("ports_monitoring_broadcast"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets": ""
            }, {
                "PortPackets": translate("ports_monitoring_multicast"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets": ""
            }, {
                "PortPackets": translate("ports_monitoring_crc_errors"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets": ""
            }, {
                "PortPackets": translate("ports_monitoring_runts"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets": ""
            }, {
                "PortPackets": translate("ports_monitoring_errors"),
                "TotalPackets": "",
                "SentPackets":"",
                "ReceivedPackets": ""
            }];
            angular.element("#portsPacketGrid").data('kendoGrid').dataSource.data([]);
            for (var i=0;i<portsPacketTableInfo.length; i++ ) {
                $scope.portsPacketGrid.dataSource.add({
                    "PortPackets":portsPacketTableInfo[i].PortPackets,
                    "TotalPackets": portsPacketTableInfo[i].TotalPackets,
                    "SentPackets": portsPacketTableInfo[i].SentPackets,
                    "ReceivedPackets": portsPacketTableInfo[i].ReceivedPackets
                });
            }


            var portsStatusTableInfo = [{
                "PortOtherStatus": translate("ports_monitoring_unidirectional_links"),
                "PortStatus": ""
            }, {
                "PortOtherStatus": translate("ports_monitoring_buffer_overflow"),
                "PortStatus": ""
            }, {
                "PortOtherStatus": translate("ports_monitoring_queue_drops"),
                "PortStatus": ""
            },  {
                "PortOtherStatus": translate("ports_monitoring_optics_intserted"),
                "PortStatus":""
            }, {
                "PortOtherStatus": translate("ports_monitoring_loopback_enabled"),
                "PortStatus": ""
            }];
            angular.element("#portsStatusGrid").data('kendoGrid').dataSource.data([]);
            for (var i=0;i<portsStatusTableInfo.length; i++ ) {
                $scope.portsStatusGrid.dataSource.add({
                    "PortOtherStatus":portsStatusTableInfo[i].PortOtherStatus,
                    "PortStatus": portsStatusTableInfo[i].PortStatus
                });
            }
        };


            $scope.$on('portSelected', function(event, args) {
            var selectedPort = args.object;
             //Select the port in the grid
            if(selectedPort!=null) {
                populateGridData(selectedPort.uniqueId);
            }
            else{
            	$scope.currentPort = "";
                unpopulateGridData();
            }    
        });


        var showPortEdit = function () {
            var selected = this.dataItem(this.select());
            if(selected!=null) {
                var newport = selected.Port;
                populateGridData(newport);
            }
            else{
            	$scope.currentPort = "";
                unpopulateGridData();
            }

        };

        $scope.portsPacketDataSource = new kendo.data.DataSource({
            pageSize : 10,
            data : portsPacketTableInfo
        });

        $scope.portsStatusDataSource = new kendo.data.DataSource({
            pageSize : 10,
            data : portsStatusTableInfo
        });

        $scope.portsGridOptions = {
            editable: false,
            sortable: true,
            reorderable: true,
            change: showPortEdit,
            filterable: {
                extra: false,
                operators: {
                    string: {
                    	eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
                    }
                },
                messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
            },
            scrollable: false,
            selectable: true,
            pageable: {
            	messages: {
					  display: translate("com_page_display"), 
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),  
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
                previousNext: true,
                info: true,
                refresh: true,
                pageSizes: gridCrudService.grid_page_sizes,
                buttonCount: 5
            },
            columns: [{
                field: "Port",
                title: translate("ports_monitoring_description_switchport"),
                width:20
            }, {
                field: "Name",
                title: translate("ports_monitoring_description_desc"),
                width:20
            }, {
                field: "Status",
                title: translate("ports_monitoring_description_status"),
                width:20
            }, {
                field: "PortType",
                title: translate("ports_monitoring_description_porttype"),
                width:20
            }, {
                field: "Vlan",
                title: translate("ports_monitoring_description_vlanip"),
                width:20
            }, {
                field: "Duplex",
                title: translate("ports_monitoring_description_duplex"),
                width:20
            }, {
                field: "Power",
                title: translate("ports_monitoring_description_power"),
                width:20
            }, {
                field: "Speed",
                title: translate("ports_monitoring_description_speed"),
                width:20
            }, {
                field: "TxBytes",
                title: translate("ports_monitoring_description_txbytes"),
                width:20
            }, {
                field: "RxBytes",
                title: translate("ports_monitoring_description_rxbytes"),
                width:20
            }, {
                field: "PktDrop",
                title: translate("ports_monitoring_description_pktdrop"),
                width:20
            }]
        };

        $scope.portsPacketGridOptions = {
            editable: false,
            sortable: true,
            filterable: {
                extra: false,
                operators: {
                    string: {
                    	eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
                    }
                },
                messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
            },
            scrollable: false,
            selectable: true,
            columns: [{
                field: "PortPackets",
                title: translate("ports_monitoring_packets")
            }, {
                field: "TotalPackets",
                title: translate("ports_monitoring_total")
            }, {
                field: "SentPackets",
                title: translate("ports_monitoring_sent")
            }, {
                field: "ReceivedPackets",
                title: translate("ports_monitoring_received")
            }]
        };



        $scope.portsStatusGridOptions = {
            editable: false,
            sortable: true,
            filterable: {
                extra: false,
                operators: {
                    string: {
                    	eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
                    }
                },
                messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
            },
            scrollable: false,
            selectable: true,
            columns: [{
                field: "PortOtherStatus",
                title: translate("ports_monitoring_otherstatus"),
                width: "60%"
            }, {
                field: "PortStatus",
                title: translate("ports_monitoring_status"),
                width: "40%"
            }]
        };
    }
]);
