/**
 Description: STP Controller
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
'use strict';
app.controller('StpCtrl', ['$scope', '$filter', 'gridCrudService', 'dataSourceService', '$timeout', 'stpdataSourceService', 'notificationService', 'validationService','$window','dialogService','requestRoutingService',
    function ($scope, $filter, gridCrudService, dataSourceService, $timeout, stpdataSourceService, notificationService, validationService,$window,dialogService,requestRoutingService) {
        var translate = $filter("translate");
        
        /*Controller - Data & Actions For Switch Tab Starts*/
        var switchConfigDetails, switchInitialData;   
        $scope.mtuSizeDataSource = dataSourceService.mtuSizeOptions();
        $scope.initGridLoad = function () {
           switchConfigDetails = stpdataSourceService.getSwitchDetails();           
           //setting values
           $scope.switchConfigData = {
               hostName: switchConfigDetails.hostName,
               switchIp: switchConfigDetails.switchIp,
               managementVlan: switchConfigDetails.managementVlan,
               mtuSize: switchConfigDetails.mtuSize,
               subnetMask: switchConfigDetails.subnetMask,
               defaultGateway: switchConfigDetails.defaultGateway
           };
           $scope.diableApplyButton=true;           
           $timeout(function(){        	
        	   if(switchConfigDetails.mtuSize=="10240"){
        		   //$scope.switchConfigData.mtuSize = "jumbo";
        		   angular.element("#mtuSize").data('kendoDropDownList').value("jumbo");
        	   }else{
        		   //$scope.switchConfigData.mtuSize = switchConfigDetails.mtuSize;
        		   angular.element("#mtuSize").data('kendoDropDownList').value(switchConfigDetails.mtuSize);
        	   }
        	  
          },50);           
           switchInitialData = angular.copy(switchConfigDetails);
        };
        $scope.initGridLoad();
        
        //validation
        var stpValidations = angular.element("#stpForm").kendoValidator({
            rules: {
                validateip: function (input) {
                    return validationService.validateIPAddress(input);
                },
                dataspace: function (input) {
                    return validationService.validateDataSpace(input);
                }
            }
        }).data("kendoValidator");
        
        //save switch config into device
        var redirectionState=false;
        $scope.saveSwitchConfig = function () {
        	var cliHostNameCmd="";
            if (stpValidations.validate()) {
                if ($scope.switchConfigData.hostName !== switchInitialData.hostName) {
                      cliHostNameCmd+="hostname "+$scope.switchConfigData.hostName+"\n";
                }
                if ($scope.switchConfigData.switchIp !== switchInitialData.switchIp || $scope.switchConfigData.subnetMask !== switchInitialData.subnetMask) {
                      cliHostNameCmd+="int "+$scope.switchConfigData.managementVlan+"\n ip address "+$scope.switchConfigData.switchIp+" "+$scope.switchConfigData.subnetMask+"\n exit\n";
                }
                if ($scope.switchConfigData.managementVlan !== switchInitialData.managementVlan) {
                    cliHostNameCmd+="int "+switchInitialData.managementVlan+"\n no ip address \n exit\n";
                    cliHostNameCmd+="int "+$scope.switchConfigData.managementVlan+"\n ip address "+$scope.switchConfigData.switchIp+" "+$scope.switchConfigData.subnetMask+"\n exit\n";
                }
                if ($scope.switchConfigData.mtuSize !== switchInitialData.mtuSize) {
                      cliHostNameCmd+="system mtu "+$scope.switchConfigData.mtuSize+"\n";
                }
                if ($scope.switchConfigData.defaultGateway !== switchInitialData.defaultGateway) {
                      cliHostNameCmd+="ip default-gateway "+$scope.switchConfigData.defaultGateway+"\n";
                }
                if(cliHostNameCmd!=""){
                	var result = requestRoutingService.getConfigCmdOutput(cliHostNameCmd);
                	if(result==""){
                		notificationService.showNotification(translate('switch_success_msg'),translate('com_config_success_title'),'success');
                	}else{
                		notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
                	}
                }
                if($scope.switchConfigData.switchIp != switchInitialData.switchIp){                	 
                	 var baseUrl = window.location.origin;
                	 if(baseUrl.indexOf('https') > -1){
                		 $window.location.href = "https://"+ $scope.switchConfigData.switchIp + "/#/switch";  
                	 }else{
                		 $window.location.href = "http://"+ $scope.switchConfigData.switchIp + "/#/switch";  
                	 }
                }
    			$scope.diableApplyButton=true;
    			$scope.initGridLoad();
                switchInitialData = angular.copy($scope.switchConfigData);
            }
        };
        //cancel the changes
        $scope.cancelSwitchConfig = function () {
        	 $scope.diableApplyButton=true;
        	 $scope.switchConfigData.hostName=switchInitialData.hostName;
        	 $scope.switchConfigData.switchIp=switchInitialData.switchIp;
        	 $scope.switchConfigData.managementVlan=switchInitialData.managementVlan;
        	 $scope.switchConfigData.mtuSize=switchInitialData.mtuSize;
        	 $scope.switchConfigData.subnetMask=switchInitialData.subnetMask;
        	 $scope.switchConfigData.defaultGateway=switchInitialData.defaultGateway; 
        	 $scope.initGridLoad();
        };
        
        
        $scope.commonConfirmationSwitch = function() {
            $scope.dlgSwitch = dialogService.dialog({
                content : translate("msg_redirect_confirmation")+" "+$scope.switchConfigData.switchIp,
                title : translate("msg_redirect_confirmation_window"),
                messageType : "confirm",
                actionButtons : [{
                    text : translate("com_ok"),
                    callback : "pageRedirection"
                }, {
                    text : translate("com_cancel")
                }]
            });
        };
        $scope.$on("pageRedirection", function(event, data) {
            $scope.saveSwitchConfig($scope.dlgSwitch.data("kendoWindow"));
        });
        $scope.redirection= function(){
           if($scope.switchConfigData.switchIp != switchInitialData.switchIp){
        	   redirectionState=true;
        	   $scope.commonConfirmationSwitch();        	   
           }else{
        	   redirectionState=false; 
        	   $scope.saveSwitchConfig();
           }               
        };
      
        /*Controller - Data & Actions For Switch Tab Ends*/
        

        /*Controller - Data & Actions For STP Tab Starts*/
        /*Default Values*/
        var stpDefaultModeType = "rapid-pvst";
        /*To Identify Edited filed*/
        $scope.gridEdited = false;
        $scope.stpModeEdited = false;
        /*Display Values*/
        $scope.stpModeType = null;
        $scope.stpGridValues = [];
        $scope.stpPriorityOptions = dataSourceService.stpPriorityOptions();
        $scope.stpModeDataSource = dataSourceService.stpModeOptions();
        /*To Identify Actual Edit*/
        $scope.stpModeModel = null;
        $scope.editedVlanListValues = [];

        /*Enable and Disabling Cancel & Apply Buttons*/
        $scope.disableApplyButton = function () {
            return ($scope.stpModeEdited || $scope.gridEdited) ? false : true;
        };
        $scope.disableCancelButton = function () {
            return ($scope.stpModeEdited || $scope.gridEdited) ? false : true;
        };
        $timeout(function () {
            $scope.stpModeType = stpdataSourceService.getStpModeType() ? stpdataSourceService.getStpModeType() : stpDefaultModeType;
            $scope.stpModeModel = angular.copy($scope.stpModeType);
        }, 50);

        $scope.stpGridValues = stpdataSourceService.getVlanData();
        var deviceData = angular.copy($scope.stpGridValues);

        /*Kendo Grid-Data Values*/
        var hdrTmpbridgePriorityNum=translate("stp_bridgepriority") + " <tooltip helptext='" + translate("help_STP_bridge_priority_number") +"' position='top'></tooltip>";
        $scope.stpInstanceGridOptions = {
            editable: true,
            filterable: {
                extra : false,
                messages: {
                    isTrue: translate("com_enable"),
                    isFalse: translate("com_disable"),
                    info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
                },
                operators : {
                    string : {
                        eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
                    }
                }
            },
            sortable: true,
            pageable: {
            	messages: {
					  display: translate("com_page_display"), 
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),  
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
                refresh: true,
                pageSizes: gridCrudService.grid_page_sizes,
                buttonCount: 5
            },
            scrollable: true,
            selectable: true,
            columns: [{
                field: "vlanId",
                title: translate("stp_vlanid")
            }, {
                field: "vlanName",
                title: translate("stp_vlanname")
            }, {
                field: "hasSpanningTree",
                title: translate("stp_spanningtree"),
                template:'<span >#= hasSpanningTree === true ? "Enable" : "Disable" #</span>'
            }, {
            	 field: "bridgePriorityNumber",
                 title: translate("stp_bridgepriority"),
                 headerTemplate :hdrTmpbridgePriorityNum,
                 template: "#=bridgePriorityNumber#",
                 editor: function (container, options) {
                     var inlineEditSpanningTreeFlag = !options.model.hasSpanningTree;
                     container.append(angular.element('<select ng-disabled="' + inlineEditSpanningTreeFlag +
                     '" kendo-drop-down-list="stpPriority" name="stpPriority" id="stpPriority" k-data-source="stpPriorityOptions" k-data-text-field="\'name\'" k-data-value-field="\'value\'" data-bind="value:'
                     + options.field + '" ></select>'));
                 }
            }]
        };

       

        $scope.stpInstancedataSource = kendoGridObject($scope.stpGridValues);
        /*STP Mode Select*/
        $scope.updateStpMode = function () {        	
            if ( ($scope.stpModeModel) && ($scope.stpModeModel !== $scope.stpModeType)) {
                $scope.stpModeEdited = true;
            } else {
                $scope.stpModeEdited = false;
            }
        };
        /*Apply Button Click*/
        $scope.apply = function () {
        	var resultResponse=null;
            if ($scope.stpModeEdited) {
            	var stpCliCommand="spanning-tree mode ";
                stpCliCommand=stpCliCommand+$scope.stpModeType;
                resultResponse=requestRoutingService.getConfigCmdOutput(stpCliCommand);
                $timeout(function () {
                    $scope.stpModeType = stpdataSourceService.getStpModeType() ? stpdataSourceService.getStpModeType() : stpDefaultModeType;
                    $scope.stpModeModel = angular.copy($scope.stpModeType);
                }, 50);
                $scope.stpModeEdited = false;
            }
            if ($scope.gridEdited) {
                var editedObject = $scope.editedVlanListValues;
                resultResponse = stpdataSourceService.sendingVlanDataToDevice(editedObject);
                var updatedData = stpdataSourceService.getVlanData();
                var dataSource = kendoGridObject(updatedData);
                var grid = angular.element('#stpInstanceGrid').data('kendoGrid');
                dataSource.read();
                grid.setDataSource(dataSource);
                deviceData = angular.copy(dataSource);    
                
                $scope.gridEdited = false;
            }
            if(resultResponse==""){
        		notificationService.showNotification(translate('switch_success_msg'),translate('com_config_success_title'),'success');
        	}else{
        		notificationService.showNotification(resultResponse.errorResponse,translate('com_config_fail_title'),'error');
        	}
        };
        /*Cancel Button Click*/
        $scope.cancel = function () {
            if ($scope.stpModeEdited) {
                $scope.stpModeType = $scope.stpModeModel;
                $scope.stpModeEdited = false;
            }
            if ($scope.gridEdited) {
            	var updatedData = stpdataSourceService.getVlanData();
                var dataSource = kendoGridObject(updatedData);

                var grid = angular.element('#stpInstanceGrid').data('kendoGrid');
                dataSource.read();
                grid.setDataSource(dataSource);
                $scope.gridEdited = false;
            }
        };

        function kendoGridObject(dataValues) {
            var newOject = new kendo.data.DataSource({
                pageSize: 10,
                data: dataValues,
                batch: true,
                change: function (e) {
                    var dataList = this.data();
                    var editedVlanList = [];
                    for (var index = 0; index < dataList.length; index++) {
                        if (dataList[index].hasOwnProperty('dirty') && dataList[index].dirty == true) {
                            var editedObj = {};
                            editedObj["vlanId"] = dataList[index].vlanId;
                            editedObj["vlanName"] = dataList[index].vlanName;
                            editedObj["hasSpanningTree"] = dataList[index].hasSpanningTree;
                            editedObj["bridgePriorityNumber"] = dataList[index].bridgePriorityNumber;
                            editedVlanList.push(editedObj);
                        }
                    }
                    if (editedVlanList.length > 0) {
                        $scope.editedVlanListValues = editedVlanList;
                        $scope.gridEdited = true;
                    }
                },
                schema: {
                    model: {
                        id: "vlanId",
                        fields: {
                            vlanId: {
                                editable: false,
                                nullable: true
                            },
                            vlanName: {
                                editable: false,
                                nullable: true
                            },
                            hasSpanningTree: {
                                type: "boolean"
                            },
                            bridgePriorityNumber: {
                                
                            }
                        }
                    }
                }
            });
            return newOject;
        };
        /*Controller - Data & Actions For STP Tab Ends*/

    }
]);
