/**
 Description: Controller for Port Configuration
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.controller('PortsConfCtrl', ['$scope','$rootScope','$timeout','$filter','dataSourceService','portsDataSourceService','notificationService','validationService','requestRoutingService',
    function($scope,$rootScope,$timeout,$filter,dataSourceService,portsDataSourceService,notificationService,validationService,requestRoutingService) {
        var trimVal=$filter('trimValue');
		var translate = $filter("translate"),
        portsConfigGenCLI = "",
        portsConfigSetCLI = "",
        portsConfigAdvCLI = "";
        var portDetails, portInitialData ="";
        $scope.diableGenApplyButton=true;
        $scope.diableGenCancelButton=true;
        $scope.diableSetApplyButton=true;
        $scope.diableSetCancelButton=true;
        $scope.diableAdvApplyButton=true;
        $scope.diableAdvCancelButton=true;
		$scope.portMode = translate("com_switch");
        if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
        	$scope.showSeleconDetails=true;
        }
		
		if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
			$scope.visibleportMode = true;
		}
		angular.extend($scope,{
			currentPortconfig: '',
            portsVoiceVlan: ""
		});

         var portGenValidations = angular.element("#portsConfigGenForm").kendoValidator({
                rules: {
                    check: function (input) {
						var valMsg = input.data('checkMsg');
						if ((valMsg==undefined)) {
							return true;
						}
                        return validationService.validateCheck(input);
						
                    },
                    space: function (input) {
						var valMsg = input.data('spaceMsg');
						if ((valMsg==undefined)) {
							return true;
						}
                        return validationService.validateDataSpace(input);
                    },
                    range: function (input) {
						var valMsg = input.data('rangeMsg');
						if ((valMsg==undefined)) {
							return true;
						}
                        return validationService.validateRange(input);
                    },
					interfacerange:function(input){
						var valMsg = input.data('interfacerangeMsg');
						if ((valMsg==undefined)) {
							return true;
						}
						if($scope.intportConfDefault)
						{
							var fromVal = parseInt(angular.element("#intRangeFrom").val().split("/")[1]);
							var toVal = parseInt(angular.element("#accessPortsTo").val().split("/")[1]);
							if(toVal<fromVal)
								return false;
							
						}else return true;	
						return true;
					}

                }
            }).data("kendoValidator");

        var portSetValidations = angular.element("#portsConfigSetForm").kendoValidator({
            rules: {
                check: function (input) {
                    var valMsg = input.data('checkMsg');
                        if ((valMsg==undefined)) {
                            return true;
                        }
                    return validationService.validateCheck(input);
                },
                space: function (input) {
                    var valMsg = input.data('spaceMsg');
                        if ((valMsg==undefined)) {
                            return true;
                        }
                    return validationService.validateDataSpace(input);
                },
                range: function (input) {
					if(input.val() != ""){
						var count=0;
						var valMsg = input.data('rangeMsg');
						if ((valMsg==undefined)) {
							return true;
						}
						var min= trimVal(input.prop('min'));
						var max= trimVal(input.prop('max'));
						var arr = input.val().replace('-',',');
						arr= arr.split(',');						
						for(var i=0;i<arr.length;i++){
							if(parseFloat(trimVal(arr[i]))>=min && parseFloat(trimVal(arr[i]))<=max) {
								count++;
							}
						}
						if(arr.length!=count){
							return false;
						}
						return true;
					}
					else return true;
				},
				checkVlanList:function(input){
					var valMsg = input.data('checkVlanListMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var regExp=/^[,-]+$/;
					var valStrHy=input.val().includes("--");
					var valStrCom=input.val().includes(",,");
					if(regExp.test(input.val()) || valStrHy || valStrCom || trim(input.val()) == "")
						return false;
					return true;
				},
                vlancheck: function (input) {                                          
                    var valMsg = input.data('vlancheckMsg');
                    if ((valMsg==undefined)) 
                        return true;

                    /*if($scope.portsAllowedVlan == 'notall'){
                        if(input.val()==''){
                            return false;
                        }
                    }*/
                    return true 
                }
            }
        }).data("kendoValidator");

        var portAdvValidations = angular.element("#portsConfigAdvForm").kendoValidator({
            rules: {
                check: function (input) {
                    return validationService.validateCheck(input);
                },
                space: function (input) {
                    return validationService.validateDataSpace(input);
                },
                range: function (input) {
					if(input.val() != ""){
						var count=0;
						var valMsg = input.data('rangeMsg');
						if ((valMsg==undefined)) {
							return true;
						}
						var min= trimVal(input.prop('min'));
						var max= trimVal(input.prop('max'));
						var arr = input.val().replace('-',',');
						arr= arr.split(',');						
						for(var i=0;i<arr.length;i++){
							if(parseFloat(trimVal(arr[i]))>=min && parseFloat(trimVal(arr[i]))<=max) {
								count++;
							}
						}
						if(arr.length!=count){
							return false;
						}
						return true;
					}
					else return true;
				}
            }
        }).data("kendoValidator");
		
		$scope.portsStormControlStorm = null;
		$scope.autoQos = null;
        var getPortDetails= function(portno) {
			$scope.portNumIdentity = portno;
            portDetails = portsDataSourceService.getPortData($scope.selectedPortId);
            portInitialData = angular.copy(portDetails);
		$scope.speedDisable = false;
                $scope.duplexDisable = false;
            /*Display Values*/
            if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
				$scope.speedDisable = false;
				$scope.duplexDisable = false;
				if(portno.indexOf("Gi") !=-1) {
					$scope.speedOptions = dataSourceService.speedOptions(); 
					$scope.showSeleconDetails=false;
				}else  {
					$scope.speedOptions = dataSourceService.speedSeleconOptions();
					$scope.showSeleconDetails=true;
				}
            } else {
			$scope.speedOptions = dataSourceService.speedOptions();
                                var result = deviceCommunicator.getExecCmdOutput("show interface " + $scope.selectedPortId +" | i media type");
                                if(result.indexOf("Not Present") != -1 || result.indexOf("SFP") != -1){
                                        //Optical port
                                        var portNo = $scope.selectedPortId.substr($scope.selectedPortId.indexOf("/")-1);
                                        var inv = deviceCommunicator.getExecCmdOutput("show inventory | begin " + portNo);
                                        if(inv==""){
                                                //speed and duplex CANNOT be modified
                                                $scope.speedDisable = true;
                                                $scope.duplexDisable = true;
                                        }else{
                                                inv = inv.split("\n")[1];
                                                if(inv != undefined && inv.indexOf("GLC-T") != -1){
                                                        //speed and duplex CAN be modified
                                                } else {
                                                        //speed and duplex CANNOT be modified
                                                        $scope.speedDisable = true;
                                                        $scope.duplexDisable = true;
                                                }
                                        }
                                } else {
                                        //DO NOTHING
                                        //speed and duplex CAN be modified
                                }	
	    }
		/*
		else if($rootScope.deviceInfo.type.indexOf("C2960X")!=-1){
				$scope.speedOptions = dataSourceService.speedOptions();
				var portSplit = portno.split("/");
				var portIndex = portSplit[portSplit.length-1];
				var deviceIndex = $rootScope.deviceInfo.numberOfPorts;
				if(parseFloat(portIndex) > parseFloat(deviceIndex)) {
					$scope.speedDisable = true;
					$scope.duplexDisable = true;
				}else{
					$scope.speedDisable = false;
					$scope.duplexDisable = false;
				} 
				if(portno.indexOf("Te") !=-1) {
					$scope.speedDisable = true;
					$scope.duplexDisable = true;
				} 
			}else{
				$scope.speedDisable = false;
				$scope.duplexDisable = false;
				$scope.speedOptions = dataSourceService.speedOptions();
			}
           	*/	   
            $scope.autoNegoLimitOptions = dataSourceService.speedAutoOptions();
            $scope.duplexOptions = dataSourceService.duplexOptions();
            $scope.switchModeOptions = dataSourceService.switchModeOptions();
            $scope.stormControlOptions = dataSourceService.stormControlOptions();
            /*To Identify Actual Edit*/
            $scope.portsDuplex = null;
            $scope.switchMode = null;
            $timeout(function(){
                $scope.interfaceId = portDetails.PortId;
                
                //General config
                $scope.portsDescription = portDetails.Description ? portDetails.Description : "";
                $scope.portsOldDescription = portDetails.Description ? portDetails.Description : "";
                if(portDetails.runSpeed==undefined){
                     $scope.portsSpeed="auto";
                     $scope.portsOldSpeed="auto";
                     $scope.portsAutoSpeed="none";
                     $scope.portsOldAutoSpeed="none";
                     $scope.autoNegotiation=false;
                }else{
                	if(portDetails.runSpeed.indexOf("auto")!=-1){
                		speedArr=portDetails.runSpeed.split(" ");
                		if(speedArr.length>1){
                			$scope.portsSpeed=speedArr[0];
                			$scope.portsAutoSpeed=speedArr[1];
                			$scope.portsOldAutoSpeed=speedArr[1];
                		}else{
                			$scope.portsSpeed=portDetails.runSpeed;
                			$scope.portsAutoSpeed="none";
                			$scope.portsOldAutoSpeed="none";
                		}
                      	$scope.autoNegotiation=false;
                	}else{
                		$scope.portsSpeed = portDetails.Speed;
                		$scope.portsOldSpeed = portDetails.Speed;
                		$scope.portsAutoSpeed="none";
                		$scope.portsOldAutoSpeed="none";
                		$scope.autoNegotiation=true;
                   	}
                }
                
                $timeout(function(){
                    if(portDetails.runDuplex==undefined){
                        $scope.portsDuplex="auto";
                    }else{
                        $scope.portsDuplex = portDetails.Duplex;
                    } 
                },100);               
                $scope.portsStatus = portDetails.Status === "disabled" ? translate("toggle_down") : translate("toggle_up");
                $scope.portsOldStatus = portDetails.Status === "disabled" ? translate("toggle_down") : translate("toggle_up");
                
                //port settings
				$timeout(function(){
					$scope.switchMode = portDetails.SwitchMode === "static access" ? "access" : portDetails.SwitchMode;
				},500);
                
                $scope.switchOldMode = portDetails.SwitchMode === "static access" ? "access" : portDetails.SwitchMode;
                $scope.portsAccessVlan = portDetails.accessVlan;
                if (portDetails.voiceVlan!="none"){
                    $scope.portsVoiceVlan = portDetails.voiceVlan;
                    $scope.portsOldVoiceVlan = portDetails.voiceVlan;
                }
                else{
                    $scope.portsVoiceVlan = "";
                    $scope.portsOldVoiceVlan = "";
                }
                $scope.portsAllowedVlan = portDetails.vlanIDs === "ALL" ? "all" : "notall";
                $scope.portsOldAllowedVlan = portDetails.vlanIDs === "ALL" ? "all" : "notall";
                $scope.portsAllowedVlanId = portDetails.vlanIDs !== "ALL" ? portDetails.vlanIDs : "";
                $scope.portsOldAllowedVlanId = portDetails.vlanIDs !== "ALL" ? portDetails.vlanIDs : "";
                $scope.portsNativeVlan = portDetails.nativeVlan;
                
                if(portDetails.portfast=="disable" || portDetails.portfast==undefined){
                	 $scope.portsPortFast = translate("toggle_off");
                     $scope.portsOldPortFast = translate("toggle_off");
                }else{
                	$scope.portsPortFast = translate("toggle_on");
                    $scope.portsOldPortFast = translate("toggle_on");
                }
                if(portDetails.dhcpsnooping=="" || portDetails.dhcpsnooping==undefined){
               	 	$scope.portsDhcpSnooping = translate("com_disable");
                    $scope.portsOldDhcpSnooping = translate("com_disable");
                }else{
               	 	$scope.portsDhcpSnooping = translate("com_enable");
                    $scope.portsOldDhcpSnooping = translate("com_enable");
                } 
                if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
                	$scope.eveClassification=portDetails.eveClassification;
                	$scope.eveClassificationOld=portDetails.eveClassification;                	
                	$scope.perpetualPoE=portDetails.perpetualPoE;
                	$scope.perpetualPoEOld=portDetails.perpetualPoE;
                }
				//Advance config	
				if(portDetails.stormControl == undefined){
                	$scope.portsStormControlStorm = "none";
                	$scope.portsOldStormControlStorm = "none";
					angular.element("#stormControl").val("none");
                }else{
                	$scope.portsStormControlStorm = portDetails.stormControl;
                	$scope.portsOldStormControlStorm = portDetails.stormControl;
					angular.element("#stormControl").val(portDetails.stormControl);
                }
				
				
                $scope.portsStormControlBroadcast = portDetails.broadcast;
                $scope.portsStormControlMulticast = portDetails.multicast;
                $scope.portsStormControlUnicast = portDetails.unicast;
				
							
             if(  ($rootScope.deviceInfo.type.indexOf("C2960X") != -1 && $rootScope.deviceInfo.type.indexOf("-LL") == -1) ||
                  ($rootScope.deviceInfo.type.indexOf("C3560CX") != -1) ||
                  ($rootScope.deviceInfo.type.indexOf("2960C") != -1 && $rootScope.deviceInfo.type.indexOf("-S") == -1)  ||
                  ($rootScope.deviceInfo.type.indexOf("WS-C2960+") != -1 && $rootScope.deviceInfo.type.indexOf("-S") == -1) ||
                  ($rootScope.deviceInfo.type.indexOf("2960XR") != -1)  ||
                  ($rootScope.deviceInfo.type.indexOf("2960CX") != -1)  )   {
					
            	    $scope.portSettingDeviceL = false;
					$scope.portSettingDeviceX = true;
					$scope.autoQosOptions = dataSourceService.autoQosOptions();	
					if(portDetails.autoQOS == undefined){
						$scope.autoQos = "none";
						$scope.autoQosOld = "none";
						angular.element("#autoQosPolicy").val("none");
						
					}else{
						$scope.autoQos = portDetails.autoQOS;
						$scope.autoQosOld = portDetails.autoQOS;
						angular.element("#autoQosPolicy").val(portDetails.autoQOS);
					}				
				}else{
					$scope.portSettingDeviceL = true;
					$scope.portSettingDeviceX = false;
				}                				
            },50);
			
			//portMode
			$scope.isportMode = true;
			if($rootScope.deviceInfo.type.indexOf("C2960XR") != -1 || $rootScope.deviceInfo.type.indexOf("C3560CX") != -1){
				var findPortMode = requestRoutingService.getShowCmdOutput("show running-config interface "+ $scope.selectedPortId);
				if(findPortMode.indexOf("no switchport") != -1){
					$scope.isportMode = false;
					$scope.isportMode = false;
					$scope.portMode = translate("portconfig_port_routed");
				}else{
					$scope.isportMode = true;
					$scope.portMode = translate("com_switch");
				}
			}else {
				$scope.isportMode = true;
			}
        };

        var interfaceData = requestRoutingService.getShowCmdOutput("show interfaces status", "showInterfacesStatus");
        interfaceData= interfaceData.ShowInterfacesStatus.wnwebdata.entry;
        $scope.selectedPortId = interfaceData[0].Port;
		$scope.portNumIdentity = $scope.selectedPortId;
		$scope.currentPortconfig = $scope.selectedPortId;
        $scope.diableGenApplyButton=true;
        $scope.diableGenCancelButton=true;
        $scope.diableSetApplyButton=true;
        $scope.diableSetCancelButton=true;
        $scope.diableAdvApplyButton=true;
        $scope.diableAdvCancelButton=true;
        getPortDetails($scope.selectedPortId);

        $scope.$on('portSelected', function(event, args) {
            var selectedPort = args.object;
            $scope.portConfDefault = false;
            $scope.selectedPortId = selectedPort.uniqueId;
            //Select the port in the grid
            $scope.diableGenApplyButton=true;
            $scope.diableGenCancelButton=true;
            $scope.diableSetApplyButton=true;
            $scope.diableSetCancelButton=true;
            $scope.diableAdvApplyButton=true;
            $scope.diableAdvCancelButton=true;
			$scope.currentPortconfig = $scope.selectedPortId;
			if (!$scope.$$phase)
				$scope.$apply();
			
            getPortDetails($scope.selectedPortId);
        });

        $scope.allowdVlanOnChange = function(){
            $scope.diableSetApplyButton = $scope.diableSetCancelButton = false;
            angular.element("#portsConfigSetForm  span.k-tooltip-validation").hide();
            $scope.portsAllowedVlanId = "";
        }
        
        $scope.speedNegoOnChange = function(){
        	$scope.diableGenApplyButton = $scope.diableGenCancelButton= false;
            if($scope.portsSpeed=="auto"){
            	$scope.autoNegotiation=false;
            	$scope.portsAutoSpeed="none";
            }else{
            	$scope.autoNegotiation=true;
            	$scope.portsAutoSpeed="none";        		
            }    		
        }

        $scope.isAllowedVlan = function () {
            return $scope.portsAllowedVlan === "notall" ? false : true;
        };

        $scope.validateDuplex = function () {
            var _selectedValue = $scope.portsSpeed;
            var duplValue = "half";
            if (_selectedValue === "1000") {
                duplValue = "full";
            }
            else {
                duplValue = $scope.portsDuplex;
            }
            $timeout(function () {
                $scope.portsDuplex = duplValue;
            }, 0);
        };
        angular.element("#duplex").on("focus", function (event,data) {
            $timeout(function(){
                $scope.validateDuplex(data);
            },0);
        });
        angular.element("#speed").on("focus", function (event,data) {
            $timeout(function(){
                $scope.validateDuplex(data);
            },0);
        });

        $scope.savePortsGenConf = function () {
        	var result="";
            if(portGenValidations.validate()) {
            	portsConfigGenCLI += "interface " + $scope.interfaceId + "\n";

                if($scope.portConfDefault){
                    portsConfigGenCLI += "default interface " + $scope.interfaceId + "\n";
                }else{
                	if($scope.portsOldDescription!=$scope.portsDescription){
    	                if ($scope.portsDescription !== "") {
    	                    portsConfigGenCLI += "description " + $scope.portsDescription + "\n";
    	                }
    	                else {
    	                    portsConfigGenCLI += "no description" + "\n";
    	                }
                    }
                    
                    //applying duplex and speed
                   	if($scope.portsOldSpeed!=$scope.portsSpeed){
    	                if ($scope.portsSpeed != "") { 
							if($scope.speedDisable == false)   	                	
    	                		portsConfigGenCLI += "speed " + $scope.portsSpeed + "\n";    	                	
    	                }
                	}
                	if(portDetails.Duplex!=$scope.portsDuplex){
    	                if ($scope.portsDuplex != "") { 
    	                	if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
    	                		if($scope.currentPortconfig.indexOf("Gi") !=-1){
    	                			if (($scope.portsSpeed != "auto" || $scope.portsDuplex != "half") && ($scope.portsSpeed != "1000" || $scope.portsDuplex != "half") && ($scope.portsSpeed != "1000" || $scope.portsDuplex != "auto") ){
						if($scope.duplexDisable == false){
    	    	                			portsConfigGenCLI += "duplex " + $scope.portsDuplex + "\n";
						}
    	    	                	}
    	                		}else{
    	                		   portsConfigGenCLI += "duplex " + $scope.portsDuplex + "\n";
    	                		}
    	                	}else{
	    	                	if (($scope.portsSpeed != "auto" || $scope.portsDuplex != "half") && ($scope.portsSpeed != "1000" || $scope.portsDuplex != "half")){
									if($scope.duplexDisable == false)
										portsConfigGenCLI += "duplex " + $scope.portsDuplex + "\n";
	    	                	}
    	                	}
    	                }
                	}
                    
                    //applying port status
                	if($scope.portsOldStatus!=$scope.portsStatus){
    	                if ($scope.portsStatus ===translate("toggle_up")) {
    	                    portsConfigGenCLI += "no shutdown" + "\n";
    	                }
    	                else {
    	                    portsConfigGenCLI += "shutdown" + "\n";
    	                }
                	}
                }
				 result = requestRoutingService.getConfigCmdOutput(portsConfigGenCLI);
				if (result == "") {
					   notificationService.showNotification(translate('portsconfig_success_msg'), translate('com_config_success_title'), 'success');
				} else {
						notificationService.showNotification(result.errorResponse, translate('com_config_fail_title'), 'error');
				}

				portsConfigGenCLI = "";
				$scope.diableGenApplyButton=true;
				$scope.diableGenCancelButton=true;
				$scope.portConfDefault = false;
				getPortDetails($scope.interfaceId);
            }
           
        };
        $scope.cancelPortsGenConf = function () {
            $scope.portsDescription = portInitialData.Description;
            $scope.portsSpeed = portInitialData.Speed;
            $scope.portsDuplex = portInitialData.Duplex;
            $scope.portsStatus = portInitialData.Status === "connected" ? translate("toggle_up") : translate("toggle_down");
            $scope.diableGenCancelButton=true;
            $scope.diableGenApplyButton=true;
            $scope.portConfDefault = false;
        };
        $scope.savePortsSetConf = function () {

            var result="", portsConfigSetCLI = "", portModeConfigSetCLI="";				
			if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
				if ($scope.portMode == translate("portconfig_port_routed")) {
					portModeConfigSetCLI += "interface " + $scope.interfaceId + "\n";
					portModeConfigSetCLI += "no switchport \n";
					
					result = requestRoutingService.getConfigCmdOutput(portModeConfigSetCLI);
					if (result == "") {
						notificationService.showNotification(translate('portsconfig_success_msg'), translate('com_config_success_title'), 'success');
					} else {
						notificationService.showNotification(result.errorResponse, translate('com_config_fail_title'), 'error');
					}
					portModeConfigSetCLI = "";
					$scope.diableSetApplyButton=true;
					$scope.diableSetCancelButton=true;
					getPortDetails($scope.interfaceId);
				}
			}
			if($scope.portMode === translate("com_switch")){				
				if(portSetValidations.validate()) {
					portsConfigSetCLI += "interface " + $scope.interfaceId + "\n";
					if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
						portsConfigSetCLI += "switchport \n";
					}
					if($scope.switchMode !== $scope.switchOldMode){
						portsConfigSetCLI += "switchport mode " + $scope.switchMode + "\n";
					}
					
					if ($scope.switchMode === "access" || $scope.switchMode === "dynamic auto" || $scope.switchMode === "dynamic desirable") {
						
						if($scope.portsAccessVlan !== portDetails.accessVlan){
							if($scope.portsAccessVlan != undefined){
								portsConfigSetCLI += "switchport access vlan " + $scope.portsAccessVlan + "\n";
							}
							else {
								portsConfigSetCLI += "no switchport access vlan " + portDetails.accessVlan + "\n";
							}
						}

						if($scope.portsVoiceVlan !== $scope.portsOldVoiceVlan){
							if($scope.portsVoiceVlan != undefined){
								if ($scope.portsVoiceVlan != "" || $scope.portsVoiceVlan != 0 || $scope.portsVoiceVlan != undefined || $scope.portsVoiceVlan != "undefined") {
									portsConfigSetCLI += "switchport voice vlan " + $scope.portsVoiceVlan + "\n";
								}
							}
							else {
								portsConfigSetCLI += "no switchport voice vlan" + "\n";
							}
						}
					}
					
					if ($scope.switchMode === "trunk" || $scope.switchMode === "dynamic auto" || $scope.switchMode === "dynamic desirable") {
						if ($scope.portsAllowedVlan === "all") {
							if($scope.portsAllowedVlan !== $scope.portsOldAllowedVlan){
								if($scope.portsAllowedVlan != undefined)
								portsConfigSetCLI += "switchport trunk allowed vlan all" + "\n";
							}
						}
						else {
							if($scope.portsAllowedVlanId !== $scope.portsOldAllowedVlanId){
								if(($scope.portsAllowedVlanId != "" || $scope.portsAllowedVlanId != 0)){
									if($scope.portsAllowedVlanId != undefined )
									portsConfigSetCLI += "switchport trunk allowed vlan " + $scope.portsAllowedVlanId + "\n";
								}else{
									portsConfigSetCLI += "no switchport trunk allowed vlan \n";
								}
							}
						}

						if($scope.portsNativeVlan !== portDetails.nativeVlan){
							if($scope.portsNativeVlan){
								portsConfigSetCLI += "switchport trunk native vlan " + $scope.portsNativeVlan + "\n";
							}else{
								portsConfigSetCLI += "no switchport trunk native vlan \n";
							}
						}
					}
					if($scope.portsPortFast !== $scope.portsOldPortFast){
						if ($scope.portsPortFast === translate("toggle_on")) {
							portsConfigSetCLI += "spanning-tree portfast" + "\n";
						} else {
							portsConfigSetCLI += "no spanning-tree portfast" + "\n";
						}
					}
					
					if($scope.portsDhcpSnooping !== $scope.portsOldDhcpSnooping){
						if ($scope.portsDhcpSnooping === translate("com_enable")) {
							portsConfigSetCLI += "ip dhcp snooping trust" + "\n";
						} else {
							portsConfigSetCLI += "no ip dhcp snooping trust" + "\n";
						}
					}
					
					//if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
						if($scope.eveClassification !== $scope.eveClassificationOld) {
							if ($scope.eveClassification) {
								portsConfigSetCLI+="power inline port 2-event \n";
							}else{
								portsConfigSetCLI+="no power inline port 2-event \n";
							}
						}
						if($scope.perpetualPoE !== $scope.perpetualPoEOld) {
							if ($scope.perpetualPoE) {
								portsConfigSetCLI+="power inline port poe-ha \n";
							}else{
								portsConfigSetCLI+="no power inline port poe-ha \n";
							}
						}
				   // }
				  result = requestRoutingService.getConfigCmdOutput(portsConfigSetCLI);
					if (result == "" || result.errorResponse.indexOf("Access VLAN does not exist. Creating vlan")) {
						notificationService.showNotification(translate('portsconfig_success_msg'), translate('com_config_success_title'), 'success');
					} else {
						notificationService.showNotification(result.errorResponse, translate('com_config_fail_title'), 'error');
					}
					 portsConfigSetCLI = "";
					$scope.diableSetApplyButton=true;
					$scope.diableSetCancelButton=true;
					getPortDetails($scope.interfaceId);
					
				}
				else return false;
			}
           
        };
        $scope.cancelPortsSetConf = function () {
            angular.element("#portsConfigSetForm  span.k-tooltip-validation").hide();
            $scope.switchMode = portInitialData.SwitchMode === "static access" ? "access" : portInitialData.SwitchMode;
            $scope.portsVoiceVlan = portInitialData.voiceVlan === "none" ? "" : portInitialData.voiceVlan;
            $scope.portsAccessVlan = portInitialData.accessVlan;
            $scope.portsAllowedVlan = portInitialData.vlanIDs === "ALL" ? "all" : "notall";
            $scope.portsAllowedVlanId = portInitialData.vlanIDs !== "ALL" ? portDetails.vlanIDs : "";
            $scope.portsNativeVlan = portInitialData.nativeVlan;
            $scope.portsPortFast = portInitialData.portfast ? translate("toggle_on") : translate("toggle_off");
            $scope.portsDhcpSnooping = portInitialData.dhcpsnooping ? translate("com_enable") : translate("com_disable");
            $scope.diableSetCancelButton=true;
            $scope.diableSetApplyButton=true;
			if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
				$scope.portMode = $scope.portMode ? translate("com_switch") : translate("portconfig_port_routed");
				getPortDetails($scope.selectedPortId);
			}
        };
		
		$scope.changePortMode = function(){
			$scope.diableSetApplyButton  = false;
			$scope.diableSetCancelButton = false;
			// Port Mode
			if($rootScope.deviceInfo.type.indexOf("C2960XR") != -1 || $rootScope.deviceInfo.type.indexOf("C3560CX") != -1){
				if($scope.portMode == translate("portconfig_port_routed")){
					$scope.isportMode = false;
				}else{					
					$scope.switchMode = "access";
					$scope.isportMode = true;
				} 
			}
		};
		
        $scope.savePortsAdvConf = function () {
        	var result="";
            if(portAdvValidations.validate()) {
                portsConfigAdvCLI += "interface " + $scope.interfaceId + "\n";
                
                if($scope.portsOldStormControlStorm!=$scope.portsStormControlStorm){
	                if ($scope.portsStormControlStorm === "shutdown") {
	                    portsConfigAdvCLI += "no storm-control action trap" + "\n";
	                    portsConfigAdvCLI += "storm-control action shutdown" + "\n";
	                }
	                else if ($scope.portsStormControlStorm === "trap") {
	                    portsConfigAdvCLI += "storm-control action trap" + "\n";
	                    portsConfigAdvCLI += "no storm-control action shutdown" + "\n";
	                }
	                else {
	                    portsConfigAdvCLI += "no storm-control action trap" + "\n";
	                    portsConfigAdvCLI += "no storm-control action shutdown" + "\n";
	                }
                }
                
                if(portDetails.broadcast!=$scope.portsStormControlBroadcast){
	                if ($scope.portsStormControlBroadcast !== "" && $scope.portsStormControlBroadcast != undefined) {
	                    portsConfigAdvCLI += "storm-control broadcast level " + $scope.portsStormControlBroadcast + "\n";
	                }
	                else {
	                    portsConfigAdvCLI += "no storm-control broadcast level " + "\n";
	                }
                }
                
                if(portDetails.multicast!=$scope.portsStormControlMulticast){
	                if ($scope.portsStormControlMulticast !== "" && $scope.portsStormControlMulticast != undefined) {
	                    portsConfigAdvCLI += "storm-control multicast level " + $scope.portsStormControlMulticast + "\n";
	                }
	                else {
	                    portsConfigAdvCLI += "no storm-control multicast level " + "\n";
	                }
                }
                
                if(portDetails.unicast!=$scope.portsStormControlUnicast){
	                if ($scope.portsStormControlUnicast !== "" && $scope.portsStormControlUnicast != undefined) {
	                    portsConfigAdvCLI += "storm-control unicast level " + $scope.portsStormControlUnicast + "\n";
	                }
	                else {
	                    portsConfigAdvCLI += "no storm-control unicast level " + "\n";
	                }
                }
				if($scope.autoQosOld!=$scope.autoQos){
                  if($scope.autoQos=="none"){
					  portsConfigAdvCLI += "no auto qos " +$scope.autoQosOld+"\n";
				  }
				  else{
					  if($scope.autoQosOld!="none"){
						portsConfigAdvCLI += "no auto qos " +$scope.autoQosOld+ "\n";							
					  }		
						portsConfigAdvCLI += "auto qos " +$scope.autoQos+ "\n";	
						portsConfigAdvCLI += "exit \n";	

						portsConfigAdvCLI+="mls qos map policed-dscp  0 10 18 24 46 to 8\n";
						portsConfigAdvCLI+="mls qos map cos-dscp 0 8 16 24 32 46 48 56\n";
						portsConfigAdvCLI+="mls qos srr-queue output cos-map queue 1 threshold 3 4 5\n";
						portsConfigAdvCLI+="mls qos srr-queue output cos-map queue 2 threshold 1 2\n";
						portsConfigAdvCLI+="mls qos srr-queue output cos-map queue 2 threshold 2 3\n";
						portsConfigAdvCLI+="mls qos srr-queue output cos-map queue 2 threshold 3 6 7\n";
						portsConfigAdvCLI+="mls qos srr-queue output cos-map queue 3 threshold 3 0\n";
						portsConfigAdvCLI+="mls qos srr-queue output cos-map queue 4 threshold 3 1\n";
						portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 1 threshold 3 32 33 40 41 42 43 44 45\n";
						portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 1 threshold 3 46 47\n";
						portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 2 threshold 1 16 17 18 19 20 21 22 23\n";
						portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 2 threshold 1 26 27 28 29 30 31 34 35\n";
						portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 2 threshold 1 36 37 38 39\n";
						portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 2 threshold 2 24\n";
						portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 2 threshold 3 48 49 50 51 52 53 54 55\n";
						portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 2 threshold 3 56 57 58 59 60 61 62 63\n";
						portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 3 threshold 3 0 1 2 3 4 5 6 7\n";
						portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 4 threshold 1 8 9 11 13 15\n";
						portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 4 threshold 2 10 12 14\n";
						portsConfigAdvCLI+="mls qos queue-set output 1 threshold 1 100 100 50 200\n";
						portsConfigAdvCLI+="mls qos queue-set output 1 threshold 2 125 125 100 400\n";
						portsConfigAdvCLI+="mls qos queue-set output 1 threshold 3 100 100 100 400\n";
						portsConfigAdvCLI+="mls qos queue-set output 1 threshold 4 60 150 50 200\n";
						portsConfigAdvCLI+="mls qos queue-set output 1 buffers 15 25 40 20\n";
						portsConfigAdvCLI+="mls qos\n";				
				  }				
				}
									
				result = requestRoutingService.getConfigCmdOutput(portsConfigAdvCLI);
				if (result == "") {
					notificationService.showNotification(translate('portsconfig_success_msg'), translate('com_config_success_title'), 'success');
				} else {
					notificationService.showNotification(result.errorResponse, translate('com_config_fail_title'), 'error');
				}
				portsConfigAdvCLI = "";
				$scope.diableAdvApplyButton=true;
				$scope.diableAdvCancelButton=true;
				getPortDetails($scope.interfaceId);
            }
           else return false;
           
           
        };

        $scope.cancelPortsAdvConf = function () {
            $scope.portsStormControlStorm = portInitialData.stormControl === undefined ? "none" : portInitialData.stormControl;
            $scope.portsStormControlBroadcast = portInitialData.broadcast;
            $scope.portsStormControlMulticast = portInitialData.multicast;
            $scope.portsStormControlUnicast = portInitialData.unicast;
            $scope.diableAdvCancelButton=true;
            $scope.diableAdvApplyButton=true;
        };
    }
]);
