/**
 Description: system-Time/NTP Server Controller
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
'use strict';
app.controller('SystemCtrl', ['$scope','$filter','$timeout','validationService','requestRoutingService','dataSourceService','notificationService','gridCrudService','getLocalCalendar','getLocalDayMonth','getMonthIndex',
	function($scope,$filter,$timeout, validationService,requestRoutingService,dataSourceService,notificationService,gridCrudService,getLocalCalendar,getLocalDayMonth,getMonthIndex) {
		var translate = $filter("translate");

		// System Time Configuration
		$scope.currentdate = "";
		$scope.disableApplyButton = true;
		$scope.displayHostnameType = false;

		$scope.timeZoneNameOptions = dataSourceService.timeZoneNameOptions();
		$scope.offsetHoursDataSource = dataSourceService.offsetHoursDataSource();
		$scope.offsetMinutesDataSource = dataSourceService.offsetMinutesDataSource();

		$scope.systemModel = {
			setDate: '',
			setTime: '',
			settimezoneName: 'UTC',
			setOffsetHours: '-23',
			setOffsetMinutes: '0'
		};

		$scope.loadGridData = function () {
			var showTIME = requestRoutingService.getShowCmdOutput("show clock");
			var showTimeSource = requestRoutingService.getShowCmdOutput("show ntp status");
			
			// converting the device date to ISO 8601 format
			var getTime = showTIME.split(" ");
			var getMonthNum = getMonthIndex.monthIndex(getTime[3]);
			var dayFormat = getTime[4].toString().length < 2 ? '0' + getTime[4] : getTime[4];
			var newArr = getTime[5]+"-"+getMonthNum+"-"+dayFormat+" "+getTime[0]+" "+getTime[1];
			showTIME = newArr;
			
			$scope.currentdate = showTIME;
			$scope.setDate = $scope.dateValue;
						
			var splitCurremtData = $scope.currentdate.split(" ");
			var splitDate = splitCurremtData[3]+" "+splitCurremtData[4]+" "+splitCurremtData[5];
			var splitTime = splitCurremtData[0];
			$scope.setDate = splitDate;
			var splitTime = splitCurremtData[0];
			$scope.setTime = splitTime;
			var todayDate = new Date();

			$scope.timesource = showTimeSource;
			var splitCurremtData = $scope.timesource.split("\n");
			var temp = {};
			temp.timesourceName = "None";
			$scope.timesource = "NTP";
			if (splitCurremtData[0].indexOf("Clock is synchronized") > -1) {
				var splitVrf = splitCurremtData[0].split("Clock is synchronized ");
				temp.timesourceName = splitVrf[0];
				if(temp.timesourceName.indexOf("Clock is synchronized")>-1)	{
					$scope.timesource = "NTP";
				}else{
					$scope.timesource = translate('system_time_local');
				}
			}else{
				$scope.timesource = translate('system_time_local');
			}
			var cultureName = "";			
			$timeout(function(){			
				if(navigator.language.indexOf("zh") != -1 || angular.element("#languageSelector").val() == "zh"){
					cultureName = kendo.culture("zh");
				}
				else if(navigator.language.indexOf("ko") != -1 || angular.element("#languageSelector").val() == "ko"){
					cultureName = kendo.culture("ko");
				}
				else if(navigator.language.indexOf("ja") != -1 || angular.element("#languageSelector").val() == "ja"){
					cultureName = kendo.culture("ja");
				}	
				angular.element("#date").kendoDatePicker({
					value: todayDate, //setting current date as default date
					format: "yyyy-MM-dd",
					change: function() {
						$timeout(function(){$scope.disableApplyButton = false;});
					},
					culture: cultureName
				});
			},1000);

			angular.element("#time").kendoTimePicker({
				value: "00:00:00", //setting default time
				format: "HH:mm:ss",
				change: function() {
					$timeout(function(){$scope.disableApplyButton = false;});
				}
			});
			angular.element('input').removeAttr('style'); 
		};

		$scope.init = function(){
			$scope.loadGridData();
			$scope.disableApplyButton = true;
		};
		
		$scope.tabTog = function(){
			angular.element('#myTabSys').find('li').removeClass('k-state-default');
		}


		$scope.apply = function() {
			var generalsystemCLI = "";
			if($scope.systemModel["setOffsetMinutes"]!="0") {
				generalsystemCLI = "clock timezone " +$scope.systemModel["settimezoneName"] +" " +$scope.systemModel["setOffsetHours"]+" " +$scope.systemModel["setOffsetMinutes"] +"\n";
			}
			else {
				generalsystemCLI = "clock timezone " + $scope.systemModel["settimezoneName"] + " " + $scope.systemModel["setOffsetHours"] + "\n";
			}
			var datepicker = angular.element("#date").data("kendoDatePicker");			
			//var setDate = getLocalCalendar.getLocalDate(datepicker._oldText);
			var setDate = datepicker._oldText;
			setDate=$filter('date')(new Date(setDate), 'dd MMMM yyyy');			
			var timepicker = angular.element("#time").data("kendoTimePicker");
			var setTime = timepicker._oldText;
			generalsystemCLI += "do-exec clock set "+setTime+" "+setDate+"\n";

			var result = requestRoutingService.getConfigCmdOutput(generalsystemCLI);
			if(result==""){
				notificationService.showNotification(translate('system_success_msg'),translate('com_config_success_title'),'success');
				$scope.loadGridData();
			}else{
				notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
			}
			$scope.disableApplyButton = true;
		};

		$scope.cancel = function () {
			$scope.loadGridData();
			$scope.disableApplyButton = true;
		};

		// NTP Server Configuration
		var trimVal=$filter('trimValue');
		var vlanOptions=[];
		var interfaceOptions=[];
		var vrfOptions=[];
		$scope.validateHostNameMsg='';
		var ntpList = requestRoutingService.getShowCmdOutput("show ntp config","showNtpConfig");
		if(ntpList.ShowNtp.entry)
			ntpList=ntpList.ShowNtp.entry;
		else ntpList=ntpList.ShowNtp;
		if (typeof ntpList == "object" && !ntpList.length)
			ntpList = [ntpList];
		var ntpGridDataList=[];
		for(var i=0;i<ntpList.length;i++){
			var sourceAdress='';
			var hostName='';
			if(ntpList[i].hostName){
				if(ntpList[i].hostName=="ip"){
					hostName=ntpList[i].hostNameIP;
					if(ntpList[i].IPInterface)
						sourceAdress=ntpList[i].IPInterface;
					else sourceAdress="None"
				}
				else if(ntpList[i].hostName=="ipv6"){
					hostName=ntpList[i].hostNameIPv6;
					if(ntpList[i].IPv6Interface)
						sourceAdress=ntpList[i].IPv6Interface;
					else sourceAdress="None"
				} else {
					hostName=ntpList[i].hostName;
					if(ntpList[i].hostNameIP2)
						sourceAdress=ntpList[i].hostNameIP2;
					else if(ntpList[i].hostNameIP)
						sourceAdress=ntpList[i].hostNameIP;
					else sourceAdress="None"
				}
				var ntpStatusTemp = requestRoutingService.getShowCmdOutput("show ntp status");
				if(ntpStatusTemp.indexOf("Clock is unsynchronized") > -1)
					ntpStatusTemp="Unsynchronized"
				else ntpStatusTemp="Synchronized"
					var sourceAdd;
					if(sourceAdress.indexOf("GigabitEthernet")!=-1){
						sourceAdd = sourceAdress.replace("GigabitEthernet","Gi");
					}else if(sourceAdress.indexOf("FastEthernet")!=-1){
						sourceAdd = sourceAdress.replace("FastEthernet","Fa");
					}else if(sourceAdress.indexOf("TenGigabitEthernet")!=-1){
						sourceAdd = sourceAdress.replace("TenGigabitEthernet","Te");
					}else{
						sourceAdd = sourceAdress;
					}
				ntpGridDataList.push({
					"HostName": hostName,
					"VRFName": "None",
					"SourceAddress": sourceAdd, //sourceAdress.replace("GigabitEthernet","Gi"),
					"Status": ntpStatusTemp});
			}
		}
		$scope.ntpData=new kendo.data.ObservableArray(ntpGridDataList);
		var showVlanBrList = requestRoutingService.getShowCmdOutput("show ip interface brief","showAccessPorts");
		showVlanBrList=showVlanBrList.ShowIpInterfaceBrief.IPInterfaces.entry;
		showVlanBrList=showVlanBrList.filter(function (el) {
			return el.Interface.indexOf("Vlan") > -1;
		});
		var interfaceStatusInfo = requestRoutingService.getShowCmdOutput("show interface status", "portsMonStatus");
		interfaceStatusInfo = interfaceStatusInfo.Port.InterfaceStatus.entry;
		for(var i=0;i<showVlanBrList.length;i++){
			vlanOptions.push({
				"ntpVlanText": showVlanBrList[i].Interface,
				"ntpVlanValue": showVlanBrList[i].Interface
			});
		}

		for(var i=0;i<interfaceStatusInfo.length;i++){
			interfaceOptions.push({
				"ntpInterfaceText": interfaceStatusInfo[i].Port,
				"ntpInterfaceValue": interfaceStatusInfo[i].Port
			});
		}
		vrfOptions.push({
			"ntpVRFNameText": "Mgmt-vrf",
			"ntpVRFNameValue": "Mgmt-vrf"
		});
		$scope.ntpVlan = null;
		$scope.ntpInterfaceOptions = null;
		$timeout(function () {
			$scope.ntpVlanDataSource=new kendo.data.ObservableArray(vlanOptions);
			$scope.ntpInterfaceDataSource=new kendo.data.ObservableArray(interfaceOptions);
			$scope.ntpVRFNameDataSource=new kendo.data.ObservableArray(vrfOptions);
		}, 1000);
		$scope.stpStackModeType = null;
		$scope.ntpHostNameRadio= translate('ntp_word');
		$scope.hostNamePlaceHolder=translate("ntp_host_placeholder");
		$scope.showVRF=true;
		$scope.vrfCheckbox=true;
		$scope.$watch('ntpHostNameRadio', function(value) {
			if($scope.ntpHostNameRadio==translate('ntp_word')){
				$scope.showVRF=true;
				$scope.hostNamePlaceHolder=translate("ntp_host_placeholder");
				$scope.ntpHostName='';
			}else{
				$scope.showVRF=false;
				$scope.hostNamePlaceHolder=translate("ntp_host_placeholderTxt");
				$scope.ntpHostName='';
			}
		});
		$scope.ntpVRF= false;
		$scope.showntpVRFName=false;
		$scope.showNtpSource=true;
		$scope.$watch('ntpVRF', function(value) {
			if($scope.ntpVRF){
				$scope.showntpVRFName=true;
				$scope.showNtpSource=false;
			}else{
				$scope.showntpVRFName=false;
				$scope.showNtpSource=true;

			}
		});
		$scope.ntpSource= translate('ntp_none');
		$scope.showVlan=true;
		$scope.showInterface=true;
		$scope.$watch('ntpSource', function(value) {
			if($scope.ntpSource==translate('menu_vlan')){
				$scope.showVlan=false;
				$scope.showInterface=true;
				$scope.vrfCheckbox=true;
			}else if($scope.ntpSource==translate('portconfig_general_interface')){
				$scope.showVlan=true;
				$scope.showInterface=false;
				$scope.vrfCheckbox=true;
			}else{
				$scope.showVlan=true;
				$scope.showInterface=true;
				$scope.vrfCheckbox=true;
			}
		});
		//form validate
		var ntpFormValidate = $("#ntpForm").kendoValidator({
			rules: {
				duplicate:function(input){
					var valMsg = input.data('duplicateMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					if(!$scope.ntpDirty)
						return true;
					var ntpGrid = $("#ntpGrid").data("kendoGrid");
					var ntpData = ntpGrid.dataSource.data();
					for(i=0;i<ntpData.length;i++){
						if(trimVal(input.val())== trimVal(ntpData[i].HostName)){
							return false;
						}
					}
					return true;
				},
				checkhost:function(input) {
					var valMsg = input.data('checkhostMsg');
					if ((valMsg == undefined)) {
						return true;
					}
					if($scope.ntpHostNameRadio== translate('ntp_word')){
						// return flase
					}else{
						var regExp=/^[0-9]+$/;
						if ( !isNaN(parseInt(input.val().charAt(0))) )
							return false;
						if(input.val()=="0.0.0.0" || /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/.test(input.val()))
							return false;
						if(regExp.test(input.val()) || trimVal(input.val()) == "")
							return false;

					}
					return true;
				}
			}
		}).data("kendoValidator");
		var ntpEditData={
			HostName: "",
			VRFName: "",
			SourceAddress: "",
			Status: ""
		};
		$scope.ntpEditData = angular.copy(ntpEditData);
		$scope.ntpDirty="";
		$scope.ntpDelBtn=true;
		$scope.disNtpApplyBtn=true;
		var ntpConfigCLI="";
		$scope.newData=[];
		// Edit vlan Group
		var showNtpEdit = function(){
			$("#ntpForm  span.k-tooltip-validation").hide();
			var selected = this.dataItem(this.select());
			$scope.ntpHostName=selected.HostName;
			$timeout(function(){$scope.ntpShowEditSection = true});
			for(var i=0;i<ntpList.length;i++) {
				if (ntpList[i].hostName) {
					if (ntpList[i].hostName == "ip") {
						if (selected.HostName == ntpList[i].hostNameIP)
							$scope.ntpHostNameRadio = translate('clients_ip');
					}
					else if (ntpList[i].hostName == "ipv6") {
						if (selected.HostName == ntpList[i].hostNameIPv6)
							$scope.ntpHostNameRadio = translate('portconfig_adv_ipv6label');
					}
					else $scope.ntpHostNameRadio = translate('ntp_word');
				}
			}
			for(var j=0;j<$scope.newData.length;j++) {
				if($scope.newData[j].HostName==selected.HostName)
					{
						if($scope.newData[j].hostType=="IP")
							$scope.ntpHostNameRadio = translate('clients_ip');
						else if($scope.newData[j].hostType=="IPV6")
								$scope.ntpHostNameRadio = translate('portconfig_adv_ipv6label');
					}
			}
			if(selected.SourceAddress.indexOf("Gi") > -1 || selected.SourceAddress.indexOf("Fa") > -1 || selected.SourceAddress.indexOf("Te") > -1){
				$scope.ntpSource=translate('portconfig_general_interface');
				//$scope.ntpVlan=selected.SourceAddress;
			}
			else if(selected.SourceAddress.indexOf("Vlan") > -1){
				$scope.ntpSource=translate('menu_vlan');
				//$scope.ntpInterface=selected.SourceAddress;
			}else {
				$scope.ntpSource=translate('ntp_none');
			}			
			$timeout(function(){
				$scope.ntpInterfaceOptions = selected.SourceAddress;
				$scope.ntpVlan=selected.SourceAddress;
			},100)
			$scope.ntpDirty=selected.dirty;
			$scope.ntpDelBtn=false;
		};
		//Save vlan group
		$scope.saveNtpData = function() {
			var ntpGrid = $("#ntpGrid").data("kendoGrid");
			var ntpData = ntpGrid.dataSource.data();
			//var VlanGroup = $scope.vlanGrpEditData.VlanGroup;

			var hostName='';
			var vrfName='';
			var sourceAddress='';
			var status='';
			if($scope.ntpHostNameRadio==translate('ntp_word') && $scope.ntpSource==translate('ntp_none') && !$scope.ntpVRF){
				hostName=$scope.ntpHostName;
				vrfName='None';
				sourceAddress='None';
				status='Unsynchronized';
				ntpConfigCLI += "ntp server " + hostName+"\n";

			}else if($scope.ntpHostNameRadio!=translate('ntp_word') && $scope.ntpSource==translate('ntp_none')){
				hostName=$scope.ntpHostName;
				vrfName='None';
				sourceAddress='None';
				status='Unsynchronized';
				if($scope.ntpHostNameRadio==translate('clients_ip')){
					$scope.newData.push({HostName:hostName,hostType:"IP"});
					ntpConfigCLI += "ntp server ip " + hostName+"\n";
				}else{
					ntpConfigCLI += "ntp server ipv6 " + hostName+"\n";
					$scope.newData.push({HostName:hostName,hostType:"IPV6"});
				}
			}else if($scope.ntpHostNameRadio==translate('ntp_word') && $scope.ntpVRF){
				hostName=$scope.ntpHostName;
				vrfName=$scope.ntpVRFName;
				sourceAddress='None';
				status='Unsynchronized';
				//ntpConfigCLI += "ntp server " + hostName;
			}else if($scope.ntpHostNameRadio==translate('ntp_word') && $scope.ntpSource==translate('menu_vlan')){
				hostName=$scope.ntpHostName;
				vrfName="None";
				sourceAddress=$scope.ntpVlan;
				status='Unsynchronized';
				if($scope.ntpVlan)
				ntpConfigCLI += "ntp server "+hostName+" source " + sourceAddress+"\n";
				else ntpConfigCLI += "ntp server "+hostName+"\n";;
			}else if($scope.ntpHostNameRadio==translate('ntp_word') && $scope.ntpSource==translate('portconfig_general_interface')){
				hostName=$scope.ntpHostName;
				vrfName="None";
				sourceAddress=$scope.ntpInterfaceOptions;
				status='Unsynchronized';
				if($scope.ntpInterfaceOptions)
				ntpConfigCLI += "ntp server "+hostName+" source " + sourceAddress+"\n";
				else ntpConfigCLI += "ntp server "+hostName+"\n";;
			}
			else if($scope.ntpHostNameRadio!=translate('ntp_word') && $scope.ntpSource==translate('menu_vlan')){
				hostName=$scope.ntpHostName;
				vrfName="None";
				sourceAddress=$scope.ntpVlan;
				status='Unsynchronized';
				if($scope.ntpVlan){
					if($scope.ntpHostNameRadio==translate('clients_ip')){
						$scope.newData.push({HostName:hostName,hostType:"IP"});
						ntpConfigCLI += "ntp server ip "+hostName+" source " + sourceAddress+"\n";
					}else{
						ntpConfigCLI += "ntp server ipv6 "+hostName+" source " + sourceAddress+"\n";
						$scope.newData.push({HostName:hostName,hostType:"IPV6"});
					}
				}else{
					if($scope.ntpHostNameRadio==translate('clients_ip')){
						ntpConfigCLI += "ntp server ip "+hostName+"\n";
						$scope.newData.push({HostName:hostName,hostType:"IP"});
					}else{
						ntpConfigCLI += "ntp server ipv6 "+hostName+"\n";
						$scope.newData.push({HostName:hostName,hostType:"IPV6"});
					}
				}
			}else if($scope.ntpHostNameRadio!=translate('ntp_word') && $scope.ntpSource==translate('portconfig_general_interface')){
				hostName=$scope.ntpHostName;
				vrfName="None";
				sourceAddress=$scope.ntpInterfaceOptions;
				status='Unsynchronized';
				if($scope.ntpInterfaceOptions){
					if($scope.ntpHostNameRadio==translate('clients_ip')){
						ntpConfigCLI += "ntp server ip "+hostName+" source " + sourceAddress+"\n";
						$scope.newData.push({HostName:hostName,hostType:"IP"});
					}else{
						ntpConfigCLI += "ntp server ipv6 "+hostName+" source " + sourceAddress+"\n";
						$scope.newData.push({HostName:hostName,hostType:"IPV6"});
					}
				}else{
					if($scope.ntpHostNameRadio==translate('clients_ip')){
						ntpConfigCLI += "ntp server ip "+hostName+"\n";
						$scope.newData.push({HostName:hostName,hostType:"IP"});
					}else{
						ntpConfigCLI += "ntp server ipv6 "+hostName+"\n";
						$scope.newData.push({HostName:hostName,hostType:"IPV6"});
					}
				}
			}
			if(sourceAddress=='')
				sourceAddress="None"
			if (ntpFormValidate.validate()) {
				if (!$scope.ntpDirty) {
					var hostNameFlag=false;
					var selectedItem = $scope.ntpGrid.dataItem($scope.ntpGrid.select());
					for(var i=0;i<ntpList.length;i++) {
						if (ntpList[i].hostName) {
							if (ntpList[i].hostName == "ipv6") {
								if (selectedItem.HostName == ntpList[i].hostNameIPv6)
									hostNameFlag=true
							}
						}
					}
					if(selectedItem.HostName!=hostName) {
						if (hostNameFlag) {
							ntpConfigCLI += "no ntp server ipv6 " + selectedItem.HostName + "\n";
						} else ntpConfigCLI += "no ntp server " + selectedItem.HostName + "\n";
					}
					selectedItem.HostName =hostName;
					selectedItem.VRFName = vrfName
					selectedItem.SourceAddress = sourceAddress
					selectedItem.Status = status

				} else {
					$scope.ntpGrid.dataSource.add({
						"HostName": hostName,
						"VRFName": vrfName,
						"SourceAddress": sourceAddress,
						"Status": status
					});
				}
				$scope.ntpShowEditSection = false;
				$scope.disNtpApplyBtn = false;
			}
		}
		// Cancel Vlan Group
		$scope.cancelNtpData=function(){
			$scope.ntpShowEditSection = false;
			$scope.ntpVlan = null;
			$scope.ntpInterfaceOptions = null;
		};
		// Delete vlan group
		$scope.delNtpRow=function(){
			var selectedItem = $scope.ntpGrid.dataItem($scope.ntpGrid.select());
			var hostName=selectedItem.HostName;
			var hostNameFlag=false;
			for(var i=0;i<ntpList.length;i++) {
				if (ntpList[i].hostName) {
					if (ntpList[i].hostName == "ipv6") {
						if (selectedItem.HostName == ntpList[i].hostNameIPv6)
							hostNameFlag=true
					}
				}
			}
			if(hostNameFlag){
				ntpConfigCLI += "no ntp server ipv6 "+hostName+"\n";
			}else ntpConfigCLI += "no ntp server "+hostName+"\n";
			$scope.ntpGrid.dataSource.remove(selectedItem);
			$scope.ntpShowEditSection = false;
			$scope.ntpDelBtn=true;
			$scope.disNtpApplyBtn=false;
		};
		// Add vlan group row
		$scope.addNtpRow = function(){
			//$scope.ntpEditData = angular.copy(ntpEditData);
			$scope.ntpShowEditSection = true;
			$scope.ntpDirty=true;
			$scope.ntpHostNameRadio= translate('ntp_word');
			$scope.hostNamePlaceHolder=translate("ntp_host_placeholder");
			$scope.showVRF=true;
			$scope.vrfCheckbox=true;
			$scope.ntpVRF= false;
			$scope.showntpVRFName=false;
			$scope.showNtpSource=true;
			$scope.ntpSource= translate('ntp_none');
			$scope.showVlan=true;
			$scope.showInterface=true;
			$scope.ntpHostName='';
			$("#ntpForm  span.k-tooltip-validation").hide();

		};
		
		$scope.ntpApplyBtn=function(){
			$("#ntpForm  span.k-tooltip-validation").hide();
			var result = requestRoutingService.getConfigCmdOutput(ntpConfigCLI);
			if(result==""){
				notificationService.showNotification(translate('ntp_success_msg'),translate('com_config_success_title'),'success');
			}else{
				notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
			}
			$scope.disNtpApplyBtn=true;
			ntpConfigCLI='';
		}

		$scope.gridDataSource = new kendo.data.DataSource({
			pageSize : 10,
			data : $scope.ntpData
		});
		$scope.ntpGridOptions = {
			dataSource: $scope.gridDataSource,
			editable : false,
			sortable : true,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			change	:showNtpEdit,
			scrollable : false,
			selectable : true,
			pageable : {
				 messages: {
					  display: translate("com_page_display"), 
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),  
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			columns : [{
				field : "HostName",
				title : translate("portconfig_port_ipv4_host")
			}, {
				field : "VRFName",
				title : translate("ntp_vrf_name")
			}, {
				field : "SourceAddress",
				title : translate("ntp_source_address")
			}, {
				field : "Status",
				title : translate("com_status")
			}]
		};

	}]);
