app.controller('VlanCtrl', ['$scope','$rootScope','$timeout', '$filter', 'gridCrudService','executeCliCmdService','notificationService','dialogService','requestRoutingService',
	function($scope,$rootScope,$timeout, $filter, gridCrudService,executeCliCmdService,notificationService,dialogService,requestRoutingService) {
		var translate = $filter("translate");
		var trimVal=$filter('trimValue');
		var MaxVlan = 65;


	/*************VLAN2 configuration controller code.***************/
		//Showing configured vlan list in the grid
		$scope.loadVlanDetails = function(){
			$scope.vlanApplySection  = true;
			$scope.vlanDeleteSection = true;

			var showVlanBrList = requestRoutingService.getShowCmdOutput("show vlan brief","showVlanBrief");
			showVlanBrList=showVlanBrList.ShowVlanBrief.VlanBriefTable.entry;
			for(var i=0;i<showVlanBrList.length;i++){
				if(showVlanBrList[i].status.indexOf("act/unsup")>-1)
				    showVlanBrList[i].status="unsupported"
			}
			$scope.vlanData = new kendo.data.ObservableArray(showVlanBrList)
			$scope.vlanDataSource = new kendo.data.DataSource({
				pageSize : 10,
				data : $scope.vlanData
			});
	        $scope.layer2VlanGridOptions = {
				dataSource: $scope.vlanDataSource,
				editable : false,
				sortable : true,
				change : showVlanEdit ,
				filterable : {
					extra : false,
					operators : {
						string : {
							eq : translate("com_is_equal"),
							neq : translate("com_isnot_equal")
						}
					},
					messages : {
			            info: translate("com_page_dropDowntext"),
			            filter: translate("com_btn_filter"),
			            clear: translate("com_btn_clear")
			        }
				},
				scrollable : false,
				selectable : true,
				pageable : {
					messages: {
						  display: translate("com_page_display"),
						  empty: translate("com_page_empty"),
						  page: translate("com_page_pagetext"),
						  of:translate("com_page_of"),  
						  itemsPerPage: translate("com_page_itemsPerPage"),
						  first: translate("com_page_first"),
						  previous: translate("com_page_previous"),
						  next: translate("com_page_next"),
						  last: translate("com_page_last"),
						  refresh: translate("com_page_refresh"),
						  morePages: translate("com_page_morePage")
					},
					previousNext : true,
					info : true,
					refresh : true,
					pageSizes : gridCrudService.grid_page_sizes,
					buttonCount : 5
				},
				columns : [{
					field : "vlan",
					title : translate("vlan_id"),
					width : "10%"
				}, {
					field : "name",
					title : translate("com_name"),
					width : "20%"
				}, {
					field : "status",
					title : translate("com_status"),
					width : "10%"
					//template:'<span>#= status ==="act/unsup" ? "unsupported" : status #</span>'
				}, {
					field : "ports",
					title : translate("com_ports"),
					width : "60%"
				}]
			};
			if(showVlanBrList.length >= MaxVlan){
				$scope.vlanAddSection = false;
			}else{
				$scope.vlanAddSection = true;
			}
        }
			
		var vlanEditData={
			vlan: "",
			name: "",
			status: translate("com_active")
		};

		
		//Edit vlan grid value
		$scope.vlanEditData = angular.copy(vlanEditData);
		$scope.vlanDirty="";
		var vlanConfigCLI="";
		var showVlanEdit = function(){
			angular.element("#vlanForm  span.k-tooltip-validation").hide();
			var selected = this.dataItem(this.select());	
			if (selected.vlan == 1 || selected.vlan == 1002 || selected.vlan == 1003 || selected.vlan == 1004 || selected.vlan == 1005) {
				$timeout(function(){$scope.vlanShowEditSection = false;$scope.vlanDeleteSection = true;$scope.vlanApplySection = true});
			} else {
				$timeout(function(){$scope.vlanShowEditSection = true;$scope.vlanDeleteSection = false;$scope.vlanIdState = true});
			}			
			$scope.vlanEditData.vlan = selected.vlan;
			$scope.vlanEditData.name = selected.name;
			if(selected.status=="active"){
				$scope.vlanEditData.status = translate("com_active");
			}else{
				$scope.vlanEditData.status = translate("com_suspended");
			}			
			$scope.vlanDirty=selected.dirty;
		};
		
		$scope.loadVlanDetails();

		$scope.saveVlanData = function(){
			if(vlanValidations.validate()){
				$scope.vlanApplySection = false;
				var status="";
				if($scope.vlanDirty){  //add function	
					if($scope.vlanEditData.status==translate("com_suspended")){
						status="suspend";
					}else{
						status="active";
					}
					$scope.layer2VlanGrid.dataSource.add({"vlan": $scope.vlanEditData.vlan,"name": $scope.vlanEditData.name,"status": status});
				}else{ //for edit
					var selectedItem = $scope.layer2VlanGrid.dataItem($scope.layer2VlanGrid.select());
					selectedItem.vlan = $scope.vlanEditData.vlan;
					selectedItem.name = $scope.vlanEditData.name;
					if($scope.vlanEditData.status==translate("com_suspended")){
						status="suspend";
					}else{
						status="active";
					}
					selectedItem.status = status;
				}

				vlanConfigCLI += "vlan "+$scope.vlanEditData.vlan+"\n";
				vlanConfigCLI += "name "+$scope.vlanEditData.name+"\n";
				if($scope.vlanEditData.status==translate("com_suspended")){
					vlanConfigCLI += "state suspend \n";
				}else{
					vlanConfigCLI += "state active \n";
				}
				$scope.vlanEditData.vlan = "";
				$scope.vlanEditData.name = "";
				$scope.vlanEditData.status = translate("com_active");
				$scope.vlanShowEditSection = false;
				
				if($scope.layer2VlanGrid.dataSource._total >= MaxVlan){
					$scope.vlanAddSection = false;
				}else{
					$scope.vlanAddSection = true;
				}
			}
		}

		$scope.deleteData = function(popup) {
			var selectedItem = $scope.layer2VlanGrid.dataItem($scope.layer2VlanGrid.select());
			$scope.layer2VlanGrid.dataSource.remove(selectedItem);
			vlanConfigCLI += "no vlan ";
			vlanConfigCLI += selectedItem.vlan;
			vlanConfigCLI += "\n";
			popup.close();		
			$scope.vlanCancel();
			if($scope.layer2VlanGrid.dataSource._total >= MaxVlan){
				$scope.vlanAddSection = false;
			}else{
				$scope.vlanAddSection = true;
			}	
			$timeout(function(){$scope.vlanApplySection = false});
		}

		$scope.addVlanRow = function(){
			$scope.vlanEditData = angular.copy(vlanEditData);
			$scope.vlanShowEditSection = true;
			$scope.vlanDirty=true;
			$scope.vlanIdState = false;
			$scope.vlanEditData.vlan = "";
			$scope.vlanEditData.name = "";
			$scope.vlanDeleteSection = true;
			$scope.vlanEditData.status = translate("com_active");
			angular.element("#vlanForm  span.k-tooltip-validation").hide();
		};
		$scope.vlanCancel = function() {
			$timeout(function(){
				angular.element("#vlanForm  span.k-tooltip-validation").hide();
				$scope.vlanShowEditSection = false;
				$scope.vlanDeleteSection = true;
				$scope.vlanApplySection = true
			});
		};
		$scope.applyVlan2Layer=function(){
			var result = requestRoutingService.getConfigCmdOutput(vlanConfigCLI);
			if(result==""){
				notificationService.showNotification(translate('vlan_success_msg'),translate('com_config_success_title'),'success');
			}else{
				notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
			}
			vlanConfigCLI="";
			$scope.vlanApplySection  = true;
			$scope.loadVlanDetails();
		}

		// Layer2 VLAN Form validation
		var vlanValidations = angular.element("#vlanForm").kendoValidator({
			rules: {
				duplicate:function(input){
					var valMsg = input.data('duplicateMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					if(!$scope.vlanDirty)
						return true;
					var vlanGrid = angular.element("#layer2VlanGrid").data("kendoGrid");
					var vlanGridData = vlanGrid.dataSource.data();
					for(i=0;i<vlanGridData.length;i++){
						vlanGridData[i];
						if(trimVal(input.val())== trimVal(vlanGridData[i].vlan)){
							return false;
						}
					}
					return true;
				},
				range: function (input) {
					var count=0;
					var valMsg = input.data('rangeMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var min= input.prop('min');
					var max= input.prop('max');
					if(parseFloat(input.val())>=min && parseFloat(input.val())<=max)
						return true;
					return false;
				},
				checkVlanName:function(input){
					var valMsg = input.data('checkVlanNameMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var regExp=/^[-]+$/;
					if(regExp.test(input.val()) || trimVal(input.val()) == "")
						return false;
					return true;
				}
			}
		}).data("kendoValidator");
		$scope.deleteConfirmation = function() {
			$scope.commonConfirmationVlan('delete');
		};

		$scope.commonConfirmationVlan = function() {
			$scope.dlgVlan = dialogService.dialog({
				content : translate("msg_delete_confirmation"),
				title : translate("msg_delete_confirmation_window"),
				messageType : "confirm",
				actionButtons : [{
					text : translate("com_ok"),
					callback : "vlanDeleteConfirmation"
				}, {
					text : translate("com_cancel")
				}]
			});
		};

		$scope.$on("vlanDeleteConfirmation", function(event, data) {
			$scope.deleteData($scope.dlgVlan.data("kendoWindow"));
		});

		//form validate
		var vlanListValidations = angular.element("#vlanListForm").kendoValidator({
			rules: {
				range: function (input) {
					var count=0;
					var min= input.prop('min');
					var max= input.prop('max');
					vlanListNew=[];
					var vlanList1=input.val().split(',');
					for(var i=0;i<vlanList1.length;i++){
						if(vlanList1[i].indexOf("-")>-1){
							var lowEnd = Number(vlanList1[i].split('-')[0]);
							var highEnd = Number(vlanList1[i].split('-')[1]);
							for (var j = lowEnd; j <= highEnd; j++) {
								vlanListNew.push(j);
							}
						}else vlanListNew.push(Number(vlanList1[i]));
					}
					var finalVlanListNew1=[];
					for(var i=0;i<=vlanListNew.length-1;i++){
						if(!isNaN(vlanListNew[i]))
							finalVlanListNew1.push(vlanListNew[i]);
					}
					for(var i=0;i<finalVlanListNew1.length;i++){
						if(parseFloat(finalVlanListNew1[i])>=Number(min) && parseFloat(finalVlanListNew1[i])<=Number(max)) {
						  count++;
					  }
					}
					if(finalVlanListNew1.length==count){
					return true;
					}
					return false;
				},
				duplicateRecord:function(input){
					if(!$scope.vlanListDirty)
						return true;
					var ipDhGrid = angular.element("#ipDhcpSnnopingGrid").data("kendoGrid");
					var ipDhData = ipDhGrid.dataSource.data();
					var newipDhData=[];
					for(i=0;i<ipDhData.length;i++){
						newipDhData[i]=ipDhData[i].VlanList;
						}
					var arr= input.val().split(',');
					for (var i = 0; i < arr.length; i++) {
						for (var j = 0; j < newipDhData.length; j++) {
							if (arr[i] == newipDhData[j]) {
								return false;
							}
						}
					}
					return true;
				},
				checkVlanList:function(input){
					var valMsg = input.data('checkVlanListMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var regExp=/^[,-]+$/;
					var valStrHy=input.val().includes("--");
					var valStrCom=input.val().includes(",,");
					if(regExp.test(input.val()) || valStrHy || valStrCom || trimVal(input.val()) == "")
						return false;
					return true;
				}
			}
		}).data("kendoValidator");
		//form validate
		var vlanGroupFormValidate = angular.element("#vlanGroupForm").kendoValidator({
			rules: {
				duplicate:function(input){
					var valMsg = input.data('duplicateMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					if(!$scope.vlanGrpDirty)
					return true;
					var vlanGroupGrid = angular.element("#vlanGroupGrid").data("kendoGrid");
					var vlanGroupGridData = vlanGroupGrid.dataSource.data();
					for(i=0;i<vlanGroupGridData.length;i++){
						//vlanGroupGridData[i];
						if(input.val()== vlanGroupGridData[i].VlanGroup){
							return false;
						}
					}
						return true;
				},
				checkvlangroup:function(input){
					var valMsg = input.data('checkvlangroupMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var regExp=/^[0-9-]+$/;
					if(regExp.test(input.val()))
					return false;
					return true;
				},
				range: function (input) {
					var count=0;
					var valMsg = input.data('rangeMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var min= trimVal(input.prop('min'));
					var max= trimVal(input.prop('max'));
					var arr = input.val().replace('-',',');
					arr= arr.split(',');
					for(var i=0;i<arr.length;i++){
						if(parseFloat(trimVal(arr[i]))>=min && parseFloat(trimVal(arr[i]))<=max) {
							count++;
						}
					}
					if(arr.length!=count){
						return false;
					}
					return true;
				},
				checkVlanList:function(input){
					var valMsg = input.data('checkVlanListMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var regExp=/^[,-]+$/;
					var valStrHy=input.val().includes("--");
					var valStrCom=input.val().includes(",,");
					if(regExp.test(input.val()) || valStrHy || valStrCom || trimVal(input.val()) == "")
						return false;
					return true;
				}
			}
		}).data("kendoValidator");

		//controller code for vlan group page
		
		$scope.showVlanGroups = true;	
		$scope.vlanGrpData = [];	
		if( ($rootScope.deviceInfo.type.indexOf("2960X")!=-1 && $rootScope.deviceInfo.type.indexOf("-LL")!=-1) || 
			    ($rootScope.deviceInfo.type.indexOf("2960+")!=-1 && $rootScope.deviceInfo.type.indexOf("-S")!=-1) || 
				($rootScope.deviceInfo.type.indexOf("2960C")!=-1 && $rootScope.deviceInfo.type.indexOf("-S")!=-1))
		{		
             $scope.showVlanGroups = false;
		}else{
			var showVlanGrp = requestRoutingService.getShowCmdOutput("show vlan group","showVlanGroup");
			if(showVlanGrp.ShowVlanGroup.entry){
				showVlanGrp = showVlanGrp.ShowVlanGroup.entry;
				if (typeof showVlanGrp == "object" && !showVlanGrp.length)
					showVlanGrp = [showVlanGrp];
			}else {
				showVlanGrp=[];
			}
			$scope.vlanGrpData = new kendo.data.ObservableArray(showVlanGrp)
		}
		var vlanGrpEditData={
			VlanGroup: "",
			VlanList: ""
		};
		$scope.vlanGrpEditData = angular.copy(vlanGrpEditData);
		$scope.vlanGrpDirty="";
		$scope.vlanGrpDelBtn=true;
		$scope.disVlanGrpApplyBtn=true;
		var vlanGroupConfigCLI="";
		// Edit vlan Group
		var showVlanGrpEdit = function(){
			var selected = this.dataItem(this.select());
			$timeout(function(){$scope.vlanGrpShowEditSection = true});
			$scope.vlanGrpEditData.VlanGroup = selected.VlanGroup;
			$scope.vlanGrpEditData.VlanList = selected.VlanList;
			$scope.vlanGrpDirty=selected.dirty;
			$scope.vlanGrpDelBtn=false;
		};
		//Save vlan group
		$scope.saveVlanGrpData = function() {
			var vlGrpGrid = angular.element("#vlanGroupGrid").data("kendoGrid");
			var vlGrpData = vlGrpGrid.dataSource.data();
			var VlanGroup = $scope.vlanGrpEditData.VlanGroup;

			if (vlanGroupFormValidate.validate()) {
				if ($scope.vlanGrpDirty) {
						$scope.vlanGroupGrid.dataSource.add({
							"VlanGroup": $scope.vlanGrpEditData.VlanGroup,
							"VlanList": $scope.vlanGrpEditData.VlanList
						});

				} else {
					var selectedItem = $scope.vlanGroupGrid.dataItem($scope.vlanGroupGrid.select());
					vlanGroupConfigCLI += "no vlan group" + " " + selectedItem.VlanGroup + " " + "vlan-list" + " " + selectedItem.VlanList + "\n";
					selectedItem.VlanGroup = $scope.vlanGrpEditData.VlanGroup;
					selectedItem.VlanList = $scope.vlanGrpEditData.VlanList;
				}
				$scope.vlanGrpShowEditSection = false;
				$scope.disVlanGrpApplyBtn = false;
				vlanGroupConfigCLI += "vlan group" + " " + $scope.vlanGrpEditData.VlanGroup + " " + "vlan-list" + " " + $scope.vlanGrpEditData.VlanList + "\n";
			}
		}
		// Cancel Vlan Group
		$scope.cancelVlanGrpData=function(){
			$scope.vlanGrpShowEditSection = false;
		};
		// Delete vlan group
		$scope.delVlanGrpRow=function(){
			var selectedItem = $scope.vlanGroupGrid.dataItem($scope.vlanGroupGrid.select());
			$scope.vlanGroupGrid.dataSource.remove(selectedItem);
			vlanGroupConfigCLI+="no vlan group"+" "+selectedItem.VlanGroup+" "+"vlan-list"+" "+selectedItem.VlanList+"\n";
			$scope.vlanGrpShowEditSection = false;
			$scope.vlanGrpDelBtn=true;
			$scope.disVlanGrpApplyBtn=false;
		};
		// Add vlan group row
		$scope.addVlanGrpRow = function(){
			$scope.vlanGrpEditData = angular.copy(vlanGrpEditData);
			$scope.vlanGrpShowEditSection = true;
			$scope.vlanGrpDirty=true;

		};
		// Apply valn group configurations
		$scope.vlanGroupApplyBtn=function(){
			var result = requestRoutingService.getConfigCmdOutput(vlanGroupConfigCLI);
			if(result==""){
				notificationService.showNotification(translate('vlan_success_msg'),translate('com_config_success_title'),'success');
			}else{
				notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
			}
			$scope.disVlanGrpApplyBtn=true;
		}
		// Vlan group Grid starts here
		$scope.gridDataSource2 = new kendo.data.DataSource({
			pageSize : 10,
			data : $scope.vlanGrpData
		});
		$scope.vlanGroupGridOptions = {
			dataSource: $scope.gridDataSource2,
			editable : false,
			sortable : true,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
						neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			change	:showVlanGrpEdit,
			scrollable : false,
			selectable : true,
			pageable : {
				messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),  
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			columns : [{
				field : "VlanGroup",
				title : translate("vlan_group_name")
			}, {
				field : "VlanList",
				title : translate("vlan_list")
			}]
		};

		// Controller for Valn List page
		$scope.ipDhcpStatus="on";
		$scope.vlanListDelBtn=true;
		$scope.disVlanListApplyBtn=true;

		// Fetching vlan list grid data
		var vlanList = deviceCommunicator.getExecCmdOutput("show ip dhcp snooping");
		var START_INPUT= new Array("configured on following VLANs:");
		var END_INPUT= new Array("DHCP snooping is operational");
		vlanList= executeCliCmdService.getNextString(vlanList,START_INPUT,END_INPUT);

		// Fetching ip dhcp status
		var newIpDhcpStatus = deviceCommunicator.getExecCmdOutput("show ip dhcp snooping");
		var ipDhcpStart= new Array("Switch DHCP snooping is");
		var ipDhcpEnd= new Array("Switch DHCP gleaning is");
		newIpDhcpStatus= executeCliCmdService.getNextString(newIpDhcpStatus,ipDhcpStart,ipDhcpEnd);

		// ip dhcp status
		if(trimVal(newIpDhcpStatus)=="enabled"){
			$timeout(function() {
				$scope.ipDhcpStatus="on";
			}, 0);
		}
		else{
			$timeout(function() {
				$scope.ipDhcpStatus="off";
			}, 0);
		}
		// ip dhcp status toggle button
		$scope.ipDhcpToggleBtn=function(){
			$scope.disVlanListApplyBtn=false;
			if($scope.ipDhcpStatus==translate("com_enable")){
				vlanListConfigCLI+="ip dhcp snooping"+"\n";
			}else{
				vlanListConfigCLI+="no ip dhcp snooping"+"\n";
			}
		};
		// Vlan List edit grid data
		var vlanListEditData={
			VlanList: ""
		};
		$scope.vlanListEditData = angular.copy(vlanListEditData);
		$scope.vlanListDirty="";
		var vlanListConfigCLI="";
		var vlanListNew=[];
		vlanList1=vlanList.split(',');
		for(var i=0;i<vlanList1.length;i++){
			if(vlanList1[i].indexOf("-")>-1){
				var lowEnd = Number(vlanList1[i].split('-')[0]);
				var highEnd = Number(vlanList1[i].split('-')[1]);
				for (var j = lowEnd; j <= highEnd; j++) {
					vlanListNew.push(j);
				}
			}else vlanListNew.push(Number(vlanList1[i]));
		}
		var finalVlanListNew1=[];
		for(var i=0;i<=vlanListNew.length-1;i++){
			if(!isNaN(vlanListNew[i]))
				finalVlanListNew1.push({VlanList:vlanListNew[i]});
		}
		$scope.vlanListData = new kendo.data.ObservableArray(finalVlanListNew1);
		// vlan list edit record
		var showVlanListEdit = function(){
			var selected = this.dataItem(this.select());
			$timeout(function(){$scope.vlanListShowEditSection = true});
			$scope.vlanListEditData.VlanList = selected.VlanList;
			$scope.vlanListDirty=selected.dirty;
			$scope.vlanListDelBtn=false;
		};
		// vlan list save records
		$scope.saveVlanListData = function(){
			var ipDhGrid = angular.element("#ipDhcpSnnopingGrid").data("kendoGrid");
			var ipDhData = ipDhGrid.dataSource.data();
			var vlanList = $scope.vlanListEditData.VlanList;
			if(vlanListValidations.validate()){
				if($scope.vlanListDirty){
					var vlanList=$scope.vlanListEditData.VlanList.split(',');
					var vlanListNew=[];
					for(var i=0;i<vlanList.length;i++){
						if(vlanList[i].indexOf("-")>-1){
							var lowEnd = Number(vlanList[i].split('-')[0]);
							var highEnd = Number(vlanList[i].split('-')[1]);
							for (var j = lowEnd; j <= highEnd; j++) {
								vlanListNew.push(j);
							}
						}else vlanListNew.push(Number(vlanList[i]));
					}
					for(var i=0;i<=vlanListNew.length-1;i++){
						$scope.ipDhcpSnnopingGrid.dataSource.add({"VlanList": vlanListNew[i]});
					}
				}else{
					var selectedItem = $scope.ipDhcpSnnopingGrid.dataItem($scope.ipDhcpSnnopingGrid.select());
					vlanListConfigCLI+="no ip dhcp snooping vlan"+" "+ trimVal(selectedItem.VlanList)+"\n";
					selectedItem.VlanList = $scope.vlanListEditData.VlanList;
				}
				var newVlanList=$scope.vlanListEditData.VlanList.split(', ').join(',');
				vlanListConfigCLI+="ip dhcp snooping vlan"+" "+newVlanList+"\n";
				$scope.vlanListShowEditSection = false;
				$scope.disVlanListApplyBtn=false;
			}
		}
		// Cancel Vlan Group
		$scope.cancelVlanListData=function(){
			$scope.vlanListShowEditSection = false;
		};
		// vlan list delete record
		$scope.delVlanListRow=function(){
			var selectedItem = $scope.ipDhcpSnnopingGrid.dataItem($scope.ipDhcpSnnopingGrid.select());
			vlanListConfigCLI+="no ip dhcp snooping vlan"+" "+selectedItem.VlanList+"\n";
			$scope.ipDhcpSnnopingGrid.dataSource.remove(selectedItem);
			$scope.vlanListShowEditSection = false;
			$scope.vlanListDelBtn=true;
			$scope.disVlanListApplyBtn=false;
		};
		// vlan list add record
		$scope.addVlanListRow = function(){
			$scope.vlanListEditData = angular.copy(vlanListEditData);
			$scope.vlanListShowEditSection = true;
			$scope.vlanListDirty=true;
		};
		// vlan list apply configurations
		$scope.vlanListApplyBtn=function(){
			var result = requestRoutingService.getConfigCmdOutput(vlanListConfigCLI);
			if(result==""){
				notificationService.showNotification(translate('vlan_success_msg'),translate('com_config_success_title'),'success');
			}else{
				notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
			}
			$scope.disVlanListApplyBtn=true;
		}
		// Vlan list grid starts here
		$scope.gridDataSource = new kendo.data.DataSource({
			pageSize : 10,
			data : $scope.vlanListData
		});
		$scope.ipDhcpSnnopingGridOptions = {
			dataSource: $scope.gridDataSource,
			editable : false,
			sortable : true,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
						neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			change	:showVlanListEdit,
			scrollable : false,
			selectable : true,
			pageable : {
				messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),  
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			columns : [{
				field : "VlanList",
				title : translate("vlan_list")
			}]
		};
	}]);
