/**
 * Contains all the common directives. Add any common diretives here.
 * This has 'toolTip' directive. 
 */

/**
 Description: Common directives to be included here.
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */




/* Directive name: tooltip
 * This directive places a tool tip icon and shows the tooltip when the mouse is hovered on it.
 * Two attributes, position and helptext need to be passed from the directive markup in html
 * Default position is right. Values could be 'right, 'left', 'top', 'bottom' and 'center'.
 * helptext provides explanation about the field and tips to choose a value
 * Usage (in markup):
    <tooltip helptext="{{'help_ua_username' | translate}}" ></tooltip>
    <tooltip position='left' helptext="{{'help_ua_password' | translate}}" ></tooltip>
*/
app.directive('tooltip', function () {
            var directive = {};
            directive.restrict = 'E';            
			directive.template = '<span><i class="fa fa-question-circle-o fa-lg" aria-hidden="true"></i></span>';
            directive.link=function(scope, element, attrs){
            	//Add the kendo tooltip to this element
            	//position and helptext should be passed from the directive markup as attributes
            	var helptext = attrs.helptext;
            	var position = 'right';
            	if(attrs.position){
                	position = attrs.position;
            	}
            	element.kendoTooltip({ content: helptext, 
                                               position: position,
                                               width: '350px',
                                               showOn: 'mouseenter',
                                               autoHide: true
                                       });
            }
            return directive;
});

