/**
 Description: Controller - Day Zero Wizard
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.controller("step2Ctrl", ['$scope','dayZeroStepService', 'validationService', '$timeout', '$filter','requestRoutingService',
function($scope,dayZeroStepService, validationService, $timeout, $filter,requestRoutingService) {
	var translate = $filter("translate");
	var trim=$filter('trim');
	$scope.dayzero={};
	var gigInterface=[];
	var teInterface=[];
	var vlanInterface=[];
	var allVlans=[];
	var portsCount=''
	var versionInfo = requestRoutingService.getShowCmdOutput("show version","overviewshVer");
	$scope.extendedVlanSupport = true;
	if((versionInfo.ShowVersion.name.indexOf("C2960X") != -1)&&(versionInfo.ShowVersion.name.indexOf("-LL") != -1)){
	var stpStatus = requestRoutingService.getShowCmdOutput("show vtp status");
	var stpEntries = stpStatus.split("\n");
	for (var i=0; i < stpEntries.length; i++) {
		var keyval = stpEntries[i].split(":");
		if((keyval[0].indexOf("VTP version running"))&&(keyval[1].indexOf("1"))){
			$scope.extendedVlanSupport = false;
			break;
	}
	}
	}
	$scope.isSelecon=(versionInfo.ShowVersion.name.indexOf("CDB-") != -1);
	if($scope.isSelecon){
		portsCount=versionInfo.ShowVersion.name.split('-')[1].substr(0,2).match(/[0-9]+/g)[0];
		$scope.showSeleconDetails=true;
	}else{
		if(versionInfo.ShowVersion.name.indexOf("C2960+") != -1){
                                versionInfo.ShowVersion.name = versionInfo.ShowVersion.name.replace("+","+-");
                }
		portsCount=versionInfo.ShowVersion.name.split('-')[2].substr(0,2).match(/[0-9]+/g)[0];
	}
	$scope.dayzero.portfast=false;
	$scope.interConfigToolTip=true;
	angular.element("#dataVlan").on("focus", function () {
		$timeout(function(){
			$scope.dataVlanTip = true;
		},0);
	});
	angular.element("#voiceVlan").on("focus", function () {
		$timeout(function(){
			$scope.voiceVlanTip = true;
		},0);

	});
	angular.element("#portfast").on("focus", function () {
		$timeout(function(){
			$scope.portfastTip = true;
		},0);

	});
	$scope.checkEveClass = function(){
		$scope.eveClassTip = true;
	};
	$scope.PoE=function(){
		$scope.poeTip = true;
	};
	$scope.accessPortToolTip=function(){
		$timeout(function(){
			$scope.accessPortsTip = true;
			$scope.interConfigToolTip=false;
		},0);
	}
	$scope.accessPortToolTipHide=function(){
		$timeout(function(){
			$scope.accessPortsTip = false;
			$scope.interConfigToolTip=true;
		},0);
	}
	$scope.uplinkToolTip=function(){
		$timeout(function(){
			$scope.uplinkPortTip = true;
			$scope.interConfigToolTip=false;
		},0);
	}
	$scope.uplinkToolTipHide=function(){
		$timeout(function(){
			$scope.uplinkPortTip = false;
			$scope.interConfigToolTip=true;
		},0);
	}
	angular.element("input").on("blur", function () {
		$timeout(function(){
			$scope.dataVlanTip=false;
			$scope.voiceVlanTip=false;
			$scope.portfastTip=false;
			$scope.eveClassTip=false;
			$scope.poeTip=false;
			$scope.interConfigToolTip=true;
		},0);
	});
	angular.element("input").on("focus", function () {
		$timeout(function(){
			$scope.interConfigToolTip=false;
		},0);
	});
	var ports = requestRoutingService.getShowCmdOutput("show ip interface brief","showAccessPorts");
	ports=ports.ShowIpInterfaceBrief.IPInterfaces.entry;

	var interfaceNames=[{"accessPortsText": "none", "accessPortsValue": "none"}];
	gigInterface=ports.filter(function (el) {
		//We only need access/downlink ports here
		if(el.Interface == "FastEthernet0"){
			//Management port, ignore.
			return false;
		}
		return el.Interface.indexOf("Vlan") == -1;

		if($scope.isSelecon){
			return el.Interface.indexOf("Fast") > -1;
		} else {
			return el.Interface.indexOf("Gig") > -1;
		}
	});
	for(var i1=0;i1<portsCount;i1++){
		interfaceNames.push({
			"accessPortsText": gigInterface[i1].Interface,
			"accessPortsValue": gigInterface[i1].Interface
			});
	}

	var teInterfaceNames=[{"uplinkPortText": "none", "uplinkPortValue": "none"}];
	teInterface=ports.filter(function (el) {
		if($scope.isSelecon){
			return el.Interface.indexOf("Gig") > -1;
		} else {
			return el.Interface.indexOf("Te") > -1;
		}
	});

	for(var i2=0;i2<gigInterface.length;i2++){
		if(i2>portsCount-1 && gigInterface[i2].Interface.indexOf("Loopback")==-1){
			teInterfaceNames.push({
				"uplinkPortText": gigInterface[i2].Interface,
				"uplinkPortValue": gigInterface[i2].Interface
			});
		}
	}
	for(var i3=0;i3<teInterface.length;i3++){
		if(teInterface[i3].Interface.indexOf("Loopback")==-1){
			teInterfaceNames.push({
				"uplinkPortText": teInterface[i3].Interface,
				"uplinkPortValue": teInterface[i3].Interface
			});
		}
	}
	vlanInterface=ports.filter(function (el) {
		return (el.Interface=='Vlan1');
	});
	allVlans=ports.filter(function (el) {
		return (el.Interface.indexOf("Vlan") > -1  );
	});
	dayZeroStepService.setVlanInter(vlanInterface);
	dayZeroStepService.setAllValns(allVlans);
	$timeout(function () {
		$scope.accessPortsDataSource=new kendo.data.ObservableArray(interfaceNames);
		$scope.uplinkPortDataSource=new kendo.data.ObservableArray(teInterfaceNames);
	}, 0);
	$scope.selectOptions = {
		autoBind: false
	};
	$scope.wizardValidations = {
		rules : {
			checkvlan:function(input){
				var valMsg = input.data('checkvlanMsg');
				if ((valMsg==undefined)) {
					return true;
				}
				//CSCvc19191
				if((!$scope.extendedVlanSupport)&&(trim(input.val())>1005)){
						return false;
				}
				if(trim(input.val()) == "" && input.prop('id')=='voiceVlan'){
					return true;
				}
				if(trim(input.val()) == ""){
					return false;
				}
				return true;
			},
			range: function (input) {
				var count=0;
				var valMsg = input.data('rangeMsg');
				if ((valMsg==undefined)) {
					return true;
				}
				if(trim(input.val()) == "" && input.prop('id')=='voiceVlan'){
					return true;
				}
				var min= input.prop('min');
				var max= input.prop('max');
				var arr = input.val().split(',');
				for(var i=0;i<arr.length;i++){
					if(parseFloat(trim(arr[i]))>=min && parseFloat(trim(arr[i]))<=max) {
						count++;
					}
				}
				if(arr.length==count){
					return true;
				}
				return false;
			}
		}
	};
	$scope.$on("dayZeroWizard:nextButtonPressed", function(evt, laststep, stepNumber) {
		if (stepNumber === 2) {
			$scope.myValidator = $scope.basicScreenValidator;
			validationService.addValidator($scope.myValidator, 2);
			if ($scope.myValidator && $scope.myValidator.validate()) {
				var dataVlanList=($scope.dayzero.dataVlan).split(',');
				var voiceVlanList='';
				if($scope.dayzero.voiceVlan){
					voiceVlanList=($scope.dayzero.voiceVlan).split(',');
				}
				var portfastVal,evetClass,perPoe;
				if($scope.dayzero.portfast){
					portfastVal = translate("com_enable");
				}
				else{
					portfastVal = translate("com_disable");
				}
				if($scope.dayzero.eveClassification){
					evetClass = translate("com_enable");
					} else {
					evetClass = translate("com_disable");
					}
				if($scope.dayzero.perpetualPoE) {
					perPoe = translate("com_enable");
				}
				else {
					perPoe = translate("com_disable");
				}
				var interConfig = {
					"dataVlan": dataVlanList,
					"voiceVlan": voiceVlanList,
					"accessPorts": $scope.dayzero.accessPorts,
					"portfast": portfastVal,
					"uplinkPort": $scope.dayzero.uplinkPort,
					"evetClass":evetClass,
					"perPoe":perPoe
				};
				dayZeroStepService.setInterConfig(interConfig);
				var interfaceOptions=[];
				for(var i=0;i<dataVlanList.length;i++){
					interfaceOptions.push({"interfaceText": translate('day0_wizard_interface_config_datavlan')+" "+dataVlanList[i]});
				}
				for(var i4=0;i4<voiceVlanList.length;i4++){
					interfaceOptions.push({"interfaceText": translate('day0_wizard_interface_config_vicevlan')+" "+voiceVlanList[i4]});
				}
				dayZeroStepService.setInterOption(interfaceOptions);
			}
		}
	});
}]);

