/**
 Description: Controller - Day Zero Wizard
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.controller("SummaryScreenCtrl", ['$scope','$rootScope', 'dayZeroStepService', 'validationService', '$filter','requestRoutingService',
function ($scope, $rootScope,dayZeroStepService, validationService, $filter,requestRoutingService) {
	var translate = $filter("translate");
	var versionInfo = requestRoutingService.getShowCmdOutput("show version","overviewshVer");
	$scope.version = versionInfo.ShowVersion.version.split(',')[0];
	$rootScope.deviceInfo = {
			type: versionInfo.ShowVersion.name
	};
	if(  ($rootScope.deviceInfo.type.indexOf("C2960X") != -1 && $rootScope.deviceInfo.type.indexOf("-LL") == -1) || ($rootScope.deviceInfo.type.indexOf("C3560CX") != -1) || ($rootScope.deviceInfo.type.indexOf("2960C") != -1 && $rootScope.deviceInfo.type.indexOf("-S") == -1)  || ($rootScope.deviceInfo.type.indexOf("WS-C2960+") != -1 && $rootScope.deviceInfo.type.indexOf("-S") == -1) || ($rootScope.deviceInfo.type.indexOf("2960XR") != -1)  || ($rootScope.deviceInfo.type.indexOf("2960CX") != -1) ) {
		     $scope.showDeviceStatus=true;
	}else{
		$scope.showDeviceStatus=false;
	}
	$scope.basicSummary= dayZeroStepService.getBasicConfig();
	$scope.interSummary= dayZeroStepService.getInterConfig();
	$scope.advSummary= dayZeroStepService.getAdvConfig();
	$scope.laySummary= dayZeroStepService.getLayConfig();
	$scope.ipAddressAssign= dayZeroStepService.getIpAddressAssign();
	$scope.$watch(function() {
		return dayZeroStepService.getBasicConfig();
	}, function(newValue) {
		$scope.basicSummary = newValue;
	});
	$scope.$watch(function() {
		return dayZeroStepService.getInterConfig();
	}, function(newValue) {
		$scope.interSummary = newValue;
	});
	$scope.$watch(function() {
		return dayZeroStepService.getAdvConfig();
	}, function(newValue) {
		$scope.advSummary = newValue;
	});
	$scope.$watch(function() {
		return dayZeroStepService.getLayConfig();
	}, function(newValue) {
		$scope.laySummary = newValue;
	});
	$scope.$watch(function() {
		return dayZeroStepService.getIpAddressAssign();
	}, function(newValue) {
		$scope.ipAddressAssign = newValue;
	});
	$scope.$on("dayZeroWizard:nextButtonPressed", function (evt, laststep, stepNumber) {
		if (stepNumber === 5) {
			var dayzeroConfigCLI='';
			dayzeroConfigCLI+="hostname "+ $scope.basicSummary.hostName+"\n";
			dayzeroConfigCLI+="username " + $scope.basicSummary.userName+" privilege 15 password 0 "+ $scope.basicSummary.password+"\n ";
			dayzeroConfigCLI+="enable secret "+ $scope.basicSummary.enablePassword+"\n";
			dayzeroConfigCLI+="do clock set "+ $scope.basicSummary.clock+"\n";
			for(var i=0;i<$scope.interSummary.dataVlan.length;i++){
				dayzeroConfigCLI+="int vlan" + $scope.interSummary.dataVlan[i]+"\n";
			}
			for(var i1=0;i1<$scope.interSummary.voiceVlan.length;i1++){
				dayzeroConfigCLI+="int vlan" + $scope.interSummary.voiceVlan[i1]+"\n";
			}
			if($scope.interSummary.accessPorts){
				for(var index=0;index<$scope.interSummary.accessPorts.length;index++){
					if($scope.interSummary.accessPorts[index]!=translate("portconfig_options_none") && $scope.interSummary.accessPorts[index]!=undefined){
						dayzeroConfigCLI+="int "+ $scope.interSummary.accessPorts[index]+"\n";
						dayzeroConfigCLI+="switchport mode access \n";
						for(var i2=0;i2<$scope.interSummary.dataVlan.length;i2++){
							dayzeroConfigCLI+="switchport access vlan "+$scope.interSummary.dataVlan[i2]+"\n";
						}
						for(var j=0;j<$scope.interSummary.voiceVlan.length;j++){
							dayzeroConfigCLI+="switchport voice vlan "+$scope.interSummary.voiceVlan[j]+"\n";
						}
						if($scope.interSummary.portfast==translate("com_enable")){
							dayzeroConfigCLI+="spanning-tree portfast edge\n";
						}
						if($scope.interSummary.evetClass==translate("com_enable")){
							dayzeroConfigCLI+="power inline port 2-event \n";
						}
						if($scope.interSummary.perPoe==translate("com_enable")){
							dayzeroConfigCLI+="power inline port poe-ha \n";
						}
					}
				}
			}			
			if($scope.interSummary.uplinkPort!="none" && $scope.interSummary.uplinkPort!=translate("portconfig_options_none") && $scope.interSummary.uplinkPort!=undefined){
				dayzeroConfigCLI+="exit\nint "+ $scope.interSummary.uplinkPort+"\n";
				dayzeroConfigCLI+="switchport mode trunk \n";
				dayzeroConfigCLI+="switchport trunk allowed vlan all \n";
			}
			dayzeroConfigCLI+="ip default-gateway " + $scope.laySummary.defaultGateway +"\n";
			if($scope.laySummary.defaultRoute!='' && $scope.laySummary.defaultRoute!=undefined){
				dayzeroConfigCLI+="ip routing \nip route 0.0.0.0 0.0.0.0 " + $scope.laySummary.defaultRoute+"\n";
			}
			if($scope.laySummary.newIpAddress){
				dayzeroConfigCLI+="interface "+$scope.laySummary.vlan+"\n";
				dayzeroConfigCLI+="ip address "+$scope.laySummary.newIpAddress+" "+$scope.laySummary.subnet+"\n";
			}
			for(var i3=0;i3<$scope.ipAddressAssign.length;i3++){
				if($scope.ipAddressAssign[i3].ipAddress){
					var newIpAddressAssign=($scope.ipAddressAssign[i3].vlan).replace(/\D/g,'');
					dayzeroConfigCLI+="interface vlan"+newIpAddressAssign+"\n";
					dayzeroConfigCLI+="ip address "+$scope.ipAddressAssign[i3].ipAddress+" "+$scope.ipAddressAssign[i3].subnet+"\n";
				}
			}
			
			if(($scope.advSummary.enableSSH=="Enable")&&($scope.advSummary.enableTelnet=="Enable")) {
				// IMP! DO NOT remove the write mem. Its required.
				dayzeroConfigCLI+="do write memory\n";
				dayzeroConfigCLI+="line vty 0 10 \ntransport input all \ntransport output all\nlogin local\n";
				dayzeroConfigCLI+="exit\n";
				dayzeroConfigCLI+="ip domain-name "+$scope.advSummary.domainName+"\n";
				dayzeroConfigCLI+="crypto key generate rsa modulus "+$scope.advSummary.RSAKey+"\n";
			}
			else if($scope.advSummary.enableTelnet=="Enable"){
				// IMP! DO NOT remove the write mem. Its required.
				dayzeroConfigCLI+="do write memory\n";
				dayzeroConfigCLI+="line vty 0 10 \ntransport input telnet \ntransport output telnet\nlogin local\nexit\n";
			}			
			else if($scope.advSummary.enableSSH=="Enable"){
				// IMP! DO NOT remove the write mem. Its required.
				dayzeroConfigCLI+="do write memory\n";
				dayzeroConfigCLI+="line vty 0 10 \ntransport input ssh \ntransport output ssh\nlogin local\n exit\n";
				dayzeroConfigCLI+="ip domain-name "+$scope.advSummary.domainName+"\n";
				dayzeroConfigCLI+="crypto key generate rsa modulus "+$scope.advSummary.RSAKey+"\n";
			}
			if($scope.advSummary.enableVTPTransparent=="Enable"){				
				dayzeroConfigCLI+="vtp mode transparent\n";
			} 
			// adding qos phones
			if(($scope.advSummary.enableQosPhones==translate("com_enable"))&&($scope.interSummary.accessPorts)){
				for(var index1=0;index1<$scope.interSummary.accessPorts.length;index1++){
					if($scope.interSummary.accessPorts[index1]!=translate("portconfig_options_none") && $scope.interSummary.accessPorts[index1]!=undefined){
						var autoQoSDetails = requestRoutingService.getShowCmdOutput("show auto qos interface "+$scope.interSummary.accessPorts[index1],"showAutoQoS");
						var autoQOS=autoQoSDetails.ShowAutoQoS.wnwebdata.autoQOS;
						dayzeroConfigCLI+="int "+ $scope.interSummary.accessPorts[index1]+"\n";
						if(autoQOS!=undefined){
							var cliExist = "auto qos "+autoQOS;
							if(cliExist != $scope.advSummary.enableAutoQosCli){
								dayzeroConfigCLI+="no auto qos "+autoQOS+"\n";
								dayzeroConfigCLI+=$scope.advSummary.enableAutoQosCli+"\n";
							}
						}else{
							dayzeroConfigCLI+=$scope.advSummary.enableAutoQosCli+"\n";
						}
						dayzeroConfigCLI+="exit\n";
					}
				}
			}
			// adding qos uplink
			if($scope.advSummary.enableQosUplink==translate("com_enable") && $scope.interSummary.uplinkPort){
							var autoQoSDetailsUplink = requestRoutingService.getShowCmdOutput("show auto qos interface "+$scope.interSummary.uplinkPort,"showAutoQoS");
							var autoQOSupLink=autoQoSDetailsUplink.ShowAutoQoS.wnwebdata.autoQOS;
							dayzeroConfigCLI+="int "+ $scope.interSummary.uplinkPort+"\n";
							if(autoQOSupLink!=undefined){
								var cliExist_uplink = "auto qos "+autoQOSupLink;
								if(cliExist_uplink != $scope.advSummary.enableAutoQosCli){
									dayzeroConfigCLI+="no auto qos "+autoQOSupLink+"\n";
									dayzeroConfigCLI+=$scope.advSummary.enableAutoQosUplinkCli+"\n";
								}
							}else{
								dayzeroConfigCLI+=$scope.advSummary.enableAutoQosUplinkCli+"\n";
							}
							dayzeroConfigCLI+="exit\n";
			}
			//executing default qos related CLIs CSCvc01697
			if($scope.advSummary.enableQosPhones==translate("com_enable") || $scope.advSummary.enableQosUplink==translate("com_enable")){
				dayzeroConfigCLI+="mls qos map policed-dscp  0 10 18 24 46 to 8\n";
				dayzeroConfigCLI+="mls qos map cos-dscp 0 8 16 24 32 46 48 56\n";
				dayzeroConfigCLI+="mls qos srr-queue output cos-map queue 1 threshold 3 4 5\n";
				dayzeroConfigCLI+="mls qos srr-queue output cos-map queue 2 threshold 1 2\n";
				dayzeroConfigCLI+="mls qos srr-queue output cos-map queue 2 threshold 2 3\n";
				dayzeroConfigCLI+="mls qos srr-queue output cos-map queue 2 threshold 3 6 7\n";
				dayzeroConfigCLI+="mls qos srr-queue output cos-map queue 3 threshold 3 0\n";
				dayzeroConfigCLI+="mls qos srr-queue output cos-map queue 4 threshold 3 1\n";
				dayzeroConfigCLI+="mls qos srr-queue output dscp-map queue 1 threshold 3 32 33 40 41 42 43 44 45\n";
				dayzeroConfigCLI+="mls qos srr-queue output dscp-map queue 1 threshold 3 46 47\n";
				dayzeroConfigCLI+="mls qos srr-queue output dscp-map queue 2 threshold 1 16 17 18 19 20 21 22 23\n";
				dayzeroConfigCLI+="mls qos srr-queue output dscp-map queue 2 threshold 1 26 27 28 29 30 31 34 35\n";
				dayzeroConfigCLI+="mls qos srr-queue output dscp-map queue 2 threshold 1 36 37 38 39\n";
				dayzeroConfigCLI+="mls qos srr-queue output dscp-map queue 2 threshold 2 24\n";
				dayzeroConfigCLI+="mls qos srr-queue output dscp-map queue 2 threshold 3 48 49 50 51 52 53 54 55\n";
				dayzeroConfigCLI+="mls qos srr-queue output dscp-map queue 2 threshold 3 56 57 58 59 60 61 62 63\n";
				dayzeroConfigCLI+="mls qos srr-queue output dscp-map queue 3 threshold 3 0 1 2 3 4 5 6 7\n";
				dayzeroConfigCLI+="mls qos srr-queue output dscp-map queue 4 threshold 1 8 9 11 13 15\n";
				dayzeroConfigCLI+="mls qos srr-queue output dscp-map queue 4 threshold 2 10 12 14\n";
				dayzeroConfigCLI+="mls qos queue-set output 1 threshold 1 100 100 50 200\n";
				dayzeroConfigCLI+="mls qos queue-set output 1 threshold 2 125 125 100 400\n";
				dayzeroConfigCLI+="mls qos queue-set output 1 threshold 3 100 100 100 400\n";
				dayzeroConfigCLI+="mls qos queue-set output 1 threshold 4 60 150 50 200\n";
				dayzeroConfigCLI+="mls qos queue-set output 1 buffers 15 25 40 20\n";
				dayzeroConfigCLI+="mls qos\n";
			}
			// IMP! DO NOT remove the write mem. Its required.
			dayzeroConfigCLI+="ip http authentication local\n"
			dayzeroConfigCLI+="do write memory\n"
			dayzeroConfigCLI+="exit\n"
			dayZeroStepService.setCli(dayzeroConfigCLI);
		}
	});
	$scope.tabTog = function(){
		$('#summaryTabs').find('li').removeClass('k-state-default');
	}
}]);