/**
 Description: Controller for Port Configuration
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.register.controller('PortsConfCtrl', ['$scope','$rootScope','$timeout','$filter','dataSourceService','portsDataSourceService','notificationService','validationService','requestRoutingService','dialogService',
    function($scope,$rootScope,$timeout,$filter,dataSourceService,portsDataSourceService,notificationService,validationService,requestRoutingService,dialogService) {
        var trimVal=$filter('trimValue');
		var translate = $filter("translate"),
        portsConfigGenCLI = "",
        portsConfigAdvCLI = "";
        var portDetails, portInitialData ="";
        $scope.diableGenApplyButton=true;
        $scope.diableGenCancelButton=true;
        $scope.diableSetApplyButton=true;
        $scope.diableSetCancelButton=true;
        $scope.diableAdvApplyButton=true;
        $scope.diableAdvCancelButton=true;
		$scope.portMode = translate("com_switch");
		$scope.portGroupData = {
	       keepAliveMode:translate("com_enable")
	    };
		$scope.portConfigIp = "";
		$scope.portConfigSubnet = "";
        $scope.portgroupno = "";
        $scope.translatePortGroupNumRange = translate("portconfig_portgroupnumber_range");
        if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
        	$scope.showSeleconDetails=true;
        }
        if($rootScope.deviceInfo.type.indexOf("CDB")!=-1 || $rootScope.deviceInfo.type.indexOf("3560CX")!=-1 || $rootScope.deviceInfo.type.indexOf("2960C")!=-1 || $rootScope.deviceInfo.type.indexOf("2960L")!=-1 ){
            $scope.portGroupNumRangeUpto = "6";
            $scope.translatePortGroupNumRange = $scope.translatePortGroupNumRange.replace("6",$scope.portGroupNumRangeUpto);
        }else if($rootScope.deviceInfo.type.indexOf("2960XR")!=-1){
            $scope.portGroupNumRangeUpto = "48";
            $scope.translatePortGroupNumRange = $scope.translatePortGroupNumRange.replace("6",$scope.portGroupNumRangeUpto);
        }else if($rootScope.deviceInfo.type.indexOf("2960X")!=-1){
            $scope.portGroupNumRangeUpto = "24";
            $scope.translatePortGroupNumRange = $scope.translatePortGroupNumRange.replace("6",$scope.portGroupNumRangeUpto);
        }
        if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
			$scope.visibleportMode = true;
		}
		angular.extend($scope,{
			currentPortconfig: '',
            portsVoiceVlan: ""
		});
		$scope.diableApplyButton = function(){
			$timeout(function(){
				$scope.diableGenApplyButton = true;
				$scope.diableGenCancelButton=true;
				$scope.diableSetApplyButton=true;
				$scope.diableAdvApplyButton=true;
				$scope.diableSetCancelButton=true;
				$scope.diableAdvCancelButton=true;
			}, 1000);
		}								
		$scope.portGroupType = null;
        $scope.portGroupTypeOptions = new kendo.data.ObservableArray([
                {"portGroupTypeText": translate('portconfig_portgroup_type_lacp'), "portGroupTypeValue": "LACP"},
                {"portGroupTypeText": translate('portconfig_portgroup_type_pagp'), "portGroupTypeValue": "PAgP"},
                {"portGroupTypeText": translate('portconfig_portgroup_type_on'), "portGroupTypeValue": "On"}
        ]);
        var portGenValidations = angular.element("#portsConfigGenForm").kendoValidator({
                rules: {
                    check: function (input) {
						var valMsg = input.data('checkMsg');
						if ((valMsg==undefined)) {
							return true;
						}
                        return validationService.validateCheck(input);
                    },
                    space: function (input) {
						var valMsg = input.data('spaceMsg');
						if ((valMsg==undefined)) {
							return true;
						}
                        return validationService.validateDataSpace(input);
                    },
                    range: function (input) {
						var valMsg = input.data('rangeMsg');
						if ((valMsg==undefined)) {
							return true;
						}
                        return validationService.validateRange(input);
                    },
					interfacerange:function(input){
						var valMsg = input.data('interfacerangeMsg');
						if ((valMsg==undefined)) {
							return true;
						}
						if($scope.intportConfDefault)
						{
							var fromVal = parseInt(angular.element("#intRangeFrom").val().split("/")[1]);
							var toVal = parseInt(angular.element("#accessPortsTo").val().split("/")[1]);
							if(toVal<fromVal){
								return false;
							}
						}else{
							return true;
						}
						return true;
					}
                }
            }).data("kendoValidator");

        var portSetValidations = angular.element("#portsConfigSetForm").kendoValidator({
            rules: {
                check: function (input) {
                    var valMsg = input.data('checkMsg');
                        if ((valMsg==undefined)) {
                            return true;
                        }
                    return validationService.validateCheck(input);
                },
                space: function (input) {
                    var valMsg = input.data('spaceMsg');
                        if ((valMsg==undefined)) {
                            return true;
                        }
                    return validationService.validateDataSpace(input);
                },
                range: function (input) {
					if(input.val() != ""){
						var count=0;
						var valMsg = input.data('rangeMsg');
						if ((valMsg==undefined)) {
							return true;
						}
						var min= trimVal(input.prop('min'));
						var max= trimVal(input.prop('max'));
						var arr = input.val().replace('-',',');
						arr= arr.split(',');
						for(var i=0;i<arr.length;i++){
							if(parseFloat(trimVal(arr[i]))>=min && parseFloat(trimVal(arr[i]))<=max) {
								count++;
							}
						}
						if(arr.length!=count){
							return false;
						}
						return true;
					}
					else {
						return true;
					}
				},
				checkVlanList:function(input){
					var valMsg = input.data('checkVlanListMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var regExp=/^[,-]+$/;
					var valStrHy=input.val().includes("--");
					var valStrCom=input.val().includes(",,");
					if(regExp.test(input.val()) || valStrHy || valStrCom || trim(input.val()) == ""){
						return false;
					}
					return true;
				},
                vlancheck: function (input) {
                    var valMsg = input.data('vlancheckMsg');
					if ((valMsg==undefined)){
                        return true;
					}
                    return true;
                },
				validateip: function (input) {
					var valMsg = input.data('validateipMsg');
                    if ((valMsg==undefined)){
                        return true;
					}
					if(input.val().trim() == ""){
						return true;
					}
					return validationService.validateIPAddress(input);
				},
				validatesubnet: function(input){
					var valMsg = input.data('validatesubnetMsg');
                    if ((valMsg==undefined)){
                        return true;
					}
					if(input.val() === "0.0.0.0" || input.val() === "255.255.255.255" || input.val().trim() == ""){
						return true;
					}
					else{
						return input.data('validatesubnetMsg') ? $scope.validateSubnetMask(input.val())  : true;
					}
				}
            }
        }).data("kendoValidator");
		$scope.validateSubnetMask = function(value) {
			if(value == undefined){
				return false;
			} else {
				var subnetRegex = "^((128|192|224|240|248|252|254)\.0\.0\.0)|(255\.(((0|128|192|224|240|248|252|254)\.0\.0)|(255\.(((0|128|192|224|240|248|252|254)\.0)|255\.(0|128|192|224|240|248|252|254)))))$";
				if (new RegExp(subnetRegex).test(value)) {
					return true;
				}
			}
			return false;
		};
		
        var portAdvValidations = angular.element("#portsConfigAdvForm").kendoValidator({
            rules: {
                check: function (input) {
                    return validationService.validateCheck(input);
                },
                space: function (input) {
                    return validationService.validateDataSpace(input);
                },
                range: function (input) {
					if(input.val() != ""){
						var count=0;
						var valMsg = input.data('rangeMsg');
						if ((valMsg==undefined)) {
							return true;
						}
						var min= trimVal(input.prop('min'));
						var max= trimVal(input.prop('max'));
						var arr = input.val().replace('-',',');
						arr= arr.split(',');
						for(var i=0;i<arr.length;i++){
							if(parseFloat(trimVal(arr[i]))>=min && parseFloat(trimVal(arr[i]))<=max) {
								count++;
							}
						}
						if(arr.length!=count){
							return false;
						}
						return true;
					}
					else {
						return true;
					}
				}
            }
        }).data("kendoValidator");
		$scope.portsStormControlStorm = null;
		$scope.autoQos = null;
        var portConfigIpOld="", portConfigSubnetOld="";
		$scope.portModeOld="";
		var getPortDetails= function(portno, multiPortObjs) {
            var findPortIsL3OrL2 = l2L3ports.map(function(e) {
                return e.PortName;
            }).indexOf(portno);

            if(l2L3ports[findPortIsL3OrL2].hasOwnProperty('isRouted') && l2L3ports[findPortIsL3OrL2].isRouted == "no"){
                $scope.l3Port = "on";
            }else{
                $scope.l3Port = "";
            }
            $scope.portNumIdentity = portno;
            if(multiPortObjs){
                $rootScope.portNumIdentityMultiSelect = multiPortObjs;
                if(multiPortObjs.length == 1){
                    $scope.multiSelectedPort[0].routed = $scope.l3Port;
                }
            }
            portDetails = portsDataSourceService.getPortData($scope.selectedPortId);
            portInitialData = angular.copy(portDetails);
			$scope.speedDisable = false;
            $scope.duplexDisable = false;
            /*Display Values*/
            if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
				$scope.speedDisable = false;
				$scope.duplexDisable = false;
				if(portno.indexOf("Gi") !=-1) {
					$scope.speedOptions = dataSourceService.speedOptions();
					$scope.showSeleconDetails=false;
				}else  {
					$scope.speedOptions = dataSourceService.speedSeleconOptions();
					$scope.showSeleconDetails=true;
				}
            } else {
			$scope.speedOptions = dataSourceService.speedOptions();
                                var result = deviceCommunicator.getExecCmdOutput("show interface " + $scope.selectedPortId +" | i media type");
                                if(result.indexOf("Not Present") != -1 || result.indexOf("SFP") != -1){
                                        //Optical port
                                        var portNo = $scope.selectedPortId.substr($scope.selectedPortId.indexOf("/")-1);
                                        var inv = deviceCommunicator.getExecCmdOutput("show inventory | begin " + portNo);
                                        if(inv==""){
                                                //speed and duplex CANNOT be modified
                                                $scope.speedDisable = true;
                                                $scope.duplexDisable = true;
                                        }else{
                                                inv = inv.split("\n")[1];
                                                if(inv != undefined && inv.indexOf("GLC-T") != -1){
                                                        //speed and duplex CAN be modified
                                                } else {
                                                        //speed and duplex CANNOT be modified
                                                        $scope.speedDisable = true;
                                                        $scope.duplexDisable = true;
                                                }
                                        }
                                } else {
                                        //DO NOTHING
                                        //speed and duplex CAN be modified
                                }
	    }
            $scope.autoNegoLimitOptions = dataSourceService.speedAutoOptions();
            $scope.duplexOptions = dataSourceService.duplexOptions();
            $scope.switchModeOptions = dataSourceService.switchModeOptions();
            $scope.stormControlOptions = dataSourceService.stormControlOptions();
            /*To Identify Actual Edit*/
            $scope.portsDuplex = null;
            $scope.switchMode = null;
            $timeout(function(){
                $scope.interfaceId = portDetails.PortId;
                //General config
                $scope.portsDescription = portDetails.Description ? portDetails.Description : "";
                $scope.portsOldDescription = portDetails.Description ? portDetails.Description : "";
                if(portDetails.runSpeed==undefined){
                     $scope.portsSpeed="auto";
                     $scope.portsOldSpeed="auto";
                     $scope.portsAutoSpeed="none";
                     $scope.portsOldAutoSpeed="none";
                     $scope.autoNegotiation=false;
                }else{
                	if(portDetails.runSpeed.indexOf("auto")!=-1){
                		speedArr=portDetails.runSpeed.split(" ");
                		if(speedArr.length>1){
                			$scope.portsSpeed=speedArr[0];
                			$scope.portsAutoSpeed=speedArr[1];
                			$scope.portsOldAutoSpeed=speedArr[1];
                		}else{
                			$scope.portsSpeed=portDetails.runSpeed;
                			$scope.portsAutoSpeed="none";
                			$scope.portsOldAutoSpeed="none";
                		}
                      	$scope.autoNegotiation=false;
                	}else{
                		$scope.portsSpeed = portDetails.Speed;
                		$scope.portsOldSpeed = portDetails.Speed;
                		$scope.portsAutoSpeed="none";
                		$scope.portsOldAutoSpeed="none";
                		$scope.autoNegotiation=true;
                   	}
                }
                $timeout(function(){
                    if(portDetails.runDuplex==undefined){
                        $scope.portsDuplex="auto";
                    }else{
                        $scope.portsDuplex = portDetails.Duplex;
                    }
                },100);
                $scope.portsStatus = portDetails.Status === "disabled" ? translate("toggle_down") : translate("toggle_up");
                $scope.portsOldStatus = portDetails.Status === "disabled" ? translate("toggle_down") : translate("toggle_up");
                //port settings
				$timeout(function(){
					$scope.switchMode = portDetails.SwitchMode === "static access" ? "access" : portDetails.SwitchMode;
				    //$scope.diableSetApplyButton=$scope.diableSetCancelButton = true;
                },500);
                $scope.switchOldMode = portDetails.SwitchMode === "static access" ? "access" : portDetails.SwitchMode;
                $scope.portsAccessVlan = portDetails.accessVlan;
                if (portDetails.voiceVlan!="none"){
                    $scope.portsVoiceVlan = portDetails.voiceVlan;
                    $scope.portsOldVoiceVlan = portDetails.voiceVlan;
                }
                else{
                    $scope.portsVoiceVlan = "";
                    $scope.portsOldVoiceVlan = "";
                }
                $scope.portsAllowedVlan = portDetails.vlanIDs === "ALL" ? "all" : "notall";
                $scope.portsOldAllowedVlan = portDetails.vlanIDs === "ALL" ? "all" : "notall";
                $scope.portsAllowedVlanId = portDetails.vlanIDs !== "ALL" ? portDetails.vlanIDs : "";
                $scope.portsOldAllowedVlanId = portDetails.vlanIDs !== "ALL" ? portDetails.vlanIDs : "";
                $scope.portsNativeVlan = portDetails.nativeVlan;
                if(portDetails.portfast=="disable" || portDetails.portfast==undefined){
                	 $scope.portsPortFast = translate("toggle_off");
                     $scope.portsOldPortFast = translate("toggle_off");
                }else{
                	$scope.portsPortFast = translate("toggle_on");
                    $scope.portsOldPortFast = translate("toggle_on");
                }
                if(portDetails.dhcpsnooping=="" || portDetails.dhcpsnooping==undefined){
               	 	$scope.portsDhcpSnooping = translate("com_disable");
                    $scope.portsOldDhcpSnooping = translate("com_disable");
                }else{
               	 	$scope.portsDhcpSnooping = translate("com_enable");
                    $scope.portsOldDhcpSnooping = translate("com_enable");
                }
                if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
                	$scope.eveClassification=portDetails.eveClassification;
                	$scope.eveClassificationOld=portDetails.eveClassification;
                	$scope.perpetualPoE=portDetails.perpetualPoE;
                	$scope.perpetualPoEOld=portDetails.perpetualPoE;
                }
				//Advance config
				if(portDetails.stormControl == undefined){
                	$scope.portsStormControlStorm = "none";
                	$scope.portsOldStormControlStorm = "none";
					angular.element("#stormControl").val("none");
                }else{
                	$scope.portsStormControlStorm = portDetails.stormControl;
                	$scope.portsOldStormControlStorm = portDetails.stormControl;
					angular.element("#stormControl").val(portDetails.stormControl);
                }
                $scope.portsStormControlBroadcast = portDetails.broadcast;
                $scope.portsStormControlMulticast = portDetails.multicast;
                $scope.portsStormControlUnicast = portDetails.unicast;
             if(($rootScope.deviceInfo.type.indexOf("C2960X") != -1 && $rootScope.deviceInfo.type.indexOf("-LL") == -1) ||
                  ($rootScope.deviceInfo.type.indexOf("C3560CX") != -1) ||
                  ($rootScope.deviceInfo.type.indexOf("2960C") != -1 && $rootScope.deviceInfo.type.indexOf("-S") == -1)  ||
                  ($rootScope.deviceInfo.type.indexOf("WS-C2960+") != -1 && $rootScope.deviceInfo.type.indexOf("-S") == -1) ||
                  ($rootScope.deviceInfo.type.indexOf("2960XR") != -1)  ||
                  ($rootScope.deviceInfo.type.indexOf("2960CX") != -1))   {
            	    $scope.portSettingDeviceL = false;
					$scope.portSettingDeviceX = true;
					$scope.autoQosOptions = dataSourceService.autoQosOptions();
					if(portDetails.autoQOS == undefined){
						$scope.autoQos = "none";
						$scope.autoQosOld = "none";
					}else{
						$scope.autoQos = portDetails.autoQOS;
						$scope.autoQosOld = portDetails.autoQOS;
					}
				}else{
					$scope.portSettingDeviceL = true;
					$scope.portSettingDeviceX = false;
				}
            },1000);
			//portMode
			$scope.isportMode = true;
			if($rootScope.deviceInfo.type.indexOf("C2960XR") != -1 || $rootScope.deviceInfo.type.indexOf("C3560CX") != -1){
				$scope.isRoutedMode = true;
				var findPortMode = requestRoutingService.getShowCmdOutput("show running-config interface "+ $scope.selectedPortId);
				if(findPortMode.indexOf("no switchport") != -1){
					$scope.isportMode = false;
					$scope.isRoutedMode = true;
					$scope.portMode = translate("portconfig_port_routed");
					$scope.portModeOld = "Routed";
					if($scope.multiSelectedPort.length==1){
						var runningconfig = requestRoutingService.getShowCmdOutput("show running-config interface "+ $scope.selectedPortId,"showRunConfig");
						if(runningconfig.ShowRunningGig.wnwebdata.hasOwnProperty("ipaddress")){
							var getIpAddress = runningconfig.ShowRunningGig.wnwebdata.ipaddress;
							var spltIp = getIpAddress.split(" ");
							$scope.portConfigIp = spltIp[0];
	                        portConfigIpOld = spltIp[0];
							$scope.portConfigSubnet = spltIp[1];
	                        portConfigSubnetOld = spltIp[1];
						}	
					}else{
						if($scope.portgroupno!=""){
							var cliop = requestRoutingService.getShowCmdOutput("show running-config interface po"+$scope.portgroupno ,"showRunConfig");
					        var portIPSubnet = cliop.ShowRunningGig.wnwebdata.ipaddress;
					        if(portIPSubnet){
					             var result1 = portIPSubnet.split(" ");
					             $scope.portConfigIp = result1[0];
					             $scope.portConfigSubnet = result1[1];
					        }else{
					              $scope.portConfigIp = "";
					              $scope.portConfigSubnet = "";
					        }
					        if (!$scope.$$phase){
					             $scope.$apply();
					        } 
						}
					}	
				}else{
					$scope.portConfigIp = "";
                    portConfigIpOld = "";
					$scope.portConfigSubnet = "";
                    portConfigSubnetOld = "";
					$scope.isportMode = true;
					$scope.isRoutedMode = false;
					$scope.portMode = translate("com_switch");
					$scope.portModeOld = "Switch";
				}
			}else {
				$scope.isportMode = true;
			}
        };
        function setCharAt(str,index,chr) {
            if(index > str.length-1) return str;
            return str.substr(0,index) + chr + str.substr(index+1);
        }
        //Port setting LAG
        $scope.portSetingLAGLoading = function(multiSelectedPort, showRunConfig){
            $scope.selectedPortsIntRecords = [];
            for(var sel = 0; sel < multiSelectedPort.length; sel++){
                var selectedPorts = $filter('filter')(showRunConfig, {interfaceName:multiSelectedPort[sel].uniqueId},true);
                $scope.selectedPortsIntRecords.push(selectedPorts[0]);
            }
            var retainGroupChannel = "", retainPortGroupType = "";
            angular.forEach($scope.selectedPortsIntRecords, function(value, key) {
                if (value.hasOwnProperty('channelGroup') && value.hasOwnProperty('groupMode')) {
                    retainGroupChannel = value.channelGroup;
                    retainPortGroupType = value.groupMode;
                    var isSameChannelGroup = $filter('filter')($scope.selectedPortsIntRecords, {channelGroup:value.channelGroup},true);
                    if($scope.selectedPortsIntRecords.length === isSameChannelGroup.length){
                        $scope.portgroupno = value.channelGroup;
                        oldPortgroupno = $scope.portgroupno;
                        if(value.groupMode === "passive"){
                            $timeout(function(){
                                $scope.portGroupType = $scope.portGroupTypeOptions[0].portGroupTypeValue;
                            },1000);
                            oldPortGroupType = $scope.portGroupTypeOptions[0].portGroupTypeValue;
                            $scope.portGroupData.keepAliveMode = translate('com_disable');
                            oldKeepAliveMode = $scope.portGroupData.keepAliveMode;
                        }else if(value.groupMode === "on"){
                            $timeout(function(){
                                $scope.portGroupType = $scope.portGroupTypeOptions[2].portGroupTypeValue;
                            },1000);
                                oldPortGroupType = $scope.portGroupTypeOptions[2].portGroupTypeValue;
                        }else if(value.groupMode === "active"){
                            $timeout(function(){
                                $scope.portGroupType = $scope.portGroupTypeOptions[0].portGroupTypeValue;
                            },1000);
                            oldPortGroupType = $scope.portGroupTypeOptions[0].portGroupTypeValue;
                            $scope.portGroupData.keepAliveMode = translate('com_enable');
                            oldKeepAliveMode = $scope.portGroupData.keepAliveMode;
                        }else if(value.groupMode === "desirable"){
                            $timeout(function(){
                                $scope.portGroupType = $scope.portGroupTypeOptions[1].portGroupTypeValue;
                            },1000);
                            oldPortGroupType = $scope.portGroupTypeOptions[1].portGroupTypeValue;
                            $scope.portGroupData.keepAliveMode = translate('com_enable');
                            oldKeepAliveMode = $scope.portGroupData.keepAliveMode;
                        }else if(value.groupMode === "auto"){
                            $timeout(function(){
                                $scope.portGroupType = $scope.portGroupTypeOptions[1].portGroupTypeValue;
                            },1000);
                            oldPortGroupType = $scope.portGroupTypeOptions[1].portGroupTypeValue;
                            $scope.portGroupData.keepAliveMode = translate('com_disable');
                            oldKeepAliveMode = $scope.portGroupData.keepAliveMode;
                        }
                    }else{
                        $scope.portgroupno = retainGroupChannel;
                        oldPortgroupno = $scope.portgroupno;
                    }
                }else{
                    $scope.portgroupno = retainGroupChannel;
                    oldPortgroupno = $scope.portgroupno;
                    if(retainPortGroupType){
                        var groupTypeKeepalive = $scope.formatPortGroupType(retainPortGroupType);
                        $timeout(function(){
                            $scope.portGroupType = groupTypeKeepalive.type;
                        },1000);
                        $scope.portGroupData.keepAliveMode = groupTypeKeepalive.keepalive;
                    }else{
                        $timeout(function(){
                            $scope.portGroupType = $scope.portGroupTypeOptions[0].portGroupTypeValue;
                        },1000);
                        $scope.portGroupData.keepAliveMode = translate("com_enable");
                    }
                    oldPortGroupType = $scope.portGroupType;
                    oldKeepAliveMode = $scope.portGroupData.keepAliveMode;
                }
            });
        };
        $scope.formatPortGroupType = function(mode){
            if(mode === "passive"){
                return {type:$scope.portGroupTypeOptions[0].portGroupTypeValue,keepalive: translate('com_disable')};
            }else if(mode === "on"){
                return {type:$scope.portGroupTypeOptions[2].portGroupTypeValue,keepalive: translate('com_disable')};
            }else if(mode === "active"){
                return {type:$scope.portGroupTypeOptions[0].portGroupTypeValue,keepalive: translate('com_enable')};
            }else if(mode === "desirable"){
                return {type:$scope.portGroupTypeOptions[1].portGroupTypeValue,keepalive: translate('com_enable')};
            }else if(mode === "auto"){
                return {type:$scope.portGroupTypeOptions[1].portGroupTypeValue,keepalive: translate('com_disable')};
            }
        }
        $scope.L2AndL3PortName = function(){
            var portTypeDetails = requestRoutingService.getShowCmdOutput("show running-config", "portsMonPortType");
                portTypeDetails = portTypeDetails.showRun.wnwebdata;
            for(var srconf = 0; srconf < portTypeDetails.length; srconf++){
                if(portTypeDetails[srconf].PortName.indexOf("TenGigabitEthernet")!=-1){
                    portTypeDetails[srconf].PortName=portTypeDetails[srconf].PortName.replace("TenGigabitEthernet","Te")
                }else if(portTypeDetails[srconf].PortName.indexOf("GigabitEthernet")!=-1){
                    portTypeDetails[srconf].PortName=portTypeDetails[srconf].PortName.replace("GigabitEthernet","Gi")
                }else if(portTypeDetails[srconf].PortName.indexOf("FastEthernet")!=-1){
                    portTypeDetails[srconf].PortName=portTypeDetails[srconf].PortName.replace("FastEthernet","Fa")
                }
            }
            return portTypeDetails;
        };
        var l2L3ports = $scope.L2AndL3PortName();
        $scope.formatInterfaceName = function(){
            var showRunConfig = requestRoutingService.getShowCmdOutput("show running-config ", "showRunInterfacesDetails");
            showRunConfig = showRunConfig.ShowInterface.wnwebdata.entry;
            for(var srconf = 0; srconf < showRunConfig.length; srconf++){
                if(showRunConfig[srconf].interfaceName.indexOf("TenGigabitEthernet")!=-1){
                    showRunConfig[srconf].interfaceName=showRunConfig[srconf].interfaceName.replace("TenGigabitEthernet","Te")
                }else if(showRunConfig[srconf].interfaceName.indexOf("GigabitEthernet")!=-1){
                    showRunConfig[srconf].interfaceName=showRunConfig[srconf].interfaceName.replace("GigabitEthernet","Gi")
                }else if(showRunConfig[srconf].interfaceName.indexOf("FastEthernet")!=-1){
                    showRunConfig[srconf].interfaceName=showRunConfig[srconf].interfaceName.replace("FastEthernet","Fa")
                }
            }
            return showRunConfig;
        };
        var showRunConfigRecords = function(){
            var showRunInterfacesDetails = requestRoutingService.getShowCmdOutput("show running-config","showRunInterfacesDetails");
            showRunInterfacesDetails = showRunInterfacesDetails.ShowInterface.wnwebdata.entry;
            for(var srconf = 0; srconf < showRunInterfacesDetails.length; srconf++){
                if(showRunInterfacesDetails[srconf].interfaceName.indexOf("TenGigabitEthernet")!=-1){
                    showRunInterfacesDetails[srconf].interfaceName=showRunInterfacesDetails[srconf].interfaceName.replace("TenGigabitEthernet","Te")
                }else if(showRunInterfacesDetails[srconf].interfaceName.indexOf("GigabitEthernet")!=-1){
                    showRunInterfacesDetails[srconf].interfaceName=showRunInterfacesDetails[srconf].interfaceName.replace("GigabitEthernet","Gi")
                }else if(showRunInterfacesDetails[srconf].interfaceName.indexOf("FastEthernet")!=-1){
                    showRunInterfacesDetails[srconf].interfaceName=showRunInterfacesDetails[srconf].interfaceName.replace("FastEthernet","Fa")
                }
            }
            return showRunInterfacesDetails;
        }
        $scope.showRunConfigRecords = showRunConfigRecords();
        var interfaceData = requestRoutingService.getShowCmdOutput("show interfaces status", "showInterfacesStatus");
        interfaceData= interfaceData.ShowInterfacesStatus.wnwebdata.entry;
        interfacesDataTemp= interfaceData;
        $scope.selectedPortId = interfaceData[0].Port;
		$scope.portNumIdentity = $scope.selectedPortId;
		$scope.currentPortconfig = $scope.selectedPortId;
        $scope.diableGenApplyButton=true;
        $scope.diableGenCancelButton=true;
        $scope.diableSetApplyButton=true;
        $scope.diableSetCancelButton=true;
        $scope.diableAdvApplyButton=true;
        $scope.diableAdvCancelButton=true;
        interfacesDataTemp[0].uniqueId = interfacesDataTemp[0].Port;
        interfacesDataTemp[0].single = true;
        $scope.multiSelectedPort = [];
        $scope.multiSelectedPort.push(interfacesDataTemp[0]);
        $scope.selectedGrpPorts = angular.copy($scope.multiSelectedPort);
        $scope.storedSelectedPort = $scope.multiSelectedPort[0];
        var showRunConfig = $scope.formatInterfaceName();
        getPortDetails($scope.selectedPortId, $scope.multiSelectedPort);
        $scope.currentPortSelected = $scope.selectedPortId;
        $scope.l2L3portConfig = [];
        $scope.confirmationL3Port = function(portName) {
            $scope.defaultPortName = portName;
            $scope.defaultInt = dialogService.dialog({
                content : translate("portconfig_the_port")+portName+" "+translate("portconfig_the_newport_config_msg"),
                title : translate("msg_delete_confirmation_window"),
                messageType : "confirm",
                actionButtons : [{
                    text : translate("com_ok"),
                    callback : "saveDefaultInterface"
                }, {
                    text : translate("com_cancel")
                }],
                onClose:closeFunction
            });
        };
        $scope.loadPortGroups = function(args){
			$scope.portChannelGroup = "";
            if($scope.portgroupno){
			    $scope.portChannelGroup = $scope.portgroupno;				
                var findIntMatchWithGrpNum = $filter('filter')(showRunConfig, {"channelGroup":$scope.portgroupno}, true);
				if(findIntMatchWithGrpNum.length > 0){
					$scope.tempMultiSelectedPort = [];
					$scope.selectedGrpPorts = [];
					$scope.multiSelectedPort = [];
					for(var $match in findIntMatchWithGrpNum){
						var intMatchId = {
							uniqueId: findIntMatchWithGrpNum[$match].interfaceName,
							channelGroup: $scope.portgroupno
						};
						$scope.multiSelectedPort.push(intMatchId);
						$scope.tempMultiSelectedPort.push(intMatchId);
						$scope.selectedGrpPorts.push(intMatchId);
					}
				}
            }else{
				$scope.tempMultiSelectedPort = [];
				$scope.selectedGrpPorts = [];
				$scope.multiSelectedPort = [];
				args.default = "default";
                $scope.multiSelectedPort.push(args);
            }
        };
        var closeFunction = function(e){
            $scope.cancelToDefaultInterface();
        }
        $scope.$on("saveDefaultInterface", function() {
            $scope.saveToDefaultInterface($scope.defaultInt.data("kendoWindow"));
        });
        $scope.saveToDefaultInterface = function (popup) {
            var l3PortIndex = $scope.multiSelectedPort.map(function(e, i) {
                return e.uniqueId;
            }).indexOf($scope.defaultPortName);
            $scope.multiSelectedPort[l3PortIndex].default = "default";
            setTimeout(function() {
                popup.destroy();
            }, 500);
        };
        $scope.cancelToDefaultInterface = function (popup) {
            var l3PortIndex = $scope.multiSelectedPort.map(function(e, i) {
                return e.uniqueId;
            }).indexOf($scope.defaultPortName);
            if(l3PortIndex != -1){
                $scope.multiSelectedPort.splice(l3PortIndex, 1);
                $scope.formatSelectedPortsName($scope.multiSelectedPort);
                getPortDetails($scope.selectedPortId, $scope.multiSelectedPort);
            }
        }
        $scope.$on('portSelected', function(event, args) {
            var showRunConfig = $scope.formatInterfaceName();
            if(args.event.ctrlKey || args.event.metaKey){
                if($scope.multiSelectedPort.length >= 1){
                    if($scope.portgroupno == "" || $scope.portgroupno == undefined){
                        $scope.portConfigIpDisabled = true;
                        $scope.portConfigSubnetDisabled = true;
                    }
                }
                var isSinglePortSelected = angular.element(args.event.target).hasClass('selectSwitch');
                if(!isSinglePortSelected){
                    if(args.object.hasOwnProperty('single')){
                        delete args.object.single;
                    }
                    var isPortAlreadyPresentIndexForMulti = $scope.multiSelectedPort.map(function(e, i) {
                        return e.uniqueId;
                    }).indexOf(args.object.uniqueId);
                    if(isPortAlreadyPresentIndexForMulti != -1){
                        args.object.mSelect = false;
                        $scope.multiSelectedPort.splice(isPortAlreadyPresentIndexForMulti,1);
                        if($scope.tempMultiSelectedPort){
                            var isPortAlreadyPresentIndexForTempMulti = $scope.tempMultiSelectedPort.map(function(e, i) {
                                return e.uniqueId;
                            }).indexOf(args.object.uniqueId);
                            if($scope.tempMultiSelectedPort.length > 0){
                                if($scope.tempMultiSelectedPort[isPortAlreadyPresentIndexForTempMulti]){
                                    $scope.tempMultiSelectedPort[isPortAlreadyPresentIndexForTempMulti].unselected=true;
                                }
                            }
                        }
                    }else{
                        args.object.mSelect = true;
                        if($scope.multiSelectedPort.length > 0){
                            if($scope.multiSelectedPort[0].routed == "on"){
                                args.object.routed = "on";
                            }else{
                                args.object.routed = "";
                            }
                        }
                        if($scope.tempMultiSelectedPort){
                            var unSelectPortsIndex = $scope.tempMultiSelectedPort.map(function(e) {
                                return e.uniqueId;
                            }).indexOf(args.object.uniqueId);
                            if(unSelectPortsIndex != -1){
                                delete $scope.tempMultiSelectedPort[unSelectPortsIndex].unselected;
                            }
                        }
                        var runningconfig = $scope.showRunConfigRecords.map(function(e) {
                            return e.interfaceName;
                        }).indexOf(args.object.uniqueId);
                        if($scope.showRunConfigRecords[runningconfig].hasOwnProperty('channelGroup')){
                            var channelGroup = $scope.showRunConfigRecords[runningconfig].channelGroup;
                            var findIntMatchWithGrpNum = $filter('filter')(showRunConfig, {"channelGroup":channelGroup}, true);
                            var isOne = true;
                            for(var $match in findIntMatchWithGrpNum){
                                if(findIntMatchWithGrpNum[$match].channelGroup != $scope.portChannelGroup){
                                    isOne = false;
                                }
                            }
                            if(!isOne){
                                $scope.confirmationL3Port(args.object.uniqueId);
                            }
                        }else{
                            $scope.confirmationL3Port(args.object.uniqueId);
                        }
                        $scope.multiSelectedPort.push(args.object);
                    }
                }
                $scope.diableSetApplyButton=$scope.diableSetCancelButton = false;
                $scope.diableGenApplyButton=$scope.diableGenCancelButton=false;
            }else{
                if($scope.multiSelectedPort.length == 1){
                    $scope.portConfigIpDisabled = false;
                    $scope.portConfigSubnetDisabled = false;
                }
                $scope.tempMultiSelectedPort = [];
                $scope.selectedGrpPorts = [];
                $scope.multiSelectedPort = [];
                $scope.portChannelGroup = "";
                var selectedPort = args.object;
                $scope.storedSelectedPort = args.object;
                $scope.portConfDefault = false;
                var runningconfig = $scope.showRunConfigRecords.map(function(e) {
                    return e.interfaceName;
                }).indexOf(args.object.uniqueId);
                if($scope.showRunConfigRecords[runningconfig].hasOwnProperty('channelGroup')){
                    $scope.multiSelectedPort = [];
                    var channelGroup = $scope.showRunConfigRecords[runningconfig].channelGroup;
                    $scope.portChannelGroup = channelGroup;
                    var findIntMatchWithGrpNum = $filter('filter')(showRunConfig, {"channelGroup":channelGroup},true);
                    for(var $match in findIntMatchWithGrpNum){
                        var intMatchId = {
                            uniqueId: findIntMatchWithGrpNum[$match].interfaceName,
                            channelGroup: channelGroup
                        };
                        $scope.multiSelectedPort.push(intMatchId);
                        $scope.tempMultiSelectedPort.push(intMatchId);
                        $scope.selectedGrpPorts.push(intMatchId);
                    }
                }else{
                    args.object.default = "default";
                    $scope.multiSelectedPort.push(args.object);
                }
                $scope.selectedPortId = selectedPort.uniqueId;
                //Select the port in the grid
                $scope.diableGenApplyButton=true;
                $scope.diableGenCancelButton=true;
                $scope.diableSetApplyButton=true;
                $scope.diableSetCancelButton=true;
                $scope.diableAdvApplyButton=true;
                $scope.diableAdvCancelButton=true;
                $scope.currentPortconfig = $scope.selectedPortId;
                if (!$scope.$$phase){
                    $scope.$apply();
                }
                $scope.portSetingLAGLoading($scope.multiSelectedPort, showRunConfig);
            }
            $scope.formatSelectedPortsName($scope.multiSelectedPort);
            getPortDetails($scope.selectedPortId, $scope.multiSelectedPort);            
        });
        $scope.formatSelectedPortsName = function(multiSelectedPort){
            var multiPorts = [];
            multiPorts = $.map(multiSelectedPort, function(value, index) {
                var $portNumber = value.uniqueId;
                return [$portNumber];
            });
            multiPorts.sort($scope.naturalCompareSorting);
            var intFa1 = [], intGig1 = [], intTen1 = [], intFa = [], intGig = [], intTen = [];
            for(var p = 0; p < multiPorts.length; p++){
                if(multiPorts[p].split("/")[0].indexOf("Fa") != -1){
                    var multiPortsSplitSlash = multiPorts[p].split("/");
                    intFa1.push(multiPortsSplitSlash[multiPortsSplitSlash.length - 1]);
                    intFa.push(multiPortsSplitSlash);
                }
                if(multiPorts[p].split("/")[0].indexOf("Gi") != -1){
                    var multiPortsSplitSlash = multiPorts[p].split("/");
                    intGig1.push(multiPortsSplitSlash[multiPortsSplitSlash.length - 1]);
                    intGig.push(multiPortsSplitSlash);
                }
                if(multiPorts[p].split("/")[0].indexOf("Te") != -1){
                    var multiPortsSplitSlash = multiPorts[p].split("/");
                    intTen1.push(multiPortsSplitSlash[multiPortsSplitSlash.length - 1]);
                    intTen.push(multiPortsSplitSlash);
                }
            }
            var faListName = "", gigListName = "", teGigListName = "";
            if(intFa1.length > 0){
                var arrIntType = intFa[0];
                var intType;
                if(arrIntType.length > 2){
                    intType = arrIntType[0]+"/"+arrIntType[1]+"/";
                }else{
                    intType = arrIntType[0]+"/";
                }
                faListName = intType+$scope.setPortsGroups(intFa1,intType);
            }
            if(intGig1.length > 0){
                var arrIntType = intGig[0];
                var intType;
                if(arrIntType.length > 2){
                    intType = arrIntType[0]+"/"+arrIntType[1]+"/";
                }else{
                    intType = arrIntType[0]+"/";
                }
                gigListName = intType+$scope.setPortsGroups(intGig1,intType);
            }
            if(intTen1.length > 0){
                var arrIntType = intTen[0];
                var intType;
                if(arrIntType.length > 2){
                    intType = arrIntType[0]+"/"+arrIntType[1]+"/";
                }else{
                    intType = arrIntType[0]+"/";
                }
                teGigListName = intType+$scope.setPortsGroups(intTen1,intType);;
            }
            var currentPortSel = faListName+","+gigListName+","+teGigListName;
            if(currentPortSel.charAt(0) === ","){
                currentPortSel = setCharAt(currentPortSel,0,'');
            }
            var currentPortSelSplit = currentPortSel.split("");
            for (var i=currentPortSelSplit.length-1; i>=0; i--) {
                if(currentPortSelSplit[i] === ","){
                    currentPortSel = setCharAt(currentPortSel,currentPortSel.length - 1,'');
                }else{
                    break;
                }
            }
            $scope.currentPortSelected = currentPortSel;
        };
        var oldPortGroupType="", oldPortgroupno="", oldKeepAliveMode=translate('com_disable');
        //displaying multi selected port
        $scope.naturalCompareSorting = function(a, b) {
            var ax = [], bx = [];

            a.replace(/(\d+)|(\D+)/g, function(_, $1, $2) { ax.push([$1 || Infinity, $2 || ""]) });
            b.replace(/(\d+)|(\D+)/g, function(_, $1, $2) { bx.push([$1 || Infinity, $2 || ""]) });
            
            while(ax.length && bx.length) {
                var an = ax.shift();
                var bn = bx.shift();
                var nn = (an[0] - bn[0]) || an[1].localeCompare(bn[1]);
                if(nn) return nn;
            }

            return ax.length - bx.length;
        }

        $scope.setPortsGroups = function(interfaceNameArr, portName){
            var intNameList = "", firstInt = "", secondInt="", intList = "", singleIntCount = 0, count = 0, diffCount = 0;
                for(var j = 0; j < interfaceNameArr.length; j++){
                    if(j == 0){
                        firstInt = interfaceNameArr[j];                   
                    }else{
                        var intDiff = Number(interfaceNameArr[j]) - Number(interfaceNameArr[j - 1]);
                        if(intDiff == 1){
                            secondInt = interfaceNameArr[j];
                            intList = firstInt +"-"+ secondInt;
                        }else{
                            diffCount++;
                            if(intList == "" && count == 0){
                                intNameList += firstInt;
                                count++;
                            }else{
                                intNameList += intList;
                            }
                            if(intNameList != ""){
                                intNameList += ","+portName;
                            }
                            var nextCount;
                            if(interfaceNameArr[j+1]){
                                nextCount = Number(interfaceNameArr[j+1]) - Number(interfaceNameArr[j]);
                            }else{
                                intNameList += interfaceNameArr[j];
                                nextCount = undefined;
                            }
                            if(nextCount && nextCount != 1){
                                intNameList += interfaceNameArr[j];
                                count++;
                            }
                            firstInt = interfaceNameArr[j];
                            intList="";
                        }
                    }               
                }
                var count1 = 0;
                if(diffCount == 0){          
                    intNameList = intList;
                    count1++;
                }
                if(interfaceNameArr.length == 1){
                    intNameList = firstInt;
                }
                if(count1 == 0){
                    intNameList += intList;
                }
            return intNameList;
        }

        $scope.allowdVlanOnChange = function(){
            $scope.diableSetApplyButton = $scope.diableSetCancelButton = false;
            angular.element("#portsConfigSetForm  span.k-tooltip-validation").hide();
            $scope.portsAllowedVlanId = "";
        }
        $scope.speedNegoOnChange = function(){
        	$scope.diableGenApplyButton = $scope.diableGenCancelButton= false;
            if($scope.portsSpeed=="auto"){
            	$scope.autoNegotiation=false;
            	$scope.portsAutoSpeed="none";
            }else{
            	$scope.autoNegotiation=true;
            	$scope.portsAutoSpeed="none";
            }
        }
        $scope.isAllowedVlan = function () {
            return $scope.portsAllowedVlan === "notall" ? false : true;
        };

        $scope.validateDuplex = function () {
            var _selectedValue = $scope.portsSpeed;
            var duplValue = "half";
            if (_selectedValue === "1000") {
                duplValue = "full";
            }
            else {
                duplValue = $scope.portsDuplex;
            }
            $timeout(function () {
                $scope.portsDuplex = duplValue;
            }, 0);
        };
        angular.element("#duplex").on("focus", function (event,data) {
            $timeout(function(){
                $scope.validateDuplex(data);
            },0);
        });
        angular.element("#speed").on("focus", function (event,data) {
            $timeout(function(){
                $scope.validateDuplex(data);
            },0);
        });
        function changeObjToArr(a,key){
            var op = [];
            for(var a1 in a){
                op.push(a[a1][key]);
            }
            return op;
        }
        // Send Entire CLi's to General Tab Configuration
        $scope.entirePortGenConf = function(multiSelectedPort, j){
            var portsConfigGenCLI = "";
            portsConfigGenCLI += "interface " + multiSelectedPort[j].uniqueId + "\n";
            if ($scope.portsDescription !== "") {
                portsConfigGenCLI += "description " + $scope.portsDescription + "\n";
            }
            else {
                portsConfigGenCLI += "no description" + "\n";
            }
            if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
                if($scope.currentPortconfig.indexOf("Gi") !=-1){
                    if (($scope.portsSpeed != "auto" || $scope.portsDuplex != "half") && ($scope.portsSpeed != "1000" || $scope.portsDuplex != "half") && ($scope.portsSpeed != "1000" || $scope.portsDuplex != "auto") ){
                        if($scope.duplexDisable == false){
                            portsConfigGenCLI += "duplex " + $scope.portsDuplex + "\n";
                        }
                    }
                }else{
                   portsConfigGenCLI += "duplex " + $scope.portsDuplex + "\n";
                }
            }else{
                if (($scope.portsSpeed != "auto" || $scope.portsDuplex != "half") && ($scope.portsSpeed != "1000" || $scope.portsDuplex != "half")){
                    if($scope.duplexDisable == false){
                        portsConfigGenCLI += "duplex " + $scope.portsDuplex + "\n";
                    }
                }
            }
            //applying duplex and speed
            if($scope.portsSpeed != "" && $scope.speedDisable == false){//$scope.portsOldSpeed!=$scope.portsSpeed && 
                portsConfigGenCLI += "speed " + $scope.portsSpeed + "\n";
            }
            //applying port status
            if ($scope.portsStatus ===translate("toggle_up")) {
                portsConfigGenCLI += "no shutdown" + "\n";
            }
            else {
                portsConfigGenCLI += "shutdown" + "\n";
            }
            return portsConfigGenCLI;
        }
        // Send only those changed CLi's to General Tab Configuration
        $scope.onlyChangedPortGenConf = function(multiSelectedPort, j){
            var portsConfigGenCLI = "";
            portsConfigGenCLI += "interface " + multiSelectedPort[j].uniqueId + "\n";
            if($scope.portsOldDescription!=$scope.portsDescription){
                if ($scope.portsDescription !== "") {
                    portsConfigGenCLI += "description " + $scope.portsDescription + "\n";
                }
                else {
                    portsConfigGenCLI += "no description" + "\n";
                }
            }
            if(portDetails.Duplex!=$scope.portsDuplex){
                if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
                    if($scope.currentPortconfig.indexOf("Gi") !=-1){
                        if (($scope.portsSpeed != "auto" || $scope.portsDuplex != "half") && ($scope.portsSpeed != "1000" || $scope.portsDuplex != "half") && ($scope.portsSpeed != "1000" || $scope.portsDuplex != "auto") ){
                            if($scope.duplexDisable == false){
                                portsConfigGenCLI += "duplex " + $scope.portsDuplex + "\n";
                            }
                        }
                    }else{
                       portsConfigGenCLI += "duplex " + $scope.portsDuplex + "\n";
                    }
                }else{
                    if (($scope.portsSpeed != "auto" || $scope.portsDuplex != "half") && ($scope.portsSpeed != "1000" || $scope.portsDuplex != "half")){
                        if($scope.duplexDisable == false){
                            portsConfigGenCLI += "duplex " + $scope.portsDuplex + "\n";
                        }
                    }
                }
            }
            //applying duplex and speed
            if($scope.portsOldSpeed!=$scope.portsSpeed){
                if($scope.portsSpeed != "" && $scope.speedDisable == false){//$scope.portsOldSpeed!=$scope.portsSpeed && 
                    portsConfigGenCLI += "speed " + $scope.portsSpeed + "\n";
                }
            }
            //applying port status
            if($scope.portsOldStatus!=$scope.portsStatus){
                if ($scope.portsStatus ===translate("toggle_up")) {
                    portsConfigGenCLI += "no shutdown" + "\n";
                }
                else {
                    portsConfigGenCLI += "shutdown" + "\n";
                }
            }
            return portsConfigGenCLI;
        };
        $scope.availableGroups = function (groups,assignedGroups) {
            var assignedGroupsIds = {};
            var groupsIds = {};
            var result = [];

            $scope[assignedGroups].forEach(function (el, i) {
              assignedGroupsIds[el.uniqueId] = $scope[assignedGroups][i];
            });

            $scope[groups].forEach(function (el, i) {
              groupsIds[el.uniqueId] = $scope[groups][i];
            });

            for (var i in groupsIds) {
                if (!assignedGroupsIds.hasOwnProperty(i)) {
                    result.push(groupsIds[i]);
                }
            }

            return result;    
        }
        $scope.savePortsGenConf = function () {
            var portsConfigGenCLI = "";
        	var result="";
            if(portGenValidations.validate()) {
                var a = changeObjToArr($scope.multiSelectedPort, "uniqueId");
                var b = changeObjToArr($scope.selectedGrpPorts, "uniqueId");
                $scope.findUnique = a.filter(function(obj) {
                    return b.indexOf(obj) == -1; 
                });
                for(var i = 0; i < $scope.findUnique.length; i++){
                    $scope.findUnique[i] = {uniqueId:$scope.findUnique[i]};
                }
                var extractMultiSelectedPort;
                if($scope.findUnique.length > 0){
                    extractMultiSelectedPort = $scope.availableGroups("multiSelectedPort","findUnique");
                }
                var checkOnlyLAGFields = checkLAGFields();
                for(var j = 0; j < $scope.multiSelectedPort.length; j++){
                    if($scope.findUnique.length > 0){
                        for(var u = 0; u < $scope.findUnique.length; u++){
                            if($scope.multiSelectedPort[j].uniqueId === $scope.findUnique[u].uniqueId){
                               portsConfigGenCLI += $scope.entirePortGenConf($scope.multiSelectedPort, j);
                            }
                        }
                    }else{
                        if(checkOnlyLAGFields){
                            portsConfigGenCLI += $scope.onlyChangedPortGenConf($scope.multiSelectedPort, j);
                        }else{
                            portsConfigGenCLI += $scope.entirePortGenConf($scope.multiSelectedPort, j);
                        }
                    }
                }
                if(extractMultiSelectedPort && extractMultiSelectedPort.length > 0){
                    for(var extract = 0; extract < extractMultiSelectedPort.length; extract++){
                        if(checkOnlyLAGFields){
                            portsConfigGenCLI += $scope.onlyChangedPortGenConf(extractMultiSelectedPort, extract);
                        }else{
                            portsConfigGenCLI += $scope.entirePortGenConf(extractMultiSelectedPort, extract);
                        }
                    }
                }
                result = requestRoutingService.getConfigCmdOutput(portsConfigGenCLI);
    			if (result == "") {
    				notificationService.showNotification(translate('portsconfig_success_msg'), translate('com_config_success_title'), 'success');
    			} else {
    				notificationService.showNotification(result.errorResponse, translate('com_config_fail_title'), 'error');
    			}
				portsConfigGenCLI = "";
				$scope.diableGenApplyButton=true;
				$scope.diableGenCancelButton=true;
				$scope.portConfDefault = false;
                //for(var j1 = 0; j1 < $scope.multiSelectedPort.length; j1++){
    				getPortDetails($scope.multiSelectedPort[0].uniqueId);
                //}
            }
        };
        $scope.cancelPortsGenConf = function () {
            $scope.portsDescription = portInitialData.Description;
            $scope.portsSpeed = portInitialData.Speed;
            $scope.portsDuplex = portInitialData.Duplex;
            $scope.portsStatus =$scope.portsOldStatus;
            $scope.diableGenCancelButton=true;
            $scope.diableGenApplyButton=true;
            $scope.portConfDefault = false;
        };
        $scope.keepAliveOnChange = function(){
            $scope.diableSetApplyButton= false;
            $scope.diableSetCancelButton = false;
        };
        $scope.findPortsMode = function(type, keepAlive){
            if(type === "PAgP" && keepAlive === translate("com_disable")){
                return "auto";
            }else if(type === "PAgP" && keepAlive === translate("com_enable")){
                return "desirable";
            }else if(type === "LACP" && keepAlive === translate("com_disable")){
                return "passive";
            }else if(type === "LACP" && keepAlive === translate("com_enable")){
                return "active";
            }else if(type === "On"){
                return "on";
            }
        }
        // Method for change Object to Array
        function changeObjToArr(a,key){
            var op = [];
            for(var a1 in a){
                op.push(a[a1][key]);
            }
            return op;
        }
		$scope.ipSet = function(ipVal,subVal){
			if($scope.portgroupno){
			$scope.portConfigIp = ipVal;
			$scope.portConfigSubnet =subVal;
			}
		}
        var checkLAGFields = function(portCurrentMode){
        	oldPortGroupType = oldPortGroupType == null ? "LACP" : oldPortGroupType;
        	if(portCurrentMode){
        		if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){ 
		        	if(oldPortgroupno === $scope.portgroupno && oldPortGroupType === $scope.portGroupType && oldKeepAliveMode === $scope.portGroupData.keepAliveMode && $scope.portModeOld === portCurrentMode){
		                return true;
		            }else{
		                return false;
		            }
        	   }else{
        		   if(oldPortgroupno === $scope.portgroupno && oldPortGroupType === $scope.portGroupType && oldKeepAliveMode === $scope.portGroupData.keepAliveMode){
		                return true;
		            }else{
		                return false;
		            } 
        	   }
        	}else{
                  if(oldPortgroupno === $scope.portgroupno && oldPortGroupType === $scope.portGroupType && oldKeepAliveMode === $scope.portGroupData.keepAliveMode){
                    return true;
                  }else{
                    return false;
                  }
        	}
            
        };
        // Send only those changed CLi's to General Tab Configuration
        $scope.onlyChangedPortSetConf = function(multiSelectedPort, j){
            var portsConfigSetCLI = "";
            if(multiSelectedPort[j].hasOwnProperty('default') && j != 0 && multiSelectedPort[j].routed === ""){
                portsConfigSetCLI += "default interface " + multiSelectedPort[j].uniqueId + "\n";
                delete $scope.multiSelectedPort[j]['default']; 
            }
            portsConfigSetCLI += "interface " + multiSelectedPort[j].uniqueId + "\n";
            var portGroupMode = $scope.findPortsMode($scope.portGroupType,$scope.portGroupData.keepAliveMode);
            var checkOnlyLAGFields = checkLAGFields("Switch");
            if(!checkOnlyLAGFields){
                if($scope.portgroupno && (($scope.portgroupno != oldPortgroupno) || (!checkOnlyLAGFields)) ){
                      portsConfigSetCLI += "channel-group "+$scope.portgroupno+" mode "+portGroupMode+" \n";
                }
                else if((angular.isUndefined($scope.portgroupno) || $scope.portgroupno == "")) {
                    portsConfigSetCLI += "no channel-group \n";
                }
            }
            
            if($scope.switchMode !== $scope.switchOldMode){
                portsConfigSetCLI += "switchport mode " + $scope.switchMode + "\n";
            }
            if ($scope.switchMode === "access" || $scope.switchMode === "dynamic auto" || $scope.switchMode === "dynamic desirable") {
                if($scope.portsAccessVlan !== portDetails.accessVlan){
                    if($scope.portsAccessVlan){
                        portsConfigSetCLI += "switchport access vlan " + $scope.portsAccessVlan + "\n";
                    }
                    else {
                        portsConfigSetCLI += "no switchport access vlan \n";
                    }
                }
                if($scope.portsVoiceVlan !== $scope.portsOldVoiceVlan){
                    if($scope.portsVoiceVlan && $scope.portsVoiceVlan != 0 ){
                            portsConfigSetCLI += "switchport voice vlan " + $scope.portsVoiceVlan + "\n";
                    }else {
                        portsConfigSetCLI += "no switchport voice vlan" + "\n";
                    }
                }
            }
            if ($scope.switchMode === "trunk" || $scope.switchMode === "dynamic auto" || $scope.switchMode === "dynamic desirable") {
                if ($scope.portsAllowedVlan === "all") {
                    if($scope.portsAllowedVlan !== $scope.portsOldAllowedVlan && $scope.portsAllowedVlan != undefined){
                          portsConfigSetCLI += "switchport trunk allowed vlan all" + "\n";
                    }
                }
                else {
                    if($scope.portsAllowedVlanId !== $scope.portsOldAllowedVlanId){
                        if(($scope.portsAllowedVlanId != "" || $scope.portsAllowedVlanId != 0)){
                            if($scope.portsAllowedVlanId != undefined ){
                                portsConfigSetCLI += "switchport trunk allowed vlan " + $scope.portsAllowedVlanId + "\n";
                            }
                        }else{
                            portsConfigSetCLI += "no switchport trunk allowed vlan \n";
                        }
                    }
                }
                if($scope.portsNativeVlan !== portDetails.nativeVlan){
                    if($scope.portsNativeVlan){
                        portsConfigSetCLI += "switchport trunk native vlan " + $scope.portsNativeVlan + "\n";
                    }else{
                        portsConfigSetCLI += "no switchport trunk native vlan \n";
                    }
                }
            }
            if($scope.portsPortFast !== $scope.portsOldPortFast){
                if ($scope.portsPortFast === translate("toggle_on")) {
                    portsConfigSetCLI += "spanning-tree portfast" + "\n";
                } else {
                    portsConfigSetCLI += "no spanning-tree portfast" + "\n";
                }
            }
            if($scope.portsDhcpSnooping !== $scope.portsOldDhcpSnooping){
                if ($scope.portsDhcpSnooping === translate("com_enable")) {
                    portsConfigSetCLI += "ip dhcp snooping trust" + "\n";
                } else {
                    portsConfigSetCLI += "no ip dhcp snooping trust" + "\n";
                }
            }
            if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
                if($scope.eveClassification !== $scope.eveClassificationOld) {
                    if ($scope.eveClassification) {
                        portsConfigSetCLI+="power inline port 2-event \n";
                    }else{
                        portsConfigSetCLI+="no power inline port 2-event \n";
                    }
                }
                if($scope.perpetualPoE !== $scope.perpetualPoEOld) {
                    if ($scope.perpetualPoE) {
                        portsConfigSetCLI+="power inline port poe-ha \n";
                    }else{
                        portsConfigSetCLI+="no power inline port poe-ha \n";
                    }
                }
            }
            portsConfigSetCLI+="exit \n";
            return portsConfigSetCLI;
        }
        // Send Entire CLi's to General Tab Configuration
        var newlyAddPorts = false;
        $scope.entirePortSetConf = function(multiSelectedPort, j){
            var portsConfigSetCLI = "";
            if(multiSelectedPort[j].hasOwnProperty('default') && j != 0 && multiSelectedPort[j].routed === ""){
                portsConfigSetCLI += "default interface " + multiSelectedPort[j].uniqueId + "\n";
                delete $scope.multiSelectedPort[j]['default']; 
            }
            portsConfigSetCLI += "interface " + multiSelectedPort[j].uniqueId + "\n";
            var portGroupMode = $scope.findPortsMode($scope.portGroupType,$scope.portGroupData.keepAliveMode);
            var checkOnlyLAGFields = checkLAGFields("Switch");
            if(!checkOnlyLAGFields || newlyAddPorts){
                if($scope.portgroupno){
                    portsConfigSetCLI += "channel-group "+$scope.portgroupno+" mode "+portGroupMode+" \n";
                }
                else if((angular.isUndefined($scope.portgroupno) || $scope.portgroupno == "")) {
                    portsConfigSetCLI += "no channel-group \n";
                }
            }
           
                portsConfigSetCLI += "switchport mode " + $scope.switchMode + "\n";
            if ($scope.switchMode === "access" || $scope.switchMode === "dynamic auto" || $scope.switchMode === "dynamic desirable") {
                if($scope.portsAccessVlan){
                    portsConfigSetCLI += "switchport access vlan " + $scope.portsAccessVlan + "\n";
                }
                else {
                    portsConfigSetCLI += "no switchport access vlan \n";
                }
                if($scope.portsVoiceVlan && $scope.portsVoiceVlan != 0 ){
                        portsConfigSetCLI += "switchport voice vlan " + $scope.portsVoiceVlan + "\n";
                }else {
                    portsConfigSetCLI += "no switchport voice vlan" + "\n";
                }
            }
            if ($scope.switchMode === "trunk" || $scope.switchMode === "dynamic auto" || $scope.switchMode === "dynamic desirable") {
                if ($scope.portsAllowedVlan === "all") {
                    if($scope.portsAllowedVlan != undefined){
                        portsConfigSetCLI += "switchport trunk allowed vlan all" + "\n";
                    }
                }
                else {
                    if(($scope.portsAllowedVlanId != "" || $scope.portsAllowedVlanId != 0)){
                        if($scope.portsAllowedVlanId != undefined ){
                            portsConfigSetCLI += "switchport trunk allowed vlan " + $scope.portsAllowedVlanId + "\n";
                        }
                    }else{
                        portsConfigSetCLI += "no switchport trunk allowed vlan \n";
                    }
                }
                if($scope.portsNativeVlan){
                    portsConfigSetCLI += "switchport trunk native vlan " + $scope.portsNativeVlan + "\n";
                }else{
                    portsConfigSetCLI += "no switchport trunk native vlan \n";
                }
            }
            if ($scope.portsPortFast === translate("toggle_on")) {
                portsConfigSetCLI += "spanning-tree portfast" + "\n";
            } else {
                portsConfigSetCLI += "no spanning-tree portfast" + "\n";
            }
            if ($scope.portsDhcpSnooping === translate("com_enable")) {
                portsConfigSetCLI += "ip dhcp snooping trust" + "\n";
            } else {
                portsConfigSetCLI += "no ip dhcp snooping trust" + "\n";
            }
            if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
                if ($scope.eveClassification) {
                    portsConfigSetCLI+="power inline port 2-event \n";
                }else{
                    portsConfigSetCLI+="no power inline port 2-event \n";
                }
                if ($scope.perpetualPoE) {
                    portsConfigSetCLI+="power inline port poe-ha \n";
                }else{
                    portsConfigSetCLI+="no power inline port poe-ha \n";
                }
            }
            portsConfigSetCLI+="exit \n";
            return portsConfigSetCLI;
        }
        $scope.savePortsSetConf = function () {
            var result="", portsConfigSetCLI = "", portModeConfigSetCLI="";            
            if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
				if ($scope.portMode == translate("portconfig_port_routed")) {
                    if(portSetValidations.validate()) {
                        var unselectedIndexRoute = [];     
                        
                        if($scope.tempMultiSelectedPort){
                            for(var j = 0; j < $scope.tempMultiSelectedPort.length; j++){
                                if($scope.tempMultiSelectedPort[j].unselected){
                                    portModeConfigSetCLI += "interface " + $scope.tempMultiSelectedPort[j].uniqueId + "\n";
                                    portModeConfigSetCLI += "no channel-group \n";
                                    portModeConfigSetCLI += "exit \n";
                                    unselectedIndexRoute.push(j);
                                }
                            }
                            for(var _i = 0; _i < unselectedIndexRoute.length; _i++ ){
                                $scope.tempMultiSelectedPort.splice(unselectedIndexRoute[_i],1);
                            }
                        }
                        var checkOnlyLAGFields = checkLAGFields("Routed");
                        var oldPortGroupMode = $scope.findPortsMode(oldPortGroupType,oldKeepAliveMode);
                        for(var j = 0; j < $scope.multiSelectedPort.length; j++){
                            if($scope.multiSelectedPort[j].hasOwnProperty('default') && j != 0 && $scope.multiSelectedPort[j].routed === "on"){
                                portModeConfigSetCLI += "default interface " + $scope.multiSelectedPort[j].uniqueId + "\n";
                                delete $scope.multiSelectedPort[j]['default']; 
                            }
                        }   
                        if(!checkOnlyLAGFields){
                            for(var j1 = 0; j1 < $scope.multiSelectedPort.length; j1++){
                                if($scope.portgroupno){
                                    portModeConfigSetCLI += "interface " + $scope.multiSelectedPort[j1].uniqueId + "\n";
                                    if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
                                       portModeConfigSetCLI += "no switchport \n";
                                    }
                                    portModeConfigSetCLI += "no channel-group "+$scope.portgroupno+" mode "+oldPortGroupMode+" \n";
                                    portModeConfigSetCLI += "exit \n";
                                }
                                else if((angular.isUndefined($scope.portgroupno) || $scope.portgroupno == "")) {
                                    portModeConfigSetCLI += "interface " + $scope.multiSelectedPort[j1].uniqueId + "\n";
                                    if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
                                       portModeConfigSetCLI += "no switchport \n";
                                    }
                                    portModeConfigSetCLI += "no channel-group \n";
                                    portModeConfigSetCLI += "exit \n";
                                }
                            }
                            if($scope.portgroupno){
    								portModeConfigSetCLI +="interface Po" + $scope.portgroupno + "\n";
    								if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
    								   portModeConfigSetCLI += "no switchport \n";
    								}
    								portModeConfigSetCLI += "exit\n";
    						}
                        }
                        $scope.portConfigIp = $scope.portConfigIp == undefined ? "": $scope.portConfigIp;
						$scope.portConfigSubnet = $scope.portConfigSubnet == undefined ? "": $scope.portConfigSubnet;						
						if($scope.portgroupno && $scope.multiSelectedPort.length > 1){
								portModeConfigSetCLI +="interface Po" + $scope.portgroupno + "\n";								
								if($scope.portConfigIp != "" && $scope.portConfigSubnet != ""){
									portModeConfigSetCLI += "ip address " + $scope.portConfigIp + " " +  $scope.portConfigSubnet + "\n";
								}else{
									portModeConfigSetCLI += "no ip address \n";
								}
								portModeConfigSetCLI += "exit\n";
						}
                        var portGroupMode = $scope.findPortsMode($scope.portGroupType,$scope.portGroupData.keepAliveMode);
					    for(var j = 0; j < $scope.multiSelectedPort.length; j++){
                             portModeConfigSetCLI += "interface " + $scope.multiSelectedPort[j].uniqueId + "\n";
										
							var isOneTime = true; 
							if(!checkOnlyLAGFields){
							     isOneTime = false;
							     if( $scope.portgroupno && (($scope.portgroupno != oldPortgroupno) || (!checkOnlyLAGFields))){                                 
							            portModeConfigSetCLI += "channel-group "+$scope.portgroupno+" mode "+portGroupMode+" \n";
							      }else if((angular.isUndefined($scope.portgroupno) || $scope.portgroupno == "")) {
							            portModeConfigSetCLI += "no channel-group \n";
							      }
							}
							if(!$scope.multiSelectedPort[j].hasOwnProperty('channelGroup') && isOneTime && $scope.portgroupno){
								portModeConfigSetCLI += "no switchport \n";
							    portModeConfigSetCLI += "channel-group "+$scope.portgroupno+" mode "+portGroupMode+" \n";
							}
							
							if($scope.multiSelectedPort.length == 1){								
                                if($scope.portConfigIp != portConfigIpOld || $scope.portConfigSubnet != portConfigSubnetOld){                                	
                                	if($scope.portConfigIp != "" && $scope.portConfigSubnet != ""){
    									portModeConfigSetCLI += "ip address " + $scope.portConfigIp + " " +  $scope.portConfigSubnet + "\n";
    								}else{
    									portModeConfigSetCLI += "no ip address \n";
    								}                                	
                                }
							}
							portModeConfigSetCLI += "exit\n";
						}
					    result = requestRoutingService.getConfigCmdOutput(portModeConfigSetCLI);
                        if (result == "" || (result.errorResponse.indexOf("Creating a port-channel interface Port-channel") != -1)) {
    						notificationService.showNotification(translate('portsconfig_success_msg'), translate('com_config_success_title'), 'success');
    					} else {
    						notificationService.showNotification(result.errorResponse, translate('com_config_fail_title'), 'error');
    					}
					
						var ipVal = $scope.portConfigIp;
						var subVal = $scope.portConfigSubnet;
    					portModeConfigSetCLI = "";
    					$scope.diableSetApplyButton=true;
    					$scope.diableSetCancelButton=true;
						l2L3ports = $scope.L2AndL3PortName();
                        showRunConfig = $scope.formatInterfaceName();
                        $scope.showRunConfigRecords = showRunConfigRecords(); // Loads show running config 
                        $scope.loadPortGroups($scope.storedSelectedPort); // Load ports 
                        $scope.formatSelectedPortsName($scope.multiSelectedPort); // Function for Formating selected ports Text display
                        $scope.portSetingLAGLoading($scope.multiSelectedPort, $scope.formatInterfaceName()); // Function for Loading LAG Field
                        $scope.tempMultiSelectedPort = angular.copy($scope.multiSelectedPort);
                        //for(var j2 = 0; j2 < $scope.multiSelectedPort.length; j2++){
							getPortDetails($scope.storedSelectedPort.uniqueId, $scope.multiSelectedPort);
                        //}
						$scope.ipSet(ipVal ,subVal);
                    }
				}
			}
            if($scope.portMode === translate("com_switch")){
                var unselectedIndex = [];
                if($scope.tempMultiSelectedPort){
                    for(var j = 0; j < $scope.tempMultiSelectedPort.length; j++){
                        if($scope.tempMultiSelectedPort[j].unselected){
                            portsConfigSetCLI += "interface " + $scope.tempMultiSelectedPort[j].uniqueId + "\n";
                            portsConfigSetCLI += "no channel-group \n";
                            portsConfigSetCLI += "exit \n";
                            unselectedIndex.push(j);
                        }
                    }
                    for(var _i = 0; _i < unselectedIndex.length; _i++ ){
                        $scope.tempMultiSelectedPort.splice(unselectedIndex[_i],1);
                    }
                }
                //if(portSetValidations.validate()) {
                var a = changeObjToArr($scope.multiSelectedPort, "uniqueId");
                var b = changeObjToArr($scope.selectedGrpPorts, "uniqueId");
                $scope.findUnique = a.filter(function(obj) {
                    return b.indexOf(obj) == -1; 
                });
                for(var i = 0; i < $scope.findUnique.length; i++){
                    $scope.findUnique[i] = {uniqueId:$scope.findUnique[i]};
                }
                var extractMultiSelectedPort;
                if($scope.findUnique.length > 0){
                    extractMultiSelectedPort = $scope.availableGroups("multiSelectedPort","findUnique");
                }
                var checkOnlyLAGFields = checkLAGFields("Switch");
                var oldPortGroupMode = $scope.findPortsMode(oldPortGroupType,oldKeepAliveMode);
                if(!checkOnlyLAGFields){
                    for(var j1 = 0; j1 < $scope.multiSelectedPort.length; j1++){
                        if($scope.portgroupno){
                            portsConfigSetCLI += "interface " + $scope.multiSelectedPort[j1].uniqueId + "\n";
                            if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
                               portsConfigSetCLI += "switchport \n";
                            }
                            portsConfigSetCLI += "no channel-group "+$scope.portgroupno+" mode "+oldPortGroupMode+" \n";                           
                            portsConfigSetCLI += "exit \n";
                        }
                        else if((angular.isUndefined($scope.portgroupno) || $scope.portgroupno == "")) {
                            portsConfigSetCLI += "interface " + $scope.multiSelectedPort[j1].uniqueId + "\n";
                            if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
                               portsConfigSetCLI += "switchport \n";
                            }
                            portsConfigSetCLI += "no channel-group \n";
                            portsConfigSetCLI += "exit \n";
                        }
                    }
                    if($scope.portgroupno){
                    	portsConfigSetCLI +="interface Po" + $scope.portgroupno + "\n";
						if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
							portsConfigSetCLI += "switchport \n";
						}
						portsConfigSetCLI += "exit\n";
				   }
                }
                for(var j = 0; j < $scope.multiSelectedPort.length; j++){
                    if($scope.findUnique.length > 0){
                        for(var u = 0; u < $scope.findUnique.length; u++){
                            if($scope.multiSelectedPort[j].uniqueId === $scope.findUnique[u].uniqueId){
                                newlyAddPorts = true;
                                portsConfigSetCLI += $scope.entirePortSetConf($scope.multiSelectedPort, j);
                            }
                        }
                    }else{
                        newlyAddPorts = false;
                        if(checkOnlyLAGFields){
                            portsConfigSetCLI += $scope.onlyChangedPortSetConf($scope.multiSelectedPort, j);
                        }else{
                            portsConfigSetCLI += $scope.entirePortSetConf($scope.multiSelectedPort, j);
                        }
                    }
                }
                if(extractMultiSelectedPort && extractMultiSelectedPort.length > 0){
                    for(var extract = 0; extract < extractMultiSelectedPort.length; extract++){
                        if(checkOnlyLAGFields){
                            portsConfigSetCLI += $scope.onlyChangedPortSetConf(extractMultiSelectedPort, extract);
                        }else{
                            portsConfigSetCLI += $scope.entirePortSetConf(extractMultiSelectedPort, extract);
                        }
                    }
                }
			    result = requestRoutingService.getConfigCmdOutput(portsConfigSetCLI);
                if (result == "" || (result.errorResponse.indexOf("Access VLAN does not exist. Creating vlan") != -1) || (result.errorResponse.indexOf("Creating a port-channel interface Port-channel") != -1)) {
					notificationService.showNotification(translate('portsconfig_success_msg'), translate('com_config_success_title'), 'success');
				} else {
					notificationService.showNotification(result.errorResponse, translate('com_config_fail_title'), 'error');
				}
				portsConfigSetCLI = "";
				$scope.diableSetApplyButton=true;
				$scope.diableSetCancelButton=true;
                l2L3ports = $scope.L2AndL3PortName();
                showRunConfig = $scope.formatInterfaceName();
                $scope.showRunConfigRecords = showRunConfigRecords(); // Loads show running config 
                $scope.loadPortGroups($scope.storedSelectedPort); // Load ports 
                $scope.formatSelectedPortsName($scope.multiSelectedPort); // Function for Formating selected ports Text display
                $scope.portSetingLAGLoading($scope.multiSelectedPort, $scope.formatInterfaceName()); // Function for Loading LAG Field
                $scope.tempMultiSelectedPort = angular.copy($scope.multiSelectedPort);
                //for(var j3 = 0; j3 < $scope.multiSelectedPort.length; j3++){
              			getPortDetails($scope.storedSelectedPort.uniqueId, $scope.multiSelectedPort);
                //}
				/*}
				else {
					return false;
				}*/
			}
        };
        $scope.cancelPortsSetConf = function () {
            var showRunConfig = $scope.formatInterfaceName();
            $scope.portSetingLAGLoading($scope.multiSelectedPort, showRunConfig);
            angular.element("#portsConfigSetForm  span.k-tooltip-validation").hide();
            $scope.switchMode = portInitialData.SwitchMode === "static access" ? "access" : portInitialData.SwitchMode;
            $scope.portsVoiceVlan = portInitialData.voiceVlan === "none" ? "" : portInitialData.voiceVlan;
            $scope.portsAccessVlan = portInitialData.accessVlan;
            $scope.portsAllowedVlan = portInitialData.vlanIDs === "ALL" ? "all" : "notall";
            $scope.portsAllowedVlanId = portInitialData.vlanIDs !== "ALL" ? portDetails.vlanIDs : "";
            $scope.portsNativeVlan = portInitialData.nativeVlan;
            $scope.portsPortFast = portInitialData.portfast ? translate("toggle_on") : translate("toggle_off");
            $scope.portsDhcpSnooping = portInitialData.dhcpsnooping ? translate("com_enable") : translate("com_disable");
            $scope.diableSetCancelButton=true;
            $scope.diableSetApplyButton=true;
            $scope.portgroupno = oldPortgroupno;
            $scope.portGroupType = oldPortGroupType;
            $scope.portGroupData.keepAliveMode = oldKeepAliveMode;
			if($rootScope.deviceInfo.type.indexOf("C2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("C3560CX")!=-1){
				$scope.portMode = $scope.portMode ? translate("com_switch") : translate("portconfig_port_routed");
				getPortDetails($scope.selectedPortId);
			}else{
                getPortDetails($scope.selectedPortId, $scope.multiSelectedPort);
            }
        };
		$scope.portGroupNumberOnChange = function(port){
			$scope.diableSetApplyButton=$scope.diableSetCancelButton = false
			if($scope.multiSelectedPort.length>1){
			if($scope.portgroupno != ""){
					$scope.portConfigIpDisabled = false;
					$scope.portConfigSubnetDisabled = false;
				}if($scope.portgroupno == "" || $scope.portgroupno == undefined){
					$scope.portConfigIpDisabled = true;
					$scope.portConfigSubnetDisabled = true;
				}
			}
		}
		$scope.changePortMode = function(){
			$scope.diableSetApplyButton  = false;
			$scope.diableSetCancelButton = false;
			// Port Mode
			if($rootScope.deviceInfo.type.indexOf("C2960XR") != -1 || $rootScope.deviceInfo.type.indexOf("C3560CX") != -1){
				if($scope.portMode == translate("portconfig_port_routed")){
					$scope.isportMode = false;
					$scope.isRoutedMode = true;
				}else{
					$scope.switchMode = "access";
					$scope.isportMode = true;
					$scope.isRoutedMode = false;
				}
			}
		};
        $scope.onlyChangedPortAdvConf = function(multiSelectedPort, j){
            var portsConfigAdvCLI = "";
            portsConfigAdvCLI += "interface " + multiSelectedPort[j].uniqueId + "\n";
            if($scope.portsOldStormControlStorm!=$scope.portsStormControlStorm){
                if ($scope.portsStormControlStorm === "shutdown") {
                    portsConfigAdvCLI += "no storm-control action trap" + "\n";
                    portsConfigAdvCLI += "storm-control action shutdown" + "\n";
                }
                else if ($scope.portsStormControlStorm === "trap") {
                    portsConfigAdvCLI += "storm-control action trap" + "\n";
                    portsConfigAdvCLI += "no storm-control action shutdown" + "\n";
                }
                else {
                    portsConfigAdvCLI += "no storm-control action trap" + "\n";
                    portsConfigAdvCLI += "no storm-control action shutdown" + "\n";
                }
            }
            if(portDetails.broadcast!=$scope.portsStormControlBroadcast){
                if ($scope.portsStormControlBroadcast !== "" && $scope.portsStormControlBroadcast != undefined) {
                    portsConfigAdvCLI += "storm-control broadcast level " + $scope.portsStormControlBroadcast + "\n";
                }
                else {
                    portsConfigAdvCLI += "no storm-control broadcast level " + "\n";
                }
            }
            if(portDetails.multicast!=$scope.portsStormControlMulticast){
                if ($scope.portsStormControlMulticast !== "" && $scope.portsStormControlMulticast != undefined) {
                    portsConfigAdvCLI += "storm-control multicast level " + $scope.portsStormControlMulticast + "\n";
                }
                else {
                    portsConfigAdvCLI += "no storm-control multicast level " + "\n";
                }
            }
            if(portDetails.unicast!=$scope.portsStormControlUnicast){
                if ($scope.portsStormControlUnicast !== "" && $scope.portsStormControlUnicast != undefined) {
                    portsConfigAdvCLI += "storm-control unicast level " + $scope.portsStormControlUnicast + "\n";
                }
                else {
                    portsConfigAdvCLI += "no storm-control unicast level " + "\n";
                }
            }
            return portsConfigAdvCLI;
        }
        $scope.entirePortAdvConf = function(multiSelectedPort, j){
            var portsConfigAdvCLI = "";
            portsConfigAdvCLI += "interface " + multiSelectedPort[j].uniqueId + "\n";
            if ($scope.portsStormControlStorm === "shutdown") {
                portsConfigAdvCLI += "no storm-control action trap" + "\n";
                portsConfigAdvCLI += "storm-control action shutdown" + "\n";
            }
            else if ($scope.portsStormControlStorm === "trap") {
                portsConfigAdvCLI += "storm-control action trap" + "\n";
                portsConfigAdvCLI += "no storm-control action shutdown" + "\n";
            }
            else {
                portsConfigAdvCLI += "no storm-control action trap" + "\n";
                portsConfigAdvCLI += "no storm-control action shutdown" + "\n";
            }
            if ($scope.portsStormControlBroadcast !== "" && $scope.portsStormControlBroadcast != undefined) {
                portsConfigAdvCLI += "storm-control broadcast level " + $scope.portsStormControlBroadcast + "\n";
            }
            else {
                portsConfigAdvCLI += "no storm-control broadcast level " + "\n";
            }
            if ($scope.portsStormControlMulticast !== "" && $scope.portsStormControlMulticast != undefined) {
                portsConfigAdvCLI += "storm-control multicast level " + $scope.portsStormControlMulticast + "\n";
            }
            else {
                portsConfigAdvCLI += "no storm-control multicast level " + "\n";
            }
            if ($scope.portsStormControlUnicast !== "" && $scope.portsStormControlUnicast != undefined) {
                portsConfigAdvCLI += "storm-control unicast level " + $scope.portsStormControlUnicast + "\n";
            }
            else {
                portsConfigAdvCLI += "no storm-control unicast level " + "\n";
            }
            return portsConfigAdvCLI;
        }
        $scope.savePortsAdvConf = function () {
        	var result="";
        	var isAutoQOS=false;
            var portsConfigAdvCLI = "";
            if(portAdvValidations.validate()) {
             for(var j = 0; j < $scope.multiSelectedPort.length; j++){
                var a = changeObjToArr($scope.multiSelectedPort, "uniqueId");
                var b = changeObjToArr($scope.selectedGrpPorts, "uniqueId");
                $scope.findUnique = a.filter(function(obj) {
                    return b.indexOf(obj) == -1; 
                });
                for(var i = 0; i < $scope.findUnique.length; i++){
                    $scope.findUnique[i] = {uniqueId:$scope.findUnique[i]};
                }
                var extractMultiSelectedPort;
                if($scope.findUnique.length > 0){
                    extractMultiSelectedPort = $scope.availableGroups("multiSelectedPort","findUnique");
                }
                var checkOnlyLAGFields = checkLAGFields();
                for(var j = 0; j < $scope.multiSelectedPort.length; j++){
                    if($scope.findUnique.length > 0){
                        for(var u = 0; u < $scope.findUnique.length; u++){
                            if($scope.multiSelectedPort[j].uniqueId === $scope.findUnique[u].uniqueId){
                                portsConfigAdvCLI += $scope.entirePortAdvConf($scope.multiSelectedPort, j);
                            }
                        }
                    }else{
                        if(checkOnlyLAGFields){
                            portsConfigAdvCLI += $scope.onlyChangedPortAdvConf($scope.multiSelectedPort, j);
                        }else{
                            portsConfigAdvCLI += $scope.entirePortAdvConf($scope.multiSelectedPort, j);
                        }
                    }
                }
                if(extractMultiSelectedPort && extractMultiSelectedPort.length > 0){
                    for(var extract = 0; extract < extractMultiSelectedPort.length; extract++){
                        if(checkOnlyLAGFields){
                            portsConfigAdvCLI += $scope.onlyChangedPortAdvConf(extractMultiSelectedPort, extract);
                        }else{
                            portsConfigAdvCLI += $scope.entirePortAdvConf(extractMultiSelectedPort, extract);
                        }
                    }
                }
				if($scope.autoQos && $scope.autoQosOld != $scope.autoQos){
				  isAutoQOS=true;
                  if($scope.autoQos==="none"){
					  portsConfigAdvCLI += "no auto qos " +$scope.autoQosOld+"\n";
				  }else{						
						if($scope.autoQos === "voip trust"){
							if($scope.autoQosOld!="none"){
							   portsConfigAdvCLI += "no auto qos " +$scope.autoQosOld+ "\n";
							}
							portsConfigAdvCLI += "exit \n";
							portsConfigAdvCLI += "no auto qos srnd4 \n";
							portsConfigAdvCLI += "interface " + $scope.interfaceId + "\n";
							portsConfigAdvCLI += "auto qos voip trust \n";
						}else{
							if($scope.autoQosOld!="none"){
								portsConfigAdvCLI += "no auto qos " +$scope.autoQosOld+ "\n";
								portsConfigAdvCLI += "auto qos " +$scope.autoQos+ "\n";
							}else{
								portsConfigAdvCLI += "auto qos " +$scope.autoQos+ "\n";
							}
						}
				   }
				 }
            }
            if(isAutoQOS){
                portsConfigAdvCLI += "exit \n";
				portsConfigAdvCLI+="mls qos map policed-dscp  0 10 18 24 46 to 8\n";
				portsConfigAdvCLI+="mls qos map cos-dscp 0 8 16 24 32 46 48 56\n";
				portsConfigAdvCLI+="mls qos srr-queue output cos-map queue 1 threshold 3 4 5\n";
				portsConfigAdvCLI+="mls qos srr-queue output cos-map queue 2 threshold 1 2\n";
				portsConfigAdvCLI+="mls qos srr-queue output cos-map queue 2 threshold 2 3\n";
				portsConfigAdvCLI+="mls qos srr-queue output cos-map queue 2 threshold 3 6 7\n";
				portsConfigAdvCLI+="mls qos srr-queue output cos-map queue 3 threshold 3 0\n";
				portsConfigAdvCLI+="mls qos srr-queue output cos-map queue 4 threshold 3 1\n";
				portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 1 threshold 3 32 33 40 41 42 43 44 45\n";
				portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 1 threshold 3 46 47\n";
				portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 2 threshold 1 16 17 18 19 20 21 22 23\n";
				portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 2 threshold 1 26 27 28 29 30 31 34 35\n";
				portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 2 threshold 1 36 37 38 39\n";
				portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 2 threshold 2 24\n";
				portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 2 threshold 3 48 49 50 51 52 53 54 55\n";
				portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 2 threshold 3 56 57 58 59 60 61 62 63\n";
				portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 3 threshold 3 0 1 2 3 4 5 6 7\n";
				portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 4 threshold 1 8 9 11 13 15\n";
				portsConfigAdvCLI+="mls qos srr-queue output dscp-map queue 4 threshold 2 10 12 14\n";
				portsConfigAdvCLI+="mls qos queue-set output 1 threshold 1 100 100 50 200\n";
				portsConfigAdvCLI+="mls qos queue-set output 1 threshold 2 125 125 100 400\n";
				portsConfigAdvCLI+="mls qos queue-set output 1 threshold 3 100 100 100 400\n";
				portsConfigAdvCLI+="mls qos queue-set output 1 threshold 4 60 150 50 200\n";
				portsConfigAdvCLI+="mls qos queue-set output 1 buffers 15 25 40 20\n";
				portsConfigAdvCLI+="mls qos\n";
            }
            result = requestRoutingService.getConfigCmdOutput(portsConfigAdvCLI);
			if (result == "") {
				notificationService.showNotification(translate('portsconfig_success_msg'), translate('com_config_success_title'), 'success');
			} else {
				notificationService.showNotification(result.errorResponse, translate('com_config_fail_title'), 'error');
			}
				portsConfigAdvCLI = "";
				$scope.diableAdvApplyButton=true;
				$scope.diableAdvCancelButton=true;
                //for(var j4 = 0; j4 < $scope.multiSelectedPort.length; j4++){
    				getPortDetails($scope.multiSelectedPort[0].uniqueId);
                //}
            }
			else {
			   return false;
			}
        };
        $scope.cancelPortsAdvConf = function () {
            getPortDetails($scope.selectedPortId);
            $scope.portsStormControlStorm = portInitialData.stormControl === undefined ? "none" : portInitialData.stormControl;
            $scope.portsStormControlBroadcast = portInitialData.broadcast;
            $scope.portsStormControlMulticast = portInitialData.multicast;
            $scope.portsStormControlUnicast = portInitialData.unicast;
            $scope.diableAdvCancelButton=true;
            $scope.diableAdvApplyButton=true;
        };
    }
]);
