/**
 Description: Ports Monitoring Controller
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.register.controller('PortsMonitorCtrl', ['$scope','$rootScope','gridCrudService', '$filter','requestRoutingService', '$timeout','executeCliCmdService','getStringLineService','notificationService','dialogService',
    function ($scope,$rootScope,gridCrudService, $filter,requestRoutingService, $timeout,executeCliCmdService,getStringLineService,notificationService,dialogService) {
        var translate = $filter("translate"),exportData = [];
        $scope.clearCounterStatus=true;
        $rootScope.portNumIdentityMultiSelect = [];
        $rootScope.portNumIdentity = "";
        angular.extend($scope, {
            currentPort: ''
        });
        $scope.headersInExport = [translate("ports_monitoring_description_switchport"), translate("ports_monitoring_description_desc"), translate("ports_monitoring_description_status"),
                                  translate("ports_monitoring_description_porttype"), translate("ports_monitoring_description_vlanip"),
                                  translate("ports_monitoring_description_duplex"), translate("ports_monitoring_description_power"), translate("ports_monitoring_description_speed"),
                                  translate("ports_monitoring_description_txbytes"), translate("ports_monitoring_description_rxbytes"), translate("ports_monitoring_description_pktdrop")
                              ];
        var interfaceStatusInfo;
        $scope.showInterfaceStatusInfo = function(){
            interfaceStatusInfo = requestRoutingService.getShowCmdOutput("show interface status", "portsMonStatus");
            interfaceStatusInfo = interfaceStatusInfo.Port.InterfaceStatus.entry;
            interfaceStatusInfo = $filter("filter")(interfaceStatusInfo);
            var portTypeDetails = requestRoutingService.getShowCmdOutput("show running-config", "portsMonPortType");
            portTypeDetails = portTypeDetails.showRun.wnwebdata;
            var vlanIdDetails = new kendo.data.ObservableArray([]);
            for (var ind in interfaceStatusInfo) {
				if (interfaceStatusInfo.hasOwnProperty(ind)) {
					vlanIdDetails.push(interfaceStatusInfo[ind].Vlan);
				}
            }

            var deviceInterface=null;
            for (var i in interfaceStatusInfo){
				if (interfaceStatusInfo.hasOwnProperty(i)) {
					for (var j in portTypeDetails) {
						if (portTypeDetails.hasOwnProperty(j)) {
							deviceInterface=portTypeDetails[j].PortName;
							if(deviceInterface.indexOf("TenGigabitEthernet")!=-1){
								deviceInterface=deviceInterface.replace("TenGigabitEthernet","Te")
							} else if(deviceInterface.indexOf("GigabitEthernet")!=-1){
								deviceInterface=deviceInterface.replace("GigabitEthernet","Gi")
							}else if(deviceInterface.indexOf("FastEthernet")!=-1){
								deviceInterface=deviceInterface.replace("FastEthernet","Fa")
							}
							if(deviceInterface==interfaceStatusInfo[i].Port){
								if(portTypeDetails[j].mode === "trunk" || interfaceStatusInfo[i].Vlan=="trunk") {
									interfaceStatusInfo[i].PortType = "Trunk";
									//Finding set of trunk allowed vlans
									var trunkVlanList="";
									var strCLIOutput = deviceCommunicator.getExecCmdOutput("show running-config int "+deviceInterface+"");
									var OUTPUT_BEGIN = new Array("switchport trunk allowed vlan ");
									var OUTPUT_BEGIN1 = new Array("switchport trunk allowed vlan add ");
									var OUTPUT_END = new Array("\n");
									trunkVlanList = executeCliCmdService.getNextString(strCLIOutput,OUTPUT_BEGIN,OUTPUT_END);
									var strLines = getStringLineService.getLines(strCLIOutput,OUTPUT_BEGIN1);
									if (strLines != null) {
									   for (var m=0; m<strLines.length; m++) {
										   trunkVlanList +=","+executeCliCmdService.getNextString(strLines[m],OUTPUT_BEGIN1,OUTPUT_END);
									   }
									}
									interfaceStatusInfo[i].Vlan=" "+trunkVlanList;
									if(trunkVlanList==""){
										interfaceStatusInfo[i].Vlan= "ALL";
									}
								} else {
									if(portTypeDetails[j].isRouted==="no"){
										interfaceStatusInfo[i].PortType = "Routed";
										interfaceStatusInfo[i].Vlan=portTypeDetails[j].ipAddress;
									}else{
										if(deviceInterface==="Fa0"){
											interfaceStatusInfo[i].PortType = "Routed";											
											if(portTypeDetails[j].ipAddress==="" || portTypeDetails[j].ipAddress===undefined){
											  interfaceStatusInfo[i].Vlan="1";
											}else{
											  interfaceStatusInfo[i].Vlan=portTypeDetails[j].ipAddress;
										    }	
										}else{
											interfaceStatusInfo[i].PortType = "Access";
										}
								  }
							 }
						  }
					  }
					}
                if (interfaceStatusInfo[i].Status == "notconnect") {
                    interfaceStatusInfo[i].Status = "not connected";
                }
			}
            }

            var portsPowerInfo = requestRoutingService.getShowCmdOutput("show power inline", "portsMonPower");
            portsPowerInfo = portsPowerInfo.ShowPowerInline.PowerTable.entry;

            var powerData = new kendo.data.ObservableArray([]);
            for (var c in portsPowerInfo) {
				 if (portsPowerInfo.hasOwnProperty(c)) {
					powerData.push(portsPowerInfo[c].Power);
				 }
            }
            powerData.shift();
            for (var d in interfaceStatusInfo) {
            	if($rootScope.deviceInfo.isPoECapable){
					if (interfaceStatusInfo.hasOwnProperty(d)) {
						interfaceStatusInfo[d].Power = powerData[d];
						if(powerData[d]===undefined){
							interfaceStatusInfo[d].Power ="0.0";
						}
					}else{
	            		interfaceStatusInfo[d].Power ="0.0";
	            	}
            	}else{
            		interfaceStatusInfo[d].Power ="0.0";
            	}
            }
            //setting the packet drop for each interfaces
            var portsPacketDropInfo = requestRoutingService.getShowCmdOutput("show interfaces", "showInterfaceDetails");
            portsPacketDropInfo = portsPacketDropInfo.ShowInterface.wnwebdata.entry;
            var deviceInterface=null;
            for (var i1 in interfaceStatusInfo){
				if (interfaceStatusInfo.hasOwnProperty(i1)) {
					for (var j1 in portsPacketDropInfo) {
						if (portsPacketDropInfo.hasOwnProperty(j1)) {
							deviceInterface=portsPacketDropInfo[j1].interfaceName;
							if(deviceInterface.indexOf("TenGigabitEthernet")!=-1){
								deviceInterface=deviceInterface.replace("TenGigabitEthernet","Te");
							} else if(deviceInterface.indexOf("GigabitEthernet")!=-1){
								deviceInterface=deviceInterface.replace("GigabitEthernet","Gi");
							}else if(deviceInterface.indexOf("FastEthernet")!=-1){
								deviceInterface=deviceInterface.replace("FastEthernet","Fa");
							}
                            if(deviceInterface==interfaceStatusInfo[i1].Port){
                                interfaceStatusInfo[i1].PktDrop=portsPacketDropInfo[j1].totalDrop;
							}else{
								interfaceStatusInfo[i1].PktDrop= "0";
							}
						}
					}
				}
            }
            var arrTotalInByteInterface=[],arrTotalOutByteInterface=[],arrTotalInByte=[],arrTotalOutByte=[],inBytesCount=0;
            var strCLIOutput1 = deviceCommunicator.getExecCmdOutput("show interfaces counters");
			var arrRxTxBytes=strCLIOutput1.split("\n");
            for (var i2=0; i2 < arrRxTxBytes.length; i2++) {
            	if(arrRxTxBytes[i2].indexOf("InOctets")!=-1){
            		inBytesCount=1;
            		continue;
            	}
            	if(arrRxTxBytes[i2].indexOf("OutOctets")!=-1){
            		inBytesCount=0;
            		continue;
            	}
				var arrInnerWords = arrRxTxBytes[i2].split(" ");
				for (var k=0,j2=1; k < arrInnerWords.length; k++) {
					if(arrInnerWords[k] == "") {
			 			continue;
		 			}
					if (j2 == 1) {
						if(inBytesCount==1){
							arrTotalInByteInterface.push(arrInnerWords[k]);
		 				}else{
		 					arrTotalOutByteInterface.push(arrInnerWords[k]);
		 				}
		 			} else if (j2 == 2) {
		 				if(inBytesCount==1){
		 					arrTotalInByte.push(arrInnerWords[k]);
		 				}else{
		 					arrTotalOutByte.push(arrInnerWords[k]);
		 				}
		 			}
		 		   	j2++;
				}
            }
            for (var i3 in interfaceStatusInfo){
				if (interfaceStatusInfo.hasOwnProperty(i3)) {
					for (var j3=0; j3 < arrTotalInByteInterface.length; j3++) {
                        if(arrTotalInByteInterface[j3].trim() != ""){
                            if(arrTotalInByteInterface[j3]==interfaceStatusInfo[i3].Port){
    							interfaceStatusInfo[i3].TxBytes= arrTotalOutByte[j3];
    							interfaceStatusInfo[i3].RxBytes= arrTotalInByte[j3];
    						}
                        }else{
                            //console.log(interfaceStatusInfo, j3)
                            /*interfaceStatusInfo[j3].TxBytes= "0";
                            interfaceStatusInfo[j3].RxBytes= "0";*/
                        }
					}
				}
				if(interfaceStatusInfo[i3].Port==="Fa0"){
					var ethernetcounters = deviceCommunicator.getExecCmdOutput("show controllers ethernet-controller");					
					var fa0counters = ethernetcounters.split("\n");
					var txrxcount = fa0counters[1].trim().split(" ");	
					for(var index=0,fields=1;index<txrxcount.length;index++){
	    				if(txrxcount[index] == "")  {
	    					continue;
	    				}
	    				if(fields == 1){
	    					interfaceStatusInfo[i3].TxBytes=txrxcount[index];
	    				} else if (fields == 3){
	    					interfaceStatusInfo[i3].RxBytes=txrxcount[index];
	    				}
	    				fields++;
	    			}					
				}
            }
        };
        $scope.showInterfaceStatusInfo();
        $scope.portsDataSource = new kendo.data.DataSource({
            pageSize: 10,
            data: interfaceStatusInfo
        });
        //Export Port monitoring data
        $scope.getHeader = function () {
            return $scope.headersInExport;
        };
        $scope.getArray = function () {
            $scope.dataForExport = function () {
            	interfaceStatusInfo.forEach(function (x) {
                        exportData.push({
                            "Port": x.Port,
                            "Name": x.Name,
                            "Status": x.Status,
                            "PortType": x.PortType,
                            "Vlan": x.Vlan,
                            "Duplex": x.Duplex,
                            "Power": x.Power,
                            "Speed": x.Speed,
                            "TxBytes": x.TxBytes,
                            "RxBytes": x.RxBytes,
                            "PktDrop": x.PktDrop
                        })
                    });
                return exportData;
            };
            dateTimeStamp = new Date();
            $scope.portsFileName = "PortsMonitoring" + $filter('date')(dateTimeStamp, 'yyyy-MM-dd_hh-mm-ss');
            exportData = [];
            return $scope.dataForExport;
        };  
        //clear counter value for selected port
        $scope.deleteConfirmation = function() {
			$scope.commonConfirmation('delete');
		};
		$scope.commonConfirmation = function() {
			$scope.dlgCounter = dialogService.dialog({
				content : translate("msg_clear_counter_confirmation"),
				title : translate("msg_delete_confirmation_window"),
				messageType : "confirm",
				actionButtons : [{
					text : translate("com_ok"),
					callback : "counterDeleteConfirmation"
				}, {
					text : translate("com_cancel")
				}]
			});
		};
		$scope.$on("counterDeleteConfirmation", function() {
			$scope.deleteData($scope.dlgCounter.data("kendoWindow"));
		});
		$scope.deleteData = function(popup) {
			var selectedItem =$scope.currentPort;			
			popup.close();	
			var configCLI = "clear counters "+selectedItem;			
			var result = deviceCommunicator.getExecCmdOutput(configCLI);
			if(result===""){
				notificationService.showNotification(translate('clearcounter_success_msg'),translate('com_config_success_title'),'success');
			}else{
				notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
			}
			configCLI="";		
			$scope.manualGridRefresh();
			$scope.portsPacketmanualRefresh();
			$scope.portsStatusmanualRefresh();
			populateGridData(selectedItem);
			$timeout(function(){$scope.clearCounterStatus = true});
			$scope.currentPort = "";
			$rootScope.portNumIdentity = "";
		}
		
        var portsPacketTableInfo = [{
            "PortPackets": translate("ports_monitoring_total")
        }, {
            "PortPackets": translate("ports_monitoring_broadcast")
        }, {
            "PortPackets": translate("ports_monitoring_multicast")
        }, {
            "PortPackets": translate("ports_monitoring_crc_errors")
        }, {
            "PortPackets": translate("ports_monitoring_runts")
        }, {
            "PortPackets": translate("ports_monitoring_errors")
        }];

        var portsStatusTableInfo = [{
            "PortOtherStatus": translate("ports_monitoring_unidirectional_links")
        }, {
            "PortOtherStatus": translate("ports_monitoring_buffer_overflow")
        }, {
            "PortOtherStatus": translate("ports_monitoring_queue_drops")
        }, {
            "PortOtherStatus": translate("ports_monitoring_optics_intserted")
        }, {
            "PortOtherStatus": translate("ports_monitoring_loopback_enabled")
        }];
        var populateGridData = function(newport){
        	$scope.clearCounterStatus=false;
			$scope.currentPort = newport;
			$rootScope.portNumIdentity = newport;
			if (!$scope.$$phase){
				$scope.$apply();
            }
            var portsInterfacesInfo = requestRoutingService.getShowCmdOutput("show interfaces " + newport, "portsMonShowInterfaces");
            portsInterfacesInfo = portsInterfacesInfo.ShowInterfaces.InterfacesDetail.line;
            var ethernetControllerInfo = updateSingleSelectedRow(newport);
            var receiveOctets,receiveUcastPkts,receiveMcastPkts,receiveBcastPkts,sentOctets,sentUcastPkts,sentMcastPkts,sentBcastPkts;
            if(ethernetControllerInfo.indexOf("Counters information is not available")!=-1){
            	receiveOctets="NA";
				receiveUcastPkts="NA";
				receiveMcastPkts="NA";
				receiveBcastPkts="NA";
				sentOctets="NA";
				sentUcastPkts="NA";
				sentMcastPkts="NA";
				sentBcastPkts="NA";
             }else{
            	var arrPort=ethernetControllerInfo.split("\n");
    			var dataIn = arrPort[1].split(" ");
    			var dataOut = arrPort[4].split(" ");
    			for(var index=0,fields=1;index<dataIn.length;index++){
    				if(dataIn[index] == "")  {
    					continue;
    				}
    				if(fields == 2){
    					receiveOctets=dataIn[index];
    				} else if (fields == 3){
    					receiveUcastPkts=dataIn[index];
    				} else if(fields == 4){
    					receiveMcastPkts=dataIn[index];
    				} else if(fields == 5){
    					receiveBcastPkts=dataIn[index];
    				}
    				fields++;
    			}
    			for(var index1=0,fields1=1;index1<dataOut.length;index1++){
    				if(dataOut[index1]== "")  {
    					continue;
    				}
    				if(fields1 == 2){
    					sentOctets=dataOut[index1];
    				} else if (fields1 == 3){
    					sentUcastPkts=dataOut[index1];
    				} else if(fields1 == 4){
    					sentMcastPkts=dataOut[index1];
    				} else if(fields1 == 5){
    					sentBcastPkts=dataOut[index1];
    				}
    				fields1++;
    			}
            }
		    var counterErrorsInfo= requestRoutingService.getShowCmdOutput("show interfaces "+ newport +" counters errors ", "portsMonCounterErrors");
		    var counterErrorsInfo1 = deviceCommunicator.getExecCmdOutput("show interfaces "+ newport +" counters errors");
		    if(counterErrorsInfo1.indexOf("Counters information is not available")!=-1){
		    	counterErrorsInfo.crcReceived="NA";
	            counterErrorsInfo.runtsReceived="NA";
	            counterErrorsInfo.crcSent="NA";
	            counterErrorsInfo.runtSent="NA";
		    }else{
	            counterErrorsInfo = counterErrorsInfo.Port;
	            counterErrorsInfo.crcReceived=counterErrorsInfo.InterfaceCounters1.entry.crcReceived;
	            counterErrorsInfo.runtsReceived=counterErrorsInfo.InterfaceCounters2.entry.runtsReceived;
	            counterErrorsInfo.crcSent="0";
	            counterErrorsInfo.runtSent="0";
            }

            var udldInfo = requestRoutingService.getShowCmdOutput("show udld " + newport, "portsMonUdld");
            udldInfo = udldInfo.ShowUdld.Port;
            var sfpInf="Not Present";
            for (var i in interfaceStatusInfo){
               	if(newport===interfaceStatusInfo[i].Port && interfaceStatusInfo[i].Type==="10/100/1000BaseTX"){
               		sfpInf="NA";
               	}
           }
            var deviceInterface=null;
            var portsInventoryInfo = requestRoutingService.getShowCmdOutput("show inventory", "portsMonInventory");
            if(portsInventoryInfo.ShowInventory.name){
	            if (portsInventoryInfo.ShowInventory.name.length > 0) {
	               for (var i4 in portsInventoryInfo.ShowInventory.name) {
	                    intname = portsInventoryInfo.ShowInventory.name[i4].interfaceName.replace(/\,/g,"");
	                    sfpInfo = portsInventoryInfo.ShowInventory.name[i4].sfpInfo.replace(/\,/g,"");
	                    pid = portsInventoryInfo.ShowInventory.name[i4].pid.replace(/\,/g,"");
	                    intname = portsInventoryInfo.ShowInventory.name[i4].interfaceName.replace(/"/g,"");
	                    intname = intname.replace(",","");
	                    sfpInfo = portsInventoryInfo.ShowInventory.name[i4].sfpInfo.replace(/"/g,"");
	                    pid = portsInventoryInfo.ShowInventory.name[i4].pid.replace(/"/g,"");
	                    deviceInterface=intname;
	                    if(deviceInterface.indexOf("TenGigabitEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("TenGigabitEthernet","Te");
	                	}else if(deviceInterface.indexOf("GigabitEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("GigabitEthernet","Gi");
	                	}else if(deviceInterface.indexOf("FastEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("FastEthernet","Fa");
	                	}
	                    if (deviceInterface ==newport){
	                         sfpInf=sfpInfo;
	                    }
					}
	            }else{
	            	 intname = portsInventoryInfo.ShowInventory.name.interfaceName.replace(/\,/g,"");
	                 sfpInfo = portsInventoryInfo.ShowInventory.name.sfpInfo.replace(/\,/g,"");
	                 pid     = portsInventoryInfo.ShowInventory.name.pid.replace(/\,/g,"");
	                 intname = portsInventoryInfo.ShowInventory.name.interfaceName.replace(/"/g,"");
	                 intname = intname.replace(",","");
	                 sfpInfo = portsInventoryInfo.ShowInventory.name.sfpInfo.replace(/"/g,"");
	                 pid     = portsInventoryInfo.ShowInventory.name.pid.replace(/"/g,"");
	                 deviceInterface=intname;
	                 if(deviceInterface.indexOf("TenGigabitEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("TenGigabitEthernet","Te");
	                 }else if(deviceInterface.indexOf("GigabitEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("GigabitEthernet","Gi");
	                 }else if(deviceInterface.indexOf("FastEthernet")!=-1){
	                		deviceInterface=deviceInterface.replace("FastEthernet","Fa");
	                 }
	                 if (deviceInterface ==newport){
	                         sfpInf=sfpInfo;
	                 }
	            }
            }
            portsInterfacesInfo.totalErrors = parseInt(portsInterfacesInfo.inputErrors) + parseInt(portsInterfacesInfo.outputErrors);
            var packetsTotal,broadcastFramesTotalData,multicastFramesTotalData;
            if(receiveOctets=="NA"){
            	packetsTotal="NA";
            	broadcastFramesTotalData="NA";
            	multicastFramesTotalData="NA";
            }else{
            	packetsTotal= parseInt(receiveOctets) + parseInt(sentOctets);
            	broadcastFramesTotalData = parseInt(receiveBcastPkts) + parseInt(sentBcastPkts);
            	multicastFramesTotalData = parseInt(receiveMcastPkts) + parseInt(sentMcastPkts);
            }
            if(udldInfo.uniDirectionalLinks=="Unknown"){
                udldInfo.uniDirectionalLinksState = "Yes";
            }
            else{
                udldInfo.uniDirectionalLinksState = "No";
			}
            if(portsInterfacesInfo.loopback =="not set"){
                portsInterfacesInfo.loopbackinfo = "No";
			}
            else{
                portsInterfacesInfo.loopbackinfo = "Yes";
			}
            if(udldInfo==""){
            	udldInfo.uniDirectionalLinksState="NA";
            }
            var portsPacketTableInfo = [{
                "PortPackets": translate("ports_monitoring_total"),
                "TotalPackets": packetsTotal,
                "SentPackets": sentOctets,
                "ReceivedPackets":receiveOctets
            }, {
                "PortPackets": translate("ports_monitoring_broadcast"),
                "TotalPackets": broadcastFramesTotalData,
                "SentPackets": sentBcastPkts,
                "ReceivedPackets": receiveBcastPkts
            }, {
                "PortPackets": translate("ports_monitoring_multicast"),
                "TotalPackets": multicastFramesTotalData,
                "SentPackets": sentMcastPkts,
                "ReceivedPackets": receiveMcastPkts
            }, {
                "PortPackets": translate("ports_monitoring_crc_errors"),
                "TotalPackets": portsInterfacesInfo.totalCRC,
                "SentPackets": counterErrorsInfo.crcSent,
                "ReceivedPackets": portsInterfacesInfo.totalCRC
            }, {
                "PortPackets": translate("ports_monitoring_runts"),
                "TotalPackets": portsInterfacesInfo.totalRunts,
                "SentPackets": counterErrorsInfo.runtSent,
                "ReceivedPackets": counterErrorsInfo.runtsReceived
            }, {
                "PortPackets": translate("ports_monitoring_errors"),
                "TotalPackets": portsInterfacesInfo.totalErrors,
                "SentPackets":portsInterfacesInfo.outputErrors,
                "ReceivedPackets": portsInterfacesInfo.inputErrors
            }];
            angular.element("#portsPacketGrid").data('kendoGrid').dataSource.data([]);
            for (var i5=0;i5<portsPacketTableInfo.length; i5++ ) {
                $scope.portsPacketGrid.dataSource.add({
                    "PortPackets":portsPacketTableInfo[i5].PortPackets,
                    "TotalPackets": portsPacketTableInfo[i5].TotalPackets,
                    "SentPackets": portsPacketTableInfo[i5].SentPackets,
                    "ReceivedPackets": portsPacketTableInfo[i5].ReceivedPackets
                });
            }
            var portsStatusTableInfo = [{
                "PortOtherStatus": translate("ports_monitoring_unidirectional_links"),
                "PortStatus": udldInfo.uniDirectionalLinksState
            }, {
                "PortOtherStatus": translate("ports_monitoring_buffer_overflow"),
                "PortStatus": portsInterfacesInfo.outputbuffers
            }, {
                "PortOtherStatus": translate("ports_monitoring_queue_drops"),
                "PortStatus": portsInterfacesInfo.queueDrops
            },  {
                "PortOtherStatus": translate("ports_monitoring_optics_intserted"),
                "PortStatus":sfpInf
            }, {
                "PortOtherStatus": translate("ports_monitoring_loopback_enabled"),
                "PortStatus": portsInterfacesInfo.loopbackinfo
            }];
            angular.element("#portsStatusGrid").data('kendoGrid').dataSource.data([]);
            for (var i6=0;i6<portsStatusTableInfo.length; i6++ ) {
                $scope.portsStatusGrid.dataSource.add({
                    "PortOtherStatus":portsStatusTableInfo[i6].PortOtherStatus,
                    "PortStatus": portsStatusTableInfo[i6].PortStatus
                });
            }
        };
        function unpopulateGridData(){
            var portsPacketTableInfo = [{
                "PortPackets": translate("ports_monitoring_total"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets":""
            }, {
                "PortPackets": translate("ports_monitoring_broadcast"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets": ""
            }, {
                "PortPackets": translate("ports_monitoring_multicast"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets": ""
            }, {
                "PortPackets": translate("ports_monitoring_crc_errors"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets": ""
            }, {
                "PortPackets": translate("ports_monitoring_runts"),
                "TotalPackets": "",
                "SentPackets": "",
                "ReceivedPackets": ""
            }, {
                "PortPackets": translate("ports_monitoring_errors"),
                "TotalPackets": "",
                "SentPackets":"",
                "ReceivedPackets": ""
            }];
            angular.element("#portsPacketGrid").data('kendoGrid').dataSource.data([]);
            for (var i7=0;i7<portsPacketTableInfo.length; i7++ ) {
                $scope.portsPacketGrid.dataSource.add({
                    "PortPackets":portsPacketTableInfo[i7].PortPackets,
                    "TotalPackets": portsPacketTableInfo[i7].TotalPackets,
                    "SentPackets": portsPacketTableInfo[i7].SentPackets,
                    "ReceivedPackets": portsPacketTableInfo[i7].ReceivedPackets
                });
            }
            var portsStatusTableInfo = [{
                "PortOtherStatus": translate("ports_monitoring_unidirectional_links"),
                "PortStatus": ""
            }, {
                "PortOtherStatus": translate("ports_monitoring_buffer_overflow"),
                "PortStatus": ""
            }, {
                "PortOtherStatus": translate("ports_monitoring_queue_drops"),
                "PortStatus": ""
            },  {
                "PortOtherStatus": translate("ports_monitoring_optics_intserted"),
                "PortStatus":""
            }, {
                "PortOtherStatus": translate("ports_monitoring_loopback_enabled"),
                "PortStatus": ""
            }];
            angular.element("#portsStatusGrid").data('kendoGrid').dataSource.data([]);
            for (var i8=0;i8<portsStatusTableInfo.length; i8++ ) {
                $scope.portsStatusGrid.dataSource.add({
                    "PortOtherStatus":portsStatusTableInfo[i8].PortOtherStatus,
                    "PortStatus": portsStatusTableInfo[i8].PortStatus
                });
            }
        };
        $scope.$on('portSelected', function(event, args) {
            var selectedPort = args.object;
             //Select the port in the grid
            if(selectedPort!=null) {
            	populateGridData(selectedPort.uniqueId);
 				var nIndex;
 				angular.forEach($scope.portsGrid._data, function($value,$index){
 					var allElement = $scope.portsGrid.tbody[0].childNodes[$index];
 					angular.element(allElement).removeClass("k-state-selected");
 					if($value.Port == selectedPort.uniqueId){
 						nIndex = $index;
 						var curElement = $scope.portsGrid.tbody[0].childNodes[nIndex];
 						angular.element(curElement).addClass("k-state-selected");
 					}
 				});
            }
            else{
            	$scope.currentPort = "";
				$rootScope.portNumIdentity = "";
                unpopulateGridData();
            }
        });
        var showPortEdit = function () {
            var selected = this.dataItem(this.select());
            if(selected!=null) {
                var newport = selected.Port;
                populateGridData(newport);
            } else{
            	$scope.currentPort = "";
				$rootScope.portNumIdentity = "";
                unpopulateGridData();
                $scope.clearCounterStatus=true;
            }
        };
        $scope.portsPacketDataSource = new kendo.data.DataSource({
            pageSize : 10,
            data : portsPacketTableInfo
        });
        $scope.portsStatusDataSource = new kendo.data.DataSource({
            pageSize : 10,
            data : portsStatusTableInfo
        });
        $scope.etherChannelSummary = function(){
            var etherChannelSum = requestRoutingService.getShowCmdOutput("show etherchannel summary", "etherChannelSummary");
            if(angular.isUndefined(etherChannelSum.ShowEtherChannelSummary.EtherTable.entry)){
                $scope.etherChannelSumData = [];
            }else if(!angular.isArray(etherChannelSum.ShowEtherChannelSummary.EtherTable.entry)){
                $scope.etherChannelSumData = [etherChannelSum.ShowEtherChannelSummary.EtherTable.entry];
            }else{
                $scope.etherChannelSumData = etherChannelSum.ShowEtherChannelSummary.EtherTable.entry;
            }
            for(var ether=0; ether < $scope.etherChannelSumData.length; ether++){
                $scope.etherChannelSumData[ether].portChannel = $scope.etherChannelSumData[ether].portChannel.replace(/ *\([^)]*\) */g, "");
                $scope.etherChannelSumData[ether].ports = $scope.etherChannelSumData[ether].ports.replace(/ *\([^)]*\) */g, ",").replace(/\,$/, '');
            }
        };
        $scope.etherChannelSummary();
        $scope.etherChannelDataSource = new kendo.data.DataSource({
            pageSize : 10,
            data : $scope.etherChannelSumData
        });
        $scope.formatDefaultValueTemplate = function(value,num){
            if(!value){
                value = num;
            }
            return value;
        };
        $scope.portsGridOptions = {
            editable: false,
            sortable: true,
            reorderable: true,
            change: showPortEdit,
            filterable: {
                extra: false,
                operators: {
                    string: {
                    	eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
                    }
                },
                messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
            },
            scrollable: false,
            selectable: true,
            pageable: {
            	messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
                previousNext: true,
                info: true,
                refresh: true,
                pageSizes: gridCrudService.grid_page_sizes,
                buttonCount: 5
            },
            columns: [{
                field: "Port",
                title: translate("ports_monitoring_description_switchport"),
                width:20
            }, {
                field: "Name",
                title: translate("ports_monitoring_description_desc"),
                width:20
            }, {
                field: "Status",
                title: translate("ports_monitoring_description_status"),
                width:20
            }, {
                field: "PortType",
                title: translate("ports_monitoring_description_porttype"),
                width:20
            }, {
                field: "Vlan",
                title: translate("ports_monitoring_description_vlanip"),
                template : "{{ formatDefaultValueTemplate(dataItem.Vlan,1) }}",
                width:20
            }, {
                field: "Duplex",
                title: translate("ports_monitoring_description_duplex"),
                width:20
            }, {
                field: "Power",
                title: translate("ports_monitoring_description_power"),
                width:20
            }, {
                field: "Speed",
                title: translate("ports_monitoring_description_speed"),
                width:20
            }, {
                field: "TxBytes",
                title: translate("ports_monitoring_description_txbytes"),
                template : "{{ formatDefaultValueTemplate(dataItem.TxBytes,0) }}",
                width:20
            }, {
                field: "RxBytes",
                title: translate("ports_monitoring_description_rxbytes"),
                template : "{{ formatDefaultValueTemplate(dataItem.RxBytes,0) }}",
                width:20
            }, {
                field : "PktDrop",
                title: translate("ports_monitoring_description_pktdrop"),
                template : "{{ formatDefaultValueTemplate(dataItem.PktDrop,0) }}",
                width:20
            }]
        };
        
        $timeout(function(){
            angular.element("#portsGrid").find('.k-pager-refresh').click(function(){
				$rootScope.portNumIdentity = "";
                $scope.manualGridRefresh();
				$scope.portsPacketmanualRefresh();
				$scope.portsStatusmanualRefresh();
            });
        },10);
        // Manual refresh the kendo ui grid table
        $scope.manualGridRefresh = function() {
            $scope.showInterfaceStatusInfo();
            var grid = angular.element("#portsGrid").data("kendoGrid");
            $scope.formGridData = new kendo.data.ObservableArray(interfaceStatusInfo);
            $scope.portsDataSource = new kendo.data.DataSource({
                pageSize: 10,
                data: $scope.formGridData
            });
            grid.dataSource = $scope.portsDataSource;
            $scope.portsDataSource.read();
            grid.refresh();
            $scope.currentPort = "";
            $timeout(function(){$scope.clearCounterStatus = true});
        }
        var updateSingleSelectedRow = function(newport){
            var portIndex = $scope.portsDataSource._data.map(function(e) {
                    return e.Port;
                }).indexOf(newport);
            var ethernetControllerInfo = deviceCommunicator.getExecCmdOutput("show interfaces "+ newport +" counters ");
            var arrPort=ethernetControllerInfo.split("\n");
            var dataIn = arrPort[1].split(" ");
            var dataOut = arrPort[4].split(" ");
            var receiveOctets,sentOctets;
            for(var index=0,fields=1;index<dataIn.length;index++){
                if(dataIn[index] == "")  {
                    continue;
                }
                if(fields == 2){
                    receiveOctets=dataIn[index];
                }
                fields++;
            }
            for(var index1=0,fields1=1;index1<dataOut.length;index1++){
                if(dataOut[index1]== "")  {
                    continue;
                }
                if(fields1 == 2){
                    sentOctets=dataOut[index1];
                }
                fields1++;
            }
            $scope.portsDataSource._data[portIndex].RxBytes = receiveOctets;
            $scope.portsDataSource._data[portIndex].TxBytes = sentOctets;
            return ethernetControllerInfo;
        };
		$scope.portsPacketmanualRefresh = function(){
			var grid = angular.element("#portsPacketGrid").data("kendoGrid");
			$scope.portsPacketDataSource = new kendo.data.DataSource({
				pageSize : 10,
				data : portsPacketTableInfo
			});
			grid.dataSource = $scope.portsPacketDataSource;
            $scope.portsPacketDataSource.read();
            grid.refresh();
		}
		$scope.portsStatusmanualRefresh = function(){
			var grid = angular.element("#portsStatusGrid").data("kendoGrid");
			$scope.portsStatusDataSource = new kendo.data.DataSource({
				pageSize : 10,
				data : portsStatusTableInfo
			});
			grid.dataSource = $scope.portsStatusDataSource;
            $scope.portsStatusDataSource.read();
            grid.refresh();
		}
        $scope.portsPacketGridOptions = {
            editable: false,
            sortable: true,
			filterable:false,
            scrollable: false,
            selectable: true,
            columns: [{
                field: "PortPackets",
                title: translate("ports_monitoring_packets")
            }, {
                field: "TotalPackets",
                title: translate("ports_monitoring_total")
            }, {
                field: "SentPackets",
                title: translate("ports_monitoring_sent")
            }, {
                field: "ReceivedPackets",
                title: translate("ports_monitoring_received")
            }]
        };



        $scope.portsStatusGridOptions = {
            editable: false,
            sortable: true,
            filterable:false,
            scrollable: false,
            selectable: true,
            columns: [{
                field: "PortOtherStatus",
                title: translate("ports_monitoring_otherstatus"),
                width: "60%"
            }, {
                field: "PortStatus",
                title: translate("ports_monitoring_status"),
                width: "40%"
            }]
        };
        $scope.etherChannelGridOptions = {
            editable : false,
            sortable : true,
            filterable : {
                extra : false,
                operators : {
                    string : {
                        eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
                    }
                },
                messages : {
                    info: translate("com_page_dropDowntext"),
                    filter: translate("com_btn_filter"),
                    clear: translate("com_btn_clear")
                }
            },
            scrollable : false,
            selectable : true,
            pageable : {
                 messages: {
                      display: translate("com_page_display"),
                      empty: translate("com_page_empty"),
                      page: translate("com_page_pagetext"),
                      of:translate("com_page_of"),
                      itemsPerPage: translate("com_page_itemsPerPage"),
                      first: translate("com_page_first"),
                      previous: translate("com_page_previous"),
                      next: translate("com_page_next"),
                      last: translate("com_page_last"),
                      refresh: translate("com_page_refresh"),
                      morePages: translate("com_page_morePage")
                },
                previousNext : true,
                info : true,
                pageSizes : gridCrudService.grid_page_sizes,
                buttonCount : 5
            },
            columns: [{
                field: "group",
                title: translate("management_snmp_v3user_group")
            }, {
                field: "portChannel",
                title: translate("etherchannel_port_hannel")
            },{
                field: "protocol",
                title: translate("etherchannel_protocol")
            },{
                field: "ports",
                title: translate("com_ports")
            }]
        };
    }
]);
