/**
 Description: Controller for Trouble Shooting
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.register.controller('troubleShootCtrl', ['$scope','$rootScope','$filter','gridCrudService','requestRoutingService','executeCliCmdService','$timeout','getStringLineService','notificationService','dialogService','validationService','httpServices',
	function($scope,$rootScope,$filter,gridCrudService,requestRoutingService,executeCliCmdService,$timeout,getStringLineService,notificationService,dialogService,validationService,httpServices) {
		var translate = $filter("translate");
		$scope.showStackRestart = ($rootScope.deviceInfo.stackingInfo.type === "STACK");
		$scope.statusMsg="";
		$scope.showTick = true;
		var chartStatus=0;
		$scope.pingSource="";
		$scope.diagnosticTest="";
		$scope.disablePing = true;
		$scope.disableTrace = true; 
		$scope.diableDiagnostic = true;			
		$rootScope.portNumIdentity = "";
		$scope.switchDisplayreboot = false;
		$scope.switchDisplayfindSwitch = false;
		// Ping validation
		var pingValidations = angular.element("#pingForm").kendoValidator({
			rules: {
				validateip : function(input) {
					if (input.val()){
						if (angular.isUndefined(input.data('validateIp'))) {
							return true;
						}
						if ( !isNaN(parseInt(input.val())) ){
							return checkValidateIP(input.val());
						}
						return true;
					}
				}
			}
		}).data("kendoValidator");
		if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
			$scope.showConnectCtrl = true;
			$scope.showFindTab = true;
		}else{
			$scope.showFindTab = false;
			
		}
		$scope.findSwitchLoader = function(tab){
			if(tab === 'ping'){
				$scope.loadInterfaces();
			}
			if(tab === 'traceRoute'){
			
			}
			if(tab === 'diagnostic'){
				$scope.diagnosticResults();
			}
			if(tab === 'findswitch'){
				$scope.switchDisplayreboot = false;
				$scope.switchDisplayfindSwitch = true;
				$timeout(function(){
					$rootScope.switchfinder = true;
					$rootScope.showRestartBtn = false;
				},200)
			}
			if(tab === 'reboot'){
				$scope.switchDisplayreboot = true;
				$scope.switchDisplayfindSwitch = false;
				$timeout(function(){
					$rootScope.switchfinder = false;
					$rootScope.showRestartBtn = true;
				},200)
			}
		}
		$scope.showReloadStackConfirmDialog = function(){
			$scope.dlg = dialogService.dialog({
                                content : translate('reload_stack_confirm') + "<br/>"+ "<div class=\"col-sm-9 col-sm-offset-1 webui-centerpanel-label\"></div>" + "<br/>",
                                title : translate('reload_stack_title'),
                                messageType : "confirm",
                                actionButtons : [{
                                        text : translate("com_ok"),
                                        callback : "ReloadStack"
                                }, {
                                        text : translate("com_cancel")
                                }]
                        });
                };
		$scope.$on("ReloadStack", function() {
                        $scope.dlg.data("kendoWindow").close();
                        var result = requestRoutingService.getShowCmdOutput("reload\n");
			if(result == ""){
                                notificationService.showNotification(translate('reload_stack_success'),translate('reload_stack_title'),'success');
                        } else {
                                notificationService.showNotification(result.errorResponse,translate('reload_stack_title'),'error');
                        }
                });
		$scope.showRebootConfirmDialog = function(){
			$scope.dlg = dialogService.dialog({
				content : translate('factory_reset_confirm') + "<br/>"+ "<div class=\"col-sm-9 col-sm-offset-1 webui-centerpanel-label\"></div>" + "<br/>",
				title : translate('factory_reset'),
				messageType : "confirm",
				actionButtons : [{
					text : translate("com_ok"),
					callback : "RebootSwitch"
				}, {
					text : translate("com_cancel")
				}]
			});
		};
		$scope.$on("RebootSwitch", function() {
			$scope.dlg.data("kendoWindow").close();
			var result = "";
			if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
				//requestRoutingService.getShowCmdOutput("staging standalone\n");
				requestRoutingService.getShowCmdOutput("write erase\n");
				result = requestRoutingService.getShowCmdOutput("reload\n");
			}else{
				requestRoutingService.getShowCmdOutput("write erase\n");
				result = requestRoutingService.getShowCmdOutput("reload\n");
			}
			if(result == ""){
                                notificationService.showNotification(translate('factory_reset_success'),translate('factory_reset'),'success');
                        } else {
                                notificationService.showNotification(result.errorResponse,translate('factory_reset'),'error');
                        }
		});
		$scope.showRestartSuccessDialog = function(){
			$scope.dlg = dialogService.dialog({
				content : translate('software_update_restart_success'),
				title : translate('software_update_restart_title'),
				messageType : "success",
				actionButtons : [{
					text : translate("com_ok")
				}]
			});
		};
		$scope.showConnectController = function(){
			$scope.dlg = dialogService.dialog({
                                content : translate('connect_to_controller') + "<br/>"+ "<div class=\"col-sm-9 col-sm-offset-1 webui-centerpanel-label\"></div>" + "<br/>",
                                title : translate('connect_to_controller_title'),
                                messageType : "confirm",
                                actionButtons : [{
                                        text : translate("com_ok"),
                                        callback : "ConnectToController"
                                }, {
                                        text : translate("com_cancel")
                                }]
                        });
		};
		$scope.$on("ConnectToController", function() {
                        $scope.dlg.data("kendoWindow").close();
			if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
                                var result = requestRoutingService.getShowCmdOutput("staging network\n");
				if(result == ""){
					notificationService.showNotification(translate('connect_to_controller_success_msg'),translate('com_config_success_msg'),'success');
				} else {
					notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
				}
                        }
                });
		//load interface with configured ip address
		$scope.pingSourceInterface=[];
		$scope.loadInterfaces = function(){
	        var showInterfaces = requestRoutingService.getShowCmdOutput("show ip int brief", "showInterfaces");
	        showInterfaces = showInterfaces.showIpInterfaceBrief.IntBriefTable.entry;
	        angular.forEach(showInterfaces, function(interfaces){
	        	if(interfaces.ipAddress != 'unassigned'){
	        			var pingSourceInterface = {
	        					"intNameAddress": interfaces.interfaceName+"-"+interfaces.ipAddress,
		        				"name":interfaces.interfaceName
		        		};
		        		$scope.pingSourceInterface.push(pingSourceInterface);
	        	}
	        });
	    }
	    $scope.loadInterfaces();
		$scope.startPing= function(evt) {
          evt=evt.target;
          $scope.statusMsg="";
          $scope.isChartShown = false;
          chartStatus=0;
         if(pingValidations.validate()){
        	angular.element(evt).button('loading');
            $scope.showTick = false;
        	var maxRate,minRate,averageRate=0,pingCLI="";
        	$timeout(function() {
        		if($scope.pingName!="" && $scope.pingSource!="none"){
        			pingCLI="do ping "+$scope.pingName+" source "+$scope.pingSource+"\n";
        		}else{
        			pingCLI="do ping "+$scope.pingName+"\n";
        		}
        		var strCLIOutput = requestRoutingService.getConfigCmdOutput(pingCLI);
        		if(strCLIOutput===undefined){
        			$scope.statusMsg=translate("trouble_shoot_noreply_received")+" "+$scope.pingName;	
        		}
        		angular.element(evt).button('reset');
                $scope.showTick = true;
        		strCLIOutput=strCLIOutput.errorResponse;        		      		
        	if(strCLIOutput.indexOf("Success rate is")!=-1){
	            var SUCCESS_OUTPUT_BEGIN = new Array("Success rate is ");
	            var SUCCESS_OUTPUT_END = new Array("percent");
	            var successStatusPer = executeCliCmdService.getNextString(strCLIOutput,SUCCESS_OUTPUT_BEGIN,SUCCESS_OUTPUT_END);
	            var SUCCESSRATE_OUTPUT_BEGIN = new Array("min/avg/max = ");
	            var SUCCESSRATE_OUTPUT_END = new Array(" ms");
	            var successRate = executeCliCmdService.getNextString(strCLIOutput,SUCCESSRATE_OUTPUT_BEGIN,SUCCESSRATE_OUTPUT_END);
	            var successRateArr=successRate.split("/");
	            maxRate=successRateArr[2];
	            averageRate=successRateArr[1];
	            minRate=successRateArr[0];
	            if(successStatusPer==0){
	            	$scope.statusMsg=translate("trouble_shoot_noreply_received")+" "+$scope.pingName;
	            }else{
	            	$scope.statusMsg=translate("trouble_shoot_success_rate")+":"+successStatusPer+" %";
	            	chartStatus=1;
	            	$scope.isChartShown = true;
	            }
        	}else if(strCLIOutput.indexOf("Unrecognized host or address, or protocol not running")!=-1){
        		$scope.statusMsg=translate("trouble_shoot_unrecognized");
        	}else if(strCLIOutput.indexOf("Invalid source interface")!=-1){
        		$scope.statusMsg=translate("trouble_shoot_invalid_source");
        	}else if(strCLIOutput.indexOf("Reply to request")!=-1){
        		$scope.statusMsg=translate("ping_ip")+" "+$scope.pingName+" "+translate("com_success");
        	}else {
        		$scope.statusMsg=translate("trouble_shoot_noreply_received")+" "+$scope.pingName;
        	}
        	if(chartStatus==1){
            angular.element("#chart").kendoChart({
                title: {
                    text:translate("trouble_shoot_ping_type")
                },
                chartArea:{
                    height:300,
                    width :250
                },
                seriesColors: ["#9EC654","#0096D6","#725D87"],
                seriesDefaults: {
	                type: "column",
	                "overlay" : {
	                    "gradient" : "none"
	                }
	            },
                legend: {
                    position: "bottom"
                },
                series: [{
                    name:translate("trouble_shoot_ping_min"),
                    data: [minRate]
                }, {
                    name:translate("trouble_shoot_ping_avg"),
                    data: [averageRate]
                }, {
                    name:translate("trouble_shoot_ping_max"),
                    data: [maxRate]
                }],
                valueAxis: {
                    labels: {
                        format: "{0} ms"
                    },
                    line: {
                        visible: true
                    },
                    axisCrossingValue: 0
                },
                categoryAxis: {
                    line: {
                        visible: false
                    },
                    labels: {
                        padding: {top: 135}
                    }
                },
                tooltip: {
                    visible: true,
                    template: "#= series.name #: #= value # ms"
                }
            });
        	}
        	},50);
        }
      }
		//Trace Route code
		//form validate
		function checkValidateIP(ip){
		    //Check Format
		    var ip = ip.split(".");
			if(ip.length != 4){
		        return false;
			}
		    //Check Numbers
		    for(var c = 0; c < 4; c++){
				if( !(1/ip[c] > 0) ||
		                    ip[c] > 255 ||
		                    isNaN(parseFloat(ip[c])) ||
		                    !isFinite(ip[c])  ||
		                    ip[c].indexOf(" ") !== -1){
		 
		                    return false;
				}
		    }
		    //Invalidate addresses that start with 192.168
		    if( ip[0] == 192 && ip[1] == 168 ){
		        return false;
		    }
		    return true;
		}
		// Ping validation
		var traceRouteValidations = angular.element("#traceRouteForm").kendoValidator({
			rules: {
				validateip : function(input) {
					if (input.val()){
						if (angular.isUndefined(input.data('validateIp'))) {
							return true;
						}
						var subnetRegex = "^((128|192|224|240|248|252|254)\.0\.0\.0)|(255\.(((0|128|192|224|240|248|252|254)\.0\.0)|(255\.(((0|128|192|224|240|248|252|254)\.0)|255\.(0|128|192|224|240|248|252|254)))))$";
						var subnetMask = "255.255.255.255"
						if (new RegExp(subnetRegex).test(input.val())|| input.val()==subnetMask) {
							return false;
						}
						if ( !isNaN(parseInt(input.val())) ){
							return checkValidateIP(input.val());
						}
						
						return true;
					}
				}
			}
		}).data("kendoValidator");
	   function isNumeric(n) {
		  return !isNaN(parseFloat(n)) && isFinite(n);
	   }
       $scope.startTraceRoute= function(evt) {
          evt=evt.target;
          if(traceRouteValidations.validate()){
          angular.element(evt).button('loading');
          $scope.showTick = false;
          $scope.isTraceRouteGrid = false;
          $timeout(function(){
      		  var strCLIOutput = deviceCommunicator.getExecCmdOutput("traceroute "+$scope.traceRouteName+"\n");
      		  angular.element(evt).button('reset');
	          $scope.showTick = true;
	           var arrTraceRouteDetails = new Array();
	           var arrWords = new Array();
	           var arrWords1 = new Array();
	           var arrTTL = new Array();
	           var arrDelays = new Array();
	           var LINE_INDEX = new Array("msec");
	           var strLines = getStringLineService.getLines(strCLIOutput,LINE_INDEX);
	           if (strLines != null) {
	              for (var i=0; i<strLines.length; i++) {
	                      var strLine = strLines[i].trim();
	                      if(strLine.indexOf(")")!=-1){
	                          arrWords  = strLine.split(")");
	                          arrTTL    = arrWords[0].trim().split(" ");
	                          arrWords1 = arrWords[0].trim().split("(");
	                          arrDelays = arrWords[1].trim().split(" ");
	                          if(isNumeric(arrTTL[0])){
	                        	  var items = {
	  	                        		"hopCount"     : arrTTL[0],
	  	                          		"hop"          : arrTTL[1]+" ("+arrWords1[1]+")",
	  	                          		"roundTrip1"   : arrDelays[0],
	  	                          		"roundTrip2"   : arrDelays[2],
	  	                          		"roundTrip3"   : arrDelays[4]
	  	                          };
	  	                          arrTraceRouteDetails.push(items);
	                          }else{
	                        	  var items = {
		  	                        		"hopCount"     : "",
		  	                        		"hop"          : arrTTL[0]+" ("+arrWords1[1]+")",
		  	                          		"roundTrip1"   : arrDelays[0],
		  	                          		"roundTrip2"   : arrDelays[2],
		  	                          		"roundTrip3"   : arrDelays[4]
		  	                      };
		  	                      arrTraceRouteDetails.push(items);
	                          }
	                       } else{
	                    	   arrWords = strLine.split(" ");
	                       	   var items1 = {
	                    			"hopCount"     : arrWords[0],
	                           		"hop"          : arrWords[1],
	                           		"roundTrip1"   : arrWords[2],
	                           		"roundTrip2"   : arrWords[4],
	                           		"roundTrip3"   : arrWords[6]
	                           };
	                           arrTraceRouteDetails.push(items1);
	                       }
	                 }
	           }
	           $scope.isTraceRouteGrid = true;
	           $scope.arrTracesList = new kendo.data.ObservableArray(arrTraceRouteDetails);
			   $scope.traceRouteDataSource = new kendo.data.DataSource({
					   pageSize : 20,
					   data : $scope.arrTracesList
				});
	           $scope.traceRouteGridOptions = {
	                   dataSource: $scope.traceRouteDataSource,
	                   editable : false,
	                   sortable : true,
	                   reorderable: true,
	                   scrollable: true,
	                   filterable : {
	                           extra : false,
	                           operators : {
	                                   string : {
	                                           eq : translate("com_is_equal"),
	                                           neq : translate("com_isnot_equal")
	                                   }
	                           },
	                           messages : {
	           		            info: translate("com_page_dropDowntext"),
	           		            filter: translate("com_btn_filter"),
	           		            clear: translate("com_btn_clear")
	           		        }
	                   },
	                   selectable : true,
	                   pageable : {
	                   		messages: {
	                   			display: translate("com_page_display"),
	                   			empty: translate("com_page_empty"),
	                   			page: translate("com_page_pagetext"),
	                   			of:translate("com_page_of"),
	                   			itemsPerPage: translate("com_page_itemsPerPage"),
	                   			first: translate("com_page_first"),
	                   			previous: translate("com_page_previous"),
	                   			next: translate("com_page_next"),
	                   			last: translate("com_page_last"),
	                   			refresh: translate("com_page_refresh"),
	                   			morePages: translate("com_page_morePage")
	                   		},
	                           previousNext : true,
	                           info : true,
	                           refresh : true,
	                           pageSizes : gridCrudService.grid_page_sizes,
	                           buttonCount : 5
	                   },
	                   columns : [{
	                           field : "hopCount",
	                           title : translate("trouble_shoot_traceroute_hop_ttl"),
	                           width : "15%"
	                   },{
                           	   field : "hop",
                           	   title : translate("trouble_shoot_traceroute_hop"),
                           	   width : "40%"
	                   },{
	                           field : "roundTrip1",
	                           title : translate("trouble_shoot_traceroute_roundtrip"),
	                           width : "15%"
	                   }, {
	                           field : "roundTrip2",
	                           title : translate("trouble_shoot_traceroute_roundtrip"),
	                           width : "15%"
	                   }, {
	                           field : "roundTrip3",
	                           title : translate("trouble_shoot_traceroute_roundtrip"),
	                           width : "15%"
	                   }]
	           };
	        },50)
       }
       }
		//Start Diagnostic code
       //Hiding the diagnostics tab if the device platform is 2960 plus and the type contains "-S" at the end. -S indicates lanlite for 2960 plus platform
       $scope.showDiagnostic=true; 
      if($rootScope.deviceInfo.type === "WS-C2960+48TC-S" || $rootScope.deviceInfo.type === "WS-C2960+-48TC-S"){
    	  $scope.showDiagnostic=false; 
      }else{
		$scope.diagnosticTestSource=[];
		$scope.loadTestsList = function(){
	        var diagnosticTestSource = {
				"testText": translate("trouble_shoot_diagnostic_alltests"),
   				"testValue":"all"
   		    };
   		    $scope.diagnosticTestSource.push(diagnosticTestSource);
	       	var diagnosticTestSource1 ={
	        	"testText": translate("trouble_shoot_diagnostic_basictests"),
		        "testValue":"basic"
	        };
   		  	$scope.diagnosticTestSource.push(diagnosticTestSource1);
   		     if($rootScope.deviceInfo.type.indexOf("2960X")!=-1 || $rootScope.deviceInfo.type.indexOf("3560CX")!=-1 || $rootScope.deviceInfo.type.indexOf("2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("2960C")!=-1 || $rootScope.deviceInfo.type.indexOf("WS-C2960+")!=-1 ){
	       	  var diagnosticTestSource2 ={
	        	"testText": translate("trouble_shoot_diagnostic_nondisruptive"),
		        "testValue":"non-disruptive"
	          };
		  	  $scope.diagnosticTestSource.push(diagnosticTestSource2);
   		    }
	    }
	    $scope.loadTestsList();
	    $scope.startDiagnostic = function() {
			$scope.startConfirmation('start');
		};
		$scope.startConfirmation = function() {
			$scope.tsTest = dialogService.dialog({
				content : translate("trouble_shoot_diagnostic_confirm"),
				title : translate("msg_delete_confirmation_window"),
				messageType : "confirm",
				actionButtons : [{
					text : translate("com_ok"),
					callback : "callDiagnosticTest"
				}, {
					text : translate("com_cancel")
				}]
			});
		};
		$scope.$on("callDiagnosticTest", function() {
			$scope.startTests($scope.tsTest.data("kendoWindow"));
		});
		 $scope.startTests= function(popup) {
		    	popup.close();
		    	var diagnosticCLI="",hiddenCLI="";
		    	var formToSubmit = document.getElementById("diagnosticForm");
		    	 if(($rootScope.deviceInfo.type.indexOf("2960X")!=-1 && ($rootScope.deviceInfo.type != "WS-C2960X-24PSQ-L" &&
                                                $rootScope.deviceInfo.type != "WS-C2960X-48TS-LL" &&
                                                $rootScope.deviceInfo.type != "WS-C2960X-24TS-LL" ))
					|| $rootScope.deviceInfo.type.indexOf("2960XR")!=-1
					|| $rootScope.deviceInfo.type == "WS-C3560CX-12PD-S" || $rootScope.deviceInfo.type == "WS-C3560CX-8XPD-S" ){
						if($scope.diagnosticTest==="basic"){
							diagnosticCLI = "/level/15/exec/-/diagnostic/start/switch/"+$rootScope.deviceInfo.masterId+"/test/basic";
							hiddenCLI = "diagnostic start switch "+$rootScope.deviceInfo.masterId+" test basic";
			    		} else if($scope.diagnosticTest==="all"){
			    			diagnosticCLI = "/level/15/exec/-/diagnostic/start/switch/"+$rootScope.deviceInfo.masterId+"/test/all";
			    			hiddenCLI = "diagnostic start switch "+$rootScope.deviceInfo.masterId+" test all";
			    		} else{
			    			diagnosticCLI = "/level/15/exec/-/diagnostic/start/switch/"+$rootScope.deviceInfo.masterId+"/test/non-disruptive";
			    			hiddenCLI = "diagnostic start switch "+$rootScope.deviceInfo.masterId+" test non-disruptive";
			    		}
		    	 }else{
		    		 if($scope.diagnosticTest==="basic"){
		    			 diagnosticCLI = "/level/15/exec/-/diagnostic/start/test/basic";
		    			 hiddenCLI = "diagnostic start test basic";
		    		 } else if($scope.diagnosticTest==="all"){
		    			 diagnosticCLI = "/level/15/exec/-/diagnostic/start/test/all";
		    			 hiddenCLI = "diagnostic start test all";
		    		 } else{
		    			 diagnosticCLI = "/level/15/exec/-/diagnostic/start/test/non-disruptive";
		    			 hiddenCLI = "diagnostic start test non-disruptive";
		    		 }
		    	}
		        $scope.getConfigureToken = function(){
        			 var url = diagnosticCLI;
        			 var result = httpServices.httpGetMethod(url);
        			 var token = result.slice(result.search("csrf_token VALUE=")+18, result.search("csrf_token VALUE=")+18+40)
		             return token;
		        };
	            var token = $scope.getConfigureToken();
		        var url=diagnosticCLI;
		        var data = 'hidden_command='+hiddenCLI+'&csrf_token='+token+'&CMD=CR';
		        var result=httpServices.httpPostMethod(url,data)
		        notificationService.showNotification("",translate('diagnostic_success_msg'),'success');
		    	$timeout(function(){
		    	   $scope.diagnosticResults();
		    	},500);
		    	$scope.diableDiagnostic = true;
		 }
	    $scope.diagnosticResults= function() {
	    	 var showDiagnosticResult = "";
	    	 if(($rootScope.deviceInfo.type.indexOf("2960X") !=-1 && ($rootScope.deviceInfo.type != "WS-C2960X-24PSQ-L" && $rootScope.deviceInfo.type != "WS-C2960X-48TS-LL" && $rootScope.deviceInfo.type != "WS-C2960X-24TS-LL" )) || $rootScope.deviceInfo.type.indexOf("2960XR")!=-1 || $rootScope.deviceInfo.type === "WS-C3560CX-12PD-S" || $rootScope.deviceInfo.type === "WS-C3560CX-8XPD-S" ){
	    		 showDiagnosticResult=deviceCommunicator.getExecCmdOutput("show diagnostic result switch "+$rootScope.deviceInfo.masterId+" \n");
	    	 }else{
	    		 showDiagnosticResult=deviceCommunicator.getExecCmdOutput("show diagnostic result \n");
	    	 }
	    	 var DIAGNOSTIC_TEST1 = new Array("TestPortAsicStackPortLoopback");
	    	 var DIAGNOSTIC_TEST2 = new Array("TestPortAsicLoopback");
	    	 var DIAGNOSTIC_TEST3 = new Array("TestPortAsicRingLoopback");
	    	 var DIAGNOSTIC_TEST4 = new Array("TestPortAsicCam");
	    	 var DIAGNOSTIC_TEST5 = new Array("TestMicRingLoopback");
	    	 var DIAGNOSTIC_TEST6 = new Array("TestPortAsicMem");
	    	 var DIAGNOSTIC_TEST7 = new Array("TestInlinePwrCtlr");
	    	if(showDiagnosticResult!=null){
	    		if($rootScope.deviceInfo.type.indexOf("2960X")!=-1 || $rootScope.deviceInfo.type.indexOf("2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("3560CX")!=-1 || $rootScope.deviceInfo.type.indexOf("2960C")!=-1 || $rootScope.deviceInfo.type.indexOf("WS-C2960+")!=-1){
		    		var testPortAsicStackPortLoopback = getStringLineService.getLines(showDiagnosticResult,DIAGNOSTIC_TEST1);
		    		if(testPortAsicStackPortLoopback!=undefined && testPortAsicStackPortLoopback.length>0 ){
		    			$scope.testView1=true;
			    		var arrtestPortAsicStackPortLoopback=testPortAsicStackPortLoopback[0].split(" ");
			    		testPortAsicStackPortLoopback=arrtestPortAsicStackPortLoopback[7].trim();
			    		if(testPortAsicStackPortLoopback==="U"){
			    			$scope.testResult1="fa fa-ban";
			    		}else if(testPortAsicStackPortLoopback==="F"){
			    			$scope.testResult1="fa fa-times-circle redCross";
			    		} else if(testPortAsicStackPortLoopback==="."){
			    			$scope.testResult1="fa fa-check-circle master";
			    		}
		    		}else{
	    				$scope.testView1=false;
	    			}
			    	var testPortAsicRingLoopback = getStringLineService.getLines(showDiagnosticResult,DIAGNOSTIC_TEST3);
			    	if(testPortAsicRingLoopback!=undefined && testPortAsicRingLoopback.length>0 ){
			    		$scope.testView3=true;
			    		var arrtestPortAsicRingLoopback=testPortAsicRingLoopback[0].split(" ");
			    		testPortAsicRingLoopback=arrtestPortAsicRingLoopback[7].trim();
			    		if(testPortAsicRingLoopback==="U"){
			    			$scope.testResult3="fa fa-ban";
			    		}else if(testPortAsicRingLoopback==="F"){
			    			$scope.testResult3="fa fa-times-circle redCross";
			    		} else if(testPortAsicRingLoopback==="."){
			    			$scope.testResult3="fa fa-check-circle master";
			    		}
		    		}else{
	    				$scope.testView3=false;
	    			}
		    		var testMicRingLoopback = getStringLineService.getLines(showDiagnosticResult,DIAGNOSTIC_TEST5);
		    		if(testMicRingLoopback!=undefined && testMicRingLoopback.length>0 ){
		    			$scope.testView5=true;
			    		var arrtestMicRingLoopback=testMicRingLoopback[0].split(" ");
			    		testMicRingLoopback=arrtestMicRingLoopback[7].trim();
			    		if(testMicRingLoopback==="U"){
			    			$scope.testResult5="fa fa-ban";
			    		}else if(testMicRingLoopback==="F"){
			    			$scope.testResult5="fa fa-times-circle redCross";
			    		} else if(testMicRingLoopback==="."){
			    			$scope.testResult5="fa fa-check-circle master";
			    		}
		    		}else{
	    				$scope.testView5=false;
	    			}
	    		}
	    		var testPortAsicLoopback = getStringLineService.getLines(showDiagnosticResult,DIAGNOSTIC_TEST2);
	    		if(testPortAsicLoopback!=undefined && testPortAsicLoopback.length>0 ){
	    			$scope.testView2=true;
		    		var arrtestPortAsicLoopback=testPortAsicLoopback[0].split(" ");
		    		testPortAsicLoopback=arrtestPortAsicLoopback[7].trim();
		    		if(testPortAsicLoopback==="U"){
		    			$scope.testResult2="fa fa-ban";
		    		}else if(testPortAsicLoopback==="F"){
		    			$scope.testResult2="fa fa-times-circle redCross";
		    		} else if(testPortAsicLoopback==="."){
		    			$scope.testResult2="fa fa-check-circle master";
		    		}
	    		}else{
    				$scope.testView2=false;
    			}
	    		var testPortAsicCam = getStringLineService.getLines(showDiagnosticResult,DIAGNOSTIC_TEST4);
	    		if(testPortAsicCam!=undefined && testPortAsicCam.length>0 ){
	    			$scope.testView4=true;
		    		var arrtestPortAsicCam=testPortAsicCam[0].split(" ");
		    		testPortAsicCam=arrtestPortAsicCam[7].trim();
		    		if(testPortAsicCam==="U"){
		    			$scope.testResult4="fa fa-ban";
		    		}else if(testPortAsicCam==="F"){
		    			$scope.testResult4="fa fa-times-circle redCross";
		    		} else if(testPortAsicCam==="."){
		    			$scope.testResult4="fa fa-check-circle master";
		    		}
	    		}else{
    				$scope.testView4=false;
    			}
	    		var testPortAsicMem = getStringLineService.getLines(showDiagnosticResult,DIAGNOSTIC_TEST6);
	    		if(testPortAsicMem!=undefined && testPortAsicMem.length>0 ){
	    			$scope.testView6=true;
		    		var arrtestPortAsicMem=testPortAsicMem[0].split(" ");
		    		testPortAsicMem=arrtestPortAsicMem[7].trim();
		    		if(testPortAsicMem==="U"){
		    			$scope.testResult6="fa fa-ban";
		    		}else if(testPortAsicMem==="F"){
		    			$scope.testResult6="fa fa-times-circle redCross";
		    		} else if(testPortAsicMem==="."){
		    			$scope.testResult6="fa fa-check-circle master";
		    		}
	    		}else{
    				$scope.testView6=false;
    			}
	    		if($rootScope.deviceInfo.type.indexOf("2960X")!=-1 || $rootScope.deviceInfo.type.indexOf("2960XR")!=-1 || $rootScope.deviceInfo.type.indexOf("2960CX")!=-1 || $rootScope.deviceInfo.type === "WS-C3560CX-12PD-S" || $rootScope.deviceInfo.type === "WS-C3560CX-8XPD-S"){
	    			var testInlinePwrCtlr = getStringLineService.getLines(showDiagnosticResult,DIAGNOSTIC_TEST7);
	    			if(testInlinePwrCtlr!=undefined && testInlinePwrCtlr.length>0 ){
	    				$scope.testView7=true;
			    		var arrtestInlinePwrCtlr=testInlinePwrCtlr[0].split(" ");
			    		testInlinePwrCtlr=arrtestInlinePwrCtlr[7].trim();
			    		if(testInlinePwrCtlr==="U"){
			    			$scope.testResult7="fa fa-ban";
			    		}else if(testInlinePwrCtlr==="F"){
			    			$scope.testResult7="fa fa-times-circle redCross";
			    		} else if(testInlinePwrCtlr==="."){
			    			$scope.testResult7="fa fa-check-circle master";
			    		}
	    			}else{
	    				$scope.testView7=false;
	    			}
	    		}
	    	}
	    }
      }  
	  //End Diagnostic
		// find switch tab
		$scope.findSwitch = function (){
			var findCli="led beacon";
			var result = deviceCommunicator.getExecCmdOutput(findCli);
				if(result==""){
					notificationService.showNotification(translate('findSwitch_success_msg'),translate('com_config_success_title'),'success');
				}else{
					notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
				}
		}
	}]);
