app.service("portsDataSourceService",['$rootScope','requestRoutingService','executeCliCmdService','getStringLineService',function($rootScope,requestRoutingService,executeCliCmdService,getStringLineService){
return {
    getPortData: function (selectedPortId) {
        var portsObj = {};
        var portConfCLI="";
        if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
        	portConfCLI="show interfaces "+selectedPortId+" status\n show interfaces "+selectedPortId+" switchport\n show running-config interface "+selectedPortId+"\n ";
        }else{
        	portConfCLI="show interfaces "+selectedPortId+" status\n show interfaces "+selectedPortId+" switchport\n show running-config interface "+selectedPortId+"\n show interface "+selectedPortId+" | i media type\n";
        }
        var portConfCLIOP = deviceCommunicatorCLI.getExecCmdOutput(portConfCLI);
        var interfaceStatus=portConfCLIOP[0].split("\n");
        portsObj["PortId"] = interfaceStatus[1].substring(0,8).trim();
        portsObj["Status"] =interfaceStatus[1].substring(29,41).trim();
        portsObj["Duplex"] = interfaceStatus[1].substring(52,59).trim().replace(/^a-/, "");
        portsObj["Speed"] = interfaceStatus[1].substring(60,66).trim().replace(/^a-/, "");
        var portsSwitchInfo=portConfCLIOP[1];
        portsObj["SwitchMode"] = executeCliCmdService.getNextString(portsSwitchInfo,["Administrative Mode:"],["\n"]).trim();
        portsObj["accessVlan"] = executeCliCmdService.getNextString(portsSwitchInfo,["Access Mode VLAN:"],["\n"]).trim().split(" ")[0].trim();
        portsObj["voiceVlan"] = executeCliCmdService.getNextString(portsSwitchInfo,["Voice VLAN:"],["\n"]).trim().split(" ")[0].trim();
        portsObj["nativeVlan"] = executeCliCmdService.getNextString(portsSwitchInfo,["Trunking Native Mode VLAN:"],["\n"]).trim().split(" ")[0].trim();
        portsObj["vlanIDs"] = executeCliCmdService.getNextString(portsSwitchInfo,["Trunking VLANs Enabled:"],["\n"]).trim();
        var runningconfig=portConfCLIOP[2];
        portsObj["runningConfigSelectedPort"]=runningconfig;
        portsObj["dhcpsnooping"] =executeCliCmdService.getNextString(runningconfig,["ip dhcp snooping"],["\n"]).trim();
        portsObj["portfast"] =executeCliCmdService.getNextString(runningconfig,["spanning-tree portfast"],["\n"]).trim();
        portsObj["stormControl"] =executeCliCmdService.getNextString(runningconfig,["storm-control action"],["\n"]).trim();
		portsObj["autoQOS"] =executeCliCmdService.getNextString(runningconfig,["auto qos"],["\n"]).trim();
		portsObj["Description"] =executeCliCmdService.getNextString(runningconfig,["description"],["\n"]).trim();
		//Adding selecon support
        if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
    		if(runningconfig.indexOf("no power inline port 2-event")!=-1){
    			portsObj["eveClassification"]=false;
    		}else{
    			portsObj["eveClassification"]=true;
    		}
    		if(runningconfig.indexOf("no power inline port poe-ha")!=-1){
    			portsObj["perpetualPoE"]=false;
    		}else{
    			portsObj["perpetualPoE"]=true;
    		}
        }
        var advSetting = {};
        advSetting.broadcast =executeCliCmdService.getNextString(runningconfig,["storm-control broadcast level"],["\n"]).trim();
        advSetting.broadcast = advSetting.broadcast === undefined ? "" : advSetting.broadcast;
        var broadcastToString = advSetting.broadcast.toString();
        advSetting.multicast =executeCliCmdService.getNextString(runningconfig,["storm-control multicast level"],["\n"]).trim();
        advSetting.multicast = advSetting.multicast === undefined ? "" : advSetting.multicast;
        var multicastToString = advSetting.multicast.toString();
        advSetting.unicast =executeCliCmdService.getNextString(runningconfig,["storm-control unicast level"],["\n"]).trim();
        advSetting.unicast = advSetting.unicast === undefined ? "" : advSetting.unicast;
        var unicastToString = advSetting.unicast.toString();
        portsObj["broadcast"]=broadcastToString.split('.')[0];
        portsObj["multicast"]=multicastToString.split('.')[0];
        portsObj["unicast"]=unicastToString.split('.')[0];
        portsObj["runDuplex"]= executeCliCmdService.getNextString(runningconfig,["duplex"],["\n"]).trim();
        portsObj["runSpeed"]= executeCliCmdService.getNextString(runningconfig,["speed"],["\n"]).trim();
        if($rootScope.deviceInfo.type.indexOf("CDB")==-1){
        	portsObj["mediaCLIOP"]=portConfCLIOP[3];
        }
        return portsObj;
    }
}
}]);
