/**
 Description: Services for STP.
 Copyright (c) 2016 by Cisco Systems, Inc.
 All rights reserved.
 */
app.service('stpdataSourceService',['$rootScope','requestRoutingService','getStringLineService','executeCliCmdService','$filter', function($rootScope,requestRoutingService,getStringLineService,executeCliCmdService,$filter) {
  var trimVal=$filter('trimValue');
  var translate = $filter("translate");
	  return{
         sendingStpModeToDevice : function(stpModeType){
            var stpCliCommand="spanning-tree mode ";
            var stpValue=stpModeType;
            stpCliCommand=stpCliCommand+stpValue;
            var resultResponse=requestRoutingService.getConfigCmdOutput(stpCliCommand);
        },
        sendingVlanDataToDevice:function(editedObject){
            var vlanCliCommand = "";
            editedObject.forEach(function(changedTableItem){
                   if(changedTableItem.hasSpanningTree === false){
                        vlanCliCommand+="no spanning-tree vlan "+changedTableItem.vlanId+" \n";
                   }else{
                	   vlanCliCommand+="spanning-tree vlan "+changedTableItem.vlanId+"\n";
                       vlanCliCommand+="spanning-tree vlan "+changedTableItem.vlanId+" priority "+changedTableItem.bridgePriorityNumber+"\n";
                   }
            });
            var resultResponse=requestRoutingService.getConfigCmdOutput(vlanCliCommand);
            return resultResponse;
        },
        getStpModeType:function(){
            var responseStpModeType=requestRoutingService.getShowCmdOutput("show spanning-tree summary","showMode");
            return responseStpModeType.ShowSTP.modeType;
        },
        getVlanData:function(){
        	var arrSTP=[];
            //Sending all required CLIs of STP page
        	var stpCLI="show vlan brief\n show running-config partition common | s spanning-tree\n";
           //Returning array that contains all the given CLI O/P
            var stpCLIOP = deviceCommunicatorCLI.getExecCmdOutput(stpCLI);
            //Getting vlan brief details
            var vlanBriefData=[];
            var arrVlanBr=stpCLIOP[0].split("\n");
			for (var i=2; i < arrVlanBr.length; i++) {
				vlanPorts="";
				var arrInnerWords = arrVlanBr[i].split(" ");
				for (var k=0,j=1; k < arrInnerWords.length; k++) {
					if(arrInnerWords[k] == "") {
			 			continue;
		 			}
					if (j == 1) {
						vlanId=arrInnerWords[k];
		 			} else if (j == 2) {
		 				vlanName=arrInnerWords[k];
		 			}
		 		   	j++;
				}
				var items = {
    					"vlan"   : vlanId,
    					"name"   : vlanName
    			};
				vlanBriefData.push(items);
			}
            var arrVlanId=[];
            var arrPriority=[];
            var arrVlanId1=[];
            var strLines = getStringLineService.getLines(stpCLIOP[1],["spanning-tree vlan "]);
            if (strLines != null) {
                for (var i=0; i<strLines.length; i++) {
                       var strLine = strLines[i];
                       //for disabled state vlan's
                       if(strLine.indexOf("no spanning-tree vlan")!=-1){
                    	 vlanList= executeCliCmdService.getNextString(strLine,["spanning-tree vlan "],["\n"]);
                      	 arrValList=vlanList.split(" ");
                         if(vlanList.indexOf(",")!=-1){
                        		 vlansList=arrValList[0];
                        		 arrVlansList=vlansList.split(",");
                        		 for (var j=0; j<arrVlansList.length; j++) {
                        			if(arrVlansList[j].indexOf("-")!=-1){
                        				vlanMultiList=arrVlansList[j].split("-");
                        				for (var k=vlanMultiList[0]; k<= vlanMultiList[1]; k++) {
                        					arrVlanId1.push(k);
                        				}
                        			}else{
                        				arrVlanId1.push(arrVlansList[j]);
                               		}
                        		 }
                           }else{
                          	 if(vlanList.indexOf("-")!=-1){
                     				vlanMultiList=arrValList[0].split("-");
                     				for (var k1=vlanMultiList[0]; k1<= vlanMultiList[1]; k1++) {
                     					arrVlanId1.push(k1);
                                	}
                     			}else{
                     				arrVlanId1.push(arrValList[0]);
                     			}
                         }
                       }else{
                            //for enabled state vlan's
                             vlanList= executeCliCmdService.getNextString(strLine,["spanning-tree vlan "],["\n"]);
                        	 arrValList=vlanList.split(" ");
                             if(vlanList.indexOf(",")!=-1){
                          		 vlansList=arrValList[0];
                          		 arrVlansList=vlansList.split(",");
                          		 for (var j1=0; j1<arrVlansList.length; j1++) {
                          			if(arrVlansList[j1].indexOf("-")!=-1){
                          				vlanMultiList=arrVlansList[j1].split("-");
                          				for (var j1k=vlanMultiList[0]; j1k<= vlanMultiList[1]; j1k++) {
                          					arrVlanId.push(j1k);
                                     		arrPriority.push(arrValList[2]);
                          				}
                          			}else{
                          				arrVlanId.push(arrVlansList[j1]);
                                 		arrPriority.push(arrValList[2]);
                          			}
                          		 }
                             }else{
                            	 if(vlanList.indexOf("-")!=-1){
                       				vlanMultiList=arrValList[0].split("-");
                       				for (var k2=vlanMultiList[0]; k2<= vlanMultiList[1]; k2++) {
                       					arrVlanId.push(k2);
                                  		arrPriority.push(arrValList[2]);
                       				}
                       			}else{
                       				arrVlanId.push(arrValList[0]);
                       				arrPriority.push(arrValList[2]);
                       			}
                           }
                     }
                }
            }
            for(var item=0;item < vlanBriefData.length;item++){
            	if (vlanBriefData[item].name != "" &&  vlanBriefData[item].name != "token-ring-default" && vlanBriefData[item].name != "MGMT_VLAN" && vlanBriefData[item].name != "DataVlan" && vlanBriefData[item].name != "VoiceVlan" && vlanBriefData[item].name != "fddi-default" && vlanBriefData[item].name != "trnet-default" && vlanBriefData[item].name != "fddinet-default") {
                	var stpObj = {};
                	var count=0;
                	stpObj["vlanId"] = vlanBriefData[item].vlan;
                    stpObj["vlanName"] = vlanBriefData[item].name == "default" ? translate("port_config_default") : vlanBriefData[item].name;
                    //set default bridge priority
                    stpObj["bridgePriorityNumber"] = "32768";
                    //set default ST status
                    stpObj["hasSpanningTree"] = true;
                    for(var i1=0;i1 <arrVlanId.length;i1++){
                    	if(vlanBriefData[item].vlan==arrVlanId[i1]){
                    		stpObj["bridgePriorityNumber"] = arrPriority[i1];
                            stpObj["hasSpanningTree"] = true;
                            count++;
                    	}
                    }
                    for(var j2=0;j2 <arrVlanId1.length;j2++){
                    	if(vlanBriefData[item].vlan==arrVlanId1[j2]){
                    		if(count==0){
                    			stpObj["bridgePriorityNumber"] = "32768";
                    		}
                            stpObj["hasSpanningTree"] = false;
                    	}
                    }
                    arrSTP.push(stpObj);
               }
           }
           return arrSTP;
        },
        getSwitchDetails:function(){
        	 var deviceType = $rootScope.deviceInfo.type;
        	//Sending all required CLIs of Switch page
        	var switchCLI="";
        	if(deviceType.indexOf("CDB")!=-1){
        		switchCLI="show version\n show ip interface\n show ip http server history | i [0-9]+\n show running-config partition common | in ip default-gateway \n show system mtu\n show cluster\n show coap stats\n";
        	}else{
        		switchCLI="show version\n show ip interface\n show ip http server history | i [0-9]+\n show running-config partition common | in ip default-gateway \n show system mtu\n show cluster\n";
        	}
           //Returning array that contains all the given CLI O/P
            var switchCLIOP = deviceCommunicatorCLI.getExecCmdOutput(switchCLI);
            var switchData={};
            var strLines = getStringLineService.getLines(switchCLIOP[0],["uptime"]);
            switchData["hostName"] = strLines[0].split(" ")[0].trim();
            //Setting Show Ip Interface O/P
            var switchDetailResponse=[];
            var strLinesInterface = getStringLineService.getLines(switchCLIOP[1],["line protocol is"]);
            var arrShowIPIntefaceList=switchCLIOP[1].split("line protocol is");
            for(var i = 0; i < strLinesInterface.length; i++){
            	var portsObj = {};
        		portsObj["Vlan"] = strLinesInterface[i].split(" ")[0].trim();
        		portsObj["ipAddress"] = executeCliCmdService.getNextString(arrShowIPIntefaceList[parseInt(i)+1],["Internet address is"],["\n"]).trim();
        		switchDetailResponse.push(portsObj);
            }
            var httpIpAddress = switchCLIOP[2];
            httpIpAddressList=httpIpAddress.split("\n");
            arrayLength=httpIpAddressList.length;
            arrHttpIpAddress=trimVal(httpIpAddressList[arrayLength-1]).split(" ");
            mgmtIpaddress=arrHttpIpAddress[0].split(":");
            var currentIpAdddress=mgmtIpaddress[0];
            currentIpAdddress=trimVal(currentIpAdddress);
            var vlan="";
            var ipAddress="";
            if (switchDetailResponse.length > 0) {
                for (var i = 0; i < switchDetailResponse.length; i++) {
                	vlan= switchDetailResponse[i].Vlan;
                	ipAddress= switchDetailResponse[i].ipAddress;
                	if(ipAddress!=undefined){
                		aripAddress=ipAddress.split("/");
                		newIP=trimVal(aripAddress[0]);
                		if(newIP==currentIpAdddress){
                			switchData["managementVlan"]=vlan;
                			break;
                		}
                	}
                }
            }else if (switchDetailResponse.Vlan) {
            	   vlan= switchDetailResponse.Vlan;
            	   ipAddress= switchDetailResponse.ipAddress;
            	   if(ipAddress!=undefined){
               		aripAddress=ipAddress.split("/");
               		newIP=trimVal(aripAddress[0]);
               		if(newIP==currentIpAdddress){
               			switchData["managementVlan"]=vlan;
               		}
               	}
            }
            var strGatewayLines = getStringLineService.getLines(switchCLIOP[3],["ip default-gateway"]);
            switchData["defaultGateway"]=executeCliCmdService.getNextString(strGatewayLines[0],["ip default-gateway"],["\n"]).trim();
            var switchShowRunIPAddress=requestRoutingService.getShowCmdOutput("show running-config int "+switchData["managementVlan"]+"","showRunIpAddress");
            var switchIPAddress=switchShowRunIPAddress.ShowRun.wnwebdata.ipAddress;
            arrSwitchIPAddress=switchIPAddress.split(" ");
            switchData["switchIp"]=arrSwitchIPAddress[0]
            switchData["subnetMask"]=arrSwitchIPAddress[1];
            var strCLIOutputMTU =switchCLIOP[4];
          	switchData["mtuSize"]=executeCliCmdService.getNextString(strCLIOutputMTU,["System MTU size is "],[" bytes"]).trim();
          	//Setting Cluster Details
          	switchData["domainName"]=executeCliCmdService.getNextString(switchCLIOP[5],["switch for cluster"],["\n"]).trim();
         	//Adding selecon support
            if(deviceType.indexOf("CDB")!=-1){
	    		var coapStatus = switchCLIOP[6];
	    		if(coapStatus.indexOf("COAP is disabled")!=-1){
	    			switchData["switchCOAP"]=false;
	    		}else{
	    			switchData["switchCOAP"]=true;
	    		}
            }
            return switchData;
        }
    }
}]);
