<!-- Copyright (c) 2009 by Cisco Systems, Inc. -->
// discover.js - for C2960S devices.
/*Support added for Stout devices :
Updated PIDs.
	Murphys : WS-C2960S-48FPD-L,WS-C2960S-48LPD-L,WS-C2960S-24PD-L,WS-C2960S-48TD-L,WS-C2960S-24TD-L
	Guinness: WS-C2960S-48FPS-L,WS-C2960S-48LPS-L,WS-C2960S-24PS-L,WS-C2960S-48TS-L,WS-C2960S-24TS-L
	Beamish	: WS-C2960S-48TS-S,WS-C2960S-24TS-S
	*/
//////////////////////////////////////////////////////////////////////////////////////////////

function addLabel( dev, label1, label2 )
{
	var image1 = "images/port_label_"+label1+".gif";
	var image2= "";
	if (label2 != null ) image2= "images/port_label_"+label2+".gif";
	switch (label1)
	{
		case 1:
			// Adding the ten gb port label1
			var portlbtl = new top.portLabel(577, 65, 7, 5, image1);
			if(dev.type.indexOf("WS-C3750E-12SD") != -1){
				portlbtl = new top.portLabel(586, 19, 7, 5, image1);
			}
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 2:
			// Adding the ten gb port label2
			var portlbtl = new top.portLabel(624, 65, 7, 5, image1);
			if(dev.type.indexOf("WS-C3750E-12SD") != -1){
				portlbtl = new top.portLabel(585, 43, 7, 5, image1);
			}
	        portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 13:
				// Adding the top port label1
		        var portlbl = new top.portLabel(583, 19, 7, 5, image1);
	        	portlbl.id = "portlbl1";
		        dev.addPortLabel(portlbl);

		        // Adding the top port label2
		        var portlbl2 = new top.portLabel(647, 19, 7, 5, image2);
	        	portlbl2.id = "portlbl2";
		        dev.addPortLabel(portlbl2);
			break;
		case 15:
				// Adding the bottom port label1
		        var portlbl3 = new top.portLabel(584, 43, 7, 5, image1);
		        portlbl3.id = "portlbl3";
		        dev.addPortLabel(portlbl3);

		        // Adding the bottom port label2
		        var portlbl4 = new top.portLabel(647, 43, 7, 5, image2);
		        portlbl4.id = "portlbl4";
		        dev.addPortLabel(portlbl4);
			break;
		case 25:
		case 49:
			// Adding the top port label1
		        var portlbl = new top.portLabel(567, 65, 7, 5, image1);
	        	portlbl.id = "portlbl1";
		        dev.addPortLabel(portlbl);

		        // Adding the top port label2
		        var portlbl2 = new top.portLabel(588, 65, 7, 5, image2);
	        	portlbl2.id = "portlbl2";
		        dev.addPortLabel(portlbl2);
			break;
		case 27:
		case 51:
		        // Adding the bottom port label1
		        var portlbl3 = new top.portLabel(614, 65, 7, 5, image1);
		        portlbl3.id = "portlbl3";
		        dev.addPortLabel(portlbl3);

		        // Adding the bottom port label2
		        var portlbl4 = new top.portLabel(635, 65, 7, 5, image2);
		        portlbl4.id = "portlbl4";
		        dev.addPortLabel(portlbl4);
	}
}

function construct_Murphys_Guinnes_PoE_Leds(dev) {
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 22;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 28;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 34;
	tempLed.id = "master_led";
	tempLed.device = dev;
	dev.sysleds["MASTER"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 41;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 47;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 53;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 59;
	tempLed.id = "stack_led";
	tempLed.device = dev;
	dev.sysleds["STACK"] = tempLed;

	//construct Power LEDs
	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 64;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	// Create the Mode Btn
	//var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 29;//42;
	modeBtn.y = 66;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;

		
}
function construct_Murphys_Guinnes_Leds(dev) {
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 22;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 28;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 34;
	tempLed.id = "master_led";
	tempLed.device = dev;
	dev.sysleds["MASTER"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 41;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 47;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 53;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 59;
	tempLed.id = "stack_led";
	tempLed.device = dev;
	dev.sysleds["STACK"] = tempLed;


	// Create the Mode Btn
	//var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 29;//42;
	modeBtn.y = 66;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;

		
}
function construct_Beamish_Leds(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 9; //8;
	tempLed.y = 22;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9; //8;
	tempLed.y = 28;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9; //8;
	tempLed.y = 40;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9; //8;
	tempLed.y = 46;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9; //8;
	tempLed.y = 52;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	// Create the Mode Btn
	//var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 29;//42;
	modeBtn.y = 66;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
	
}

//Start of Stout devices
function WS_C2960XS_48PD_L(int_status, media_type, deviceType) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	if(deviceType=="WS-C2960S-48FPD-L") dev.image = "images/C2960XS_48FPD_L.gif";	
	else if (deviceType=="WS-C2960S-48LPD-L") dev.image = "images/C2960XS_48LPD_L.gif";
	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_PoE_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 49;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	var intNames = new Array();
	var portInd = 48;
	for (i=0; i< int_status.length; i++) intNames[i] = int_status[i][0];
	var interfaces = "#"+intNames.join('#')+"#";

	if (interfaces.indexOf("0/49") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 559;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+2; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,49,50);
	}
	
	if (interfaces.indexOf("0/51") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 606;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+2; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,51,52);
	}
	
	if (interfaces.indexOf("0/49") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 559;
		yPortCoord = 47;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}
	if (interfaces.indexOf("0/51") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 559 + 47;
		yPortCoord = 47;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");
	return dev;
}

function WS_C2960XS_48TD_L(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960XS_48TD_L.gif";	
	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_Leds(dev);
	 
	 // Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 49;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	var intNames = new Array();
	var portInd = 48;
	for (i=0; i< int_status.length; i++) intNames[i] = int_status[i][0];
	var interfaces = "#"+intNames.join('#')+"#";

	if (interfaces.indexOf("0/49") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 559;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+2; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,49,50);
	}
	
	if (interfaces.indexOf("0/51") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 606;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+2; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,51,52);
	}
	
	if (interfaces.indexOf("0/49") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 559;
		yPortCoord = 47;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}
	if (interfaces.indexOf("0/51") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 559 + 47;
		yPortCoord = 47;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}
	
	// Add the 2 SFP ports.
	/*xPortCoord = 560;//551;//589;
	xPortGap = 20;//13;
	yPortCoord = 49;//23;
	for(i=48; i<50; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}*/
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
	
}

function WS_C2960XS_24PD_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960XS_24PD_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_PoE_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 611;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 301;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	var intNames = new Array();
	var portInd = 24;
	for (i=0; i< int_status.length; i++) intNames[i] = int_status[i][0];
	var interfaces = "#"+intNames.join('#')+"#";

	if (interfaces.indexOf("0/25") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 557;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+2; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,25,26);
	}
	
	if (interfaces.indexOf("0/27") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 604;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+2; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,27,28);
	}
	
	if (interfaces.indexOf("0/25") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 557;
		yPortCoord = 47;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}
	if (interfaces.indexOf("0/27") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 557 + 47;
		yPortCoord = 47;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}

	// Add the 2 SFP ports.
	/*xPortCoord = 551;//589;
	xPortGap = 22;//13;
	yPortCoord = 49;//23;
	for(i=24; i<26; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}*/

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");	
	return dev;
}
function WS_C2960XS_24TD_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960XS_24TD_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_Leds(dev);

	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 611;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 301;//292;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	var intNames = new Array();
	var portInd = 24;
	for (i=0; i< int_status.length; i++) intNames[i] = int_status[i][0];
	var interfaces = "#"+intNames.join('#')+"#";

	if (interfaces.indexOf("0/25") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 557;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+2; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,25,26);
	}
	
	if (interfaces.indexOf("0/27") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 604;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+2; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,27,28);
	}
	
	if (interfaces.indexOf("0/25") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 557;
		yPortCoord = 47;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}
	if (interfaces.indexOf("0/27") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 557 + 47;
		yPortCoord = 47;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}

	// Add the 2 SFP ports.
	/*xPortCoord = 558;//589;
	xPortGap = 22;//13;
	yPortCoord = 49;//23;
	for(i=24; i<26; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}*/

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}

function WS_C2960XS_48PS_L(int_status, media_type, deviceType) {
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	if(deviceType == "WS-C2960S-48FPS-L") dev.image = "images/C2960XS_48FPS_L.gif";	
	else if (deviceType == "WS-C2960S-48LPS-L") dev.image = "images/C2960XS_48LPS_L.gif";
	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_PoE_Leds(dev);

	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 49;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 558;//560;
	xPortGap = 5;//13;
	yPortCoord = 48;//23;
	for(i=48; i<52; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");
	return dev;
}

function WS_C2960XS_24PS_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960XS_24PS_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_PoE_Leds(dev);
	
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 604;
	tempLed.y = 23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 292;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 552;//589;
	xPortGap = 5;//13;
	yPortCoord = 49;//23;
	for(i=24; i<28; i++) {
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");
	return dev;
}

function WS_C2960XS_24TS_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960XS_24TS_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 605;
	tempLed.y = 23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;
	var xPortStartPos = 292;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 553;//589;
	xPortGap = 5;//13;
	yPortCoord = 49;//23;
	for(i=24; i<28; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}

function WS_C2960X_48TS_S(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960X_48TS_S.gif";	
	// Construct the mode button and the system LEDs
	construct_Beamish_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 611;
	tempLed.y = 23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 49;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 558;//551;//589;
	xPortGap = 25;//13;
	yPortCoord = 48;//23;
	for(i=48; i<50; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	return dev;
	
}

function WS_C2960X_24TS_S(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960X_24TS_S.gif";

	// Construct the mode button and the system LEDs
	construct_Beamish_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 302;//292;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 24;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 40;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 558;//589;
	xPortGap = 26;//13;
	yPortCoord = 47;//23;
	for(i=24; i<26; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	return dev;
}

function WS_C2960XS_48TS_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960XS_48TS_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_Leds(dev);

	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 24;//23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;
	var xPortStartPos = 49;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<48; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35)
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 558;//589;
	xPortGap = 5;//13;
	yPortCoord = 48;//23;
	for(i=48; i<52; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}
// End of Stout Family
function createDevice(int_status, media_type, deviceType) {
	var device = null;
	if(deviceType == null) 
		return device;
	// Stout Support
	if(deviceType == "WS-C2960S-48FPD-L" || deviceType == "WS-C2960S-48LPD-L"){ //Murphys48FullPWR & Murphys48PWR  
		device = new WS_C2960XS_48PD_L(int_status, media_type, deviceType); 
	}
	else if(deviceType == "WS-C2960S-48TD-L"){ //Murphys48
		device = new WS_C2960XS_48TD_L(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-24PD-L"){ //Murphys24PWR
		device = new WS_C2960XS_24PD_L(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-24TD-L"){ //Murphys24
		device = new WS_C2960XS_24TD_L(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-48FPS-L" || deviceType == "WS-C2960S-48LPS-L"){ //Guinness48FullPWR & Guinness48PWR 
		device = new WS_C2960XS_48PS_L(int_status, media_type, deviceType); 
	}
	else if(deviceType == "WS-C2960S-48TS-L"){//Guinness48
		device = new WS_C2960XS_48TS_L(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-24PS-L"){ //Guinness24PWR
		device = new WS_C2960XS_24PS_L(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-24TS-L"){ //Guinness24
		device = new WS_C2960XS_24TS_L(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-48TS-S"){ //Beamish48
		device = new WS_C2960X_48TS_S(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-24TS-S"){ //Beamish24
		device = new WS_C2960X_24TS_S(int_status, media_type); 
	}
	
	if(device != null) {
		device.type = deviceType;
		if(deviceType.indexOf("C2960S-")!= -1)
			device.family ="2960-S";
	}
	return device;
}
