<!-- Copyright (c) 2005, 2009 by Cisco Systems, Inc. -->
// discover.js - Will discover EagleEye Layer2 SKUs
// Support added for EagleEye Layer 2 SKUs SM-ES2-16-P, SM-ES2-24, SM-ES2-24-P & SM-D-ES2-48
//////////////////////////////////////////////////////////////////////////////////////////////

// EAGLEEYE SM-ES2-16-P	
function SM_ES2_16P(int_status, media_type) {
	var dev = new top.device(); 
	dev.noofports = 18;   //16 + 2  internal
	dev.x=0;
	dev.y=0;
	dev.image = "images/EE_SM_ES2_16P.gif";	
	
	//LED ( draw Enable LED )
	construct_EagleEye_Led(dev, 31, 67, 5, 5); 

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3;
	var xPortGroupGap = 19;
	var xPortStartPos = 303;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 15 FastEthernet ports + 1 Gibabit Ethernet Ports  - right to left 
	
	for(i=0; i<15; i++) {
		if(i%2 != 0) {
			yPortCoord = 23;
			port = new top.rj45portInv(portInvImages);
			
		} 
		else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 ==0 ) {
			 xPortCoord -= (portWidth + xPortGap); 
		}
		dev.addPort(port);
	}	// add Gigabit Port 
		xPortCoord = 303;
		yPortCoord = 23;
		var i = 15;
		port = new top.rj45port(portInvImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
		return dev;

}

// EAGLEEYE SM-ES2-24 		
function SM_ES2_24(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 26;   // 2 Gi internal ports
	dev.x=0;
	dev.y=0;
	dev.image = "images/EE_SM_ES2_24.gif";	
	
	//LED ( draw Enable LED )
	construct_EagleEye_Led(dev, 31, 67, 5, 5); 

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3; 
	var xPortGroupGap = 19;  
	var xPortStartPos = 303;  
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 23 FastEthernet ports + 1 Gibabit Ethernet Ports in 2 groups .
	//16 ports in first group  & 8 ports in second group from  right to left
	for(i=0; i<23; i++){
		if(i%2 != 0){
			yPortCoord = 23; 
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 41;  
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 ==0 ) {
			 xPortCoord -= (portWidth + xPortGap); 
		}
		if ( i==14 || i == 22 )	{		// Check for Second group Gap
		
			xPortCoord -= (xPortGroupGap - xPortGap); 
		}
		dev.addPort(port);
	}
		xPortCoord = 303;
		yPortCoord = 23;
		var i = 23;
		port = new top.rj45port(portInvImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;

		dev.addPort(port); 
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED","PoE");
	return dev;
}

// EAGLEEYE SM-ES2-24-P 		
function SM_ES2_24P(int_status, media_type){
	
	var dev = new top.device();
	dev.noofports = 26;   // 2 Gi internal ports
	dev.x=0;
	dev.y=0;
	dev.image = "images/EE_SM_ES2_24P.gif";	

	//LED ( draw Enable LED )
	construct_EagleEye_Led(dev, 31, 67, 5, 5); 

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3; 
	var xPortGroupGap = 19;  
	var xPortStartPos = 303;  
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 23 FastEthernet ports + 1 Gibabit Ethernet Ports in 2 groups .
	//16 ports in first group  & 8 ports in second group from  right to left
	for(i=0; i<23; i++){
		if(i%2 != 0){
			yPortCoord = 23; 
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 41;  
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 ==0 ) {
			 xPortCoord -= (portWidth + xPortGap); 
		}
		if ( i==14 || i == 22 )	{		// Check for Second group Gap
		
			xPortCoord -= (xPortGroupGap - xPortGap); 
		}
		dev.addPort(port);
	}
		xPortCoord = 303;
		yPortCoord = 23;
		var i = 23;
		port = new top.rj45port(portInvImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;

		dev.addPort(port);
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}
// EAGLEEYE SM-D-ES2-48 	
function SMD_ES2_48(int_status, media_type) {
//48 FastEthernet Ports.
//2  SFP Ports (Gi0/1 & Gi0/2) & Internal ports (Gi0/51 and Gi0/52).
	
	var dev = new top.device();

	dev.noofports = 52; // 50 + 2 internal.
	dev.x=0;
	dev.y=0;
	dev.image = "images/EE_SMD_ES2_48.gif";

	construct_EagleEye_Led(dev, 33, 63, 8, 4); 
	
	// Create the Ports.
	var port;
	var	portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3;//8; 
	var xPortGroupGap = 13;
	var xPortStartPos = 576; 
	var xPortCoord = xPortStartPos;
	var yPortCoord;

   // Add the 48 (2 to 50) FastEthernet ports in three groups from right to left 16 on each group
 	portWidth = 19;
	xPortGap = 3; 
	xPortCoord =576;

	for(var i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 23;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i+2; //Lable
		if(i%2 != 0) {
			xPortCoord -= (portWidth + xPortGap);	
		}
		if(i == 15 || i == 31) {
			xPortCoord -= (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }
	// Add the 2 SFP ports - Gi0/1 and Gi0/2
	// Gi0/51 & Gi0/52 are internal ports
		xPortCoord=612;//609;
		yPortCoord = 22;
		xPortGap=8;
		portWidth=21;
	
		for(i=48; i<50; i++) {
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			//port.id = "port_" + i;
			if(i%2 == 0) {
				yPortCoord = 41;
				port.id = "port_" + 0; //1st SFP port
			}else
				port.id = "port_" + 1; //2nd SFP port
			dev.addPort(port);
		}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	return dev;
}

function createDevice(int_status, media_type, deviceType) 
{
	var device = null;
	
	if(deviceType == null) 
		return device;

	if(deviceType == "SM-ES2-16-P"){ //EagleEye-16 PoE
		device = new SM_ES2_16P(int_status, media_type);
	}
	else if(deviceType == "SM-ES2-24-P"){ //EagleEye-24 PoE 
		device = new SM_ES2_24P(int_status, media_type);
	}
	else if(deviceType == "SM-ES2-24"){ //EagleEye-24 
		device = new SM_ES2_24(int_status, media_type);
	}
	else if(deviceType == "SM-D-ES2-48"){ //EagleEye-48  
		device = new SMD_ES2_48(int_status, media_type);
	}
	if(device != null) 
	{
		device.type = deviceType;
		device.family = "Enhanced EtherSwitch Service Module";
	}

	return device;
}
//construct EN Led for EagleEye
function construct_EagleEye_Led(dev, x, y, width, height) {
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = x;
	tempLed.y = y;
	tempLed.width = width;
	tempLed.height = height;
	tempLed.id = "en_led";
	tempLed.device = dev;
	dev.sysleds["EN"] = tempLed;
}

//*** End of EagleEye Layer 2 SKUs ***//