/*
 *------------------------------------------------------------------
 * portstats.js -- Parsing code for port statistics.  
 *
 * Copyright (c) 2004, 2006, 2008, 2010 by cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 */

function parseData(details, intStatus, interfaceData) {
	var tempBuffer;
	var intArray = split("\n", trim_string(token_string("Duplex  Speed Type",1,intStatus)));
	var portName= "" ;
	var stackMemberPorts = new Array();
	var memberPortCount = 0;
	var memberNumber = top.getSelectedDevice().stackNumber;
	for (var i = 0; i<intArray.length; i++) {
	   var tmp = split(" ", compact_line(intArray[i]));
	   if ( tmp.length > 4){
	   	if(tmp[0].indexOf("Po") == 0) { //skip ether channels
		  	continue;
		}
		  portNames[portNames.length] = tmp[0];
		  if ( isPortOfMember(portNames[portNames.length-1], memberNumber)) {
			  stackMemberPorts[memberPortCount] = portNames[portNames.length-1];
			  memberPortCount = memberPortCount +1;
		  }
	   }
	}
	var tmpDetails = split('Transmit',details);
	if (portNames.join("##").indexOf("Fa0") != -1 && tmpDetails.join("##").indexOf("FastEthernet0") != -1)
	{
		var portFa0index=0;
		for (var i=0; i<tmpDetails.length;i++)
		{
			if ( tmpDetails[i].indexOf("FastEthernet0") != -1 )
			{
				portFa0index = i;
			}

		}
		var temp = tmpDetails[portFa0index];
		tmpDetails.splice(portFa0index,1);
		tmpDetails[tmpDetails.length] = temp;
	}
	if ( tmpDetails.length != portNames.length)  
	{
		details = new Array();
		var i = 0;
		var j = 0;
		var port="";
		var portname="";
		var tmppport="";
		while ( i < portNames.length) 
		{
			if (portNames[i].indexOf("/0/") != -1)
			{
				port =  trim_string(grep_string("/0/", portNames[i]));
				portname = port.substring(port.indexOf("/0/")-1, port.length);
			}
			else if (portNames[i].indexOf("Fa0") != -1)
			{
				portname = "FastEthernet0";
			} 
			
			if (tmpDetails[j].indexOf("/0/") != -1)
			{ 
				var holder =  trim_string(grep_string("/0/", tmpDetails[j]));
				var holder2 = holder.substring(holder.indexOf("/0/")-1, holder.length);
				tmpport = holder2.split(" ")[0];
			}
			else if (tmpDetails[j].indexOf("FastEthernet0") != -1)
			{
				tmpport = "FastEthernet0";
			}
			
			if ( tmpport == portname )
			{
				details[i] = tmpDetails[j];				
			}
			else 
			{
				j++;
				continue;
			}
			i++;
			j++;
		}
	} 
	else 
	{
		details = tmpDetails;
	}
	totalPorts = details.length;
	//if ( details.length != portNames.length)  { 
	//	alert("This logic will not work");
	//}
	
	total_Bytes_Trans = new Array(memberPortCount);
	total_Bytes_Recev = new Array(memberPortCount);
	total_Pkts_Trans = new Array(memberPortCount);
	total_Pkts_Recev = new Array(memberPortCount);
	unicast_Trans = new Array(memberPortCount);
	unicast_Recev = new Array(memberPortCount);
	multicast_Trans = new Array(memberPortCount);
	multicast_Recev = new Array(memberPortCount);
	broadcast_Trans = new Array(memberPortCount);
	broadcast_Recev = new Array(memberPortCount);
	total_Error_Trans = new Array(memberPortCount);
	total_Error_Recev = new Array(memberPortCount);
	total_Collision = new Array(memberPortCount)
	xcess_Collision  = new Array(memberPortCount);
	late_Collision = new Array(memberPortCount);
	FCS_Error = new Array(memberPortCount);
	alignment_Error = new Array(memberPortCount);
	collision_Fragments = new Array(memberPortCount);
	oversize_Pkts = new Array(memberPortCount);
	undersize_Pkts = new Array(memberPortCount);
	var count = 0;
	
	for( i = 0; i < totalPorts; i++ ) {
		if ( !isPortOfMember(portNames[i], memberNumber)) {
			continue;
		}
		
	// getting total Bytes;
		tempBuffer = grep_string('Bytes', details[i]);
		tempArr = split('Bytes',tempBuffer);
		total_Bytes_Trans[count] = trim_string(tempArr[0]);
		total_Bytes_Recev[count] = trim_string(tempArr[1]);
		// getting the Unicast Pkts.
		tempBuffer = grep_string('Unicast frames', details[i]);
		if ( tempBuffer == null) {
			tempBuffer = grep_string('Frames', details[i]);
			tempArr = split('Frames',tempBuffer);
		} else {
			tempArr = split('Unicast frames',tempBuffer);
		}
		unicast_Trans[count] = trim_string(tempArr[0]);
		unicast_Recev[count] = trim_string(tempArr[1]);
		//getting the Multicast Pkts.
		tempBuffer = multi_grep_string('Multicast frames', details[i]);
		if ( tempBuffer.length == 1) {
			tempArr = split('Multicast frames',tempBuffer[0]);
			multicast_Trans[count] = trim_string(tempArr[0]);
			multicast_Recev[count] = trim_string(tempArr[1]);
		} else {
			tempArr = split('Multicast frames',tempBuffer[0]);
			multicast_Trans[count] = trim_string(tempArr[0]);
			tempArr = split(' ',compact_line(tempBuffer[1]));
			if ( tempArr.length > 4 ) {
				multicast_Recev[count] = trim_string(tempArr[3]);
			} else {
				multicast_Recev[count] = 0;
			}
		}								
		// getting the Broadcast Pkts.
		tempBuffer = multi_grep_string('Broadcast frames', details[i]);
		if ( tempBuffer.length == 1) {
			tempArr = split('Broadcast frames',tempBuffer[0]);
			broadcast_Trans[count] = trim_string(tempArr[0]);
			broadcast_Recev[count] = trim_string(tempArr[1]);
		} else {
			tempArr = split('Broadcast frames',tempBuffer[0]);
			broadcast_Trans[count] = trim_string(tempArr[0]);
			tempArr = split(' ',compact_line(tempBuffer[1]));
			if ( tempArr.length > 4 ) {
				broadcast_Recev[count] = trim_string(tempArr[3]);
			} else {
				broadcast_Recev[count] = 0;
			}
		}
		// calculating the total tranmitted and Received Packets..
		total_Pkts_Trans[count] = parseInt(unicast_Trans[count]) + parseInt(multicast_Trans[count]) + parseInt(broadcast_Trans[count]);
		total_Pkts_Recev[count] = parseInt(unicast_Recev[count]) + parseInt(multicast_Recev[count]) + parseInt(broadcast_Recev[count]);
		// calculating the total Collisions...
		
		tempBuffer = multi_grep_string('collision frames', details[i]);
		var temp = 0;
		for( j = 0; j< tempBuffer.length;j++) {
			tempArr = split((j+1)+' collision frames',tempBuffer[j])
			temp += parseInt(trim_string(tempArr[0]));
		}
		total_Collision[count] = temp;
		
		
	//  Exceissive collision
		tempBuffer = grep_string('Excessive collisions', details[i]);
		tempArr = split('Excessive collisions',tempBuffer);
		xcess_Collision[count] = trim_string(tempArr[0]);
	// Late Collisions	
		tempBuffer = grep_string('Late collisions', details[i]);
		tempArr = split('Late collisions',tempBuffer);
		late_Collision[count] = trim_string(tempArr[0])
	//  FCS_Error
		tempBuffer = grep_string('FCS errors', details[i]);
		tempBuffer = compact_line(tempBuffer)
		FCS_Error[count] = token_string(" ",4,tempBuffer);
		if ( FCS_Error[count] == "FCS" ) {
			FCS_Error[count] = token_string(" ",3,tempBuffer);
		}
	// Alignment Error
		tempBuffer = grep_string('Alignment errors', details[i]);
		tempBuffer = compact_line(tempBuffer)
		alignment_Error[count] = token_string(" ",4,tempBuffer);
		if ( alignment_Error[count] == "Alignment" ) {
			alignment_Error[count] = token_string(" ",3,tempBuffer);
		}
	
	// Total Error calculation 
		total_Error_Trans[count] = parseInt(total_Collision[count]) + parseInt(late_Collision[count]) + parseInt(xcess_Collision[count]);
		total_Error_Recev[count] = parseInt(FCS_Error[count]) + parseInt(alignment_Error[count]);
	// undersize Packets
                tempBuffer = grep_string('Valid frames, too small', details[i]);
                if (tempBuffer != null) {
                        tempBuffer = compact_line(token_string('Valid frames, too smal', 0, tempBuffer));
                        var tmpArray = split(" ",tempBuffer);
                        undersize_Pkts[count] = parseInt(tmpArray[tmpArray.length-1]);
                } else {
                        undersize_Pkts[count] = 0;
                }
                //Fix for CSCsi62687
                /*tempBuffer = grep_string('Invalid frames, too small', details[i]);
                if ( tempBuffer != null) {
                        tempBuffer = compact_line(token_string('Invalid frames, too smal', 0, tempBuffer));
                        var tmpArray = split(" ",tempBuffer);
                        undersize_Pkts[count] += parseInt(tmpArray[tmpArray.length-1]);
                } else {
                        undersize_Pkts[count] += 0;
                }*/
        // oversize packets
                tempBuffer = grep_string('Valid frames, too large', details[i]);
                if ( tempBuffer != null) {
                        tempBuffer = compact_line(token_string('Valid frames, too larg', 0, tempBuffer));
                        var tmpArray = split(" ",tempBuffer);
                        oversize_Pkts[count] = parseInt(tmpArray[tmpArray.length-1]);
                } else {
                        oversize_Pkts[count] = 0;
                }
                tempBuffer = grep_string('Invalid frames, too large', details[i]);
                if ( tempBuffer != null) {
                        tempBuffer = compact_line(token_string('Invalid frames, too larg', 0, tempBuffer));
                        var tmpArray = split(" ",tempBuffer);
                        oversize_Pkts[count] += parseInt(tmpArray[tmpArray.length-1]);
                } else {
                        oversize_Pkts[count] += 0;
                }
	// Collision Fragments
		tempBuffer = grep_string('Collision fragments', details[i]);
		if ( tempBuffer != null) {
			tempBuffer = compact_line(tempBuffer)
			collision_Fragments[count] = token_string(" ",4,tempBuffer);
		} else {
			collision_Fragments[count] = 0;
		}
		count = count + 1 ;
	}
	portNames = stackMemberPorts;
	totalPortArray = portNames;
	totalPorts = portNames.length;
}																											

function isPortOfMember(port, memberNumber) {
	if (port == "Fa0") return true;
	var portStackMemberNumber = parseInt(port.charAt(2));
	return (portStackMemberNumber == memberNumber);
}
