app.service("portsDataSourceService",['$rootScope','requestRoutingService',function($rootScope,requestRoutingService){
return {

    getPortData: function (selectedPortId) {
        var portsObj = {};
        var portsStatusInfo = requestRoutingService.getShowCmdOutput("show interfaces "+ selectedPortId +" status", "showInterfacesStatus");
        portsStatusInfo = portsStatusInfo.ShowInterfacesStatus.wnwebdata.entry;
                portsObj["PortId"] = portsStatusInfo.Port;
                portsObj["Status"] = portsStatusInfo.Status;
                portsObj["Speed"] = portsStatusInfo.Speed.replace(/^a-/, "");
                portsObj["Duplex"] = portsStatusInfo.Duplex.replace(/^a-/, "");

        var portsDescInfo = requestRoutingService.getShowCmdOutput("show interfaces "+ selectedPortId +" description", "showInterfacesDescription");
        portsDescInfo = portsDescInfo.showInterfacesDescription.wnwebdata.entry;
        portsObj["Description"] = portsDescInfo.Description;

        var portsSwitchInfo = requestRoutingService.getShowCmdOutput("show interfaces "+ selectedPortId +" switchport", "showInterfacesSwitchport");
        portsSwitchInfo = portsSwitchInfo.showInterfacesSwitchport.wnwebdata.Name;
                portsObj["SwitchMode"] = portsSwitchInfo.swtMode;
                portsObj["accessVlan"] = portsSwitchInfo.accessVlan;
                portsObj["voiceVlan"] = portsSwitchInfo.voiceVlan;
                portsObj["nativeVlan"] = portsSwitchInfo.nativeVlan;
                portsObj["vlanIDs"] = portsSwitchInfo.vlanIDs;

        var runningconfig = requestRoutingService.getShowCmdOutput("show running-config interface "+ selectedPortId,"showRunConfig");
        runningconfig = runningconfig.ShowRunningGig.wnwebdata;
        portsObj["dhcpsnooping"] = runningconfig.ipdhcpsnooping;
        portsObj["portfast"] = runningconfig.portfast;
        portsObj["stormControl"] = runningconfig.storm;
		portsObj["autoQOS"] = runningconfig.autoQOS;

        var advSetting = {};

        advSetting.broadcast = runningconfig.broadcast;
        advSetting.broadcast = advSetting.broadcast === undefined ? "" : advSetting.broadcast;
        var broadcastToString = advSetting.broadcast.toString();

        advSetting.multicast = runningconfig.multicast;
        advSetting.multicast = advSetting.multicast === undefined ? "" : advSetting.multicast;
        var multicastToString = advSetting.multicast.toString();

        advSetting.unicast = runningconfig.unicast;
        advSetting.unicast = advSetting.unicast === undefined ? "" : advSetting.unicast;
        var unicastToString = advSetting.unicast.toString();
        
        portsObj["broadcast"]=broadcastToString.split('.')[0];
        portsObj["multicast"]=multicastToString.split('.')[0];
        portsObj["unicast"]=unicastToString.split('.')[0];

        portsObj["runDuplex"]=runningconfig.duplex;
        portsObj["runSpeed"]=runningconfig.speed;
        
      //Adding selecon support
        if($rootScope.deviceInfo.type.indexOf("CDB")!=-1){
    		var powerInlineStatus = deviceCommunicator.getExecCmdOutput("show run int "+selectedPortId);
    		if(powerInlineStatus.indexOf("no power inline port 2-event")!=-1){
    			portsObj["eveClassification"]=false;
    		}else{
    			portsObj["eveClassification"]=true;
    		}
    		if(powerInlineStatus.indexOf("no power inline port poe-ha")!=-1){
    			portsObj["perpetualPoE"]=false;
    		}else{
    			portsObj["perpetualPoE"]=true;
    		}
        }
        
        return portsObj;
    }
}
}]);
