/**
 Description: Controller for AAA
 Copyright (c) 2017 by Cisco Systems, Inc.
 All rights reserved.
 */
app.register.controller('aaaCtrl', ['$scope','$rootScope','$timeout', '$filter', 'gridCrudService','requestRoutingService','dataSourceService','dialogService','notificationService','executeCliCmdService','validationService','getStringLineService','aaaService',
	function($scope,$rootScope,$timeout, $filter, gridCrudService,requestRoutingService,dataSourceService,dialogService,notificationService,executeCliCmdService,validationService,getStringLineService,aaaService) {
		var translate = $filter("translate");
		var trimVal=$filter('trimValue');
		angular.extend($scope, {
			hideQuickSetupRadiusServers: true,
			hideQuickSetupsLdapServer: true,
			hideQuickSetupTacacsServers: true,
			hideQuickSetupRadiusServersGroup: true,
            hideQuickSetupTacacsServersGroup: true,
			hideQuickSetupLdapServerGrp: true,
            hideQuickSetupAuthentication: true,
            hideQuickSetupAuthorization: true,
			authTypeOptions: aaaService.authTypeOptions(),
			groupTypeOptions: aaaService.groupTypeOptions(),
			authorTypeOptions: aaaService.authorTypeOptions(),
			macDelimeterOptions: aaaService.macDelimeterOptions(),
			ldapServerSimpleBindOptions: aaaService.serverldapOptions(),
			ldapServerUserAttributeOptions: aaaService.serverldapuserAttr(),
			ldapServerTrustPointOptions: aaaService.serverldapTrustPoint(),
			macFilterOptions: aaaService.macFilterOptions(),
			accountType: aaaService.accoutTypeOptions(),
			radiusSelectedServerGroupOptions: [],
			tacacsSelectedServerGroupOptions: [],
			ldapSelectedServerGroupOptions: [],
			availableAuthMethodListOptions: [],
			authSelectedServerGroupOptions: [],
			availableRadiusGroupOptions: [],
			availableAuthorMethodListOptions: [],
			authorSelectedServerGroupOptions: [],
			availableTacacsGroupOptions: [],
			availableLdapGroupOptions: [],
			aaa:{
				methodList:{
					auth:{
						type:null,
						grouptype:null
					},
					author:{
						type:null,
						grouptype:null
					},
					account: {
						type:null
					}
				},
				serverGroup:{
					radius:{
						macdelimiter:null,
						securitymode:null
					},
					tacacs:{},
					ldap:{}
				},
				servers:{
					ldap:{
						ldapServerSimpleBind: null,
						ldapServerUserAttribute: null,
						ldapServerTrustPoint: null,
						selectedObjectType: null
					}
			    },
				tacacs:{},
				advanced: {
					radiusFallback: {}
				},
				general:{
					localAuthentication:null,
					localAuthorization:null
				}
			}
		});
		/*AAA Authentication Grid*/
		var editMethodListAuthData = function(){
			var selected = this.dataItem(this.select());
			$scope.authSelectedServerGroupOptions = [];
			$scope.loadAvailServerGrpAuthMethodListOptions();
			if(angular.isObject(selected)){
				$scope.disableAuthenticationName = true;
				$scope.hideQuickSetupAuthentication = false;
				$scope.aaa.methodList.auth = angular.copy(selected);
				$scope.selectedAuthenticationName = selected.listname;
				$scope.deleteAuthentication = ($scope.selectedArrayObject["selectedAuthenticationArray"].length == 0);
				if(selected.fallback){
					if(typeof(selected.fallback) === "string"){
						fallBackStr = selected.fallback.split(" ");
					}
					if(fallBackStr[0] === "group" && fallBackStr[fallBackStr.length - 1] === "local"){
						$scope.aaa.methodList.auth.fallback = true;
					}else if(selected.fallback == true){
						$scope.aaa.methodList.auth.fallback = true;
					}else{
						$scope.aaa.methodList.auth.fallback = false;
					}
				}
				for (var i = 0; i < $scope.aaa.methodList.auth.group.length; i++) {
					$scope.authSelectedServerGroupOptions[i] = $scope.aaa.methodList.auth.group[i];
				}
				$scope.availableAuthMethodListOptions = $scope.availableAuthMethodListOptions.filter(function(val) {
					return $scope.authSelectedServerGroupOptions.indexOf(val) == -1;
				});
			}else{
				$scope.disableAuthenticationName = false;
				$scope.hideQuickSetupAuthentication = true;
			}
			angular.element("#authenticationForm  span.k-tooltip-validation").hide();
		};
		$scope.authenticationGridOptions = {
			editable : false,
			sortable : true,
			change:editMethodListAuthData,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			scrollable : false,
			selectable : true,
			pageable : {
				 messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			columns : [{
                "template": "<input type=\"checkbox\"  ng-model=\"authentication\" ng-click=\"isChecked(authentication,dataItem, 'Authentication')\"  />",
                sortable: false,
                width: 40
            }, {
				field : "listname",
				title : translate("com_name")
			}, {
				field : "type",
				title : translate("management_snmp_host_type")
			}, {
				field : "grouptype",
				title : translate("aaa_group_type")
			}, {
				title : translate("aaa_group1"),
				template : "#=(group[0]==undefined?'N/A':group[0])#"
			}, {
				title : translate("aaa_group2"),
				template : "#=(group[1]==undefined?'N/A':group[1])#"
			}, {
				title : translate("aaa_group3"),
				template : "#=(group[2]==undefined?'N/A':group[2])#"
			}, {
				title : translate("aaa_group4"),
				template : "#=(group[3]==undefined?'N/A':group[3])#"
			}]
		};
		/*AAA Authentication Grid Ends*/
		/*AAA Authorization Grid Starts Here*/
		var editMethodListAuthorData = function(){
			var selected = this.dataItem(this.select()),fallBackStr;
			$scope.authorSelectedServerGroupOptions = [];
			$scope.loadAvailServerGrpMethodListOptions("availableAuthorMethodListOptions", aaaService.getAAAServerGroupRadius);
			if(angular.isObject(selected)){
				$scope.disableAuthorizationName = true;
				$scope.hideQuickSetupAuthorization = false;
				$scope.aaa.methodList.author = angular.copy(selected);
				$scope.selectedAuthorizationName = selected.listname;
				$scope.deleteAuthorization = ($scope.selectedArrayObject["selectedAuthorizationArray"].length == 0);
				if(selected.fallback){
					if(typeof(selected.fallback) === "string"){
						fallBackStr = selected.fallback.split(" ");
					}
					if(fallBackStr[0] === "group" && fallBackStr[fallBackStr.length - 1] === "local"){
						$scope.aaa.methodList.author.fallback = true;
					}else if(selected.fallback == true){
						$scope.aaa.methodList.author.fallback = true;
					}else{
						$scope.aaa.methodList.author.fallback = false;
					}
				}
				for (var i = 0; i < $scope.aaa.methodList.author.group.length; i++) {
					$scope.authorSelectedServerGroupOptions[i] = $scope.aaa.methodList.author.group[i];
				}
				$scope.availableAuthorMethodListOptions = $scope.availableAuthorMethodListOptions.filter(function(val) {
					return $scope.authorSelectedServerGroupOptions.indexOf(val) == -1;
				});
			}else{
				$scope.disableAuthorizationName = false;
				$scope.hideQuickSetupAuthorization = true;
			}
			angular.element("#authorizationForm  span.k-tooltip-validation").hide();
		}
		$scope.authorizationGridOptions = {
			editable : false,
			sortable : true,
			change:editMethodListAuthorData,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			scrollable : false,
			selectable : true,
			pageable : {
				 messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			columns : [{
                "template": "<input type=\"checkbox\"  ng-model=\"authorization\" ng-click=\"isChecked(authorization,dataItem, 'Authorization')\"  />",
                sortable: false,
                width: 40
            }, {
				field : "listname",
				title : translate("com_name")
			}, {
				field : "type",
				title : translate("management_snmp_host_type")
			}, {
				field : "grouptype",
				title : translate("aaa_group_type")
			}, {
				title : translate("aaa_group1"),
				template : "#=(group[0]==undefined?'N/A':group[0])#"
			}, {
				title : translate("aaa_group2"),
				template : "#=(group[1]==undefined?'N/A':group[1])#"
			}, {
				title : translate("aaa_group3"),
				template : "#=(group[2]==undefined?'N/A':group[2])#"
			}, {
				title : translate("aaa_group4"),
				template : "#=(group[3]==undefined?'N/A':group[3])#"
			}]
		};
		/*AAA Authorization Grid Ends*/
		/*Server Group Grid*/
		var editServerGroupRadiusData = function(){
			var selected = this.dataItem(this.select());
			$scope.radiusSelectedServerGroupOptions = [];
			$scope.serverGroupAccordian(true,false);
			if(angular.isObject(selected)){
				$scope.disableRadiusServersGroupName = true;
				$scope.hideQuickSetupRadiusServersGroup = false;
				$scope.aaa.serverGroup.radius = angular.copy(selected);
				if(!$scope.aaa.serverGroup.radius.macdelimiter){
					$scope.aaa.serverGroup.radius.macdelimiter = $scope.macDelimeterOptions.options.data[0].macDelimeterValue;
				}
				if(!$scope.aaa.serverGroup.radius.securitymode){
					$scope.aaa.serverGroup.radius.securitymode = $scope.macFilterOptions.options.data[0].macFilterValue;
				}
				$scope.selectedServerGroupRadiusName = selected.name;
				$scope.deleteRadiusServersGroup = ($scope.selectedArrayObject["selectedRadiusServerGroupArray"].length == 0);
				for (var i = 0; i < $scope.aaa.serverGroup.radius.list.length; i++) {
					$scope.radiusSelectedServerGroupOptions[i] = $scope.aaa.serverGroup.radius.list[i].list;
				}				
				$scope.availableRadiusGroupOptions = $scope.availableRadiusGroupOptions.filter(function(val) {
					return $scope.radiusSelectedServerGroupOptions.indexOf(val) == -1;
				});
			}else{
				$scope.disableRadiusServersGroupName = false;
				$scope.hideQuickSetupRadiusServersGroup = true;
			}
			angular.element("#radiusGroupForm  span.k-tooltip-validation").hide();
		};
		$scope.radiusGroupGridOptions = {
			editable : false,
			sortable : true,
			change:editServerGroupRadiusData,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			scrollable : false,
			selectable : true,
			pageable : {
				 messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			columns : [{
                "template": "<input type=\"checkbox\"  ng-model=\"radiusServerGrp\" ng-click=\"isChecked(radiusServerGrp,dataItem, 'RadiusServerGroup')\"  />",
                sortable: false,
                width: 40
            }, {
				field : "name",
				title : translate("com_name")
			}, {
				title : translate("aaa_server1"),
				template : "#=(list[0]==undefined?'N/A':list[0].list)#"
			}, {
				field : "server2",
				title : translate("aaa_server2"),
				template : "#=(list[1]==undefined?'N/A':list[1].list)#"
			}, {
				field : "server3",
				title : translate("aaa_server3"),
				template : "#=(list[2]==undefined?'N/A':list[2].list)#"
			}, {
				field : "list",
				title : translate("aaa_title_list"),
				hidden : "true"
			}]
		};
		/*Server Group Grid Ends*/
			var editServerGroupTacacsData= function() {
			var selected = this.dataItem(this.select());
			$scope.tacacsSelectedServerGroupOptions = [];
			$scope.serverGroupTacacsAccordian(true, false);
			if(angular.isObject(selected)){
				$scope.disableTacacsServersGroupName = true;
				$scope.hideQuickSetupTacacsServersGroup = false;
				$scope.aaa.serverGroup.tacacs = angular.copy(selected);
				$scope.selectedServerGroupTacacsName = selected.name;
				$scope.ServerGroupTacacsDelBtn = ($scope.selectedArrayObject["selectedTacacsServerGroupArray"].length == 0);
				for (var i = 0; i < $scope.aaa.serverGroup.tacacs.list.length; i++) {
					$scope.tacacsSelectedServerGroupOptions[i] = $scope.aaa.serverGroup.tacacs.list[i].list;
				}
				$scope.availableTacacsGroupOptions = $scope.availableTacacsGroupOptions.filter(function(val) {
					return $scope.tacacsSelectedServerGroupOptions.indexOf(val) == -1;
				});
				if (!$scope.$$phase)
  					$scope.$apply();
			}else{
				$scope.disableTacacsServersGroupName = false;
				$scope.hideQuickSetupTacacsServersGroup = true;
			}
			angular.element("#tacacsGroupForm").kendoValidator().data("kendoValidator").hideMessages();
		};
		$scope.serverGroupTacacsGridOptions = {
			dataSource: $scope.serverGroupTacacsData,
			editable : false,
			sortable : true,
			change: editServerGroupTacacsData,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			scrollable : false,
			selectable : true,
			pageable : {
				 messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			columns : [{
                "template": "<input type=\"checkbox\"  ng-model=\"tacacsServerGrp\" ng-click=\"isChecked(tacacsServerGrp,dataItem, 'TacacsServerGroup')\"  />",
                sortable: false,
                width: 40
            }, {
				field : "name",
				title : translate("com_name")
			}, {
				field : "server1",
				title : translate("aaa_server1"),
				template : "#=(list[0]==undefined?'N/A':list[0].list)#"
			}, {
				field : "server2",
				title : translate("aaa_server2"),
				template : "#=(list[1]==undefined?'N/A':list[1].list)#"
			}, {
				field : "server3",
				title : translate("aaa_server3"),
				template : "#=(list[2]==undefined?'N/A':list[2].list)#"
			}, {
				field : "list",
				title : "list",
				hidden : "true"
			}]
		};
		/*****************************Server Group Tacacs Grid Ends Here*****************************/
		
	var editServerGroupLdapData= function() {
		var selected = this.dataItem(this.select());
		$scope.ldapSelectedServerGroupOptions = [];
		$scope.serverGroupLdapAccordian(true, false);
		if(angular.isObject(selected)){
			$scope.disableLdapServersGroupName = true;
			$scope.hideQuickSetupLdapServerGrp = false;
			$scope.aaa.serverGroup.ldap = angular.copy(selected);
			$scope.selectedServerGroupLdapName = selected.name;
			$scope.deleteLdapServer = ($scope.selectedArrayObject["selectedLdapServerGroupArray"].length == 0);
			for (var i = 0; i < $scope.aaa.serverGroup.ldap.list.length; i++) {
				$scope.ldapSelectedServerGroupOptions[i] = $scope.aaa.serverGroup.ldap.list[i].list;
			}
			$scope.availableLdapGroupOptions = $scope.availableLdapGroupOptions.filter(function(val) {
				return $scope.ldapSelectedServerGroupOptions.indexOf(val) == -1;
			});
			if (!$scope.$$phase)
				$scope.$apply();
		}else{
			$scope.disableLdapServersGroupName = false;
			$scope.hideQuickSetupLdapServerGrp = true;
		}
		angular.element("#ldapServerGroupForm").kendoValidator().data("kendoValidator").hideMessages();
	};	
	$scope.ldapServerGroupGridOptions = {
		dataSource: $scope.ldapServerGroupGridData,
		editable : false,
			sortable : true,
			change: editServerGroupLdapData,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			scrollable : false,
			selectable : true,
			pageable : {
				 messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
		columns : [{
			"template" : "<input type=\"checkbox\" ng-init=\"checked=false\" ng-model=\"checked\" ng-click=\"isChecked(checked,dataItem,'LdapServerGroup')\"  />",
			sortable : false
		}, {
			field : "name",
			title : translate("com_name")
		}, {
			title : translate("aaa_server1"),
			template : "#=(list[0]==undefined?'N/A':list[0].list)#"
		}, {
			title : translate("aaa_server2"),
			template : "#=(list[1]==undefined?'N/A':list[1].list)#"
		}, {
			title : translate("aaa_server3"),
			template : "#=(list[2]==undefined?'N/A':list[2].list)#"
		}, {
			field : "list",
			title : "list",
			hidden : "true"
		}]
	};
		var editServerRadiusData = function(){
			var selected = this.dataItem(this.select());
			if(angular.isObject(selected)){
				$scope.disableRadiusServersName = true;
				$scope.hideQuickSetupRadiusServers = false;
				$scope.aaa.servers.radius = angular.copy(selected);
				$scope.selectedServerRadiusName = selected.name;
				$scope.deleteRadiusServers = ($scope.selectedArrayObject["selectedRadiusServerArray"].length == 0);
				$scope.aaa.servers.radius.confirmPassword = selected.password;
			}else{
				$scope.disableRadiusServersName = false;
				$scope.hideQuickSetupRadiusServers = true;
			}
		}
		//Kendo Validations
		$scope.aaaValidations = {
			rules : {
				max : function(input) {
					var maxlength = input.data('max');
					if (maxlength) {
						return input.val().length < Number(maxlength);
					}
					return true;
				},
				min : function(input) {
					var minValue = input.data('min');
					if (minValue){
						return input.val().length > Number(minValue);
					}
					return true;
				},
				validateip : function(input) {
					if (angular.isUndefined(input.data('validateIp'))) {
						return true;
					}
					if (validationService.validateIPAddress(input)) {
						return true;
					}
					else {
						return false;
					}
				},
				matches : function(input) {
					var toMatch = input.data('matches');
					var toModule = input.data('module');
					if (!toMatch){
						return true;
					}
					if (toMatch) {
						var match = $scope.aaa.servers[toModule][toMatch];
						return (input[0].value === match);
					}
					return true;
				},
				aaaservers : function(input) {
					if (angular.isUndefined(input.data('aaaservers'))) {
						return true;
					} else {
						if (input.val().toUpperCase() == "RADIUS" || input.val().toUpperCase() == "TACACS" || input.val().toUpperCase() == "LDAP") {
							return false;
						} else {
							return true;
						}
					}
				},
				ipportradius : function(input) {
					if (angular.isUndefined(input.data('ipportradius'))) {
						return true;
					} else {
						/*for (var index = 0; index < $scope.radiusServersGridData.length; index++) {
							if ($scope.radiusServersGridData[index].name != $scope.aaa.servers.radius.name && ($scope.radiusServersGridData[index].address == $scope.aaa.servers.radius.address) && ($scope.radiusServersGridData[index].authport == $scope.aaa.servers.radius.authport) && ($scope.radiusServersGridData[index].acctport == $scope.aaa.servers.radius.acctport)) {
								return false;
							}
						}*/
						return true;
					}
				},
				ipporttacacss : function(input) {
					if (angular.isUndefined(input.data('ipporttacacss'))) {
						return true;
					} else {
						/*for (var index = 0; index < $scope.tacacssServersGridData.length; index++) {
							if (($scope.tacacssServersGridData[index].name != $scope.aaa.servers.tacacss.name) && ($scope.tacacssServersGridData[index].address == $scope.aaa.servers.tacacss.address) && ($scope.tacacssServersGridData[index].port == $scope.aaa.servers.tacacss.port)) {
								return false;
							}
						}*/
						return true;
					}
				},
				ipportldap : function(input) {
					if (angular.isUndefined(input.data('ipportldap'))) {
						return true;
					} else {
						/*for (var index = 0; index < $scope.ldapServerGridData.length; index++) {
							if ($scope.ldapServerGridData[index].ldapServerName != $scope.aaa.servers.ldap.ldapServerName && ($scope.ldapServerGridData[index].ldapServerAddress == $scope.aaa.servers.ldap.ldapServerAddress) && ($scope.ldapServerGridData[index].ldapServerPortNumber == $scope.aaa.servers.ldap.ldapServerPortNumber)) {
								return false;
							}
						}*/
						return true;
					}

				},
				authduplicate: function(input){
					if (angular.isUndefined(input.data('authduplicate'))) {
						return true;
					} else {
						for (var index = 0; index < $scope.methodlistAuthData.length; index++) {
							if ($scope.methodlistAuthData[index].listname === $scope.aaa.methodList.auth.listname){
								return false;
							}
						}
						return true;
					}
				},
				authorduplicate: function(input){
					if (angular.isUndefined(input.data('authorduplicate'))) {
						return true;
					} else {
						for (var index = 0; index < $scope.methodlistAuthorData.length; index++) {
							if ($scope.methodlistAuthorData[index].listname === $scope.aaa.methodList.author.listname){
								return false;
							}
						}
						return true;
					}
				},
				radiusgroupduplicate: function(input){
					if (angular.isUndefined(input.data('radiusgroupduplicate'))) {
						return true;
					} else {
						for (var index = 0; index < $scope.serverGroupRadiusData.length; index++) {
							if ($scope.serverGroupRadiusData[index].name === $scope.aaa.serverGroup.radius.name){
								return false;
							}
						}
						return true;
					}
				},
				radiusduplicate: function(input){
					if (angular.isUndefined(input.data('radiusduplicate'))) {
						return true;
					} else {
						for (var index = 0; index < $scope.serverRadiusGridData.length; index++) {
							if ($scope.serverRadiusGridData[index].name === $scope.aaa.servers.radius.name){
								return false;
							}
						}
						return true;
					}
				},
				range: function (input) {
					if(input.val()){
						if(input.val() != ""){
							var count=0;
							var valMsg = input.data('rangeMsg');
							if ((valMsg==undefined)) {
								return true;
							}
							var min= trimVal(input.prop('min'));
							var max= trimVal(input.prop('max'));
							var arr = input.val().replace('-',',');
							arr= arr.split(',');						
							for(var i=0;i<arr.length;i++){
								if(parseFloat(trimVal(arr[i]))>=min && parseFloat(trimVal(arr[i]))<=max) {
									count++;
								}
							}
							if(arr.length!=count){
								return false;
							}
							return true;
						}
						else return true;
					}else{
						return true;
					}
				},
				check : function(input) {
					if (angular.isUndefined(input.data('checkMsg'))) {
						return true;
					}
					var val = input.val();
					if (val.indexOf("?") != -1 || val.indexOf(" ") != -1) {
						return false;
					}
					return true;
				},
				ldapserversduplicate : function(input) {
					if (angular.isUndefined(input.data('ldapserversduplicate'))){
						return true;
					}
					for (var index = 0; index < $scope.ldapServerGridData.length; index++) {
						if ($scope.ldapServerGridData[index].ldapServerName == $scope.aaa.servers.ldap.ldapServerName) {
							return false;
						}
					}
					return true;
				},
				accountduplicate : function(input) {
					if (angular.isUndefined(input.data('accountduplicate'))){
						return true;
					}
					for (var index = 0; index < $scope.accountGridData.length; index++) {
						if ($scope.accountGridData[index].name == $scope.aaa.methodList.account.name) {
							return false;
						}
					}
					return true;
				},
				matchldapserver : function(input) {
					var toMatch = input.data('matchldapserver');
					if (!toMatch)
						return true;
					if (toMatch) {
						var match = $scope.aaa.servers.ldap[toMatch];
						return (input[0].value === match);
					}
					return true;
				},
				ldapgroupduplicate : function(input) {
					if (angular.isUndefined(input.data('ldapgroupduplicate'))){
						return true;
					}
					for (var index = 0; index < $scope.ldapServerGroupGridData.length; index++) {
						if ($scope.ldapServerGroupGridData[index].name == $scope.aaa.serverGroup.ldap.name) {
							return false;
						}
					}
					return true;
				}
			}
		};
		//Server RADIUS data Grid
		$scope.serverRadiusGridOptions = {
			editable : false,
			sortable : true,
			change : editServerRadiusData,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			scrollable : false,
			selectable : true,
			pageable : {
				 messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			columns : [{
                "template": "<input type=\"checkbox\"  ng-model=\"radiusServer\" ng-click=\"isChecked(radiusServer,dataItem,'RadiusServer')\"  />",
                sortable: false,
                width: 40
            }, {
				field : "name",
				title : translate("com_name")
			}, {
				field : "address",
				title : translate("aaa_address")
			}, {
				field : "authport",
				title : translate("aaa_authport")
			}, {
				field : "acctport",
				title : translate("aaa_acctport")
			}]
		};
		//Server TRACE data Grid
		var editServerTacacsData = function(){
			var selected = this.dataItem(this.select());
			if(angular.isObject(selected)){
				$scope.disableTacacsServersName = true;
				$scope.hideQuickSetupTacacsServers = false;
				$scope.aaa.servers.tacacs = angular.copy(selected);
				$scope.selectedServerTacacsName = selected.name;
				$scope.deleteTacacsServers = ($scope.selectedArrayObject["selectedRadiusServerArray"].length == 0);
				$scope.aaa.servers.tacacs.confirmPassword = selected.password;
			}else{
				$scope.disableTacacsServersName = false;
				$scope.hideQuickSetupTacacsServers = true;
			}
		}
		$scope.serverTacacsGridOptions = {
			dataSource: $scope.serverTacacsGridDataSource,
			editable : false,
			sortable : true,
			change : editServerTacacsData,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			scrollable : false,
			selectable : true,
			pageable : {
				 messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			columns : [{
                "template": "<input type=\"checkbox\"  ng-model=\"tacacsServer\" ng-click=\"isChecked(tacacsServer,dataItem, 'tacacsServer')\"  />",
                sortable: false,
                width: 40
            }, {
				field : "name",
				title : translate("com_name")
			}, {
				field : "address",
				title : translate("aaa_server_address")
			}, {
				field : "port",
				title : translate("management_snmp_host_port")
			}]
		};
		$scope.selectedArrayObject = {
			selectedAuthenticationArray : [],
			selectedAuthorizationArray : [],
			selectedAccountingArray : [],
			selectedRadiusServerGroupArray : [],
            selectedTacacsServerGroupArray : [],
			selectedLdapServerGroupArray : [],
			selectedldapServerGroupArray : [],
			selectedRadiusServerArray : [],
			selectedldapServerArray : [],
			selectedtacacsServerArray : [],
			selectedUsersArray : [],
			selectedmacFilterArray : [],
			selectedattributeListArray : [],
			selectedAccountArray : []
		};
		// AAA Global function
		$scope.AAAaccordianTrigger = function(){
			angular.element('.aaaContainer li').removeClass('k-state-default');
		};
		$scope.deleted = {};
		$scope.AAA = function(){
			this.methodListAuthentication = function(){
				$scope.methodlistAuthData = new kendo.data.ObservableArray([]);
				var methodListAuthentication = aaaService.getAAAMethodListAuthentication();
				if(!angular.isUndefined(methodListAuthentication)){
					for(var i = 0; i < methodListAuthentication.length; i++){
						$scope.methodlistAuthData.push(methodListAuthentication[i]);
					}
				}
				$scope.authenticationGridGridDataSource = new kendo.data.DataSource({
					pageSize : 10,
					data : $scope.methodlistAuthData
				});
			};
			this.methodListAuthorization = function(){
				$scope.methodlistAuthorData = new kendo.data.ObservableArray([]);
				var methodListAuthorization = aaaService.getAAAMethodListAuthorization();
				if(!angular.isUndefined(methodListAuthorization)){
					for(var i = 0; i < methodListAuthorization.length; i++){
						$scope.methodlistAuthorData.push(methodListAuthorization[i]);
					}
				}
				$scope.authorizationGridGridDataSource = new kendo.data.DataSource({
					pageSize : 10,
					data : $scope.methodlistAuthorData
				});
			};
			this.serverRadiusInit = function(){
				$scope.serverRadiusGridData = new kendo.data.ObservableArray([]);
				var radiusServerData = aaaService.getAAARadiusServer();
				if(!angular.isUndefined(radiusServerData)){
					for(var i = 0; i < radiusServerData.length; i++){
						$scope.serverRadiusGridData.push(radiusServerData[i]);
					}
				}
				$scope.serverRadiusGridDataSource = new kendo.data.DataSource({
					pageSize: 10,
					data: $scope.serverRadiusGridData
				});
			};
			this.serverTacacsInit = function(){
				$scope.serverTacacsGridData = new kendo.data.ObservableArray([]);
				var radiusTacacsData = aaaService.getAAARadiusTacacs();
				if(!angular.isUndefined(radiusTacacsData)){
					for(var i = 0; i < radiusTacacsData.length; i++){
						$scope.serverTacacsGridData.push(radiusTacacsData[i]);
					}
				}
				$scope.serverTacacsGridDataSource = new kendo.data.DataSource({
					pageSize: 10,
					data: $scope.serverTacacsGridData
				});
			};
			// AAA Radius Fall Back Value setting done here
	 		this.aaaRadiusFallBack  = function(){
				var aaaRadiusFallbackDetails=aaaService.getAAARadiusFallBack();
				$scope.aaa.advanced.radiusFallback.retransmit= aaaRadiusFallbackDetails.retransmit;
				$scope.aaa.advanced.radiusFallback.timeout= aaaRadiusFallbackDetails.timeout;
				$scope.aaa.advanced.radiusFallback.deadTime= aaaRadiusFallbackDetails.deadtime;
			};
			this.aaaGeneral = function(){
				$scope.aaaGeneralService = aaaService.getAAAGeneral();
				var aaaGeneralServiceObject = {
					authentication: "none",
					authorization: "none"
				}
				$scope.aaaGeneralService = typeof($scope.aaaGeneralService) != "object" ? aaaGeneralServiceObject : $scope.aaaGeneralService;
				$scope.aaaLocalAuthentication=aaaService.aaaGeneralLocalAuthentication();
				//Dot1x System Auth Control value setting here
				var dot1xSystem=aaaService.getAAAGeneralDot1x();					
				if(dot1xSystem === 1){
				   $scope.aaa.general.dot1x=translate("com_enable");
                   
				}else{
					$scope.aaa.general.dot1x= translate("com_disable");
				}
				$scope.olddot1x=$scope.aaa.general.dot1x;
				//Local Authentication and localAuthorization value setting here
				var aaaGeneralDetails=aaaService.getAAAGeneral();
				$timeout(function(){
					$scope.aaa.general.localAuthentication = $scope.aaaGeneralService.authentication;
					$scope.aaa.general.localAuthorization = $scope.aaaGeneralService.authorization;
				},1000);
				//LeastOutstanding value setting here
				var leastOutstanding=aaaService.getAAAGeneralLeastOutstanding();
				if(leastOutstanding === 1){
				   $scope.aaa.general.leastOutstanding=translate("com_enable");
				}else{
					$scope.aaa.general.leastOutstanding= translate("com_disable");
				}
				$scope.oldLeastValue=$scope.aaa.general.leastOutstanding;
			}
			this.serverGroupRadius = function(){
				$scope.serverGroupRadiusData = new kendo.data.ObservableArray([]);
				var radiusServerGroupData = aaaService.getAAAServerGroupRadius();
				if(!angular.isUndefined(radiusServerGroupData)){
					for(var i = 0; i < radiusServerGroupData.length; i++){
						if(!radiusServerGroupData[i].hasOwnProperty('list')){
							radiusServerGroupData[i].list = [];
						}
						$scope.serverGroupRadiusData.push(radiusServerGroupData[i]);
					}
				}
				$scope.radiusGroupGridDataSource = new kendo.data.DataSource({
					pageSize : 10,
					data : $scope.serverGroupRadiusData
				});
			};
	        this.moveItemsBetweenLists = function(fromList, toList, itemsToMove) {
				if ( typeof itemsToMove != "undefined") {
					while (itemsToMove.length > 0) {
						var item = itemsToMove.pop();
						toList.push(item);
						var index = fromList.indexOf(item);
						if (index != -1) {
							fromList.splice(index, 1);
						}
					}
				}
			};
            this.serverGroupTacacs = function(){
				$scope.serverGroupTacacsData = new kendo.data.ObservableArray([]);
				var tacacsServerGroupData = aaaService.getAAAServerGroupTacacs();
				if(!angular.isUndefined(tacacsServerGroupData)){
					for(var i = 0; i < tacacsServerGroupData.length; i++){
						if(!tacacsServerGroupData[i].hasOwnProperty('list')){
							tacacsServerGroupData[i].list = [];
						}
						$scope.serverGroupTacacsData.push(tacacsServerGroupData[i]);
					}
				}
				$scope.tacacsGroupGridDataSource = new kendo.data.DataSource({
					pageSize : 10,
					data : $scope.serverGroupTacacsData
				});
			};
			this.loadserverLdap = function(){
				$scope.ldapServerGridData = new kendo.data.ObservableArray([]);
				var serverLdapData = aaaService.serverldaploaddata();
				if(!angular.isUndefined(serverLdapData)){
					for(var i = 0; i < serverLdapData.length; i++){
						if(serverLdapData[i].ldapServerBindUserName == undefined){
							serverLdapData[i].ldapServerSimpleBind = translate('aaa_server_ldap_anony');
						}else{
							serverLdapData[i].ldapServerSimpleBind = translate('aaa_server_ldap_auth');
						}
						$scope.ldapServerGridData.push(serverLdapData[i]);
					}
				}
				$scope.ldapServerGridDataSource = new kendo.data.DataSource({
					pageSize : 20,
					data : $scope.ldapServerGridData
				});
			};
			this.serverGroupLdap = function(){
				$scope.ldapServerGroupGridData = new kendo.data.ObservableArray([]);
				var ldapServerGroupData = aaaService.getAAAServerGroupLdap();

				if(!angular.isUndefined(ldapServerGroupData)){
					for(var i = 0; i < ldapServerGroupData.length; i++){
						if(!ldapServerGroupData[i].hasOwnProperty('list')){
							ldapServerGroupData[i].list = [];
						}
						$scope.ldapServerGroupGridData.push(ldapServerGroupData[i]);

					}
				}
				$scope.ldapServerGroupGridDataSource = new kendo.data.DataSource({
					pageSize : 10,
					data : $scope.ldapServerGroupGridData

				});
			};
			this.loadMethodListAccount = function(){
				$scope.accountGridData = new kendo.data.ObservableArray([]);
				var methodAccountData = aaaService.methodlistAccountloaddata();
				if(!angular.isUndefined(methodAccountData)){
					for(var i = 0; i < methodAccountData.length; i++){
						$scope.accountGridData.push(methodAccountData[i]);
					}
				}
				$scope.accountGridDataSource = new kendo.data.DataSource({
					pageSize : 20,
					data : $scope.accountGridData
				});
			};
		}
		var AAA = new $scope.AAA();
		/************************************AAA Method List Authentication Starts Here***********************************/
		AAA.methodListAuthentication();
		$scope.addAuthenticationRow = function(){
			$scope.hideQuickSetupAuthentication = false;
			$scope.disableAuthenticationName = false;
			$scope.loadAvailServerGrpAuthMethodListOptions();
			$scope.authSelectedServerGroupOptions = [];
			$scope.aaa.methodList.auth = {};
			$scope.aaa.methodList.auth.type = $scope.authTypeOptions.options.data[0].authTypeName;
			$scope.aaa.methodList.auth.grouptype = $scope.groupTypeOptions.options.data[0].groupTypeName;
			angular.element("#authenticationForm  span.k-tooltip-validation").hide();
		};
		$scope.saveAuthentication = function(){
			var tempAuthSelectedArray = [];
			if($scope.disableAuthenticationName == false){
				for(var authSel = 0; authSel < $scope.authSelectedServerGroupOptions.length; authSel++){
					tempAuthSelectedArray.push($scope.authSelectedServerGroupOptions[authSel]);
				}
				$scope.aaa.methodList.auth.group = tempAuthSelectedArray;
				$scope.aaa.methodList.auth.created = true;
				$scope.methodlistAuthData.push($scope.aaa.methodList.auth);
				$scope.disableApplyButton = false;
			}else{
				var selAuthRow = $scope.methodlistAuthData.map(function(e) {
					return e.listname;
				}).indexOf($scope.selectedAuthenticationName);
				$scope.methodlistAuthData[selAuthRow].group = [];
				$scope.methodlistAuthData[selAuthRow].listname = $scope.aaa.methodList.auth.listname;
				$scope.methodlistAuthData[selAuthRow].grouptype = $scope.aaa.methodList.auth.grouptype;
				$scope.methodlistAuthData[selAuthRow].type = $scope.aaa.methodList.auth.type;
				if($scope.methodlistAuthData[selAuthRow].hasOwnProperty('fallback')){
					$scope.methodlistAuthData[selAuthRow].fallback = $scope.aaa.methodList.auth.fallback;
				}
				$scope.methodlistAuthData[selAuthRow].dirty = true;
				for (var i = 0; i < $scope.authSelectedServerGroupOptions.length; i++) {
					$scope.methodlistAuthData[selAuthRow].group[i] = $scope.authSelectedServerGroupOptions[i];
				}
			}
			$scope.aaaAuthenticationGrid.refresh();
			$scope.cancelAuthentication();
			$scope.disableApplyButton = false;
		};
		$scope.cancelAuthentication = function(){
			$scope.aaa.methodList.auth = {};
			$scope.hideQuickSetupAuthentication = true;
		}
		$scope.delAuthenticationRow = function(){
			$scope.deleteFromArray('Authentication');
			$scope.deleteAuthentication = true;
			$scope.hideQuickSetupAuthentication = true;
		}
		$scope.loadAvailServerGrpAuthMethodListOptions = function(){
			$scope.availableAuthMethodListOptions = [];
			var authRadiusServerGroupData = aaaService.getAAAServerGroupRadius();
			if(!angular.isUndefined(authRadiusServerGroupData)){
				for(var i = 0; i < authRadiusServerGroupData.length; i++){
					$scope.availableAuthMethodListOptions.push(authRadiusServerGroupData[i].name);
				}
			}
			if (!$scope.$$phase){
				$scope.$apply();
			}
		};
		$scope.moveToAAAServerGroup = function() {
			AAA.moveItemsBetweenLists($scope.availableAuthMethodListOptions, $scope.authSelectedServerGroupOptions, $scope.aaa.methodList.auth.groupMethods);
		};
		$scope.moveFromAAAServerGroup = function() {
			AAA.moveItemsBetweenLists($scope.authSelectedServerGroupOptions, $scope.availableAuthMethodListOptions, $scope.aaa.methodList.auth.list);
		};
		/************************************AAA Method List Authentication Starts Here***********************************/
		/************************************AAA Method List Authorization Starts Here***********************************/
		AAA.methodListAuthorization();
		$scope.addAuthorizationRow = function(){
			$scope.hideQuickSetupAuthorization = false;
			$scope.disableAuthorizationName = false;
			$scope.aaa.methodList.author = {};
			$scope.loadAvailServerGrpMethodListOptions("availableAuthorMethodListOptions", aaaService.getAAAServerGroupRadius);
			$scope.authorSelectedServerGroupOptions = [];
			$scope.aaa.methodList.author.type = $scope.authorTypeOptions.options.data[0].authorTypeValue;
			$scope.aaa.methodList.author.grouptype = $scope.groupTypeOptions.options.data[0].groupTypeName;
			angular.element("#authorizationForm  span.k-tooltip-validation").hide();
		};
		$scope.saveAuthorization = function(){
			tempAuthorSelectedArray = [];
			if($scope.disableAuthorizationName == false){
				for(var authorSel = 0; authorSel < $scope.authorSelectedServerGroupOptions.length; authorSel++){
					tempAuthorSelectedArray.push($scope.authorSelectedServerGroupOptions[authorSel]);
				}
				$scope.aaa.methodList.author.group = tempAuthorSelectedArray;
				$scope.aaa.methodList.author.created = true;
				$scope.methodlistAuthorData.push($scope.aaa.methodList.author);
				$scope.disableApplyButton = false;
			}else{
				var selAuthorRow = $scope.methodlistAuthorData.map(function(e) {
					return e.listname;
				}).indexOf($scope.selectedAuthorizationName);
				$scope.methodlistAuthorData[selAuthorRow].group = [];
				$scope.methodlistAuthorData[selAuthorRow].listname = $scope.aaa.methodList.author.listname;
				$scope.methodlistAuthorData[selAuthorRow].grouptype = $scope.aaa.methodList.author.grouptype;
				$scope.methodlistAuthorData[selAuthorRow].type = $scope.aaa.methodList.author.type;
				if($scope.methodlistAuthorData[selAuthorRow].hasOwnProperty('fallback')){
					$scope.methodlistAuthorData[selAuthorRow].fallback = $scope.aaa.methodList.author.fallback;
				}
				$scope.methodlistAuthorData[selAuthorRow].dirty = true;
				for (var i = 0; i < $scope.authorSelectedServerGroupOptions.length; i++) {
					$scope.methodlistAuthorData[selAuthorRow].group[i] = $scope.authorSelectedServerGroupOptions[i];
				}
			}
			$scope.aaaAuthorizationGrid.refresh();
			$scope.cancelAutorization();
			$scope.disableApplyButton = false;
		};
		$scope.cancelAuthorization = function(){
			$scope.aaa.methodList.author = {};
			$scope.hideQuickSetupAuthorization = true;
		};
		$scope.delAuthorizationRow = function(){
			$scope.deleteFromArray('Authorization');
			$scope.deleteAuthorization = true;
			$scope.hideQuickSetupAuthorization = true;
		}
		$scope.loadAvailServerGrpMethodListOptions = function(methodListOptions, serviceFunction){
			$scope[methodListOptions] = [];
			var authorRadiusServerGroupData = serviceFunction();
			if(!angular.isUndefined(authorRadiusServerGroupData)){
				for(var i = 0; i < authorRadiusServerGroupData.length; i++){
					$scope[methodListOptions].push(authorRadiusServerGroupData[i].name);
				}
			}
			if (!$scope.$$phase){
				$scope.$apply();
			}
		};
		$scope.moveToAAAAuthorServerGroup = function() {
			AAA.moveItemsBetweenLists($scope.availableAuthorMethodListOptions, $scope.authorSelectedServerGroupOptions, $scope.aaa.methodList.author.groupMethods);
		};
		$scope.moveFromAAAAuthorServerGroup = function() {
			AAA.moveItemsBetweenLists($scope.authorSelectedServerGroupOptions, $scope.availableAuthorMethodListOptions, $scope.aaa.methodList.author.list);
		};
		$scope.cancelAutorization = function(){
			$scope.aaa.methodList.author = {};
			$scope.hideQuickSetupAuthorization = true;
		}
		/************************************AAA Method List Authorization Ends Here***********************************/
		/************************************AAA Server Group Starts Here***********************************/
		AAA.serverGroupRadius();
		AAA.serverGroupTacacs();
		AAA.serverGroupLdap();
		$scope.serverGroupAccordian = function(SRadius, STacacs){
			$scope.hideQuickSetupRadiusServersGroup = true;
			$scope.aaaRadiusGroupGrid.refresh();
			if(SRadius){
				$scope.availableRadiusGroupOptions = [];
				var radiusServerGroupData = aaaService.getAAARadiusServer();
				if(!angular.isUndefined(radiusServerGroupData)){
					for(var i = 0; i < radiusServerGroupData.length; i++){
						$scope.availableRadiusGroupOptions.push(radiusServerGroupData[i].name);
					}
				}
			}
			if (!$scope.$$phase){
				$scope.$apply();
			}
		}
		// Server Group Radius
		$scope.moveToAAARadiusGroup = function() {
			AAA.moveItemsBetweenLists($scope.availableRadiusGroupOptions, $scope.radiusSelectedServerGroupOptions, $scope.aaa.serverGroup.radius.radiusGroup);
		};
		$scope.moveFromAAARadiusGroup = function() {
			AAA.moveItemsBetweenLists($scope.radiusSelectedServerGroupOptions, $scope.availableRadiusGroupOptions, $scope.aaa.serverGroup.radius.selectedlist);
		};
		$scope.addRadiusGroupRow = function(){
			$scope.serverGroupAccordian(true,false);
			$scope.deleteRadiusServersGroup = true;
			$scope.aaa.serverGroup.radius = {};
			$scope.aaa.serverGroup.radius.macdelimiter = "none",
			$scope.aaa.serverGroup.radius.securitymode = "none",
			$scope.radiusSelectedServerGroupOptions = [];
			$scope.hideQuickSetupRadiusServersGroup = false;
			$scope.disableRadiusServersGroupName = false;
			angular.element("#radiusGroupForm  span.k-tooltip-validation").hide();
		}
		$scope.cancelRadiusServersGroup = function(){
			$scope.aaa.serverGroup.radius = {};
			$scope.hideQuickSetupRadiusServersGroup = true;
		}
		$scope.delRadiusGroupRow = function() {
			$scope.deleteFromArray('RadiusServerGroup');
			$scope.deleteRadiusServersGroup = true;
			$scope.hideQuickSetupRadiusServersGroup = true;
		};
		$scope.saveRadiusServerGroup = function(){
			var tempRadiusGroupSelectedArray = [], tempRadiusGroupSelectedObj;
			if($scope.disableRadiusServersGroupName == false){
				for(var radSel = 0; radSel < $scope.radiusSelectedServerGroupOptions.length; radSel++){
					tempRadiusGroupSelectedObj = {};
					tempRadiusGroupSelectedObj['list'] = $scope.radiusSelectedServerGroupOptions[radSel];
					tempRadiusGroupSelectedArray.push(tempRadiusGroupSelectedObj);
				}
				$scope.aaa.serverGroup.radius.list = tempRadiusGroupSelectedArray;
				$scope.aaa.serverGroup.radius.created = true;
				$scope.serverGroupRadiusData.push($scope.aaa.serverGroup.radius);
				$scope.hideQuickSetupRadiusServersGroup = true;
				$scope.disableApplyButton = false;
			}else{
				var selServerGrpRow = $scope.serverGroupRadiusData.map(function(e) {
					return e.name;
				}).indexOf($scope.selectedServerGroupRadiusName);
				$scope.serverGroupRadiusData[selServerGrpRow].macdelimiter = $scope.aaa.serverGroup.radius.macdelimiter == undefined ? 'none' : $scope.aaa.serverGroup.radius.macdelimiter;
				$scope.serverGroupRadiusData[selServerGrpRow].securitymode = $scope.aaa.serverGroup.radius.securitymode == undefined ? 'none' : $scope.aaa.serverGroup.radius.securitymode;
				$scope.serverGroupRadiusData[selServerGrpRow].deadtime = $scope.aaa.serverGroup.radius.deadtime;
				$scope.serverGroupRadiusData[selServerGrpRow].list = [];
				$scope.serverGroupRadiusData[selServerGrpRow].server = [];
				$scope.serverGroupRadiusData[selServerGrpRow].dirty = true;
				for (var i = 0; i < $scope.radiusSelectedServerGroupOptions.length; i++) {
					tempRadiusGroupSelectedObj = {};
					tempRadiusGroupSelectedObj['list'] = $scope.radiusSelectedServerGroupOptions[i];
					$scope.serverGroupRadiusData[selServerGrpRow].list[i] = tempRadiusGroupSelectedObj;
				}
				$scope.aaaRadiusGroupGrid.refresh();
				$scope.hideQuickSetupRadiusServersGroup = true;
				$scope.disableApplyButton = false;
			}
			$scope.cancelRadiusServersGroup();
		}
		//       Server group tacacs starts here
		$scope.serverGroupTacacsAccordian = function(SRadius, STacacs){
			$scope.hideQuickSetupTacacsServersGroup = true;
			$scope.aaaServerGroupTacacsGrid.refresh();
			if(SRadius){
				$scope.availableTacacsGroupOptions = [];
				var tacacsServerGroupData = aaaService.getAAARadiusTacacs();
				if(!angular.isUndefined(tacacsServerGroupData)){
					for(var i = 0; i < tacacsServerGroupData.length; i++){
						$scope.availableTacacsGroupOptions.push(tacacsServerGroupData[i].name);
					}
				}
			}
			if (!$scope.$$phase){
				$scope.$apply();
			}
		}
		$scope.moveToAAATacacsGroup = function() {
			AAA.moveItemsBetweenLists($scope.availableTacacsGroupOptions, $scope.tacacsSelectedServerGroupOptions, $scope.aaa.serverGroup.tacacs.tacacsGroup);
		};
		$scope.moveFromAAATacacsGroup = function() {
			AAA.moveItemsBetweenLists($scope.tacacsSelectedServerGroupOptions, $scope.availableTacacsGroupOptions, $scope.aaa.serverGroup.tacacs.selectedlist);
		};
		$scope.addServerGroupTacacsRow = function(){
			$scope.serverGroupTacacsAccordian(true, false);
			$scope.disableTacacsServersGroupName = false;
			$scope.ServerGroupTacacsDelBtn = true;
			$scope.aaa.serverGroup.tacacs={};
			$scope.tacacsSelectedServerGroupOptions = [];
			$scope.hideQuickSetupTacacsServersGroup = false;
			angular.element("#tacacsGroupForm").kendoValidator().data("kendoValidator").hideMessages();
		};
		$scope.cancelTacacsServersGroup = function(){
			$scope.aaa.serverGroup.tacacs = {};
			$scope.hideQuickSetupTacacsServersGroup = true;
		};
		$scope.delServerGroupTacacsRow = function() {
			$scope.deleteFromArray('TacacsServerGroup');
			$scope.ServerGroupTacacsDelBtn = true;
			$scope.hideQuickSetupTacacsServersGroup = true;
		};
		$scope.saveTacacsServerGroup = function(){
			var tempTacacsGroupSelectedArray = [], tempTacacsGroupSelectedObj;
			if($scope.disableTacacsServersGroupName == false){
				for(var radSel = 0; radSel < $scope.tacacsSelectedServerGroupOptions.length; radSel++){
					tempTacacsGroupSelectedObj = {};
					tempTacacsGroupSelectedObj['list'] = $scope.tacacsSelectedServerGroupOptions[radSel];
					tempTacacsGroupSelectedArray.push(tempTacacsGroupSelectedObj);
				}
				$scope.aaa.serverGroup.tacacs.list = tempTacacsGroupSelectedArray;
				$scope.aaa.serverGroup.tacacs.created = true;
				$scope.serverGroupTacacsData.push($scope.aaa.serverGroup.tacacs);
				$scope.hideQuickSetupTacacsServersGroup = true;
				$scope.disableApplyButton = false;
			}else{
				var selectServerGrpRow = $scope.serverGroupTacacsData.map(function(e) {
					return e.name;
				}).indexOf($scope.selectedServerGroupTacacsName);
			    $scope.serverGroupTacacsData[selectServerGrpRow].list = [];
			    $scope.serverGroupTacacsData[selectServerGrpRow].server = [];
			    $scope.serverGroupTacacsData[selectServerGrpRow].dirty = true;
				for (var i = 0; i < $scope.tacacsSelectedServerGroupOptions.length; i++) {
					tempTacacsGroupSelectedObj = {};
					tempTacacsGroupSelectedObj['list'] = $scope.tacacsSelectedServerGroupOptions[i];
					$scope.serverGroupTacacsData[selectServerGrpRow].list[i] = tempTacacsGroupSelectedObj;
				}
				$scope.aaaServerGroupTacacsGrid.refresh();
				$scope.hideQuickSetupTacacsServersGroup = true;
				$scope.disableApplyButton = false;
			}
			$scope.cancelTacacsServersGroup();
					
		}
// LDAP===============================
		$scope.serverGroupLdapAccordian = function(TLdap, FLdap){
			$scope.hideQuickSetupLdapServerGrp = true;
			$scope.ldapGroupGrid.refresh();
			if(TLdap){
				$scope.availableLdapGroupOptions = [];
				var ldapServerGroupData = aaaService.serverldaploaddata();
				if(!angular.isUndefined(ldapServerGroupData)){
					for(var i = 0; i < ldapServerGroupData.length; i++){
						$scope.availableLdapGroupOptions.push(ldapServerGroupData[i].ldapServerName);
					}
				}
			}
			if (!$scope.$$phase){
				$scope.$apply();
			}
		}
$scope.moveToAAALdapGroup = function() {
			AAA.moveItemsBetweenLists($scope.availableLdapGroupOptions, $scope.ldapSelectedServerGroupOptions, $scope.aaa.serverGroup.ldap.ldapGroup);
		};
		$scope.moveFromAAALdapGroup = function() {
			AAA.moveItemsBetweenLists($scope.ldapSelectedServerGroupOptions, $scope.availableLdapGroupOptions, $scope.aaa.serverGroup.ldap.selectedlist);
		}; 
		$scope.addLdapServerGroup = function(){
			$scope.serverGroupLdapAccordian(true, false);
			$scope.disableLdapServersGroupName = false;
			$scope.deleteLdapServer = true;
			$scope.aaa.serverGroup.ldap={};
			$scope.ldapSelectedServerGroupOptions = [];
			$scope.hideQuickSetupLdapServerGrp = false;
			angular.element("#ldapServerGroupForm").kendoValidator().data("kendoValidator").hideMessages();
		};
		$scope.cancelLdap = function(){
			$scope.aaa.serverGroup.ldap = {};
			$scope.hideQuickSetupLdapServerGrp = true;
		};
		$scope.deleteLdapGroup = function() {
			$scope.deleteFromArray('LdapServerGroup');
			$scope.deleteLdapServer = true;
			$scope.hideQuickSetupLdapServerGrp = true;
		};
		$scope.saveLdapGroup = function(){
			var tempLdapGroupSelectedArray = [], tempLdapGroupSelectedObj;
			if($scope.disableLdapServersGroupName == false){
				for(var radSel = 0; radSel < $scope.ldapSelectedServerGroupOptions.length; radSel++){
					tempLdapGroupSelectedObj = {};
					tempLdapGroupSelectedObj['list'] = $scope.ldapSelectedServerGroupOptions[radSel];
					tempLdapGroupSelectedArray.push(tempLdapGroupSelectedObj);
				}
				$scope.aaa.serverGroup.ldap.list = tempLdapGroupSelectedArray;
				$scope.aaa.serverGroup.ldap.created = true;
				$scope.ldapServerGroupGridData.push($scope.aaa.serverGroup.ldap);
				$scope.hideQuickSetupLdapServerGrp = true;
				$scope.disableApplyButton = false;
			}else{
				var selectServerGrpRow = $scope.ldapServerGroupGridData.map(function(e) {
					return e.name;
				}).indexOf($scope.selectedServerGroupLdapName);
			    $scope.ldapServerGroupGridData[selectServerGrpRow].list = [];
			    $scope.ldapServerGroupGridData[selectServerGrpRow].server = [];
			    $scope.ldapServerGroupGridData[selectServerGrpRow].dirty = true;
				for (var i = 0; i < $scope.ldapSelectedServerGroupOptions.length; i++) {
					tempLdapGroupSelectedObj = {};
					tempLdapGroupSelectedObj['list'] = $scope.ldapSelectedServerGroupOptions[i];
					$scope.ldapServerGroupGridData[selectServerGrpRow].list[i] = tempLdapGroupSelectedObj;
				}
				$scope.ldapGroupGrid.refresh();
				$scope.hideQuickSetupLdapServerGrp = true;
				$scope.disableApplyButton = false;
			}
			$scope.cancelLdap();
			
		}
		// LDAP Ends==========================
		/***********************************AAA Server Group Ends Here***********************************/
		/*AAA Server Starts Here*/
		//Server RADIUS Initial Function
		AAA.serverRadiusInit();
		//calling Fall back value set function
		AAA.aaaRadiusFallBack();
		//calling AAA general function
		AAA.aaaGeneral();
		$scope.addServerRadiusRow = function(){
			$scope.deleteRadiusServers = true;
			angular.element("#radiusServersForm  span.k-tooltip-validation").hide();
			$scope.aaa.servers.radius = {};
			$scope.aaa.servers.radius.authport = "1812";
			$scope.aaa.servers.radius.acctport = "1813";
			$scope.disableRadiusServersName = false;
			$scope.hideQuickSetupRadiusServers = false;
		}
		$scope.cancelRadiusServers = function(){
			$scope.disableRadiusServersName = true;
			$scope.hideQuickSetupRadiusServers = true;	
		}
		$scope.isChecked = function(checked, dataItem, grid){
			if (!grid || grid == '') {
				return;
			}
			if (checked == false) {
                var index = $scope.selectedArrayObject["selected" + grid + "Array"].indexOf(dataItem);
                if (index > -1) {
                    $scope.selectedArrayObject["selected" + grid + "Array"].splice(index, 1);
                }
            } else {
                $scope.selectedArrayObject["selected" + grid + "Array"].push(dataItem);
            }
            $scope.deleteAuthentication = ($scope.selectedArrayObject["selectedAuthenticationArray"].length == 0);
			$scope.deleteAccount = ($scope.selectedArrayObject["selectedAccountArray"].length == 0);
			$scope.deleteAuthorization = ($scope.selectedArrayObject["selectedAuthorizationArray"].length == 0);
			$scope.deleteAccount = ($scope.selectedArrayObject["selectedAccountingArray"].length == 0);
			$scope.deleteRadiusServersGroup = ($scope.selectedArrayObject["selectedRadiusServerGroupArray"].length == 0);
			$scope.ServerGroupTacacsDelBtn = ($scope.selectedArrayObject["selectedTacacsServerGroupArray"].length == 0);
			$scope.deleteLdapServer = ($scope.selectedArrayObject["selectedLdapServerGroupArray"].length == 0);
			$scope.deleteRadiusServers = ($scope.selectedArrayObject["selectedRadiusServerArray"].length == 0);
			$scope.deleteTacacsServers = ($scope.selectedArrayObject["selectedtacacsServerArray"].length == 0);
			$scope.enableDeleteButton = ($scope.selectedArrayObject["selectedldapServerArray"].length == 0);
			$scope.deleteAdvUser = ($scope.selectedArrayObject["selectedUsersArray"].length == 0);
			$scope.deleteAttr = ($scope.selectedArrayObject["selectedattributeListArray"].length == 0);
			$scope.deleteMacFilt = ($scope.selectedArrayObject["selectedmacFilterArray"].length == 0);
		}
		// Server RADIUS SAVE
		$scope.saveRadiusServers = function(){
			if($scope.disableRadiusServersName == false){
				$scope.aaa.servers.radius.created = true;
				$scope.serverRadiusGridData.push($scope.aaa.servers.radius);
				$scope.hideQuickSetupRadiusServers = true;
				$scope.disableApplyButton = false;
			}else{
				var selectedRow = $scope.serverRadiusGridData.map(function(e) {
					return e.name;
				}).indexOf($scope.selectedServerRadiusName);
				$scope.serverRadiusGridData[selectedRow].dirty = true;
				$scope.serverRadiusGridData[selectedRow].address = $scope.aaa.servers.radius.address;
				$scope.serverRadiusGridData[selectedRow].authport = $scope.aaa.servers.radius.authport;
				$scope.serverRadiusGridData[selectedRow].acctport = $scope.aaa.servers.radius.acctport;
				$scope.serverRadiusGridData[selectedRow].password = $scope.aaa.servers.radius.password;
				$scope.serverRadiusGridData[selectedRow].confirmPassword = $scope.aaa.servers.radius.confirmPassword;
				$scope.serverRadiusGridData[selectedRow].retry = $scope.aaa.servers.radius.retry;
				$scope.serverRadiusGridData[selectedRow].rfc = $scope.aaa.servers.radius.rfc;
				$scope.serverRadiusGridData[selectedRow].timeout = $scope.aaa.servers.radius.timeout;
				$scope.hideQuickSetupRadiusServers = true;
				$scope.disableApplyButton = false;
			}
		}
		$scope.delServerRadiusRow = function(){
			$scope.deleteFromArray('RadiusServer');
			$scope.deleteRadiusServers = true;
			$scope.deleteRadiusServer = true;
			$scope.hideQuickSetupRadiusServers = true;
		}
		/*AAA Server Ends Here*/

		/*AAA TACACS+ Starts Here*/
		//Server TACACS+ Initial Function
		AAA.serverTacacsInit();
		//Server TACACS+ SAVE
		$scope.addServerTacacsRow = function(){
			$scope.deleteTacacsServers = true;
			$scope.aaa.servers.tacacs = "";
			$scope.disableTacacsServersName = false;
			$scope.hideQuickSetupTacacsServers = false;
		}
		$scope.cancelTacacsServers = function(){
			$scope.disableTacacsServersName = true;
			$scope.hideQuickSetupTacacsServers = true;	
		}
		$scope.saveTacacsServersRow = function(){
			if($scope.disableTacacsServersName == false){
				$scope.aaa.servers.tacacs.created = true;
				$scope.serverTacacsGridData.push($scope.aaa.servers.tacacs);
				$scope.hideQuickSetupTacacsServers = true;
				$scope.disableApplyButton = false;
			}else{
				var selectedTacacsRow = $scope.serverTacacsGridData.map(function(e) {
					return e.name;
				}).indexOf($scope.selectedServerTacacsName);
				$scope.serverTacacsGridData[selectedTacacsRow].dirty = true;
				$scope.serverTacacsGridData[selectedTacacsRow].address = $scope.aaa.servers.tacacs.address;
				$scope.serverTacacsGridData[selectedTacacsRow].port = $scope.aaa.servers.tacacs.port;
				$scope.serverTacacsGridData[selectedTacacsRow].password = $scope.aaa.servers.tacacs.password;
				$scope.serverTacacsGridData[selectedTacacsRow].confirmPassword = $scope.aaa.servers.tacacs.confirmPassword;
				$scope.serverTacacsGridData[selectedTacacsRow].timeout = $scope.aaa.servers.tacacs.timeout;
				$scope.hideQuickSetupTacacsServers = true;
				$scope.disableApplyButton = false;
			}
		}
		$scope.delServerTacacsRow = function(){
			$scope.deleteFromArray('tacacsServer');
			$scope.deleteTacacsServers = true;
			$scope.hideQuickSetupTacacsServers = true;
		}
		/*AAA TACACS+ Ends Here*/
		$scope.deleteFromArray = function(grid){
			$scope.deleted = {
				methodListAuth:[],
				methodListAuthor:[],
				tacacsServers: [],
				radiusServers: [],
				radiusGroup: [],
				tacacsGroup: [],
				ldapGroup: [],
				ldapServers: [],
				Accounting : []
			};
			for (var index in $scope.selectedArrayObject["selected" + grid + "Array"]) {
				switch (grid) {
					case 'Authentication':
					$scope.aaaAuthenticationGrid.dataSource.remove($scope.selectedArrayObject["selected" + grid + "Array"][index]);
					$scope.deleted.methodListAuth.push($scope.selectedArrayObject["selected" + grid + "Array"][index]);
					break;
					case 'Authorization':
					$scope.aaaAuthorizationGrid.dataSource.remove($scope.selectedArrayObject["selected" + grid + "Array"][index]);
					$scope.deleted.methodListAuthor.push($scope.selectedArrayObject["selected" + grid + "Array"][index]);
					break;
					case 'RadiusServerGroup':
					$scope.aaaRadiusGroupGrid.dataSource.remove($scope.selectedArrayObject["selected" + grid + "Array"][index]);
					$scope.deleted.radiusGroup.push($scope.selectedArrayObject["selected" + grid + "Array"][index].name);
					break;
					case 'RadiusServer':
					$scope.aaaServerRadiusGrid.dataSource.remove($scope.selectedArrayObject["selected" + grid + "Array"][index]);
					$scope.deleted.radiusServers.push(
						{
							name:$scope.selectedArrayObject["selected" + grid + "Array"][index].name,
							address:$scope.selectedArrayObject["selected" + grid + "Array"][index].address
						}
					);
					break;
					case 'tacacsServer':
					$scope.aaaServerTacacsGrid.dataSource.remove($scope.selectedArrayObject["selected" + grid + "Array"][index]);
					$scope.deleted.tacacsServers.push(
						{
							name:$scope.selectedArrayObject["selected" + grid + "Array"][index].name
						}
					);
                     break;
					case 'TacacsServerGroup':
					$scope.aaaServerGroupTacacsGrid.dataSource.remove($scope.selectedArrayObject["selected" + grid + "Array"][index]);
					$scope.deleted.tacacsGroup.push($scope.selectedArrayObject["selected" + grid + "Array"][index].name);
					case 'ldapServer':
						$scope.ldapServerGrid.dataSource.remove($scope.selectedArrayObject["selected" + grid + "Array"][index]);
						if ($scope.deleted.ldapServers.indexOf($scope.selectedArrayObject["selected" + grid + "Array"][index].ldapServerName) == -1) {
							$scope.deleted.ldapServers.push($scope.selectedArrayObject["selected" + grid + "Array"][index].ldapServerName);
						}
					break;
					case 'LdapServerGroup':
					$scope.ldapGroupGrid.dataSource.remove($scope.selectedArrayObject["selected" + grid + "Array"][index]);
					$scope.deleted.ldapGroup.push($scope.selectedArrayObject["selected" + grid + "Array"][index].name);
					case 'Accounting' :

					$scope.accountGrid.dataSource.remove($scope.selectedArrayObject["selected" + grid + "Array"][index]);
					if ($scope.deleted.Accounting == undefined) {
						$scope.deleted.Accounting = [];
					}
					$scope.deleted.Accounting.push($scope.selectedArrayObject["selected" + grid + "Array"][index]);
				}
			}
		}
		
		
		/* AAA method list accounting start here*/
		
		AAA.loadMethodListAccount();
		
		$scope.accountGridOptions = {
			editable : false,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
						neq : translate("com_isnot_equal")
					}
				},
				messages : {
					info: translate("com_page_dropDowntext"),
					filter: translate("com_btn_filter"),
					clear: translate("com_btn_clear")
				}
			},
			pageable : {
				messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			scrollable : false,
			sortable : true,
			selectable : true,
			columns : [{
				"template" : "<input type=\"checkbox\" ng-init=\"checked=false\" ng-model=\"checked\" ng-click=\"isChecked(checked,dataItem,'Accounting')\"  />",
				sortable : false
			}, {
				field : "name",
				title : translate("com_name")
			}, {
				field : "type",
				title : translate("management_snmp_host_type")
			}, {
				field : "list1",
				title : translate("aaa_group1"),
				template : "#=(group[0]==undefined?'N/A':group[0])#"
			}, {
				field : "list2",
				title : translate("aaa_group2"),
				template : "#=(group[1]==undefined?'N/A':group[1])#"
			}, {
				field : "list3",
				title : translate("aaa_group3"),
				template : "#=(group[2]==undefined?'N/A':group[2])#"
			}, {
				field : "list4",
				title : translate("aaa_group4"),
				template : "#=(group[3]==undefined?'N/A':group[3])#"
			}]
		};
		
		$scope.hideQuickSetupAccounting = true;
		
		$scope.aaaMethodAccountAccord = function(SRadius, STacacs){
			$scope.hideQuickSetupTacacsServersGroup = true;
			$scope.aaaServerGroupTacacsGrid.refresh();
			if(SRadius){
				$scope.availableAccountMethodListOptions = [];
				var AccountMethodListData = aaaService.serverldaploaddata();
				if(!angular.isUndefined(AccountMethodListData)){
					for(var i = 0; i < AccountMethodListData.length; i++){
						$scope.availableAccountMethodListOptions.push(AccountMethodListData[i].ldapServerName);
					}
				}
			}
			if (!$scope.$$phase){
				$scope.$apply();
			}
		}
		
		$scope.moveToAccountServerGroup = function() {
			AAA.moveItemsBetweenLists($scope.availableAccountMethodListOptions, $scope.accountSelectedServerGroupOptions, $scope.aaa.methodList.account.groupMethods);
		};

		$scope.moveFromAccountServerGroup = function() {
			AAA.moveItemsBetweenLists($scope.accountSelectedServerGroupOptions, $scope.availableAccountMethodListOptions, $scope.aaa.methodList.account.list);
		};
	
		$scope.addNewAccounting = function() {
			$scope.aaaMethodAccountAccord(true,false);
			$scope.deleteAccount = true;
			$scope.hideQuickSetupAccounting = false;
			$scope.aaa.methodList.account = {};
			$scope.disableAccountName = false;
			$scope.accountSelectedServerGroupOptions = [];
			angular.element("#accountingForm  span.k-tooltip-validation").hide();
		};
		
		$scope.deleteAccounting = function() {
			$scope.deleteFromArray('Accounting');
			$scope.deleteAccount = true;
			$scope.hideQuickSetupAccounting = true;
		};
		
		$scope.doneAccount = function() {
			var tempAccSelectedArray = [];
			if ($scope.accountValidator.validate()) {
				if ($scope.disableAccountName == false) {
					for(var accSel = 0; accSel < $scope.accountSelectedServerGroupOptions.length; accSel++){
						tempAccSelectedArray.push($scope.accountSelectedServerGroupOptions[accSel]);
					}
					if(!$scope.aaa.methodList.account.hasOwnProperty("type")){
						$scope.aaa.methodList.account.type = $scope.accountType.options.data[0].accountTypeName;
					}
					$scope.aaa.methodList.account.group = tempAccSelectedArray;
					$scope.aaa.methodList.account.created = true;
					$scope.accountGridData.push($scope.aaa.methodList.account);
				} else {
					var selectedRow = $scope.accountGridData.map(function(e) {
						return e.name;
					}).indexOf($scope.selectedAccountnName);
					$scope.accountGridData[selectedRow].group = [];
					$scope.accountGridData[selectedRow].level = $scope.aaa.methodList.account.level;
					$scope.accountGridData[selectedRow].type = $scope.aaa.methodList.account.type;
					for (var i = 0; i < $scope.accountSelectedServerGroupOptions.length; i++) {
						$scope.accountGridData[selectedRow].group[i] = $scope.accountSelectedServerGroupOptions[i];
					}
					$scope.accountGridData[selectedRow].dirty = true;
				}
				$scope.accountGrid.refresh();
				$scope.hideQuickSetupAccounting = true;
				$scope.disableApplyButton = false;
			}
		};
		
		$scope.cancelAccount = function() {
			$scope.hideQuickSetupAccounting = true;
			$scope.aaa.methodList.account = {};
		};
		
		$scope.showAccountQuickSetup = function(data) {
			$scope.accountSelectedServerGroupOptions = [];
			$scope.aaaMethodAccountAccord(true,false);
			if(angular.isObject(data)){
				$scope.disableAccountName = true;
				$scope.hideQuickSetupAccounting = false;
				$scope.selectedAccountnName = data.name;
				$scope.deleteAccount = ($scope.selectedArrayObject["selectedAccountArray"].length == 0);
				$scope.aaa.methodList.account = angular.copy(data);
				if($scope.aaa.methodList.account.group){
					for (var i = 0; i < $scope.aaa.methodList.account.group.length; i++) {
						$scope.accountSelectedServerGroupOptions[i] = $scope.aaa.methodList.account.group[i];
					}
				}
				$scope.availableAccountMethodListOptions = $scope.availableAccountMethodListOptions.filter(function(val) {
					return $scope.accountSelectedServerGroupOptions.indexOf(val) == -1;
				});
			}else{
				$scope.disableAccountName = false;
				$scope.hideQuickSetupAccounting = true;
			}
			angular.element("#accountingForm  span.k-tooltip-validation").hide();
		};
		
		
		/* AAA method list accounting end here*/
		
		/*===========================================*/
		
		
		/*AAA server LDAP start Here*/
				
		AAA.loadserverLdap();
		
		$scope.ldapServerGridOptions = {
			editable : false,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			pageable : {
				messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			scrollable : false,
			sortable : true,
			selectable : true,
			columns : [{
				"template" : "<input type=\"checkbox\" ng-init=\"checked=false\" ng-model=\"checked\" ng-click=\"isChecked(checked,dataItem,'ldapServer')\"  />",
				sortable : false
			}, {
				field : "ldapServerName",
				title : translate("com_name")
			}, {
				field : "ldapServerAddress",
				title : translate("aaa_server_address")
			}, {
				field : "ldapServerPortNumber",
				title : translate("aaa_port_number")
			}, {
				field : "ldapServerSimpleBind",
				title : translate("aaa_server_ldap_bind")
			}]
		};
		
		$scope.addLDAPServer = function(){
			$scope.userObjectTypeData = [];
			$scope.disableldapServerName = false;
			$scope.hideQuickSetupsLdapServer = false;		
			$scope.aaa.servers.ldap = {};
			$scope.disableLDAPTrustPoint = false;
			$scope.aaa.servers.ldap.ldapServerSimpleBind = $scope.ldapServerSimpleBindOptions.options.data[0].serverldapName;
		}
		$scope.ldapCancel = function(){
			$scope.disableldapServerName = true;
			$scope.hideQuickSetupsLdapServer = true;
			$scope.aaa.servers.ldap = {};
		}
		$scope.userObjectTypeData = [];
		$scope.addUserObjectType = function() {
			if ($scope.aaa.servers.ldap.userObjectType) {
				if (!($scope.aaa.servers.ldap.userObjectType.indexOf('?') === -1)) {
					return false;
				}else {
					for (var index = 0; index < $scope.userObjectTypeData.length; index++) {
						if ($scope.userObjectTypeData[index] == $scope.aaa.servers.ldap.userObjectType) {
							return false;
						}
					}
				}
				$scope.userObjectTypeData.push({userObjectType:$scope.aaa.servers.ldap.userObjectType});
				$scope.aaa.servers.ldap.userObjectType = '';
			}
		};
		
		$scope.removeUserObjectType = function() {
			while ($scope.aaa.servers.ldap.selectedObjectType.length > 0) {
				var item = $scope.aaa.servers.ldap.selectedObjectType.pop();
				var index = $scope.userObjectTypeData.indexOf(item);
				if (index != -1) {
					$scope.userObjectTypeData.splice(index, 1);
				}
			}
		};
		
		
		$scope.doneLDAPServer = function() {
			if ($scope.ldapServerValidator.validate()) {
				if ($scope.disableldapServerName === false) {
					$scope.aaa.servers.ldap.ldapServerUserObjectType = $scope.userObjectTypeData;
					$scope.aaa.servers.ldap.created = true;
					if(!$scope.aaa.servers.ldap.hasOwnProperty("ldapServerSimpleBind")){
						$scope.aaa.servers.ldap.ldapServerSimpleBind = $scope.ldapServerSimpleBindOptions.options.data[0].serverldapName;
					}
					$scope.ldapServerGridData.push($scope.aaa.servers.ldap);
					$scope.hideQuickSetupsLdapServer = true;
				} else {
					var selectedRow = $scope.ldapServerGridData.map(function(e) {
						return e.ldapServerName;
					}).indexOf($scope.selectedLdapServerName);
					$scope.ldapServerGridData[selectedRow].ldapServerAddress = $scope.aaa.servers.ldap.ldapServerAddress;
					$scope.ldapServerGridData[selectedRow].ldapServerPortNumber = $scope.aaa.servers.ldap.ldapServerPortNumber;
					$scope.ldapServerGridData[selectedRow].ldapServerSimpleBind = $scope.aaa.servers.ldap.ldapServerSimpleBind;
					$scope.ldapServerGridData[selectedRow].ldapServerUserBaseDN = $scope.aaa.servers.ldap.ldapServerUserBaseDN;
					$scope.ldapServerGridData[selectedRow].ldapServerUserAttribute = $scope.aaa.servers.ldap.ldapServerUserAttribute;
					$scope.ldapServerGridData[selectedRow].ldapServerTimeout = $scope.aaa.servers.ldap.ldapServerTimeout;
					$scope.ldapServerGridData[selectedRow].ldapServerBindUserName = $scope.aaa.servers.ldap.ldapServerBindUserName;
					$scope.ldapServerGridData[selectedRow].ldapServerBindPassword = $scope.aaa.servers.ldap.ldapServerBindPassword;
					$scope.ldapServerGridData[selectedRow].ldapServerBindConfirmPassword = $scope.aaa.servers.ldap.ldapServerBindConfirmPassword;
					$scope.ldapServerGridData[selectedRow].ldapServerSecureMode = $scope.aaa.servers.ldap.ldapServerSecureMode;
					$scope.ldapServerGridData[selectedRow].ldapServerTrustPoint = $scope.aaa.servers.ldap.ldapServerTrustPoint;
					$scope.ldapServerGridData[selectedRow].ldapServerUserObjectType = [];
					$scope.ldapServerGridData[selectedRow].ldapServerUserObjectType = angular.copy($scope.userObjectTypeData);
					$scope.ldapServerGridData[selectedRow].userObjectType = $scope.aaa.servers.ldap.selectedObjectType;
					$scope.ldapServerGridData[selectedRow].dirty = true;
					$scope.hideQuickSetupsLdapServer = true;
				}
				$scope.ldapServerGrid.refresh();
				$scope.disableApplyButton = false;
			}
		};
		
		$scope.deleteldapServer = function() {
			$scope.deleteFromArray('ldapServer');
			$scope.deleteLdapServer = false;
			$scope.hideQuickSetupsLdapServer = true;
			$scope.enableDeleteButton = true;
		};
		
		$scope.setTrustPoint = function() {
			if (!$scope.aaa.servers.ldap.ldapServerSecureMode) {
				$scope.disableLDAPTrustPoint = false;
			}else {
				$scope.aaa.servers.ldap.ldapServerTrustPoint = "None";
				$scope.disableLDAPTrustPoint = true;
			}
		}		
		$scope.showLDAPServerQuickSetup = function(data) {
			$scope.hideQuickSetupsLdapServer = false;
			$scope.userObjectTypeData = [];
			$scope.selectedLdapServerName = data.ldapServerName;
			$scope.enableDeleteButton = ($scope.selectedArrayObject["selectedldapServerArray"].length == 0);
			$scope.disableldapServerName = true;
			$scope.aaa.servers.ldap = angular.copy(data);
			if($scope.aaa.servers.ldap.ldapServerUserObjectType){
				if($scope.aaa.servers.ldap.ldapServerUserObjectType.length === undefined ){
					$scope.aaa.servers.ldap.ldapServerUserObjectType = [$scope.aaa.servers.ldap.ldapServerUserObjectType];
				}
				for (var i = 0; i < $scope.aaa.servers.ldap.ldapServerUserObjectType.length; i++) {
					$scope.userObjectTypeData[i] = $scope.aaa.servers.ldap.ldapServerUserObjectType[i];
				}
			}
			$scope.aaa.servers.ldap.ldapServerBindConfirmPassword = $scope.aaa.servers.ldap.ldapServerBindPassword;

			if (data.ldapServerSecureMode) {
				$scope.disableLDAPTrustPoint = false;
			} else {
				$scope.disableLDAPTrustPoint = true;
			}
		};
		
		/*AAA server LDAP End Here*/
		/******************Start User Administration ************/			
			$scope.userAdministration = {
				userName : "",
				privilege : "",
				password : "",
				type : ""
			};
			var userValidations = $("#userForm").kendoValidator({
					rules : {
						maximum : function(input) {
							var minValue = input.data('maximum');
							if (minValue){
								return input.val().length < Number(minValue);
							}
							return true;
						},
						matches : function(input) {
							var matches = input.data('matches');
							if (matches) {
								return (input.val() === $scope.userAdministration.password);
							}
							return true;
						},
						check:function(input){
							var msg = input.data('checkMsg');
							if ((msg==undefined)) {
								return true;
							}
							var regExp=/^[A-Za-z][A-Za-z0-9]*$/;
							if(regExp.test(input.val())){
								return true;
							}
							return false;
						},
						existing : function(input) {
							if (!input.data('existingMsg')){
								return true;
							}
							var val = input.val();
							if (!$scope.userData || $scope.userData.length <= 0){
								return true;
							}
							for (var i = 0; i < $scope.userData.length; i++) {
								if ($scope.userData[i]["userName"] == val) {
									return false;
								}
							}
							return true;
						},
						minimum : function(input) {
							var minValue = input.data('minimum');
							if (minValue){
								return input.val().length > Number(minValue);
							}
							return true;
						}
				}
			}).data("kendoValidator");
			$scope.disableUserName = true;
			$scope.disableDelete = true;			
			$scope.privilegeOptions = dataSourceService.privilegeOptions();
			$scope.typeOptions = dataSourceService.typeOptions();
			$scope.userAdministration = angular.copy($scope.userAdministration);
			$scope.userDirty="";
			var userConfigCLI="";
			var editUserData = function(){
				angular.element("#userForm  span.k-tooltip-validation").hide();
				var selected = this.dataItem(this.select());
				$timeout(function(){$scope.userShowEditSection = true;});
				$scope.userAdministration.userName = selected.userName;
				$scope.userAdministration.privilege = selected.privilege;
				$scope.userAdministration.password = selected.password;
				$scope.userAdministration.confirmPassword = selected.password;
				$scope.userAdministration.type = selected.type;
				$scope.userDirty=selected.dirty;
				$scope.disableUserName = true;
				$scope.disableDelete = false;
			};
			$scope.saveUserData = function(){
				if (userValidations.validate()) {
				//var scrypt = scrypt_module_factory(33554432);
				$scope.disableApplyButton = false;
				if($scope.userDirty){
					$scope.userGrid.dataSource.add({"userName": $scope.userAdministration.userName,"privilege": $scope.userAdministration.privilege,"password": $scope.userAdministration.password,"type": $scope.userAdministration.type});
				}else{ 
					var selectedItem = $scope.userGrid.dataItem($scope.userGrid.select());
					selectedItem.userName = $scope.userAdministration.userName;
					selectedItem.privilege = $scope.userAdministration.privilege;
					selectedItem.password = $scope.userAdministration.password;
					selectedItem.type = $scope.userAdministration.type;
				}
				var currentUser = $scope.userAdministration.password;
				//The following commented code will be enabled when secret 9 is supported in IOS
				/*var generateRandomNumber = randomString();
	            var output_printableHash = get_printable_hash(generateRandomNumber, 10);
				var keyBytes = scrypt.crypto_scrypt(scrypt.encode_utf8(currentUser),scrypt.encode_utf8(output_printableHash),16384,1,1,32);
	            var output_printableHash_Scrypt = get_printable_hash(keyBytes, 32);
				currentUser = "$9$"+ output_printableHash + "$"+ output_printableHash_Scrypt;
				userConfigCLI += "user-name "+$scope.userAdministration.userName+"\n privilege "+$scope.userAdministration.privilege+"\n nopassword \n";
				userConfigCLI += "user-name "+$scope.userAdministration.userName+"\n privilege "+$scope.userAdministration.privilege+"\n secret 9 "+currentUser+"\n";	*/
				userConfigCLI += "user-name "+$scope.userAdministration.userName+"\n privilege "+$scope.userAdministration.privilege+"\n password "+currentUser+"\n type "+$scope.userAdministration.type+"\n";
				$scope.reset();
			  }
			}
			$scope.deleteData = function(popup) {
				var selectedItem = $scope.userGrid.dataItem($scope.userGrid.select());
				$scope.userGrid.dataSource.remove(selectedItem);
				userConfigCLI += "no user-name "+selectedItem.userName+"\n";				
				popup.close();
			}
			$scope.addUser = function() {
				$scope.userAdministration = angular.copy($scope.userAdministration);
				$scope.userShowEditSection = true;
				$scope.disableUserName = false;
				$scope.disableDelete = true;
				$scope.userAdministration.userName = "";
				$scope.userAdministration.privilege = "0";
				$scope.userAdministration.password = "";
				$scope.userAdministration.confirmPassword = "";
				$scope.userAdministration.type = "default";
				$scope.userDirty=true;
				$("#userForm  span.k-tooltip-validation").hide();
			};			
			$scope.deleteConfirmation = function() {
				$scope.commonConfirmationUser('delete');
			};
			$scope.commonConfirmationUser = function() {
				$scope.dlgUser = dialogService.dialog({
					content : translate("msg_delete_confirmation"),
					title : translate("msg_delete_confirmation_window"),
					messageType : "confirm",
					actionButtons : [{
						text : translate("com_ok"),
						callback : "userDeleteConfirmation"
					}, {
						text : translate("com_cancel")
					}]
				});
			};  
			$scope.$on("userDeleteConfirmation", function() {
				$scope.disableApplyButton = false;
				$scope.deleteData($scope.dlgUser.data("kendoWindow"));
			});
			$scope.reset = function() {
				$scope.userAdministration.userName = "";
				$scope.userAdministration.privilege = "0";
				$scope.userAdministration.password = "";
				$scope.userAdministration.confirmPassword = "";
				$scope.userAdministration.type = "default";
				$scope.userShowEditSection = false;
				$scope.disableDelete = true;
			};			
			function userDetailsList(){			
				var showUserList =requestRoutingService.getShowCmdOutput("show running-config aaa user-name","userAAA");			
				if(showUserList.ShowRunningconfigAAAUserName.wnwebdata.entry){
					showUserList=showUserList.ShowRunningconfigAAAUserName.wnwebdata.entry;
					if (typeof showUserList == "object" && !showUserList.length){
						showUserList = [showUserList];
					}
					$scope.showUserList = $.map(showUserList, function(value) {
						return [value];
					});
				}
				for(var i=0;i<showUserList.length;i++){
					if(showUserList[i].privilege===undefined){
						showUserList[i].privilege="1";
					}
				}
				$scope.userData = new kendo.data.ObservableArray(showUserList);
				$scope.userDataSource = new kendo.data.DataSource({
					pageSize : 10,
					data : $scope.userData
				});				
				$scope.userGridOptions = {
					editable : false,
					sortable : true,
					change : editUserData,
					pageable: {
						  messages: {
							  display: translate("com_page_display"), 
							  empty: translate("com_page_empty"),
							  page: translate("com_page_pagetext"),
							  of:translate("com_page_of"),  
							  itemsPerPage: translate("com_page_itemsPerPage"),
							  first: translate("com_page_first"),
							  previous: translate("com_page_previous"),
							  next: translate("com_page_next"),
							  last: translate("com_page_last"),
							  refresh: translate("com_page_refresh"),
							  morePages: translate("com_page_morePage")
						   },
						   pageSizes : gridCrudService.grid_page_sizes,
						   refresh : true,
						   buttonCount : 5
					},
					filterable : {
						extra : false,
						operators : {
							string : {
								eq : translate("com_is_equal"),
		                        neq : translate("com_isnot_equal")
							}
						},
						messages : {
				            info: translate("com_page_dropDowntext"),
				            filter: translate("com_btn_filter"),
				            clear: translate("com_btn_clear")
				        }
					},
					scrollable : false,
					selectable : true,
					columns : [
					{
						field : "userName",
						editable : "false",
						title : translate("user_administration_name"),
						width : 25
					}, {
						field : "privilege",
						editable : "false",
						title : translate("user_administration_priv"),
						width : 25
					}, {
						field : "password",
						hidden : "true"
					},{
						field : "type",
						editable : "false",
						title : translate("management_snmp_host_type"),
						width : 25
					}]
				};	
			}	
			userDetailsList();
			//encrypting password
			function randomString(){
		        var text = [];
		        var possible = "0123456789";
		        for( var i=0; i < 10; i++ )
		            text.push(parseInt(possible.charAt(Math.floor(Math.random() * possible.length)))+15);
		        return text;
		    }
		    var printable_char_array =  "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
		    function convert_6_bit_into_char(n) {
		        return printable_char_array[ n & 0x3f];
		    }
		    function get_printable_hash (input, len_total){
		        var i,j,k,n;
		        var out = [];
		        if (!input || !len_total) {
		            return(false);
		        }
		        var len = len_total;
		        var inp = [];
		        var out_str = [];
		        for ( ; len; len -= n) {
		            n = (len > 3) ? 3 : len;
		            j = 0;
		            inp = input.slice((len_total - len),len_total);
		            for (i = 0; i<n; i++) {
		                j = (j<<8) | (inp[i] & 0xff);
		            }
		            var partial_output = (n * 8 % 6);
		            if (partial_output > 0) j = j << (6 - partial_output);
		            k = parseInt((n * 8 + 5) / 6);
		            for (i = 0,out = []; i < k; i++) {
		                var bit_position = 6 * (k - i - 1);
		                var this_output = (j>>bit_position) & 0x3f;
		                out[i] = convert_6_bit_into_char(this_output);
		            }
		            out_str = out_str + out;
		            out_str = out_str.replace(/,/g, "");
		        }
		        return out_str;
		    }		
		/******************End   User Administration ************/
				
		$scope.aaaApplyBtn = function(){
			var aaaJson = {
				createdAuthMethodList : [],
				updatedAuthMethodList : [],
				deletedAuthMethodList : [],
				createdAuthorMethodList : [],
				updatedAuthorMethodList : [],
				deletedAuthorMethodList : [],
				createdRadiusServerGroups: [],
				updatedRadiusServerGroups: [],
				deletedRadiusServerGroups: [],
				createdTacacsServerGroups: [],
				updatedTacacsServerGroups: [],
				deletedTacacsServerGroups: [],
				createdLdapServerGroups: [],
				updatedLdapServerGroups: [],
				deletedLdapServerGroups: [],
				createdRadiusServers: [],
				updatedRadiusServers: [],
				deletedRadiusServers: [],
				createdTacacsServers: [],
				updatedTacacsServers: [],
				deletedTacacsServers: [],
				createdLdapServers : [],
				updatedLdapServers : [],
				deletedLdapServers : [],
				createdMethodlistAccount : [],
				updatedMethodlistAccount : [],
				deletedMethodlistAccount : []
			};
			if ($scope.methodlistAuthData.length > 0) {
				for (var authIndex in $scope["methodlistAuthData"]) {
					var authCurrent = $scope.methodlistAuthData[authIndex];
					if (authCurrent.created) {
						aaaJson.createdAuthMethodList.push(authCurrent);
						authCurrent.created = false;
					}
					if (authCurrent.hasOwnProperty('dirty') && authCurrent.dirty == true) {
						aaaJson.updatedAuthMethodList.push(angular.copy(authCurrent));
						authCurrent.dirty = false;
					}
				}
			}
			if ($scope.methodlistAuthorData.length > 0) {
				for (var authorIndex in $scope["methodlistAuthorData"]) {
					var authorCurrent = $scope.methodlistAuthorData[authorIndex];
					if (authorCurrent.created) {
						aaaJson.createdAuthorMethodList.push(authorCurrent);
						authorCurrent.created = false;
					}
					if (authorCurrent.hasOwnProperty('dirty') && authorCurrent.dirty == true) {
						aaaJson.updatedAuthorMethodList.push(angular.copy(authorCurrent));
						authorCurrent.dirty = false;
					}
				}
			}
			if ($scope.serverGroupRadiusData.length > 0) {
				for (var index in $scope["serverGroupRadiusData"]) {
					var current = $scope.serverGroupRadiusData[index];
					if (current.created) {
						aaaJson.createdRadiusServerGroups.push(current);
						current.created = false;
					}
					if (current.hasOwnProperty('dirty') && current.dirty == true) {
						//current.deletedServerList = _.difference(current._pristineList, current.list);
						aaaJson.updatedRadiusServerGroups.push(angular.copy(current));
						current.dirty = false;
					}
				}
			}
			if ($scope.serverGroupTacacsData.length > 0) {
				for (var index in $scope["serverGroupTacacsData"]) {
					var current = $scope.serverGroupTacacsData[index];
					if (current.created) {
						aaaJson.createdTacacsServerGroups.push(current);
						current.created = false;
					}
					if (current.hasOwnProperty('dirty') && current.dirty == true) {
						//current.deletedServerList = _.difference(current._pristineList, current.list);
						aaaJson.updatedTacacsServerGroups.push(angular.copy(current));
						current.dirty = false;
					}
				}
			} 
			if ($scope.ldapServerGroupGridData.length > 0) {
				for (var index in $scope["ldapServerGroupGridData"]) {
					var current = $scope.ldapServerGroupGridData[index];
					if (current.created) {
						aaaJson.createdLdapServerGroups.push(current);
						current.created = false;
					}
					if (current.hasOwnProperty('dirty') && current.dirty == true) {
						
						//current.deletedServerList = _.difference(current._pristineList, current.list);
						aaaJson.updatedLdapServerGroups.push(angular.copy(current));
						current.dirty = false;
					}
				}
			}
			if ($scope.serverRadiusGridData.length >= 0) {
				for (var index in $scope["serverRadiusGridData"]) {
					var current = $scope.serverRadiusGridData[index];
					if (current.created) {
						//current.password = btoa(current.password);
						// to encrypt the password
						aaaJson.createdRadiusServers.push(current);
						current.created = false;
					}
					if (current.hasOwnProperty('dirty') && current.dirty == true) {
						//current.password = btoa(current.password);
						// to encrypt the password
						aaaJson.updatedRadiusServers.push(current);
						current.dirty = false;
					}
				}
			}
			if ($scope.serverTacacsGridData.length >= 0) {
				for (var index in $scope["serverTacacsGridData"]) {
					var current = $scope.serverTacacsGridData[index];
					if (current.created) {
						//current.password = btoa(current.password);
						// to encrypt the password
						aaaJson.createdTacacsServers.push(current);
						current.created = false;
					}
					if (current.hasOwnProperty('dirty') && current.dirty == true) {
						//current.password = btoa(current.password);
						// to encrypt the password
						aaaJson.updatedTacacsServers.push(current);
						current.dirty = false;
					}
				}
			}
			($scope.deleted.methodListAuth && $scope.deleted.methodListAuth.length > 0) ? aaaJson.deletedAuthMethodList = angular.copy($scope.deleted.methodListAuth) : aaaJson.deletedAuthMethodList = [];
			($scope.deleted.methodListAuthor && $scope.deleted.methodListAuthor.length > 0) ? aaaJson.deletedAuthorMethodList = angular.copy($scope.deleted.methodListAuthor) : aaaJson.deletedAuthorMethodList = [];
			($scope.deleted.radiusServers && $scope.deleted.radiusServers.length > 0) ? aaaJson.deletedRadiusServers = angular.copy($scope.deleted.radiusServers) : aaaJson.deletedRadiusServers = [];
			($scope.deleted.tacacsServers && $scope.deleted.tacacsServers.length > 0) ? aaaJson.deletedTacacsServers = angular.copy($scope.deleted.tacacsServers) : aaaJson.deletedTacacsServers = [];
			($scope.deleted.radiusGroup && $scope.deleted.radiusGroup.length > 0) ? aaaJson.deletedRadiusServerGroups = angular.copy($scope.deleted.radiusGroup) : aaaJson.deletedRadiusServerGroups = [];
			($scope.deleted.tacacsGroup && $scope.deleted.tacacsGroup.length > 0) ? aaaJson.deletedTacacsServerGroups = angular.copy($scope.deleted.tacacsGroup) : aaaJson.deletedTacacsServerGroups = [];
			($scope.deleted.ldapGroup && $scope.deleted.ldapGroup.length > 0) ? aaaJson.deletedLdapServerGroups = angular.copy($scope.deleted.ldapGroup) : aaaJson.deletedLdapServerGroups = [];
			($scope.deleted.ldapServers && $scope.deleted.ldapServers.length > 0) ? aaaJson.deletedLdapServers = angular.copy($scope.deleted.ldapServers) : aaaJson.deletedLdapServers = [];
			($scope.deleted.Accounting && $scope.deleted.Accounting.length > 0) ? aaaJson.deletedMethodlistAccount = angular.copy($scope.deleted.Accounting) : aaaJson.deletedMethodlistAccount = [];
			var aaaConfigCli = "";
			var isOneTimeGeneral = false;
			var isOneTimeLdap = false ;
			// AAA MthodList Authentication Starts here
			var aaaAuthConfig = "";
			if(aaaJson.createdAuthMethodList.length > 0){
				for(var methodListAuth = 0; methodListAuth < aaaJson.createdAuthMethodList.length; methodListAuth++){
					if(aaaJson.createdAuthMethodList[methodListAuth].grouptype == "local"){
						aaaAuthConfig += "aaa authentication "+aaaJson.createdAuthMethodList[methodListAuth]["type"]+" "+aaaJson.createdAuthMethodList[methodListAuth]["listname"]+" local"
					}else if(aaaJson.createdAuthMethodList[methodListAuth].grouptype == "group"){
						aaaAuthConfig += "aaa authentication "+aaaJson.createdAuthMethodList[methodListAuth]["type"]+" "+aaaJson.createdAuthMethodList[methodListAuth]["listname"]+""
					}
					for(var authGroup = 0; authGroup < aaaJson.createdAuthMethodList[methodListAuth].group.length; authGroup++){
						aaaAuthConfig += " group "+aaaJson.createdAuthMethodList[methodListAuth].group[authGroup]+""
					}
					//aaaAuthConfig += "aaa authentication ";
					if(aaaJson.createdAuthMethodList[methodListAuth].hasOwnProperty('fallback') && aaaJson.createdAuthMethodList[methodListAuth].fallback){
						aaaAuthConfig += " local ";
					}
				}
				aaaAuthConfig +="\n";
			}
			if(aaaJson.updatedAuthMethodList.length > 0){
				for(var methodListAuth = 0; methodListAuth < aaaJson.updatedAuthMethodList.length; methodListAuth++){
					if(aaaJson.updatedAuthMethodList[methodListAuth].grouptype == "local"){
						aaaAuthConfig += "aaa authentication "+aaaJson.updatedAuthMethodList[methodListAuth]["type"]+" "+aaaJson.updatedAuthMethodList[methodListAuth]["listname"]+" local"
					}
					if(aaaJson.updatedAuthMethodList[methodListAuth].grouptype == "group"){
						aaaAuthConfig += "aaa authentication "+aaaJson.updatedAuthMethodList[methodListAuth]["type"]+" "+aaaJson.updatedAuthMethodList[methodListAuth]["listname"]+""
					}
					for(var authGroup = 0; authGroup < aaaJson.updatedAuthMethodList[methodListAuth].group.length; authGroup++){
						aaaAuthConfig += " group "+aaaJson.updatedAuthMethodList[methodListAuth].group[authGroup]+""
					}
					if(aaaJson.updatedAuthMethodList[methodListAuth].hasOwnProperty('fallback') && aaaJson.updatedAuthMethodList[methodListAuth].fallback){
						aaaAuthConfig += " local ";
					}
				}
				aaaAuthConfig +="\n";
			}
			if(aaaJson.deletedAuthMethodList.length > 0){
				for(var delAuth = 0; delAuth < aaaJson.deletedAuthMethodList.length; delAuth++){
					aaaAuthConfig += "no aaa authentication "+ aaaJson.deletedAuthMethodList[delAuth].type +" "+ aaaJson.deletedAuthMethodList[delAuth].listname +"\n";
				}
			}
			if(aaaAuthConfig != ""){
				aaaConfigCli += aaaAuthConfig;
			}
			// AAA MthodList Authentication Ends here
			// AAA MthodList Authorization Starts here
			var aaaAuthorConfig = "";
			if(aaaJson.createdAuthorMethodList.length > 0){
				for(var methodListAuthor = 0; methodListAuthor < aaaJson.createdAuthorMethodList.length; methodListAuthor++){
					if(aaaJson.createdAuthorMethodList[methodListAuthor].grouptype == "local"){
						aaaAuthorConfig += "aaa authorization "+aaaJson.createdAuthorMethodList[methodListAuthor]["type"]+" "+aaaJson.createdAuthorMethodList[methodListAuthor]["listname"]+" local"
					}else if(aaaJson.createdAuthorMethodList[methodListAuthor].grouptype == "group"){
						aaaAuthorConfig += "aaa authorization "+aaaJson.createdAuthorMethodList[methodListAuthor]["type"]+" "+aaaJson.createdAuthorMethodList[methodListAuthor]["listname"]+""
					}
					for(var authorGroup = 0; authorGroup < aaaJson.createdAuthorMethodList[methodListAuthor].group.length; authorGroup++){
						aaaAuthorConfig += " group "+aaaJson.createdAuthorMethodList[methodListAuthor].group[authorGroup]+""
					}
					if(aaaJson.createdAuthorMethodList[methodListAuthor].hasOwnProperty('fallback') && aaaJson.createdAuthorMethodList[methodListAuthor].fallback){
						aaaAuthorConfig += " local ";
					}
				}
				aaaAuthorConfig +="\n";
			}
			if(aaaJson.updatedAuthorMethodList.length > 0){
				for(var upMethodListAuthor = 0; upMethodListAuthor < aaaJson.updatedAuthorMethodList.length; upMethodListAuthor++){
					if(aaaJson.updatedAuthorMethodList[upMethodListAuthor].grouptype == "local"){
						aaaAuthorConfig += "aaa authorization "+aaaJson.updatedAuthorMethodList[upMethodListAuthor]["type"]+" "+aaaJson.updatedAuthorMethodList[upMethodListAuthor]["listname"]+" local"
					}
					if(aaaJson.updatedAuthorMethodList[upMethodListAuthor].grouptype == "group"){
						aaaAuthorConfig += "aaa authorization "+aaaJson.updatedAuthorMethodList[upMethodListAuthor]["type"]+" "+aaaJson.updatedAuthorMethodList[upMethodListAuthor]["listname"]+""
					}
					for(var authGroup = 0; authGroup < aaaJson.updatedAuthorMethodList[upMethodListAuthor].group.length; authGroup++){
						aaaAuthorConfig += " group "+aaaJson.updatedAuthorMethodList[upMethodListAuthor].group[authGroup]+""
					}
					if(aaaJson.updatedAuthorMethodList[upMethodListAuthor].hasOwnProperty('fallback') && aaaJson.updatedAuthorMethodList[upMethodListAuthor].fallback){
						aaaAuthorConfig += " local ";
					}
				}
				aaaAuthorConfig +="\n";
			}
			if(aaaJson.deletedAuthorMethodList.length > 0){
				for(var delAuthor = 0; delAuthor < aaaJson.deletedAuthorMethodList.length; delAuthor++){
					aaaAuthorConfig += "no aaa authorization "+ aaaJson.deletedAuthorMethodList[delAuthor].type +" "+ aaaJson.deletedAuthorMethodList[delAuthor].listname +"\n";
				}
			}
			if(aaaAuthorConfig != ""){
				aaaConfigCli += aaaAuthorConfig;
			}
			// AAA MthodList Authorization Ends here
			//AAA Server Group RADIUS starts here
			if(aaaJson.createdRadiusServerGroups.length > 0){
				for(var crtRadSerGrp = 0; crtRadSerGrp < aaaJson.createdRadiusServerGroups.length; crtRadSerGrp++){
					aaaConfigCli += "aaa group server radius "+aaaJson.createdRadiusServerGroups[crtRadSerGrp].name+"\n";
					if(aaaJson.createdRadiusServerGroups[crtRadSerGrp].hasOwnProperty('macdelimiter')){
						aaaConfigCli += "mac-delimiter "+aaaJson.createdRadiusServerGroups[crtRadSerGrp].macdelimiter+"\n";
					}else{
						aaaConfigCli += "mac-delimiter none\n";
					}
					if(aaaJson.createdRadiusServerGroups[crtRadSerGrp].hasOwnProperty('securitymode')){
						aaaConfigCli += "subscriber mac-filtering security-mode "+aaaJson.createdRadiusServerGroups[crtRadSerGrp].securitymode+"\n";
					}else{
						aaaConfigCli += "subscriber mac-filtering security-mode none\n";
					}
					if(aaaJson.createdRadiusServerGroups[crtRadSerGrp].deadtime){
						aaaConfigCli += "deadtime "+aaaJson.createdRadiusServerGroups[crtRadSerGrp].deadtime+"\n";
					}
					for(var crtRadSerGrpServer = 0; crtRadSerGrpServer < aaaJson.createdRadiusServerGroups[crtRadSerGrp].list.length; crtRadSerGrpServer++){
						aaaConfigCli += "server name "+aaaJson.createdRadiusServerGroups[crtRadSerGrp].list[crtRadSerGrpServer].list+"\n";
					}
					aaaConfigCli += "exit\n";
				}
			}
			if(aaaJson.updatedRadiusServerGroups.length > 0){
				for(var updRadSerGrp = 0; updRadSerGrp < aaaJson.updatedRadiusServerGroups.length; updRadSerGrp++){
					aaaConfigCli += "aaa group server radius "+aaaJson.updatedRadiusServerGroups[updRadSerGrp].name+"\n";
					if(aaaJson.updatedRadiusServerGroups[updRadSerGrp].hasOwnProperty('macdelimiter')){
						aaaConfigCli += "mac-delimiter "+aaaJson.updatedRadiusServerGroups[updRadSerGrp].macdelimiter+"\n";
					}else{
						aaaConfigCli += "mac-delimiter none\n";
					}
					if(aaaJson.updatedRadiusServerGroups[updRadSerGrp].hasOwnProperty('securitymode')){
						aaaConfigCli += "subscriber mac-filtering security-mode "+aaaJson.updatedRadiusServerGroups[updRadSerGrp].securitymode+"\n";
					}else{
						aaaConfigCli += "subscriber mac-filtering security-mode none\n";
					}
					if(aaaJson.updatedRadiusServerGroups[updRadSerGrp].deadtime){
						aaaConfigCli += "deadtime "+aaaJson.updatedRadiusServerGroups[updRadSerGrp].deadtime+"\n";
					}
					for(var updRadSerGrpServer = 0; updRadSerGrpServer < aaaJson.updatedRadiusServerGroups[updRadSerGrp].list.length; updRadSerGrpServer++){
						aaaConfigCli += "server name "+aaaJson.updatedRadiusServerGroups[updRadSerGrp].list[updRadSerGrpServer].list+"\n";
					}
					for(var upRadServerGrp =0;upRadServerGrp <$scope.availableRadiusGroupOptions.length; upRadServerGrp++){
						aaaConfigCli +="no server name "+$scope.availableRadiusGroupOptions[upRadServerGrp]+"\n";
				    }
					aaaConfigCli += "exit\n";
				}
			}
			if(aaaJson.deletedRadiusServerGroups.length > 0){
				for(var delRadSerGrp = 0; delRadSerGrp < aaaJson.deletedRadiusServerGroups.length; delRadSerGrp++){
					aaaConfigCli += "no aaa group server radius "+ aaaJson.deletedRadiusServerGroups[delRadSerGrp]+"\n";
				}
					aaaConfigCli += "exit\n";
			}
	        //AAA Server Group RADIUS Ends here
		    //AAA server Group Tacacs starts here
			if(aaaJson.createdTacacsServerGroups.length > 0){
				for(var crtRadSerGrp = 0; crtRadSerGrp < aaaJson.createdTacacsServerGroups.length; crtRadSerGrp++){
					aaaConfigCli += "aaa group server tacacs "+aaaJson.createdTacacsServerGroups[crtRadSerGrp].name+"\n";
					for(var crtRadSerGrpServer = 0; crtRadSerGrpServer < aaaJson.createdTacacsServerGroups[crtRadSerGrp].list.length; crtRadSerGrpServer++){
						aaaConfigCli += "server name "+aaaJson.createdTacacsServerGroups[crtRadSerGrp].list[crtRadSerGrpServer].list+"\n";
					}
					aaaConfigCli += "exit\n";
				}
			}
			if(aaaJson.updatedTacacsServerGroups.length > 0){
				for(var updRadSerGrp = 0; updRadSerGrp < aaaJson.updatedTacacsServerGroups.length; updRadSerGrp++){
					aaaConfigCli += "aaa group server tacacs "+aaaJson.updatedTacacsServerGroups[updRadSerGrp].name+"\n";
					if(aaaJson.updatedTacacsServerGroups[updRadSerGrp].list.length > 0){
						for(var updRadSerGrpServer = 0; updRadSerGrpServer < aaaJson.updatedTacacsServerGroups[updRadSerGrp].list.length; updRadSerGrpServer++){

							aaaConfigCli += "server name "+aaaJson.updatedTacacsServerGroups[updRadSerGrp].list[updRadSerGrpServer].list+"\n";
						}
					}	
							 for(var upTacServerGrp =0;upTacServerGrp <$scope.availableTacacsGroupOptions.length; upTacServerGrp++){
							  aaaConfigCli +="no server name "+$scope.availableTacacsGroupOptions[upTacServerGrp]+"\n";
						     }
					aaaConfigCli += "exit\n";
				}
			}
			if(aaaJson.deletedTacacsServerGroups.length > 0){
				for(var delRadSerGrp = 0; delRadSerGrp < aaaJson.deletedTacacsServerGroups.length; delRadSerGrp++){
					aaaConfigCli += "no aaa group server tacacs "+ aaaJson.deletedTacacsServerGroups[delRadSerGrp]+"\n";
				}
					aaaConfigCli += "exit\n";
			}
			//AAA server Group Tacacs Ends here
			//AAA server group Ldap starts here
			if(aaaJson.createdLdapServerGroups.length > 0){
				for(var crtLdapSerGrp = 0; crtLdapSerGrp < aaaJson.createdLdapServerGroups.length; crtLdapSerGrp++){
					aaaConfigCli += "aaa group server ldap "+aaaJson.createdLdapServerGroups[crtLdapSerGrp].name+"\n";
					for(var crtLdapSerGrpServer = 0; crtLdapSerGrpServer < aaaJson.createdLdapServerGroups[crtLdapSerGrp].list.length; crtLdapSerGrpServer++){
						aaaConfigCli += "server "+aaaJson.createdLdapServerGroups[crtLdapSerGrp].list[crtLdapSerGrpServer].list+"\n";
					}
					aaaConfigCli += "exit\n";
					isOneTimeLdap = true;
				}
			}
			if(aaaJson.updatedLdapServerGroups.length > 0){
				for(var updLdapSerGrp = 0; updLdapSerGrp < aaaJson.updatedLdapServerGroups.length; updLdapSerGrp++){
					aaaConfigCli += "aaa group server ldap "+aaaJson.updatedLdapServerGroups[updLdapSerGrp].name+"\n";
					if(aaaJson.updatedLdapServerGroups[updLdapSerGrp].list.length > 0){
						for(var updLdapSerGrpServer = 0; updLdapSerGrpServer < aaaJson.updatedLdapServerGroups[updLdapSerGrp].list.length; updLdapSerGrpServer++){
							aaaConfigCli += "server "+aaaJson.updatedLdapServerGroups[updLdapSerGrp].list[updLdapSerGrpServer].list+"\n";
						}
					}	
						for(var upLdapServerGrp =0;upLdapServerGrp <$scope.availableLdapGroupOptions.length; upLdapServerGrp++){
							  aaaConfigCli +="no server "+$scope.availableLdapGroupOptions[upLdapServerGrp]+"\n";
						}
					aaaConfigCli += "exit\n";
					isOneTimeLdap =true;
				}
			}
			if(aaaJson.deletedLdapServerGroups.length > 0){
				for(var delRadSerGrp = 0; delRadSerGrp < aaaJson.deletedLdapServerGroups.length; delRadSerGrp++){
					aaaConfigCli += "no aaa group server ldap "+ aaaJson.deletedLdapServerGroups[delRadSerGrp]+"\n";
				}
					aaaConfigCli += "exit\n";
					isOneTimeLdap =true;
			}
			
			//AAA server group LDAP Ends here
			if(aaaJson.createdRadiusServers.length > 0){
				for(var crtRadSer = 0; crtRadSer < aaaJson.createdRadiusServers.length; crtRadSer++){
					aaaConfigCli += "aaa new-model\n";
					aaaConfigCli += "radius server "+ aaaJson.createdRadiusServers[crtRadSer].name+"\n";
					aaaConfigCli += "address ipv4 "+aaaJson.createdRadiusServers[crtRadSer].address+" auth-port "+aaaJson.createdRadiusServers[crtRadSer].authport+" acct-port "+aaaJson.createdRadiusServers[crtRadSer].acctport+"\n";
					aaaConfigCli += "key "+aaaJson.createdRadiusServers[crtRadSer].password+"\n";
					if(aaaJson.createdRadiusServers[crtRadSer].timeout){
						aaaConfigCli += "timeout "+aaaJson.createdRadiusServers[crtRadSer].timeout+"\n";
					}
					if(aaaJson.createdRadiusServers[crtRadSer].retry){
						aaaConfigCli += "retransmit "+aaaJson.createdRadiusServers[crtRadSer].retry+"\n";
					}
					aaaConfigCli += "exit\n";
					aaaConfigCli += "aaa server radius dynamic-author\n";
					aaaConfigCli += "client "+aaaJson.createdRadiusServers[crtRadSer].address+" server-key "+aaaJson.createdRadiusServers[crtRadSer].password+"\n";
					aaaConfigCli += "exit\n";
				}
			}
			if(aaaJson.updatedRadiusServers.length > 0){
				for(var updRadSer = 0; updRadSer < aaaJson.updatedRadiusServers.length; updRadSer++){
					aaaConfigCli += "radius server "+ aaaJson.updatedRadiusServers[updRadSer].name+"\n";
					aaaConfigCli += "address ipv4 "+aaaJson.updatedRadiusServers[updRadSer].address+" auth-port "+aaaJson.updatedRadiusServers[updRadSer].authport+" acct-port "+aaaJson.updatedRadiusServers[updRadSer].acctport+"\n";
					aaaConfigCli += "key "+aaaJson.updatedRadiusServers[updRadSer].password+"\n";
					if(aaaJson.updatedRadiusServers[updRadSer].timeout){
						aaaConfigCli += "timeout "+aaaJson.updatedRadiusServers[updRadSer].timeout+"\n";
					}
					if(aaaJson.updatedRadiusServers[updRadSer].retry){
						aaaConfigCli += "retransmit "+aaaJson.updatedRadiusServers[updRadSer].retry+"\n";
					}
					aaaConfigCli += "exit\n";
					aaaConfigCli += "aaa server radius dynamic-author\n";
					aaaConfigCli += "client "+aaaJson.updatedRadiusServers[updRadSer].address+" server-key "+aaaJson.updatedRadiusServers[updRadSer].password+"\n";
					aaaConfigCli += "exit\n";
				}
			}
			if(aaaJson.deletedRadiusServers.length > 0){
				for(var delRadSer = 0; delRadSer < aaaJson.deletedRadiusServers.length; delRadSer++){
					aaaConfigCli += "no radius server "+ aaaJson.deletedRadiusServers[delRadSer].name+"\n";
					aaaConfigCli += "aaa server radius dynamic-author\n";
					aaaConfigCli += "no client "+aaaJson.deletedRadiusServers[delRadSer].address+"\n";
					aaaConfigCli += "exit\n";
				}
			}
			if(aaaJson.createdTacacsServers.length > 0){
				for(var crtTacSer = 0; crtTacSer < aaaJson.createdTacacsServers.length; crtTacSer++){
					aaaConfigCli += "tacacs server "+ aaaJson.createdTacacsServers[crtTacSer].name+"\n";
					aaaConfigCli += "address ipv4 "+ aaaJson.createdTacacsServers[crtTacSer].address+"\n";
					aaaConfigCli += "port "+ aaaJson.createdTacacsServers[crtTacSer].port+"\n";
					aaaConfigCli += "key "+ aaaJson.createdTacacsServers[crtTacSer].password+"\n";
					aaaConfigCli += "timeout "+ aaaJson.createdTacacsServers[crtTacSer].timeout+"\n";
					aaaConfigCli += "exit\n";
				}
			}
			if(aaaJson.updatedTacacsServers.length > 0){
				for(var updTacSer = 0; updTacSer < aaaJson.updatedTacacsServers.length; updTacSer++){
					aaaConfigCli += "tacacs server "+ aaaJson.updatedTacacsServers[updTacSer].name+"\n";
					aaaConfigCli += "address ipv4 "+ aaaJson.updatedTacacsServers[updTacSer].address+"\n";
					aaaConfigCli += "port "+ aaaJson.updatedTacacsServers[updTacSer].port+"\n";
					aaaConfigCli += "key "+ aaaJson.updatedTacacsServers[updTacSer].password+"\n";
					aaaConfigCli += "timeout "+ aaaJson.updatedTacacsServers[updTacSer].timeout+"\n";
					aaaConfigCli += "exit\n";
				}
			}
			if(aaaJson.deletedTacacsServers.length > 0){
				for(var delTacSer = 0; delTacSer < aaaJson.deletedTacacsServers.length; delTacSer++){
					aaaConfigCli += "no tacacs server "+ aaaJson.deletedTacacsServers[delTacSer].name+"\n";
				}
					aaaConfigCli += "exit\n";
			}
			//AAA Radius FallBack starts here
			var aaaRadiusFallbackDetails=aaaService.getAAARadiusFallBack();
			if(aaaRadiusFallbackDetails.retransmit != $scope.aaa.advanced.radiusFallback.retransmit){			
				if(angular.isUndefined($scope.aaa.advanced.radiusFallback.retransmit)){
                      aaaConfigCli +="no radius-server retransmit \n";
				}else{					
					  aaaConfigCli +="radius-server retransmit "+$scope.aaa.advanced.radiusFallback.retransmit+"\n";
				}
				aaaConfigCli += "exit\n";
			}
			if(aaaRadiusFallbackDetails.timeout != $scope.aaa.advanced.radiusFallback.timeout){
				if(angular.isUndefined($scope.aaa.advanced.radiusFallback.timeout)){
                      aaaConfigCli +=" no radius-server timeout \n";
				}else{					
					aaaConfigCli +="radius-server timeout "+$scope.aaa.advanced.radiusFallback.timeout+"\n";
				}
				aaaConfigCli += "exit\n";
			}
			if(aaaRadiusFallbackDetails.deadtime != $scope.aaa.advanced.radiusFallback.deadTime){
				if(angular.isUndefined($scope.aaa.advanced.radiusFallback.deadTime)){
                    aaaConfigCli +=" no radius-server deadtime \n";
				}else{					
					aaaConfigCli +="radius-server deadtime "+$scope.aaa.advanced.radiusFallback.deadTime+"\n";
				}
				aaaConfigCli += "exit\n";
			}
			//Radius FallBack Ends here.
			//AAA General starts here
			var aaaGeneralDetails=aaaService.getAAAGeneral();
			if($scope.aaa.general.dot1x != $scope.olddot1x){
				if($scope.aaa.general.dot1x == "Enable"){
					aaaConfigCli += "dot1x system-auth-control \n";
				}else{
					aaaConfigCli += "no dot1x system-auth-control \n";
				}
				aaaConfigCli += "exit\n";
				isOneTimeGeneral = true;
			}
			if($scope.aaa.general.localAuthentication != $scope.aaaGeneralService.authentication || $scope.aaa.general.localAuthorization != $scope.aaaGeneralService.authorization ){
			    if($scope.aaa.general.localAuthentication == "none" || $scope.aaa.general.localAuthorization == "none" ){
                      aaaConfigCli +="no aaa local authentication default authorization default \n";
				}if($scope.aaa.general.localAuthentication == "default" && $scope.aaa.general.localAuthorization == "default" ){					
					aaaConfigCli +="aaa local authentication default authorization default \n";
				}if($scope.aaa.general.localAuthentication == "default" && $scope.aaa.general.localAuthorization == "methodlist" ){					
					aaaConfigCli +="aaa local authentication default authorization methodlist \n";
				}if($scope.aaa.general.localAuthentication == "methodlist" && $scope.aaa.general.localAuthorization == "default" ){					
					aaaConfigCli +="aaa local authentication methodlist authorization default \n";
				}if($scope.aaa.general.localAuthentication == "methodlist" && $scope.aaa.general.localAuthorization == "methodlist" ){					
					aaaConfigCli +="aaa local authentication methodlist authorization methodlist \n";
				}
				aaaConfigCli += "exit\n";
				isOneTimeGeneral = true;
			}
			if($scope.aaa.general.leastOutstanding != $scope.oldLeastValue ){
				if($scope.aaa.general.leastOutstanding == "Enable"){
					aaaConfigCli += "radius-server load-balance method least-outstanding \n";
				}else{
					aaaConfigCli += "no radius-server load-balance method least-outstanding \n";
				}
				aaaConfigCli += "exit\n";
				isOneTimeGeneral = true;
			}
			
			// AAA server ldap start here 
			
			/* create ldap */ 	
			var aaaServerLdapConfig = "";
			if ($scope.ldapServerGridData.length > 0) {
				for (var index in $scope["ldapServerGridData"]) {
					var current = $scope.ldapServerGridData[index];
					if (current.created) {
						aaaJson.createdLdapServers.push(current);
						aaaServerLdapConfig += "ldap server "+ current.ldapServerName + "\n";
						aaaServerLdapConfig += "ipv4 "+ current.ldapServerAddress + "\n";
						aaaServerLdapConfig += "base-dn "+ current.ldapServerUserBaseDN + "\n";
						if(current.ldapServerUserAttribute){
							aaaServerLdapConfig += "attribute map "+ current.ldapServerUserAttribute + "\n";
						}
						if(current.ldapServerUserObjectType){
							for (var ind=0;ind<current.ldapServerUserObjectType.length;ind++) {
								aaaServerLdapConfig += "search-filter user-object-type "+ current.ldapServerUserObjectType[ind].userObjectType + "\n";
							}
						}
						if(current.ldapServerPortNumber){
							aaaServerLdapConfig += "transport port "+ current.ldapServerPortNumber + "\n \n";
						}
						if(current.ldapServerSimpleBind == translate('aaa_server_ldap_auth')){
							aaaServerLdapConfig += "bind authenticate root-dn "+ current.ldapServerBindUserName + " password "+ current.ldapServerBindPassword + "\n \n";
						}
						
						if(current.ldapServerTimeout){
							aaaServerLdapConfig += "timeout retransmit "+ current.ldapServerTimeout + "\n";
						}
						
						if(current.ldapServerSecureMode == true){
							aaaServerLdapConfig += "mode secure \n";
						}
						
						if(current.ldapServerTrustPoint == true){
							if(current.ldapServerTrustPoint == "None" ){
								aaaServerLdapConfig += " no secure trustpoint \n";
							}else{
								aaaServerLdapConfig += "secure trustpoint "+current.ldapServerTrustPoint+ "\n";
							}
						}else{
							aaaServerLdapConfig += "no mode secure  \n";
							aaaServerLdapConfig += " no secure trustpoint \n";
						}
						aaaServerLdapConfig += "exit\n";
					}
					if (current.hasOwnProperty('dirty') && current.dirty == true) {
						aaaJson.updatedLdapServers.push(current);
						aaaServerLdapConfig += "ldap server "+current.ldapServerName+ "\n";
						aaaServerLdapConfig += "ipv4 "+current.ldapServerAddress+ "\n";
						aaaServerLdapConfig += "base-dn "+ current.ldapServerUserBaseDN + "\n";
						if(current.ldapServerUserAttribute){
							aaaServerLdapConfig += "attribute map "+current.ldapServerUserAttribute+ "\n";
						}
						if(current.ldapServerUserObjectType){
							for (var ind=0;ind<current.ldapServerUserObjectType.length;ind++) {
								aaaServerLdapConfig += "search-filter user-object-type "+ current.ldapServerUserObjectType[ind].userObjectType + "\n";
							}
						}
						if(current.ldapServerPortNumber){
							aaaServerLdapConfig += "transport port "+current.ldapServerPortNumber+ "\n \n";
						}
						if(current.ldapServerSimpleBind == translate('aaa_server_ldap_auth')){
							aaaServerLdapConfig += "bind authenticate root-dn "+current.ldapServerBindUserName+ " password "+ current.ldapServerBindPassword + "\n \n";
						}
						
						if(current.ldapServerTimeout){
							aaaServerLdapConfig += "timeout retransmit "+current.ldapServerTimeout+ "\n";
						}
						
						if(current.ldapServerSecureMode == true){
							aaaServerLdapConfig += "mode secure \n";
						}
						
						if(current.ldapServerTrustPoint == true){
							if(current.ldapServerTrustPoint == "None" ){
								aaaServerLdapConfig += " no secure trustpoint \n";
							}else{
								aaaServerLdapConfig += "secure trustpoint "+current.ldapServerTrustPoint+ "\n";
							}
						}else{
							aaaServerLdapConfig += "no mode secure  \n";
							aaaServerLdapConfig += " no secure trustpoint \n";
						}
						aaaServerLdapConfig += "exit\n";
					}
				}
			}
			if(aaaJson.deletedLdapServers.length > 0){
				for(var delldapSer = 0; delldapSer < aaaJson.deletedLdapServers.length; delldapSer++){
					aaaServerLdapConfig += "no ldap server "+ aaaJson.deletedLdapServers[delldapSer]+"\n";
				}
					aaaServerLdapConfig += "exit\n";
			}
			if(aaaServerLdapConfig != ""){
				aaaConfigCli += aaaServerLdapConfig;
			}
			/* server ldap end here */
			
			// AAA Method list account start here 
			
			/* create Account */ 	
			var aaaMethodAccountConfig = "";
			if ($scope.accountGridData.length > 0) {
				for (var indexAcc in $scope["accountGridData"]) {
					var current = $scope.accountGridData[indexAcc];
					if (current.created) {
						aaaJson.createdMethodlistAccount.push(current);
					}
					if (current.hasOwnProperty('dirty') && current.dirty == true) {
						aaaJson.updatedMethodlistAccount.push(current);
					}
				}
			}			

			if(aaaJson.createdMethodlistAccount.length > 0){
				for(var indexA =0 ;indexA < aaaJson.createdMethodlistAccount.length ; indexA++){
					if(aaaJson.createdMethodlistAccount[indexA].type == "commands"){
						aaaMethodAccountConfig += "aaa accounting "+ aaaJson.createdMethodlistAccount[indexA].type +" " + aaaJson.createdMethodlistAccount[indexA].level + " " + aaaJson.createdMethodlistAccount[indexA].name + " start-stop ";				
					}else{
						aaaMethodAccountConfig += "aaa accounting "+ aaaJson.createdMethodlistAccount[indexA].type + " " + aaaJson.createdMethodlistAccount[indexA].name + " start-stop ";
					}
					if(aaaJson.createdMethodlistAccount[indexA].group){	
						for(var listInd=0;listInd < aaaJson.createdMethodlistAccount[indexA].group.length; listInd++){
							aaaMethodAccountConfig += "group "+ aaaJson.createdMethodlistAccount[indexA].group[listInd] +" ";
						}
					}
				aaaMethodAccountConfig += "\n";
				}
			}
			
			if(aaaJson.updatedMethodlistAccount.length > 0){
				for(var indexA =0 ;indexA < aaaJson.updatedMethodlistAccount.length ; indexA++){
					if(aaaJson.updatedMethodlistAccount[indexA].type == "commands"){
						aaaMethodAccountConfig += "aaa accounting "+ aaaJson.updatedMethodlistAccount[indexA].type +" " + aaaJson.updatedMethodlistAccount[indexA].level + " " + aaaJson.updatedMethodlistAccount[indexA].name + " start-stop ";				
					}else{
						aaaMethodAccountConfig += "aaa accounting "+ aaaJson.updatedMethodlistAccount[indexA].type + " " + aaaJson.updatedMethodlistAccount[indexA].name + " start-stop ";
					}
					if(aaaJson.updatedMethodlistAccount[indexA].group){		
						for(var listInd=0;listInd < aaaJson.updatedMethodlistAccount[indexA].group.length; listInd++){
							aaaMethodAccountConfig += "group "+ aaaJson.updatedMethodlistAccount[indexA].group[listInd] +" ";
						}
					}
				aaaMethodAccountConfig += "\n";
				}
			}
						
			if(aaaJson.deletedMethodlistAccount.length > 0){
				for(var delacc = 0; delacc < aaaJson.deletedMethodlistAccount.length; delacc++){
					if(aaaJson.deletedMethodlistAccount[delacc].type == "commands"){
						aaaMethodAccountConfig += "no aaa accounting "+ aaaJson.deletedMethodlistAccount[delacc].type +" " + aaaJson.deletedMethodlistAccount[indexA].level + " " + aaaJson.deletedMethodlistAccount[delacc].name + "\n";
					}else{
						aaaMethodAccountConfig += "no aaa accounting "+ aaaJson.deletedMethodlistAccount[delacc].type + " " + aaaJson.deletedMethodlistAccount[delacc].name + "\n";
					}
				}
					aaaMethodAccountConfig += "exit\n";
			}
			if(aaaMethodAccountConfig != ""){
				aaaConfigCli += aaaMethodAccountConfig;
			}
		
			console.log(aaaConfigCli,"cli")
			/*AAA Method list account end here */
			if(userConfigCLI!=""){
				aaaConfigCli += userConfigCLI;
			}
			//AAA General ends here
			if(aaaConfigCli != ""){
				var result = requestRoutingService.getConfigCmdOutput(aaaConfigCli);
				if(result==""){
					notificationService.showNotification(translate('aaa_success_msg'),translate('com_config_success_title'),'success');
				}else{
					notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
				}
				if(isOneTimeGeneral){				
					AAA.aaaGeneral();
				}
				$scope.cancelRadiusServersGroup();
				if(aaaAuthConfig != ""){
					AAA.methodListAuthentication();
				}
				if(aaaAuthorConfig != ""){
					AAA.methodListAuthorization();
				}
				if(aaaServerLdapConfig!=""){
					AAA.loadserverLdap();
				}
				if(aaaMethodAccountConfig!=""){
					AAA.loadMethodListAccount();
				}
				if(userConfigCLI!=""){
					userConfigCLI="";
					userDetailsList();
				}
			}
		}
	}]);
