
app.register.controller('VlanCtrl', ['$scope','$rootScope','$timeout', '$filter', 'gridCrudService','executeCliCmdService','notificationService','dialogService','requestRoutingService','validationService',
	function($scope,$rootScope,$timeout, $filter, gridCrudService,executeCliCmdService,notificationService,dialogService,requestRoutingService,validationService) {
		var translate = $filter("translate");
		var trimVal=$filter('trimValue'), maxVlan;
		if( $rootScope.deviceInfo.type == "WS-C2960L-24TQ-LL" || $rootScope.deviceInfo.type.indexOf("CDB")!=-1 ){
			maxVlan = 64;
		}else{
			maxVlan = 512;
		}
	/*************VLAN2 configuration controller code.***************/
		//Showing configured vlan list in the grid
		var showVlanBrList=[];
		var isEditModeFlag = false;
		$scope.loadVlanDetails = function(){
			$scope.vlanApplySection  = true;
			$scope.vlanDeleteSection = true;
			var strCLIOutput = deviceCommunicatorCLI.getExecCmdOutput("show vlan brief\n show ip dhcp snooping\n");
			//Vlan list of snooping enabled
			var vlanList= executeCliCmdService.getNextString(strCLIOutput[1],["configured on following VLANs:"],["DHCP snooping is operational"]);
			var vlanListNew=[];
			vlanList1=vlanList.split(',');
			for(var i=0;i<vlanList1.length;i++){
				if(vlanList1[i].indexOf("-")>-1){
					var lowEnd = Number(vlanList1[i].split('-')[0]);
					var highEnd = Number(vlanList1[i].split('-')[1]);
					for (var j = lowEnd; j <= highEnd; j++) {
						vlanListNew.push(j);
					}
				}else {
					vlanListNew.push(Number(vlanList1[i]));
				}
			}
			var finalVlanListNew1=[];
			for(var p=0;p<=vlanListNew.length-1;p++){
				if(!isNaN(vlanListNew[p])){
					finalVlanListNew1.push(vlanListNew[p]);
				}
			}
			var arrVlanBr=strCLIOutput[0].split("\n");
			for (var i=2; i < arrVlanBr.length; i++) {
				vlanPorts="";
				var arrInnerWords = arrVlanBr[i].split(" ");
				for (var k=0,j=1; k < arrInnerWords.length; k++) {
					if(arrInnerWords[k] == "") {
			 			continue;
		 			}
					if (j == 1) {
						vlanId=arrInnerWords[k];
						var vlandhcpsnooping = "Disabled";
						if(finalVlanListNew1.indexOf(parseFloat(vlanId)) > -1){
							vlandhcpsnooping = "Enabled";
						}else{
							vlandhcpsnooping = "Disabled";
						}
		 			} else if (j == 2) {
		 				vlanName=arrInnerWords[k];
		 			} else if (j == 3) {
		 				vlanStatus=arrInnerWords[k];
		 				if(vlanStatus.indexOf("act/unsup")>-1){
		 					vlanStatus="unsupported";
						}
		 			} else {
		 				vlanPorts+=arrInnerWords[k]+" ";
		 			}
		 		   	j++;
				}
				var items = {
    					"vlan"   : vlanId,
    					"name"   : vlanName,
    					"status" : vlanStatus,
    					"ports"  : vlanPorts,
						"dhcpSnooping" : vlandhcpsnooping
    			};
				showVlanBrList.push(items);
				if(isEditModeFlag){
					return;
				}
			}
			var ipDhcpSnoopingStatus= executeCliCmdService.getNextString(strCLIOutput[1],["Switch DHCP snooping is"],["Switch DHCP gleaning is"]);
			// ip dhcp status
			if(trimVal(ipDhcpSnoopingStatus)=="enabled"){
				$timeout(function() {
					$scope.ipDhcpStatus="on";
				}, 0);
			}
			else{
				$timeout(function() {
					$scope.ipDhcpStatus="off";
				}, 0);
			}
			$scope.vlanData = new kendo.data.ObservableArray(showVlanBrList);
			$scope.vlanDataSource = new kendo.data.DataSource({
				pageSize : 10,
				data : $scope.vlanData
			});
	        $scope.layer2VlanGridOptions = {
				dataSource: $scope.vlanDataSource,
				editable : false,
				sortable : true,
				change : showVlanEdit,
				filterable : {
					extra : false,
					operators : {
						string : {
							eq : translate("com_is_equal"),
							neq : translate("com_isnot_equal")
						}
					},
					messages : {
			            info: translate("com_page_dropDowntext"),
			            filter: translate("com_btn_filter"),
			            clear: translate("com_btn_clear")
			        }
				},
				scrollable : false,
				selectable : true,
				pageable : {
					messages: {
						  display: translate("com_page_display"),
						  empty: translate("com_page_empty"),
						  page: translate("com_page_pagetext"),
						  of:translate("com_page_of"),
						  itemsPerPage: translate("com_page_itemsPerPage"),
						  first: translate("com_page_first"),
						  previous: translate("com_page_previous"),
						  next: translate("com_page_next"),
						  last: translate("com_page_last"),
						  refresh: translate("com_page_refresh"),
						  morePages: translate("com_page_morePage")
					},
					previousNext : true,
					info : true,
					refresh : true,
					pageSizes : gridCrudService.grid_page_sizes,
					buttonCount : 5
				},
				columns : [{
                    "template": "<input type=\"checkbox\" ng-init=\"checked=false\" ng-model=\"checked\" ng-click=\"isVlanDeleteChecked(checked,dataItem)\"  ng-disabled=\"(dataItem.vlan==1 ||dataItem.vlan==1002||dataItem.vlan==1003||dataItem.vlan==1004||dataItem.vlan==1005)?true:false\"  />",
                    sortable: false,
                    width: 10
                },{
					field : "vlan",
					title : translate("vlan_id"),
					width : "10%"
				}, {
					field : "name",
					title : translate("com_name"),
					width : "20%"
				}, {
					field : "status",
					title : translate("com_status"),
					width : "10%"
				}, {
					field : "dhcpSnooping",
					title : translate("vlan_ip_dhcp_snooping"),
					width : "20%"
				},{
					field : "ports",
					title : translate("com_ports"),
					width : "50%"
				}]
			};
			if($scope.vlanData.length >= maxVlan){
				$scope.vlanAddSection = false;
			}else{
				$scope.vlanAddSection = true;
			}
        }
		var vlanEditData={
			vlan: null,
			name: null,
			status: translate("com_active"),
			dhcpSnooping: translate("com_enable")
		};
		//Edit vlan grid value
			$scope.vlanEditData = angular.copy(vlanEditData);
			$scope.vlanDirty="";
			var vlanConfigCLI="";
			var showVlanEdit = function(){
				angular.element("#vlanForm  span.k-tooltip-validation").hide();
				$scope.isEditModeFlag = true;
				var selected = this.dataItem(this.select());
				if (selected.vlan == 1 || selected.vlan == 1002 || selected.vlan == 1003 || selected.vlan == 1004 || selected.vlan == 1005) {
					$timeout(function(){
						$scope.vlanShowEditSection = false;
						$scope.vlanDeleteSection = true;
						$scope.vlanApplySection = true;
					});
				} else {
					$timeout(function(){
						$scope.vlanGridWindow.open().center();
						$scope.vlanShowEditSection = true;
						$scope.vlanIdState = true;
					});
				}
				$scope.vlanEditData.vlan = selected.vlan;
				$scope.vlanEditData.name = selected.name;
				$scope.vlanEditData.dhcpSnooping = selected.dhcpSnooping;
				if(selected.status=="active"){
					$scope.vlanEditData.status = translate("com_active");
				}else{
					$scope.vlanEditData.status = translate("com_suspended");
				}
				if($scope.vlanEditData.dhcpSnooping == translate("com_enabled")){
					$scope.vlanEditData.dhcpSnooping = translate("com_enable");
				}else{
					$scope.vlanEditData.dhcpSnooping = translate("com_disable");
				}
				$scope.vlanDirty=selected.dirty;
			};
		$scope.loadVlanDetails();
		$scope.saveVlanData = function(){
			if(vlanValidations.validate()){
				$scope.vlanApplySection = false;
				var status="";
				var edittedItem = $scope.layer2VlanGrid.dataItem($scope.layer2VlanGrid.select());
				if($scope.vlanDirty){  //add function
					if($scope.vlanEditData.status==translate("com_suspended")){
						status="suspend";
					}else{
						status="active";
					}
					vlanConfigCLI += "vlan "+$scope.vlanEditData.vlan+"\n";
					vlanConfigCLI += "name "+$scope.vlanEditData.name+"\n";
					if($scope.vlanEditData.status==translate("com_suspended")){
						vlanConfigCLI += "state suspend \n";
					}else{
						vlanConfigCLI += "state active \n";
					}
					if($scope.vlanEditData.dhcpSnooping == translate("com_enable")){
						$scope.vlanEditData.dhcpSnooping = translate("com_enabled");
						vlanConfigCLI += "ip dhcp snooping vlan "+$scope.vlanEditData.vlan+"\n";
					}else{
						vlanConfigCLI += "no ip dhcp snooping vlan "+$scope.vlanEditData.vlan+"\n";
						$scope.vlanEditData.dhcpSnooping = translate("com_disabled");
					}
					$scope.layer2VlanGrid.dataSource.add({"vlan": $scope.vlanEditData.vlan,"name": $scope.vlanEditData.name,"status": status,"dhcpSnooping": $scope.vlanEditData.dhcpSnooping});
				}else{ //for edit
					prevVlan = edittedItem.vlan;
					prevName = edittedItem.name;
					prevDhcpSnooping = edittedItem.dhcpSnooping;
					prevstatus = edittedItem.status;
					var selectedItem = $scope.layer2VlanGrid.dataItem($scope.layer2VlanGrid.select());
					selectedItem.vlan = $scope.vlanEditData.vlan;
					selectedItem.name = $scope.vlanEditData.name;
					if($scope.vlanEditData.status==translate("com_suspended")){
						status="suspend";
					}else{
						status="active";
					}
					selectedItem.status = status;
					if($scope.vlanEditData.dhcpSnooping==translate("com_enable")){
						dhcpSnooping=translate("com_enabled");
					}else{
						dhcpSnooping=translate("com_disabled");
					}
					selectedItem.dhcpSnooping = dhcpSnooping;
					vlanConfigCLI += "vlan "+$scope.vlanEditData.vlan+"\n";
					if(prevName != $scope.vlanEditData.name){
						vlanConfigCLI += "name "+$scope.vlanEditData.name+"\n";
					}
					if($scope.vlanEditData.status != prevstatus.charAt(0).toUpperCase() + prevstatus.slice(1)){
						if($scope.vlanEditData.status==translate("com_suspended")){
							vlanConfigCLI += "state suspend \n";
						}else{
							vlanConfigCLI += "state active \n";
						}
					}
					if(prevDhcpSnooping == translate("com_enable")){
						prevDhcpSnooping = translate("com_enabled");
					}
					else{
						prevDhcpSnooping = translate("com_disabled");
					}
					if($scope.vlanEditData.dhcpSnooping != prevDhcpSnooping){
						if($scope.vlanEditData.dhcpSnooping == translate("com_enable")){
							vlanConfigCLI += "ip dhcp snooping vlan "+$scope.vlanEditData.vlan+"\n";
						}else{
							vlanConfigCLI += "no ip dhcp snooping vlan "+$scope.vlanEditData.vlan+"\n";
						}
					}
				}
				$scope.applyVlan2Layer();
				$scope.vlanGridWindow.close();
				$scope.vlanEditData.vlan = null;
				$scope.vlanEditData.name = null;
				$scope.vlanEditData.status = translate("com_active");
				$scope.vlanShowEditSection = false;
				if($scope.layer2VlanGrid.dataSource._total >= maxVlan){
					$scope.vlanAddSection = false;
				}else{
					$scope.vlanAddSection = true;
				}
			}
		}
		$scope.delVlanArray = [];
        $scope.isVlanDeleteChecked = function(checked, dataItem) {
            if (checked == false) {
                var index = $scope.delVlanArray.indexOf(dataItem);
                if (index > -1) {
                    $scope.delVlanArray.splice(index, 1);
                }
            } else {
                $scope.delVlanArray.push(dataItem);
            }
            if ($scope.delVlanArray.length > 0) {
                $scope.vlanDeleteSection = false;
            } else {
                $scope.vlanDeleteSection = true;
            }
        };
		$scope.$on("okDeleteVlan", function() {
            $scope.dlg.data("kendoWindow").close();
            $scope.deleteVlanRow();
        });
		//Confirmation Window For Delete VLAN Data.
        $scope.vlanDeleteConfirm = function() {
            $scope.dlg = dialogService.dialog({
                content: translate('msg_delete_confirmation'),
                title: translate('msg_delete_confirmation_window'),
                messageType: "confirm",
                actionButtons: [{
                    text: translate('com_ok'),
                    callback: "okDeleteVlan"
                }, {
                    text: translate('com_cancel'),
                    callback: "cancel"
                }]
            });
        };
		//Delete VLAN Data.
        $scope.deleteVlanRow = function() {
            $scope.vlanDeleteSection = true;
            var selectedItem = $scope.delVlanArray;
            $scope.delVlanArray = [];
            for (var i = 0; i < selectedItem.length; i++) {
                vlanConfigCLI += "no vlan " + selectedItem[i].vlan + " \n";
                $scope.layer2VlanGrid.dataSource.remove(selectedItem[i]);
            }
            $scope.vlanDeleteSection =true;
            $scope.applyVlan2Layer();
			$scope.vlanCancel();
			if($scope.layer2VlanGrid.dataSource._total >= maxVlan){
				$scope.vlanAddSection = false;
			}else{
				$scope.vlanAddSection = true;
			}
        }
		$scope.addVlanRow = function(){
			$scope.vlanEditData = angular.copy(vlanEditData);
			$scope.vlanShowEditSection = true;
			$scope.vlanDirty=true;
			$scope.vlanIdState = false;
			$scope.vlanDeleteSection = true;
			$scope.vlanEditData.status = translate("com_active");
			angular.element("#vlanForm  span.k-tooltip-validation").hide();
			$scope.vlanGridWindow.open().center();
			$scope.isEditModeFlag = false;
		};
		$scope.vlanCancel = function() {
			$timeout(function(){
				angular.element("#vlanForm  span.k-tooltip-validation").hide();
				$scope.vlanShowEditSection = false;
				$scope.vlanDeleteSection = true;
				$scope.vlanApplySection = true;
				$scope.vlanGridWindow.close();
				$scope.delVlanArray = [];
				angular.element('#layer2VlanGrid').data('kendoGrid').refresh();
			});
		};
		$scope.applyVlan2Layer=function(){
			var result = requestRoutingService.getConfigCmdOutput(vlanConfigCLI);
			if(result==""){
				notificationService.showNotification(translate('vlan_success_msg'),translate('com_config_success_title'),'success');
			}else{
				notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
			}
			vlanConfigCLI="";
			$scope.vlanApplySection  = true;
			isEditModeFlag = true;
			$scope.loadVlanDetails();
		}
		$timeout(function(){
            angular.element("#layer2VlanGrid").find('.k-pager-refresh').click(function(){
                $scope.manualGridRefresh();
            });
        },10);
		 $scope.manualGridRefresh = function(){
			angular.element("#layer2VlanGrid  span.k-tooltip-validation").hide();
			$scope.vlanShowEditSection = false;
			$scope.vlanDeleteSection = true;
			$scope.vlanApplySection = true;
		 }
		// Layer2 VLAN Form validation
		var vlanValidations = angular.element("#vlanForm").kendoValidator({
			rules: {
				duplicate:function(input){
					var valMsg = input.data('duplicateMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					if(!$scope.vlanDirty){
						return true;
					}
					var vlanGrid = angular.element("#layer2VlanGrid").data("kendoGrid");
					var vlanGridData = vlanGrid.dataSource.data();
					for(var i=0;i<vlanGridData.length;i++){
						vlanGridData[i];
						if(trimVal(input.val())== trimVal(vlanGridData[i].vlan)){
							return false;
						}
					}
					return true;
				},
				range: function (input) {
					var valMsg = input.data('rangeMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var min= input.prop('min');
					var max= input.prop('max');
					if(parseFloat(input.val())>=min && parseFloat(input.val())<=max){
						return true;
					}
					return false;
				},
				checkVlanName:function(input){
					var valMsg = input.data('checkVlanNameMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var regExp=/^[-]+$/;
					if(regExp.test(input.val()) || trimVal(input.val()) == ""){
						return false;
					}
					return true;
				}
			}
		}).data("kendoValidator");
		$scope.deleteConfirmation = function() {
			$scope.commonConfirmationVlan('delete');
		};

		$scope.commonConfirmationVlan = function() {
			$scope.dlgVlan = dialogService.dialog({
				content : translate("msg_delete_confirmation"),
				title : translate("msg_delete_confirmation_window"),
				messageType : "confirm",
				actionButtons : [{
					text : translate("com_ok"),
					callback : "vlanDeleteConfirmation"
				}, {
					text : translate("com_cancel")
				}]
			});
		};

		$scope.$on("vlanDeleteConfirmation", function() {
			$scope.deleteData($scope.dlgVlan.data("kendoWindow"));
		});

		//form validate
		var vlanListValidations = angular.element("#vlanListForm").kendoValidator({
			rules: {
				range: function (input) {
					var count=0;
					var min= input.prop('min');
					var max= input.prop('max');
					var vlanListNew=[];
					var vlanList1=input.val().split(',');
					for(var i=0;i<vlanList1.length;i++){
						if(vlanList1[i].indexOf("-")>-1){
							var lowEnd = Number(vlanList1[i].split('-')[0]);
							var highEnd = Number(vlanList1[i].split('-')[1]);
							for (var j = lowEnd; j <= highEnd; j++) {
								vlanListNew.push(j);
							}
						}else {
							vlanListNew.push(Number(vlanList1[i]));
						}
					}
					var finalVlanListNew1=[];
					for(var i1=0;i1<=vlanListNew.length-1;i1++){
						if(!isNaN(vlanListNew[i1])){
							finalVlanListNew1.push(vlanListNew[i1]);
						}
					}
					for(var i2=0;i2<finalVlanListNew1.length;i2++){
						if(parseFloat(finalVlanListNew1[i2])>=Number(min) && parseFloat(finalVlanListNew1[i2])<=Number(max)) {
						  count++;
					  }
					}
					if(finalVlanListNew1.length==count){
					return true;
					}
					return false;
				},
				duplicateRecord:function(input){
					if(!$scope.vlanListDirty){
						return true;
					}
					var ipDhGrid = angular.element("#ipDhcpSnnopingGrid").data("kendoGrid");
					var ipDhData = ipDhGrid.dataSource.data();
					var newipDhData=[];
					for(var i=0;i<ipDhData.length;i++){
						newipDhData[i]=ipDhData[i].VlanList;
					}
					var arr= input.val().split(',');
					for (var i1 = 0; i1 < arr.length; i1++) {
						for (var j = 0; j < newipDhData.length; j++) {
							if (arr[i1] == newipDhData[j]) {
								return false;
							}
						}
					}
					return true;
				},
				checkVlanList:function(input){
					var valMsg = input.data('checkVlanListMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var regExp=/^[,-]+$/;
					var valStrHy=input.val().includes("--");
					var valStrCom=input.val().includes(",,");
					if(regExp.test(input.val()) || valStrHy || valStrCom || trimVal(input.val()) == ""){
						return false;
					}
					return true;
				}
			}
		}).data("kendoValidator");
		//form validate
		var vlanGroupFormValidate = angular.element("#vlanGroupForm").kendoValidator({
			rules: {
				duplicate:function(input){
					var valMsg = input.data('duplicateMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					if(!$scope.vlanGrpDirty){
						return true;
					}
					var vlanGroupGrid = angular.element("#vlanGroupGrid").data("kendoGrid");
					var vlanGroupGridData = vlanGroupGrid.dataSource.data();
					for(i=0;i<vlanGroupGridData.length;i++){
						if(input.val()== vlanGroupGridData[i].VlanGroup){
							return false;
						}
					}
						return true;
				},
				checkvlangroup:function(input){
					var valMsg = input.data('checkvlangroupMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var regExp=/^[0-9-]+$/;
					if(regExp.test(input.val())){
						return false;
					}
					return true;
				},
				range: function (input) {
					var count=0;
					var valMsg = input.data('rangeMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var min= trimVal(input.prop('min'));
					var max= trimVal(input.prop('max'));
					var arr = input.val().replace('-',',');
					arr= arr.split(',');
					for(var i=0;i<arr.length;i++){
						if(parseFloat(trimVal(arr[i]))>=min && parseFloat(trimVal(arr[i]))<=max) {
							count++;
						}
					}
					if(arr.length!=count){
						return false;
					}
					return true;
				},
				checkVlanList:function(input){
					var valMsg = input.data('checkVlanListMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					var regExp=/^[,-]+$/;
					var valStrHy=input.val().includes("--");
					var valStrCom=input.val().includes(",,");
					if(regExp.test(input.val()) || valStrHy || valStrCom || trimVal(input.val()) == ""){
						return false;
					}
					return true;
				},
				domainspace: function(input){
				  var valMsg = input.data('domainspaceMsg');
					if ((valMsg==undefined)) {
						return true;
					}
					if(/\s/g.test(input.val())){
					  return false;
					}
					return true;
				}
			}
		}).data("kendoValidator");
		//controller code for vlan group page
		$scope.showVlanGroups = true;
		$scope.vlanGrpData = [];
		if( ($rootScope.deviceInfo.type.indexOf("2960X")!=-1 && $rootScope.deviceInfo.type.indexOf("-LL")!=-1) ||
			    ($rootScope.deviceInfo.type.indexOf("2960+")!=-1 && $rootScope.deviceInfo.type.indexOf("-S")!=-1) ||
				($rootScope.deviceInfo.type.indexOf("2960C")!=-1 && $rootScope.deviceInfo.type.indexOf("-S")!=-1)){
            $scope.showVlanGroups = false;
		}else{
			var showVlanGrp = requestRoutingService.getShowCmdOutput("show vlan group","showVlanGroup");
			if(showVlanGrp.ShowVlanGroup.entry){
				showVlanGrp = showVlanGrp.ShowVlanGroup.entry;
				if (typeof showVlanGrp == "object" && !showVlanGrp.length){
					showVlanGrp = [showVlanGrp];
				}
			}else {
				showVlanGrp=[];
			}
			$scope.vlanGrpData = new kendo.data.ObservableArray(showVlanGrp)
		}
		var vlanGrpEditData={
			VlanGroup: null,
			VlanList: null
		};
		$scope.vlanGrpEditData = angular.copy(vlanGrpEditData);
		$scope.vlanGrpDirty="";
		$scope.vlanGrpDelBtn=true;
		$scope.disVlanGrpApplyBtn=true;
		var vlanGroupConfigCLI="";
		// Edit vlan Group
		var showVlanGrpEdit = function(){
			$scope.kendoWindow.isEditMode = false;
			var selected = this.dataItem(this.select());
			$timeout(function(){$scope.vlanGrpShowEditSection = true});
			$scope.vlanGrpEditData.VlanGroup = selected.VlanGroup;
			$scope.vlanGrpEditData.VlanList = selected.VlanList;
			$scope.vlanGrpDirty=selected.dirty;
			$scope.vlanGroupDiv.open().center();
			$scope.vlanGrpDelBtn=true;
		};
		//Save vlan group
		$scope.saveVlanGrpData = function() {
			if (vlanGroupFormValidate.validate()) {
				if ($scope.vlanGrpDirty) {
						$scope.vlanGroupGrid.dataSource.add({
							"VlanGroup": $scope.vlanGrpEditData.VlanGroup,
							"VlanList": $scope.vlanGrpEditData.VlanList
						});

				} else {
					var selectedItem = $scope.vlanGroupGrid.dataItem($scope.vlanGroupGrid.select());
					vlanGroupConfigCLI += "no vlan group" + " " + selectedItem.VlanGroup + " " + "vlan-list" + " " + selectedItem.VlanList + "\n";
					selectedItem.VlanGroup = $scope.vlanGrpEditData.VlanGroup;
					selectedItem.VlanList = $scope.vlanGrpEditData.VlanList;
				}
				$scope.vlanGrpShowEditSection = false;
				$scope.disVlanGrpApplyBtn = false;
				vlanGroupConfigCLI += "vlan group" + " " + $scope.vlanGrpEditData.VlanGroup + " " + "vlan-list" + " " + $scope.vlanGrpEditData.VlanList + "\n";
				$scope.vlanGroupApplyBtn();
				$scope.vlanGroupDiv.close();
			}
		}
		// Cancel Vlan Group
		$scope.cancelVlanGrpData=function(){
			$scope.vlanGroupDiv.close();
			$scope.vlanGrpShowEditSection = false;
		};
		$scope.delVlanGroupArray = [];
		$scope.isVlanGroupChecked = function(checked, dataItem) {
		if (checked == false) {
                    var index = $scope.delVlanGroupArray.indexOf(dataItem);
                    if (index > -1) {
                        $scope.delVlanGroupArray.splice(index, 1);
                    }
                } else {
                    $scope.delVlanGroupArray.push(dataItem);
                }
                if ($scope.delVlanGroupArray.length > 0) {
                    $scope.vlanGrpDelBtn= false;
                }else {
                    $scope.vlanGrpDelBtn= true;
                }
		}
		//Confirmation Window For Delete Vlan Group Data.
		$scope.delConfirmationWindow = function(){
			$scope.dlg = dialogService.dialog({
				content : translate('msg_delete_confirmation'),
				title : translate('msg_delete_confirmation_window'),
				messageType : "confirm",
				actionButtons : [{
					text : translate('com_ok'),
					callback : "okDelete"
				}, {
					text : translate('com_cancel'),
					callback : "cancel"
				}]
			});
		};
		 $scope.$on("okDelete", function() {
                $scope.dlg.data("kendoWindow").close();
                $scope.delVlanGrpRow();
            });
		$scope.$on("cancel", function() {
                $scope.dlg.data("kendoWindow").close();
				$scope.vlanGrpDelBtn = true;
				angular.element("#vlanGroupGrid").data('kendoGrid').refresh();
            });
		// Delete vlan group
		$scope.delVlanGrpRow=function(){
			$scope.vlanGrpDelBtn=true;
			var selectedItem = $scope.delVlanGroupArray;
			$scope.delVlanGroupArray = [];
			 for (var i = 0; i < selectedItem.length; i++) {
                vlanGroupConfigCLI+="no vlan group"+" "+selectedItem[i].VlanGroup+" "+"vlan-list"+" "+selectedItem[i].VlanList+"\n";
                $scope.vlanGroupGrid.dataSource.remove(selectedItem[i]);
			}
			$scope.vlanGrpShowEditSection = false;
            $scope.vlanGroupApplyBtn();
		};
		// Add vlan group row
		$scope.addVlanGrpRow = function(){
			$scope.kendoWindow.isEditMode = true;
			$scope.vlanGroupDiv.open().center();
			$scope.vlanGrpEditData = angular.copy(vlanGrpEditData);
			$scope.vlanGrpShowEditSection = true;
			$scope.vlanGrpDirty=true;
			angular.element("#vlanGroupForm  span.k-tooltip-validation").hide();
		};
		// Apply valn group configurations
		$scope.vlanGroupApplyBtn=function(){
			var result = requestRoutingService.getConfigCmdOutput(vlanGroupConfigCLI);
			if(result==""){
				notificationService.showNotification(translate('vlan_success_msg'),translate('com_config_success_title'),'success');
			}else{
				notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
			}
			$scope.disVlanGrpApplyBtn=true;
		}
		// Vlan group Grid starts here
		$scope.gridDataSource2 = new kendo.data.DataSource({
			pageSize : 10,
			data : $scope.vlanGrpData
		});
		$scope.vlanGroupGridOptions = {
			dataSource: $scope.gridDataSource2,
			editable : false,
			sortable : true,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
						neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			change	:showVlanGrpEdit,
			scrollable : false,
			selectable : true,
			pageable : {
				messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			columns : [{
                        "template" : "<input type=\"checkbox\" ng-init=\"checked=false\" ng-model=\"checked\" ng-click=\"isVlanGroupChecked(checked,dataItem)\"  />",
                        sortable : false,
                        width : 10
                    },{
						field : "VlanGroup",
						title : translate("vlan_group_name")
					}, {
						field : "VlanList",
						title : translate("vlan_list")
					}]
		};
		// Controller for Valn List page
		$scope.ipDhcpStatus="on";
		$scope.vlanListDelBtn=true;
		$scope.disVlanListApplyBtn=true;

		// Fetching vlan list grid data
		var showIPDhcpSnooping = deviceCommunicator.getExecCmdOutput("show ip dhcp snooping");
		var START_INPUT= ["configured on following VLANs:"];
		var END_INPUT= ["DHCP snooping is operational"];
		var vlanList= executeCliCmdService.getNextString(showIPDhcpSnooping,START_INPUT,END_INPUT);
		// Fetching ip dhcp status
		var ipDhcpStart= ["Switch DHCP snooping is"];
		var ipDhcpEnd= ["Switch DHCP gleaning is"];
		var newIpDhcpStatus= executeCliCmdService.getNextString(showIPDhcpSnooping,ipDhcpStart,ipDhcpEnd);
		// ip dhcp status
		if(trimVal(newIpDhcpStatus)=="enabled"){
			$timeout(function() {
				$scope.ipDhcpStatus="on";
			}, 0);
		}
		else{
			$timeout(function() {
				$scope.ipDhcpStatus="off";
			}, 0);
		}
		// Vlan List edit grid data
		var vlanListEditData={
			VlanList: null
		};
		$scope.vlanListEditData = angular.copy(vlanListEditData);
		$scope.vlanListDirty="";
		var vlanListConfigCLI="";
		// ip dhcp status toggle button
		$scope.ipDhcpToggleBtn=function(){
			$scope.disVlanListApplyBtn=false;
			if($scope.ipDhcpStatus==translate("com_enable")){
				vlanListConfigCLI+="ip dhcp snooping"+"\n";
			}else{
				vlanListConfigCLI+="no ip dhcp snooping"+"\n";
			}
		};
		var vlanListNew=[];
		vlanList1=vlanList.split(',');
		for(var i=0;i<vlanList1.length;i++){
			if(vlanList1[i].indexOf("-")>-1){
				var lowEnd = Number(vlanList1[i].split('-')[0]);
				var highEnd = Number(vlanList1[i].split('-')[1]);
				for (var j = lowEnd; j <= highEnd; j++) {
					vlanListNew.push(j);
				}
			}else {
				vlanListNew.push(Number(vlanList1[i]));
			}
		}
		var finalVlanListNew1=[];
		for(var i4=0;i4<=vlanListNew.length-1;i4++){
			if(!isNaN(vlanListNew[i4])){
				finalVlanListNew1.push({VlanList:vlanListNew[i4]});
			}
		}
		$scope.vlanListData = new kendo.data.ObservableArray(finalVlanListNew1);
		// vlan list edit record
		var showVlanListEdit = function(){
			var selected = this.dataItem(this.select());
			$timeout(function(){$scope.vlanListShowEditSection = true});
			$scope.vlanListEditData.VlanList = selected.VlanList;
			$scope.vlanListDirty=selected.dirty;
			$scope.vlanListDelBtn=false;
		};
		// vlan list save records
		$scope.saveVlanListData = function(){
			if(vlanListValidations.validate()){
				if($scope.vlanListDirty){
					var vlanList=$scope.vlanListEditData.VlanList.split(',');
					var vlanListNew=[];
					for(var i=0;i<vlanList.length;i++){
						if(vlanList[i].indexOf("-")>-1){
							var lowEnd = Number(vlanList[i].split('-')[0]);
							var highEnd = Number(vlanList[i].split('-')[1]);
							for (var j = lowEnd; j <= highEnd; j++) {
								vlanListNew.push(j);
							}
						}else {
							vlanListNew.push(Number(vlanList[i]));
						}
					}
					for(var i1=0;i1<=vlanListNew.length-1;i1++){
						$scope.ipDhcpSnnopingGrid.dataSource.add({"VlanList": vlanListNew[i1]});
					}
				}else{
					var selectedItem = $scope.ipDhcpSnnopingGrid.dataItem($scope.ipDhcpSnnopingGrid.select());
					vlanListConfigCLI+="no ip dhcp snooping vlan"+" "+ trimVal(selectedItem.VlanList)+"\n";
					selectedItem.VlanList = $scope.vlanListEditData.VlanList;
				}
				var newVlanList=$scope.vlanListEditData.VlanList.split(', ').join(',');
				vlanListConfigCLI+="ip dhcp snooping vlan"+" "+newVlanList+"\n";
				$scope.vlanListShowEditSection = false;
				$scope.disVlanListApplyBtn=false;
			}
		}
		// Cancel Vlan Group
		$scope.cancelVlanListData=function(){
			$scope.vlanListShowEditSection = false;
		};
		// vlan list delete record
		$scope.delVlanListRow=function(){
			var selectedItem = $scope.ipDhcpSnnopingGrid.dataItem($scope.ipDhcpSnnopingGrid.select());
			vlanListConfigCLI+="no ip dhcp snooping vlan"+" "+selectedItem.VlanList+"\n";
			$scope.ipDhcpSnnopingGrid.dataSource.remove(selectedItem);
			$scope.vlanListShowEditSection = false;
			$scope.vlanListDelBtn=true;
			$scope.disVlanListApplyBtn=false;
		};
		// vlan list add record
		$scope.addVlanListRow = function(){
			$scope.vlanListEditData = angular.copy(vlanListEditData);
			$scope.vlanListShowEditSection = true;
			$scope.vlanListDirty=true;
			angular.element("#vlanListForm  span.k-tooltip-validation").hide();
		};
		// vlan list apply configurations
		$scope.vlanListApplyBtn=function(){
			var result = requestRoutingService.getConfigCmdOutput(vlanListConfigCLI);
			if(result==""){
				notificationService.showNotification(translate('vlan_success_msg'),translate('com_config_success_title'),'success');
			}else{
				notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
			}
			$scope.disVlanListApplyBtn=true;
		}
		// Vlan list grid starts here
		$scope.gridDataSource = new kendo.data.DataSource({
			pageSize : 10,
			data : $scope.vlanListData
		});
		$scope.ipDhcpSnnopingGridOptions = {
			dataSource: $scope.gridDataSource,
			editable : false,
			sortable : true,
			filterable : {
				extra : false,
				operators : {
					string : {
						eq : translate("com_is_equal"),
						neq : translate("com_isnot_equal")
					}
				},
				messages : {
		            info: translate("com_page_dropDowntext"),
		            filter: translate("com_btn_filter"),
		            clear: translate("com_btn_clear")
		        }
			},
			change	:showVlanListEdit,
			scrollable : false,
			selectable : true,
			pageable : {
				messages: {
					  display: translate("com_page_display"),
					  empty: translate("com_page_empty"),
					  page: translate("com_page_pagetext"),
					  of:translate("com_page_of"),
					  itemsPerPage: translate("com_page_itemsPerPage"),
					  first: translate("com_page_first"),
					  previous: translate("com_page_previous"),
					  next: translate("com_page_next"),
					  last: translate("com_page_last"),
					  refresh: translate("com_page_refresh"),
					  morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			columns : [{
				field : "VlanList",
				title : translate("vlan_list")
			}]
		};
		$scope.tabChange = function(tab){
			$scope[tab] = false;
		}
	// sviconfig start here
		$scope.sviDelBtn = true;
        // Edit SVI
        var sviCli = "";
        var editVlan = "";
		var mtuHName="",sviHDescription=null,vlanHDhcp=null,vlanHIP=null,dhcpHRelay="Disable",adminHStatus="Up";
        $scope.kendoWindow = {
            isEditMode: true
        };
        //MTU field will be enabled if need in future
		if($rootScope.deviceInfo.type.indexOf("2960X")!=-1 || $rootScope.deviceInfo.type.indexOf("2960C")!=-1 ){
			$scope.vlanNumRangeUpto = "4094";
		}else{
			$scope.vlanNumRangeUpto = "4095";
		}
		$scope.mtuSize = true;
        $scope.showEditTabsOnClick = function(data) {
			angular.element("#sviQuicksetupForm  span.k-tooltip-validation").hide();
            $scope.vlanInterfaceName = true;
            $scope.kendoWindow.isEditMode = false;
            $scope.sviGridWindow.open().center();
            editVlan = data.interface;
            sviCli = "show running-config interface " + editVlan + "\n";
            var showEditData = deviceCommunicatorCLI.getExecCmdOutput(sviCli);
            var showSviData = showEditData[0].split("\n");
            $scope.sviDescription = "";
            $scope.dhcpRelay = translate("com_disable");
            $scope.vlanIP = "";
            $scope.vlanSubnet = "";
            $scope.vlanDhcp = "";
			$scope.vlanNumber = editVlan.substring(4);
            $scope.adminStatus = data.status.indexOf("down")!=-1 ? translate("toggle_down") : translate("toggle_up");
            for (var i = 0; i < showSviData.length; i++) {
                if (showSviData[i].indexOf("description") > 0) {
                    $scope.sviDescription = showSviData[i].substring(12);
					sviHDescription = $scope.sviDescription;
                }
                if (showSviData[i].indexOf("ip dhcp relay information trusted") > 0) {
                    $scope.dhcpRelay = translate("com_enable");
					dhcpHRelay = $scope.dhcpRelay;
                }
                if (showSviData[i].indexOf("no ip address") == -1 && showSviData[i].indexOf("ip address") > 0) {
                    var ipCheck = showSviData[i].split(" ");
                    $scope.vlanIP = ipCheck[3];
                    $scope.vlanSubnet = ipCheck[4];
					vlanHIP = $scope.vlanIP;
                }
                if (showSviData[i].indexOf("shutdown") > 0) {
                    $scope.adminStatus = translate("toggle_down");
					adminHStatus = $scope.adminStatus;
                }
                if (showSviData[i].indexOf("ip mtu") > 0) {
                    $scope.mtu = showSviData[i].substring(8);
					mtuHName = $scope.mtu;
                }
                if (showSviData[i].indexOf("ip helper-address") > 0) {
                    $scope.vlanDhcp = showSviData[i].substring(18).trim();
					vlanHDhcp = $scope.vlanDhcp;
                }
            }
        }
        $scope.addSviRow = function() {
			angular.element("#sviQuicksetupForm  span.k-tooltip-validation").hide();
            $scope.vlanInterfaceName = false;
            $scope.kendoWindow.isEditMode = true;
            $scope.sviGridWindow.open().center();
            $scope.vlanNumber = null;
            $scope.mtu = "";
            $scope.sviDescription = null;
            $scope.dhcpRelay = translate("com_disable");
            $scope.vlanIP = null;
            $scope.vlanSubnet = null;
            $scope.vlanDhcp = null;
            $scope.adminStatus= translate("toggle_up");
        }
        $scope.cancelSviData = function() {
            $scope.sviGridWindow.close();
        }
        //Save SVI Data
        var sviConfigCLI = "";
        $scope.saveSviData = function(data) {
			if(data=='edit'){
					$scope.vlanNumber = editVlan.substring(4);
				}
			if($scope.sviValidator.validate()){
				var mtuName = $scope.mtu;
				var sviDesc = $scope.sviDescription;
				var vlanIpAddress = $scope.vlanIP;
				var vlanSubnetMask = $scope.vlanSubnet;
				var vlanDhcpServer = $scope.vlanDhcp;
				var vlanAdminStatus = $scope.adminStatus;
				sviConfigCLI = "interface vlan " + $scope.vlanNumber + " \n";
				if(mtuName!=mtuHName && mtuName != undefined){
					if (mtuName != "") {
						sviConfigCLI += "ip mtu " + mtuName + " \n";
					} else {
						sviConfigCLI += "no ip mtu \n";
					}
					mtuHName = "";
				}
				if(sviDesc != sviHDescription && sviDesc!=""){
				if (sviDesc) {
					sviConfigCLI += "description " + sviDesc + " \n";
				} else {
					sviConfigCLI += "no description \n";
				}
				sviHDescription = null;
				}
				if($scope.dhcpRelay!=dhcpHRelay){
				if ($scope.dhcpRelay == translate("com_enable")){
					sviConfigCLI += "ip dhcp relay information trusted \n"
				}
				else{
					sviConfigCLI += "no ip dhcp relay information trusted \n"
				}
				dhcpHRelay = "Disable";
				}
				if(vlanIpAddress != vlanHIP){
				if (vlanIpAddress) {
					sviConfigCLI += "ip address " + vlanIpAddress + " " + vlanSubnetMask + "  \n";
				}
				vlanHIP = null;
				}
				
				if(vlanDhcpServer != vlanHDhcp && vlanDhcpServer!=""){
				if(vlanDhcpServer){
				   sviConfigCLI += "no ip helper-address \n";				
				   sviConfigCLI += "ip helper-address " + vlanDhcpServer + "\n";
				}				
				else{
					sviConfigCLI += "no ip helper-address \n";
				}
				vlanHDhcp = null;
				}
				if(vlanAdminStatus!=adminHStatus){
				if (vlanAdminStatus === "Up") {
					sviConfigCLI += "no shutdown \n";
				} else {
					sviConfigCLI += "shutdown \n";
				}
				adminHStatus="Up";
				}
				cliPush(sviConfigCLI);
				if(data=='add'){
					$scope.sviGrid.dataSource.add({
						"interface": "Vlan" + vlanName,
						"status": vlanAdminStatus.toLowerCase(),
						"operstatus": "down",
						"ipaddress": vlanIpAddress,
						"description": sviDesc
					});
				}
				else{
					var selectedItem = $scope.sviGrid.dataItem($scope.sviGrid.select());
					selectedItem.description = sviDesc;
					selectedItem.ipaddress = vlanIpAddress;
					selectedItem.status = vlanAdminStatus.toLowerCase();
				}
				$scope.sviGridWindow.close();
			}
        }
		$scope.manualSVIGridRefresh = function(){
			$scope.sviDelBtn = true;
			$scope.delSviArray = [];
			if (!$scope.$$phase){
				$scope.$apply();
			}
		}
        // Delete functionality
        $scope.delSviArray = [];
        $scope.isDeleteChecked = function(checked, dataItem) {
            if (checked == false) {
                var index = $scope.delSviArray.indexOf(dataItem);
                if (index > -1) {
                    $scope.delSviArray.splice(index, 1);
                }
            } else {
                $scope.delSviArray.push(dataItem);
            }
            if ($scope.delSviArray.length > 0) {
                $scope.sviDelBtn = false;
            } else {
                $scope.sviDelBtn = true;
            }
        };
        $scope.$on("okDelete", function() {
            $scope.dlg.data("kendoWindow").close();
            $scope.deleteSviRow();
        });
        //Delete SVI Data.
        $scope.deleteSviRow = function() {
            $scope.sviDelBtn = true;
            var selectedItem = $scope.delSviArray;
            $scope.delSviArray = [];
            var sviDeleteCLI = ""
            for (var i = 0; i < selectedItem.length; i++) {
                sviDeleteCLI += "no interface " + selectedItem[i].interface + " \n";
                $scope.sviGrid.dataSource.remove(selectedItem[i]);
            }
            cliPush(sviDeleteCLI);
        }
        //Device cli push and Toaster messages
        function cliPush(cli) {
			if(cli != ""){
				var result = requestRoutingService.getConfigCmdOutput(cli);
				if (result == "") {
					notificationService.showNotification(translate('svi_config_success_msg'), translate('com_config_success_title'), 'success');
				} else {
					notificationService.showNotification(result.errorResponse, translate('com_config_fail_title'), 'error');
				}
				$scope.vlanInterface();
			}
        }
        $scope.$on("cancel", function() {
			isEditModeFlag = true;
            $scope.dlg.data("kendoWindow").close();
			$scope.vlanDeleteSection = true;
			angular.element('#layer2VlanGrid').data('kendoGrid').refresh();
			$scope.sviDelBtn = true;
			$scope.delVlanArray = [];
			angular.element('#sviGrid').data('kendoGrid').refresh();
        });
        //Confirmation Window For Delete SVI Data.
        $scope.sviDeleteConfirm = function() {
            $scope.dlg = dialogService.dialog({
                content: translate('svi_delete_confirmation'),
                title: translate('msg_delete_confirmation_window'),
                messageType: "confirm",
                actionButtons: [{
                    text: translate('com_ok'),
                    callback: "okDelete"
                }, {
                    text: translate('com_cancel'),
                    callback: "cancel"
                }]
            });
        };
        $scope.sviGridOptions = {
            editable: false,
            sortable: true,
            filterable: {
                extra: false,
                operators: {
                    string: {
                        eq: translate("com_is_equal"),
                        neq: translate("com_isnot_equal")
                    }
                },
                messages: {
                    info: translate("com_page_dropDowntext"),
                    filter: translate("com_btn_filter"),
                    clear: translate("com_btn_clear")
                }
            },
            scrollable: false,
            selectable: true,
            pageable: {
                messages: {
                    display: translate("com_page_display"),
                    empty: translate("com_page_empty"),
                    page: translate("com_page_pagetext"),
                    of: translate("com_page_of"),
                    itemsPerPage: translate("com_page_itemsPerPage"),
                    first: translate("com_page_first"),
                    previous: translate("com_page_previous"),
                    next: translate("com_page_next"),
                    last: translate("com_page_last"),
                    refresh: translate("com_page_refresh"),
                    morePages: translate("com_page_morePage")
                },
                previousNext: true,
                info: true,
                pageSizes: gridCrudService.grid_page_sizes,
                buttonCount: 5
            },
            columns: [{
                    "template": "<input type=\"checkbox\" ng-init=\"checked=false\" ng-model=\"checked\" ng-click=\"isDeleteChecked(checked,dataItem)\"  ng-disabled=\"dataItem.interface=='Vlan1'?true:false\"  />",
                    sortable: false,
                    width: 10
                },
                {
                    field: "interface",
                    title: translate("com_name")
                },
                {
                    field: "status",
                    title: translate("svi_admin_status"),
                    attributes: {
                        style: "text-align:center"
                    },
                    template: '<i class=\"fa fa-arrow-circle-#=status# fa-lg\" style=color:#=status==="up"?"green":"red"#></i>'
                }, {
                    field: "operstatus",
                    title: translate("svi_opl_status"),
                    attributes: {
                        style: "text-align:center"
                    },
                    template: '<i class=\"fa fa-arrow-circle-#=operstatus# fa-lg\" style=color:#=operstatus==="up"?"green":"red"#></i>'
                }, {
                    field: "ipaddress",
                    title: translate("portconfig_port_ipv4_ip")
                }, {
                    field: "description",
                    title: translate("portconfig_general_description")
                }
            ]
        };
		// svi validation
        $scope.sviValidations = {
            rules : {
				validateip : function(input) {
					if(input.val()){
						if (angular.isUndefined(input.data('validateIp'))) {
							return true;
						}
						if (validationService.validateIPAddress(input)) {
							return true;
						}
						else {
							return false;
						}
					}
					return true;
                },
				validatesubnet: function(input){
					if(input.val() === "0.0.0.0" || input.val() === "255.255.255.255"){
						return true;
					}
					else{
						return input.data('validatesubnetMsg') ? $scope.validateSubnetMask(input.val())  : true;
					}
				},
				range: function (input) {
                    if(input.val()){
                        if(input.val() != ""){
                            var count=0;
                            var valMsg = input.data('rangeMsg');
                            if ((valMsg==undefined)) {
                                return true;
                            }
                            var min= trimVal(input.prop('min'));
                            var max= trimVal(input.prop('max'));
                            var arr = input.val().replace('-',',');
                            arr= arr.split(',');
                            for(var i=0;i<arr.length;i++){
                                if(parseFloat(trimVal(arr[i]))>=min && parseFloat(trimVal(arr[i]))<=max) {
                                    count++;
                                }
                            }
                            if(arr.length!=count){
                                return false;
                            }
                            return true;
                        }
                        else {
							return true;
						}
                    }else{
                        return true;
                    }
                }
            }
        };
		$scope.validateSubnetMask = function(value) {
			if(value == undefined){
				return false;
			} else {
				var subnetRegex = "^((128|192|224|240|248|252|254)\.0\.0\.0)|(255\.(((0|128|192|224|240|248|252|254)\.0\.0)|(255\.(((0|128|192|224|240|248|252|254)\.0)|255\.(0|128|192|224|240|248|252|254)))))$";
				if (new RegExp(subnetRegex).test(value)) {
					return true;
				}
			}
			return false;
		};
		$scope.vlanInterface = function() {
            $scope.vlanInterfaceData = [];
            var portMonCLI = "show ip interface brief \n";
            var portMonCLIOP = deviceCommunicatorCLI.getExecCmdOutput(portMonCLI);
            var arrVlan = portMonCLIOP[0].split("\n"),findStatus = "",findPStatus = "";
            var shwRunVlanCLIOp = [];
            var vlanCLI = "";
            for (var i = 1; i < arrVlan.length; i++) {
                var portsObj = {};
                if (arrVlan[i].substring(0, 22).trim().indexOf("Vlan") != -1) {
                    portsObj["interface"] = arrVlan[i].substring(0, 22).trim();
                    vlanCLI += "show running-config interface " + portsObj["interface"] + "\n";
					if(arrVlan[i].substring(22, 39).trim().indexOf("unassigned") != -1){
						portsObj["ipaddress"] = translate("config_vlan_svi_unassigned");
					}else{
						portsObj["ipaddress"] = arrVlan[i].substring(22, 39).trim();
					}					
                    findStatus = arrVlan[i].substring(50, 72).trim();
                    findPStatus = arrVlan[i].substring(72, 95).trim();

                    if (findStatus.indexOf("up")!=-1) {
                        portsObj["status"] = "up";
                    } else {
                        portsObj["status"] = "down";
                    }
                    if (findPStatus.indexOf("up")!=-1) {
                        portsObj["operstatus"] = "up";
                    } else {
                        portsObj["operstatus"] = "down";
                    }
                    $scope.vlanInterfaceData.push(portsObj)
                }
            }
            var vlanShowRunOP = deviceCommunicatorCLI.getExecCmdOutput(vlanCLI);
            for (var i = 0; i < vlanShowRunOP.length; i++) {
                var vlanName = executeCliCmdService.getNextString(vlanShowRunOP[i], ["interface"], ["\n"]).trim();
                var vlanIndex = $scope.vlanInterfaceData.map(function(e) {
                    return e.interface;
                }).indexOf(vlanName);
                $scope.vlanInterfaceData[vlanIndex].description = executeCliCmdService.getNextString(vlanShowRunOP[i], ["description"], ["\n"]).trim();
            }
			$scope.vlanDataSource = new kendo.data.DataSource({
				pageSize: 10,
				data: $scope.vlanInterfaceData
			});
			$scope.manualSVIGridRefresh();
        }
        $scope.vlanInterface();
	// sviconfig end here
}]);
