<!-- Copyright (c) 2004, 2006-2011, 2013-2016 by Cisco Systems, Inc. -->
// discover.js for c3560 devices.

// c3560 models.
// WS-C3560-24PS, WS-C3560-48PS, WS-C3560G-24TS, WS-C3560G-48TS, WS-C3560G-24PS, WS-C3560G-48PS
// WS-C3560-24TS, WS-C3560-48TS,WS-C3560E-12D-S/E,Slinky
// Support added for EagleEye Layer 3 SKUs SM-ES3-16-P, SM-ES3G-16-P, SM-ES3-24-P, SM-ES3G-24-P, SM-D-ES3-48-P, SM-D-ES3G-48-P
// Support added for Lebwoski Layer 3 SKUs SM-X-ES3-16-P, SM-X-ES3-24-P, SM-X-ES3D-48-P
/* Added support for  Incredible-Elastigirl Catalyst 3560 X Series
	Elastigirl 24 data WS-C3560X-24
	Elastigirl 48 data WS-C3560X-48
	Elastigirl 24 PoE+ WS-C3560X-24P
	Elastigirl 48 PoE+ WS-C3560X-48P */

/*Added support for Sake Junmai SKUs
	Junmai8PWR  	WS-C3560CG-8PC-S
	Junmai83k 	    WS-C3560CG-8TC-S
*/
//////////////////////////////////////////////////////////////////////////////////////////////

function WSC356024P(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356024_2p.gif";

	drawLeds_withPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 62;
	var xPortStartPos = 115;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 25;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 GBIC ports.
	xPortCoord = 549;
	xPortGap = 22;
	portWidth = 21;
	for(i=24; i<26; i++) {     
		yPortCoord = 38;		
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

function WSC356048P(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356048_4p.gif";

	drawLeds_withPoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 11;
	yPortCoord = 26;
	portWidth = 21;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	return dev;
}

function WSC3560G244TS(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3560G24_4TS.gif";

	drawLeds_withoutPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 38;
	var xPortStartPos = 287;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	yPortCoord = 26;
	for(i=24; i<28; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}


function WSC3560G484TS(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3560G48_4TS.gif";

	drawLeds_withoutPoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	yPortCoord = 26;
        portWidth = 21;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	return dev;
}


function WSC3560G244PS(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356024g_4p.gif";

	drawLeds_withPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 38;
	var xPortStartPos = 287;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	yPortCoord = 26;
	for(i=24; i<28; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}


function WSC3560G484PS(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3560g48_4p.gif";

	drawLeds_withPoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	yPortCoord = 26;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	return dev;
}

function WSC3560G242T(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356024_2T.gif";

	drawLeds_withoutPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 38;
	var xPortStartPos = 287;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	yPortCoord = 37;
	for(i=24; i<26; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		yPortCoord = 37;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function WSC3560484T(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c356048_4T.gif";

	drawLeds_withoutPoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 7;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 3 groups of 16 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
    }

	// Add the 4 SFP ports.
	xPortCoord = 578;
	xPortGap = 15;
	yPortCoord = 26;
        portWidth = 21;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 26;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	return dev;
}

function WSC35608PC(int_status, media_type) {
	var dev = new top.device();

	dev.noofports = 9;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3560_8_1.gif";

	drawLeds_pilsner2_PoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 8 FastEthernet ports. 
	for(i=0; i<8; i++) {       
		yPortCoord = 57;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
				
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
    }
	//Add one composite port
	xPortCoord = 397;
	yPortCoord = 55;
	portWidth = 21;
	for(i=8; i<9; i++) {
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX"; 
		port = new top.rj45Compositeport(intType,portImages,true);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
		port.width = 44;
		port.height = 17;
		port.sfpx = 22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 1;
		port.id = "port_" + i;
		dev.addPort(port);
	}	
	
	return dev;
}

//Pilsner4 SKU - Sapporo 12 PC S
function WSC356012PCS(int_status, media_type){
	
	var dev = new top.device();
	dev.noofports = 13;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3560_12_PCS.gif";

	drawLeds_pilsner2_PoE(dev);
		
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 128;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 12 FastEthernet ports. 
	for(i=0; i<12; i++) {    
		if(i%2 == 0) {
			yPortCoord = 34;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 50;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
    }
	//Add one composite port
	xPortCoord = 387;
	yPortCoord = 49;//50;
	portWidth = 21;
	for(i=12; i<13; i++) {
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX"; 
		port = new top.rj45Compositeport(intType,portImages,true);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
		port.width = 44;
		port.height = 17;
		port.sfpx = 22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 1;
		port.id = "port_" + i;
		dev.addPort(port);
	}	
	return dev;
}

function drawLeds_pilsner2_PoE(dev) 
{
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	modeBtn.x = 37;
	modeBtn.y = 50;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;

	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 25;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 32;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 39;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 46;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 53;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

}

function drawLeds_withPoE(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3560_mode.gif");
	modeBtn.x = 30;
	modeBtn.y = 63;
	modeBtn.height = 12;
	modeBtn.width = 27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 24;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 31;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 38;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 45;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 52;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 59;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

}

function drawLeds_withoutPoE(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3560_mode.gif");
	modeBtn.x = 30;
	modeBtn.y = 63;
	modeBtn.height = 12;
	modeBtn.width = 27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 25;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 32;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 42;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 49;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 56;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
}

// For Pixar Buzz devices.

function WSC3580G24TD(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3580_24.gif";

	drawLeds_withoutPoE_pixar(dev);
	drawACOK_DCOKLEDs(dev);
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9; 
	var xPortStartPos = 325;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 18; 
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 34;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }
	var intNames = new Array();
	var portInd = 24;
	for (i=0; i< int_status.length; i++)
		intNames[i] = int_status[i][0];
	
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/25") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 15;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,25,26);
	}
			

	if (interfaces.indexOf("0/27") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 39;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,27,28);
	}

  	  if (interfaces.indexOf("0/25") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 15;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;

	}

	if (interfaces.indexOf("0/27") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599; 
		yPortCoord = 39;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function WSC3580G24PD(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3580_24_PoE.gif";

	drawLeds_withPoE_pixar(dev);
	drawACOK_DCOKLEDs(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 326;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 18;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 34;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	var intNames = new Array();
	var portInd = 24;
	for (i=0; i< int_status.length; i++)
		intNames[i] = int_status[i][0];

	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/25") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 15;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,25,26);
	}
			
	if (interfaces.indexOf("0/27") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 39;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,27,28);
	}

	if (interfaces.indexOf("0/25") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 15;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}

	if (interfaces.indexOf("0/27") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 39;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

function WSC3580G48TD(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3580_48.gif";

	drawLeds_withoutPoE_pixar(dev);
	drawACOK_DCOKLEDs(dev);	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 70;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 18;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 34;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i==35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	var intNames = new Array();
	var portInd = 48;
	for (i=0; i< int_status.length; i++)
		intNames[i] = int_status[i][0];
	
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/49") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 15;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,49,50);
	}

	if (interfaces.indexOf("0/51") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 39;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,51,52);
	}

	if (interfaces.indexOf("0/49") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 15;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}

	if (interfaces.indexOf("0/51") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 39;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function WSC3580G48PD(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/c3580_48_PoE.gif";

	drawLeds_withPoE_pixar(dev);
	drawACOK_DCOKLEDs(dev);
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 70;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 18;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 34;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i==35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	var intNames = new Array();
	var portInd = 48;
	for (i=0; i< int_status.length; i++)
		intNames[i] = int_status[i][0];
	
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/49") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 15;
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,49,50);
	}

	if (interfaces.indexOf("0/51") != -1){
		// Add the 2 sfp ports
		xPortCoord = 599;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++){       
			yPortCoord = 39;		// need to be modified
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,51,52);
	}

	if (interfaces.indexOf("0/49") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 15;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}

	if (interfaces.indexOf("0/51") == -1){
		// Add the 1 10G X2 module
		xPortCoord = 599;
		yPortCoord = 39;
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

function addLabel( dev, label1, label2 )
{
	var image1 = "images/port_label_"+label1+".gif";
	var image2= "";
	if (label2 != null ) image2= "images/port_label_"+label2+".gif";
	switch (label1)
	{
		
		case 1:
			// Adding the ten gb port label1
			var portlbtl = new top.portLabel(617, 8, 7, 5, image1);
			if(dev.type.indexOf("WS-C3560E-12SD") != -1){
				image1 = "images/port_black_label_"+label1+".gif";
				portlbtl = new top.portLabel(585, 19, 7, 5, image1);
			}
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 2:
			// Adding the ten gb port label2
			var portlbtl = new top.portLabel(617, 57, 7, 5, image1);
			if(dev.type.indexOf("WS-C3560E-12SD") != -1){
				image1 = "images/port_black_label_"+label1+".gif";
				portlbtl = new top.portLabel(584, 43, 7, 5, image1);
			}
        	portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 13:
				// Adding the top port label1
		        var portlbl = new top.portLabel(583, 19, 7, 5, image1);
	        	portlbl.id = "portlbl1";
		        dev.addPortLabel(portlbl);

		        // Adding the top port label2
		        var portlbl2 = new top.portLabel(647, 19, 7, 5, image2);
	        	portlbl2.id = "portlbl2";
		        dev.addPortLabel(portlbl2);
			break;
		case 15:
				// Adding the bottom port label1
		        var portlbl3 = new top.portLabel(584, 43, 7, 5, image1);
		        portlbl3.id = "portlbl3";
		        dev.addPortLabel(portlbl3);

		        // Adding the bottom port label2
		        var portlbl4 = new top.portLabel(647, 43, 7, 5, image2);
		        portlbl4.id = "portlbl4";
		        dev.addPortLabel(portlbl4);
			break;
		case 25:
		case 49:
			// Adding the top port label1
				var portlbl = new top.portLabel(607, 8, 7, 5, image1);
				portlbl.id = "portlbl1";
				dev.addPortLabel(portlbl);

			 // Adding the top port label2
				var portlbl2 = new top.portLabel(629, 8, 7, 5, image2);
				portlbl2.id = "portlbl2";
				dev.addPortLabel(portlbl2);
			break;
		case 27:
		case 51:
		        // Adding the bottom port label1 
				var portlbl3 = new top.portLabel(607, 57, 7, 5, image1);
				portlbl3.id = "portlbl3";
				dev.addPortLabel(portlbl3);

		        // Adding the bottom port label2 
				var portlbl4 = new top.portLabel(629, 57, 7, 5, image2);
				portlbl4.id = "portlbl4";
				dev.addPortLabel(portlbl4);
	}
}
function addIncredibleLabel(dev,label1)
{
	var image1;
	switch (label1)
	{	
		
		case 0:
			 image1 = "images/blank_module.gif";//Base for Blank module
			 var label_blank_module = new top.portLabel(556, 3, 102, 74, image1);
			 label_blank_module.id = "labelblankmodule";
			 dev.addPortLabel(label_blank_module); 
			 break;
		case 1://IG NM Module : G1,G2,G3,G4
			// Adding the Gigabit port label 1 (G1)
			 image1 = "images/C3KNM_1G_label.gif";// Label for Network Module;
			 var portlb_nm1g = new top.portLabel(590, 13, 39, 6, image1);
			 portlb_nm1g.id = "portlbnm1g";
			dev.addPortLabel(portlb_nm1g); 
			image1 = "images/giga_port_label_"+label1+".gif";			
			var portlbtl = new top.portLabel(567, 71, 8, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl); label1++;//increment for G2;
			// Adding the Gigabit port label 2 (G2)
			 image1 = "images/giga_port_label_"+label1+".gif";
			var portlbt2 = new top.portLabel(590, 71, 8, 5, image1);
			portlbt2.id = "portlbtl2";
			dev.addPortLabel(portlbt2); label1++;
			// Adding the Gigabit port label 3 (G3)
			 image1 = "images/giga_port_label_"+label1+".gif";
			var portlbt3 = new top.portLabel(614, 71, 8, 5, image1);
			portlbt3.id = "portlbtl3";
			dev.addPortLabel(portlbt3); label1++;
			// Adding the Gigabit port label 4 (G4)
			 image1 = "images/giga_port_label_"+label1+".gif";
			var portlbt4 = new top.portLabel(639, 71, 8, 5, image1);
			portlbt4.id = "portlbtl4";
			dev.addPortLabel(portlbt4);
		break;
		case 2: //Add Te1 and Te2 ports
			 image1 = "images/C3KNM_10G_label.gif";// Label for 10G Network Module;
			 var portlb_nm10g = new top.portLabel(590, 13, 39, 6, image1);
			 portlb_nm10g.id = "portlbnm10g";
			 dev.addPortLabel(portlb_nm10g); 
			 image1 ="images/tengiga_port_color.gif";//This color to indicates 10giga port is on 2nd & 4th port
			 var portlb_nm10g_color1 = new top.portLabel(584, 45, 22, 3, image1);
			 var portlb_nm10g_color2 = new top.portLabel(635, 45, 22, 3, image1);
			 portlb_nm10g_color1.id = "portlb_nm10g_color1";
			 portlb_nm10g_color2.id = "portlb_nm10g_color2";
			 dev.addPortLabel(portlb_nm10g_color1); 
			 dev.addPortLabel(portlb_nm10g_color2); 
			 // Adding port label Te1
			var label1=1;
			image1 = "images/tengiga_port_label_"+label1+".gif";
			var portlbtl = new top.portLabel(592, 71, 10, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl); label1++;
			// Adding the port label Te2
		    image1 = "images/tengiga_port_label_"+label1+".gif";
			var portlbt2 = new top.portLabel(640, 71, 10, 5, image1);
			portlbt2.id = "portlbtl2";
			dev.addPortLabel(portlbt2);
		break;
		case 3: //Add label for Te1,G3,G4
			 image1 = "images/C3KNM_10G_label.gif";// Label for 10G Network Module;
			 var portlb_nm10g = new top.portLabel(590, 13, 39, 6, image1);
			 portlb_nm10g.id = "portlbnm10g";
			 dev.addPortLabel(portlb_nm10g); 
			 image1 ="images/tengiga_port_color.gif";//This color to indicates 10giga port is on 2nd & 4th port
			 var portlb_nm10g_color1 = new top.portLabel(584, 45, 22, 3, image1);
			 var portlb_nm10g_color2 = new top.portLabel(633, 45, 22, 3, image1);
			 portlb_nm10g_color1.id = "portlb_nm10g_color1";
			 portlb_nm10g_color2.id = "portlb_nm10g_color2";
			 dev.addPortLabel(portlb_nm10g_color1); 
			 dev.addPortLabel(portlb_nm10g_color2); 
			// Adding port label Te1
			 var label1=1;
			 image1 = "images/tengiga_port_label_"+label1+".gif";
			 var portlbtl = new top.portLabel(592, 71, 10, 5, image1);
			 portlbtl.id = "portlbtl1";
			 dev.addPortLabel(portlbtl); label1=label1+2;
			 // Adding the port label G3
			var image1 = "images/giga_port_label_"+label1+".gif";
			var portlbt3 = new top.portLabel(614, 71, 8, 5, image1);
			portlbt3.id = "portlbtl3";
			dev.addPortLabel(portlbt3); label1++;
			// Adding the port label G4
			image1 = "images/giga_port_label_"+label1+".gif";
			var portlbt4 = new top.portLabel(639, 71, 8, 5, image1);
			portlbt4.id = "portlbtl4";
			dev.addPortLabel(portlbt4);
		break;
		case 4:
			//Add label for G1,G2,Te2
			 image1 = "images/C3KNM_10G_label.gif";// Label for 10G Network Module;
			 var portlb_nm10g = new top.portLabel(590, 13, 39, 6, image1);
			 portlb_nm10g.id = "portlbnm10g";
			 dev.addPortLabel(portlb_nm10g); 
			 image1 ="images/tengiga_port_color.gif";//This color to indicates 10giga port is on 2nd & 4th port
			 var portlb_nm10g_color1 = new top.portLabel(583, 45, 22, 3, image1);
			 var portlb_nm10g_color2 = new top.portLabel(632, 45, 22, 3, image1);
			 portlb_nm10g_color1.id = "portlb_nm10g_color1";
			 portlb_nm10g_color2.id = "portlb_nm10g_color2";
			 dev.addPortLabel(portlb_nm10g_color1); 
			 dev.addPortLabel(portlb_nm10g_color2);
			 // Adding port label G1
			var label1=1;
			image1 = "images/giga_port_label_"+label1+".gif";
			var portlbtl = new top.portLabel(567, 71, 8, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl); label1++;
			// Adding the port label G2
		    image1 = "images/giga_port_label_"+label1+".gif";
			var portlbt2 = new top.portLabel(592, 71, 8, 5, image1);
			portlbt2.id = "portlbtl2";
			dev.addPortLabel(portlbt2);
			// Adding the port label Te2
		    image1 = "images/tengiga_port_label_"+label1+".gif";
			var portlbt2 = new top.portLabel(640, 71, 10, 5, image1);
			portlbt2.id = "portlbtl2";
			dev.addPortLabel(portlbt2);
		break;
		case 5: // 10G NM module : G1,G2,G3,G4
			 image1 = "images/C3KNM_10G_label.gif";// Label for 10G Network Module;
			 var portlb_nm10g = new top.portLabel(590, 13, 39, 6, image1);
			 portlb_nm10g.id = "portlbnm10g";
			 dev.addPortLabel(portlb_nm10g); 
			 image1 ="images/tengiga_port_color.gif";//This color to indicates 10giga port is on 2nd & 4th port
			 var portlb_nm10g_color1 = new top.portLabel(583, 45, 22, 3, image1);
			 var portlb_nm10g_color2 = new top.portLabel(631, 45, 22, 3, image1);
			 portlb_nm10g_color1.id = "portlb_nm10g_color1";
			 portlb_nm10g_color2.id = "portlb_nm10g_color2";
			 dev.addPortLabel(portlb_nm10g_color1); 
			 dev.addPortLabel(portlb_nm10g_color2); 
			// Adding port label G1
			var label1=1;
			image1 = "images/giga_port_label_"+label1+".gif";
			var portlbtl = new top.portLabel(567, 71, 8, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl); label1++;
			// Adding the port label G2
		    image1 = "images/giga_port_label_"+label1+".gif";
			var portlbt2 = new top.portLabel(590, 71, 8, 5, image1);
			portlbt2.id = "portlbtl2";
			dev.addPortLabel(portlbt2); label1++;
			// Adding the port label G3
			var image1 = "images/giga_port_label_"+label1+".gif";
			var portlbt3 = new top.portLabel(614, 71, 8, 5, image1);
			portlbt3.id = "portlbtl3";
			dev.addPortLabel(portlbt3); label1++;
			// Adding the port label G4
			image1 = "images/giga_port_label_"+label1+".gif";
			var portlbt4 = new top.portLabel(639, 71, 8, 5, image1);
			portlbt4.id = "portlbtl4";
			dev.addPortLabel(portlbt4);
		break;
	}
}
function drawLeds_12PD(dev){
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/C3560E_PD_mode.gif");
	modeBtn.x = 34;
	modeBtn.y = 71;
	modeBtn.height = 7;
	modeBtn.width = 11;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 29;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 35;
	tempLed.id = "PS1";
	tempLed.showPopup = true;
	tempLed.device = dev;
	dev.sysleds["PS1"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 41;
	tempLed.id = "PS2";
	tempLed.showPopup = true;
	tempLed.device = dev;
	dev.sysleds["PS2"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 47;
	tempLed.id = "FAN";
	tempLed.device = dev;
	dev.sysleds["FAN"] = tempLed;
		
		
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 53;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 59;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 65;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	// Create Fa0 LED
	tempLed = new top.led(ledImages);
	tempLed.x = 56;
	tempLed.y = 75;
	tempLed.id = "fa_0";
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;
	
}
function drawLeds_withPoE_pixar(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3580_mode.gif");
	modeBtn.x = 30;
	modeBtn.y = 63;
	modeBtn.height = 12;
	modeBtn.width = 27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 23;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 29;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 37;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 43;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 49;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 58;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

}

function drawLeds_withoutPoE_pixar(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/c3580_mode.gif");
	modeBtn.x = 30;
	modeBtn.y = 63;
	modeBtn.height = 12;
	modeBtn.width = 27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 23;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 29;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 37;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 43;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 49;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
}

function drawACOK_DCOKLEDs(dev){
	// Create AC OK LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 69;
	tempLed.y = 67;
	tempLed.id = "ac_ok";
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["ACOK"] = tempLed;

	// Create DC OK LEDs
	tempLed = new top.led(ledImages);
	tempLed.x = 104;
	tempLed.y = 67;
	tempLed.id = "dc_ok";
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["DCOK"] = tempLed;

	// Create Fa0 LED
	tempLed = new top.led(ledImages);
	tempLed.x = 141;
	tempLed.y = 67;
	tempLed.id = "fa_0";
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

}

function WSC3560E12DSE(int_status, media_type) {
	var dev = new top.device();
	
	dev.noofports = 12;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C3560_12D.gif";
	
	drawLeds_12PD(dev);
	
	// Create the ports
	var port;
	var portWidth = 16;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 34;
	var xPortGroupGap = 0;
	var xPortStartPos = 60;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	xPortCoord = xPortStartPos;
	
	var portindex = 0;
	for(var t=0;t<int_status.length;t++){
			var lbl = new top.label(xPortCoord,yPortCoord,8,8,t);
			lbl.fontfamily="Arial Black";
			lbl.fontsize="5pt";
			lbl.id = "lbl" +t;
			lbl.width=24;
			var intNum=int_status[t][0].substring(int_status[t][0].indexOf("/")+1,int_status[t][0].length);
			if(int_status[t][0].indexOf("Gi") != -1){
					lbl.text = intNum;
					lbl.color = "#F7EB84";
					if(intNum % 2 == 0){
						port = new top.SFPsideport(int_status[t][6], portImages);
						xPortCoord = (intNum/2) * (portWidth + xPortGap);
						port.x=xPortCoord + 5;
						port.y = 41;
						port.id = "port_" + t;
						port.index = t;
						
						lbl.x=xPortCoord + 18;
						lbl.y=47;
						
						
					}else{
						port = new top.SFPsideport(int_status[t][6], portImages);
						xPortCoord = ((parseInt(intNum)+1)/2) * (portWidth + xPortGap);
						port.x=xPortCoord + 5;
						port.y = 19;
						port.id = "port_" + t;
						port.index = t;
						
						lbl.x=xPortCoord + 18;
						lbl.y=22;
						
					}
			
			}else if(int_status[t][0].indexOf("Te") != -1){
				port = new top.tenGbSFPVerticalport(int_status[t][6], portImages);
				xPortCoord = intNum * (portWidth + xPortGap);
				port.x=xPortCoord + 5;
				port.y = 19;
				port.id = "port_" + t;
				port.index = t;
				
				lbl.x=xPortCoord + 23;
				lbl.y=35;
				lbl.text="X2-" + intNum;
				lbl.color="#000000";
			}
			port.id = "port_" + t;
			dev.addPort(port);	
			dev.addLabel(lbl);	
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function WSC3560CG8PC(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 10;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C3560CG_8PC_2.gif";	

	// Construct the mode button and the system LEDs
	construct_Junmai_leds(dev);

	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 48;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 0;
	var xPortGroupGap = 11;
	var xPortStartPos = 204;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<8; i++){
 	    yPortCoord = 42;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		if(i==3)
			xPortCoord +=xPortGroupGap;
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 390;
	yPortCoord = 25;//49;
	for(i=8; i<10; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED","PoE");
	return dev;
}

function WSC3560CG8TC(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 10;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C3560CG_8TC_2.gif";	

	// Construct the mode button and the system LEDs
	construct_Junmai_leds(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 0;
	var xPortGroupGap = 10;
	var xPortStartPos = 204;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<8; i++){
 	    yPortCoord = 42;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		if(i==3)
			xPortCoord +=xPortGroupGap;
		dev.addPort(port);
	}
		//Add Two composite port
	xPortCoord = 390;
	yPortCoord = 25;//49;
	for(i=8; i<10; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;
}
function WSC3560CPD8PTS(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 10;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C3560CPD_8PTS_2.gif";	

	// Construct the mode button and the system LEDs
	construct_Junmai_leds(dev);

	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 48;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	//PD led
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 55;
	tempLed.id = "pd_led";
	tempLed.device = dev;
	dev.sysleds["PD"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var xPortGap = 0;
	var xPortGroupGap = 11;
	var xPortStartPos = 204;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<8; i++){
 	    yPortCoord = 42;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		if(i==3)
			xPortCoord +=xPortGroupGap;
		dev.addPort(port);
	}
	//Add Uplink Giga port
	xPortCoord = 394;//381;//397;
	yPortCoord = 40;//53;//49;
	xPortGap=12;
	for(i=8; i<10; i++){
 	    yPortCoord = 40;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED","PoE");
	return dev;
}
function construct_Junmai_leds(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 20;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 27;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 34;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 41;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

/*  tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 55;
	tempLed.id = "stack";
	tempLed.device = dev;
	dev.sysleds["STACK"] = tempLed;*/
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/Junmai_mode.gif"); 
	modeBtn.x = 32;
	modeBtn.y = 55;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}

function createDevice(int_status, media_type, deviceType,FRULinkname,hardwareModuleActivePorts) {
	var device = null;
	if(deviceType == null)
		return device;
	var REX = "";
	if(deviceType.indexOf("WS-C3560E-12D") != -1){        
		REX = deviceType;
	}
	
	switch(deviceType){    
        
		case "WS-C3560-24PS":
			device = new WSC356024P(int_status, media_type);
			break;	
		case "WS-C3560-48PS":
			device = new WSC356048P(int_status, media_type);
			break;
		case "WS-C3560G-24TS":
			device = new WSC3560G244TS(int_status, media_type);
			break;
		case "WS-C3560G-48TS":
			device = new WSC3560G484TS(int_status, media_type);
			break;
		case "WS-C3560G-48PS":
			device = new WSC3560G484PS(int_status, media_type);
			break;
		case "WS-C3560G-24PS":
			device = new WSC3560G244PS(int_status, media_type);
			break;
		case "WS-C3560-24TS":
			device = new WSC3560G242T(int_status, media_type);
			break;
		case "WS-C3560-48TS":
			device = new WSC3560484T(int_status, media_type);
			break;
		case "WS-C3560-8PC":
			device = new WSC35608PC(int_status, media_type);
			break;
		case "WS-C3560E-24TD":
			device = new WSC3580G24TD(int_status, media_type);
			break;
		case "WS-C3560E-24PD":
			device = new WSC3580G24PD(int_status, media_type);
			break;
		case "WS-C3560E-48TD":
			device = new WSC3580G48TD(int_status, media_type);
			break;
		case "WS-C3560E-48PD":
			device = new WSC3580G48PD(int_status, media_type);
			break;
		case REX:
			device = new WSC3560E12DSE(int_status, media_type);
			break;
		case "WS-C3560E-12SD":
			device = new SLINKY12(int_status, media_type);
			break;
		case "WS-C3560-12PC-S":
		    device = new WSC356012PCS(int_status, media_type);
            break;
		case "SM-ES3-16-P":  
			device = new SM_ES3_16P(int_status, media_type);
			break;	
		case "SM-ES3G-16-P":
			device = new SM_ES3G_16P(int_status, media_type);
			break;
		case "SM-ES3-24-P":
			device = new SM_ES3_24P(int_status, media_type);
			break;
		case "SM-ES3G-24-P":
			device = new SM_ES3G_24P(int_status, media_type);
			break;
		case "SM-D-ES3G-48-P":
			device = new SMD_ES3G_48P(int_status, media_type);
			break;
		case "SM-D-ES3-48-P":
			device = new SMD_ES3_48P(int_status, media_type);
			break;
		case "SM-X-ES3-16-P":
			device = new SM_ES3X_16P(int_status, media_type);
			break;
		case "SM-X-ES3-24-P":
			device = new SM_ES3X_24P(int_status, media_type);
			break;
		case "SM-X-ES3D-48-P":
			device = new SM_ES3X_48P(int_status, media_type);
			break;	
			
	} 
	if(deviceType.indexOf("WS-C3560V2-24PS") !=-1){            //SheYoJee - 3560F series
		device = new WS3560F24PS(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560V2-24TS-SD") !=-1){
	    device = new WS3560F24TS_D(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560V2-24TS") !=-1){
	    device = new WS3560F24TS(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560V2-48PS") !=-1){
	    device = new WSC3560F48PS(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560V2-48TS") !=-1){
	    device = new WSC3560F48TS(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560X-24U") !=-1){          // ElastiGirl  3560X series
	    device = new WSC3560X24U(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560X-48U") !=-1){ 
	    device = new WSC3560X48U(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560X-24P") !=-1){ 
	    device = new WSC3560X24P(int_status, media_type,FRULinkname,hardwareModuleActivePorts);
	}else if(deviceType.indexOf("WS-C3560X-24") !=-1){
	    device = new WSC3560X24(int_status, media_type,FRULinkname,hardwareModuleActivePorts);
	}else if(deviceType.indexOf("WS-C3560X-48P") !=-1){
	    device = new WSC3560X48P(int_status, media_type,FRULinkname,hardwareModuleActivePorts);
	}else if(deviceType.indexOf("WS-C3560X-48") !=-1){
	    device = new WSC3560X48(int_status, media_type,FRULinkname,hardwareModuleActivePorts);
	}else if(deviceType.indexOf("SW-6560X-48P") !=-1){
	    device = new SW6560X48P(int_status, media_type,FRULinkname,hardwareModuleActivePorts);
	}else if(deviceType.indexOf("SW-6560X-48") !=-1){
	    device = new SW6560X48(int_status, media_type,FRULinkname,hardwareModuleActivePorts);
	}else if(deviceType.indexOf("SW-6560X-24P") !=-1){ 
	    device = new SW6560X24P(int_status, media_type,FRULinkname,hardwareModuleActivePorts);
	}else if(deviceType.indexOf("SW-6560X-24") !=-1){
	    device = new SW6560X24(int_status, media_type,FRULinkname,hardwareModuleActivePorts);
	}else if(deviceType.indexOf("WS-C3560CG-8PC-S") !=-1){
	    device = new WSC3560CG8PC(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560CG-8TC-S") !=-1){
	    device = new WSC3560CG8TC(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560CPD-8PT-S") !=-1){ //Sake Takara
	    device = new WSC3560CPD8PTS(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560C-8PC-S") !=-1){ //Ginjo
	    device = new WSC3560C8PCS(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560CX-8PC-S") !=-1){    //Smirnoff Support
	    device = new WSC3560CX_8PC_S(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560CX-8TC-S") !=-1){ 
	    device = new WSC3560CX_8TC_S(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560CX-8PT-S") !=-1){    //Belwadere
	    device = new WSC3560CX_8PT_S(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560CPX-8PT-S") !=-1){ 
	    device = new WSC3560CPX_8PT_S(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560CX-8PD-S") !=-1){ 
	    device = new WSC3560CX_8PD_S(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560CX-8XPD-S") !=-1){   //WS-C3560CX-8XPD-S.....GA
	    device = new WSC3560CX_8XPD_S(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560C-12PC-S") !=-1){ //Ginjo
	    device = new WSC3560C12PCS(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560CX-12PC-S") !=-1){  //Smirnoff Support
	    device = new WSC3560CX_12PC_S(int_status, media_type);
	}else if(deviceType.indexOf("WS-C3560CX-12PD-S") !=-1){ 
	    device = new WSC3560CX_12PD_S(int_status, media_type);
	}else if(deviceType == "WS-C3560CX-12TC-S"){ 
	    device = new WSC3560CX_12TC_S(int_status, media_type);
	} 	

	if(device != null) {
		device.type = deviceType;
		if(deviceType.indexOf("C3560E")!=-1)
			device.family = "3560-E";	
		else if(deviceType.indexOf("C3560V2")!=-1)
		    device.family = "3560-V2";
		else if(deviceType.indexOf("SM-ES3")!=-1 || deviceType.indexOf("SM-D-ES3")!=-1 || deviceType.indexOf("SM-X-ES3") != -1)
			device.family = "Enhanced EtherSwitch Service Module";
		else if(deviceType.indexOf("C3560X")!=-1)
		    device.family = "3560-X";
		else if(deviceType.indexOf("SW-6560X")!=-1)
		    device.family = "6560-X";
		else if(deviceType.indexOf("C3560CX")!=-1)
		    device.family = "3560-CX";
		else if(deviceType.indexOf("C3560CPX")!=-1)
		    device.family = "3560-CPX";
		else if(deviceType.indexOf("C3560C")!=-1)
		    device.family = "3560-C";
		else 
			device.family = "3560";
	}
			
	return device;
}

function SLINKY12(int_status, media_type){
var dev = new top.device();

	dev.noofports = 14;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C3560E_12SD.gif";
	dev.type = "WS-C3560E-12SD";
	drawLedsforSlinky(dev);

	// Create the ports
	var port;
	var portWidth = 21;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 14;
	var xPortStartPos = 200;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	for(i=0; i<12; i++) {       
		
		yPortCoord = 30;
		port = new top.SFPport(int_status[i][6]); 
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		if (i==3 || i==7) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }
	var intNames = new Array();
	var portInd = 12;
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
	}
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/13") != -1)
	{
		// Add the 2 sfp ports
		xPortCoord = 597;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++) 
		{       
			yPortCoord = 13;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,13,14);
	}

	if (interfaces.indexOf("0/15") != -1)
	{
		// Add the 2 sfp ports
		xPortCoord = 597;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++) 
		{       
			yPortCoord = 37;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,15,16);

	}
	if (interfaces.indexOf("0/13") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 597;
		yPortCoord = 13;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}
	if (interfaces.indexOf("0/15") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 597;
		yPortCoord = 37;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,2);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}
function drawLedsforSlinky(dev){
// Create the Mode Btn
	var modeBtn = new top.modebtn("images/C3560E_mode_btn.gif");
	modeBtn.x = 36;
	modeBtn.y = 69;
	modeBtn.height = 8;
	modeBtn.width = 19;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 25;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 31;
	tempLed.id = "ps1";
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["PS1"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 37;
	tempLed.id = "ps2";
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["PS2"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 43;
	tempLed.id = "fan";
	tempLed.device = dev;
	dev.sysleds["FAN"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 49;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 55;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 61;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	// Create Fa0 LED
	tempLed = new top.led(ledImages);
	tempLed.x = 62;
	tempLed.y = 67;
	tempLed.id = "fa_0";
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;
	
}

function WS3560F24PS(int_status, media_type) {
 var dev = new top.device();

	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/3560F_24_PWR.gif";

	drawLeds_3560F_withPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 8;
	var xPortStartPos = 317;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 GBIC ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	for(i=24; i<26; i++) {     
		yPortCoord = 44;//37;//36;		
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;   
}


function WS3560F24TS(int_status, media_type) {
	 var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/3560F_24TS.gif";

	drawLeds_3560F_withoutPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 8;//38;
	var xPortStartPos = 317;//287;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 GBIC ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	for(i=24; i<26; i++) {     
		yPortCoord = 44;
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;   
}

function WS3560F24TS_D(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/3560F_24TS_DC.gif";

	drawLeds_3560F_withoutPoE(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 8;//38;
	var xPortStartPos = 317;//287;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 2 GBIC ports.
	xPortCoord = 578;
	xPortGap = 15;
	portWidth = 21;
	for(i=24; i<26; i++) {     
		yPortCoord = 44;
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev;   
}

function drawLeds_3560F_withPoE(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/3560f_mode.gif");
	modeBtn.x = 42;
	modeBtn.y = 67;
	modeBtn.height = 8;//12;
	modeBtn.width = 16;//27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 20;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 27;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 37;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 44;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 51;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 59;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

}

function drawLeds_3560F_withoutPoE(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/3560f_mode.gif");
	modeBtn.x = 42;//30;
	modeBtn.y = 67;//63;
	modeBtn.height = 8;
	modeBtn.width = 16;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 25;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 32;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 42;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 49;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 16;
	tempLed.y = 56;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
}


function WSC3560F48PS(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/3560F_48_PWR.gif";

	drawLeds_3560F_48_withPoE(dev);
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;//18;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;//34;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i==35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	xPortCoord = 589;
	xPortGap = 12;
	yPortCoord = 25;
	portWidth = 21;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 25;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED","PoE");
	return dev; 

}

function WSC3560F48TS(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/3560F_48.gif";

	drawLeds_3560F_48(dev);
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 29;//18;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 45;//34;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i==35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	xPortCoord = 589;
	xPortGap = 12;
	yPortCoord = 25;
	portWidth = 21;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 47;			
		} else {
			yPortCoord = 25;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");
	return dev; 

}

function drawLeds_3560F_48_withPoE(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/3560f_mode.gif");
	modeBtn.x = 38;
	modeBtn.y = 67;
	modeBtn.height = 8;//12;
	modeBtn.width = 16;//27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 21;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 28;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 38;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 45;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 52;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 60;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

}

function drawLeds_3560F_48(dev) {
	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/3560f_mode.gif");
	modeBtn.x = 38;
	modeBtn.y = 67;
	modeBtn.height = 8;//12;
	modeBtn.width = 16;//27;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 25;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 32;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y =42;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 49;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 56;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
}
// EAGLEEYE SM-ES3-16-P	 

function SM_ES3_16P(int_status, media_type) {   
		
	var dev = new top.device();
	dev.noofports = 18;   //  2 Gi internal ports
	dev.x=0;
	dev.y=0;
	dev.image = "images/EE_SM_ES3_16P.gif";	
	
	//LED ( draw Enable LED )
	drawLedsForEagleEye(dev, 31, 67, 5, 5); 

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3;
	var xPortGroupGap = 19;
	var xPortStartPos = 303;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 15 FastEthernet ports + 1 Gibabit Ethernet Ports  - right to left 
	for(i=0; i<15; i++) {
 
		if(i%2 != 0) {
			yPortCoord = 23;
			port = new top.rj45portInv(portInvImages);
		} 

		else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}

		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;

		if( i%2 ==0 ) {
			 xPortCoord -= (portWidth + xPortGap); 
		}

		dev.addPort(port);
	}
		xPortCoord = 303;
		yPortCoord = 23;
		var i = 15;
		port = new top.rj45port(portInvImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
	    dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

// EAGLEEYE SM-ES3G-16-P
function SM_ES3G_16P(int_status, media_type){   
	
	var dev = new top.device();
	dev.noofports = 18;   // 2 Gi internal ports
	dev.x=0;
	dev.y=0;
	dev.image = "images/EE_SM_ES3G_16P.gif";	
	
	//LED ( draw Enable LED )
	drawLedsForEagleEye(dev, 31, 67, 5, 5); 

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3;
	var xPortGroupGap = 19;
	var xPortStartPos = 303; 
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 16 Gigabit Ethernet ports - right to left 
	for(i=0; i<16; i++) {

		if(i%2 == 0) {
			yPortCoord = 23;
			port = new top.rj45portInv(portInvImages);
		} 
		else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) {
			xPortCoord -= (portWidth + xPortGap); 
		}
		
		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

// EAGLEEYE SM-ES3-24-P 
function SM_ES3_24P(int_status, media_type){
	
	var dev = new top.device();
	dev.noofports = 26;   // 2 Gi internal ports
	dev.x=0;
	dev.y=0;
	dev.image = "images/EE_SM_ES3_24.gif";	

	//LED ( draw Enable LED )
	drawLedsForEagleEye(dev, 31, 67, 5, 5); 

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3; 
	var xPortGroupGap = 19;  
	var xPortStartPos = 303;  
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 23 FastEthernet ports + 1 Gibabit Ethernet Ports in 2 groups .
	//16 ports in first group  & 8 ports in second group from  right to left
	for(i=0; i<23; i++){
		if(i%2 != 0){
			yPortCoord = 23; 
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 41;  
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 ==0 ) {
			 xPortCoord -= (portWidth + xPortGap); 
		}
		if ( i==14 || i == 22 )	{		// Check for Second group Gap
		
			xPortCoord -= (xPortGroupGap - xPortGap); 
		}
		dev.addPort(port);
	}
		xPortCoord = 303;
		yPortCoord = 23;
		var i = 23;
		port = new top.rj45port(portInvImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;

		dev.addPort(port);
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}
// EAGLEEYE SM-ES3G-24-P 

function SM_ES3G_24P(int_status, media_type){
	
	var dev = new top.device(); 
	dev.noofports = 26;   // 2 Gi internel ports
	dev.x=0;
	dev.y=0;
	dev.image = "images/EE_SM_ES3G_24P.gif";
	
	//LED ( draw Enable LED )
	drawLedsForEagleEye(dev, 31, 67, 5, 5); 
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3; 
	var xPortGroupGap = 19;  
	var xPortStartPos = 303;  
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add  24 Gibabit Ethernet Ports in 2 groups .
	//16 ports in First group  & 8 ports in second group from  right to left
	for(i=0; i<24; i++) {
		if(i%2 == 0){
			yPortCoord = 23; 
			port = new top.rj45portInv(portInvImages);
			
		} 
		else {
			yPortCoord = 41;  
			port = new top.rj45port(portImages);
		}
		port.index = i; 
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i; 
		if( i%2 !=0 ) { 
			xPortCoord -= (portWidth + xPortGap);  
		}
		if ( i==15 ) {
			xPortCoord -= (xPortGroupGap - xPortGap); 
		}

		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}
 // Draw LED for EagleEye SKUs
function drawLedsForEagleEye(dev, x, y, width, height) {
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = x;
	tempLed.y = y;
	tempLed.width = width;
	tempLed.height = height;
	tempLed.id = "en_led";
	tempLed.device = dev;
	dev.sysleds["EN"] = tempLed;
}
function SMD_ES3_48P(int_status, media_type) {
//48 FastEthernet Ports.
//2  SFP Ports & Gigabit (Gi0/51 and Gi0/52) internal ports.
//Inline power version
	
	var dev = new top.device();

	dev.noofports = 52; // 50 + 2 internal.
	dev.x=0;
	dev.y=0;
	dev.image = "images/EE_SMD_ES3_48P.gif";

	drawLedsForEagleEye(dev, 33, 63, 8, 4); 
	
	// Create the Ports.
	var port;
	var	portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3;//8; 
	var xPortGroupGap = 13;
	var xPortStartPos = 576; 
	var xPortCoord = xPortStartPos;
	var yPortCoord;

   // Add the 48 (2 to 50) FastEthernet ports in three groups from right to left 16 on each group
 	portWidth = 19;
	xPortGap = 3; 
	xPortCoord =576;

	for(var i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 23;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i+2;//Lable
		if(i%2 != 0) {
			xPortCoord -= (portWidth + xPortGap);	
		}
		if(i == 15 || i == 31) {
			xPortCoord -= (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }
	// Add the 2 SFP ports - Gi0/1 and Gi0/2
	// Gi0/51 & Gi0/52 are internal ports
		xPortCoord=612;//609;
		yPortCoord = 22;
		xPortGap=8;
		portWidth=21;
	
		for(i=48; i<50; i++) {
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			if(i%2 == 0) {
				yPortCoord = 41;
				port.id = "port_" + 0;
			}else
				port.id = "port_" + 1;
			dev.addPort(port);
		}
    dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED","PoE");	
	return dev;
}
 
function SMD_ES3G_48P(int_status, media_type) {
//48 Gigabit Ethernet Ports.
//2  SFP Ports & Gigabit (Gi0/51 and Gi0/52) internal ports.
//Inline power version
	
	var dev = new top.device();

	dev.noofports = 52; // 50 + 2 internal.
	dev.x=0;
	dev.y=0;
	dev.image = "images/EE_SMD_ES3G_48P.gif";

	drawLedsForEagleEye(dev, 33, 63, 8, 4); 
	
	// Create the Ports.
	var port;
	var	portWidth = 21;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 8; 
	var xPortGroupGap = 13;//19;  
	var xPortStartPos = 612;//609;//576;  
	var xPortCoord = xPortStartPos;
	var yPortCoord;


	// Add the 2 SFP ports - Gi0/1 and Gi0/2
	// Gi0/51 & Gi0/52 are internal ports
		yPortCoord = 22;
	
		for(i=0; i<2; i++) {
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			if(i%2 == 0) {
				yPortCoord = 41;
			}
			dev.addPort(port);
		}
	// Add the 48 (2 to 50) Gigabit Ethernet ports in three groups from right to left 16 on each group
 	portWidth = 19;
	xPortGap = 3; 
	xPortCoord =576;

	for(var i=2; i<50; i++) {       
		if(i%2 == 0) {
			yPortCoord = 23;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord -= (portWidth + xPortGap);	
		}
		if(i == 17 || i == 33) {
			xPortCoord -= (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }
    dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED","PoE");	
	return dev;
}

//*** End Of EagleEye Layer 3 SKUs ***//
//*** Start Lebowski Layer 3 SKUs ***//
// Lebowski SM-X-ES3-16-P 
function SM_ES3X_16P(int_status, media_type){   
	
	var dev = new top.device();
	dev.noofports = 18;   // 2 Gi internal ports
	dev.x=0;
	dev.y=0;
	dev.image = "images/SM-ES3X-16-P.gif";	
	
	//LED ( draw Enable LED )
	drawLedsForEagleEye(dev, 31, 67, 5, 5); 

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3;
	var xPortGroupGap = 19;
	var xPortStartPos = 46; 
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 16 Gigabit Ethernet ports - right to left 
	for(i=0; i<16; i++) {

		if(i%2 == 0) {
			yPortCoord = 23;
			port = new top.rj45portInv(portInvImages);
		} 
		else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) {
			xPortCoord += (portWidth + xPortGap); 
		}
		
		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

// Lebowski SM-X-ES3-24-P 
function SM_ES3X_24P(int_status, media_type){
	
	var dev = new top.device(); 
	dev.noofports = 26;   // 2 Gi internel ports
	dev.x=0;
	dev.y=0;
	dev.image = "images/SM-ES3X-24-P.gif";
	
	//LED ( draw Enable LED )
	drawLedsForEagleEye(dev, 31, 67, 5, 5); 
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3; 
	var xPortGroupGap = 18;  
	var xPortStartPos = 46;  
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add  24 Gibabit Ethernet Ports in 2 groups .
	//16 ports in First group  & 8 ports in second group from  right to left
	for(i=0; i<24; i++) {
		if(i%2 == 0){
			yPortCoord = 23; 
			port = new top.rj45portInv(portInvImages);
			
		} 
		else {
			yPortCoord = 41;  
			port = new top.rj45port(portImages);
		}
		port.index = i; 
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i; 
		if( i%2 !=0 ) { 
			xPortCoord += (portWidth + xPortGap);  
		}
		if ( i==15 ) {
			xPortCoord += (xPortGroupGap - xPortGap); 
		}

		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "PoE");
	return dev;
}

// Lebowski SMD-ES3X-48-P 
function SM_ES3X_48P(int_status, media_type) {
//48 Gigabit Ethernet Ports.
//2  SFP Ports & Gigabit (Gi0/51 and Gi0/52) internal ports.
//Inline power version
	
	var dev = new top.device();

	dev.noofports = 52; // 50 + 2 internal.
	dev.x=0;
	dev.y=0;
	dev.image = "images/SM-ES3X-48-P.gif";

	drawLedsForEagleEye(dev, 33, 63, 8, 4); 
	
	// Create the Ports.
	var port;
	var	portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3; 
	var xPortGroupGap = 13;//19;  
	var xPortStartPos = 50;//609;//576;  
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	for(var i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 23;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);	
		}
		if(i == 15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }
	
	// Add the 2 SFP ports - Gi0/49 and Gi0/50
	// Gi0/51 & Gi0/52 are internal ports
	yPortCoord = 23
	xPortCoord = 613;
	var yPortCoord;
	// Add the 48 (2 to 50) Gigabit Ethernet ports in three groups from right to left 16 on each group
	for(i=48; i<50; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.id = "port_" + i;
		if(i%2 != 0) {
			yPortCoord = 41;
		}
		else
		{
			yPortCoord = 23;
		}
		port.x = xPortCoord;
		port.y = yPortCoord;
		dev.addPort(port);
	}
    dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED","PoE");	
	return dev;
}
//*** End of Lebowski Layer 3 SKUs ***//

//Start of Incredibles

function WSC3560X24(int_status, media_type,FRULinkname,hardwareModuleActivePorts) {
	var dev = new top.device();
	var FRUModule= FRULinkname;
	dev.noofports = 30; 
	dev.x=0;
	dev.y=0;
	dev.image = "images/3560X_24.gif";

   // drawLedsForPowerSwitch(dev);	
   drawledsforIncredibles(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 17;//8;
	var xPortStartPos = 287;//13;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 30;//27;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 46;//43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	//Add Network module
	var intNames = new Array();
	var intTypes = new Array();
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
		intTypes[i] = int_status[i][6]; // Type of Port - Incredible will have FRULink for SFP & SFP+ .SO its supporting three type of network module
	}
	
	var interfaces = "#"+intNames.join('#')+"#";

	if(FRUModule.indexOf("none") != -1) { //Total no.of ports will be 24 if it have blank module connected.
	addIncredibleLabel(dev,0);
	}
	
	else if(FRUModule.indexOf("1G Module") != -1) //1G Network module FRULink.[ G1,G2,G3,G4 ]
		draw1GNetworkModule(24,560,int_status,dev,portImages); 
	
	else if (FRUModule.indexOf("10G ST") != -1) //10G Network module FRULink. [G1,G2/Te1,G3,G4/Te2]
		draw10GNetworkModule(24,560,int_status,intTypes,dev,portImages);

	else if(FRUModule.indexOf("10G SM Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  WallE Module
		dev.image = "images/3560X_24_SM_Module.gif";
		draw10GServiceModule(24,606,int_status,intTypes,dev,portImages);
	}
    else if(FRUModule.indexOf("10GT Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  Gamma Jack Module
		dev.image = "images/3560X_24_10GT_Module.gif"; //Gamma Jack Module Support
		draw10GTNMModule(24,585,int_status,intTypes,dev,portImages,hardwareModuleActivePorts);
	}	
	dev.modeAliases = new Array ("STATUS","DUPLEX","SPEED");	
	return dev;	
}

function SW6560X24(int_status, media_type,FRULinkname,hardwareModuleActivePorts) {
	var dev = new top.device();
	var FRUModule= FRULinkname;
	dev.noofports = 30; 
	dev.x=0;
	dev.y=0;
	dev.image = "images/6560X_24.gif";

   // drawLedsForPowerSwitch(dev);	
   drawledsforIncredibles(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 17;//8;
	var xPortStartPos = 287;//13;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 30;//27;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 46;//43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	//Add Network module
	var intNames = new Array();
	var intTypes = new Array();
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
		intTypes[i] = int_status[i][6]; // Type of Port - Incredible will have FRULink for SFP & SFP+ .SO its supporting three type of network module
	}
	
	var interfaces = "#"+intNames.join('#')+"#";

	if(FRUModule.indexOf("none") != -1) { //Total no.of ports will be 24 if it have blank module connected.
	addIncredibleLabel(dev,0);
	}
	
	else if(FRUModule.indexOf("1G Module") != -1) //1G Network module FRULink.[ G1,G2,G3,G4 ]
		draw1GNetworkModule(24,560,int_status,dev,portImages); 
	
	else if (FRUModule.indexOf("10G ST") != -1) //10G Network module FRULink. [G1,G2/Te1,G3,G4/Te2]
		draw10GNetworkModule(24,560,int_status,intTypes,dev,portImages);

	else if(FRUModule.indexOf("10G SM Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  WallE Module
		dev.image = "images/6560X_24_SM_Module.gif";
		draw10GServiceModule(24,606,int_status,intTypes,dev,portImages);
	}
    else if(FRUModule.indexOf("10GT Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  Gamma Jack Module
		dev.image = "images/6560X_24_10GT_Module.gif"; //Gamma Jack Module Support
		draw10GTNMModule(24,585,int_status,intTypes,dev,portImages,hardwareModuleActivePorts);
	}	
	dev.modeAliases = new Array ("STATUS","DUPLEX","SPEED");	
	return dev;	
}


function WSC3560X24P(int_status, media_type,FRULinkname,hardwareModuleActivePorts) {
	var dev = new top.device();
	var FRUModule= FRULinkname;
	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/3560X_24_PWR.gif";

	drawledsforIncredibles_power(dev);

	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 17;//30;
	var xPortStartPos = 287;//110;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 30;//25;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 46;//41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	//Add Network module
	var intNames = new Array();
	var intTypes = new Array();
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
		intTypes[i] = int_status[i][6]; // Type of Port - Incredible will have FRULink for SFP & SFP+ .SO its supporting three type of network module
	}
	
	var interfaces = "#"+intNames.join('#')+"#";

	if(FRUModule.indexOf("none") != -1) { //Total no.of ports will be 24 if it have blank module connected.
	addIncredibleLabel(dev,0);
	}
	
	else if(FRUModule.indexOf("1G Module") != -1) //1G Network module FRULink.[ G1,G2,G3,G4 ]
		draw1GNetworkModule(24,560,int_status,dev,portImages); 
	
	else if (FRUModule.indexOf("10G ST") != -1) //10G Network module FRULink. [G1,G2/Te1,G3,G4/Te2]
		draw10GNetworkModule(24,560,int_status,intTypes,dev,portImages);

	else if(FRUModule.indexOf("10G SM Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  WallE Module
		dev.image = "images/3560X_24_PWR_SM_Module.gif";
		draw10GServiceModule(24,606,int_status,intTypes,dev,portImages);
	}else if(FRUModule.indexOf("10GT Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  Gamma Jack Module
		dev.image = "images/3560X_24_PWR_10GT_Module.gif"; //Gamma Jack Module Support
		draw10GTNMModule(24,585,int_status,intTypes,dev,portImages,hardwareModuleActivePorts);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED","PoE");	
	return dev;
	
}

function SW6560X24P(int_status, media_type,FRULinkname,hardwareModuleActivePorts) {
	var dev = new top.device();
	var FRUModule= FRULinkname;
	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/6560X_24_PWR.gif";

	drawledsforIncredibles_power(dev);

	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 17;//30;
	var xPortStartPos = 287;//110;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 30;//25;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 46;//41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	//Add Network module
	var intNames = new Array();
	var intTypes = new Array();
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
		intTypes[i] = int_status[i][6]; // Type of Port - Incredible will have FRULink for SFP & SFP+ .SO its supporting three type of network module
	}
	
	var interfaces = "#"+intNames.join('#')+"#";

	if(FRUModule.indexOf("none") != -1) { //Total no.of ports will be 24 if it have blank module connected.
	addIncredibleLabel(dev,0);
	}
	
	else if(FRUModule.indexOf("1G Module") != -1) //1G Network module FRULink.[ G1,G2,G3,G4 ]
		draw1GNetworkModule(24,560,int_status,dev,portImages); 
	
	else if (FRUModule.indexOf("10G ST") != -1) //10G Network module FRULink. [G1,G2/Te1,G3,G4/Te2]
		draw10GNetworkModule(24,560,int_status,intTypes,dev,portImages);

	else if(FRUModule.indexOf("10G SM Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  WallE Module
		dev.image = "images/6560X_24_PWR_SM_Module.gif";
		draw10GServiceModule(24,606,int_status,intTypes,dev,portImages);
	}else if(FRUModule.indexOf("10GT Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  Gamma Jack Module
		dev.image = "images/6560X_24_PWR_10GT_Module.gif"; //Gamma Jack Module Support
		draw10GTNMModule(24,585,int_status,intTypes,dev,portImages,hardwareModuleActivePorts);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED","PoE");	
	return dev;
	
}

function WSC3560X24U(int_status, media_type) {           
	var dev = new top.device();
	//var FRUModule= FRULinkname;
	
	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/3560X_24_UPOE.gif";
	
	drawledsforIncredibles_power(dev);

	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 17;//30;
	var xPortStartPos = 287;//110;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) {       
		if(i%2 == 0) {
			yPortCoord = 30;//25;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 46;//41;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }
	
	addIncredibleLabel(dev,0);

	//Add Network module
	/*var intNames = new Array();
	var intTypes = new Array();
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
		intTypes[i] = int_status[i][6]; // Type of Port - Incredible will have FRULink for SFP & SFP+ .SO its supporting three type of network module
	}
	
	var interfaces = "#"+intNames.join('#')+"#";

	if(FRUModule.indexOf("none") != -1) { //Total no.of ports will be 24 if it have blank module connected.
	addIncredibleLabel(dev,0);
	}
	
	else if(FRUModule.indexOf("1G Module") != -1) //1G Network module FRULink.[ G1,G2,G3,G4 ]
		draw1GNetworkModule(24,560,int_status,dev,portImages); 
	
	else if (FRUModule.indexOf("10G ST") != -1) //10G Network module FRULink. [G1,G2/Te1,G3,G4/Te2]
		draw10GNetworkModule(24,560,int_status,intTypes,dev,portImages);

	else if(FRUModule.indexOf("10G SM Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  WallE Module
		dev.image = "images/3560X_24_PWR_SM_Module.gif";
		draw10GServiceModule(24,606,int_status,intTypes,dev,portImages);
	}else if(FRUModule.indexOf("10GT Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  Gamma Jack Module
		dev.image = "images/3560X_24_PWR_10GT_Module.gif"; //Gamma Jack Module Support
		draw10GTNMModule(48,585,int_status,intTypes,dev,portImages,hardwareModuleActivePorts);
	} */
    
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED","UPoE");	
	return dev;
	
}
function WSC3560X48(int_status, media_type,FRULinkname,hardwareModuleActivePorts) {
	var dev = new top.device();
	var FRUModule= FRULinkname;
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/3560X_48.gif";

   // drawLedsForPowerSwitch(dev);	
   drawledsforIncredibles(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 17;//8;
	var xPortStartPos = 13;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 30;//27;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 46;//43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i== 35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	var intNames = new Array();
	var intTypes = new Array();
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
		intTypes[i] = int_status[i][6]; // Type of Port - Incredible will have FRULink for SFP & SFP+ .Its supports 3 types of network module
	}
	
	var interfaces = "#"+intNames.join('#')+"#";
	
	if(FRUModule.indexOf("none") != -1) { //Total no.of ports will be 48 if it have blank module connected.
	addIncredibleLabel(dev,0);
	}	
	else if(FRUModule.indexOf("1G Module") != -1) //1G Network module FRULink.[ G1,G2,G3,G4 ]
		draw1GNetworkModule(48,560,int_status,dev,portImages); 
	
	else if (FRUModule.indexOf("10G ST") != -1) //10G Network module FRULink. [G1,G2/Te1,G3,G4/Te2]
		draw10GNetworkModule(48,560,int_status,intTypes,dev,portImages);

	else if(FRUModule.indexOf("10G SM Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  WallE Module
		dev.image = "images/3560X_48_SM_Module.gif";
		draw10GServiceModule(48,606,int_status,intTypes,dev,portImages);
	}
	else if(FRUModule.indexOf("10GT Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  Gamma Jack Module
		dev.image = "images/3560X_48_10GT_Module.gif"; //Gamma Jack Module Support
		draw10GTNMModule(48,585,int_status,intTypes,dev,portImages,hardwareModuleActivePorts);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	return dev;
}
function SW6560X48(int_status, media_type,FRULinkname,hardwareModuleActivePorts) {  
	var dev = new top.device();
	var FRUModule= FRULinkname;
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/6560X_48.gif";

   // drawLedsForPowerSwitch(dev);	
   drawledsforIncredibles(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 17;//8;
	var xPortStartPos = 13;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 30;//27;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 46;//43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i== 35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	var intNames = new Array();
	var intTypes = new Array();
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
		intTypes[i] = int_status[i][6]; // Type of Port - Incredible will have FRULink for SFP & SFP+ .Its supports 3 types of network module
	}
	
	var interfaces = "#"+intNames.join('#')+"#";
	
	if(FRUModule.indexOf("none") != -1) { //Total no.of ports will be 48 if it have blank module connected.
	addIncredibleLabel(dev,0);
	}	
	else if(FRUModule.indexOf("1G Module") != -1) //1G Network module FRULink.[ G1,G2,G3,G4 ]
		draw1GNetworkModule(48,560,int_status,dev,portImages); 
	
	else if (FRUModule.indexOf("10G ST") != -1) //10G Network module FRULink. [G1,G2/Te1,G3,G4/Te2]
		draw10GNetworkModule(48,560,int_status,intTypes,dev,portImages);

	else if(FRUModule.indexOf("10G SM Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  WallE Module
		dev.image = "images/6560X_48_SM_Module.gif";
		draw10GServiceModule(48,606,int_status,intTypes,dev,portImages);
	}
	else if(FRUModule.indexOf("10GT Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  Gamma Jack Module
		dev.image = "images/6560X_48_10GT_Module.gif"; //Gamma Jack Module Support
		draw10GTNMModule(48,585,int_status,intTypes,dev,portImages,hardwareModuleActivePorts);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	return dev;
}


function WSC3560X48P(int_status, media_type,FRULinkname,hardwareModuleActivePorts) {
	var dev = new top.device();
	var FRUModule= FRULinkname;

	dev.noofports = 54; 
	dev.x=0;
	dev.y=0;
	dev.image = "images/3560X_48_PWR.gif";

   // drawLedsForPowerSwitch(dev);	
   drawledsforIncredibles_power(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 17;//8;
	var xPortStartPos = 13;//17;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 30;//27;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 46;//43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i== 35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	var intNames = new Array();
	var intTypes = new Array();
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
		intTypes[i] = int_status[i][6]; // Type of Port - Incredible will have FRULink for SFP & SFP+ .Its supports 3 types of network module
	}
	
	var interfaces = "#"+intNames.join('#')+"#";
	
	if(FRUModule.indexOf("none") != -1) { //Total no.of ports will be 48 if it have blank module connected.
	addIncredibleLabel(dev,0);
	}	
	else if(FRUModule.indexOf("1G Module") != -1) //1G Network module FRULink.[ G1,G2,G3,G4 ]
		draw1GNetworkModule(48,560,int_status,dev,portImages); 
	
	else if (FRUModule.indexOf("10G ST") != -1) //10G Network module FRULink. [G1,G2/Te1,G3,G4/Te2]
		draw10GNetworkModule(48,560,int_status,intTypes,dev,portImages);

	else if(FRUModule.indexOf("10G SM Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  WallE Module
		dev.image = "images/3560X_48_PWR_SM_Module.gif";
		draw10GServiceModule(48,606,int_status,intTypes,dev,portImages);
	}
	else if(FRUModule.indexOf("10GT Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  Gamma Jack Module
		dev.image = "images/3560X_48_PWR_10GT_Module.gif"; //Gamma Jack Module Support
		draw10GTNMModule(48,585,int_status,intTypes,dev,portImages,hardwareModuleActivePorts);
	}
	
	dev.modeAliases = new Array ("STATUS","DUPLEX","SPEED","PoE");	
	return dev;
}

function SW6560X48P(int_status, media_type,FRULinkname,hardwareModuleActivePorts) {
	var dev = new top.device();
	var FRUModule= FRULinkname;

	dev.noofports = 54; 
	dev.x=0;
	dev.y=0;
	dev.image = "images/6560X_48_PWR.gif";

   // drawLedsForPowerSwitch(dev);	
   drawledsforIncredibles_power(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 17;//8;
	var xPortStartPos = 13;//17;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 30;//27;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 46;//43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i== 35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	var intNames = new Array();
	var intTypes = new Array();
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
		intTypes[i] = int_status[i][6]; // Type of Port - Incredible will have FRULink for SFP & SFP+ .Its supports 3 types of network module
	}
	
	var interfaces = "#"+intNames.join('#')+"#";
	
	if(FRUModule.indexOf("none") != -1) { //Total no.of ports will be 48 if it have blank module connected.
	addIncredibleLabel(dev,0);
	}	
	else if(FRUModule.indexOf("1G Module") != -1) //1G Network module FRULink.[ G1,G2,G3,G4 ]
		draw1GNetworkModule(48,560,int_status,dev,portImages); 
	
	else if (FRUModule.indexOf("10G ST") != -1) //10G Network module FRULink. [G1,G2/Te1,G3,G4/Te2]
		draw10GNetworkModule(48,560,int_status,intTypes,dev,portImages);

	else if(FRUModule.indexOf("10G SM Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  WallE Module
		dev.image = "images/6560X_48_PWR_SM_Module.gif";
		draw10GServiceModule(48,606,int_status,intTypes,dev,portImages);
	}
	else if(FRUModule.indexOf("10GT Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  Gamma Jack Module
		dev.image = "images/6560X_48_PWR_10GT_Module.gif"; //Gamma Jack Module Support
		draw10GTNMModule(48,585,int_status,intTypes,dev,portImages,hardwareModuleActivePorts);
	}
	
	dev.modeAliases = new Array ("STATUS","DUPLEX","SPEED","PoE");	
	return dev;
} 

function WSC3560X48U(int_status, media_type) {
	var dev = new top.device();
	//var FRUModule= FRULinkname;

	dev.noofports = 54; 
	dev.x=0;
	dev.y=0;
	dev.image = "images/3560X_48_UPOE.gif";

   // drawLedsForPowerSwitch(dev);	
   drawledsforIncredibles_power(dev);
	
	// Create the ports
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 17;//8;
	var xPortStartPos = 13;//17;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 30;//27;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 46;//43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==11 || i == 23 || i== 35) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	/*var intNames = new Array();
	var intTypes = new Array();
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
		intTypes[i] = int_status[i][6]; // Type of Port - Incredible will have FRULink for SFP & SFP+ .Its supports 3 types of network module
	}
	
	var interfaces = "#"+intNames.join('#')+"#";
	
	if(FRUModule.indexOf("none") != -1) { //Total no.of ports will be 48 if it have blank module connected.
	addIncredibleLabel(dev,0);
	}	
	else if(FRUModule.indexOf("1G Module") != -1) //1G Network module FRULink.[ G1,G2,G3,G4 ]
		draw1GNetworkModule(48,560,int_status,dev,portImages); 
	
	else if (FRUModule.indexOf("10G ST") != -1) //10G Network module FRULink. [G1,G2/Te1,G3,G4/Te2]
		draw10GNetworkModule(48,560,int_status,intTypes,dev,portImages);

	else if(FRUModule.indexOf("10G SM Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  WallE Module
		dev.image = "images/3560X_48_PWR_SM_Module.gif";
		draw10GServiceModule(48,606,int_status,intTypes,dev,portImages);
	}
	else if(FRUModule.indexOf("10GT Module") != -1) {	//10G Service Module FRULink. [G2/Te1,G4/Te2]  Gamma Jack Module
		dev.image = "images/3560X_48_PWR_10GT_Module.gif"; //Gamma Jack Module Support
		draw10GTNMModule(48,585,int_status,intTypes,dev,portImages,hardwareModuleActivePorts);
	}*/
	addIncredibleLabel(dev,0);
	dev.modeAliases = new Array ("STATUS","DUPLEX","SPEED","UPoE");	
	return dev;
}

function drawledsforIncredibles(dev) {
    var modeBtn = new top.modebtn("images/C3560E_PD_mode.gif");
	modeBtn.x = 24;//28;//36;//30;
	modeBtn.y = 6;//10;//67;//63;
	modeBtn.height = 9;//8;
	modeBtn.width = 11;//16;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	//USB Console - enable LED 
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 68;//74;//13;
	tempLed.y = 13;//21;
	tempLed.id = "usb_console_led";
	tempLed.device = dev;
	dev.sysleds["USB CONSOLE"] = tempLed;
	
	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 67;//13;
	tempLed.y = 6;//21;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 98;
	tempLed.y = 6;//27;
	tempLed.id = "rps_led"; 
	tempLed.device = dev; 
	dev.sysleds["RPS"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 128;//13;
	tempLed.y = 6;//39;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	
	tempLed = new top.led(ledImages);
	tempLed.x = 159;//13;
	tempLed.y = 6;//51;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 190;//13;
	tempLed.y = 6;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

		
}

function drawledsforIncredibles_power(dev) {
   var modeBtn = new top.modebtn("images/C3560E_PD_mode.gif");
	modeBtn.x = 24;//28;//36;//30;
	modeBtn.y = 6;//10;//67;//63;
	modeBtn.height = 9;//8;
	modeBtn.width = 11;//16;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		
	
	//USB Console - enable LED 
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 68;//74;//13;
	tempLed.y = 13;//21;
	tempLed.id = "usb_console_led";
	tempLed.device = dev;
	dev.sysleds["USB CONSOLE"] = tempLed;
	

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 67;//13;
	tempLed.y = 5;//21;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 98;
	tempLed.y = 6;//27;
	tempLed.id = "rps_led"; 
	tempLed.device = dev; 
	dev.sysleds["RPS"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 128;//13;
	tempLed.y = 6;//39;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	
	tempLed = new top.led(ledImages);
	tempLed.x = 158;//13;
	tempLed.y = 6;//51;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 190;//13;
	tempLed.y = 6;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 190;//13;
	tempLed.y = 13;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;
	
}

function draw1GNetworkModule(portIndex,xPortStartPos,int_status,dev,portImages) {
	var port;
	var	portInd = portIndex;
	var	xPortCoord = xPortStartPos;
	var	xPortGap = 1;
	var	portWidth = 23;
		for(i=portInd; i<portInd+4; i++) 
		{       
			yPortCoord = 50;//13;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		
		}
			addIncredibleLabel(dev,1);  // add G1,G2,G3,G4 label			
}

function draw10GNetworkModule(portIndex,xPortStartPos,int_status,intTypes,dev,portImages) {// 10G Network module FRULink. [G1,G2,G3,G4, Te1,Te2]
		var port;
		var portInd = portIndex;
		var xPortCoord = xPortStartPos;
		var xPortGap = 1;
		var portWidth = 23;
		var yPortCoord = 50;
		if(intTypes[portInd+4] != "Not Present" || intTypes[portInd+5] != "Not Present") //Te1 and Te2 
		{
			if (intTypes[portInd] != "Not Present" || intTypes[portInd+1] != "Not Present")	
				{	
				for(i=portInd; i<portInd+3; i++) //G1,G2,Te2
					{    
						if(i == portInd+2){
						port = new top.SFPplusport(int_status[i+3][6], portImages);// pass the module type plugged-in the SFP slot
						}
						else 
						port = new top.SFPport(int_status[i][6], portImages);
						port.index = i;
						port.id = "port_" + i;
						port.x = xPortCoord;
						port.y = yPortCoord;
						if(i == portInd+1) xPortGap=25;//5;
						xPortCoord += portWidth + xPortGap;
						dev.addPort(port);
			
					}
			addIncredibleLabel(dev,4);
			}
			else if (intTypes[portInd+4] != "Not Present" && (intTypes[portInd+2] != "Not Present" 
				|| intTypes[portInd+3] != "Not Present"))		// Te1 and G3, G4
				{	
				xPortCoord = 562;
				for(i=portInd; i<portInd+3; i++) // Te1,G3,G4 
					{    
					if(i == portInd) {
					xPortCoord = 585;//562;
					portWidth=23;//43;
					port = new top.SFPplusport(int_status[i+4][6], portImages); // pass the module type plugged-in the SFP slot
					port.index = i;
					port.id = "port_" + i;
					port.x = xPortCoord;
					port.y = yPortCoord;			
					xPortCoord += portWidth + xPortGap;
					}
					else {
					port = new top.SFPport(int_status[i+1][6], portImages);
					portWidth=23;
					xPortGap = 1;
					port.index = i;
					port.id = "port_" + i;
					port.x = xPortCoord;
					port.y = yPortCoord;			
					xPortCoord += portWidth + xPortGap; 
					}
					dev.addPort(port);
				}
				addIncredibleLabel(dev,3);
			}
			else 
				{ //For Te1,Te2
					xPortCoord = 585;//560;
					for(i=portInd; i<portInd+2; i++){			
					//portWidth = 43;
					xPortGap = 25;//5;
					port = new top.SFPplusport(int_status[i+4][6], portImages); 
					port.index = i;
					port.id = "port_" + i;
					port.x = xPortCoord;
					port.y = yPortCoord;			
					xPortCoord += portWidth + xPortGap;
					dev.addPort(port);
				}
				addIncredibleLabel(dev,2);//Te1 and Te2 Label
			}
		}
		else
		{
			for(i=portInd; i<portInd+4; i++) //G1,G2,G3,G4
			{    
				port = new top.SFPport(int_status[i][6], portImages);
				port.index = i;
				port.id = "port_" + i;
				port.x = xPortCoord;
				port.y = yPortCoord;			
				xPortCoord += portWidth + xPortGap;
				dev.addPort(port);
			}		
				
		addIncredibleLabel(dev,5);// add G1,G2,G3,G4 label for 10G NM Module
		}
	}
	
function draw10GServiceModule(portIndex,xPortStartPos,int_status,intTypes,dev,portImages){
		var port;
		var portInd = portIndex;
		var xPortCoord = xPortStartPos;
		var	yPortCoord = 47;
		var xPortGap = 1;
		var portWidth = 23;
			
		for (var i=portInd;i<portInd+2;i++)
		{ 
	
			if (intTypes[i] != "Not Present")
			port = new top.SFPport(int_status[i][6], portImages); // 1G 
			else 
			port = new top.SFPplusport(int_status[i+2][6], portImages); // 10G 
			port.index = i;
			port.id = "port_" + i;
			port.x = xPortCoord;
			port.y = yPortCoord;			
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}

}
function draw10GTNMModule(portIndex,xPortStartPos,int_status,intTypes,dev,portImages,hardwareModuleActivePorts){
        var port;
		var portInd = portIndex;
		var xPortCoord = xPortStartPos;
		var	yPortCoord = 51;
		var xPortGap = 1;
		var portWidth = 23;
		for (var i=portInd;i<portInd+2;i++){
		   if(hardwareModuleActivePorts[i-portInd].indexOf("Gi")!=-1)
						port = new top.SFPport(int_status[i][6], portImages); // 1G 
				else
						port = new top.SFPplusport(int_status[i][6], portImages); // 10G 
				port.index = i;
				port.id = "port_" + i;
				port.x = xPortCoord;
				port.y = yPortCoord;			
				xPortCoord += portWidth + xPortGap;
				dev.addPort(port);
		}
 }
 //Start of Ginjo 12PWR
function WSC3560C12PCS(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 14;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WS3560C_12PC_S.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds(dev);

	// PoE led	
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 48;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3;
	var xPortGroupGap = 9;
	var xPortStartPos = 208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
   // Add the 12 FastEthernet ports.
	for(i=0; i<12; i++){
	
		if(i%2 == 0) {
			yPortCoord = 19;//26;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 36;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 393;
	yPortCoord = 24;//49;
	for(i=12; i<14; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "DUPLEX", "SPEED","PoE");
	return dev;
}

function WSC3560CX_12PC_S(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 16;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC3560CX_12PC_S.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds_WSC3560CX(dev);

	// PoE led	
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 41;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3;
	var xPortGroupGap = 9;
	var xPortStartPos = 208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
   // Add the 12 FastEthernet ports.
	for(i=0; i<12; i++){
	
		if(i%2 == 0) {
			yPortCoord = 19;//26;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 36;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	xPortCoord = 350;//381;//397;
	yPortCoord = 36;//53;//49;
	xPortGap=0;
	for(i=12; i<14; i++){
 	    yPortCoord = 36;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 400;
	yPortCoord = 24;//49;
	for(i=14; i<16; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "SPEED","PoE");
	return dev;
}
function WSC3560CX_12PD_S(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 16;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC3560CX_12PD_S.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds_WSC3560CX(dev);

	// PoE led	
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 41;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3;
	var xPortGroupGap = 9;
	var xPortStartPos = 208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
   // Add the 12 FastEthernet ports.
	for(i=0; i<12; i++){
	
		if(i%2 == 0) {
			yPortCoord = 19;//26;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 37;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	xPortCoord = 350;//381;//397;
	yPortCoord = 37;//53;//49;
	xPortGap=0;
	for(i=12; i<14; i++){
 	    yPortCoord = 37;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 400;
	yPortCoord = 24;//49;
	for(i=14; i<16; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "SPEED","PoE");
	return dev;
}
function WSC3560CX_12TC_S(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 16;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC3560CX_12TC_S.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds_WSC3560CX(dev);
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 3;
	var xPortGroupGap = 9;
	var xPortStartPos = 208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
   // Add the 12 FastEthernet ports.
	for(i=0; i<12; i++){
	
		if(i%2 == 0) {
			yPortCoord = 20;//26;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 37;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	xPortCoord = 350;//381;//397;
	yPortCoord = 37;//53;//49;
	xPortGap=0;
	for(i=12; i<14; i++){
 	    yPortCoord = 37;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 400;
	yPortCoord = 24;//49;
	for(i=14; i<16; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "SPEED");
	return dev;
}
//Start of Ginjo 8PWR
function WSC3560C8PCS(int_status, media_type) 
{
	var dev = new top.device();
	dev.noofports = 10;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WS3560C_8PC_S.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds(dev);

	
	// PoE led	
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 48;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 247;//208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 8 FastEthernet ports.
	for(i=0; i<8; i++){
	
		if(i%2 == 0) {
			yPortCoord = 22;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 39;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0){
		xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 393;
	yPortCoord = 24;//49;
	for(i=8; i<10; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "DUPLEX", "SPEED","PoE");
	return dev;
} 
function WSC3560CX_8PC_S(int_status, media_type)                   //Smirnoff Support
{
	var dev = new top.device();
	dev.noofports = 12;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC3560CX_8PC_S.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds_WSC3560CX(dev);

	
	// PoE led	
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 41;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 247;//208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 8 FastEthernet ports.
	for(i=0; i<8; i++){
	
		if(i%2 == 0) {
			yPortCoord = 22;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 39;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0){
		xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	xPortCoord = 339;//381;//397;
	yPortCoord = 38;//53;//49;
	xPortGap=0;
	for(i=8; i<10; i++){
 	    yPortCoord = 38;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 400;
	yPortCoord = 24;//49;
	for(i=10; i<12; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=29;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "SPEED","PoE");
	return dev;
} 
function WSC3560CX_8TC_S(int_status, media_type)                   //Smirnoff Support
{
	var dev = new top.device();
	dev.noofports = 12;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC3560CX_8TC_S.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds_WSC3560CX(dev);

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 247;//208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 8 FastEthernet ports.
	for(i=0; i<8; i++){
	
		if(i%2 == 0) {
			yPortCoord = 22;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 39;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0){
		xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	xPortCoord = 339;//381;//397;
	yPortCoord = 39;//53;//49;
	xPortGap=0;
	for(i=8; i<10; i++){
 	    yPortCoord = 38;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 390;
	yPortCoord = 24;//49;
	for(i=10; i<12; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "SPEED");
	return dev;
} 
function WSC3560CX_8PD_S(int_status, media_type)                   //Smirnoff Support
{
	var dev = new top.device();
	dev.noofports = 12;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC3560CX_8PD_S.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds_WSC3560CX(dev);
		// PoE led	
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 41;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;
	//STACK Led
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 48;
	tempLed.id = "stack";
	tempLed.device = dev;
	dev.sysleds["STACK"] = tempLed;
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 247;//208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 8 FastEthernet ports.
	for(i=0; i<8; i++){
	
		if(i%2 == 0) {
			yPortCoord = 22;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 39;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0){
		xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	xPortCoord = 350;//381;//397;
	yPortCoord = 39;//53;//49;
	xPortGap=0;
	for(i=8; i<10; i++){
 	    yPortCoord = 39;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 400;
	yPortCoord = 24;//49;
	for(i=10; i<12; i++){       
		var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : "10/100/1000BaseTX";
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "SPEED", "PoE", "STACK");
	return dev;
} 
function WSC3560CX_8XPD_S(int_status, media_type)                   //Smirnoff Support..GA
{
	var dev = new top.device();
	dev.noofports = 12;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC3560CX_8XPD_S.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds_WSC3560CX_8XPD_S(dev);
		// PoE led	
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 41;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;
	//STACK Led
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 48;
	tempLed.id = "stack_led";
	tempLed.device = dev;
	dev.sysleds["STACK"] = tempLed; 
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 247;//208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 8 FastEthernet ports.
	for(i=0; i<6; i++){
	
		if(i%2 == 0) {
			yPortCoord = 22;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 39;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0){
		xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	xPortCoord = 320;//381;//397;
	yPortCoord = 38;//53;//49;
	xPortGap=0;
	for(i=6; i<8; i++){
 	    yPortCoord = 38;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	//Add Two composite port
	xPortCoord = 400;
	yPortCoord = 24;//49;
	for(i=8; i<10; i++){
	  /* yPortCoord = 38;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);*/
	
		var intType = ((int_status[i])[6].indexOf("SFP") != -1) ? ((int_status[i])[6] + "-10/100/1000BaseTX" ): ("10/100/1000BaseTX");
		port = new top.rj45Compositeport(intType,portImages);
        port.index = i;
        port.x = xPortCoord;
        port.y = yPortCoord;
        port.width = 19;//44;
        port.height = 37;//17;
		port.sfpx = 0;//22;
		port.sfpy = 0;
		port.rj45x = 1;
		port.rj45y = 22;//19;
		port.id = "port_" + i;
		xPortCoord +=31;//
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "SPEED", "STACK", "PoE");
	return dev;
} 
function WSC3560CX_8PT_S(int_status, media_type)                   //Smirnoff Support..Belwadere
{
	var dev = new top.device();
	dev.noofports = 10;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC3560CX_8PT_S.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds_WSC3560CX_8PT_S(dev);
		// PoE led	
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 42;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;
	//PD led
	tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 49;
	tempLed.id = "pd_led";
	tempLed.device = dev;
	dev.sysleds["PD"] = tempLed;
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 247;//208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 8 FastEthernet ports.
	for(i=0; i<8; i++){
	
		if(i%2 == 0) {
			yPortCoord = 22;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 39;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0){
		xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	xPortCoord = 339;//381;//397;
	yPortCoord = 37;//53;//49;
	xPortGap=0;
	for(i=8; i<10; i++){
 	    yPortCoord = 37;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "SPEED", "PoE", "PD");
	return dev;
} 
function WSC3560CPX_8PT_S(int_status, media_type)                   //Smirnoff Support
{
	var dev = new top.device();
	dev.noofports = 10;
	dev.x=0;
	dev.y=0;
	dev.image = "images/WSC3560CPX_8PT_S.gif";	

	// Construct the mode button and the system LEDs
	construct_Choya_leds_WSC3560CX(dev);
		// PoE led	
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 41;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;
	//PD led
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 48;
	tempLed.id = "pd_led";
	tempLed.device = dev;
	dev.sysleds["PD"] = tempLed;
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 0;
	var xPortGroupGap = 9;
	var xPortStartPos = 247;//208;//113;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 8 FastEthernet ports.
	for(i=0; i<8; i++){
	
		if(i%2 == 0) {
			yPortCoord = 22;//27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 39;//42;//43;
			port = new top.rj45port(portImages);
		}

		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0){
		xPortCoord += portWidth + xPortGap;
		}
		dev.addPort(port);
	}
	xPortCoord = 350;//381;//397;
	yPortCoord = 39;//53;//49;
	xPortGap=0;
	for(i=8; i<10; i++){
 	    yPortCoord = 39;
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	dev.modeAliases = new Array("STATUS", "SPEED", "PoE", "PD");
	return dev;
} 
function construct_Choya_leds(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 20;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 27;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 34;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 41;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;


	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/pilsner2_mode.gif"); 
	modeBtn.x = 32;
	modeBtn.y = 55;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}
function construct_Choya_leds_WSC3560CX_8XPD_S(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 21;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 28;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 35;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
    tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 42;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 49;
	tempLed.id = "stack_led";
	tempLed.device = dev;
	dev.sysleds["STACK"] = tempLed;

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/pilsner2_mode.gif"); 
	modeBtn.x = 32;
	modeBtn.y = 55;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}
function construct_Choya_leds_WSC3560CX_8PT_S(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 21;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 28;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 35;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
    tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 42;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 169;
	tempLed.y = 49;
	tempLed.id = "pd_led";
	tempLed.device = dev;
	dev.sysleds["PD"] = tempLed;

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/pilsner2_mode.gif"); 
	modeBtn.x = 32;
	modeBtn.y = 55;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}
function construct_Choya_leds_WSC3560CX(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 20;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 27;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 168;
	tempLed.y = 34;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;


	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/pilsner2_mode.gif"); 
	modeBtn.x = 32;
	modeBtn.y = 55;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}
