/**
 Description: Controller for AAA
 Copyright (c) 2017 by Cisco Systems, Inc.
 All rights reserved.
 */
app.register.controller('aaaCtrl', ['$scope','$rootScope','$timeout', '$filter', 'gridCrudService','requestRoutingService','dataSourceService','dialogService','notificationService','executeCliCmdService','validationService','aaaService',
    function($scope,$rootScope,$timeout, $filter, gridCrudService,requestRoutingService,dataSourceService,dialogService,notificationService,executeCliCmdService,validationService,aaaService) {
		var translate = $filter("translate");
		var trimVal=$filter('trimValue');
		var totalRadiusServer= 0,totalTacacsServer= 0,totalLdapServer= 0;
		var oldAAAStatus, oldServerRadiusGridData = [];
		$scope.kendoWindow = {isEditMode:true,isEditMode1:true  };
		$scope.deleteRadiusServers=true;
		$scope.deleteaaaPolicy=true;
		$scope.disableApplyButton=true;
		angular.extend($scope, {
			 aaa:{
				servers:{
					radius:{
						aaaProtocol:null
					},
					policy:{
						aaaProtocol:null,
						aaapolicyProt:null
					}
				}
			}
		});
		angular.element(".pageLoader").show();
		// AAA server start
		$scope.serverRadiusGridOptions = {
			editable : false,
			sortable : true,
			scrollable : false,
			selectable : true,
			pageable : {
				messages: {
					display: translate("com_page_display"),
					empty: translate("com_page_empty"),
					page: translate("com_page_pagetext"),
					of:translate("com_page_of"),
					itemsPerPage: translate("com_page_itemsPerPage"),
					first: translate("com_page_first"),
					previous: translate("com_page_previous"),
					next: translate("com_page_next"),
					last: translate("com_page_last"),
					refresh: translate("com_page_refresh"),
					morePages: translate("com_page_morePage")
				},
				previousNext : true,
				info : true,
				refresh : true,
				pageSizes : gridCrudService.grid_page_sizes,
				buttonCount : 5
			},
			columns : [{
				"template": "<input type=\"checkbox\" ng-init=\"radiusServer=false\" ng-model=\"radiusServer\" ng-click=\"selectRows(radiusServer,dataItem)\"/>",
				sortable: false,
				width: 40
			}, {
				field : "name",
				title : translate("com_name")
			}, {
				field : "address",
				title : translate("aaa_address")
			}, {
				field : "aaaProtocol",
				title : translate("etherchannel_protocol")
			}, {
				field : "test",
				template: "<img src='../resources/images/play_icon.png' width='20' id='#= name #' class='' ng-click=\"pingIP(dataItem,'#= name #')\" />",
				title : translate("com_ping")
			}]
		};
		$scope.protocolData = new kendo.data.DataSource({
			data : [{
					protocolName  : translate('aaa_radius'),
					protocolValue : 'radius'
				},{
					protocolName  : translate('aaa_tacacs'),
					protocolValue : 'tacacs'
				},{
					 protocolName  : translate('aaa_ldap'),
					 protocolValue : 'ldap'
			}]
		});
		//Kendo Validations
		$scope.aaaValidations = {
			rules : {
				max : function(input) {
					var maxlength = input.data('max');
					if (maxlength) {
						return input.val().length < Number(maxlength);
					}
					return true;
				},
				min : function(input) {
					var minValue = input.data('min');
					if (minValue){
						return input.val().length > Number(minValue);
					}
					return true;
				},
				range: function (input) {
					if(input.val()){
						if(input.val() != ""){
							var count=0;
							var valMsg = input.data('rangeMsg');
							if ((valMsg==undefined)) {
								return true;
							}
							var min= trimVal(input.prop('min'));
							var max= trimVal(input.prop('max'));
							var arr = input.val().replace('-',',');
							arr= arr.split(',');
							for(var i=0;i<arr.length;i++){
								if(parseFloat(trimVal(arr[i]))>=min && parseFloat(trimVal(arr[i]))<=max) {
									count++;
								}
							}
							if(arr.length!=count){
								return false;
							}
							return true;
						}
						else {
							return true;
						}
					}else{
						return true;
					}
				},
				validateip : function(input) {
					if (angular.isUndefined(input.data('validateIp'))) {
						return true;
					}
					var value = input.val();
					if (validationService.validateIpAddress(value) == false && validationService.validateIpv6Address(value) == false) {
						return false;
					}
					else {
						return true;
					}
				},
				aaaservers : function(input) {
					if (angular.isUndefined(input.data('aaaservers'))) {
						return true;
					} else {
						if (input.val().toUpperCase() == "RADIUS" || input.val().toUpperCase() == "TACACS" || input.val().toUpperCase() == "LDAP") {
							return false;
						} else {
							return true;
						}
					}
				},
				radiusduplicate: function(input){
                    if (angular.isUndefined(input.data('radiusduplicate'))) {
                        return true;
                    } else {
                        for (var index = 0; index < $scope.serverRadiusGridData.length; index++) {
                            if (($scope.serverRadiusGridData[index].name === $scope.aaa.servers.radius.name) && ($scope.serverRadiusGridData[index].aaaProtocol === $scope.aaa.servers.radius.aaaProtocol)){
                                return false;
                            }
                        }
                        return true;
                    }
                }
			}
		};
		var serverWindow = angular.element("#serverWindow");
		serverWindow.kendoWindow({
			modal: true,
			width: "800px",
			title: "<div>"+translate("aaa_server_title")+"</div>",
			visible: false,
			actions: [
				"Close"
			]
		}).data("kendoWindow").center();
		$scope.doneAddEditKendoWindow = function(btnState){
			if($scope.radiusServersValidator.validate()){
				if($scope.aaa.servers.radius.created && btnState == "save"){
					if(!$scope.aaa.servers.radius.authport) {
						$scope.aaa.servers.radius.authport = "1645";
					}
					if(!$scope.aaa.servers.radius.acctport) {
						$scope.aaa.servers.radius.acctport = "1646";
					}
					$scope.serverRadiusGridData.push($scope.aaa.servers.radius);
				}else{
					$scope.updateAAAServerChange();
				}
				serverWindow.data("kendoWindow").close();
				$scope.applyAAAServer();
			}
		}
		$scope.protocolChange = function(){
			angular.element("#radiusServersForm  span.k-tooltip-validation").hide();
			if($scope.aaa.servers.radius.aaaProtocol == "radius"){
				$scope.aaa.servers.radius.name = "Radius_"+(parseFloat(totalRadiusServer)+1);
			}else if($scope.aaa.servers.radius.aaaProtocol == "tacacs"){
				$scope.aaa.servers.radius.name = "TACACS_"+(parseFloat(totalTacacsServer)+1);
			}else if($scope.aaa.servers.radius.aaaProtocol == "ldap"){
				$scope.aaa.servers.radius.name = "LDAP_"+(parseFloat(totalLdapServer)+1);
			}
		}
		$scope.globalStatusChange = function(){
			if(oldAAAStatus != $scope.aaaStatus){
				$scope.disableApplyButton= false;
			}else{
				$scope.disableApplyButton= true;
			}
		}
		$scope.addServerRadiusRow = function(){
			$scope.disableRadiusServersName = false;
			$scope.disableProtocolName = false;
			angular.element("#radiusServersForm  span.k-tooltip-validation").hide();
			$scope.aaa.servers.radius = {};
			$scope.aaa.servers.radius.aaaProtocol = "radius";
			if($scope.aaa.servers.radius.aaaProtocol == "radius"){
				$scope.aaa.servers.radius.name = "Radius_"+(parseFloat(totalRadiusServer)+1);
			}else if($scope.aaa.servers.radius.aaaProtocol == "tacacs"){
				$scope.aaa.servers.radius.name = "TACACS_"+(parseFloat(totalTacacsServer)+1);
			}else if($scope.aaa.servers.radius.aaaProtocol == "ldap"){
				$scope.aaa.servers.radius.name = "LDAP_"+(parseFloat(totalLdapServer)+1);
			}
			$scope.hideQuickSetupRadiusServers = false;
			$scope.aaa.servers.radius.created = true;
			serverWindow.data("kendoWindow").open().center();
			$scope.kendoWindow.isEditMode = true;
		}
		$scope.cancelAddEditKendoWindow = function(){
			serverWindow.data("kendoWindow").close();
		};
		$scope.deleteConfirmation = function (callbackname) {
            $scope.dlgAAA = dialogService.dialog({
                content : translate('msg_delete_confirmation'),
                title : translate('msg_delete_confirmation_window'),
                messageType : "confirm",
                actionButtons : [{
                    text : translate('com_ok'),
                    callback : callbackname
                }, {
                    text : translate('com_cancel')
                }]
            });
        };
		$scope.$on("deleteServer", function() {
            $scope.dlgAAA.data("kendoWindow").close();
            $scope.delServerRadiusRow();
        });
        $scope.cancelAuthentication = function(){
           $scope.aaa.servers.radius = {};
            $scope.hideQuickSetupRadiusServers = true;
        }
		$scope.selectedArray = [];
		$scope.selectRows = function (checked, dataItem) {
			if (checked == false) {
				var index = $scope.selectedArray.indexOf(dataItem);
				if (index > -1) {
					$scope.selectedArray.splice(index, 1);
					if($scope.selectedArray.length === 0){
						$scope.deleteRadiusServers = true;
					}
				}
			}
			else {
				$scope.deleteRadiusServers = false;
				$scope.selectedArray.push(dataItem);
			}
		};
		$scope.delServerRadiusRow = function() {
			$scope.deleteRadiusServers = true;
			$scope.deleteStaticArray = [];
			for (var index = 0; index < $scope.selectedArray.length; index++) {
				$scope.aaaServerRadiusGrid.dataSource.remove($scope.selectedArray[index]);
				$scope.deleteStaticArray.push($scope.selectedArray[index]);
			}
			$scope.selectedArray = [];
			$timeout(function(){
				$scope.deleteAAAServer();
			},10);
		};
		$scope.deleteAAAServer = function(){
			var deleteaaaConfigCli = "";
			for (var del = 0; del < $scope.deleteStaticArray.length; del++) {
				if($scope.deleteStaticArray[del].aaaProtocol == "radius"){
					deleteaaaConfigCli += "no radius server "+$scope.deleteStaticArray[del].name+"\n";
					deleteaaaConfigCli += "aaa server radius dynamic-author \n";
					deleteaaaConfigCli += "no client "+$scope.deleteStaticArray[del].address+ " server-key "+$scope.deleteStaticArray[del].password+"\n";
				}else if($scope.deleteStaticArray[del].aaaProtocol == "tacacs"){
					deleteaaaConfigCli += "no tacacs server "+$scope.deleteStaticArray[del].name+"\n";
				}else if($scope.deleteStaticArray[del].aaaProtocol == "ldap"){
					deleteaaaConfigCli += "no ldap server "+$scope.deleteStaticArray[del].name+"\n";
				}
			}
			deleteaaaConfigCli += "exit\n";
			if(deleteaaaConfigCli != ""){
				var result = requestRoutingService.getConfigCmdOutput(deleteaaaConfigCli);
				if(result==""){
					notificationService.showNotification(translate('aaa_success_msg'),translate('com_config_success_title'),'success');
				}else{
					notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
				}
			}
			$scope.loadAAAServer();
		}
		// Refresh button trigger
		angular.element("#aaaServerRadiusGrid").delegate(".k-pager-refresh", "click", function(){
			$scope.deleteRadiusServers = true;
			$scope.selectedArray = [];
			if (!$scope.$$phase){
				$scope.$apply();
			}
		});
		$scope.manualServerGridRefresh = function(){
			$scope.deleteRadiusServers = true;
			$scope.selectedArray = [];
			if (!$scope.$$phase){
				$scope.$apply();
			}
		}
		$scope.applyAAAStatus = function(){
			var aaaStatusConfigCli = "";
			if($scope.aaaStatus == translate("com_enable")){
				aaaStatusConfigCli += "aaa new-model \n";
			}else{
				aaaStatusConfigCli += "no aaa new-model \n";
			}
			aaaStatusConfigCli += "exit\n";
			if(aaaStatusConfigCli != ""){
				var result = requestRoutingService.getConfigCmdOutput(aaaStatusConfigCli);
				if(result==""){
					notificationService.showNotification(translate('aaa_success_msg'),translate('com_config_success_title'),'success');
				}else{
					notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
				}
			}
			$scope.disableApplyButton = true;
			$scope.loadAAAServer();
		}
		$scope.isPing = false;
		$scope.onSelectAAAserverHandler = function(data) {
			if(!$scope.isPing){
				$scope.disableRadiusServersName = true;
				$scope.disableProtocolName = true;
				angular.element("#radiusServersForm  span.k-tooltip-validation").hide();
				$scope.aaa.servers.radius = angular.copy(data);
				$scope.kendoWindow.isEditMode = false;
				serverWindow.data("kendoWindow").open();
				$scope.aaa.servers.radius.created = false;
			}
		};
		var deleteIndex = "";
		$scope.updateAAAServerChange = function() {
			var selSRIndex = $scope.aaaServerRadiusGrid.dataSource.indexOf($scope.aaa.servers.radius);
			deleteIndex = selSRIndex;
			$scope.serverRadiusGridData[selSRIndex].aaaProtocol = $scope.aaa.servers.radius.aaaProtocol;
			$scope.serverRadiusGridData[selSRIndex].name = $scope.aaa.servers.radius.name;
			$scope.serverRadiusGridData[selSRIndex].address = $scope.aaa.servers.radius.address;
			if($scope.aaa.servers.radius.aaaProtocol == "radius"){
				if(!$scope.aaa.servers.radius.authport) {
					$scope.aaa.servers.radius.authport = "1645";
				}
				if(!$scope.aaa.servers.radius.acctport) {
					$scope.aaa.servers.radius.acctport = "1646";
				}
				$scope.serverRadiusGridData[selSRIndex].password = $scope.aaa.servers.radius.password;
				$scope.serverRadiusGridData[selSRIndex].authport = $scope.aaa.servers.radius.authport;
				$scope.serverRadiusGridData[selSRIndex].acctport = $scope.aaa.servers.radius.acctport;
			}else if($scope.aaa.servers.radius.aaaProtocol == "tacacs"){
				$scope.serverRadiusGridData[selSRIndex].password = $scope.aaa.servers.radius.password;
				$scope.serverRadiusGridData[selSRIndex].port = $scope.aaa.servers.radius.port;
			}else if($scope.aaa.servers.radius.aaaProtocol == "ldap"){
				$scope.serverRadiusGridData[selSRIndex].port = $scope.aaa.servers.radius.port;
				$scope.serverRadiusGridData[selSRIndex].ldapServerUserBaseDN = $scope.aaa.servers.radius.ldapServerUserBaseDN;
			}
		}
		$scope.pingIP = function(dataItem,curID){
			$scope.isPing = true;
			var pingConfigCli = "";
			if(dataItem.address){
				angular.element("#"+curID).attr("src", "");
				angular.element("#"+curID).attr("class", "fa fa-refresh fa-spin spinCust");
				$timeout(function(){
					 pingConfigCli = requestRoutingService.getShowCmdOutput("ping "+dataItem.address+" \n");
					 angular.element("#"+curID).attr("class", "");
					 if(pingConfigCli.indexOf("Success rate is")!=-1){
	           	            var successStatusPer = executeCliCmdService.getNextString(pingConfigCli,["Success rate is "],["percent"]);
							if(successStatusPer == 0){
								angular.element("#"+curID).attr("src", "../resources/images/play_icon.png");
								notificationService.showNotification(pingConfigCli,translate('trouble_shoot_noreply_received'),'error');
							}else{
								angular.element("#"+curID).attr("src", "../resources/images/play_icon_on.png");
								notificationService.showNotification(pingConfigCli,translate("trouble_shoot_success_rate")+":"+successStatusPer+" %",'success');
							}
					 }else{
						  angular.element("#"+curID).attr("src", "../resources/images/play_icon.png");
						  notificationService.showNotification(pingConfigCli,translate('trouble_shoot_noreply_received'),'error');
					 }
					 $scope.isPing = false;
				 },100);
			}
		}
		$scope.applyAAAServer = function(){
			var aaaConfigCli = "";
			if($scope.aaa.servers.radius.aaaProtocol == "radius"){
				aaaConfigCli += "radius server "+ $scope.aaa.servers.radius.name+"\n";
				if($scope.aaa.servers.radius.address.indexOf(":")==-1){
				aaaConfigCli += "address ipv4 "+$scope.aaa.servers.radius.address+" auth-port "+$scope.aaa.servers.radius.authport+" acct-port "+$scope.aaa.servers.radius.acctport+"\n";
				}else{
				aaaConfigCli += "address ipv6 "+$scope.aaa.servers.radius.address+" auth-port "+$scope.aaa.servers.radius.authport+" acct-port "+$scope.aaa.servers.radius.acctport+"\n";	
				}
				if($scope.aaa.servers.radius.password){
					aaaConfigCli += "key "+ $scope.aaa.servers.radius.password+"\n";
				}
				aaaConfigCli += "exit\n";
				aaaConfigCli += "aaa server radius dynamic-author \n";
				if(deleteIndex.toString() != "" && oldServerRadiusGridData.length > 0){
					aaaConfigCli += "no client "+oldServerRadiusGridData[deleteIndex].address+" server-key "+oldServerRadiusGridData[deleteIndex].password+ "\n";
				}
				aaaConfigCli += "client "+$scope.aaa.servers.radius.address+" server-key "+$scope.aaa.servers.radius.password+ "\n";
			}else if($scope.aaa.servers.radius.aaaProtocol == "tacacs"){
				aaaConfigCli += "tacacs server "+ $scope.aaa.servers.radius.name+"\n";
				if($scope.aaa.servers.radius.address.indexOf(":")==-1){
				aaaConfigCli += "address ipv4 "+$scope.aaa.servers.radius.address+"\n";
				}else{
				aaaConfigCli += "address ipv6 "+$scope.aaa.servers.radius.address+"\n";	
				}
				if($scope.aaa.servers.radius.port){
					aaaConfigCli += "port "+$scope.aaa.servers.radius.port+"\n";
				}
				if($scope.aaa.servers.radius.password){
					aaaConfigCli += "key "+ $scope.aaa.servers.radius.password+"\n";
				}
			}else if($scope.aaa.servers.radius.aaaProtocol == "ldap"){
				aaaConfigCli += "ldap server "+ $scope.aaa.servers.radius.name+"\n";
				if($scope.aaa.servers.radius.address.indexOf(":")==-1){
				aaaConfigCli += "ipv4 "+$scope.aaa.servers.radius.address+"\n";
				}else{
				aaaConfigCli += "ipv6 "+$scope.aaa.servers.radius.address+"\n";	
				}
				aaaConfigCli += "base-dn "+$scope.aaa.servers.radius.ldapServerUserBaseDN+"\n";
				if($scope.aaa.servers.radius.port){
					aaaConfigCli += "transport port "+$scope.aaa.servers.radius.port+"\n";
				}
			}
			aaaConfigCli += "exit\n";
			if(aaaConfigCli != ""){
				var result = requestRoutingService.getConfigCmdOutput(aaaConfigCli);
				if(result==""){
					notificationService.showNotification(translate('aaa_success_msg'),translate('com_config_success_title'),'success');
				}else{
					notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
				}
			}
			$scope.loadAAAServer();
		}
		$scope.loadAAAServer = function(){
			totalRadiusServer= 0,totalTacacsServer= 0,totalLdapServer= 0;
			$scope.serverRadiusGridData = new kendo.data.ObservableArray([]);
			var aaaServerDataChk = deviceCommunicatorCLI.getExecCmdOutput("show running-config aaa\n show running-config aaa radius-server\n show running-config aaa tacacs-server\n show running-config aaa ldap");
			var aaaStatus = aaaServerDataChk[0].indexOf("no aaa new-model");
			if(aaaStatus != -1){
				$scope.aaaStatus = translate("com_disable");
				oldAAAStatus = translate("com_disable");
			}else{
				$scope.aaaStatus = translate("com_enable");
				oldAAAStatus = translate("com_enable");
			}
			var radiusServerData = aaaServerDataChk[1].split("radius server");
			if(!angular.isUndefined(radiusServerData)){
				var ipRadiusValue = "";
				var ipAuthport = ""
				var ipAcctport = ""
				for(var i = 1; i < radiusServerData.length; i++){
					totalRadiusServer++;
					var intShowRun="radius server "+radiusServerData[i];
					ipRadiusValue = "";
					if(intShowRun.indexOf("address ipv4")!=-1){
					ipRadiusValue = executeCliCmdService.getNextString(intShowRun,["address ipv4"],["\n"]).trim().split(" ")[0]
					ipAuthport = executeCliCmdService.getNextString(intShowRun,["address ipv4"],["\n"]).trim().split(" ")[2];
					ipAcctport = executeCliCmdService.getNextString(intShowRun,["address ipv4"],["\n"]).trim().split(" ")[4];
					}else if(intShowRun.indexOf("address ipv6")!=-1){
					ipRadiusValue = executeCliCmdService.getNextString(intShowRun,["address ipv6"],["\n"]).trim().split(" ")[0];	
					ipAuthport = executeCliCmdService.getNextString(intShowRun,["address ipv6"],["\n"]).trim().split(" ")[2];
					ipAcctport = executeCliCmdService.getNextString(intShowRun,["address ipv6"],["\n"]).trim().split(" ")[4];
					}
					$scope.serverRadiusGridData.push({
							"name":executeCliCmdService.getNextString(intShowRun,["radius server"],["\n"]).trim(),
							"address": ipRadiusValue,
							"aaaProtocol":"radius",
							"password": executeCliCmdService.getNextString(intShowRun,["key"],["\n"]).trim(),
							"authport":ipAuthport,
							"acctport":ipAcctport
						}
					);
				}
			}
			var tacacsServerData = aaaServerDataChk[2].split("tacacs server");
			if(!angular.isUndefined(tacacsServerData)){
				var ipTacacsValue = "";
				for(var i = 1; i < tacacsServerData.length; i++){
					totalTacacsServer++;
					var intShowRun="tacacs server "+tacacsServerData[i];
					ipTacacsValue = "";
					if(intShowRun.indexOf("address ipv4")!=-1){
					ipTacacsValue = executeCliCmdService.getNextString(intShowRun,["address ipv4"],["\n"]).trim().split(" ")[0]
					}else if(intShowRun.indexOf("address ipv6")!=-1){
					ipTacacsValue = executeCliCmdService.getNextString(intShowRun,["address ipv6"],["\n"]).trim().split(" ")[0]	
					}
					$scope.serverRadiusGridData.push({
							"name":executeCliCmdService.getNextString(intShowRun,["tacacs server"],["\n"]).trim(),
							"address": ipTacacsValue,
							"aaaProtocol":"tacacs",
							"password": executeCliCmdService.getNextString(intShowRun,["key"],["\n"]).trim(),
							"port": executeCliCmdService.getNextString(intShowRun,["port"],["\n"]).trim()
						}
					);
				}
			}
			var ldapServerData = aaaServerDataChk[3].split("ldap server");
			if(!angular.isUndefined(ldapServerData)){
				var ipLdapValue = ""
				for(var i = 1; i < ldapServerData.length; i++){
					totalLdapServer++;
					var intShowRun="ldap server "+ldapServerData[i];
					ipLdapValue = ""
					if(intShowRun.indexOf("ipv4")!=-1){
					ipLdapValue = executeCliCmdService.getNextString(intShowRun,["ipv4"],["\n"]).trim();
					}else if(intShowRun.indexOf("ipv6")!=-1){
					ipLdapValue = executeCliCmdService.getNextString(intShowRun,["ipv6"],["\n"]).trim();
					}
					$scope.serverRadiusGridData.push({
							"name":executeCliCmdService.getNextString(intShowRun,["ldap server"],["\n"]).trim(),
							"address": ipLdapValue,
							"aaaProtocol":"ldap",
							"ldapServerUserBaseDN": executeCliCmdService.getNextString(intShowRun,["base-dn"],["\n"]).trim(),
							"port": executeCliCmdService.getNextString(intShowRun,["transport port"],["\n"]).trim()
						}
					);
				}
			}
			oldServerRadiusGridData = angular.copy($scope.serverRadiusGridData);
			$scope.serverRadiusGridDataSource = new kendo.data.DataSource({
				pageSize: 10,
				data: $scope.serverRadiusGridData
			});
			angular.element(".pageLoader").hide();
			$scope.manualServerGridRefresh();
		}
		$scope.loadAAAServer();
		// AAA server end
		// Access Policy start
		$scope.disablepolicyName=true;
		$scope.aaaPolicyGridOptions = {
            editable : false,
            sortable : true,
            filterable : {
                extra : false,
                operators : {
                    string : {
                        eq : translate("com_is_equal"),
                        neq : translate("com_isnot_equal")
                    }
                },
                messages : {
                    info: translate("com_page_dropDowntext"),
                    filter: translate("com_btn_filter"),
                    clear: translate("com_btn_clear")
                }
            },
            scrollable : false,
            selectable : true,
            pageable : {
                messages: {
                    display: translate("com_page_display"),
                    empty: translate("com_page_empty"),
                    page: translate("com_page_pagetext"),
                    of:translate("com_page_of"),
                    itemsPerPage: translate("com_page_itemsPerPage"),
                    first: translate("com_page_first"),
                    previous: translate("com_page_previous"),
                    next: translate("com_page_next"),
                    last: translate("com_page_last"),
                    refresh: translate("com_page_refresh"),
                    morePages: translate("com_page_morePage")
                },
                previousNext : true,
                info : true,
                refresh : true,
                pageSizes : gridCrudService.grid_page_sizes,
                buttonCount : 5
            },
            columns : [{
                "template": "<input type=\"checkbox\"  ng-init=\"policyServer=false\" ng-model=\"policyServer\" ng-click=\"isPolicyChecked(policyServer,dataItem)\"  />",
                sortable: false,
                width: 40
            }, {
                field : "name",
                title : translate("com_name")
            }, {
                field : "aaapolicyProt",
                title : translate("etherchannel_protocol")
            }, {
                field : "aaaProtocol",
                title : translate("aaa_server")
            },{
                field : "interface",
                title : translate("portconfig_general_interface")
            }]
        };
		$scope.policyDataObj = new kendo.data.ObservableArray([{
			policyprotocolName  : translate('aaa_radius'),
			policyprotocolValue : 'radius'
		},{
			policyprotocolName  : translate('aaa_tacacs'),
			policyprotocolValue : 'tacacs'
		},{
			policyprotocolName  : translate('aaa_ldap'),
			policyprotocolValue : 'ldap'
		}]);
		
		$scope.policyDataWOObj = new kendo.data.ObservableArray([{
			policyprotocolName  : translate('aaa_radius'),
			policyprotocolValue : 'radius'
		},{
			policyprotocolName  : translate('aaa_ldap'),
			policyprotocolValue : 'ldap'
		}]);		
		$scope.policyProtocolData = new kendo.data.DataSource({
			pageSize: 10,
			data: $scope.policyDataObj
		});
		$scope.aaaPolicyValidations = {
			rules : {
				policyduplicate: function(input){
                    if (angular.isUndefined(input.data('policyduplicate'))) {
                        return true;
                    } else {
                        for (var index = 0; index < $scope.serverPolicyGridData.length; index++) {
                            if ($scope.serverPolicyGridData[index].aaapolicyProt === $scope.aaa.servers.policy.aaapolicyProt){
                                return false;
                            }
                        }
                        return true;
                    }
                }
			}
		};
		$scope.policyProtData = new kendo.data.DataSource({
			data : [{
					policyProtName  : translate('aaa_auth_type_dot1x'),
					policyProtValue : 'dot1x'
				},{
					policyProtName  : translate('aaa_policy_prot_mab'),
					policyProtValue : 'mab'
				},{
					policyProtName  : translate('aaa_policy_prot_web'),
					policyProtValue : 'web'
				}]
		});
		$scope.formatInt = function (intName) {
            if (intName.indexOf("TenGigabitEthernet") != -1) {
                intName = intName.replace("TenGigabitEthernet", "Te");
            } else if (intName.indexOf("FastEthernet") != -1) {
                intName = intName.replace("FastEthernet", "Fa");
            } else if (intName.indexOf("GigabitEthernet") != -1) {
                intName = intName.replace("GigabitEthernet", "Gi");
            } else if (intName.indexOf("Bluetooth") != -1) {
                intName = intName.replace("Bluetooth", "Bl");
            } else if (intName.indexOf("Loopback") != -1) {
                intName = intName.replace("Loopback", "Lo");
            }
            return intName;
        }
		$scope.routedSwitch = function(){
            var op = shRunIntCLIOP[0].split("interface");
            var rSwitch =[];
            for(var i = 1; i < op.length; i++){
                var portsObj = {};
                var intShowRun="interface "+op[i];
                if(intShowRun.indexOf("no switchport") != -1){
                    var inOutBoundsOP =executeCliCmdService.getNextString(intShowRun,["interface"],["\n"]).trim();
                    rSwitch.push($scope.formatInt(inOutBoundsOP));
                }
            }
            return rSwitch;
        }
		//Getting List of Available interface
		$scope.availableAuthMethodListOptions = [];
		$scope.interfacesLists = [];
		var interfaceList=[];
		var oneTime = true;
		$scope.loadPolicyTab = function(){
			if(oneTime){
				oneTime = false;
				angular.element(".pagePolicyLoader").show();
				$timeout(function(){
					$scope.loadAAAPolicy();
				},250);
			}
		}
		var policyWindow = angular.element("#policyWindow");
		policyWindow.kendoWindow({
			modal: true,
			width: "900px",
			title: "<div>"+translate("aaa_access_policy")+"</div>",
			visible: false,
			actions: [
				"Close"
			]
		}).data("kendoWindow").center();
		$scope.addaaaPolicyRow = function(){
			$scope.availableAuthMethodListOptions = angular.copy($scope.interfacesLists);
			$scope.authSelectedServerGroupOptions = [];
			$scope.disablepolicyProtocolName = false;
			$scope.disablepolicyName = true;
            angular.element("#aaaPolicyForm  span.k-tooltip-validation").hide();
			$scope.aaa.servers.policy = {};
			$scope.aaa.servers.policy.created = true;
			$scope.aaa.servers.policy.aaapolicyProt = "dot1x";
			$scope.aaa.servers.policy.aaaProtocol = "radius";
			$scope.policyProtocolChange();
			policyWindow.data("kendoWindow").open().center();
			$scope.kendoWindow.isEditMode1 = true;
        }
		$scope.cancelAddEditpolicyWindow = function(){
			policyWindow.data("kendoWindow").close();
		};
		$scope.doneAddEditpolicyWindow = function(name){
			if($scope.aaaPolicyValidator.validate()){
				if($scope.aaa.servers.policy.created && name == "save"){
					$scope.serverPolicyGridData.push($scope.aaa.servers.policy);
				}else{
					$scope.updateAAAPolicyChange();
				}
				policyWindow.data("kendoWindow").close();
				$scope.applyAAAPolicy();
			}
		}
		$scope.authSelectedServerGroupOptions = [];
		$scope.moveToAAAServerGroup = function() {
             $scope.moveItemsBetweenLists($scope.availableAuthMethodListOptions, $scope.authSelectedServerGroupOptions, $scope.aaa.methodList.auth.groupMethods);
        };
        $scope.moveFromAAAServerGroup = function() {
             $scope.moveItemsBetweenLists($scope.authSelectedServerGroupOptions, $scope.availableAuthMethodListOptions, $scope.aaa.methodList.auth.list);
        };
		$scope.moveItemsBetweenLists = function(fromList, toList, itemsToMove) {
			if ( typeof itemsToMove != "undefined") {
				while (itemsToMove.length > 0) {
					var item = itemsToMove.pop();
					toList.push(item);
					var index = fromList.indexOf(item);
					if (index != -1) {
						fromList.splice(index, 1);
					}
				}
			}
		}
		$scope.policyProtocolChange = function(){
			var policyProto = false;
			if($scope.aaa.servers.policy.aaapolicyProt == "dot1x"){	
				$scope.policyProtocolData = $scope.policyDataWOObj;			
				$scope.aaa.servers.policy.name = "POLICY_DOT1X";
			}else if($scope.aaa.servers.policy.aaapolicyProt == "mab"){	
				$scope.policyProtocolData = $scope.policyDataWOObj;
				$scope.aaa.servers.policy.name = "POLICY_MAB";
			}else if($scope.aaa.servers.policy.aaapolicyProt == "web"){
				$scope.policyProtocolData = $scope.policyDataObj;				
				$scope.aaa.servers.policy.name = "POLICY_WEB";
			}
		}
		$scope.onSelectAAAPolicyHandler = function(data) {
			$scope.authSelectedServerGroupOptions = [];
			if(data.interface != ""){
				var dataInt = data.interface.split(",");
				for(var i = 0; i < dataInt.length; i++){
					inOBOPs = $scope.formatInt(dataInt[i]);
					$scope.authSelectedServerGroupOptions.push(inOBOPs);
				}
			}
			$scope.availableAuthMethodListOptions = angular.copy($scope.interfacesLists);
			$scope.availableAuthMethodListOptions = $scope.availableAuthMethodListOptions.filter(function(val) {
				return $scope.authSelectedServerGroupOptions.indexOf(val) == -1;
			});
			$scope.disablepolicyProtocolName = true;
			$scope.disablepolicyName = true;
			angular.element("#aaaPolicyForm  span.k-tooltip-validation").hide();
			$scope.aaa.servers.policy = angular.copy(data);
			if($scope.aaa.servers.policy.aaaProtocol == "tacacs+"){
				$scope.aaa.servers.policy.aaaProtocol = "tacacs"
			}
			$scope.policyProtocolChange();
			$scope.kendoWindow.isEditMode1 = false;
			policyWindow.data("kendoWindow").open();
			$scope.aaa.servers.policy.created = false;
		};
		function filterCommunity(data1, data2) {
			var a = angular.copy(data1);
			var b = angular.copy(data2);
			for (var i = 0, len = a.length; i < len; i++) {
				for (var j = 0, len2 = b.length; j < len2; j++) {
					if (a[i] == b[j]) {
						b.splice(j, 1);
						len2 = b.length;
					}
				}
			}
			return b;
		}
		$scope.delInterface = [];
		$scope.updateAAAPolicyChange = function() {
			var selSRIndex = $scope.aaaPolicyGrid.dataSource.indexOf($scope.aaa.servers.policy);
			$scope.serverPolicyGridData[selSRIndex].aaapolicyProt = $scope.aaa.servers.policy.aaapolicyProt;
			$scope.serverPolicyGridData[selSRIndex].name = $scope.aaa.servers.policy.name;
			$scope.serverPolicyGridData[selSRIndex].aaaProtocol = $scope.aaa.servers.policy.aaaProtocol;
			$scope.serverPolicyGridData[selSRIndex].interface = $scope.authSelectedServerGroupOptions.toString();
			$scope.delInterface = filterCommunity($scope.authSelectedServerGroupOptions, $scope.oldServerPolicyGridData[selSRIndex].intArr);
		}
		$scope.deletePolicyConfirmation = function (callbackname) {
            $scope.dlgAAAPolicy = dialogService.dialog({
                content : translate('msg_delete_confirmation'),
                title : translate('msg_delete_confirmation_window'),
                messageType : "confirm",
                actionButtons : [{
                    text : translate('com_ok'),
                    callback : callbackname
                }, {
                    text : translate('com_cancel')
                }]
            });
        };
		$scope.$on("deletePolicyServer", function() {
            $scope.dlgAAAPolicy.data("kendoWindow").close();
            $scope.delPolicyRow();
        });
		$scope.selectedPolicyArray = [];
		$scope.isPolicyChecked = function (checked, dataItem) {
			if (checked == false) {
				var index = $scope.selectedPolicyArray.indexOf(dataItem);
				if (index > -1) {
					$scope.selectedPolicyArray.splice(index, 1);
					if($scope.selectedPolicyArray.length === 0){
						$scope.deleteaaaPolicy = true;
					}
				}
			}
			else {
				$scope.deleteaaaPolicy = false;
				$scope.selectedPolicyArray.push(dataItem);
			}
		};
		$scope.delPolicyRow = function() {
			$scope.deleteaaaPolicy = true;
			$scope.deletePolicyArray = [];
			for (var index = 0; index < $scope.selectedPolicyArray.length; index++) {
				$scope.deletePolicyArray.push($scope.selectedPolicyArray[index]);
			}
			$scope.selectedPolicyArray = [];
			$timeout(function(){
				$scope.deleteAAAPolicyServer();
			},10);
		};
		// Refresh button trigger
		angular.element("#aaaPolicyGrid").delegate(".k-pager-refresh", "click", function(){
			$scope.deleteaaaPolicy = true;
			$scope.selectedPolicyArray = [];
			if (!$scope.$$phase){
				$scope.$apply();
			}
		});

		$scope.manualPolicyGridRefresh = function(){
			$scope.deleteaaaPolicy = true;
			$scope.selectedPolicyArray = [];
			if (!$scope.$$phase){
				$scope.$apply();
			}
		}
		$scope.deleteAAAPolicyServer = function(){
			var delPolicyConfCli = "", forMab = 0;
			for(var d=0;d<$scope.deletePolicyArray.length;d++){
				if($scope.deletePolicyArray[d].aaapolicyProt == "dot1x"){
					var findINT = [];
					if($scope.deletePolicyArray[d]["interface"].indexOf(",") != -1){
						findINT = $scope.deletePolicyArray[d]["interface"].split(",");
					}else{
						findINT[0] = $scope.deletePolicyArray[d]["interface"];
					}
					for(var ds = 0; ds < findINT.length; ds++){
						if(findINT[ds] != ""){
							delPolicyConfCli += "interface "+ findINT[ds] + "\n";
							delPolicyConfCli += "no authentication port-control auto \n no dot1x pae authenticator \n ";
							delPolicyConfCli += "exit \n";
						}
					}
				}
				if($scope.deletePolicyArray[d].aaapolicyProt == "mab"){
					var findINT = [];
					if($scope.deletePolicyArray[d]["interface"].indexOf(",") != -1){
						findINT = $scope.deletePolicyArray[d]["interface"].split(",");
					}else{
						findINT[0] = $scope.deletePolicyArray[d]["interface"];
					}
					for(var ds = 0; ds < findINT.length; ds++){
						if(findINT[ds] != ""){
							delPolicyConfCli += "interface "+ findINT[ds] + "\n";
							delPolicyConfCli += "no authentication port-control auto \n no mab \n ";
							delPolicyConfCli += "exit \n";
						}
					}
				}
				if($scope.deletePolicyArray[d].aaapolicyProt == "web"){
					var findINT = [];
					if($scope.deletePolicyArray[d]["interface"].indexOf(",") != -1){
						findINT = $scope.deletePolicyArray[d]["interface"].split(",");
					}else{
						findINT[0] = $scope.deletePolicyArray[d]["interface"];
					}
					for(var ds = 0; ds < findINT.length; ds++){
						if(findINT[ds] != ""){
							delPolicyConfCli += "interface "+ findINT[ds] + "\n";
							delPolicyConfCli += "no ip admission web \n no authentication port-control auto \n";
							delPolicyConfCli += "exit \n";
						}
					}
				}
				if($scope.deletePolicyArray[d].aaapolicyProt == "dot1x"){
					var mabIndex = $scope.serverPolicyGridData.map(function(e) {
						return e.aaapolicyProt;
					}).indexOf("mab");
					if(mabIndex != -1){
						forMab++;
						delPolicyConfCli += $scope.serverPolicyGridData[mabIndex]["interface"] == "" ? "no aaa authentication dot1x default group "+$scope.deletePolicyArray[d].aaaProtocol+" \n no aaa authorization network default group "+$scope.deletePolicyArray[d].aaaProtocol+"\n" : "";
					}
				}
				if($scope.deletePolicyArray[d].aaapolicyProt == "mab"){
					var mabIndex = $scope.serverPolicyGridData.map(function(e) {
						return e.aaapolicyProt;
					}).indexOf("mab");
					if(mabIndex != -1){
						forMab++;
						delPolicyConfCli += $scope.serverPolicyGridData[mabIndex]["interface"] == "" ? "no aaa authentication dot1x default group "+$scope.deletePolicyArray[d].aaaProtocol+"\n no aaa authorization network default group "+$scope.deletePolicyArray[d].aaaProtocol+"\n" : "";
					}
				}
				if($scope.deletePolicyArray[d].aaapolicyProt == "web"){
					delPolicyConfCli += "no aaa authentication login default group "+$scope.deletePolicyArray[d].aaaProtocol+" \n no aaa authorization auth-proxy default group "+$scope.deletePolicyArray[d].aaaProtocol+"\n no ip admission name web proxy http \n";
				}
				if(forMab == 2){
					delPolicyConfCli += "no aaa authentication dot1x default group "+$scope.deletePolicyArray[d].aaaProtocol+"\n no aaa authorization network default group "+$scope.deletePolicyArray[d].aaaProtocol+"\n";
				}
			}
			delPolicyConfCli += "exit\n";
			if(delPolicyConfCli != ""){
				var result = requestRoutingService.getConfigCmdOutput(delPolicyConfCli);
				if(result==""){
					notificationService.showNotification(translate('aaa_access_policy_success_msg'),translate('com_config_success_title'),'success');
				}else{
					notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
				}
			}
			$scope.loadAAAPolicy();
			var grid = angular.element("#aaaPolicyGrid").data("kendoGrid");
            grid.dataSource = $scope.aaaPolicyGridDataSource;
            $scope.aaaPolicyGridDataSource.read();
            grid.refresh();
		}
		$scope.applyAAAPolicy = function(){
			var aaaPolicyConfigCli = "";
			aaaPolicyConfigCli += "no aaa local authentication default authorization default \n";
			if($scope.aaa.servers.policy.aaapolicyProt == "dot1x"){
				aaaPolicyConfigCli += "dot1x system-auth-control \n";
				aaaPolicyConfigCli += "aaa authentication dot1x default group "+ $scope.aaa.servers.policy.aaaProtocol+"\n";
				aaaPolicyConfigCli += "aaa authorization network default group "+$scope.aaa.servers.policy.aaaProtocol+"\n";
				for(var delD = 0; delD < $scope.delInterface.length; delD++){
					aaaPolicyConfigCli += "interface "+ $scope.delInterface[delD] +"\n";
					aaaPolicyConfigCli += "no authentication port-control auto \n no dot1x pae authenticator \n";
				}
				if($scope.authSelectedServerGroupOptions.length > 0){
					for(var d=0;d<$scope.authSelectedServerGroupOptions.length;d++){
						aaaPolicyConfigCli += "interface "+ $scope.authSelectedServerGroupOptions[d] +"\n";
						aaaPolicyConfigCli += "switchport mode access \n";
						aaaPolicyConfigCli += "authentication port-control auto \n";
						aaaPolicyConfigCli += "dot1x pae authenticator \n";
					}
				}
			}else if($scope.aaa.servers.policy.aaapolicyProt == "mab"){
				aaaPolicyConfigCli += "aaa authentication dot1x default group "+ $scope.aaa.servers.policy.aaaProtocol+"\n";
				aaaPolicyConfigCli += "aaa authorization network default group "+ $scope.aaa.servers.policy.aaaProtocol+"\n";
				for(var delM = 0; delM < $scope.delInterface.length; delM++){
					aaaPolicyConfigCli += "interface "+ $scope.delInterface[delM] +"\n";
					aaaPolicyConfigCli += "no authentication port-control auto \n no mab \n";
				}
				if($scope.authSelectedServerGroupOptions.length > 0){
					for(var m=0;m<$scope.authSelectedServerGroupOptions.length;m++){
						aaaPolicyConfigCli += "interface "+ $scope.authSelectedServerGroupOptions[m] +"\n";
						aaaPolicyConfigCli += "switchport mode access \n";
						aaaPolicyConfigCli += "authentication port-control auto \n";
						aaaPolicyConfigCli += "mab \n";
					}
				}
			}else if($scope.aaa.servers.policy.aaapolicyProt == "web"){
				aaaPolicyConfigCli += "aaa authentication login default group "+$scope.aaa.servers.policy.aaaProtocol+"\n";
				aaaPolicyConfigCli += "aaa authorization auth-proxy default group "+ $scope.aaa.servers.policy.aaaProtocol+"\n";
				aaaPolicyConfigCli += "ip admission name web proxy http \n";
				for(var delW = 0; delW < $scope.delInterface.length; delW++){
					aaaPolicyConfigCli += "interface "+ $scope.delInterface[delW] +"\n";
					aaaPolicyConfigCli += "no ip admission web \n no authentication port-control auto \n";
				}
				if($scope.authSelectedServerGroupOptions.length > 0){
					for(var w=0;w<$scope.authSelectedServerGroupOptions.length;w++){
						aaaPolicyConfigCli += "interface "+ $scope.authSelectedServerGroupOptions[w] +"\n";
						aaaPolicyConfigCli += "switchport mode access \n";
						aaaPolicyConfigCli += "authentication port-control auto \n";
						aaaPolicyConfigCli += "ip admission web \n";
					}
				}
			}
			aaaPolicyConfigCli += "exit\n";
			if(aaaPolicyConfigCli != ""){
				var result = requestRoutingService.getConfigCmdOutput(aaaPolicyConfigCli);
				if(result==""){
					notificationService.showNotification(translate('aaa_access_policy_success_msg'),translate('com_config_success_title'),'success');
				}else{
					notificationService.showNotification(result.errorResponse,translate('com_config_fail_title'),'error');
				}
			}
			$scope.loadAAAPolicy();
		}
		$scope.loadAAAPolicy = function(){
			var dot1xInterfaceList = [],mabInterfaceList = [], webInterfaceList = [];
			var interfaceListOP = deviceCommunicatorCLI.getExecCmdOutput("show running-config | section interface"),
				interfaceListOPArr = interfaceListOP[0].split("interface"),
				intShowRun;
			for (var i=0; i < interfaceListOPArr.length; i++) {
				intShowRun="interface "+interfaceListOPArr[i];
				var arrInterfaceName = executeCliCmdService.getNextString(intShowRun,["interface"],["\n"]).trim();
				var portsObj = {};
				if(arrInterfaceName.indexOf("Port") != -1 || arrInterfaceName.indexOf("Vlan") != -1 || arrInterfaceName.indexOf("Bluetooth") != -1 || arrInterfaceName.indexOf("Loopback") != -1 || arrInterfaceName.indexOf("FastEthernet0") != -1 || arrInterfaceName.indexOf("input") != -1 || arrInterfaceName.indexOf("collect") != -1){
					continue;
				}
				intShowRun="interface "+interfaceListOPArr[i];
				if(intShowRun.indexOf("no switchport") == -1){
					if(intShowRun.indexOf("channel-group") == -1){
						if(arrInterfaceName){
							portsObj["portName"] = arrInterfaceName;
							interfaceList.push(portsObj);
						}
					}
				}
				if(intShowRun.indexOf("dot1x pae authenticator") != -1){
					dot1xInterfaceList.push($scope.formatInt(arrInterfaceName));
				}
				if(intShowRun.indexOf("mab") != -1){
					mabInterfaceList.push($scope.formatInt(arrInterfaceName));
				}
				if(intShowRun.indexOf("ip admission web") != -1){
					webInterfaceList.push($scope.formatInt(arrInterfaceName));
				}
			}
			angular.forEach(interfaceList, function (inter) {
					var intNameAttr = $scope.formatInt(inter.portName);
					$scope.interfacesLists.push(intNameAttr);
			});
			var protocolName = "", serverGroup = "", policyName = "", associatedInterface = "";
			$scope.serverPolicyGridData = new kendo.data.ObservableArray([]);
			var aaaAuthOP = deviceCommunicator.getExecCmdOutput("show run aaa authentication");
			if(aaaAuthOP.indexOf("aaa authentication login default group") != -1){
				var serverGrp = executeCliCmdService.getNextString(aaaAuthOP,["aaa authentication login default group"],["\n"]).trim();
				serverGroup = serverGrp;
				protocolName = "web";
				policyName = "POLICY_WEB";
				$scope.serverPolicyGridData.push({
					"name" : policyName,
					"aaapolicyProt" : protocolName,
					"aaaProtocol" : serverGroup,
					"interface" : webInterfaceList == "" ? "" : webInterfaceList.join(),
					"intArr" : webInterfaceList == "" ? [] : webInterfaceList
				})
			}
			if(aaaAuthOP.indexOf("aaa authentication dot1x default group") != -1){
				var serverGrp = executeCliCmdService.getNextString(aaaAuthOP,["aaa authentication dot1x default group"],["\n"]).trim();
				serverGroup = serverGrp;
				protocolName = "dot1x";
				policyName = "POLICY_DOT1X";
				$scope.serverPolicyGridData.push({
					"name" : policyName,
					"aaapolicyProt" : protocolName,
					"aaaProtocol" : serverGroup,
					"interface" : dot1xInterfaceList == "" ? "" : dot1xInterfaceList.join(),
					"intArr" : dot1xInterfaceList == "" ? [] : dot1xInterfaceList
				})
			}
			if(aaaAuthOP.indexOf("aaa authentication dot1x default group") != -1){
				var serverGrp = executeCliCmdService.getNextString(aaaAuthOP,["aaa authentication dot1x default group"],["\n"]).trim();
				serverGroup = serverGrp;
				protocolName = "mab";
				policyName = "POLICY_MAB";
				$scope.serverPolicyGridData.push({
					"name" : policyName,
					"aaapolicyProt" : protocolName,
					"aaaProtocol" : serverGroup,
					"interface" : mabInterfaceList == "" ? "" : mabInterfaceList.join(),
					"intArr" : mabInterfaceList == "" ? [] : mabInterfaceList
				})
			}
			$scope.oldServerPolicyGridData = angular.copy($scope.serverPolicyGridData);
			$scope.aaaPolicyGridDataSource = new kendo.data.DataSource({
				pageSize: 10,
				data: $scope.serverPolicyGridData
			});
			angular.element(".pagePolicyLoader").hide();
			$scope.manualPolicyGridRefresh();
		}
}]);
