<!-- Copyright (c) 2004, 2006-2011 by Cisco Systems, Inc. -->
// smartports.js - Will create the frontPanel for 3560 devices.
// <include a list of SKUs here>
/* List of Layer 3 EagleEye SKUs  

	SM-ES3-16-P			 --> 15 FastEthernet Ports + 1 Gi Port + 2 Gi internal Ports
	SM-ES3G-16-P		 --> 16 Gigabit Ethernet Ports + 2 Gi internal Ports
	SM-ES3-24-P			 --> 23 FastEthernet Ports + 1 Gi Port + 2 Gi internal Ports
	SM-ES3G-24-P		 --> 24 Gigabit Ethernet Ports + 2 Gi internal Ports
	SM-D-ES3-48-P		 --> 2 SFP ports +48 FastEthernet Ports + 2  Gi internal Ports
	SM-D-ES3G-48-P		 --> 2 SFP Ports + 48 FastEthernet Ports + 2 Gi internal Ports
*/
//////////////////////////////////////////////////////////////////////////////////////////////
function createDevice(deviceType, uiPortDataArr) {
	var device = null;
   //	alert ("deviceType is:" + deviceType);
   
   	if(deviceType == null)
		return device;
	if((deviceType == "WS-C3560-24PS") || (deviceType == "WS-C3560-24TS") || (deviceType.indexOf("WS-C3560V2-24PS") != -1) || (deviceType.indexOf("WS-C3560V2-24TS") != -1)) {
		device = new WSC356024PS(uiPortDataArr);
	} else if ((deviceType == "WS-C3560G-24TS") || (deviceType == "WS-C3560G-24PS")) {
		device = new WSC3560G244(uiPortDataArr);
	} else if ( (deviceType == "WS-C3560G-48TS") || (deviceType == "WS-C3560-48PS") 
			|| (deviceType == "WS-C3560G-48PS") || (deviceType == "WS-C3560-48TS")) {
		device = new WSC3560G484(uiPortDataArr);
	} else if(deviceType == "WS-C3560-8PC") {
		device = new WSC35608PC(uiPortDataArr);	
	} else if(deviceType == "WS-C3560E-24TD" || deviceType == "WS-C3560E-24PD") {
		device = new WSC3560E24(uiPortDataArr);
	} else if(deviceType == "WS-C3560E-48TD" || deviceType == "WS-C3560E-48PD") {
		device = new WSC3560E48(uiPortDataArr);
	}else if(deviceType.indexOf("WS-C3560E-12D") != -1){
		device = new WSC3560E12DS(uiPortDataArr);
	}else if(deviceType.indexOf("WS-C3560E-12SD") != -1){
		device = new WSC3560E12SD(uiPortDataArr);
	}else if(deviceType.indexOf("WS-C3560-12PC-S") != -1){
		device = new WSC356012PCS(uiPortDataArr);
	}else if(deviceType.indexOf("WS-C3560V2-48PS") != -1 || deviceType.indexOf("WS-C3560V2-48TS") != -1) {
		device = new WSC3560F48(uiPortDataArr);
	}else if(deviceType.indexOf("SM-ES3-16-P")!= -1){ 
		uiPortDataArr = removeInternalPorts(new Array("16","17"));
		device = new SM_ES3_16P(uiPortDataArr);
	}else if(deviceType.indexOf("SM-ES3G-16-P") != -1){ 
		uiPortDataArr = removeInternalPorts(new Array("16","17"));
		device = new SM_ES3G_16P(uiPortDataArr);
	}else if(deviceType.indexOf("SM-ES3-24-P")!= -1){ 
		uiPortDataArr = removeInternalPorts(new Array("24","25"));
		device = new SM_ES3_24P(uiPortDataArr);
	}else if(deviceType.indexOf("SM-ES3G-24-P")!= -1){ 
		uiPortDataArr = removeInternalPorts(new Array("24","25"));
		device = new SM_ES3G_24P(uiPortDataArr);
	}else if(deviceType.indexOf("SM-D-ES3-48-P")!= -1){ 
		uiPortDataArr = removeInternalPorts(new Array("50","51"));
		device = new SMD_ES3_48P(uiPortDataArr);
	}
	else if(deviceType.indexOf("SM-D-ES3G-48-P")!= -1){ 
		uiPortDataArr = removeInternalPorts(new Array("50","51"));
		device = new SMD_ES3G_48P(uiPortDataArr);
	}else if (deviceType == "WS-C3560X-24P" || deviceType == "WS-C3560X-24"){
		device = new WSC3560X24(uiPortDataArr);
	}else if (deviceType == "WS-C3560X-48P" || deviceType == "WS-C3560X-48"){
		device = new WSC3560X48(uiPortDataArr);
	}else if (deviceType == "WS-C3560CG-8PC-S" || deviceType == "WS-C3560CG-8TC-S"){
		device = new WSC3560CG8(uiPortDataArr);
	}else if (deviceType == "WS-C3560CPD-8PT-S"){//Takara
		device = new WSC3560CPD(uiPortDataArr);
	}
}
/*
 *  This is unit tested.
 */

function WSC3560G484(uiPortDataArr) {
	portCount = uiPortDataArr.length;

	document.writeln('\
				  <tr><td colspan= "36" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount-4 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-4; portId < portCount ; portId++) {
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
			}
		}				  

		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-4 ; portId++) {
	  		// This is extra space between port 16 and 18
			if( (portId) % 16 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount - 4; portId < portCount ; portId++) {
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  					
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                  
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')			
}


/*
 *  This is unit tested.
 */

function WSC3560G244(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "36" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount-4 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-4; portId < portCount ; portId++) {
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
			}
		}				  

		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-4 ; portId++) {
	  		// This is extra space between port 16 and 18
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount - 4; portId < portCount ; portId++) {
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  					
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                  
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')			
}


/*
 *  This is unit tested.
 */

function WSC356024PS(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "25" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -2 ; portId++) {
  		// This is extra space between port 12 and 13
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();
		
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')

	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-2 ; portId++) {
	  		// This is extra space between port 12 and 13
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
		for (var portId = portCount - 2; portId < portCount ; portId++) {
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                       
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')		
}

function WSC35608PC(uiPortDataArr){
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
		for (var portId=0; portId<portCount-1; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();
	for (var portId = portCount-1; portId < portCount ; portId++) {
		document.writeln('\
		<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
		face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
		</font><a href="javascript:void(0)"\
		onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
		onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
		onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
		onMouseUp="window.status=\'\'; return true"\
		onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
		src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
		border="0"\
		width="21" height="21" name="cell', '_', portId, '"></a></td>');
		writeSpaceCell();writeSpaceCell();
	}
	
	writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "28" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function WSC356012PCS(uiPortDataArr){
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "25" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount -1 ; portId++) {
  		// This is extra space between port 12 and 13
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();
		
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')

	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-1 ; portId++) {
	  		// This is extra space between port 12 and 13
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 
		document.writeln('\
				  <td nowrap width="20" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
		for (var portId = portCount - 1; portId < portCount ; portId++) {
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>') 				  				   
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                       
		document.writeln('\
				  </tr>')
	    document.writeln('\
				  <tr><td colspan= "25" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')		
}

function WSC3560E24(uiPortDataArr) {
	var MAX_PORTS = 28;
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "32" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr>');
	//document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	for (var portId=0; portId<24; portId++) {
  		// This is extra space between port groups
		if(portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row
		if (portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}
		
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		
		var tmp_count = 0;
		for (var portId=portCount-4; portId<portCount; portId++) {
			if(uiPortDataArr[portId].portName.indexOf("/25") > 0 || uiPortDataArr[portId].portName.indexOf("/26") > 0 || (portCount < MAX_PORTS && uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/1") > 0)) {
				tmp_count++;
				document.writeln('\
						<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
						face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
						</font><a href="javascript:void(0)"\
						onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
						onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
						onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
						onMouseUp="window.status=\'\'; return true"\
						onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
						src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
						border="0"\
					    width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();
			}
		}
		
		if(tmp_count == 1 && portCount == 27) {
			document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
			writeSpaceCell();	writeSpaceCell();
		}
		
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
		document.writeln('</tr>');
		
		document.writeln('<tr><td colspan= "32" height="5" bgcolor="#f4f4f4"></td></tr>');
		document.writeln('<tr><td colspan= "32" height="3" bgcolor="#f4f4f4"></td></tr>');
		
		//Second row ports
		document.writeln('<tr>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
		//document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		
		
		for (var portId=0; portId<24; portId++) {
			// This is extra space between port groups
			if(portId == 12) {
				document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			}
			//Even numbered ports in second row
			if (portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}				  

		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		
		var tmp_count = 0;
		for (var portId=portCount-4; portId<portCount; portId++) {
			if(uiPortDataArr[portId].portName.indexOf("/27") > 0 || uiPortDataArr[portId].portName.indexOf("/28") > 0 || (portCount < MAX_PORTS && uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/2") > 0)) {
				tmp_count++;
				document.writeln('\
						<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
						face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
						</font><a href="javascript:void(0)"\
						onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
						onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
						onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
						onMouseUp="window.status=\'\'; return true"\
						onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
						src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
						border="0"\
					    width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();
			}
		}
		
		if(tmp_count == 1 && portCount == 27) {
			document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
			writeSpaceCell();	writeSpaceCell();
		}
		
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "32" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
}

function WSC3560E48(uiPortDataArr) {
	var MAX_PORTS = 52;
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "50" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<48; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	var tmp_count = 0;
	for (var portId = portCount-4; portId<portCount ; portId++) {
		if(uiPortDataArr[portId].portName.indexOf("/49") > 0 || uiPortDataArr[portId].portName.indexOf("/50") > 0 || (portCount < MAX_PORTS && uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/1") > 0)) {
			tmp_count++;
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}
	}
	
	if(tmp_count == 1 && portCount == 51) {
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "50" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "50" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<48; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 24 || portId == 36) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	var tmp_count = 0;
	for (var portId = portCount-4; portId<portCount; portId++) {
		if(uiPortDataArr[portId].portName.indexOf("/51") > 0 || uiPortDataArr[portId].portName.indexOf("/52") > 0 || (portCount < MAX_PORTS && uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/2") > 0)) {
			tmp_count++;
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}
	}
	
	if(tmp_count == 1 && portCount == 51) {
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "50" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}
function WSC3560CG8(uiPortDataArr){
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
		for (var portId=0; portId<portCount-2; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');

			if(portId==3)
			{
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			writeSpaceCell();	writeSpaceCell();
			}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();
	for (var portId = portCount-2; portId < portCount ; portId++) {
		document.writeln('\
		<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
		face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
		</font><a href="javascript:void(0)"\
		onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
		onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
		onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
		onMouseUp="window.status=\'\'; return true"\
		onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
		src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
		border="0"\
		width="21" height="21" name="cell', '_', portId, '"></a></td>');
		writeSpaceCell();writeSpaceCell();
	}
	
	writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "28" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}
function WSC3560CPD(uiPortDataArr){
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
		for (var portId=0; portId<portCount-2; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(1500); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();
	for (var portId = portCount-2; portId < portCount ; portId++) {
		document.writeln('\
		<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
		face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
		</font><a href="javascript:void(0)"\
		onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
		onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
		onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
		onMouseUp="window.status=\'\'; return true"\
		onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
		src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
		border="0"\
		width="21" height="21" name="cell', '_', portId, '"></a></td>');
		writeSpaceCell();writeSpaceCell();
	}
	
	writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "28" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}
function getPortLabel(intName) {
	var intNumber = intName.substring(intName.indexOf('/')+1);
	return parseInt(intNumber)
}

function isExtVlanSupported() {
	return true;
}

function getMaxVlans() {
  	return 250;	
}

function WSC3560E12DS(uiPortDataArr){
	
	portCount = uiPortDataArr.length;
	var intNam = new Array();
	var indxArray = new Array();
	for (var t=0; t< uiPortDataArr.length; t++){
		intNam[t] = uiPortDataArr[t].portName;
		indxArray[uiPortDataArr[t].portName]=t;
	}
	var prtString = "#"+intNam.join('#')+"#";
	document.writeln('<tr><td colspan= "246" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr bgcolor="#f4f4f4">');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	var portId =0;
	for (var t=1; t<13; t++){
		if(prtString.indexOf("#Te0/"+t+"#")!= -1){
			var prtIndx = "Te0/" + t;
			portId = indxArray[prtIndx];
			document.writeln('\
				<td align="center" width="23" bgcolor="#f4f4f4" valign="top"><font style="font-size:9px"\
				face="Helvetica">X2-', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();
		}else{
			var prtIndx_1 = "Gi0/"+((t*2)-1);
			portId = indxArray[prtIndx_1];
				document.writeln('\
				<td><table border="0" cellspacing ="0" cellpadding ="0"><tr><td width="21" bgcolor="#f4f4f4" align="center" valign="middle"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td></tr>');
				writeSpaceRow(1);
			
			prtIndx_1 = "Gi0/"+((t*2));
			portId = indxArray[prtIndx_1];
				document.writeln('\
				<tr><td align="center" width="21" bgcolor="#f4f4f4" valign="middle" ><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a><br><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
				</font></td></tr></table></td>');
				writeSpaceCell();		
		}
		}
		writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "246" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
		
}
function WSC3560E12SD(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "38" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount ; portId++) {
		document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>')
				if(portId == 3 || portId == 7 || portId == 11){
						writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
				}
	}
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('\
		  </tr>')
	document.writeln('\
			  <tr><td colspan= "38" height="9" bgcolor="#f4f4f4">')
	document.writeln('\
			  </td></tr>')					
}

function WSC3560F48(uiPortDataArr) {
	portCount = uiPortDataArr.length;

	document.writeln('\
				  <tr><td colspan= "36" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < portCount-4 ; portId++) {
  		// This is extra space between port 15 and 17
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount-4; portId < portCount ; portId++) {
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
			}
		}				  

		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < portCount-4 ; portId++) {
	  		// This is extra space between port 16 and 18
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  
		for (var portId = portCount - 4; portId < portCount ; portId++) {
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')  					
			}
		}
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();                                                  
		document.writeln('\
			  </tr>')
		document.writeln('\
				  <tr><td colspan= "36" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')			
}

//removes internal ports from the two port arrays and returns the UI port array for EagleEye
function removeInternalPorts(excludePortsArr) {
	var tempArr1 = uiPortDataArr;
	var tempArr2 = devicePortDataArr;
	if(excludePortsArr.length > 0) {
		for(var i=excludePortsArr.length-1; i>=0; i--) {
			tempArr1 = tempArr1.slice(0, parseInt(excludePortsArr[i]));
			tempArr2 = tempArr2.slice(0, parseInt(excludePortsArr[i]));
		}
		uiPortDataArr = tempArr1;
		devicePortDataArr = tempArr2;
		return uiPortDataArr;
	}
}
//SM-ES3-16-P  
function SM_ES3_16P(uiPortDataArr){
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId = portCount-2; portId >=0 ; portId--) {
  		//Odd numbered ports in first row in reverse order: 15 - 3
		if (portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}
		
		//External Gigabit port at the end of first row
		for (var portId = portCount-1; portId < portCount; portId++) {
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
		
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
		document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4"></td></tr>');
		
		//Second row ports
		document.writeln('<tr>');
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
		
		for (var portId = portCount-2; portId >=0 ; portId--) {
			//Even numbered ports in second row in reverse order: 16 - 2
			if (portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}				  

		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
}

//SM-ES3G-16-P
function SM_ES3G_16P(uiPortDataArr){ 	
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId = portCount-1; portId >=0 ; portId--) {  		
		//Odd numbered ports in first row in reverse order: 15 - 1
		if (portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}
		
		
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
		document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4"></td></tr>');
		
		//Second row ports 
		document.writeln('<tr>');
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
		
		for (var portId = portCount-1; portId >=0 ; portId--) {
			//Even numbered ports in second row in reverse order: 24 - 2
			if (portId % 2 !=0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}				  

		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
}
//SM-ES3-24-P
function SM_ES3_24P(uiPortDataArr){ 	
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId = portCount-2; portId >=0 ; portId--) {
  		// This is extra space between port 15 and 17
		if(portId == 14) { 
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row in reverse order: 23 - 3
		if (portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}
		
		//External Gigabit port at the end of first row
		for (var portId = portCount-1; portId < portCount; portId++) {
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
		
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
		document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4"></td></tr>');
		
		//Second row ports
		document.writeln('<tr>');
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
		
		for (var portId = portCount-2; portId >=0 ; portId--) {
			// This is extra space between port 16 and 18
			if(portId == 15) { 
				document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			}
			//Even numbered ports in second row in reverse order: 24 - 2
			if (portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}				  

		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
}
//SM-ES3G-24-P
function SM_ES3G_24P(uiPortDataArr){ 	
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId = portCount-1; portId >=0 ; portId--) {
  		// This is extra space between port 15 and 17
		if(portId == 15) { 
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row in reverse order: 23 - 3
		if (portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}
		
		
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
		document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4"></td></tr>');
		
		//Second row ports 
		document.writeln('<tr>');
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();//writeSpaceCell();
		
		for (var portId = portCount-1; portId >=0 ; portId--) {
			// This is extra space between port 16 and 18
			if(portId == 15) { 
				document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			}
			//Even numbered ports in second row in reverse order: 24 - 2
			if (portId % 2 !=0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}				  

		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
}
//48 Port
function SMD_ES3G_48P(uiPortDataArr){
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "42" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId = portCount-1; portId >=0 ; portId--) {
  		// This is extra space between port 17 & 19 and 33 & 35
		if(portId == 16 || portId == 32) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row in reverse order: 49 - 1		
		if ( portId % 2 ==0) {
			if (portId == 0) // For 1st SFP port
			{
				document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			}
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "42" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "42" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId = portCount-1; portId >=0 ; portId--) {
		// This is extra space between port 18 & 20 and 34 & 36
		if(portId == 17 || portId == 33) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row in reverse order: 50 - 4
		if ( portId % 2 !=0) {
			if(portId==1){
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			}
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "42" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}
//SM-D-ES3-48-P
function SMD_ES3_48P(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "42" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId = portCount-3; portId >=0 ; portId--) {
  		// This is extra space between port 17 & 19 and 33 & 35
		if(portId == 14 || portId == 30) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row in reverse order: 49 - 1		
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
	var portId = portCount-2;// add first SFP port
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "42" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "42" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId = portCount-3; portId >=0 ; portId--) {
		// This is extra space between port 18 & 20 and 34 & 36
		if(portId == 15 || portId == 31) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row in reverse order: 50 - 4
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}

	}
	var portId = portCount-1; //add second SFP port
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');	
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "42" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}
//*** End Of  Eagle Eye Layer3 SKUs Smartports Creation ***//

//*** Start of Incredibles ***//
function WSC3560X48(uiPortDataArr) {
	var MAX_PORTS=54;
	var form = document.forms["smartportsForm"];
	var intStatus = form.INT_STATUS.value;
	var intArray = split("\n", trim_string(token_string("Duplex  Speed Type",1,intStatus)));
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "54" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	//1st row 24 ports , 
	for (var portId = 0; portId < 48 ; portId++) {
  		// This is extra space between port 11 & 13 ,23 & 25 and 35 & 37
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
			document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if(portCount == 52 || portCount == 54 ) { 
			document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
			writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
			writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
			writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
			writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		}
					
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "54" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
		//2nd row  24 ports						  
		 for (var portId = 0; portId < 48 ; portId++) {
	  		// This is extra space between port 12 & 14 ,24 & 26 and 36 & 38
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		 }

		 if(portCount > 52){//For 54 port device // 10 Giga N/W module

				var nmmodule_gigaport1=uiPortDataArr[portCount-6].portName;
				var nmmodule_gigaport2=uiPortDataArr[portCount-5].portName;
				var nmmodule_gigaport3=uiPortDataArr[portCount-4].portName;
				var nmmodule_gigaport4=uiPortDataArr[portCount-3].portName;
				var nmmodule_tengigaport1=uiPortDataArr[portCount-2].portName;
				var nmmodule_tengigaport2=uiPortDataArr[portCount-1].portName;
				
				for(var i=0;i<intArray.length;i++){
				if(intArray[i].indexOf(nmmodule_gigaport1) != -1)
					nmmodule_gigaport1=intArray[i];
				else if(intArray[i].indexOf(nmmodule_gigaport2) != -1)
					nmmodule_gigaport2=intArray[i];
				else if(intArray[i].indexOf(nmmodule_gigaport3) != -1)
					nmmodule_gigaport3=intArray[i];
				else if(intArray[i].indexOf(nmmodule_gigaport4) != -1)
					nmmodule_gigaport4=intArray[i];
				else if(intArray[i].indexOf(nmmodule_tengigaport1) != -1)
					nmmodule_tengigaport1=intArray[i];
				else if(intArray[i].indexOf(nmmodule_tengigaport2) != -1)
					nmmodule_tengigaport2=intArray[i];
				}
			
			}

			if((portCount > 48 && portCount == 52) ||
				((nmmodule_tengigaport2.indexOf("Te") != -1 &
				nmmodule_tengigaport2.indexOf("Not Present") > 0) &
				 (nmmodule_tengigaport1.indexOf("Te") != -1 & 
				nmmodule_tengigaport1.indexOf("Not Present") > 0))) {
				//For 1G network module ,which have G1, G2, G3, G4 SFP ports
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			for (var portId = 48; portId < 52 ; portId++)
					{
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				   writeSpaceCell(); writeSpaceCell(); 					
			   }
			   if(portCount == 54){
			   uiPortDataArr[52].macro = MACRO_NULL;
				uiPortDataArr[53].macro = MACRO_NULL;
				}
			}
			else  if ((nmmodule_tengigaport2.indexOf("Te") != -1 &&
				nmmodule_tengigaport2.indexOf("Not Present") == -1) ||
				(nmmodule_tengigaport1.indexOf("Te") != -1 &&
				nmmodule_tengigaport1.indexOf("Not Present") == -1)) // For Te1 and Te2
			{  
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')	
				  	for (var portId = portCount - 6; portId < portCount ; portId++)
					{ 	
						if((nmmodule_gigaport1.indexOf("Not Present") == -1 
							|| nmmodule_gigaport2.indexOf("Not Present") == -1)) // G1,G2,Te2
						{
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
					 writeSpaceCell(); writeSpaceCell(); 
					 if(portId == 49) portId+=3;// for Te2
					 if(portId == 53) { writeSpaceCell(); writeSpaceCell();
					 	 writeSpaceCell(); writeSpaceCell(); 
						 uiPortDataArr[50].macro = MACRO_NULL;
						  uiPortDataArr[51].macro = MACRO_NULL;
						   uiPortDataArr[52].macro = MACRO_NULL;
						   }
						}
					 else if((nmmodule_gigaport3.indexOf("Not Present") == -1 
							|| nmmodule_gigaport4.indexOf("Not Present") == -1))//Te1,G3,G4
						{
							if(portId == 48) {
								uiPortDataArr[48].macro = MACRO_NULL;
								uiPortDataArr[49].macro = MACRO_NULL;
								uiPortDataArr[53].macro = MACRO_NULL;
								portId=portId+4;
							}
							document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
					 writeSpaceCell(); writeSpaceCell(); 
					 if(portId == 52) portId=portId-3;
					 if(portId == 51) {portId=portId+2;writeSpaceCell(); writeSpaceCell(); }

						}
						else {
					if(portId == 48){ 
					uiPortDataArr[48].macro = MACRO_NULL;
					uiPortDataArr[49].macro = MACRO_NULL;
					uiPortDataArr[50].macro = MACRO_NULL;
					uiPortDataArr[51].macro = MACRO_NULL;
					portId=portId+4;
					}// Te1,Te2
						document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
					 writeSpaceCell(); writeSpaceCell(); 
				  if(portId == 53) {writeSpaceCell(); writeSpaceCell(); writeSpaceCell(); 
									writeSpaceCell(); writeSpaceCell();writeSpaceCell();}
						}
								
				 }
				
			}
		
	document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
					 
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "54" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
		
}

function WSC3560X24(uiPortDataArr) {
	var MAX_PORTS=30;
	var form = document.forms["smartportsForm"];
	var intStatus = form.INT_STATUS.value;
	var intArray = split("\n", trim_string(token_string("Duplex  Speed Type",1,intStatus)));
	portCount = uiPortDataArr.length;
	document.writeln('\
				  <tr><td colspan= "30" height="3" bgcolor="#f4f4f4">')
   	document.writeln('\
				  </td></tr>')	  
	document.writeln('\
	  						<tr>')
	writeSpaceCell();
	for (var portId = 0; portId < 24 ; portId++) {
  		// This is extra space between port 11 & 13 
		if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 ==0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>')
			}
		}
		document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
	
		if(portCount == 28 || portCount == 30 ) {
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	}
		
		document.writeln('\
				  </tr>')
		document.writeln('\
				  <tr><td colspan= "30" height="5" bgcolor="#f4f4f4">')
    	document.writeln('\
				  </td></tr>')				  				  
	   document.writeln('\
				  <tr>')
		writeSpaceCell();
								  
	    for (var portId = 0; portId < 24 ; portId++) {
	  		// This is extra space between port 12 & 14 
			if( (portId) % 12 == 0)
		  document.writeln('\
			<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
			if ( portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
			}
		}
		
			if(portCount > 28){//For 30 port device // 10 Giga N/W module

				var nmmodule_gigaport1=uiPortDataArr[portCount-6].portName;
				var nmmodule_gigaport2=uiPortDataArr[portCount-5].portName;
				var nmmodule_gigaport3=uiPortDataArr[portCount-4].portName;
				var nmmodule_gigaport4=uiPortDataArr[portCount-3].portName;
				var nmmodule_tengigaport1=uiPortDataArr[portCount-2].portName;
				var nmmodule_tengigaport2=uiPortDataArr[portCount-1].portName;
					
				for(var i=0;i<intArray.length;i++){
				if(intArray[i].indexOf(nmmodule_gigaport1) != -1)
					nmmodule_gigaport1=intArray[i];
				else if(intArray[i].indexOf(nmmodule_gigaport2) != -1)
					nmmodule_gigaport2=intArray[i];
				else if(intArray[i].indexOf(nmmodule_gigaport3) != -1)
					nmmodule_gigaport3=intArray[i];
				else if(intArray[i].indexOf(nmmodule_gigaport4) != -1)
					nmmodule_gigaport4=intArray[i];
				else if(intArray[i].indexOf(nmmodule_tengigaport1) != -1)
					nmmodule_tengigaport1=intArray[i];
				else if(intArray[i].indexOf(nmmodule_tengigaport2) != -1)
					nmmodule_tengigaport2=intArray[i];
				}
			
			}
			if((portCount > 24 && portCount == 28) ||
			   ((nmmodule_tengigaport2.indexOf("Te") != -1 &
				 nmmodule_tengigaport2.indexOf("Not Present") > 0) &
			    (nmmodule_tengigaport1.indexOf("Te") != -1 &
				 nmmodule_tengigaport1.indexOf("Not Present") > 0))) {
				//For 1G network module ,which have G1, G2, G3, G4 SFP ports
				document.writeln('\
					  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
				for (var portId = 24; portId < 28 ; portId++)
					{
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
				   writeSpaceCell(); writeSpaceCell(); 					
				 }
				   if(portCount == 30){
						 uiPortDataArr[28].macro = MACRO_NULL;
							uiPortDataArr[29].macro = MACRO_NULL;
				}
			}
			else  if ((nmmodule_tengigaport2.indexOf("Te") != -1 &&
				nmmodule_tengigaport2.indexOf("Not Present") == -1) ||
				(nmmodule_tengigaport1.indexOf("Te") != -1 &&
				nmmodule_tengigaport1.indexOf("Not Present") == -1)) // For Te1 and Te2
			{  
				document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')	
				  	for (var portId = portCount - 6; portId < portCount ; portId++)
					{ 	
						if((nmmodule_gigaport1.indexOf("Not Present") == -1 
							|| nmmodule_gigaport2.indexOf("Not Present") == -1)) // G1,G2,Te2
						{
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
					 writeSpaceCell(); writeSpaceCell(); 
					 if(portId == 25) portId+=3;// for Te2
					 if(portId == 29) {writeSpaceCell(); writeSpaceCell();writeSpaceCell();
					 	 uiPortDataArr[26].macro = MACRO_NULL;
						  uiPortDataArr[27].macro = MACRO_NULL;
						   uiPortDataArr[28].macro = MACRO_NULL;
						   }
						}
					 else if((nmmodule_gigaport3.indexOf("Not Present") == -1 
							|| nmmodule_gigaport4.indexOf("Not Present") == -1))//Te1,G3,G4
						{
							if(portId == 24){
							portId=portId+4;
							 uiPortDataArr[24].macro = MACRO_NULL;
							  uiPortDataArr[25].macro = MACRO_NULL;
							   uiPortDataArr[29].macro = MACRO_NULL;
							   }
							document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
					 writeSpaceCell(); writeSpaceCell(); 
					 if(portId == 28) portId=portId-3;
					 if(portId == 27) {portId=portId+2; writeSpaceCell(); writeSpaceCell(); }

						}
						else {
					if(portId == 24) {
						portId=portId+4;
					uiPortDataArr[24].macro = MACRO_NULL;
					uiPortDataArr[25].macro = MACRO_NULL;
					uiPortDataArr[26].macro = MACRO_NULL;
					uiPortDataArr[27].macro = MACRO_NULL;
					}
						// Te1,Te2
						document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>')
					 writeSpaceCell(); writeSpaceCell(); 
				  if(portId == 29) {writeSpaceCell(); writeSpaceCell(); writeSpaceCell(); 
									writeSpaceCell(); writeSpaceCell();writeSpaceCell();}
						}
								
				 }
				
			}
			
	document.writeln('\
				  <td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>')
	
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "30" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');		
}
//** End of Icnredibles **//
