/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal.compression.codec;

import com.cisco.cpnm.boot.internal.compression.codec.ByteSubstring;
import com.cisco.cpnm.boot.internal.compression.codec.Util;
import java.util.Arrays;

public class BurrowsWheelerTransformer {
    public static void main(String[] args) {
        BurrowsWheelerTransformer bwt = new BurrowsWheelerTransformer();
        byte[] text = new byte[]{16, -1, 0, 7, 58, 1, 67, 1, 89, 0, 3, -57};
        System.out.println("Cleartext = ");
        int k = 0;
        while (k < text.length) {
            System.out.print("\t" + text[k]);
            ++k;
        }
        System.out.println();
        L_I codedtext_and_i = bwt.encode(text);
        byte[] codedtext = codedtext_and_i.getL();
        int I = codedtext_and_i.getI();
        System.out.println("Codedtext = ");
        int k2 = 0;
        while (k2 < codedtext.length) {
            System.out.print("\t" + codedtext[k2]);
            if (k2 == I) {
                System.out.print("*");
            }
            ++k2;
        }
        System.out.println();
        byte[] recoveredText = bwt.decode(codedtext_and_i);
        System.out.println("Recovered cleartext = ");
        int k3 = 0;
        while (k3 < recoveredText.length) {
            System.out.print("\t" + recoveredText[k3]);
            ++k3;
        }
        System.out.println();
    }

    public L_I encode(byte[] text) {
        L_I rv = new L_I();
        int _text_length_minus_1 = text.length - 1;
        ByteSubstring[] suffixArray = new ByteSubstring[text.length];
        int i = 0;
        while (i < text.length) {
            suffixArray[i] = new ByteSubstring(text, i, _text_length_minus_1);
            ++i;
        }
        this.sort(suffixArray);
        L_I.access$002(rv, new byte[text.length]);
        int i2 = 0;
        while (i2 < rv.L.length) {
            int deducedOriginalIdx = suffixArray[i2].getStartIdx();
            ((L_I)rv).L[i2] = text[(deducedOriginalIdx + _text_length_minus_1) % text.length];
            if (deducedOriginalIdx == 0) {
                rv.I = i2;
            }
            ++i2;
        }
        return rv;
    }

    public byte[] decode(L_I LAndI) {
        return this.decode(LAndI.getL(), LAndI.getI());
    }

    public byte[] decode(byte[] L, int I) {
        byte[] rv = null;
        int[] P = new int[L.length];
        int[] C = new int[256];
        int i = 0;
        while (i < L.length) {
            int unsigned_L_i = (int)Util.unsignedLong(L[i]);
            P[i] = C[unsigned_L_i];
            int n = unsigned_L_i;
            C[n] = C[n] + 1;
            ++i;
        }
        int ch = 0;
        int sum = 0;
        while (ch < C.length) {
            C[ch] = (sum += C[ch]) - C[ch];
            ++ch;
        }
        rv = new byte[L.length];
        int j = L.length - 1;
        int permutationIdx = I;
        while (j >= 0) {
            int unsigned_L_At_permutationIdx = (int)Util.unsignedLong(L[permutationIdx]);
            rv[j] = (byte)unsigned_L_At_permutationIdx;
            permutationIdx = P[permutationIdx] + C[unsigned_L_At_permutationIdx];
            --j;
        }
        return rv;
    }

    private void sort(ByteSubstring[] suffixArray) {
        Arrays.sort(suffixArray);
    }

    public static class L_I {
        private byte[] L;
        private int I;

        public final int getI() {
            return this.I;
        }

        public final byte[] getL() {
            return this.L;
        }

        public final void setI(int x) {
            this.I = x;
        }

        public final void setL(byte[] x) {
            this.L = x;
        }

        static /* synthetic */ byte[] access$002(L_I x0, byte[] x1) {
            x0.L = x1;
            return x1;
        }
    }
}

