/*
 *------------------------------------------------------------------
 * menu.js
 *
 * Copyright (c) 2003-2006 by cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 */

var sep = " > ";
var netscape = (navigator.appName.indexOf("tscape") !=-1) ? true : false;

var lvl1Padding = 14;
var lvl2Padding = 30;

function content(name, url, target, action, dontHightlight, donotdisplay) {
	this.name = name;
	this.url = url;
	if(target != null) {
		this.target = target;
	} else {
		this.target = "top.mainFrame";
	}
	this.action = action;
	if(dontHightlight != null)
		this.dontHighlight = dontHightlight;
	else
		this.dontHighlight = false;
	this.draw = _drawContent;
	this.id = null;
	this.hasChildren = false;
	this.children = new Array();
	this.donotdisplay = false;
	if(donotdisplay != null) {
		this.donotdisplay = donotdisplay;
	}
}

function _drawContent() {
	var str = "";
	var tmpDisplay = (this.donotdisplay) ? "none" : "block";
	if(this.hasChildren) { // First level menu with children
		str = "<tr id='" + this.id + "' class='firstLevelWithChildren'><td style='padding-left:" + lvl1Padding + "px;'>";
		str += "<table width='100%' cellspacing='0' cellpadding='0' border='0'><tr><td>";
		str += "<table cellspacing='0' cellpadding='0' border='0' class='leafNodeNormal' onClick='showHideChildren(\"" + this.id + "\")'><tr><td>";
		str += "<img height='10' width='10' align='middle' name='img_" + this.id + "' src='/images/mdarrow.gif'></td><td valign='middle' nowrap style='padding-left:5px;' class='secondLevelText'>";
	} else if(this.parentId) { // Second level menu
		str = "<tr id='" + this.id + "' class='secondLevelChild'><td style='padding-left:" + lvl2Padding + "px;'>";
		str += "<table width='100%' cellspacing='0' cellpadding='0' border='0'><tr><td>";
		str += "<table cellspacing='0' cellpadding='0' border='0' onMouseOver=\"this.className='leafNodeMouseOver';\" onMouseOut=\"this.className='leafNodeNormal';\" onClick='selectMenu(\"" + this.parent.name.replace(/'/g, "&#39;") + sep + this.name.replace(/'/g, "&#39;") + "\")'><tr><td>";
		str += "<img height='10' width='10' align='middle' name='img_" + this.id + "' src='/images/mleaf.gif'></td><td valign='middle' nowrap style='padding-left:5px;' class='secondLevelText'>";
	} else if(this.url && !this.parentId) { // First level menu without children
		str = "<tr id='" + this.id + "' class='firstLevelNoChildren' style='display:" + tmpDisplay + "'><td style='padding-left:" + lvl1Padding + "px;'>";
		str += "<table width='100%' cellspacing='0' cellpadding='0' border='0'><tr><td>";
		str += "<table cellspacing='0' cellpadding='0' border='0' onMouseOver=\"this.className='leafNodeMouseOver';\" onMouseOut=\"this.className='leafNodeNormal';\" onClick='selectMenu(\"" + this.name.replace(/'/g, "&#39;") + "\")'><tr><td>";
		str += "<img height='10' width='10' align='middle' name='img_" + this.id + "' src='/images/mleaf.gif'></td><td valign='middle' nowrap style='padding-left:5px;' class='secondLevelText'>";
	}	
	str += this.name + "</td></tr></table></td><td width='100%'>&nbsp;</td></tr></table></td></tr>";
	return str;
}

function TOC() {
	this.contents = new Array();
	this.addLevel1Content = _addLevel1Content;
	this.addLevel2Content = _addLevel2Content;
	this.construct = _constructTOC;
	this.draw = _drawTOC;
	this.selectedMenuId = null;
	this.collapseAll = _collapseAllTOC;
	this.frozen = false;
	this.freezeReason = null;
	this.freeze = _freezeTOC;
	this.unFreeze = _unfreezeTOC;
}

function _addLevel1Content(id, menu) {
	menu.id = "con_" + id;
	menu.index = this.contents.length;
	if(menu.url == null) menu.hasChildren = true;
	this.contents[this.contents.length] = menu;	
}

function _addLevel2Content(parentId, id, menu) {
	menu.id = "con_" + id;
	menu.index = this.contents.length;
	menu.parentId = "con_" + parentId;
	this.contents[this.contents.length] = menu;	
}

function _constructTOC() {
	for(var i=0; i< this.contents.length; i++) {
		if(this.contents[i].parentId) {
			for(var j=0; j< this.contents.length; j++) {
				if(this.contents[j].id == this.contents[i].parentId) {
					this.contents[j].children[this.contents[j].children.length] = this.contents[i].id;
					this.contents[i].parent = this.contents[j];
				}
			}
		}
	}
}

function _drawTOC() {
	this.construct();
	var str = "<table width='100%' border='0' cellspacing='0' cellpadding='0'>";
	str += "<tr><td height='5'></td></tr>";
	for(var i=0; i<this.contents.length; i++) {
		str += this.contents[i].draw();
	}
	str += "</table>";
	return str;
}

function _collapseAllTOC() {
	for (var i=0; i<toc.contents.length; i++) {
		if(toc.contents[i].hasChildren) {
			collapseMenu(i); 
		}	
	}
}

function _freezeTOC(reason) {
	this.frozen = true;
	this.freezeReason = reason;
}

function _unfreezeTOC() {
	this.frozen = false;
	this.freezeReason = null;
}

function loadHelp(id, url, target, loadPage, dontHighlight) {
	var className = null;
	if(id != toc.selectedMenuId) {
		if(toc.selectedMenuId && !dontHighlight) {
			className = document.getElementById(toc.selectedMenuId).className;
			if(className.indexOf("secondLevelChild") != -1)
				document.getElementById(toc.selectedMenuId).className = "secondLevelChild";
			else
				document.getElementById(toc.selectedMenuId).className = "firstLevelNoChildren";
		}
		className = document.getElementById(id).className;
		if(className.indexOf("secondLevelChild") != -1)
			document.getElementById(id).className = "secondLevelChildSelected";
		else {
			if(!dontHighlight)
				document.getElementById(id).className = "firstLevelNoChildrenSelected";	
		}
		if(!dontHighlight)
			toc.selectedMenuId = id;
	}
	var newUrl = url;
	if(url.indexOf("/help/") != -1) {
		newUrl = getNewUrl(url);
		if(top.toolbarFrame && top.toolbarFrame.sysInit)
			top.toolbarFrame.sysInit();
	}
	if(newUrl.indexOf("javascript:") == 0) {
		eval(newUrl);
	}
	else {
		if(loadPage != "false")
			eval(target).location.href = newUrl;
	}
}

function getNewUrl(url) {
	var family = top.window.opener.top.getSelectedDevice().family;
        var anch = null;
        if(url.indexOf("#") != -1) {
                anch = name.split("#")[1];
                url = name.split("#")[0];
        }
        var tmpUrl = url;
        if(family != null) {
                top.family = family;
                if(family == "EtherSwitch Service Module") {
                        tmpUrl = "/help2/" + url.split("/")[2];
                }
        }
        if(anch != null) tmpUrl += "#" + anch;
        return tmpUrl;
}

function selectMenu(name, loadPage) {
	if(toc.frozen) {
		alert(toc.freezeReason);
		return;
	}
	if(loadPage != 'false') {
		if(top.mainFrame.getUpdateStatus && top.mainFrame.getUpdateStatus()) {
			var msg = "Warning:\n\nThere are unsaved changes on the page.\n\nClick OK to save the changes or Cancel to discard and continue.";
			if(confirm(msg)) {
				top.mainFrame.onConfigure();
				return;
			}
		}
	}
	var parent = null; 
	var child = null; 
	var parentId = null; 
	if(name.indexOf(sep) != -1) {
		parent = token_string(sep, 0, name);
		child = token_string(sep, 1, name);		
	}	
	var anch = null;
	if(name.indexOf("#") != -1) {
		anch = name.split("#")[1];
		name = name.split("#")[0];
	}
	for(var i=0; i<toc.contents.length; i++) {
		if(parent == null) {		
			if(name == toc.contents[i].name) {
				if(toc.contents[i].hasChildren) {
					return;
				}
				if(toc.contents[i].parentId && toc.contents[i].parent.opened == false)  
					expandMenu(toc.contents[i].parent.index);
				if(anch != null)
					loadHelp(toc.contents[i].id, toc.contents[i].url + "#" + anch, toc.contents[i].target,loadPage, toc.contents[i].dontHighlight);
				else 
					loadHelp(toc.contents[i].id, toc.contents[i].url, toc.contents[i].target,loadPage, toc.contents[i].dontHighlight);
				//loadHelp(toc.contents[i].id, toc.contents[i].url, toc.contents[i].target, loadPage);
				return;
			}
		} else {
			if(child == toc.contents[i].name && parent == toc.contents[i].parent.name) {
				expandMenu(toc.contents[i].parent.index);
				if(anch != null)
					loadHelp(toc.contents[i].id, toc.contents[i].url + "#" + anch, toc.contents[i].target,loadPage, toc.contents[i].dontHighlight);
				else 
					loadHelp(toc.contents[i].id, toc.contents[i].url, toc.contents[i].target,loadPage, toc.contents[i].dontHighlight);
//				loadHelp(toc.contents[i].id, toc.contents[i].url, toc.contents[i].target, loadPage);
				return;
			}
		}
	}
	loadHelp(toc.contents[0].id, toc.contents[0].url, toc.contents[0].target,loadPage, toc.contents[0].dontHighlight);
}

function getIdFromName(name) {
	for(var i=0; i<toc.contents.length; i++) {
		if(name == toc.contents[i].name) {			
			return toc.contents[i].id;
		} 
	} 
	return null;
}

function showHideChildren(id) {
	if(toc.frozen) {
		alert(toc.freezeReason);
		return; 
	}
	for (var i=0; i<toc.contents.length; i++) {
		if(toc.contents[i].id == id) {
			if(toc.contents[i].opened) {	
				collapseMenu(i);
			} else {
				expandMenu(i);	
			}			
			return;
		}
	}
}

function collapseMenu(i) {
	var children = toc.contents[i].children;
	for(var j=0; j<children.length; j++) {
		document.getElementById(children[j]).style.display = "none";
	}
	document.images["img_" + toc.contents[i].id].src = "/images/mrarrow.gif";
	toc.contents[i].opened = false;
}

function expandMenu(i) {
	var children = toc.contents[i].children;
	for(var j=0; j<children.length; j++) {
		if(netscape) {
			document.getElementById(children[j]).style.display = "table-row";
		} else {
			document.getElementById(children[j]).style.display = "block";
		}
	}
	document.images["img_" + toc.contents[i].id].src = "/images/mdarrow.gif";
	toc.contents[i].opened = true;
}
