<!-- Copyright (c) 2005-2006 by Cisco Systems, Inc. -->
// smartports.js - Will create the frontPanel for Machete devices.
// WS-CBS3020-HPQ - Halberd2
// WS-CBS3030-DEL - Machete
// WS-CBS3040-FSC - Falchion - Internal: Gi0/1-10, External: Gi0/11-16

function createDevice(deviceType, uiPortDataArr) {
	var device = null;
	if(deviceType.indexOf("WS-CBS3020-HPQ") != -1) { //Halberd2
		device = new WSCBS3020HPQ(uiPortDataArr);
	}
	else if(deviceType.indexOf("WS-CBS3030-DEL") != -1) {
   		device = new Machete16(uiPortDataArr);
	}
	else if(deviceType.indexOf("WS-CBS3040-FSC") != -1) { //Falchion
   		device = new WSCBS3040FSC(uiPortDataArr);
	}
}

function WSCBS3020HPQ(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	for (var portId = 0; portId < 16; portId++)
		uiPortDataArr[portId].macro = MACRO_NULL;
	//last port fa0 is an internal port - it should not be displayed
	//if(portCount >= 25) {
		//uiPortDataArr[uiPortDataArr.length-1].macro = MACRO_NULL;
	//}

	document.writeln('<tr><td colspan= "12" height="3" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr>')
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	for (var portId = 16; portId < portCount; portId++) {
		if(portId % 2 == 0) {
			//condition to check if last two ports in halberd2 are acting as - internal or external, if internal hide the port
			if((portId == 22 || portId == 23) && uiPortDataArr[portId].macro == MACRO_NULL) {
				document.writeln('<td align="center" bgcolor="#f4f4f4"></td>');
			}
			else {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
					width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}
	}
	
	writeSpaceCell(); writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	
	document.writeln('<tr><td colspan= "12" height="5" bgcolor="#f4f4f4"></td></tr>');
	
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	for (var portId = 16; portId < portCount; portId++) {
		if(portId % 2 != 0) {
			if((portId == 22 || portId == 23) && uiPortDataArr[portId].macro == MACRO_NULL) {
				document.writeln('<td align="center" bgcolor="#f4f4f4"></td>');
			}
			else {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
					width="21" height="21" name="cell', '_', portId, '"></a><br>\
					<font style="font-size:9px" face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '\
					</td>');
			}
		}
	}
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>')
	document.writeln('<tr><td colspan= "12" height="5" bgcolor="#f4f4f4"></td></tr>')
}

function Machete16(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
	
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	var internalPorts = 10;
	for (var portId = 0; portId < internalPorts ; portId++) {
    	uiPortDataArr[portId].macro = MACRO_NULL;
	}
				
	for (var portId = 10; portId < portCount; portId++) {
		//if ( portId % 2 ==0) {
			if(portId == 12) {
				document.writeln('<td align="center" width="15" bgcolor="#f4f4f4"></td>');
			}
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			writeSpaceCell();
		//}
	}
	
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	
	document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
										  
	/*for (var portId = 10; portId < portCount; portId ++) {
		if ( portId % 2 !=0) {
		}
	}*/
	
	document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
}

function WSCBS3040FSC(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
	
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	var internalPorts = 10;
	for (var portId = 0; portId < internalPorts ; portId++) {
    	uiPortDataArr[portId].macro = MACRO_NULL;
	}
				
	for (var portId = 10; portId < portCount; portId++) {
		//if ( portId % 2 ==0) {
			if(portId == 12) {
				document.writeln('<td align="center" width="15" bgcolor="#f4f4f4"></td>');
			}
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			writeSpaceCell();
		//}
	}
	
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	
	document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
										  
	/*for (var portId = 10; portId < portCount; portId ++) {
		if ( portId % 2 !=0) {
		}
	}*/
	
	document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
}

function getPortLabel(intName) {
	var intNumber = intName.substring(intName.indexOf('/')+1);
	return parseInt(intNumber)
}

function isExtVlanSupported() {
	return true;
}

function getMaxVlans() {
      return 250;
}
