/*
 * Copyright (c) 2003-2009, 2015 by Cisco Systems, Inc.
 */
 
function createCmd() {
  var form = document.forms[0];
  var cmd = "";
  var newIP = getCompleteIP("text_ipAddress");
  var newGateway = getCompleteIP("text_ipDefaultGateway");
  var interfaceRanges = getInterfaceRanges();
  var conflictedInterfaces = getConflictingIpInterfaces(newIP, form.list_subnetMask.options[form.list_subnetMask.selectedIndex].value);
  
    if (!def(form.text_ipAddress0) || !def(form.text_ipAddress1) || !def(form.text_ipAddress2)
		|| !def(form.text_ipAddress3) || !def(form.list_subnetMask) || !def(form.text_VLANID)) {
	  if(!def(form.text_VLANID)) {
		for(i = 0; i < interfaceRanges.length; i++) {
			cmd += '!\n';
			cmd += 'interface range ' + interfaceRanges[i] + '\n';
			cmd += ' switchport access vlan ' + form.text_VLANID.value + '\n';
			cmd += ' switchport trunk native vlan ' + form.text_VLANID.value + '\n';
		}
		if(!isBlank(form.text_VLANID.defaultValue)) {
			cmd += '!\n';
			cmd += 'vlan ' + form.text_VLANID.defaultValue + '\n';
			cmd += 'state active\n';
		}
		cmd += '!\n';
		cmd += 'vlan ' + form.text_VLANID.value + '\n';
		cmd += 'state active\n';
	  }
	// remove conflicting IPs
	for(i = 0; i < conflictedInterfaces.length; i++) {
		if(!isSameInterface(conflictedInterfaces[i].name, form.text_VLANID.value)) {
			cmd += '!\n';
			cmd += 'interface ' + conflictedInterfaces[i].name + '\n';
			cmd += 'no ip address\n';
		}
	}
     if(!isBlank(form.text_VLANID.value)) {
	 	cmd += "!\ninterface Vlan" + form.text_VLANID.value + "\n"
	 }
	 else {
	 	cmd += "!\ninterface " + activeInterface.name + "\n"
	 }
	
	 //cmd += "ip address " + form.text_ipAddress.value + " " + form.list_subnetMask.options[form.list_subnetMask.selectedIndex].value +"\n";
	 cmd += "ip address " + newIP + " " + form.list_subnetMask.options[form.list_subnetMask.selectedIndex].value +"\n";
	 cmd += "no shutdown\n";
	 if(def(form.text_ipDefaultGateway0) && def(form.text_ipDefaultGateway1) &&
		def(form.text_ipDefaultGateway2) && def(form.text_ipDefaultGateway3)) {
	 	if(!isBlank(form.text_ipDefaultGateway0.value) && !isBlank(form.text_ipDefaultGateway1.value) &&
			!isBlank(form.text_ipDefaultGateway2.value) && !isBlank(form.text_ipDefaultGateway3.value)) {
			cmd += "!\nip default-gateway " + newGateway + "\n";
		}
	 }
  }

  if (!def(form.text_ipDefaultGateway0) || !def(form.text_ipDefaultGateway1) ||
		!def(form.text_ipDefaultGateway2) || !def(form.text_ipDefaultGateway3)) {
     	if(isBlank(form.text_ipDefaultGateway0.value) && isBlank(form.text_ipDefaultGateway1.value) &&
			isBlank(form.text_ipDefaultGateway2.value) && isBlank(form.text_ipDefaultGateway3.value)) {
         cmd += "!\nno ip default-gateway\n";
     }
     else {
         cmd += "!\nip default-gateway " + newGateway + "\n";
     }
  }

  if (!def(form.text_enableSecret) || !def(form.text_confirmEnableSecret)) {
    if (isBlank(form.text_enableSecret.value)) {
    	cmd += "!\nno enable secret\n";
    } else {
    	cmd += "!\nenable secret " + form.text_enableSecret.value + "\n";
		cmd += "!\nip http authentication enable\n";
    }
  }

  if (form.radio_telnetAccess[0].checked) {
    if (!def(form.text_telnetPassword) || !def(form.text_confirmTelnetPassword)) {
       cmd += "!\nline vty 0 15\n";
	   cmd += "password " + form.text_telnetPassword.value + "\n";  
       cmd += "login\n";  
    }
    else if (!def(form.radio_telnetAccess[0])) {
       // telnet is enabled and no password is specified.
       cmd += "!\nline vty 0 15\n";
       cmd += "login\n";  
    }
  } else {
    if (!def(form.radio_telnetAccess[1])) {
       cmd += "!\nline vty 0 15\n";
       cmd += "login\n";  
       cmd += "no password\n";  
    }
  }
  
  if (!def(form.text_sysName)) {
     if(!isBlank(form.text_sysName.value)) {
       cmd += "!\nhostname " + form.text_sysName.value + "\n";
     } else {
       cmd += "!\nno hostname\n";
     }     
  }
 
  	if(form.radio_snmpStatus[1].checked == "1") {
		if (!def(form.radio_snmpStatus[1])) {
			cmd += "no snmp-server\n";
		}
	}
	else {
		if(!isBlank(form.text_sysContact.value)) {
			if(!def(form.text_sysContact)) {
				cmd += "snmp-server contact " + form.text_sysContact.value + "\n";
			}
		}
		else if(!def(form.text_sysContact)) {
			cmd += "snmp-server contact " + form.text_sysContact.defaultValue + "\n";
			cmd += "no snmp-server contact\n";
		}
		if(!isBlank(form.text_sysLocation.value)) {
			if(!def(form.text_sysLocation)) {
				cmd += "snmp-server location " + form.text_sysLocation.value + "\n";
			}
		}
		else if(!def(form.text_sysLocation)) {
			cmd += "snmp-server location " + form.text_sysLocation.defaultValue + "\n";
			cmd += "no snmp-server location\n";
		}
	}
	  
  if (!def(form.radio_snmpStatus[0]) || !def(form.radio_snmpStatus[0]) || 
      !def(form.text_snmpReadComm) || !def(form.text_snmpWriteComm)) {  
	  if (!def(form.radio_snmpStatus[1])) {
	  
		  if(form.radio_snmpStatus[1].checked == "1") {
			  cmd += "no snmp-server\n";
		  } else {
	  
			  if(!isBlank(form.text_snmpReadComm.value)) {
				 cmd += "snmp-server community " + form.text_snmpReadComm.value + " RO\n";
			  }
	
			  if(!isBlank(form.text_snmpWriteComm.value)) {
				 cmd += "snmp-server community " + form.text_snmpWriteComm.value + " RW\n";
			  }
	
			  if(!def(form.text_snmpReadComm)) {
				 if(!isBlank(form.text_snmpReadComm.defaultValue)) {
					 cmd += "no snmp-server community " + form.SNMP_READCOMM_DEFVAL.value + " RO\n";
				 }
			  }
	
			  if(!def(form.text_snmpWriteComm)) {
				 if(!isBlank(form.text_snmpWriteComm.defaultValue)) {
					 cmd += "no snmp-server community " + form.SNMP_WRITECOMM_DEFVAL.value + " RW\n";
				 }
			  }
			  
			  // This is to enable the validate form to get invoked and detect
			  // if both the RO and RW communities are not configured.
			  if(isBlank(form.text_snmpWriteComm.value) && isBlank(form.text_snmpReadComm.value)) {
					cmd += "snmp-server community public RO\n";
			  }
		  }
	  } else {
		  if(form.radio_snmpStatus[0].checked == "1") {
	
			 if(!def(form.text_snmpReadComm)) {
				 if(!isBlank(form.text_snmpReadComm.defaultValue)) {
					  cmd += "no snmp-server community " + form.SNMP_READCOMM_DEFVAL.value + " RO\n";
				 }
			 }
			 
			 if(!def(form.text_snmpWriteComm)) {
				 if(!isBlank(form.text_snmpWriteComm.defaultValue)) {
					  cmd += "no snmp-server community " + form.SNMP_WRITECOMM_DEFVAL.value + " RW\n";
				 }
			 }
			 
			 if(!def(form.text_snmpReadComm)) {
				 if(!isBlank(form.text_snmpReadComm.value)) {
					cmd += "snmp-server community " + form.text_snmpReadComm.value + " RO\n";
				 }
			 }
			 
			 if(!def(form.text_snmpWriteComm)) {
				 if(!isBlank(form.text_snmpWriteComm.value)) {
					cmd += "snmp-server community " + form.text_snmpWriteComm.value + " RW\n";
				 }
			 } else {
				 // when both RO and RW communities are same, set only the RW community.
				 if(form.text_snmpReadComm.value == form.text_snmpWriteComm.value) { 
					cmd += "snmp-server community " + form.text_snmpWriteComm.value + " RW\n";
				 }
			 }          
		 }            
	  }
  }
  
	// for system date and time.  
	if((isExpressSetupMode) || !def(form.cbox_daylightSavings) || !def(form.list_timezone)) {
		if(!form.cbox_daylightSavings.checked) {
			cmd += "no clock summer-time\n";
		} else {
			var id = form.list_timezone.selectedIndex;
			if(id >= 3 && id <= 7) { 					// US
				//cmd += "clock summer-time UTC recurring first sunday april 02:00 last sunday october 02:00 60\n"
				cmd += "clock summer-time UTC recurring 2 sunday march 02:00 first sunday november 02:00 60\n";
			} else if (id >= 26 && id <= 27) {// Australia
				cmd += "clock summer-time UTC recurring last sunday october 02:00 last sunday march 03:00 60\n";
			} else if (id == 12) { 						// Europe UTC-01:00
				//command is "clock summer-time <TZ> recurring last sunday march 01:00UTC last sunday october 02:00UTC 60"
				cmd += "clock summer-time UTC recurring last sunday march 00:00 last sunday october 01:00 60\n"
			} else if (id == 13) { 						// Europe UTC
				cmd += "clock summer-time UTC recurring last sunday march 01:00 last sunday october 02:00 60\n"
			} else if (id == 14) { 						// Europe UTC+01:00
				cmd += "clock summer-time UTC recurring last sunday march 02:00 last sunday october 03:00 60\n"
			} else if (id == 15) { 						// Europe UTC+02:00
				cmd += "clock summer-time UTC recurring last sunday march 03:00 last sunday october 04:00 60\n"
			}
		}
	}

	if((isExpressSetupMode) || !def(form.list_date) || !def(form.list_month) || !def(form.list_year) ||
   	!def(form.list_hour) || !def(form.list_minute) || !def(form.list_period) ||	!def(form.list_timezone)) {
		if(isExpressSetupMode || !def(form.list_timezone)) {
			cmd += "clock timezone UTC " + TZ_OFFSET[form.list_timezone.selectedIndex] + "\n";
		}
		//clock set 16:59:00 1 mar 2005
		var cmdHr = parseInt(form.list_hour.options[form.list_hour.selectedIndex].value, 10) % 12;	  
		if(form.list_period.selectedIndex == 1) {
			cmdHr += 12;
		}
		cmd += "do clock set " + cmdHr + ":" + form.list_minute.selectedIndex + ":00 ";
		cmd += (form.list_date.selectedIndex + 1) + " " + form.list_month.options[form.list_month.selectedIndex].value + " ";
		cmd += form.list_year.selectedIndex + MIN_YEAR + "\n";	  
	}
	
	if(isIPv6Supported) {
		cmd = cmd + createIPv6Commands();
	}
	
	if(isPixar) {
		if (!def(form.text_fa0ipAddress0) || !def(form.text_fa0ipAddress1) || !def(form.text_fa0ipAddress2)
		|| !def(form.text_fa0ipAddress3) || !def(form.list_fa0subnetMask)) {
			var fa0_newIP = getCompleteIP("text_fa0ipAddress");
			if(fa0_newIP.replace(/\./g, "") == "") {
				cmd += '!\n';
				cmd += 'interface FastEthernet0' + '\n';
				cmd += "no ip address\n";
			}
			else {
				var fa0_conflictedInterfaces = getConflictingIpInterfaces(fa0_newIP, form.list_fa0subnetMask.options[form.list_fa0subnetMask.selectedIndex].value);
				// remove conflicting IPs
				for(i = 0; i < fa0_conflictedInterfaces.length; i++) {
					if(!isSameInterface(fa0_conflictedInterfaces[i].name, "FastEthernet0")) {
						cmd += '!\n';
						cmd += 'interface ' + fa0_conflictedInterfaces[i].name + '\n';
						cmd += 'no ip address\n';
					}
				}
				cmd += '!\n';
				cmd += 'interface FastEthernet0' + '\n';
				cmd += 'ip address ' + fa0_newIP + ' ' + form.list_fa0subnetMask.options[form.list_fa0subnetMask.selectedIndex].value + '\n';
				cmd += "no shutdown\n";
			}
		}
	}
  if(!isBlank(cmd)) {
  	cmd += "!\nend\n";
  }
  return cmd;

}

function addFa0ConfigGroup() {
	var tableStr = '';
	tableStr += '			<table width=100% border="0" cellspacing="0" cellpadding="0" class="xpcontentbgcolor"><!-- Table 2-->';
	tableStr += '				<tr><!-- Panel Title -->';
	tableStr += '					<td width="1"></td>';
	tableStr += '					<td width="2"></td>';
	tableStr += '					<td><img src="images/spacer.gif" height="1" width="15"></td>';
	tableStr += '					<td rowspan="4" valign="middle" class="contentbold" nowrap><fieldset>&nbsp;' + re_xSetup_Grp1Tt4 + '&nbsp;</fieldset></td>';
	tableStr += '					<td width="65%"><img src="images/spacer.gif" height="8"></td>';
	tableStr += '					<td width="2"></td>';
	tableStr += '					<td width="1"></td>';
	tableStr += '				</tr>';
	tableStr += '				<tr>';
	tableStr += '					<td width="1" colspan="2" rowspan="2" class="xpcontentbgcolor"><img src="images/top_left.gif" height="3" width="3"></td>';
	tableStr += '					<td height="1" class="xpcontentbordercolor"></td>';
	tableStr += '					<td height="1" class="xpcontentbordercolor"></td>';
	tableStr += '					<td width="1" colspan="2" rowspan="2" class="xpcontentbgcolor"><img src="images/top_right.gif" height="3" width="3"></td>';
	tableStr += '				</tr>';
	tableStr += '				<tr>';
	tableStr += '					<td width="1" height="2"></td>';
	tableStr += '					<td width="1" height="2"></td>';
	tableStr += '				</tr>';
	tableStr += '				<tr>';
	tableStr += '					<td width="1" height="8" class="xpcontentbordercolor"></td>';
	tableStr += '					<td width="2" height="8"></td>';
	tableStr += '					<td><img src="images/spacer.gif" height="1" width="1"></td>';
	tableStr += '					<td><img src="images/spacer.gif" height="8" width="1"></td>';
	tableStr += '					<td width="2" height="8"></td>';
	tableStr += '					<td width="1" height="8" class="xpcontentbordercolor"></td>';
	tableStr += '				</tr><!--Fields-->';
	tableStr += '				<tr>';
	tableStr += '					<td width="1" class="xpcontentbordercolor"></td>';
	tableStr += '					<td colspan="5">';
	tableStr += '						<table align="left" border="0" width="100%" height="100%" cellspacing="10" cellpadding="0"><!-- Table 3-->';
	tableStr += '						<tr>';
	tableStr += '						<td align="center" valign="middle">';
	tableStr += '							<table width="100%" border="0" cellspacing="0" cellpadding="3" height="100%" class="xpcontent"><!-- Table 4-->';
	tableStr += '							<tr>';
	tableStr += '								<td width="220" nowrap>' + re_xSetup_LblIPAddress + ':&nbsp;<img src="/images/informational16.gif" align="absmiddle" id="Fa0IPBalloonHelp" onMouseOver="tooltipLayer(this)" onMouseOut="hideLayer()"></td>';
	tableStr += '								<td nowrap width="10%"></td>';
	tableStr += '								<td width="170" nowrap>';
	tableStr += '									<input type="text" value="" name="text_fa0ipAddress0" style="width:33px;" maxlength="3" onBlur="onChangeIP(this, 223);" onKeyDown="onBtnDn(this);" onKeyUp="onBtnUp(this,event,3,this.form.text_fa0ipAddress1)">.';
	tableStr += '									<input type="text" value="" name="text_fa0ipAddress1" style="width:33px;" maxlength="3" onBlur="onChangeIP(this, 255);" onKeyDown="onBtnDn(this);" onKeyUp="onBtnUp(this,event,3,this.form.text_fa0ipAddress2)">.';
	tableStr += '									<input type="text" value="" name="text_fa0ipAddress2" style="width:33px;" maxlength="3" onBlur="onChangeIP(this, 255);" onKeyDown="onBtnDn(this);" onKeyUp="onBtnUp(this,event,3,this.form.text_fa0ipAddress3)">.';
	tableStr += '									<input type="text" value="" name="text_fa0ipAddress3" style="width:33px;" maxlength="3" onBlur="onChangeIP(this, 255);" onKeyDown="onBtnDn(this);" onKeyUp="onBtnUp(this,event,3,this.form.list_fa0subnetMask)"></td>';
	tableStr += '								<td nowrap width="50%"></td>';
	tableStr += '								<td width="180" nowrap>' + re_xSetup_LblSubnet + ':</td>';
	tableStr += '								<td nowrap width="10%"></td>';
	tableStr += '								<td width="135" nowrap>';
	tableStr += '									<select size="1" name="list_fa0subnetMask">';
	tableStr += '									  <option value="128.0.0.0">128.0.0.0</option><option value="192.0.0.0">192.0.0.0</option><option value="224.0.0.0">224.0.0.0</option><option value="240.0.0.0">240.0.0.0</option><option value="248.0.0.0">248.0.0.0</option><option value="252.0.0.0">252.0.0.0</option><option value="254.0.0.0">254.0.0.0</option><option value="255.0.0.0">255.0.0.0</option><option value="255.128.0.0">255.128.0.0</option><option value="255.192.0.0">255.192.0.0</option><option value="255.224.0.0">255.224.0.0</option><option value="255.240.0.0">255.240.0.0</option><option value="255.248.0.0">255.248.0.0</option><option value="255.252.0.0">255.252.0.0</option><option value="255.254.0.0">255.254.0.0</option><option value="255.255.0.0">255.255.0.0</option><option value="255.255.128.0">255.255.128.0</option><option value="255.255.192.0">255.255.192.0</option><option value="255.255.224.0">255.255.224.0</option><option value="255.255.240.0">255.255.240.0</option><option value="255.255.248.0">255.255.248.0</option><option value="255.255.252.0">255.255.252.0</option><option value="255.255.254.0">255.255.254.0</option><option value="255.255.255.0" selected>255.255.255.0</option><option value="255.255.255.128">255.255.255.128</option><option value="255.255.255.192">255.255.255.192</option><option value="255.255.255.224">255.255.255.224</option><option value="255.255.255.240">255.255.255.240</option><option value="255.255.255.248">255.255.255.248</option><option value="255.255.255.252">255.255.255.252</option><option value="255.255.255.254">255.255.255.254</option>';
	tableStr += '									</select>';
	tableStr += '								</td>';
	tableStr += '							</tr>';
								
	tableStr += '							</table><!-- Table 4-->';
	tableStr += '						</td>';
	tableStr += '						</tr>';
	tableStr += '						</table><!--Table 3 -->';
	tableStr += '					</td>';
	tableStr += '					<td width="1" class="xpcontentbordercolor"></td>';
	tableStr += '				</tr>';
	tableStr += '				<tr>';
	tableStr += '					<td width="1" colspan="2" rowspan="2" class="xpcontentbgcolor"><img src="images/bottom_left.gif" height="3" width="3"></td>';
	tableStr += '					<td height="2" colspan="3"></td>';
	tableStr += '					<td width="1" colspan="2" rowspan="2" class="xpcontentbgcolor"><img src="images/bottom_right.gif" height="3" width="3"></td>';
	tableStr += '				</tr>';
	tableStr += '				<tr>';
	tableStr += '					<td width="1" colspan="3" height="1" class="xpcontentbordercolor"><img src="images/spacer.gif" width="1" height="1"></td>';
	tableStr += '				</tr>';
	tableStr += '				</table><!-- Table 2 -->';
	
	set_layercontent("fa0TableDiv", tableStr);
	document.getElementById("fa0ConfTblCell").style.height = "";
	setVisibleLayer("fa0TableDiv", true);
}

function addControllerConfigGroup() {
	if(controllerMgmtInfoArr == null || controllerMgmtInfoArr.length < 1)
		return;
	
	var form = document.forms["xsetupForm"];
	var hiddenFieldsStr = "";
		
	controllerTable = new SortTable("controllerTable");
	controllerTable.AddHeader(new Array(re_xSetup_LblCtrllerStackNumber.replace("{\n}", "<br>"), re_xSetup_LblCtrllerVlan.replace("{\n}", "<br>"), re_xSetup_LblIPAddress, re_xSetup_LblSubnet, re_xSetup_LblDefGateway), new Array("number", "form", "form", "form", "form"), new Array("center", "center", "center", "center", "center"));
	if(document.all)
		controllerTable.width = "100%";
	else
		controllerTable.width = 725;
	controllerTable.minwidth = 725;
	controllerTable.height = 34;
	controllerTable.SetColumnWidth(new Array(85, 115, 190, 145, 190));
	
	for(var i=0; i<controllerMgmtInfoArr.length; i++) {
		hiddenFieldsStr += "<input type='hidden' name='text_ctrl_swnumber_" + i + "' value='" + controllerMgmtInfoArr[i][0] + "'>";
		
		controllerTable.AddLine(controllerMgmtInfoArr[i][0], '<input type="text" name="text_ctrl_VLANID_' + i + '" style="width:33px;" disabled value="' + controllerMgmtInfoArr[i][1] + '">', 
		'<input type="text" name="text_ctrl_ipAddress_' + i + '_0" style="width:33px;" maxlength="3" onBlur="onChangeIP(this);" \
			onKeyDown="onBtnDn(this);" onKeyUp="onBtnUp(this,event,3,this.form.text_ctrl_ipAddress_' + i + '_1)" value="' + controllerMgmtInfoArr[i][2][0] + '">. \
			<input type="text" name="text_ctrl_ipAddress_' + i + '_1" style="width:33px;" maxlength="3" onBlur="onChangeIP(this);" \
			onKeyDown="onBtnDn(this);" onKeyUp="onBtnUp(this,event,3,this.form.text_ctrl_ipAddress_' + i + '_2)" value="' + controllerMgmtInfoArr[i][2][1] + '">. \
			<input type="text" name="text_ctrl_ipAddress_' + i + '_2" style="width:33px;" maxlength="3" onBlur="onChangeIP(this);" \
			onKeyDown="onBtnDn(this);" onKeyUp="onBtnUp(this,event,3,this.form.text_ctrl_ipAddress_' + i + '_3)" value="' + controllerMgmtInfoArr[i][2][2] + '">. \
			<input type="text" name="text_ctrl_ipAddress_' + i + '_3" style="width:33px;" maxlength="3" onBlur="onChangeIP(this);" \
			onKeyDown="onBtnDn(this);" onKeyUp="onBtnUp(this,event,3,this.form.list_ctrl_subnetMask_' + i + ')" value="' + controllerMgmtInfoArr[i][2][3] + '">',
		'<select size="1" name="list_ctrl_subnetMask_' + i + '">\
			<option value="128.0.0.0">128.0.0.0</option>\
			<option value="192.0.0.0">192.0.0.0</option>\
			<option value="224.0.0.0">224.0.0.0</option>\
			<option value="240.0.0.0">240.0.0.0</option>\
			<option value="248.0.0.0">248.0.0.0</option>\
			<option value="252.0.0.0">252.0.0.0</option>\
			<option value="254.0.0.0">254.0.0.0</option>\
			<option value="255.0.0.0">255.0.0.0</option>\
			<option value="255.128.0.0">255.128.0.0</option>\
			<option value="255.192.0.0">255.192.0.0</option>\
			<option value="255.224.0.0">255.224.0.0</option>\
			<option value="255.240.0.0">255.240.0.0</option>\
			<option value="255.248.0.0">255.248.0.0</option>\
			<option value="255.252.0.0">255.252.0.0</option>\
			<option value="255.254.0.0">255.254.0.0</option>\
			<option value="255.255.0.0">255.255.0.0</option>\
			<option value="255.255.128.0">255.255.128.0</option>\
			<option value="255.255.192.0">255.255.192.0</option>\
			<option value="255.255.224.0">255.255.224.0</option>\
			<option value="255.255.240.0">255.255.240.0</option>\
			<option value="255.255.248.0">255.255.248.0</option>\
			<option value="255.255.252.0">255.255.252.0</option>\
			<option value="255.255.254.0">255.255.254.0</option>\
			<option value="255.255.255.0">255.255.255.0</option>\
			<option value="255.255.255.128">255.255.255.128</option>\
			<option value="255.255.255.192">255.255.255.192</option>\
			<option value="255.255.255.224">255.255.255.224</option>\
			<option value="255.255.255.240">255.255.255.240</option>\
			<option value="255.255.255.248">255.255.255.248</option>\
			<option value="255.255.255.252">255.255.255.252</option>\
			<option value="255.255.255.254">255.255.255.254</option>\
		</select>',
		'<input type="text" name="text_ctrl_ipDefaultGateway_' + i + '_0" style="width:33px;" maxlength="3" onBlur="onChangeIP(this);" \
		onKeyDown="onBtnDn(this);" onKeyUp="onBtnUp(this,event,3,this.form.text_ctrl_ipDefaultGateway_' + i + '_1)" value="' + controllerMgmtInfoArr[i][3][0] + '">. \
		<input type="text" name="text_ctrl_ipDefaultGateway_' + i + '_1" style="width:33px;" maxlength="3" onBlur="onChangeIP(this);" \
		onKeyDown="onBtnDn(this);" onKeyUp="onBtnUp(this,event,3,this.form.text_ctrl_ipDefaultGateway_' + i + '_2)" value="' + controllerMgmtInfoArr[i][3][1] + '">. \
		<input type="text" name="text_ctrl_ipDefaultGateway_' + i + '_2" style="width:33px;" maxlength="3" onBlur="onChangeIP(this);" \
		onKeyDown="onBtnDn(this);" onKeyUp="onBtnUp(this,event,3,this.form.text_ctrl_ipDefaultGateway_' + i + '_3)" value="' + controllerMgmtInfoArr[i][3][2] + '">. \
		<input type="text" name="text_ctrl_ipDefaultGateway_' + i + '_3" style="width:33px;" maxlength="3" onBlur="onChangeIP(this);" \
		onKeyDown="onBtnDn(this);" onKeyUp="onBtnUp(this,event,3)" value="' + controllerMgmtInfoArr[i][3][3] + '">');
	}
	
	var tableStr = '';
	tableStr += '				<table width=100% border="0" cellspacing="0" cellpadding="0" class="xpcontentbgcolor"><!-- Table 2-->';
	tableStr += '				<tr><!-- Panel Title -->';
	tableStr += '					<td width="1"></td>';
	tableStr += '					<td width="2"></td>';
	tableStr += '					<td><img src="images/spacer.gif" height="1" width="15"></td>';
	tableStr += '					<td rowspan="4" valign="middle" class="contentbold" nowrap><fieldset>&nbsp;' + re_xSetup_Grp1Tt3 + '&nbsp;</fieldset></td>';
	tableStr += '					<td width="80%"><img src="images/spacer.gif" height="8"></td>';
	tableStr += '					<td width="2"></td>';
	tableStr += '					<td width="1"></td>';
	tableStr += '				</tr>';
	tableStr += '				<tr>';
	tableStr += '					<td width="1" colspan="2" rowspan="2" class="xpcontentbgcolor"><img src="images/top_left.gif" height="3" width="3"></td>';
	tableStr += '					<td height="1" class="xpcontentbordercolor"></td>';
	tableStr += '					<td height="1" class="xpcontentbordercolor"></td>';
	tableStr += '					<td width="1" colspan="2" rowspan="2" class="xpcontentbgcolor"><img src="images/top_right.gif" height="3" width="3"></td>';
	tableStr += '				</tr>';
	tableStr += '				<tr>';
	tableStr += '					<td width="1" height="2"></td>';
	tableStr += '					<td width="1" height="2"></td>';
	tableStr += '				</tr>';
	tableStr += '				<tr>';
	tableStr += '					<td width="1" height="8" class="xpcontentbordercolor"></td>';
	tableStr += '					<td width="2" height="8"></td>';
	tableStr += '					<td><img src="images/spacer.gif" height="1" width="1"></td>';
	tableStr += '					<td><img src="images/spacer.gif" height="8" width="1"></td>';
	tableStr += '					<td width="2" height="8"></td>';
	tableStr += '					<td width="1" height="8" class="xpcontentbordercolor"></td>';
	tableStr += '				</tr><!--Fields-->';
	tableStr += '				<tr>';
	tableStr += '					<td width="1" class="xpcontentbordercolor"></td>';
	tableStr += '					<td colspan="5">';
	tableStr += '						<table align="left" border="0" width="100%" height="100%" cellspacing="10" cellpadding="0"><!-- Table 3-->';
	tableStr += '						<tr>';
	tableStr += '						<td align="center" valign="middle">';
	tableStr += '							<table width="100%" border="0" cellspacing="0" cellpadding="3" height="100%" class="xpcontent"><!-- Table 4-->';
	tableStr += '							<tr>';
	tableStr += '								<td width="100%" align="center" valign="middle"><div id="controllerCellDiv">';
	tableStr += controllerTable.BuildTable();
	tableStr += '								</div></td>';
	
	tableStr += '							</tr>';															
	tableStr += '							</table><!-- Table 4-->';
	tableStr += '						</td>';
	tableStr += '						</tr>';
	tableStr += '						</table><!--Table 3 -->';
	tableStr += '					</td>';
	tableStr += '					<td width="1" class="xpcontentbordercolor"></td>';
	tableStr += '				</tr>';
	tableStr += '				<tr>';
	tableStr += '					<td width="1" colspan="2" rowspan="2" class="xpcontentbgcolor"><img src="images/bottom_left.gif" height="3" width="3"></td>';
	tableStr += '					<td height="2" colspan="3"></td>';
	 tableStr += '					<td width="1" colspan="2" rowspan="2" class="xpcontentbgcolor"><img src="images/bottom_right.gif" height="3" width="3"></td>';
	tableStr += '				</tr>';
	tableStr += '				<tr>';
	tableStr += '					<td width="1" colspan="3" height="1" class="xpcontentbordercolor"><img src="images/spacer.gif" width="1" height="1"></td>';
	tableStr += '				</tr>';
	tableStr += '				</table><!-- Table 2 -->';
	
	set_layercontent("controllerTableDiv", tableStr);
	set_layercontent("controllerHiddenFields", hiddenFieldsStr);
	
	for(var i=0; i<controllerMgmtInfoArr.length; i++) {
		eval("document.forms['xsetupForm'].list_ctrl_subnetMask_" + i).value = controllerMgmtInfoArr[i][8];
		if(controllerMgmtInfoArr[i][8] == "0.0.0.0") {
     		eval("document.forms['xsetupForm'].list_ctrl_subnetMask_" + i).value = "";
  		}
  		if(eval("document.forms['xsetupForm'].list_ctrl_subnetMask_" + i).selectedIndex >= 0) {
			eval("document.forms['xsetupForm'].list_ctrl_subnetMask_" + i).options[eval("document.forms['xsetupForm'].list_ctrl_subnetMask_" + i).selectedIndex].defaultSelected = true;
		}
		
		eval("document.forms['xsetupForm'].text_ctrl_ipAddress_" + i + "_0").defaultValue = eval("document.forms['xsetupForm'].text_ctrl_ipAddress_" + i + "_0").value;
		eval("document.forms['xsetupForm'].text_ctrl_ipAddress_" + i + "_1").defaultValue = eval("document.forms['xsetupForm'].text_ctrl_ipAddress_" + i + "_1").value;
		eval("document.forms['xsetupForm'].text_ctrl_ipAddress_" + i + "_2").defaultValue = eval("document.forms['xsetupForm'].text_ctrl_ipAddress_" + i + "_2").value;
		eval("document.forms['xsetupForm'].text_ctrl_ipAddress_" + i + "_3").defaultValue = eval("document.forms['xsetupForm'].text_ctrl_ipAddress_" + i + "_3").value;
		
		eval("document.forms['xsetupForm'].text_ctrl_ipDefaultGateway_" + i + "_0").defaultValue = eval("document.forms['xsetupForm'].text_ctrl_ipDefaultGateway_" + i + "_0").value;
		eval("document.forms['xsetupForm'].text_ctrl_ipDefaultGateway_" + i + "_1").defaultValue = eval("document.forms['xsetupForm'].text_ctrl_ipDefaultGateway_" + i + "_1").value;
		eval("document.forms['xsetupForm'].text_ctrl_ipDefaultGateway_" + i + "_2").defaultValue = eval("document.forms['xsetupForm'].text_ctrl_ipDefaultGateway_" + i + "_2").value;
		eval("document.forms['xsetupForm'].text_ctrl_ipDefaultGateway_" + i + "_3").defaultValue = eval("document.forms['xsetupForm'].text_ctrl_ipDefaultGateway_" + i + "_3").value;
		
		if(isBlank(form.SETUP_MODE.value)) {
			eval("document.forms['xsetupForm'].text_ctrl_VLANID_" + i).disabled = false;
		}
	}
	
	document.getElementById("ctrllerConfTblCell").style.height = "";
	document.getElementById("ctrllerConfTblCell").style.padding = "15px";
	document.getElementById("ctrllerConfTblCell").style.paddingTop = "0px";
	setVisibleLayer("controllerTableDiv", true);
}

function parseControllerData(controllerCli, setupMode) {
	var controllerInfo = new Array();
	controllerMgmtInfoGlobalArr = new Array();
	var controllerCliArr = trim_string(controllerCli).split("\n");
	if(controllerCli.indexOf("Invalid input detected at") < 0 && controllerCliArr.length > 1) {
		//info order - swno vlan ip/subnet gateway http https mac version
		for(var i=1; i<controllerCliArr.length; i++) {
			var controllerMgmtInfo = trim_string(compact_line(controllerCliArr[i]));
			var tmpControllerMgmtInfoArr = controllerMgmtInfo.split(" ");
			if(!isBlank(setupMode)) {
				if(top.getSelectedDevice().stackNumber == tmpControllerMgmtInfoArr[0]) {
					controllerInfo[controllerInfo.length] = tmpControllerMgmtInfoArr;
					var tmpIPAddress = controllerInfo[controllerInfo.length-1][2].split("/");
					controllerInfo[controllerInfo.length-1][2] = tmpIPAddress[0].split(".");
					controllerInfo[controllerInfo.length-1][3] = controllerInfo[controllerInfo.length-1][3].split(".");
					controllerInfo[controllerInfo.length-1][8] = getSubnet(tmpIPAddress[1]);
					top.dataCache.put("Home_controllerIPAddress", tmpIPAddress[0]);
					top.dataCache.put("Home_controllerMACAddress", tmpControllerMgmtInfoArr[6]);
					top.dataCache.put("Home_controllerSwVersion", tmpControllerMgmtInfoArr[7]);
					top.dataCache.put("Home_controllerHttpMode", tmpControllerMgmtInfoArr[5]);
					top.dataCache.put("Home_controllerCli", controllerCli);
				}
			}
			else {
				controllerInfo[controllerInfo.length] = tmpControllerMgmtInfoArr;
				var tmpIPAddress = controllerInfo[controllerInfo.length-1][2].split("/");
				controllerInfo[controllerInfo.length-1][2] = tmpIPAddress[0].split(".");
				controllerInfo[controllerInfo.length-1][3] = controllerInfo[controllerInfo.length-1][3].split(".");
				controllerInfo[controllerInfo.length-1][8] = getSubnet(tmpIPAddress[1]);
			}
			//this additional global array is required to handle the case where user loads express setup page and
			//changes stack member selection before a fpv refresh happens, then the page would load stale data from last refresh
			controllerMgmtInfoGlobalArr[controllerMgmtInfoGlobalArr.length] = controllerMgmtInfo.split(" ");
			var tmpIPAddress = controllerMgmtInfoGlobalArr[controllerMgmtInfoGlobalArr.length-1][2].split("/");
			controllerMgmtInfoGlobalArr[controllerMgmtInfoGlobalArr.length-1][2] = tmpIPAddress[0].split(".");
			controllerMgmtInfoGlobalArr[controllerMgmtInfoGlobalArr.length-1][3] = controllerMgmtInfoGlobalArr[controllerMgmtInfoGlobalArr.length-1][3].split(".");
			controllerMgmtInfoGlobalArr[controllerMgmtInfoGlobalArr.length-1][8] = getSubnet(tmpIPAddress[1]);
		}
		return controllerInfo;
	}
	else {
		return null;
	}
}

function getSubnet(numberOfBits) {
	if(!isNaN(parseInt(numberOfBits))) {
		var maskBits = numberOfBits % 8;
		var subnet = "";
		for(var i=0; i<(numberOfBits - maskBits)/8; i++) {
			subnet += "255.";
		}
		subnet += Math.pow(2, 8) - Math.pow(2, (8-maskBits));
		if((numberOfBits - maskBits)/8 < 3) {
			for(var i=0; i<3-(numberOfBits - maskBits)/8; i++) {
				subnet += ".0";
			}
		}
		return subnet;
	}
	else {
		return null;
	}
}

function onStackMemberSelection() {
	var form = document.forms["xsetupForm"];
	
	if(top && top.getSelectedDevice && top.getSelectedDevice()) {
		deviceType = top.getSelectedDevice().type;
	}
	else {
		deviceType =find_string(/bytes of memory./, " ", 1, form.VERSION.value);
	}
	
	isFoxhound = (deviceType.indexOf("WS-C3750G-24PS-W12") != -1 || deviceType.indexOf("WS-C3750G-24PS-W24") != -1 || deviceType.indexOf("WS-C3750G-24WS-S12") != -1 || deviceType.indexOf("WS-C3750G-24WS-S24") != -1 || deviceType.indexOf("WS-C3750G-24WS-S25") != -1 || deviceType.indexOf("WS-C3750G-24WS-S50") != -1);
	
	document.getElementById("ctrllerConfTblCell").style.height = "0px";
	document.getElementById("ctrllerConfTblCell").style.padding = "0px";
	document.getElementById("ctrllerConfTblCell").style.paddingTop = "0px";
	setVisibleLayer("controllerTableDiv", false);
	set_layercontent("controllerTableDiv", "");
	set_layercontent("controllerHiddenFields", "");
	
	if(isFoxhound) {
		controllerMgmtInfoArr = new Array();
		for(var i=0; i<controllerMgmtInfoGlobalArr.length; i++) {
			if(controllerMgmtInfoGlobalArr[i][0] == top.getSelectedDevice().stackNumber) {
				controllerMgmtInfoArr[controllerMgmtInfoArr.length] = controllerMgmtInfoGlobalArr[i];
			}
		}
		addControllerConfigGroup();
	}
}

function refreshPage() {
	if(top.dataCache.get("Home_controllerCli").indexOf("Invalid input detected at") < 0) {
		var form = document.forms["xsetupForm"];
		controllerMgmtInfoArr = null;
		controllerMgmtInfoArr = parseControllerData(top.dataCache.get("Home_controllerCli"), form.SETUP_MODE.value);
	}
}


/* 
 * validation functions
 */

function validateForm()
{
  if(invalidIpFlag == true && !(document.all)) {
  	invalidIpFlag = false;
	return false;
  }

  var form = document.forms[0];
  confirmMsgs = new Array();

	if(isBlank(form.SETUP_MODE.value)) {
		if(!def(form.text_VLANID) && (isBlank(form.text_VLANID.value) || isNaN(form.text_VLANID.value))) {
			alert(vlanIdWarning);
			return false;
		} else {
			var t_vlanid = parseInt(form.text_VLANID.value, 10);
			if(t_vlanid < 1 || t_vlanid > 1001) {
				alert(vlanIdWarning);
				return false;
			}
		}
	
	}
	
	if(isActiveIntFa0) {
		if(isBlank(form.text_VLANID.value) || isNaN(form.text_VLANID.value)) {
			alert(vlanIdWarning);
			return false;
		}
	}
 
/*
  if (isBlank(form.text_ipAddress.value)) {
     alert(noIPAddressWarning);
     return false;
  }
 
  if (!isIP(form.text_ipAddress.value)) {
     alert("ERROR:\n\n" + form.text_ipAddress.value + " is an invalid IP address.\nEnter a valid IP address.");
     return false;
  }
*/
	if(isBlank(form.text_ipAddress0.value) && isBlank(form.text_ipAddress1.value) 
		&& isBlank(form.text_ipAddress2.value) && isBlank(form.text_ipAddress3.value)) {
		alert(noIPAddressWarning);
		return false;		
	}

	var ip = getCompleteIP("text_ipAddress");
	if(!isIP(ip)) {		
		alert(replaceParams(re_xSetup_ErrMsg21, new Array(ip))); //("Error:\n\n\"" + ip + "\" is not a valid IP Address. Enter an IP address in the x.x.x.x format, where x can be 0 to 255.");
		return false;
	}

  if (isBlank(form.SETUP_MODE.value)) {
      if(ip == "10.0.0.1" || ip == "10.0.0.3") {
          alert(ipNotAllowedWarning);
          return false;
      }
  }
  
  if (!isValidHostIP(ip, form.list_subnetMask.options[form.list_subnetMask.selectedIndex].value)) {
     	alert(replaceParams(re_xSetup_ErrMsg22, new Array(ip))); //("Error:\n\n" + ip + " is not a valid IP address.");
     	return false;
  }
  
  if (!def(form.text_ipAddress0) || !def(form.text_ipAddress1) || !def(form.text_ipAddress2)
		|| !def(form.text_ipAddress3) || !def(form.list_subnetMask)) {
     redirectToNewIPPage = true;
	 if(!def(form.text_VLANID)) {
		var conflictedInterfaces = getConflictingIpInterfaces(ip, form.list_subnetMask.options[form.list_subnetMask.selectedIndex].value);
		var conflicts = "";
		for(i = 0; i < conflictedInterfaces.length; i++) {
			if(!isSameInterface(conflictedInterfaces[i].name, form.text_VLANID.value)) {
				conflicts += conflictedInterfaces[i].name + "\t" + conflictedInterfaces[i].ip + "\t" + conflictedInterfaces[i].netmask + "\n";
			}
		}
		if(!isBlank(conflicts)) {
			if(isActiveIntFa0) {
				alert(replaceParams(re_xSetup_ErrMsg60, new Array(ip, conflicts)));
				return false;
			}
			else {
				confirmMsgs[confirmMsgs.length] = replaceParams(re_xSetup_ConfMsg5, new Array(ip, conflicts, ip, form.text_VLANID.value));
			}
		}
	 }
	 else if(!isBlank(form.SETUP_MODE.value) && top && top.getSelectedDevice && top.getSelectedDevice() && (top.getSelectedDevice().type.indexOf("WS-CBS3020-HPQ") != -1 || isPixar)) {
		 var conflictedInterfaces = getConflictingIpInterfaces(ip, form.list_subnetMask.options[form.list_subnetMask.selectedIndex].value);
		var conflicts = "";
		for(i = 0; i < conflictedInterfaces.length; i++) {
			if(!isSameInterface(conflictedInterfaces[i].name, form.text_VLANID.value)) {
				conflicts += conflictedInterfaces[i].name + "\t" + conflictedInterfaces[i].ip + "\t" + conflictedInterfaces[i].netmask + "\n";
			}
		}
		if(!isBlank(conflicts)) {
			alert(replaceParams(re_xSetup_ErrMsg60, new Array(ip, conflicts)));
			return false;
		}
	 }
  }

/*
  if (isBlank(form.text_ipDefaultGateway.value)) {
     confirmMsgs[confirmMsgs.length] = noDefaultGatewayWarning;
  }
  else if (!isIP(form.text_ipDefaultGateway.value)) {
     alert("ERROR:\n\n\"" + form.text_ipDefaultGateway.value + "\" is an invalid gateway IP address format.\nEnter a valid gateway IP address.");
     return false;
  }
*/
	var defaultGateway = "";
	if(isBlank(form.text_ipDefaultGateway0.value) && isBlank(form.text_ipDefaultGateway1.value) 
		&& isBlank(form.text_ipDefaultGateway2.value) && isBlank(form.text_ipDefaultGateway3.value)) {
		confirmMsgs[confirmMsgs.length] = noDefaultGatewayWarning;
	} else {
		defaultGateway = getCompleteIP("text_ipDefaultGateway");
		if(!isIP(defaultGateway)) {
			alert(replaceParams(re_xSetup_ErrMsg23, new Array(defaultGateway))); //("Error:\n\n\"" + defaultGateway + "\" is not a valid IP address for the default gateway.\nEnter the IP address in the x.x.x.x format, where x can be 0 to 255.");
			return false;
		}
	}
  
  if(ip == defaultGateway) {
     alert(sameIpAndGatewayError);
     return false;
  }

  if (!isBlank(defaultGateway)) {
	 if(!isInSameSubnet(ip, defaultGateway, form.list_subnetMask.options[form.list_subnetMask.selectedIndex].value)) {
		 alert(invalidGatewayWarning);
		 return false;
	}
	else if (!isValidHostIP(defaultGateway, form.list_subnetMask.options[form.list_subnetMask.selectedIndex].value)) {
     	alert(replaceParams(re_xSetup_ErrMsg24, new Array(defaultGateway))); //("Error:\n\n" + defaultGateway + " is not a valid default gateway IP address.");
     	return false;
	}
  }
  
  if (isBlank(form.text_enableSecret.value)) {
	showError(re_xSetup_ErrMsg87);
	return false;
  }
  
  if (!def(form.text_enableSecret) || !def(form.text_confirmEnableSecret)) {
     
     // To check whether there are any leading/trailing blank spaces in 
     // the password.
     if(trim_string(form.text_enableSecret.value) != form.text_enableSecret.value) {
          alert(switchPasswdWarningMsg);
          return false;
     }
	 
	 if(form.text_enableSecret.value == DEFAULT_PASSWORD) {
          showError(re_xSetup_ErrMsg88);
          return false;
	 }

     if (!isBlank(form.text_enableSecret.value) && !isValidPasswd(form.text_enableSecret.value)) {
         alert(invalidCharinPasswordError);
         return false;
     }
     
     if(doesStringHasUcodeChar(form.text_enableSecret.value)) {
	     showError(re_xSetup_ErrMsg54);
	     return false;
	 }

     if(form.text_confirmEnableSecret.value != form.text_enableSecret.value) {
          alert(noMatchPasswordConfirmError);
          return false;
     }
     
     if(form.text_enableSecret.value.length > 25) {
         alert(switchPasswordTooLongError);
         return false;
     }

	 if(form.text_enableSecret.value.length ==1 && !isNaN(form.text_enableSecret.value) ||
		form.text_confirmEnableSecret.value.length ==1 && !isNaN(form.text_confirmEnableSecret.value)) {
		alert(replaceParams(re_xSetup_ErrMsg80,new Array(form.text_enableSecret.value)));
		return false;
	}
  }

  if(isPixar) {
	  var fa0_newIP = getCompleteIP("text_fa0ipAddress");
	  if(fa0_newIP.replace(/\./g, "") != "") {
		  if(!def(form.text_fa0ipAddress0) || !def(form.text_fa0ipAddress1) || !def(form.text_fa0ipAddress2)
			|| !def(form.text_fa0ipAddress3)) {
			  if(!isIP(fa0_newIP)) {		
				alert(replaceParams(re_xSetup_ErrMsg21, new Array(fa0_newIP)));
				return false;
			  }
			
			if (isBlank(form.SETUP_MODE.value)) {
		      if(fa0_newIP == "10.0.0.1" || fa0_newIP == "10.0.0.3") {
		          alert(ipNotAllowedWarning);
		          return false;
		      }
		  	}
			
		  	if (!isValidHostIP(fa0_newIP, form.list_fa0subnetMask.options[form.list_fa0subnetMask.selectedIndex].value)) {
		     	alert(replaceParams(re_xSetup_ErrMsg22, new Array(fa0_newIP)));
		     	return false;
		  	}
		  }
	  	if (!def(form.text_fa0ipAddress0) || !def(form.text_fa0ipAddress1) || !def(form.text_fa0ipAddress2)
			|| !def(form.text_fa0ipAddress3) || !def(form.list_fa0subnetMask)) {
			var fa0_conflictedInterfaces = getConflictingIpInterfaces(fa0_newIP, form.list_fa0subnetMask.options[form.list_fa0subnetMask.selectedIndex].value);
			var fa0_conflicts = "";
			for(i=0; i<fa0_conflictedInterfaces.length; i++) {
				if(!isSameInterface(fa0_conflictedInterfaces[i].name, "FastEthernet0")) {
					fa0_conflicts += fa0_conflictedInterfaces[i].name + "\t" + fa0_conflictedInterfaces[i].ip + "\t" + fa0_conflictedInterfaces[i].netmask + "\n";
				}
			}
			if(!isBlank(fa0_conflicts)) {
				confirmMsgs[confirmMsgs.length] = replaceParams(re_xSetup_ConfMsg5, new Array(fa0_newIP, fa0_conflicts, fa0_newIP, "FastEthernet0"));
			}
		}
	}
  }
  //controller fields validation
  if(isFoxhound) {
  	for(var i=0; i<controllerMgmtInfoArr.length; i++) {
	
		if(isBlank(form.SETUP_MODE.value)) {
			if(!def(eval("form.text_ctrl_VLANID_" + i)) && (isBlank(eval("form.text_ctrl_VLANID_" + i).value) || isNaN(eval("form.text_ctrl_VLANID_" + i).value))) {
				
				alert(replaceParams(re_xSetup_ErrMsg32, new Array("" + eval("form.text_ctrl_swnumber_" + i).value)));
				return false;
			}
			else {
				var t_vlanid = parseInt(eval("form.text_ctrl_VLANID_" + i).value, 10);
				if(t_vlanid < 0 || t_vlanid > 1001) {
					
					alert(replaceParams(re_xSetup_ErrMsg32, new Array("" + eval("form.text_ctrl_swnumber_" + i).value)));
					return false;
				}
			}	
		}
		
		if(isBlank(eval("form.text_ctrl_ipAddress_" + i + "_0").value) && isBlank(eval("form.text_ctrl_ipAddress_" + i + "_1").value) && isBlank(eval("form.text_ctrl_ipAddress_" + i + "_2").value) && isBlank(eval("form.text_ctrl_ipAddress_" + i + "_3").value)) {
			
			alert(replaceParams(re_xSetup_ErrMsg34, new Array("" + eval("form.text_ctrl_swnumber_" + i).value)));
			return false;
		}
		
		var ctrlIp = getCompleteIP("text_ctrl_ipAddress_" + i + "_");
		if(!isIP(ctrlIp)) {		
			alert(replaceParams(re_xSetup_ErrMsg21, new Array("" + ctrlIp)));
			return false;
		}
		
		if (!isValidHostIP(ctrlIp, eval("form.list_ctrl_subnetMask_" + i).options[eval("form.list_ctrl_subnetMask_" + i).selectedIndex].value)) {
			alert(replaceParams(re_xSetup_ErrMsg22, new Array("" + ctrlIp)));
			return false;
		}
	
		var ctrlDefaultGateway = "";
		if(isBlank(eval("form.text_ctrl_ipDefaultGateway_" + i + "_0").value) && isBlank(eval("form.text_ctrl_ipDefaultGateway_" + i + "_1").value) 
			&& isBlank(eval("form.text_ctrl_ipDefaultGateway_" + i + "_2").value) && isBlank(eval("form.text_ctrl_ipDefaultGateway_" + i + "_3").value)) {
			
			alert(replaceParams(re_xSetup_ErrMsg37, new Array("" + eval("form.text_ctrl_swnumber_" + i).value)));
			return false;
		} else {
			ctrlDefaultGateway = getCompleteIP("text_ctrl_ipDefaultGateway_" + i + "_");
			if(!isIP(ctrlDefaultGateway)) {
				alert(replaceParams(re_xSetup_ErrMsg23, new Array("" + ctrlDefaultGateway)));
				return false;
			}
		}
	  
	  if(ctrlIp == ctrlDefaultGateway) {
	     
		 alert(replaceParams(re_xSetup_ErrMsg39, new Array("" + eval("form.text_ctrl_swnumber_" + i).value)));
	     return false;
	  }
	
	  if (!isBlank(ctrlDefaultGateway)) {
		 if(!isInSameSubnet(ctrlIp, ctrlDefaultGateway, eval("form.list_ctrl_subnetMask_" + i).options[eval("form.list_ctrl_subnetMask_" + i).selectedIndex].value)) {
			 
			 alert(replaceParams(re_xSetup_ErrMsg40, new Array("" + eval("form.text_ctrl_swnumber_" + i).value)));
			 return false;
		}
		else if (!isValidHostIP(ctrlDefaultGateway, eval("form.list_ctrl_subnetMask_" + i).options[eval("form.list_ctrl_subnetMask_" + i).selectedIndex].value)) {
	     	alert(replaceParams(re_xSetup_ErrMsg24, new Array("" + ctrlDefaultGateway))); ("Error:\n\n" + ctrlDefaultGateway + " is not a valid default gateway IP address.");
	     	return false;
		}
	  }
	 }
  }
  //controller fields validation end
  
  if (!def(form.text_sysName)) {
     if(!isValidString(form.text_sysName.value) || form.text_sysName.value.indexOf("\\") >= 0 || form.text_sysName.value.indexOf("/") >= 0) {
         alert(invalidHostnameError);
         return false;
     }
     
     if(doesStringHasUcodeChar(form.text_sysName.value)) {
         showError(re_xSetup_ErrMsg55);
         return false;
     }
  }

  if (form.radio_snmpStatus[0].checked == true) {
	  if (!def(form.text_sysContact) && !isBlank(form.text_sysContact.value) && !isSnmpString(form.text_sysContact.value)) {
			alert(sysContactWarning);
			return false;
	  }    
	  
	  if (!def(form.text_sysContact) && !isBlank(form.text_sysContact.value) && doesStringHasUcodeChar(form.text_sysContact.value)) {
			showError(re_xSetup_ErrMsg58);
			return false;
	  }    
	  
	  if (!def(form.text_sysLocation) && !isBlank(form.text_sysLocation.value) && !isSnmpString(form.text_sysLocation.value)) {
			alert(sysLocationWarning);
			return false;
	  }
	  
	  if (!def(form.text_sysLocation) && !isBlank(form.text_sysLocation.value) && doesStringHasUcodeChar(form.text_sysLocation.value)) {
			showError(re_xSetup_ErrMsg59);
			return false;
	  }
  }
  else if(!isBlank(form.text_sysContact.value) || !isBlank(form.text_sysLocation.value)) {
      return false;
  }
  
  if (!def(form.text_telnetPassword) || !def(form.text_confirmTelnetPassword)) {
     if (form.radio_telnetAccess[0].checked) {

        // To check whether there are any leading/trailing blank spaces in 
        // the password.
        if(trim_string(form.text_telnetPassword.value) != form.text_telnetPassword.value) {
           alert(telnetPasswdWarningMsg);
           return false;
        }

     	if (isBlank(form.text_telnetPassword.value)) {
         alert(needTelnetPasswordError);
         return false;       
     	}
     	
        if (!isValidPasswd(form.text_telnetPassword.value)) {
          alert(invalidCharinTelnetPassword);
          return false;
        }
        
        if (doesStringHasUcodeChar(form.text_telnetPassword.value)) {
          showError(re_xSetup_ErrMsg56);
          return false;
        }
        
        if(form.text_confirmTelnetPassword.value != form.text_telnetPassword.value) {
           alert(noMatchTelnetPasswordError);
           return false;
        }
        
        if (form.text_telnetPassword.value.length > 25) {
           alert(telnetPasswordTooLongError);
           return false;
        }
        
        if (def(form.radio_telnetAccess[0]) && form.text_telnetPassword.defaultValue == "") {
	        confirmMsgs[confirmMsgs.length] = re_xSetup_ConfMsg14;
        }
     }
     else if (!isBlank(form.text_telnetPassword.value) || !isBlank(form.text_confirmTelnetPassword.value)) {
         return false;
     }
  }
  else if (!def(form.radio_telnetAccess[0])) {
     //just enable telnet access and no password specified
     if (isBlank(form.text_telnetPassword.value)) {
         alert(needTelnetPasswordError);
         return false;       
     }
  }

  if (!def(form.radio_snmpStatus[0]) || !def(form.radio_snmpStatus[0]) || 
      !def(form.text_snmpReadComm) || !def(form.text_snmpWriteComm)) {
	  
	  if (form.radio_snmpStatus[0].checked == true) {
		 if (isBlank(form.text_snmpReadComm.value) && isBlank(form.text_snmpWriteComm.value)) {
			alert(needCommunityStringError);
			return false;
		 }
		 if (!def(form.text_snmpReadComm)) {
			if(!isBlank(form.text_snmpReadComm.value) && !isValidString(form.text_snmpReadComm.value)) {
				alert(invalidSnmpCommError);
				return false;
			}
			
			if(!isBlank(form.text_snmpReadComm.value) && doesStringHasUcodeChar(form.text_snmpReadComm.value)) {
				showError(re_xSetup_ErrMsg57);
				return false;
			}
		 }
		 if (!def(form.text_snmpWriteComm)) {
			if(!isBlank(form.text_snmpWriteComm.value) && !isValidString(form.text_snmpWriteComm.value)) {
				alert(invalidSnmpCommError);
				return false;
			}
			
			if(!isBlank(form.text_snmpWriteComm.value) && doesStringHasUcodeChar(form.text_snmpWriteComm.value)) {
				showError(re_xSetup_ErrMsg57);
				return false;
			}
		 }
		 if (!def(form.text_snmpWriteComm) || !def(form.text_snmpReadComm)) {
			if(form.text_snmpReadComm.value == form.text_snmpWriteComm.value) {
				alert(sameSnmpCommError);
			return false;
			}
		 }
	  }
	  else if (!isBlank(form.text_snmpReadComm.value) || !isBlank(form.text_snmpWriteComm.value)) {
		  return false;
	  }
  }
	
  //confirm whether user wants to continue without password or gateway
  var i = 0;
  for (i = 0; i < confirmMsgs.length; i++) {
  	if(!isBlank(confirmMsgs[i]) && !confirm(confirmMsgs[i])) {
  		return false;
  	}
  }
  return true;
}

// space, tab and ? are invalid in hostname and community strings
function isValidString(str)
{
    if (str.search(/[\s\t?]/) != -1) {
        return false;
    }
    return true;
}

// tab and ? are invalid in password fields
function isValidPasswd(str)
{
  if (isBlank(str))
    return false
  if (str.search(/[\t?]/) != -1)
    return false
  return true
}

// tab and ? are invalid in contact and location fields
function isSnmpString(str)
{
    if (str.search(/[\t?]/) != -1) {
        return false;
    }
    return true;
}


/*
 * tab functions
 */
// it changes the clicked tab as active and the other deactive
function changeActiveTab(i) {
	if (document.getElementById("xStep1").style.display == "none" && document.getElementById("xStep2").style.display == "block")
		return;
	for( j=0; j < 2; ++j ) {
		if( j==i ) {
			activateTab(j);
			activeTabNo = j; 
		} else {
			deactivateTab(j);
		}
	}
}
// converts the deactive tab images to active images and hidden layer to visible
function activateTab(i) {
	document.getElementById( "tab-left:"+i ).src='images/tab_left_active.gif';
	document.getElementById( "tab-bg:"+i ).className = 'tabheaderselected';
	document.getElementById( "tab-right:"+i ).src='images/tab_right_active.gif';
	document.getElementById( "tab-body:"+i ).style.display='block';
	document.getElementById( "tabtd-left:"+i ).className='tabselected';
	document.getElementById( "tabtd-right:"+i ).className='tabselected';
	activeTab = i;
}
// converts the active tab images to deactive tab images and  changes the visible layer to hidden
function deactivateTab(i) {
	document.getElementById( "tab-left:"+i ).src='images/tab_left_inactive.gif';
	document.getElementById( "tab-bg:"+i ).className='tabheader';
	document.getElementById( "tab-right:"+i ).src='images/tab_right_inactive.gif';
	document.getElementById( "tab-body:"+i ).style.display='none';
	document.getElementById( "tabtd-left:"+i ).className='tab';
	document.getElementById( "tabtd-right:"+i ).className='tab';
}

/*
 * ipv6 functions
 */
function onDelete() {
	if(reloadFlag) return false;
	if(selectedAddressArray.length == 0) {
		showError(re_xSetup_ErrMsg61);
		return;
	}
	else {
		for(var i=0; i<selectedAddressArray.length; i++) {
			if(selectedAddressArray[i] != null) {
				var tmp = selectedAddressArray[i].split(",");
				//the address exists in the device, mark it deleted in the original array
				if(ipv6Interfaces[tmp[0]] != null && ipv6Interfaces[tmp[0]][5] != null && ipv6Interfaces[tmp[0]][5][tmp[1]] != null) {
					ipv6Interfaces[tmp[0]][5][tmp[1]] = false;
					ipv6Interfaces_modified[tmp[0]][5][tmp[1]] = false;
				}
				else { //the deleted address was added in this session and can be deleted from the modified array
					for(var j=1; j<6; j++) {
						var tmpArr = ipv6Interfaces_modified[tmp[0]][j].slice(0, tmp[1]);
						if(ipv6Interfaces_modified[tmp[0]][j].length > tmp[1])
							tmpArr = tmpArr.concat(ipv6Interfaces_modified[tmp[0]][j].slice(parseInt(tmp[1])+1));
						ipv6Interfaces_modified[tmp[0]][j] = tmpArr.slice();
					}
				}
			}
		}
		selectedAddressArray = new Array();
		buildIPv6Table();
		set_layercontent("ipv6CellDiv", ipv6Table.BuildTable());
		
	}
}

function onEnableIPv6(obj) {
	if(reloadFlag) return false;
	var form = document.forms[0];
	if(obj.checked && isIPv6Enabled) {
		form.btn_Add.disabled = false;
		form.btn_Delete.disabled = false;
		if(isIPv6Enabled) { //enable all fields in the IPv6 table
			for(var i=0; i<ipv6Interfaces_modified.length; i++) {
				for(var j=0; j<ipv6Interfaces_modified[i][1].length; j++) {
					if(ipv6Interfaces_modified[i][0] == activeInterface.name || ipv6Interfaces_modified[i][0] == "Fa0") {
						if(ipv6Interfaces_modified[i][5][j]) {
							for(var k=0; k<8; k++) {
								eval("form.text_ipv6Address" + k + "_" + i + "_" + j).disabled = false;
							}
							eval("form.list_prefix_" + i + "_" + j).disabled = false;
							eval("form.cbox_eui_" + i + "_" + j).disabled = false;
							eval("form.cbox_select_" + i + "_" + j).disabled = false;
						}
					}
				}
			}
		}
	}
	else if(!obj.checked) {
		form.btn_Add.disabled = true;
		form.btn_Delete.disabled = true;
		if(isIPv6Enabled) { //disable all fields in the IPv6 table
			for(var i=0; i<ipv6Interfaces_modified.length; i++) {
				for(var j=0; j<ipv6Interfaces_modified[i][1].length; j++) {
					if(ipv6Interfaces_modified[i][0] == activeInterface.name || ipv6Interfaces_modified[i][0] == "Fa0") {
						if(ipv6Interfaces_modified[i][5][j]) {
							for(var k=0; k<8; k++) {
								eval("form.text_ipv6Address" + k + "_" + i + "_" + j).disabled = true;
							}
							eval("form.list_prefix_" + i + "_" + j).disabled = true;
							eval("form.cbox_eui_" + i + "_" + j).disabled = true;
							eval("form.cbox_select_" + i + "_" + j).disabled = true;
						}
					}
				}
			}
		}
	}
}

var CUSTOMIZE_BTNS = top.DONE_BTN | top.CANCEL_BTN;
function onAdd() {
	if(reloadFlag) return false;
	var form = document.forms[0];
	updateIPv6ModifiedArray();
	document.getElementById("xStep1").style.display = "none";
	document.getElementById("xStep2").style.display = "block";
	top.setButtons(CUSTOMIZE_BTNS);
	set_layercontent("titleDiv", re_xSetup_Ttl2);
	document.getElementById("titleDiv").scrollIntoView(true);
}

function onPreviousStep() {
	var form = document.forms[0];
	var tmp_ipv6Address = form.text_ipv6Address0.value + ":" + form.text_ipv6Address1.value + ":" + form.text_ipv6Address2.value + ":" + form.text_ipv6Address3.value + ":" + form.text_ipv6Address4.value + ":" + form.text_ipv6Address5.value + ":" + form.text_ipv6Address6.value + ":" + form.text_ipv6Address7.value;
	if(tmp_ipv6Address.replace(/[:\s]/g, "") == "") {
		document.getElementById("xStep1").style.display = "block";
		document.getElementById("xStep2").style.display = "none";
		top.setButtons(top.CONFIG_BTNS);
		set_layercontent("titleDiv", re_xSetup_Ttl);
		//reset add screen fields
		form.list_ipv6_interface.selectedIndex = 0;
		form.list_prefix.value = 64;
		form.cbox_eui.checked = false;
		form.text_ipv6Address0.value = ""; form.text_ipv6Address1.value = ""; form.text_ipv6Address2.value = "";
		form.text_ipv6Address3.value = ""; form.text_ipv6Address4.value = ""; form.text_ipv6Address5.value = "";
		form.text_ipv6Address6.value = ""; form.text_ipv6Address7.value = "";
	}
	else {
		if(validateIPv6Address(tmp_ipv6Address, form.list_prefix.value, form.cbox_eui.checked)) {
			var tmp_intIndex = 0;
			var tmp_addressIndex = 0;
			for(var i=0; i<ipv6Interfaces_modified.length; i++) {
				if(ipv6Interfaces_modified[i][0] == form.list_ipv6_interface.value) {
					tmp_intIndex = i;
					tmp_addressIndex = ipv6Interfaces_modified[i][1].length;
				}
			}
			
			if(tmp_ipv6Address.replace(/[:\s]/g, "") != "") { //if all the ipv6 fields are empty return
				var tmp = tmp_ipv6Address.split(":");
				
				for(var i=0; i<tmp.length; i++) {
					var tmp_oct = "0000" + tmp[i];
					tmp[i] = tmp_oct.substring(tmp_oct.length - 4).toUpperCase();
				}
				
				if(tmp_addressIndex == 0) {
					ipv6Interfaces_modified[ipv6Interfaces_modified.length] = new Array();
					ipv6Interfaces_modified[ipv6Interfaces_modified.length-1][0] = form.list_ipv6_interface.value;
					ipv6Interfaces_modified[ipv6Interfaces_modified.length-1][1] = new Array();
					ipv6Interfaces_modified[ipv6Interfaces_modified.length-1][2] = new Array();
					ipv6Interfaces_modified[ipv6Interfaces_modified.length-1][3] = new Array();
					ipv6Interfaces_modified[ipv6Interfaces_modified.length-1][4] = new Array();
					ipv6Interfaces_modified[ipv6Interfaces_modified.length-1][5] = new Array();
					tmp_intIndex = ipv6Interfaces_modified.length-1;
				}
				ipv6Interfaces_modified[tmp_intIndex][1][tmp_addressIndex] = tmp.join(":");
				ipv6Interfaces_modified[tmp_intIndex][2][tmp_addressIndex] = form.list_prefix.value;
				ipv6Interfaces_modified[tmp_intIndex][3][tmp_addressIndex] = form.cbox_eui.checked;
				ipv6Interfaces_modified[tmp_intIndex][4][tmp_addressIndex] = getIPv6Subnet(tmp.join(":"), form.list_prefix.value);
				ipv6Interfaces_modified[tmp_intIndex][5][tmp_addressIndex] = true;
				
				//ipv6Table.AddLine(form.list_ipv6_interface.value, '<input type="text" name="text_ipv6Address0_' + tmp_intIndex + '_' + tmp_addressIndex + '" value="' + tmp[0] + '" style="width:44px;" maxlength="4" onblur="onLostFocusIPv6(this)">:<input type="text" name="text_ipv6Address1_' + tmp_intIndex + '_' + tmp_addressIndex + '" value="' + tmp[1] + '" style="width:44px;" maxlength="4" onblur="onLostFocusIPv6(this)">:<input type="text" name="text_ipv6Address2_' + tmp_intIndex + '_' + tmp_addressIndex + '" value="' + tmp[2] + '" style="width:44px;" maxlength="4" onblur="onLostFocusIPv6(this)">:<input type="text" name="text_ipv6Address3_' + tmp_intIndex + '_' + tmp_addressIndex + '" value="' + tmp[3] + '" style="width:44px;" maxlength="4" onblur="onLostFocusIPv6(this)">:<input type="text" name="text_ipv6Address4_' + tmp_intIndex + '_' + tmp_addressIndex + '" value="' + tmp[4] + '" style="width:44px;" maxlength="4" onblur="onLostFocusIPv6(this)">:<input type="text" name="text_ipv6Address5_' + tmp_intIndex + '_' + tmp_addressIndex + '" value="' + tmp[5] + '" style="width:44px;" maxlength="4" onblur="onLostFocusIPv6(this)">:<input type="text" name="text_ipv6Address6_' + tmp_intIndex + '_' + tmp_addressIndex + '" value="' + tmp[6] + '" style="width:44px;" maxlength="4" onblur="onLostFocusIPv6(this)">:<input type="text" name="text_ipv6Address7_' + tmp_intIndex + '_' + tmp_addressIndex + '" value="' + tmp[7] + '" style="width:44px;" maxlength="4" onblur="onLostFocusIPv6(this)">', '<select name="list_prefix_' + tmp_intIndex + '_' + tmp_addressIndex + '" onchange="onChangeIPv6Prefix(this, ' + tmp_intIndex + ', ' + tmp_addressIndex + ')">' + ipv6_prefix_options.replace('<option value="' + form.list_prefix.value + '">' + form.list_prefix.value, '<option value="' + form.list_prefix.value + '" selected>' + form.list_prefix.value) + '</select>', '<input type="checkbox" name="cbox_eui_' + tmp_intIndex + '_' + tmp_addressIndex + '" ' + ((form.cbox_eui.checked == true) ? 'checked' : '') + ' onclick="onSelectEui(this, ' + tmp_intIndex + ', ' + tmp_addressIndex + ')">', '<input type="checkbox" name="cbox_select_' + tmp_intIndex + '_' + tmp_addressIndex + '" onclick="onSelectIPv6Address(this, ' + tmp_intIndex + ', ' + tmp_addressIndex + ')">');
				buildIPv6Table();
				set_layercontent("ipv6CellDiv", ipv6Table.BuildTable());
				SortRows(ipv6Table, 0);
			}
			document.getElementById("xStep1").style.display = "block";
			document.getElementById("xStep2").style.display = "none";
			top.setButtons(top.CONFIG_BTNS);
			set_layercontent("titleDiv", re_xSetup_Ttl);
			document.getElementById("addButton").scrollIntoView(true);
			//reset add screen fields
			form.list_ipv6_interface.selectedIndex = 0;
			form.list_prefix.value = 64;
			form.cbox_eui.checked = false;
			form.text_ipv6Address0.value = ""; form.text_ipv6Address1.value = ""; form.text_ipv6Address2.value = "";
			form.text_ipv6Address3.value = ""; form.text_ipv6Address4.value = ""; form.text_ipv6Address5.value = "";
			form.text_ipv6Address6.value = ""; form.text_ipv6Address7.value = "";
		}
	}
}

function validateIPv6Address(_ipv6, _prefix, _eui, _interfaceIndex, _addressIndex) {
	if(_ipv6 != null && _prefix != null && _eui != null) { //individual address validation
		var tmp_ipv6Address = _ipv6;
		var tmp = tmp_ipv6Address.split(":");
		for(var i=0; i<tmp.length; i++) {
			var tmp_oct = "0000" + tmp[i];
			tmp[i] = tmp_oct.substring(tmp_oct.length - 4).toUpperCase();
			if(tmp[i].replace(/[0-9ABCDEF]/g, "") != "") {
				showError(replaceParams(re_xSetup_ErrMsg62, new Array(""+tmp_ipv6Address)));
				return false;
			}
		}
		var tmp_ipv6 = tmp.join(":");
		if((tmp_ipv6.replace(/[0:]/g, "") == "" && !_eui) || (tmp_ipv6.replace(/[0:]/g, "") == "" && _eui && _prefix >= 96)) {
			showError(replaceParams(re_xSetup_ErrMsg62, new Array(""+tmp_ipv6Address)));
			return false;
		}
		
		if(tmp[0].toLowerCase().substring(0,2) == "ff") { //multicast
			showError(replaceParams(re_xSetup_ErrMsg63, new Array(""+tmp_ipv6)));
			return false;
		}
		if(tmp[0].toLowerCase().substring(0,3) == "fec") { //sitelocal
			showError(replaceParams(re_xSetup_ErrMsg64, new Array(""+tmp_ipv6)));
			return false;
		}
		
		var subnet = getIPv6Subnet(tmp_ipv6, _prefix);
		
		for(var i=0; i<ipv6Interfaces_modified.length; i++) {
			for(var j=0; j<ipv6Interfaces_modified[i][1].length; j++) {
				if(ipv6Interfaces_modified[i][5][j] && ((_interfaceIndex == null && _addressIndex == null) || !(_interfaceIndex == i && _addressIndex == j))) {
					if(tmp_ipv6 == ipv6Interfaces_modified[i][1][j]) {
						showError(replaceParams(re_xSetup_ErrMsg65, new Array(""+tmp_ipv6)));
						return false;
					}
					if(subnet == ipv6Interfaces_modified[i][4][j]) {
						showError(replaceParams(re_xSetup_ErrMsg66, new Array(tmp_ipv6, ipv6Interfaces_modified[i][0], ipv6Interfaces_modified[i][1][j], ipv6Interfaces_modified[i][4][j])));
						return false;
					}
					if(getIPv6Subnet(ipv6Interfaces_modified[i][1][j], ipv6Interfaces_modified[i][2][j]) == getIPv6Subnet(tmp_ipv6, ipv6Interfaces_modified[i][2][j]) || getIPv6Subnet(ipv6Interfaces_modified[i][1][j], _prefix) == getIPv6Subnet(tmp_ipv6, _prefix)) {
						showError(replaceParams(re_xSetup_ErrMsg66, new Array(tmp_ipv6, ipv6Interfaces_modified[i][0], ipv6Interfaces_modified[i][1][j], ipv6Interfaces_modified[i][4][j])));
						return false;
					}
				}
			}
		}
	}
	else { //on submit validation
		/*var form = document.forms[0];
		for(var i=0 ;i<ipv6Interfaces_modified.length; i++) { //update array values
			for(var j=0; j<ipv6Interfaces_modified[i][1].length; j++) {
				if(ipv6Interfaces_modified[i][5][j]) {
					var tmp_address = new Array();;
					for(var k=0; k<8; k++) {
						var tmp = eval("form.text_ipv6Address" + k + "_" + i + "_" + j).value;
						tmp = ("0000" + tmp).substring(("0000" + tmp).length - 4);
						tmp_address[tmp_address.length] = tmp;
					}
					ipv6Interfaces_modified[i][1][j] = tmp_address.join(":");
					ipv6Interfaces_modified[i][4][j] = getIPv6Subnet(ipv6Interfaces_modified[i][1][j], ipv6Interfaces_modified[i][2][j])
				}
			}
		}*/
		for(var i=0 ;i<ipv6Interfaces_modified.length; i++) { //update array values
			for(var j=0; j<ipv6Interfaces_modified[i][1].length; j++) {
				if(ipv6Interfaces_modified[i][5][j]) {
					if(!validateIPv6Address(ipv6Interfaces_modified[i][1][j], ipv6Interfaces_modified[i][2][j], ipv6Interfaces_modified[i][3][j], i, j)) {
						return false;
					}
				}
			}
		}
	}
	return true;
}

function onChangeIPv6Prefix(prefixCmb, interfaceIndex, addressIndex) {
	if(interfaceIndex != null && addressIndex != null) {
		//**is validation required here?
		ipv6Interfaces_modified[interfaceIndex][2][addressIndex] = prefixCmb.value;
		ipv6Interfaces_modified[interfaceIndex][4][addressIndex] = getIPv6Subnet(ipv6Interfaces_modified[interfaceIndex][1][addressIndex], prefixCmb.value);
		return;
	}
}

function onSelectEui(euiChkBox, interfaceIndex, addressIndex) {
	if(document.getElementById("xStep2").style.display == "none" && interfaceIndex != null && addressIndex != null) {
		//**if the function is called from ipv6 table just update the array **is this enough?
		ipv6Interfaces_modified[interfaceIndex][3][addressIndex] = euiChkBox.checked;
		//return;
	}
	var form = document.forms[0];
	var elemSuffix = "";
	if(interfaceIndex != null && addressIndex != null) {
		elemSuffix = "_" + interfaceIndex + "_" + addressIndex;
	}
	if(euiChkBox.checked) {		
		var tmp_ipv6Address = eval("form.text_ipv6Address0" + elemSuffix).value + ":" + eval("form.text_ipv6Address1" + elemSuffix).value + ":" + eval("form.text_ipv6Address2" + elemSuffix).value + ":" + eval("form.text_ipv6Address3" + elemSuffix).value + ":" + eval("form.text_ipv6Address4" + elemSuffix).value + ":" + eval("form.text_ipv6Address5" + elemSuffix).value + ":" + eval("form.text_ipv6Address6" + elemSuffix).value + ":" + eval("form.text_ipv6Address7" + elemSuffix).value;
		var tmp_ipv6Arr = tmp_ipv6Address.split(":");
		var updatedIPAddress = new Array();
		var prefix = eval("form.list_prefix" + elemSuffix).value;
		
		for(var i=0; i<tmp_ipv6Arr.length;i++) {
			tmp_ipv6Arr[i] = ("0000" + tmp_ipv6Arr[i]).substring(("0000" + tmp_ipv6Arr[i]).length - 4);
		}
		
		var euiAddress = "";
		for(var i=0; i<macAddressArray.length; i++) {
			if(macAddressArray[i][0] == form.list_ipv6_interface.value) {
				euiAddress = macAddressArray[i][1].split(":");
			}
		}
		
		var tmp = prefix % 16;
		if(tmp == 0) {
			updatedIPAddress = tmp_ipv6Arr.slice(0, prefix/16);
			if(prefix < 64) {
				var zeroArray = new Array("0000", "0000", "0000", "0000", "0000", "0000", "0000", "0000");
				updatedIPAddress = updatedIPAddress.concat(zeroArray.slice(0, (64-prefix)/16));
			}
			if(prefix <= 64)
				updatedIPAddress = updatedIPAddress.concat(euiAddress);
			else
				updatedIPAddress = updatedIPAddress.concat(euiAddress.slice((prefix-64)/16));
		}
		else {
			var lastOctet = tmp_ipv6Arr[(prefix - tmp)/16];
			var reqBits = h2b(lastOctet).substring(0, tmp);
			updatedIPAddress = tmp_ipv6Arr.slice(0, (prefix - tmp)/16);
			if(prefix > 64) {
				var reqByteIndex = 0;
				var remBits = 128 - prefix;
				reqByteIndex = Math.abs(3-parseInt((128 - prefix)/16));
				reqOctet = h2b(euiAddress[reqByteIndex]);
				reqBits += reqOctet.substring(reqOctet.length - remBits % 16);
				updatedIPAddress[(prefix - tmp)/16] = b2h(reqBits);
				updatedIPAddress = updatedIPAddress.concat(euiAddress.slice(reqByteIndex+1));
			}
			else {
				reqBits = (reqBits + "0000000000000000").substring(0, 16);
				updatedIPAddress = tmp_ipv6Arr.slice(0, (prefix - tmp)/16);
				updatedIPAddress[(prefix - tmp)/16] = b2h(reqBits);
				for(var i=((prefix - tmp)/16)+1; i<4; i++) {
					updatedIPAddress[i] = "0000";
				}
				updatedIPAddress = updatedIPAddress.concat(euiAddress);
			}
		}
		for(var i=0; i<updatedIPAddress.length; i++) {
			var elem = eval("form.text_ipv6Address" + i + elemSuffix);
			elem.value = updatedIPAddress[i];
			elem.actualValue = tmp_ipv6Arr[i];
		}
	}
	else {
		if(elemSuffix != null && eval("form.text_ipv6Address0" + elemSuffix).actualValue == null) {//**is this part needed?
			var tmp_ipv6Address = eval("form.text_ipv6Address0" + elemSuffix).value + ":" + eval("form.text_ipv6Address1" + elemSuffix).value + ":" + eval("form.text_ipv6Address2" + elemSuffix).value + ":" + eval("form.text_ipv6Address3" + elemSuffix).value + ":" + eval("form.text_ipv6Address4" + elemSuffix).value + ":" + eval("form.text_ipv6Address5" + elemSuffix).value + ":" + eval("form.text_ipv6Address6" + elemSuffix).value + ":" + eval("form.text_ipv6Address7" + elemSuffix).value;
			var tmp_ipv6Arr = tmp_ipv6Address.split(":");
			var updatedIPAddress = new Array();
			var prefix = eval("form.list_prefix" + elemSuffix).value;
			
			for(var i=0; i<tmp_ipv6Arr.length;i++) {
				tmp_ipv6Arr[i] = ("0000" + tmp_ipv6Arr[i]).substring(("0000" + tmp_ipv6Arr[i]).length - 4);
			}
			var tmp = prefix % 16;
			var zeroArray = new Array("0000", "0000", "0000", "0000", "0000", "0000", "0000", "0000");
			if(tmp == 0) {
				updatedIPAddress = tmp_ipv6Arr.slice(0, prefix/16);
				//if(prefix != 128) {
					updatedIPAddress = updatedIPAddress.concat(zeroArray.slice(0, (128-prefix)/16));
				//}
				//alert(updatedIPAddress)
			}
			else {
				var lastOctet = tmp_ipv6Arr[(prefix - tmp)/16];
				var reqBits = h2b(lastOctet).substring(0, tmp);
				updatedIPAddress = tmp_ipv6Arr.slice(0, (prefix - tmp)/16);
				reqBits = (reqBits + "0000000000000000").substring(0, 16);
				updatedIPAddress[(prefix - tmp)/16] = b2h(reqBits);
				for(var i=((prefix - tmp)/16)+1; i<8; i++) {
					updatedIPAddress[i] = "0000";
				}
			}
			for(var i=0; i<8; i++) {
				var elem = eval("form.text_ipv6Address" + i + elemSuffix);
				elem.value = updatedIPAddress[i];
			}
		}
		else {
			for(var i=0; i<8; i++) {
				var elem = eval("form.text_ipv6Address" + i + elemSuffix);
				elem.value = elem.actualValue;
			}
		}
	}
}

/*
 * number conversion functions
 */
function h2d(h) {
	return parseInt(h,16);
}

function d2h(d) {
	var hD="0123456789ABCDEF";
	var h = hD.substr(d&15,1);
	while(d>15) {
		d>>=4;
		h=hD.substr(d&15,1)+h;
	}
	return h;
}

function d2b(num) {
	var bit8=0, bit7=0, bit6=0, bit5=0, bit4=0, bit3=0, bit2=0, bit1=0;
	if (num > 255) { return ("err!") }
	if (num & 128) { bit8 = 1 }
	if (num & 64) { bit7 = 1 }
	if (num & 32) { bit6 = 1 }
	if (num & 16) { bit5 = 1 }
	if (num & 8) { bit4 = 1 }
	if (num & 4) { bit3 = 1 }
	if (num & 2) { bit2 = 1 }
	if (num & 1) { bit1 = 1 }
	//return (""+bit8+bit7+bit6+bit5+bit4+bit3+bit2+bit1);
	return ("" + bit4 + bit3 + bit2 + bit1);
}

function b2d(num) {
	num = "" + num;
	var decimal = 0;
	while (num.length < 8) {
		num = "0" + num;
	}
	if (num.substring(7,8) == "1") { decimal++ }
	if (num.substring(6,7) == "1") { decimal += 2 }
	if (num.substring(5,6) == "1") { decimal += 4 }
	if (num.substring(4,5) == "1") { decimal += 8 }
	if (num.substring(3,4) == "1") { decimal += 16 }
	if (num.substring(2,3) == "1") { decimal += 32 }
	if (num.substring(1,2) == "1") { decimal += 64 }
	if (num.substring(0,1) == "1") { decimal += 128 }
	return(decimal);
}

function b2h(num) {
	if(num == "") return "";
	var bTmp = (num + "0000000000000000").substring(0, 16).split("");
	var hTmp1 = "";
	var hTmp = "";
	for(var i=0; i<bTmp.length; i++) {
		hTmp1 += bTmp[i];
		if(hTmp1.length == 4) {
			hTmp += d2h(b2d(hTmp1));
			hTmp1 = "";
		}
	}
	return hTmp;
}

function h2b(num) {
	if(num == "") return "";
	var arr = num.split("");
	var binNum = "";
	for(var i=0; i<arr.length; i++) {
		switch(arr[i]) {
			case "0":
				binNum += "0000";
				break;
			case "1":
				binNum += "0001";
				break;
			case "2":
				binNum += "0010";
				break;
			case "3":
				binNum += "0011";
				break;
			case "4":
				binNum += "0100";
				break;
			case "5":
				binNum += "0101";
				break;
			case "6":
				binNum += "0110";
				break;
			case "7":
				binNum += "0111";
				break;
			case "8":
				binNum += "1000";
				break;
			case "9":
				binNum += "1001";
				break;
			case "A":
				binNum += "1010";
				break;
			case "B":
				binNum += "1011";
				break;
			case "C":
				binNum += "1100";
				break;
			case "D":
				binNum += "1101";
				break;
			case "E":
				binNum += "1110";
				break;
			case "F":
				binNum += "1111";
				break;
		}
	}
	return binNum;
}
