#! /pkg/bin/perl -w

#sub parse_vrf;
sub parse_rcc;
sub parse_lcc;
#sub parse_unresolved;
#sub parse_incomplete;

#parse arguments to see if vrf is specified
$num_args = $#ARGV +1;
if ($num_args == 1) {
    $vrf = $ARGV[0];
}

#getting all the vrf names from 'show vrf all detail'
#my @vrf_names;
#my $vrf = `mpls_vpn_show -a -d`;
#parse_vrf($vrf);

# parser for show vrf all detail. It populated global vrf_names
#sub parse_vrf ($)
#{
#    my $data = shift;
#    if (!$data) {
#        print "No VRFs are configured\n";
#        return;
#    }
#    my @lines = split(/\n/, $data);
#    foreach my $line (@lines) {

#        if ($line =~ m/^VRF (.*); RD/) {
#            push(@vrf_names, $1);
#        }
#    }
#}
#running 'show rcc ipv4 unicast all' on default vrf
print "----------------------------------\n";
print "Running RCC Check on VRF: $vrf\n";
print "----------------------------------\n";
my $rcc = `show_rt_check -c 0x2 -t ipv4-unicast -p 0x0 -m 0x0 -k $vrf -A 0x0`;
parse_rcc($rcc);

#running rcc checker on each of the vrfs found
#foreach $vrf (@vrf_names)
#{
#    my $rcc = `show_rt_check -c 0x2 -t ipv4-unicast -p 0x0 -m 0x0 -k $vrf -A 0x0`;
#    print "Running RCC Checker on VRF $vrf\n\n";
#    parse_rcc($rcc);
#}

# get 'show lcc ipv4 unicast all' output
# then parse out the inconsistent information
print "--------------------------------\n";
print "-----Running LCC Check--------\n";
print "--------------------------------\n";
my $lcc = `show_rt_check -c 0x2 -t mplsv4-unicast -p 0x0 -m 0x0 -k 0x0 -A 0x0`;
parse_lcc($lcc);

# get 'show cef unresolved' output without specifying vrfs
# then parse out the prefixes 
#my $unresolved = `fib_show_command -t -O 0x0 -u -N 0 `;
my $unresolved = `fib_show_command -t -O 0x0 -u`;
parse_unresolved($unresolved);

#checking each vrf for unresolved
#foreach $vrf (@vrf_names)
#{
#    my $unresolved = `fib_show_command -t -O 0x0 -f $vrf -u`;
#    print "Checking for Unresolved Prefix on VRF $vrf\n\n";
#    parse_unresolved($unresolved);
#}

# get 'show cef adjacency' output
# then parse out the prefixes and interfaces
#my $incomplete = `fib_show_command -Z -O 0x0 -9 0x0`;
#parse_incomplete($incomplete);

#parser for rcc checker
sub parse_rcc($)
{
    my $data = shift;
    if (!$data) {
        print "Warning: No RCC data to process\n";
        return;
    }
    print $data,
}

#parse for lcc checker
sub parse_lcc ($)
{
    my $data = shift;
    if (!$data) {
        print "Warning: no LCC data to process\n";
        return;
    }
    print $data,
}

#parser for show cef unresolved
sub parse_unresolved ($)
{
    my $data = shift;
    if (!$data) {
        print "\nNo CEF unresolved data found.\n";
        return;
    }
    my @lines = split(/\n/, $data);
    foreach my $line (@lines) {
       if ($line =~ m/\?/) {
          my @parts = split(/\s+/, $line);
          print "This prefix is unresolved: $parts[1]\n";
       } 
    }
}

#parser for show cef adjacency
sub parse_incomplete ($)
{
    my $data = shift;
    if (!$data) {
        print "No CEF adjacency data found\n";
        return;
    }

    my @lines = split(/\n/, $data);
    my $count = 0;
    foreach my $line (@lines) {
       if ($line =~ m/incomplete/) {
           $prefix_line = $count - 5;
           print $lines[$prefix_line], "\n";
       }
       $count++;
    }
}
