import binascii
import socket
import datetime
import os
import argparse
import logging
import math
import sys
import re
from collections import OrderedDict


class Parser:
    node_id=''
    dpalis=[]
    fiblis=[]
    fib_mgr_id=[]
    fib_trans_id=[]
    dpa_trans_id=[]
    l_dict={}
    list_of_dict=[]
    fib_leaf=[]
    label=''
    check=''
    node_affected=''

    def __init__(self,trans_id):
       self.trans_id=trans_id

    #Function to get time 
    def gettime(self,end_time, start_time):
        years = divmod((end_time-start_time).total_seconds(), 31536000)
        days = divmod(years[1], 86400)
        hours = divmod(days[1], 3600)
        minutes = divmod(hours[1], 60)
        seconds = minutes[1]
        print ("\n\nTime taken hours : {}, minutes : {}, seconds : {}".format(hours[0], minutes[0], seconds))

    #Function to save the logs
    def showlogging(self):
        cmd1="show_logging > /misc/disk1/TraceD/show_logging.txt"
        os.system(cmd1)
        logger.info("Logs are saved in show_logging.txt")


    #Function to find dpa_trans_id of corresponding node from log file
    def find_dpa_trans_id(self,node_id,flag):
        if flag==1:
            file1 = open('/misc/disk1/TraceD/show_logging.txt','r')
            file2 = open("/misc/disk1/TraceD/alllogs.txt", "w")
        else:
            file1 = open(args.log_file,'r')
            file2 = open('alllogs.txt','w')

        s="Not found"
        temp_list=[]
        file2.write("HW error\n")
        if node_id:
            logger.info("Transaction id entered")
            with file1 as f:
                with file2 as f2:
                    for lines in f:
                        if "HW" in lines:
                            Parser.dpalis.append(lines)
                            if ",dpa_trans_id,"+str(node_id)+',' in lines:
                                f2.write(lines)
                                s="Found"
                                temp_list.append(lines)
                                break

            if s=='Not found':
                return s
            
            if len(temp_list)!=0:
                regex = r'(.*),dpa_trans_id,(\d*),'
                Parser.dpa_trans_id= re.search(regex,temp_list[0])
                if Parser.dpa_trans_id:
                    logger.info("Dpa_trans_id : {} ".format(Parser.dpa_trans_id.group(2)))
                    print("Dpa_trans_id : {} ".format(Parser.dpa_trans_id.group(2)))
            else:
                return s

        else:
            
            logger.info("Transaction id not entered")
            logger.info("Taking dpa_trans_id from first Hw error")
            with file1 as f:
                with file2 as f2:
                    for lines in f:
                        if "HW" in lines:
                            Parser.dpalis.append(lines)
                            f2.write(lines)
           
            if(len(Parser.dpalis)!=0):
                regex = r'(.*),dpa_trans_id,(\d*),'
                for i in range(len(Parser.dpalis)):
                    Parser.dpa_trans_id= re.search(regex, Parser.dpalis[i])
                    if Parser.dpa_trans_id:
                        print("Dpa_trans_id : {} ".format(Parser.dpa_trans_id.group(2)))
                        logger.info("Dpa_trans_id : {} ".format(Parser.dpa_trans_id.group(2)))
                        s='Found'
                        break
            else:
                s="no hw error"
                logger.error("No HW error")

        return s

    #Funtion to find node afftected corresponding to trans_id
    def find_node_affected(self):
        for i in range(len(Parser.dpalis)):
            if "RP/0/RP0/CPU0" in Parser.dpalis[i]:
                node_affected= "node0_RP0_CPU0"
                break
            elif "RP/0/RP1/CPU0" in Parser.dpalis[i]:
                node_affected="node0_RP1_CPU0"
                break
            elif "LC/0/0/CPU0" in Parser.dpalis[i]:
                node_affected="node0_0_CPU0"
                break
            else:
                node_affected="NULL"
        print("Node Affected : {} ".format(node_affected))
        logger.info("Node Affected : {}".format(node_affected))
    
    #Function to find the line card number
    def find_lc(self):
        temp_lis=[]
        cmd="cmp_dbg -i inv | grep 'node' > /misc/disk1/TraceD/findlc.txt"
        os.system(cmd)
        file=open('/misc/disk1/TraceD/findlc.txt','r')
        with file as f:
            for line in f:
                temp_lis.append(line)

        reg=r'(.*)0x(.\w*)'
        for i in range(len(temp_lis)):
            if Parser.node_affected in temp_lis[i]:
                l=re.search(reg,temp_lis[i-1])
                if l:
                    Parser.node_id = int(l.group(2),16)

        return Parser.node_id/256
    
    #Function to save ofa traces    
    def find_ofa_trace(self,flag):
        temp_lis=[]
        if flag==1:
            cmd="/pkg/bin/ofa_show_ltrace > /misc/disk1/TraceD/ofa_trace.txt"
            os.system(cmd)
            file1=open('/misc/disk1/TraceD/ofa_trace.txt','r')
            file2=open('/misc/disk1/TraceD/alllogs.txt','a')

    #Function to find fib_mgr_id
    def find_fib_mgr_id(self,flag):
        starttime=datetime.datetime.now()
        if flag==1:
            cmd4="/pkg/bin/show_fib_hal_ltrace -i %s > %s"%(Parser.node_id,"/misc/disk1/TraceD/cef_plat.txt")
            os.system(cmd4)
            file1=open('/misc/disk1/TraceD/cef_plat.txt','r')
            file2=open('/misc/disk1/TraceD/alllogs.txt','a')
        else:
            file1=open(args.cef_file,'r')
            file2=open('alllogs.txt','a')
        
        s=''
        file2.write("Fib_mgr logs\n")
        with file1 as f:
            with file2 as f2:
                for lines in f:
                    if "dpa_trans_id,"+Parser.dpa_trans_id.group(2)+',' in lines:
                        Parser.fiblis.append(lines)
                        f2.write(lines)


        if Parser.fiblis:
            regex = r'(.*),trans_id,(\d*),(.*)'
            Parser.fib_trans_id= re.search(regex,Parser.fiblis[0])
            if Parser.fib_trans_id:
                s='found'
                print("Fib_mgr_id : {} ".format(Parser.fib_trans_id.group(2)))
                logging.info("Fib_mgr_id :{} ".format(Parser.fib_trans_id.group(2)))
            else:
                s='not found'
        else:
            s='not found'
        endtime=datetime.datetime.now()
        #self.gettime(endtime,starttime)
        return s

    #Function to construct and print chain
    def construct(self,flag):
        Parser.list_of_dict=[]
        temp_dict={}
        temp_dict=self.find_and_append(Parser.fib_trans_id.group(2),flag)
        Parser.list_of_dict.append(temp_dict)
        parent_id=self.find_parent_id(temp_dict)
        child_id=self.find_child_id(Parser.fib_trans_id.group(2),flag)
        logging.info("Parent id found :{}".format(parent_id))
        logging.info("BUILDING PARENT CHAIN")
        while(parent_id):
            if(parent_id=='No Parent'):
                logging.info("No parent found")
                break
            if(parent_id=='not found'):
                logging.info("TRACES WRAPPED")
                break
            temp_dict=self.find_and_append(parent_id,flag)
            res=not temp_dict
            if(str(res)=='True'):
                logging.info("No parent found.")
                break   
            else:
                Parser.list_of_dict.append(temp_dict)
                parent_id=self.find_parent_id(temp_dict)
                logging.info("Parent id found : {}".format(parent_id))
        logging.info("BUILDING CHILD CHAIN")
        while(child_id):
            if(child_id=='No child'):
                logging.info("No child found")
                break
            if(child_id=='wrap'):
                logging.info("TRACES WRAPPED")
                break
            temp_dict=self.find_and_append(child_id,flag)
            res=not temp_dict
            if(str(res)=='True'):
                logging.info("No child found.")
                break
            else:
                Parser.list_of_dict.insert(0,temp_dict)
                child_id=self.find_child_id(child_id,flag)
        

        print("\n")
        for i in range (len(Parser.list_of_dict)):
            if(Parser.list_of_dict[i]['object_type']=="LEAF"):
                print("-------------LEAF---------------")
                print("ENGINE :")
                for j in Parser.list_of_dict[i]:
                    if j=='OFA1':
                        print("-------------------------------")
                        print("OFA1:")
                        for k in Parser.list_of_dict[i][j]:
                            print("     {:<10}: {:<25}".format(k,Parser.list_of_dict[i][j][k]))
                    elif j=='OFA2':
                        print("OFA2:")
                        for k in Parser.list_of_dict[i][j]:
                            print("     {:<10}: {:<25}".format(k,Parser.list_of_dict[i][j][k]))
                    else:
                        print("     {:<10}: {:<15}".format(j,Parser.list_of_dict[i][j]))
                print("-------------------------------")
    
            if(Parser.list_of_dict[i]['object_type']=="LWLDI"):
                print("\n")
                print("--------------LWLDI---------------------")
                print("ENGINE :")
                for j in Parser.list_of_dict[i]:
                    if j=='OFA1':
                        print("-----------------------------------------")
                        print("OFA1:")
                        for k in Parser.list_of_dict[i][j]:
                            print("     {:<10}: {:<25}".format(k,Parser.list_of_dict[i][j][k]))
                    elif j=='OFA2':
                        print("OFA2:")
                        for k in Parser.list_of_dict[i][j]:
                            print("     {:<10}: {:<25}".format(k,Parser.list_of_dict[i][j][k]))
                    else:
                        print("     {:<10}: {:<15}".format(j,Parser.list_of_dict[i][j]))
                print("-----------------------------------------")

            if(Parser.list_of_dict[i]['object_type']=="SHLDI"):
                print("\n")
                print("---------------SHLDI--------------------")
                print("ENGINE :")
                for j in Parser.list_of_dict[i]:
                    if j=='OFA1':
                        print("-----------------------------------------")
                        print("OFA1:")
                        for k in Parser.list_of_dict[i][j]:
                            print("     {:<10}: {:<25}".format(k,Parser.list_of_dict[i][j][k]))
                    elif j=='OFA2':
                        print("OFA2:")
                        for k in Parser.list_of_dict[i][j]:
                            print("     {:<10}: {:<25}".format(k,Parser.list_of_dict[i][j][k]))
                    else:
                        print("     {:<10}: {:<15}".format(j,Parser.list_of_dict[i][j]))
                print("-----------------------------------------")
 
            if(Parser.list_of_dict[i]['object_type']=="RSHLDI"):
                print("\n")
                print("-------------RSHLDI--------------------")
                print("ENGINE :")
                for j in Parser.list_of_dict[i]:
                    if j=='OFA1':
                        print("------------------------------------------")
                        print("OFA1:")
                        for k in Parser.list_of_dict[i][j]:
                            print("     {:<10}: {:<25}".format(k,Parser.list_of_dict[i][j][k]))
                    elif j=='OFA2':
                        print("OFA2:")
                        for k in Parser.list_of_dict[i][j]:
                            print("     {:<10}: {:<25}".format(k,Parser.list_of_dict[i][j][k]))
                    else:
                        print("     {:<10}: {:<15}".format(j,Parser.list_of_dict[i][j]))
                print("------------------------------------------")
 
            if(Parser.list_of_dict[i]['object_type']=="NH"):
                print("\n")
                print("---------------NH-----------------------")
                print("ENGINE :")
                for j in Parser.list_of_dict[i]:
                    if j=='OFA1':
                        print("-----------------------------------------")
                        print("OFA1:")
                        for k in Parser.list_of_dict[i][j]:
                            print("     {:<10}: {:<25}".format(k,Parser.list_of_dict[i][j][k]))
                    elif j=='OFA2':
                        print("OFA2:")
                        for k in Parser.list_of_dict[i][j]:
                            print("     {:<10}: {:<25}".format(k,Parser.list_of_dict[i][j][k]))
                    else:
                        print("     {:<10}: {:<15}".format(j,Parser.list_of_dict[i][j]))
                print("-----------------------------------------")
            print("\n")

    #Function to find vrf
    def find_vrf(self):
        if 'Vrf_id' in Parser.list_of_dict[0]:
            vrf_id=Parser.list_of_dict[0]['Vrf_id']
            temp_list=[]
            file=open('/misc/disk1/TraceD/vrf.txt','r')
            with file as f:
                for lines in f:
                    if "VRF_ID="+vrf_id in lines:
                        temp_list.append(lines)
            
            if(len(temp_list)!=0):
                regex=r'(.*)VRF=(\w*)'
                l=re.search(regex,temp_list[0])
                if(l):
                    vrf_id=l.group(2)
                else:
                    return 'No vrf'

            return vrf_id
        else:
            logger.info("VRF NOT FETCHED")
    
    #Function to check Hw error type
    def check_error(self):
        if "mplslabel" in Parser.dpalis[0]:
            check="label"
        elif "mplsnh" in Parser.dpalis[0]:
            check="label"
        else:
            check="prefix"
		
    	return check
    
    #Function to find label
    def find_label(self):
        if 'label' in Parser.list_of_dict[0]:
            label=Parser.list_of_dict[0]['label']       
            return label
        else:
            logger.info("Label not found")
    
    #Function to find prefix
    def find_prefix(self):
        temp_list=[]
        if 'Prefix' in Parser.list_of_dict[0]:
            p1=Parser.list_of_dict[0]['Prefix']
            p2=Parser.list_of_dict[0]['Mask']
            prefix=p1+'/'+p2
            return prefix
        else:
            logger.info("Prefix not found")


    #Function to call corresponding extract function 
    def find_and_append(self,trans_id,flag):
        if flag==1:
            file = open('/misc/disk1/TraceD/cef_plat.txt','r')
            file2 = open('/misc/disk1/TraceD/alllogs.txt','a')
            file3 = open('/misc/disk1/TraceD/ofa_trace.txt','r')
            file2.write("CHAIN DATA")
            file2.write("\n")
        else:
            file = open(args.cef_file,'r')
            file3 = open(args.ofa_file,'r')
            file2=open('alllogs.txt','a')
            file2.write("CHAIN DATA\n")
        temp_list=[]
        temp2_list=[]
        ofa_traces_list=[]
        ofa_traces_list_2=[]
        temp_dict={}
        dpa_trans_id=[]
        with file as f:
            with file2 as f2:
                for lines in f:
                    if ",trans_id,"+trans_id+',' in lines:
                        temp_list.append(lines)
                        f2.write(lines)
	
	
        reg=r'(.*),dpa_trans_id,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                dpa_trans_id.append(l.group(2))
        
        if flag==1:	
            file2=open('/misc/disk1/TraceD/alllogs.txt','a')
        else :
            file2=open('alllogs.txt','a')
        
        file2.write("OFA_TRACES\n")
        if len(dpa_trans_id)!=0: 
            with file3 as f:
                with file2 as f2:
                    for lines in f:
                        if ",trans_id,"+dpa_trans_id[0]+"," in lines:
                            ofa_traces_list.append(lines)
                            f2.write(lines)
                        if len(dpa_trans_id)==2:
                            if ",trans_id,"+dpa_trans_id[1]+"," in lines:
                                ofa_traces_list_2.append(lines)
                      	        f2.write(lines)
        if(len(temp_list)!=0):
            for i in range(len(temp_list)):
                if(",leaf_" in temp_list[i]):
                    logging.info("Extracting leaf data")
                    temp_dict=self.extract_leaf(temp_list,ofa_traces_list,ofa_traces_list_2)
                    return temp_dict
                
                elif(",lwldi_" in temp_list[i]):
                    logging.info("Extracting LWLDI data")
                    temp_dict=self.extract_lwldi(temp_list,ofa_traces_list,ofa_traces_list_2)
                    return temp_dict
                
                elif(",shldi_" in temp_list[i]):
                    logging.info("Extracting SHLDI data")
                    temp_dict=self.extract_shldi(temp_list,ofa_traces_list,ofa_traces_list_2)
                    return temp_dict
                
                elif(",tx_nh2_" in temp_list[i]):
                    logging.info("Extracting NH data")
                    temp_dict=self.extract_nh(temp_list,ofa_traces_list,ofa_traces_list_2)
                    return temp_dict
                
                elif(",rshldi_" in temp_list[i]):
                    logging.info("Extracting RSHLDI data")
                    temp_dict=self.extract_rshldi(temp_list,ofa_traces_list,ofa_traces_list_2)
                    return temp_dict
        else:
            logging.error("NO logs found")
            return temp_dict

    #Function to find parent
    def find_parent_id(self,dict):
        res=not dict

        if(str(res)=='True'):
            return 'No Parent'

        return dict['Parent_trans_id']

    #Function to find child
    def find_child_id(self,trans_id,flag):
        parent_trans_list=[]
        trans_list=[]
        if flag==1:
            file=open('/misc/disk1/TraceD/cef_plat.txt','r')
        else:
            file=open(args.cef_file,'r')
        
        with file as f:
            for lines in f:
                if ",parent_trans_id,"+trans_id+',' in lines:
                    parent_trans_list.append(lines)
                if ",trans_id,"+trans_id+',' in lines:
                    trans_list.append(lines)
 
        if(len(parent_trans_list)!=0):
            if(",leaf_" in trans_list[0]):
                return 'No child'
            reg=r'(.*),trans_id,(\d*)'
            l=re.search(reg,parent_trans_list[0])
            if l:
                logging.info("child id found :{}".format(l.group(2)))
                return l.group(2)
        else:
            if(len(trans_list)!=0):
                if(",leaf_" in trans_list[0]):
                    return 'No child'
                else:
                    return 'wrap'

    #Funtion to extract leaf object data
    def extract_leaf(self,temp_list,ofa_list,ofa_list_2):

        l_dict=OrderedDict()
        l_dict['object_type']='LEAF'

        reg=r'(.*),trans_id,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['trans_id']=l.group(2)
                break

        reg=r'(.*),parent_trans_id,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['Parent_trans_id']=l.group(2)
                break
            else:
                l_dict['Parent_trans_id']='not found'

    	reg=r'(.*),in_lbl,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['label']=l.group(2)
                break

        reg=r'(.*),prefix,(.\d{1,3}.\d{1,3}.\d{1,3}.\d{1,3})'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['Prefix']=l.group(2)
                break
        
        reg=r'(.*),prefix,(.\w{1,4}:\w{1,4}:\w{1,4}:\w{1,4}:\w{1,4}:\w{1,4}:\w{1,4}:\w{1,4})'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['Prefix']=l.group(2)
                break


        reg=r'(.*),mask,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                    l_dict['Mask']=l.group(2)
                    break

        reg=r'(.*),type,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                    l_dict['type']=l.group(2)
                    break

        reg=r'(.*),afi_proto,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                    l_dict['afi_proto']=l.group(2)
                    break


        reg=r'(.*),vrf_id,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                    l_dict['Vrf_id']=l.group(2)
                    break

        reg=r'(.*),is_ldi_via_tbl,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                    l_dict['is_ldi_via_table']=l.group(2)
                    break

        reg=r'(.*),leaf_pd_ctx,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['leaf_pd_ctx']=l.group(2)
                break

        reg=r'(.*),hal_flags,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['hal_flags']=l.group(2)
                break

        if(len(ofa_list)!=0):
            self.extract_ofa_leaf(ofa_list,l_dict,1)
        if(len(ofa_list_2)!=0):
            self.extract_ofa_leaf(ofa_list_2,l_dict,2)

        return l_dict


    def extract_ofa_leaf(self,ofa_list,p_dict,check):

        l_dict=OrderedDict()
        
        if check==1:
            p_dict['OFA1']=l_dict
        if check==2:
            p_dict['OFA2']=l_dict
        
        reg=r'(.*),obj,(\w*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['obj']=l.group(2)
                break

        reg=r'(.*)client_(\w*)_create'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['obj_type']=l.group(2)
                break
        
        reg=r'(.*),trans_id,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['trans_id']=l.group(2)
                break
      
 
        reg=r'(.*),table_op,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['table_op']=l.group(2)
                break
        
        reg=r'(.*),is_high_scale_card,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['is_high_scale_card']=l.group(2)
                break
        
        reg=r'(.*),l3a_intf_id,(\w*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['l3a_intf_id']=l.group(2)
                break
        
        reg=r'(.*)push_label,(.\d*),'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['push_label']=l.group(2)
                break
        
        reg=r'(.*)npu_bmap,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['npu_bmap']=l.group(2)
                break
        
        reg=r'(.*),is_set_npu_bmap,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['is_set_npu_bmap']=l.group(2)
                break
        
        reg=r'(.*),rc,(\w*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['rc']=l.group(2)
                break
        

    
    def extract_lwldi(self,temp_list,ofa_list,ofa_list_2):
        
        l_dict=OrderedDict()
        l_dict['object_type']='LWLDI'

        reg=r'(.*),trans_id,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['trans_id']=l.group(2)
                break
        
        reg=r'(.*),parent_trans_id,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['Parent_trans_id']=l.group(2)
                break
            else:
                l_dict['Parent_trans_id']='not found'


        reg=r'(.*),parent_type,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['Parent_type']=l.group(2)
                break

        reg=r'(.*),parent_proto,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['Parent_proto']=l.group(2)
                break
	reg=r'(.*),in_lbl,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['label']=l.group(2)
                break
        reg=r'(.*),afi_proto,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['afi_proto']=l.group(2)
                break


        reg=r'(.*),ldi_type,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['ldi_type']=l.group(2)
                break


        reg=r'(.*),is_li_in_ctx,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
               l_dict['is_li_in_ctx']=l.group(2)
               break


        reg=r'(.*),feature,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['feature']=l.group(2)
                break

        if(len(ofa_list)!=0):
	        self.extract_ofa_lw_sh_rshldi(ofa_list,l_dict,1)
        if(len(ofa_list_2)!=0):
	        self.extract_ofa_lw_sh_rshldi(ofa_list_2,l_dict,2)

        return l_dict
        


    #def extract_collldi(self,temp_list,ofa_list):

    #def extract_phldi(self,temp_list,ofa_list):

    #def extract_ecdldi(self,temp_list,ofa_list):


    def extract_shldi(self,temp_list,ofa_list,ofa_list_2):
           
        l_dict=OrderedDict()
        l_dict['object_type']='SHLDI'

        reg=r'(.*),trans_id,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['trans_id']=l.group(2)
                break
            
        reg=r'(.*),parent_trans_id,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['Parent_trans_id']=l.group(2)
                break
            else:
                l_dict['Parent_trans_id']='not found'

        reg=r'(.*),parent_type,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['Parent_type']=l.group(2)
                break

        reg=r'(.*),nh_type,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['nh_type']=l.group(2)
                break

        reg=r'(.*),tx_ifh,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['tx_ifh']=l.group(2)
                break

        reg=r'(.*),proto,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['proto']=l.group(2)
                break

        reg=r'(.*),shldi_pd_ctx,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['shldi_pd_ctx']=l.group(2)
                break

        reg=r'(.*),nh_type,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['nh_type']=l.group(2)
                break

        reg=r'(.*),npu_mask,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['npu_mask']=l.group(2)
                break

        
        if(len(ofa_list)!=0):
            self.extract_ofa_lw_sh_rshldi(ofa_list,l_dict,1)
        if(len(ofa_list_2)!=0):
            self.extract_ofa_lw_sh_rshldi(ofa_list_2,l_dict,2)

        return l_dict


    
    def extract_rshldi(self,temp_list,ofa_list,ofa_list_2):
        
        l_dict=OrderedDict()
        l_dict['object_type']='RSHLDI'
        
        reg=r'(.*),trans_id,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['trans_id']=l.group(2)
                break

        reg=r'(.*),parent_trans_id,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['Parent_trans_id']=l.group(2)
                break  
            else:
                l_dict['Parent_trans_id']='not found'

        reg=r'(.*),parent_type,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['Parent_type']=l.group(2)
                break

        reg=r'(.*),parent_proto,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['Parent_proto']=l.group(2)
                break

        reg=r'(.*),parent_eng_ctx,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['Parent_eng_ctx']=l.group(2)
                break

        reg=r'(.*),export_type,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['export_type']=l.group(2)
                break

        if(len(ofa_list)!=0):
            self.extract_ofa_lw_sh_rshldi(ofa_list,l_dict,1)
        if(len(ofa_list_2)!=0):
            self.extract_ofa_lw_sh_rshldi(ofa_list_2,l_dict,2)

        return l_dict
        

    def extract_nh(self,temp_list,ofa_list,ofa_list_2):

        l_dict=OrderedDict()
        l_dict['object_type']='NH'
        
        reg=r'(.*),trans_id,(\d*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['trans_id']=l.group(2)
                break
        
        l_dict['Parent_trans_id']='No Parent'

        reg=r'(.*),hal_type,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['hal_type']=l.group(2)
                break


        reg=r'(.*),iftype,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['iftype']=l.group(2)
                break

        reg=r'(.*),ifh,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['ifh']=l.group(2)
                break

        reg=r'(.*),nh_pd_ctx,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['nh_pd_ctx']=l.group(2)
                break

        reg=r'(.*),hal_type,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['hal_type']=l.group(2)
                break

        reg=r'(.*),ifh,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['ifh']=l.group(2)
                break

        reg=r'(.*),if_type,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['if_type']=l.group(2)
                break

        reg=r'(.*),afi_proto,(\w*)'
        for i in range(len(temp_list)):
            l=re.search(reg,temp_list[i])
            if l:
                l_dict['afi_proto']=l.group(2)
                break
        
        if(len(ofa_list)!=0):
            self.extract_ofa_nh(ofa_list,l_dict,1)
        if(len(ofa_list_2)!=0):
            self.extract_ofa_nh(ofa_list_2,l_dict,2)


        return l_dict

    def extract_ofa_nh(self,ofa_list,p_dict,check):
        l_dict=OrderedDict()
        
        if check==1:
            p_dict['OFA1']=l_dict
        if check==2:
            p_dict['OFA2']=l_dict

        reg=r'(.*),obj,(\w*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['obj']=l.group(2)
                break

        reg=r'(.*)client_(\w*)_'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['obj_type']=l.group(2)
                break

        reg=r'(.*),trans_id,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['trans_id']=l.group(2)
                break

        reg=r'(.*),l3a_mac_addr,(.\w{2,4}.\w{2,4}.\w{2,4})'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['l3a_mac_addr']=l.group(2)
                break

        reg=r'(.*),l3a_intf_id,(.\w*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['l3a_intf_id']=l.group(2)
                break
        
        reg=r'(.*),npu_bmap,(.\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['npu_bmap']=l.group(2)
                break
        
        reg=r'(.*),is_set_npu_bmap,(.\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['is_set_npu_bmap']=l.group(2)
                break
        
        reg=r'(.*),encap_id,(.\w*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['encap_id']=l.group(2)
                break
        
        reg=r'(.*),is_modify,(.\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['is_modify']=l.group(2)
                break
        
        reg=r'(.*),vlan_gport,(.\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['vlan_gport']=l.group(2)
                break
        
        reg=r'(.*),out_intf,(.\w*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['out_intf']=l.group(2)
                break
        
        reg=r'(.*),npu_mask,(.\w*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['npu_mask']=l.group(2)
                break

        
        reg=r'(.*),rc,(\w*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['rc']=l.group(2)
                break
            else:
                l_dict['rc']='0x0'

    #Function to extract data from ofa traces for lwldi,shldi,rshldi
    def extract_ofa_lw_sh_rshldi(self,ofa_list,p_dict,check):
        
        l_dict=OrderedDict()

        if check==1:
            p_dict['OFA1']=l_dict
        if check==2:
            p_dict['OFA2']=l_dict

        reg=r'(.*),obj,(\w*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['obj']=l.group(2)
                break
        
        reg=r'(.*)client_(\w*)_'
        for i in range(len(ofa_list)): 
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['obj_type']=l.group(2)
                break
        
        reg=r'(.*),trans_id,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['trans_id']=l.group(2)
                break
        reg=r'(.*),npu_bmap,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['npu_bmap']=l.group(2)
                break
        
        reg=r'(.*),num_bkup_paths,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['num_bkup_paths']=l.group(2)
                break
        
        reg=r'(.*),prim_paths,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['prim_paths']=l.group(2)
                break
        
        reg=r'(.*),num_paths,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['num_paths']=l.group(2)
                break
        
        reg=r'(.*),ldi_modify,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['ldi_modify']=l.group(2)
                break
        
        reg=r'(.*),indirection_ecmp_fec,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['indirection_ecmp_fec']=l.group(2)
                break
        
        reg=r'(.*),is_oor,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['is_oor']=l.group(2)
                break
        
        reg=r'(.*),encap_id,(\w*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['encap_id']=l.group(2)
                break
        
        reg=r'(.*),fec_id,(\w*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['fec_id']=l.group(2)
                break

        reg=r'(.*),failoverid,(\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['failoverid']=l.group(2)
                break
        
        reg=r'(.*),dest,(\w*),'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['dest']=l.group(2)
                break
        
        reg=r'(.*),eei_mpls_push_label,(.\d)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['eei_mpls_push_label']=l.group(2)
                break
        
        reg=r'(.*),eei_mpls_swap_label,(.\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['eei_mpls_swap_label']=l.group(2)
                break
        
        reg=r'(.*),is_cascaded,(.\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['is_cascaded']=l.group(2)
                break
        
        reg=r'(.*),propagate_ttl,(.\d*)'
        for i in range(len(ofa_list)):
            l=re.search(reg,ofa_list[i])
            if l:
                l_dict['propagate_ttl']=l.group(2)
                break
    
    def cef_trace(self):
        cmd="/pkg/bin/show_fib_trace -i %s > %s"%(Parser.node_id,"/misc/disk1/TraceD/cef.txt")
        os.system(cmd)

    def l_trace(self):
        cmd="/pkg/bin/fia_show_ltrace -W -i %s > %s"%(Parser.node_id,"/misc/disk1/TraceD/l_trace.txt")
        os.system(cmd)
	
    def online_mode(self):
        flag=1
        dir=os.path.isdir("/misc/disk1/TraceD")
        if not dir:
            os.makedirs("/misc/disk1/TraceD")

        logging.basicConfig(filename="//misc//disk1//TraceD//debug.txt",level=log_level,format=log_format,filemode='w')
        logger=logging.getLogger()
        self.showlogging()
        s=self.find_dpa_trans_id(args.trans_id,flag)
        vrf_id="default"
        if(s=="Found"):
            logger.info("Transaction id found")
            self.find_node_affected()
            lc=self.find_lc()
            self.cef_trace()
            self.l_trace()
            self.find_ofa_trace(flag)
            f=self.find_fib_mgr_id(flag)
            if(f=="found"):
                logger.info("Fib_mgr_id found")
                logger.info("Running chain")
                self.construct(flag)
                check=self.check_error()
                cmd8="show_rsi_agent -c 0x17 > /misc/disk1/TraceD/vrf.txt"
                os.system(cmd8)
                vrf_id=self.find_vrf()
                if(check=='prefix'):
                    prefix=self.find_prefix()
                    logger.info("PREFIX : {}".format(prefix))
                    logger.info("VRF_ID : {}".format(vrf_id))
                    logger.info("LINE CARD NO. : {}".format(lc))
                    logger.info("Running cef_parser.py")
                    cmd7= "python cef_parser.py -p %s -v %s -l %d" %(prefix,vrf_id,lc)
                    os.system(cmd7)
                    end_time=datetime.datetime.now()
                    obj1.gettime(end_time,start_time)
                elif(check =='label'):
                    label=self.find_label()
                    logger.info("LABEL : {}".format(label))
                    logger.info("VRF_ID : {}".format(vrf_id))
                    logger.info("LINE CARD NO. : {}".format(lc))
                    logger.info("Running cef_parser.py")
                    cmd7= "python cef_parser.py -ll %s -v %s -l %d" %(label,vrf_id,lc)
                    os.system(cmd7)
                    end_time=datetime.datetime.now()
                    obj1.gettime(end_time,start_time)
            else:
                logger.info("Fib_mgr_id not found")
        elif(s=="Not found"):
            logger.error("TRANSACTION ID NOT FOUND")
        else:
            logger.error("NO HW ERROR FOUND")

        print("All files collected  are present in /misc/disk1/TraceD/")
    
    def offline_mode(self):
        flag=0;
        logging.basicConfig(filename="debug.txt",level=log_level,format=log_format,filemode='w')
        logger=logging.getLogger()
        s=self.find_dpa_trans_id(args.trans_id,flag)
        if(s=="Found"):
            logger.info("TRANSACTION ID FOUND")
            self.find_node_affected()
            self.find_ofa_trace(flag)
            f=obj1.find_fib_mgr_id(flag)
            if(f=="found"):
                logger.info("Fib_mgr_id found")
                logger.info("Running chain")
                obj1.construct(flag)
                end_time=datetime.datetime.now()
                obj1.gettime(end_time,start_time)
            else:
                print("Fib_mgr_id not found")
                logger.info("Fib_mgr_id not found")
        elif(s=="Not found"):
            print("TRANSACTION ID NOT FOUND")
            logger.error("TRANSACTION ID NOT FOUND")
        else:
            logger.error("NO HW ERROR FOUND")
  
if __name__ == "__main__":

    
    obj1=Parser(317)
    p=argparse.ArgumentParser()
    p.add_argument("-t","--trans_id",action="store",required=False,help="Transaction id")
    p.add_argument("-d", "--verbose", action="store_true", help="Enable Debug Mode")
    p.add_argument("-o", "--offline", action="store_true", help="Enable Offline Mode")
    p.add_argument("-c", "--cef_file", action="store", help="Name of cef plat file")
    p.add_argument("-f", "--ofa_file", action="store", help="Name of ofa trace file")
    p.add_argument("-l", "--log_file", action="store", help="Name of show logging file")

    log_format="%(levelname)s %(asctime)s - %(message)s"
    logger=logging.getLogger()
    args=p.parse_args()

    if args.verbose:
        log_level = logging.NOTSET
    else:
        log_level = logging.CRITICAL
    
    start_time=datetime.datetime.now()
    if not  args.offline:
        obj1.online_mode()
    else:
        if args.cef_file and args.ofa_file and args.log_file:
            obj1.offline_mode()
        else:
            print("offline mode: Give all 3 arguments -c -f -l")

