#!/bin/bash
#
# update_idprom_fixed_ru.sh: Script used to keep proto boards IDPROM updated
#
# Febuary 2017, Rahul Mathur
#
# Copyright (c) 2015-2017 by Cisco Systems, Inc.
# All rights reserved.
#

# Init variables 
IDPROM_UTIL=/opt/cisco/calvados/sbin/ncs5500_idprom_tool
CMGR_CLIENT=/opt/cisco/calvados/sbin/card_mgr_client
CARDINFO_FILE=/tmp/cardinfo_$$.txt
IDPROM_TOOL_FRETTA=/opt/cisco/calvados/sbin/ncs5500_idprom_tool

# Correction functions 
# Please note: All the updated function below have an Enter or
# CR. The purpose is to skip the fields in the idprom tool which
# are not to be changed. Only the PID is changing here
function fix_oc_cr_pid {
$PROG_CMD << EOF








NCS-55A1-36H-S














































y
EOF
}

function fix_oc_se_pid {
$PROG_CMD << EOF








NCS-55A1-36H-SE-S














































y
EOF
}

function fix_tortin_pid {
$PROG_CMD << EOF








N540-24Z8Q2C-M














































y
EOF
}

function fix_pyke_pid {
$PROG_CMD << EOF








NCS-55A1-24H














































y
EOF
}

# #####################################################
# Functions begin 
# #####################################################

# Clean up the temproary file 
function clean_up {

    rm -f $CARDINFO_FILE
}

# The Chassis IDPROM content has a secured and unsecured copy.
# We have to make sure we check and update both the copies 
# in the chassis IDPROM
function check_n_correct_idprom {

    local TGT_LOCATION=$1
    local TARGET=$2
    local INSTANCE

   echo -n "Reading $TGT_LOCATION $TARGET IDPROM ..."
   
    if [ "$TGT_LOCATION" == "chassis" ]; then
	INSTANCE="-i 1"
    else
        INSTANCE=" "
    fi
   
    if [ "$TARGET" == "protected" ]; then
        PROG_PID=`$IDPROM_TOOL_FRETTA -c show -t $TGT_LOCATION -a sec $INSTANCE | grep -a "Product ID" | awk '{print $4}'`
    else
        PROG_PID=`$IDPROM_TOOL_FRETTA -c show -t $TGT_LOCATION -a unsec $INSTANCE | grep -a "Product ID" | awk '{print $4}'`
    fi
    echo "[DONE]"
    
    if [ "$TARGET" == "protected" ]; then
        PROG_CMD="$IDPROM_TOOL_FRETTA -c program -t $TGT_LOCATION -a sec $INSTANCE"
    else
        PROG_CMD="$IDPROM_TOOL_FRETTA -c program -t $TGT_LOCATION -a unsec $INSTANCE "
    fi
   

    # # PID correction calling the right function 
    if [ "$PROG_PID" == "NCS-5501-A1" ]; then
	echo "Updating IDPROM PID from '$PROG_PID' to 'NCS-55A1-36H-S' ..."  
        fix_oc_cr_pid
    elif [ "$PROG_PID" == "NCS-5501-A1-SE" ]; then
	echo "Updating IDPROM PID from '$PROG_PID' to 'NCS-55A1-36H-SE-S' ..."  
        fix_oc_se_pid
    elif [ "$PROG_PID" == "NCS-5501-A3" ]; then
	echo "Updating IDPROM PID from '$PROG_PID' to 'NCS-55A1-24H' ..."  
        fix_pyke_pid
    elif [ "$PROG_PID" == "NCS-5501-HD" ]; then
    echo "Updating IDPROM PID from '$PROG_ID' to 'N540-24Z8Q2C-M' ..."
        fix_tortin_pid
    else
        echo " $TGT_LOCATION $TARGET IDPROM correction not needed for this platfrom..."
        clean_up
    fi

}


# ###############################################
# Main execution script 
# ###############################################
echo -n "Getting current card info ..."
# Get card info from card manager
$CMGR_CLIENT -n -c cardinfo > $CARDINFO_FILE
if [ $? -ne 0 ]; then
    echo ""
    echo "ERROR: Failed to get card info from card manager"
    exit 1
fi
echo "[DONE]"

# Get the valid PID from card info collected that will be used to compare with
# the PID programmed in the IDPROM
VALID_PID=`grep PID $CARDINFO_FILE | awk '{print $3}'`


# The chassis has 2 copies secured and unsecured copy of the IDPROM
# Main board or RP has only unsecured copy of the IDPROM
echo "Correcting UNSECURED CHASSIS IDPROM ================="
check_n_correct_idprom "chassis" "unprotected"
echo "Correcting SECURED CHASSIS IDPROM ================="
check_n_correct_idprom "chassis" "protected"
echo "Correcting UNSECURED RP IDPROM ================="
check_n_correct_idprom "mb" "unprotected"

echo "NOTE: IF there are updates triggered above please issue 'hw-module reload all' command "
