#!/bin/bash
#
# update_ir.sh: Script used upgrade IR FW to the latest
#
# november 2016, Rahul Mathur
#
# Copyright (c) 2015-2016 by Cisco Systems, Inc.
# All rights reserved.
#

FW_TOOL=/opt/cisco/calvados/sbin/ncs5500_fw_tool
ENV_MON_TOOL=/opt/cisco/calvados/bin/envmon_test_zermatt
function prog_ir_3564 {
$PROG_3564 << EOF
y 
EOF
}

function prog_ir_3570 {
$PROG_3570 << EOF
y 
EOF
}



PROG_3564="$FW_TOOL -c upgrade -t ir -l /opt/cisco/calvados/fpd/ucode/Zermat_ir3564_v2.cfg"

PROG_3570="$FW_TOOL -c upgrade -t ir -l /opt/cisco/calvados/fpd/ucode/Zermat_ir3570_v2.cfg"


# Invoke funtions
# Disable Sensor monitoring in envmon to avoid problems during upgrade
echo "Disabling Sensor monitoring ...."
$ENV_MON_TOOL  -c 0 1000 50
prog_ir_3564
prog_ir_3570

echo "Enabling Sensory monitoring..."

#dump All values for confirmation 
$FW_TOOL -c read -t ir
echo "=======Make sure all values are at V2 above ==========="