#!/bin/bash
#
# Copyright (c) 2019 by cisco Systems, Inc.
# All rights reserved.
#

function cleanup_start {
    touch /tmp/install_in_progress
    echo "Starting cleanup script" >> /tmp/cleanup_log.txt
    /etc/init.d/file_cleanup.py 2
    echo "Done with cleanup script" >> /tmp/cleanup_log.txt
}

function cleanup_stop {
    rm /tmp/install_in_progress
    echo "Hello I am stopping" >> /tmp/cleanup_log.txt
}

if [ "$1" == "upstart" ]; then
    if [ "$2" == "stop" ]; then
        cleanup_stop
    else
        cleanup_start
    fi
else
    echo
    echo
    echo "        This script can only be launched from upstart"
    echo "        Please do not call this script directly"
    echo "        Use "initctl stop calvados" to stop calvados"
    echo "        Use "initctl start calvados" to start calvados"
    echo
    echo
fi
