#!/bin/bash
#
# calvados/zermatt_pkg/boot/scripts/xrnginstall-zermatt-pd.sh
#
# This script has zermatt specific install functions
#
# Neil McGill (based on work by Alphesh Patel)
# 
# Copyright (c) 2014-2016, 2018-2019, 2021 by Cisco Systems, Inc.
# All rights reserved.
#

source /etc/rc.d/init.d/pd-functions

function xrnginstall_zermatt_patch_common {

    local rootdir="$1"
    local bootdir=${rootdir}/boot

    get_board_type
    ARCH=`arch`

    #platform_get_settings
    platform_log "$FUNCNAME"

    if [ -f ${rootdir}/lib/udev/rules.d/40-persistent-net-zermatt.rules ]; then
	mv -f ${rootdir}/lib/udev/rules.d/40-persistent-net-zermatt.rules \
            ${rootdir}/lib/udev/rules.d/40-persistent-net.rules
    fi

    if [ -f ${rootdir}/etc/modprobe.d/blacklist-zermatt.conf ]; then
	mv -f ${rootdir}/etc/modprobe.d/blacklist-zermatt.conf \
            ${rootdir}/etc/modprobe.d/blacklist.conf
    fi
}
function zermatt_host_cleanup () {
    local rootdir="$1"
    #remove noise
  if [ -f ${rootdir}/etc/rc3.d/S20dnsmasq ]; then
        rm ${rootdir}/etc/rc3.d/S20dnsmasq
    fi
    if [ -f ${rootdir}/opt/cisco/hostos/etc/sysconfig/modules/niantic.modules ]; then
        echo>${rootdir}/opt/cisco/hostos/etc/sysconfig/modules/niantic.modules
    fi
}

function zermatt_lxc_cleanup () {
    local rootdir="$1"
    #remove noise
    platform_log_console "Cleaning up LXC"
    if [ -f ${rootdir}/etc/rc3.d/S20tftpd-hpa ]; then
        rm ${rootdir}/etc/rc3.d/S20tftpd-hpa
    fi
    if [ -f ${rootdir}/etc/rc3.d/S20dnsmasq ]; then
        platform_log_console "deleting rm ${rootdir}/etc/rc3.d/S20dnsmasq"
        rm ${rootdir}/etc/rc3.d/S20dnsmasq
    fi
    if [ -f ${rootdir}/opt/cisco/hostos/etc/sysconfig/modules/niantic.modules ]; then
        echo>${rootdir}/opt/cisco/hostos/etc/sysconfig/modules/niantic.modules
    fi

}



function xrnginstall_zermatt_patch_hostos {

    local rootdir="$1"
    local plat="$2"
    local hostvol="$7"
    local grub_dir="$8"
    local first_giga_mac

    xrnginstall_zermatt_patch_common "$rootdir"

    # FRETTA_BRINGUP_HACK_rahmathu - CSCut92229 - abramach/hetsoi
    # Install libc6 32-bit RPM on the host for Fretta
    if [ "${ARCH}" == "x86_64" ]; then
        local libc6_rpm_file="${rootdir}/libc6-2.15+4.6a+136-r2.lib32_x86.rpm"
        if [ -f ${libc6_rpm_file} ]; then
            platform_log "Installing RPM ${libc6_rpm_file}"
            cd /
            STARTRPM=$(date +%s)
            chroot ${rootdir} rpm -i --nodeps `basename ${libc6_rpm_file}` >> /tmp/rpmlog 2>&1
            ENDRPM=$(date +%s)
            DIFFRPM=$(( $ENDRPM - $STARTRPM ))
            SIZERPM=$(ls -lh ${libc6_rpm_file}| awk '{ print $5 }')
            platform_log $"Install RPM ${libc6_rpm_file} of size ${SIZERPM} took ${DIFFRPM} sec"
        fi
    fi

    platform_log "Patch host config"
    cp /etc/init.d/calvados_bootstrap.cfg ${rootdir}/etc/init.d/calvados_bootstrap.cfg
    sed -i 's/VMTYPE=.*/VMTYPE=hostos/g' ${rootdir}/etc/init.d/calvados_bootstrap.cfg

    local plat_type=$(iofpga_reg_read 0 0x4)
    local data=$(echo ${plat_type} | cut -c3-3)
    # CSCvv00658/CSCvx13520 : Update the bootstrap with 2G RP memory for
    # OldCastle and OldcastleCR only
    if [ $data -eq 6 ] || [ $data -eq 9 ];
    then
        platform_log "updated SDR resources host ..."
        if [ ! -f /var/log/sdr_plat_supported.txt ]; then
            touch /var/log/sdr_plat_supported.txt
        fi
        sed -i -e "s;VIRT_RP_MEM=4097152;VIRT_RP_MEM=2097152;" ${rootdir}/etc/init.d/calvados_bootstrap.cfg
    fi

    sh /etc/init.d/flexr_symlink_cal.sh ${rootdir} 

    # Update init scripts
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} check-flash  start 8 2 3 4 5 . > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} cgroup-init  defaults 93  7 > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} nwbridge     defaults 95  1 > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} spirit       defaults 96  3 > /dev/null 2>&1
    mkdir -p ${rootdir}/etc/ld.so.conf.d
    cat > ${rootdir}/etc/ld.so.conf.d/hostos.conf <<%%
/opt/cisco/hostos/usr/lib64/
%%

    cat >> ${rootdir}/etc/sysctl.conf <<%%
net.core.rmem_max = 134217728
net.core.wmem_max = 67108864
net.core.rmem_default = 67108864
net.core.wmem_default = 67108864
net.core.netdev_max_backlog = 300000
net.core.optmem_max = 67108864
net.ipv4.udp_mem = 1124736     10000000  67108864
net.ipv4.udp_rmem_min = 1124736
net.ipv4.udp_wmem_min = 1124736
#
# Increased usage of ctrace facilities is skirting the default inotify watch
# limit of 8K on some platforms (with stress tests etc). Increase to future-proof.
# Should not increase any memory usage, as kernel does not pre-allocate.
# Also increase max_user_instances to 32K from 8K default.
#
fs.inotify.max_user_watches = 32768
fs.inotify.max_user_instances = 32768

vm.swappiness = 0
%%

    #make dir for lxc hooks and create symbolic link to the hook script
    mkdir -p ${rootdir}/etc/libvirt/hooks/
    ln -sf /etc/init.d/lxc_hook.sh ${rootdir}/etc/libvirt/hooks/lxc

    mkdir -p ${rootdir}/etc/profile.d
    cat > ${rootdir}/etc/profile.d/virsh.sh <<%%
export LIBVIRT_DEFAULT_URI=lxc:///
%%
    zermatt_host_cleanup ${rootdir}

    rm ${rootdir}/etc/rcS.d/S*udev
}

function xrnginstall_zermatt_patch_calvados {

    local rootdir="$1"
    local plat="$2"

    xrnginstall_zermatt_patch_common "$rootdir"
    #Alpesh: generate the 10-sim rule to rename eth1 on calvados
    #need this only for calvados and XR  (and not for host)
    mkdir -p ${rootdir}/lib/udev/rules.d/
    echo 'KERNEL=="eth1", NAME="eth-vf1"' > ${rootdir}/lib/udev/rules.d/10-sim.rules

    platform_log "Patch network"
    cat >${rootdir}/etc/rc.d/rc.local <<%%
touch /var/lock/subsys/local
ifconfig eth-vf0 10.11.12.15/24 up
route add 10.0.2.16 eth-vf0
%%
    chmod a+x ${rootdir}/etc/rc.d/rc.local
    platform_log_exec cat ${rootdir}/etc/rc.d/rc.local

    chroot ${rootdir} ln -sf ./rc.d/rc.local /etc/rc.local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc2.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc3.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc4.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc5.d/S98local

    mkdir -p ${rootdir}/etc/ld.so.conf.d
    if [ "${ARCH}" == "x86_64" ]; then
        cat > ${rootdir}/etc/ld.so.conf.d/calvados.conf <<%%
/opt/cisco/calvados/usr/lib64/
%%
    else
        cat > ${rootdir}/etc/ld.so.conf.d/calvados.conf <<%%
/opt/cisco/calvados/usr/lib/
%%
    fi
    mkdir -p ${rootdir}/etc/profile.d
    cat > ${rootdir}/etc/profile.d/sysadmin.sh <<%%
PATH=$PATH:/opt/cisco/calvados/bin/:/opt/cisco/calvados/sbin/
%%
    chmod +x ${rootdir}/etc/profile.d/sysadmin.sh

    platform_log "Patch calvados config"
    sed -i 's/VMTYPE=.*/VMTYPE=sysadmin-vm/g' ${rootdir}/etc/init.d/calvados_bootstrap.cfg
    local plat_type=$(iofpga_reg_read 0 4)
    num=$( printf "0x%x" $plat_type )
    data=$(($(( num >> 23 & 0x1 )) << 4 | $(( num >> 28 & 0xF ))))
    if [ $data -eq 23 ];
    then
        sed -i -e "s;VIRT_RP_MEM=4194304;VIRT_RP_MEM=1048576;" ${rootdir}/etc/init.d/calvados_bootstrap.cfg 
    fi 
    # CSCvv00658/CSCvx13520 : Update the bootstrap with 2G RP memory for
    # OldCastle and OldcastleCR only
    if [ $data -eq 6 ] || [ $data -eq 9 ];
    then
        platform_log "updated SDR resources sysadmin ..."
        if [ ! -f /var/log/sdr_plat_supported.txt ]; then
            touch /var/log/sdr_plat_supported.txt
        fi
        sed -i -e "s;VIRT_RP_MEM=4097152;VIRT_RP_MEM=2097152;" ${rootdir}/etc/init.d/calvados_bootstrap.cfg
    fi

    platform_log_exec cat ${rootdir}/etc/init.d/calvados_bootstrap.cfg

    platform_log "Set cmdline"
    echo "root=/dev/panini_vol_grp/calvados_lv0 platform=zermatt boardtype=${BOARDTYPE} vmtype=sysadmin-vm console=ttyS2 prod=1 crashkernel=0 bigphysarea=100M quiet clocksource=jiffies elevator=noop" > ${rootdir}/root/cmdline
 
    sh /etc/init.d/flexr_symlink_cal.sh ${rootdir} 

    # Update init scripts
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} check-flash  start 8 2 3 4 5 . > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} spirit defaults 96  3 > /dev/null 2>&1
    zermatt_lxc_cleanup ${rootdir}

    # Don't start udev if it is Linux 3.14 (WRL7) or later
    # WR7_SDK
    if [ $(printf %d%03d $(uname -r | sed 's/^\([0-9]*\)\.\([0-9]*\).*/\1 \2/')) -ge 3014 ]; then
        rm ${rootdir}/etc/rcS.d/S*udev
    fi
    
    echo "#Disable containers to sync system clock and hw clock" >> ${rootdir}/etc/default/rcS 
    echo "HWCLOCKACCESS=no" >> ${rootdir}/etc/default/rcS
}

function xrnginstall_zermatt_patch_remove_imcompatible_xr_files {
    local rootdir="$1"
    local filepath

    platform_log "$FUNCNAME"

    local ucs_imcompatible_xr_files=

    for filepath in ${ucs_imcompatible_xr_files[*]}; do
        rm ${rootdir}/${filepath}  >/dev/null 2>&1
    done
}

function xrnginstall_zermatt_patch_xr {

    local rootdir="$1"
    local plat="$2"
    local lcp_in_str=`grep -i LCP $rootdir/boot/grub/menu.lst`
    platform_log "$FUNCNAME"

    xrnginstall_zermatt_patch_common "$rootdir"

    # 
    # The igb driver supports all 82575, 82576, 82580, and I350-based 
    # gigabit network connections.
    #
    sed -i -e "s;.*igb$;;" \
        ${rootdir}/etc/modprobe.d/blacklist.conf
    #
    # enic enables the support for the Cisco VIC Ethernet card.
    #
    sed -i -e "s;.*enic.*;;" \
        ${rootdir}/etc/modprobe.d/blacklist.conf

    #Alpesh: generate the 10-sim rule to rename eth1 on calvados
    #need this only for calvados and XR  (and not for host)
    mkdir -p ${rootdir}/lib/udev/rules.d/
    echo 'KERNEL=="eth1", NAME="eth-vf1"' > ${rootdir}/lib/udev/rules.d/10-sim.rules

    platform_log "Patch network"
    if [ -n "$lcp_in_str" ]; then 
    cat >${rootdir}/etc/rc.d/rc.local <<%%
touch /var/lock/subsys/local
ifconfig eth-vf0 10.11.12.115/24 up
route add 10.0.2.16 eth-vf0
%%
    else
    cat >${rootdir}/etc/rc.d/rc.local <<%%
touch /var/lock/subsys/local
ifconfig eth-vf0 10.11.12.14/24 up
route add 10.0.2.16 eth-vf0
%%
    fi
    chmod a+x ${rootdir}/etc/rc.d/rc.local
    platform_log_exec cat ${rootdir}/etc/rc.d/rc.local

    chroot ${rootdir} ln -sf ./rc.d/rc.local /etc/rc.local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc2.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc3.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc4.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc5.d/S98local

    mkdir -p ${rootdir}/etc/ld.so.conf.d
    cat > ${rootdir}/etc/ld.so.conf.d/xr.ldso.conf <<%%
/pkg/lib/
%%

    platform_log "Patch XR config"
    cp /etc/init.d/calvados_bootstrap.cfg ${rootdir}/etc/init.d/calvados_bootstrap.cfg
    sed -i 's/VMTYPE=.*/VMTYPE=xr-vm/g' ${rootdir}/etc/init.d/calvados_bootstrap.cfg
    platform_log_exec cat ${rootdir}/etc/init.d/calvados_bootstrap.cfg

    platform_log "Set cmdline"
    if [ -n "$lcp_in_str" ]; then
    echo "root=/dev/panini_vol_grp/xr_lcp_lv0 platform=zermatt boardtype=LC vmtype=xr-vm prod=1 crashkernel=0 bigphysarea=200M quiet clocksource=jiffies elevator=noop" > ${rootdir}/root/cmdline
    else
    echo "root=/dev/panini_vol_grp/xr_lv0 platform=zermatt boardtype=${BOARDTYPE} vmtype=xr-vm prod=1 crashkernel=0 bigphysarea=200M quiet clocksource=jiffies elevator=noop" > ${rootdir}/root/cmdline
    fi

    sh /etc/init.d/flexr_symlink_xr.sh ${rootdir} ${BOARDTYPE} >& /dev/null

    # Update init scripts 
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} check-flash  start 8 2     3 4 5 . > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} spirit defaults 96 3 > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} -f lighttpd  remove > /dev/null 2>&1

    # Don't start udev if it is Linux 3.14 (WRL7) or later
    # WR7_SDK
    if [ $(printf %d%03d $(uname -r | sed 's/^\([0-9]*\)\.\([0-9]*\).*/\1 \2/')) -ge 3014 ]; then
        rm ${rootdir}/etc/rcS.d/S*udev
    fi
    echo "#Disable containers to sync system clock and hw clock" >> ${rootdir}/etc/default/rcS 
    echo "HWCLOCKACCESS=no" >> ${rootdir}/etc/default/rcS

    #
    # This is a temporary workaround until calvados supports second disk on
    # the same device.
    #
    if [ ! -e ${rootdir}/harddisk: ]; then
        if [ ! -d ${rootdir}/misc/disk1 ]; then
            platform_log_exec mkdir -p ${rootdir}/misc/disk1
            if [ $? -ne 0 ]; then
                platform_log_exec "Failed to create /misc/disk1"
            fi
        fi

        if [ -d ${rootdir}/misc/disk1 ]; then
            platform_log_exec ln -sf /misc/disk1 ${rootdir}/harddisk:
            if [ $? -ne 0 ]; then
                platform_log_exec "Failed to link /harddisk:"
            fi
        fi
    fi

    # Fix the paths for XR
    mkdir -p ${rootdir}/etc/profile.d
    cat >> ${rootdir}/etc/profile.d/xr.sh <<'%%'
if  [ "$(id -u)" -eq 0 ] ; then
    if [ -f /pkg/etc/xr_startup_envs.sh ]; then
        source /pkg/etc/xr_startup_envs.sh
    fi
    if [ -f /tmp/set_env_vars ]; then
        source /tmp/set_env_vars
    fi
    if [ -f /pkg/bin/dnx_diag_shell_alias ]; then
        source /pkg/bin/dnx_diag_shell_alias
    fi
fi
%%
    chmod +x ${rootdir}/etc/profile.d/xr.sh
}
