#!/bin/bash
#this script has usual console logging/file logging and redirect functions
#used by various pxe_install scripts.

function redirect_output
{
    local logfile
    logfile=$1
    exec 107> >( exec cat >> $logfile )
    redirect_output_pid=$!
    exec 105>&1
    exec 1> >( exec tee -a /dev/fd/107 )
    export LVM_SUPPRESS_FD_WARNINGS=1

    declare -F platform_redirect_output >&107 2>&1 && platform_redirect_output
}

function unredirect_output
{
    exec 1>&105-
    exec 107>&-
    if [ -n "$redirect_output_pid" ]; then
        kill -HUP $redirect_output_pid
        while [ -e /proc/$redirect_output_pid ]; do :; done
    fi
}


# Verbose output should always go to the file (for debug-ability)
function step_log_file {
    local log_msg=${1}
    local time_str=$(date)
    if [ "$PXEDEBUG" == "yes" ]; then
        echo "${time_str}: ${log_msg}"
    fi
    echo "${time_str}: ${log_msg}" >&107
    if [ $USE_FINAL -gt 0 ]; then
        sync
    fi
}
readonly -f step_log_file

function save_install_log {
    local dev=${1}

    mkdir -p /tmp/dvlog  >&107 2>&1
    mount ${dev} /tmp/dvlog >&107 2>&1
    cp $LOGDIR/$LOGFILE0 /tmp/dvlog/
    cp $LOGDIR2/$LOGFILE /tmp/dvlog/
    cp $LODFLOWDIR/$FLOWFILE /tmp/dvlog
    sync
    USE_FINAL=1
    unredirect_output
    redirect_output $LOGDIR2/$LOGFILE2
}

# Save up to 10 most recent bake logs
function close_install_log {
    cp $LOGDIR/$LOGFILE0 /tmp/dvlog/
    cp $LOGDIR2/$LOGFILE /tmp/dvlog/
    cp $LOGDIR2/$LOGFILE2 /tmp/dvlog/
    cp ${LOGFLOWDIR}/${LOGFLOWFILE} /tmp/dvlog/
    sync
    umount /tmp/dvlog >&107 2>&1
    if [ "$dpflag" != "TRUE" ]; then
       unredirect_output
       unlogflow
       return
    fi
    index=`cat ${LOGFLOWDIR}/index 2>&107`
    if [ -z "${index}" ]; then
       index=0
    fi 
    bakedir=${LOGFLOWDIR}/bake.${index}
    mkdir -p ${bakedir}
    rm -rf ${bakedir}/*
    cp -f /var/log/*.log ${bakedir}/ >&107 2>&1
    cp -f /tmp/calv_setup_ldpath.log ${bakedir}/ >&107 2>&1
    cp -rf /var/log/bootlogs/* ${bakedir}/ >&107 2>&1
    mv ${LOGFLOWDIR}/*.log ${bakedir}/
    tar cvfz ${bakedir}.tgz ./${bakedir} >&107 2>&1
    rm -rf ${bakedir}
    index=$((index + 1))
    if [ $index -eq 8 ]; then
       index=0
    fi
    echo "$index" > ${LOGFLOWDIR}/index
    sync
    unredirect_output
    unlogflow
    umount ${LOGFLOWDIR} >/dev/null 2>&1
    losetup -d ${dploop} >/dev/null 2>&1
} 
