#script to reset counters
#------------------------------------------------------------------
#
# Script to handle cflow clear for Calvados
#
# Vasu Arnepalli
# Copyright (c) 2012-2013, 2016, 2018-2019 by cisco Systems, Inc.
# All rights reserved.
#
#-------------------------------------------------------------------
#
FILENAME="/misc/scratch/cflow_reg_file"
DISK1_DIR="/misc/disk1/cflow"
CFLOW_DIR="/misc/scratch/cflow"
NAME=`cat /tmp/cflow_loc`
COV_LOG_DIR="$CFLOW_DIR/coverage_logs_$NAME.dat"
if [  -d "/misc/disk1" ]; then
  if [ ! -d $DISK1_DIR ]; then
    mkdir $DISK1_DIR
  fi
  if [ ! -d $CFLOW_DIR ]; then
    ln -s $DISK1_DIR /misc/scratch/
  fi
else    
  if [ ! -d $CFLOW_DIR ]; then
    mkdir $CFLOW_DIR
  fi
fi
if [ ! -d $COV_LOG_DIR ]; then
   mkdir $COV_LOG_DIR
fi
DUMPLOG="$COV_LOG_DIR/sent_signals.log"
touch $DUMPLOG
if [ -e $FILENAME ]; then
  if [ -s $FILENAME ]; then
     echo "Resetting coverage counters in memory to zeros"
     cat ${FILENAME} | while read procname pid
     do
          if [ -e $DUMPLOG ]; then
             timestamp=`date "+%Y%m%d%H%M%S"`
             echo "$timestamp : clean : $procname $pid : 57" >> $DUMPLOG
          fi
         echo -e ".\c"
         kill -57 $pid >/dev/null 2>/dev/null
     done
     sleep 2
     echo ""
     echo "[DONE...]"
  fi
else
  echo "[There is no Cflow data to be cleared...]" 
fi
