#!/bin/bash

#script to dump cflow coverage data
#------------------------------------------------------------------
#
# Script to handle cflow copy for Calvados
#
# Vasu Arnepalli
# Copyright (c) 2012-2013, 2016-2019 by cisco Systems, Inc.
# All rights reserved.
#
#-------------------------------------------------------------------

#
#create the file when autodump feature is turned on and delete it when off.
#the file presence is needed to distinguish autodump signal from other signals 
cflow_autodump="/misc/scratch/cflow_autodump"
dump_status=0

usage() {
  echo  "
Usage: $0 [options]

  options: autodump on  --> To turn automatic data dump ON
           autodump off --> To turn automatic data dump OFF
           -h           --> To display help

  All the options are optional
  When no option mentioned, the .dat files being saved into location                  
  /misc/scratch/cflow"
}

## shows help
if [ "$1" == "-h" ]; then
  usage
  exit 0
fi

##check for autodump on/off
if [ "$1" == "autodump" ]; then

  if [ "$2" == "on" ]; then
    ## if file not exist, create it
    if [ ! -f "$cflow_autodump" ]
    then
      touch $cflow_autodump
      echo "CFLOW_DUMP-02I> Autodump feature is ON"
      dump_status=1
    fi

  elif [ "$2" == "off" ]; then
    ## if file exist, delete it
    if [ -f "$cflow_autodump" ]
    then
      rm -f $cflow_autodump
      echo "CFLOW_DUMP-03I> Autodump feature is OFF"
      dump_status=1
    fi
  else
     echo "CFLOW_DUMP-01E> Incomplete option. Refer to help"
  fi
   
fi

## $# – Store count of command line arguments
## if there is no argumnet, then do manual dump
if [ $# -eq 0 ]; then
  ## if file does not exist, then only do manual dump
  if [ ! -f "$cflow_autodump" ]; then
      dump_status=1
  else
      echo "CFLOW_DUMP-04I> Autodump feature is ON"
  fi
fi


#send CFLOWSIG in case dump_status is 1
if [ $dump_status -eq 1 ]; then
  ## Read the REG file and send CFLOWSIG
  FILENAME="/misc/scratch/cflow_reg_file"
  DISK1_DIR="/misc/disk1/cflow"
  CFLOW_DIR="/misc/scratch/cflow"
  NAME=`cat /tmp/cflow_loc`
  COV_LOG_DIR="$CFLOW_DIR/coverage_logs_$NAME.dat"
  if [  -d "/misc/disk1" ]; then
    if [ ! -d $DISK1_DIR ]; then
      mkdir $DISK1_DIR
    fi
    if [ ! -d $CFLOW_DIR ]; then
      ln -s $DISK1_DIR /misc/scratch/
    fi
  else    
    if [ ! -d $CFLOW_DIR ]; then
      mkdir $CFLOW_DIR
    fi
  fi
  if [ ! -d $COV_LOG_DIR ]; then
     mkdir $COV_LOG_DIR
  fi
  DUMPLOG="$COV_LOG_DIR/sent_signals.log"
  touch $DUMPLOG
  if [ -e $FILENAME ]; then
     if [ -s $FILENAME ]; then
        echo "Dumping coverage data under directory /misc/scratch/cflow"
        cat ${FILENAME} | while read procname pid
        do
          if [ -e $DUMPLOG ]; then
             timestamp=`date "+%Y%m%d%H%M%S"`
             echo "$timestamp : dump : $procname $pid : 56" >> $DUMPLOG
          fi
          echo -e ".\c"
          kill -56 $pid >/dev/null 2>/dev/null
        done
        sleep 5
        echo ""
        echo "[DONE...]"
     fi
  else
    echo "[Cflow data collection failed...]"
    echo "[None of the instrumented processes are running in the system ]"
  fi
fi
