#!/bin/bash

# Copyright (c) 2012-2016, 2019 by cisco Systems, Inc.
# All rights reserved.
#
# This script creates symbolic links in /opt/cisco/calvados to
# files installed to /opt/cisco/calvados/packages/<pkgname>--<pkgver>.
# 
# It also creates a local calvados ldpath file.
#

. /etc/init.d/logflow
logflowall

readonly PARTMNT=$1
readonly UNSUPP_CARD="$2"
readonly INSTDB="${PARTMNT}/install/instdb/local"
readonly LDPATH_FILE="${INSTDB}/calvados_ldpath.txt"
readonly DB_CONVERT="/opt/cisco/calvados/bin/calvados_db_convert.sh"
readonly CARD_INST_FILE="$PARTMNT/root/card_instances.txt"

if [ -z $PARTMNT ]; then
   echo "Error! Partition mount parameter is empty."
   exit 1;
fi

if [ -z "${UNSUPP_CARD}" ]; then
   echo "Unsupported cards not provided. Go with rpm per card type per package."
   pkg_ver_chg=0 
else
   echo "Unsupported cards provided. Go with single rpm per package."
   pkg_ver_chg=1
fi

if [ ! -d $PARTMNT ]; then
   echo "Error! Partition mount location is not valid."
   exit 1;
fi

# CARD_INST_FILE holds the card and card instance information 
# in the form of: CARD_TYPE CARD_INSTANCE
# Extract the card instance information to be used for symlink creation.
CARD_INST=""
if [ -f $CARD_INST_FILE ]; then
    str=$(cat $CARD_INST_FILE)
    CARD_INST=$(echo $str | cut -d ' ' -f2)
    CARD_TYPE=$(echo $str | cut -d ' ' -f1)
fi

rm -f ${PARTMNT}/rpmdb/lib/rpm/__db*.*
rm -f ${PARTMNT}/var/lib/rpm/__db*.*

bootstrap_cfg="/etc/rc.d/init.d/calvados_bootstrap.cfg"
plat="$(grep "^[  ]*PLATFORM_EXT=" "$bootstrap_cfg" | cut -d'=' -f2)"

echo $(date) "Starting Calvados symlink and ldpath setup"
tool_version=1
tool_version=$(chroot ${PARTMNT} rpm --version | sed 's/^RPM version \([0-9]\+\.[0-9]\+\).*/\1/')
echo "Found RPM version $tool_version"

if [ $tool_version == "4.8" ]; then
    test -f $DB_CONVERT && \
    $DB_CONVERT $PARTMNT
fi

exception_files_str=""
PD_FILE="/etc/rc.d/init.d/spirit_pd.sh"
if [ -f "$PD_FILE" ]; then
    source "$PD_FILE"
    if [ "`type -t pd_get_ignore_file_list`" = 'function' ]; then
         exception_files_str=$(pd_get_ignore_file_list $CARD_INST)
    fi
fi    

chroot ${PARTMNT} rpm -qa --queryformat '[%{FILENAMES} %{FILEMODES:perms} \n]'\
    | awk -F"[;, \t]" -v mount="$PARTMNT" -v cards="$UNSUPP_CARD"             \
      -v pkg_ver="$pkg_ver_chg"                                               \
      -v instance="$CARD_INST" -v platform="$plat"                            \
      -v excfile="$exception_files_str" -v card_type="$CARD_TYPE"             \
      '$2 !~ /^d/ && $1 ~ /^\/opt\/cisco\/calvados\/packages/ {               \
          link_name = $1;                                                     \
        str="/opt/cisco/calvados";                                            \
          sub(/^\/opt\/cisco\/calvados\/packages\/[^\/]*/,                    \
                          str, link_name);                                    \
        if (pkg_ver == 1) {                                                   \
            valid_link = 1;                                                   \
            split(cards, unsupp);                                             \
            split(excfile, exceptionlist);                                    \
            split(instance, cards_inst);                                      \
            for (x in unsupp) {                                               \
                new_str[unsupp[x]]=str "/" unsupp[x];                         \
            }                                                                 \
            for (x in cards_inst) {                                           \
                new_str_inst[cards_inst[x]]=str "/instances/" cards_inst[x];  \
            }                                                                 \
            for (x in new_str) {                                              \
                if (match(link_name, new_str[x])) {                           \
                    valid_link = 0;                                           \
                    print "Ignored: " $1;                                     \
                    break;                                                    \
                }                                                             \
            }                                                                 \
            if (valid_link == 1) {                                            \
                sub(/^\/opt\/cisco\/calvados\/[^\/]*/,                        \
                      str, link_name);                                        \
                inst_prefix = str "/instances";                               \
                if (match(link_name, inst_prefix)) {                          \
                    for (x in new_str_inst) {                                 \
                        if (!match(link_name, new_str_inst[x])) {             \
                            valid_link = 0;                                   \
                            print "Ignored for card inst: " link_name;        \
                            print "card instance string was:" new_str_inst[x];\
                        }                                                     \
                        else {                                                \
                            print "Considered instance: " link_name;          \
                            valid_link = 1;                                   \
                            sub(new_str_inst[x], str, link_name);             \
                            break;                                            \
                        }                                                     \
                    }                                                         \
                }                                                             \
            }                                                                 \
        } else {                                                              \
            valid_link = 1;                                                   \
        }                                                                     \
        if (valid_link == 1) {                                                \
            for (x in exceptionlist) {                                        \
                if (match(link_name, exceptionlist[x]) ) {                    \
                    print "Ignored file for symlink: " link_name;             \
                    valid_link = 0;                                           \
                }                                                             \
            }                                                                 \
        }                                                                     \
        if (valid_link == 1) {                                                \
          link_name = mount link_name;                                        \
          dir_name = link_name;                                               \
          sub(/\/[^\/]*$/, "", dir_name);                                     \
          if (!system("[ ! -d " dir_name " ] && mkdir -p " dir_name " ;       \
                      ln -sf  " $1 " " link_name)) {                           \
                print "Accepted: " $1;                                        \
                link_count++;                                                 \
          }                                                                   \
        }                                                                     \
      } END{ print "Created " link_count " symlinks"}'


if [ ! -d $INSTDB ]; then
    mkdir -p $INSTDB
fi

echo "# Calvados Loadpath" > $LDPATH_FILE
echo "# Updated on $(date)" >> $LDPATH_FILE
echo "# Updated by $0 (initial boot)" >> $LDPATH_FILE

if [ "$pkg_ver_chg" -eq "1" ]; then
    GRP_OPT="-g sysadmin"
else
    GRP_OPT="-a"
fi

if [ "$pkg_ver_chg" -eq "1" ]; then
    pkgList=$(chroot ${PARTMNT} rpm -q ${GRP_OPT} --queryformat '%{NAME}-%{VERSION}-%{RELEASE} \n' |   \
               awk '{ pkg[NR]=$1} END{ for(i=NR;i>0;i--) {                        \
                             str = (i == NR) ? pkg[i] : ":" pkg[i]; printf(str)   \
                    } printf("\n") } ')
else
    pkgList=$(chroot ${PARTMNT} rpm -q ${GRP_OPT} --queryformat '%{NAME}-%{VERSION} \n' |   \
               awk '{ pkg[NR]=$1} END{ for(i=NR;i>0;i--) {                        \
                             str = (i == NR) ? pkg[i] : ":" pkg[i]; printf(str)   \
                    } printf("\n") } ')
fi

echo "" >> $LDPATH_FILE
echo $pkgList >> $LDPATH_FILE
rm -f ${PARTMNT}/rpmdb/lib/rpm/__db*.*
rm -f ${PARTMNT}/var/lib/rpm/__db*.*
echo $(date) "Finished Calvados symlink and ldpath setup"
