#!/bin/sh
#
# create_npu_pcie_inband.sh
# Copyright (c) 2020 by Cisco Systems, Inc.

#import common helpers
. /etc/init.d/mod_ins/module-load-functions
. /etc/init.d/spirit_pd.sh

MY_MOD_ID_HEX=`printf "%X" $(($(my_slot_id) - 1))`
create="$1"
pcie_bus="$2"
inband_name="$3"
inband_num=${inband_name//[^0-9]/}
mac_base="4e:41:50:00:$MY_MOD_ID_HEX:"
mac_last=$((inband_num + 0x11))

BCM_MTU=9728
PSINB_MTU=9702
VLAN_MTU=9698

SPP_VLAN=1538
#Add BFD vlan (Jisu)
OLP_VLAN=1570
BFD_VLAN=1554
TPA_VLAN=1794
SINGLE_ROUTER_VLAN=1778

echo -n  "$1 ps-inb interface $inband_name $pcie_bus bcm-$pcie_bus $inband_name.1538 $inband_name.1794 $inband_name.$SINGLE_ROUTER_VLAN"

check_inb_vlan_exist()
{
    if [ -d /sys/devices/virtual/net/$1 ]; then
        return 0
    fi
        return 1
}

# Inputs:
# $1 = vlan
add_vlan_to_inb_intf()
{
    vconfig add $inband_name $1
    set_vlan_priority_map $inband_name.$1
    /sbin/ifconfig $inband_name.$1 mtu $VLAN_MTU up
}

# Inputs:
# $1 = vlan
remove_vlan_from_inb_intf()
{
    vconfig rem $inband_name.$1
}

# Inputs:
# $1 = vlan
# $2 = bridge name
add_inb_vlan_to_bridge()
{
    brctl addif $2 $inband_name.$1
    bridge fdb add $full_mac dev $inband_name.$1 master temp
    bridge link set dev $inband_name.$1 flood off
}
boot_debug "inband shell script invoked"

if [ "$create" == "start" ]; then 

    boot_debug "inside create inband shell"
    full_mac=$(printf '%s%x' $mac_base $mac_last)
    python /usr/sbin/bcm-knet-init.py $create 0x$pcie_bus $inband_name 
    /sbin/ifconfig bcm-$pcie_bus mtu $BCM_MTU up
    /sbin/ifconfig $inband_name mtu $PSINB_MTU up

    add_vlan_to_inb_intf $SPP_VLAN
    add_inb_vlan_to_bridge $SPP_VLAN spp_br

    add_vlan_to_inb_intf $OLP_VLAN
    add_inb_vlan_to_bridge $OLP_VLAN olp_br

    add_vlan_to_inb_intf $BFD_VLAN
    add_inb_vlan_to_bridge $BFD_VLAN bfd_br

    add_vlan_to_inb_intf $TPA_VLAN
    add_inb_vlan_to_bridge $TPA_VLAN tpa_br

    add_vlan_to_inb_intf $SINGLE_ROUTER_VLAN
    add_inb_vlan_to_bridge $SINGLE_ROUTER_VLAN sr_br
else
    boot_debug "inside stop inband shell script"
    # why make decision based on SPP_VLAN existence only?
    # what about other vlans?
    check_inb_vlan_exist $inband_name.$SPP_VLAN
    if [ $? -ne 1 ]; then
        boot_debug "Removing Inband Vlan from shell script"
        remove_vlan_from_inb_intf $SPP_VLAN
        remove_vlan_from_inb_intf $OLP_VLAN
        remove_vlan_from_inb_intf $BFD_VLAN
        remove_vlan_from_inb_intf $TPA_VLAN
        remove_vlan_from_inb_intf $SINGLE_ROUTER_VLAN

        /sbin/ifconfig $inband_name down
        /sbin/ifconfig bcm-$pcie_bus down
        python /usr/sbin/bcm-knet-init.py $create 0x$pcie_bus $inband_name
    else 
        boot_debug "Inabnd Vlans already removed by LXC script"
    fi
fi
